<?php
/**
 * Add to wishlist button template
 *
 * @author YITH
 * @package YITH\Wishlist\Templates\AddToWishlist
 * @version 3.0.12
 */

/**
 * Template variables:
 *
 * @var $base_url string Current page url
 * @var $wishlist_url              string Url to wishlist page
 * @var $exists                    bool Whether current product is already in wishlist
 * @var $show_exists               bool Whether to show already in wishlist link on multi wishlist
 * @var $show_count                bool Whether to show count of times item was added to wishlist
 * @var $product_id                int Current product id
 * @var $parent_product_id         int Parent for current product
 * @var $product_type              string Current product type
 * @var $label                     string Button label
 * @var $browse_wishlist_text      string Browse wishlist text
 * @var $already_in_wishslist_text string Already in wishlist text
 * @var $product_added_text        string Product added text
 * @var $icon                      string Icon for Add to Wishlist button
 * @var $link_classes              string Classed for Add to Wishlist button
 * @var $available_multi_wishlist  bool Whether add to wishlist is available or not
 * @var $disable_wishlist          bool Whether wishlist is disabled or not
 * @var $template_part             string Template part
 * @var $container_classes         string Container classes
 */

if (!defined('YITH_WCWL')) {
    exit;
} // Exit if accessed directly

global $product;
?>
<a
        href="<?php echo esc_url(wp_nonce_url(add_query_arg('add_to_wishlist', $product_id, $base_url), 'add_to_wishlist')); ?>"
        class="<?php echo esc_attr($link_classes); ?>"
        data-product-id="<?php echo esc_attr($product_id); ?>"
        data-product-type="<?php echo esc_attr($product_type); ?>"
        data-original-product-id="<?php echo esc_attr($parent_product_id); ?>"
        data-title="<?php echo esc_attr(apply_filters('yith_wcwl_add_to_wishlist_title', $label)); ?>"
        rel="nofollow"
>
    <?php echo !empty($icon) ? $icon : ''; ?>
</a>
