<?php
/**
 * The template for displaying all single posts
 */

get_header();
$blog_single_is_banner = get_theme_mod('blog_single_is_banner', 1);
if(defined('FW')):
    $blog_si_is_settings = fw_get_db_post_option(get_the_ID(), 'blog_si_is_settings', 2);
    $blog_si_is_banner = fw_get_db_post_option(get_the_ID(), 'blog_si_is_banner', 1);
    $blog_single_is_banner = ($blog_si_is_settings == 1 && $blog_si_is_banner > 0 ? $blog_si_is_banner : $blog_single_is_banner);
endif;
if($blog_single_is_banner == 1):
    get_template_part( 'template-parts/header/blog-single', 'header' );
endif;

if(function_exists('bepro_post_view_count')){
    bepro_post_view_count(get_the_ID());
}

$blog_single_sidebar = get_theme_mod('blog_single_sidebar', 3);
$blog_single_is_author = get_theme_mod('blog_single_is_author', 1);
$blog_single_is_tag = get_theme_mod('blog_single_is_tag', 1);
$blog_single_is_share = get_theme_mod('blog_single_is_share', 2);
$blog_single_socials = get_theme_mod('blog_single_socials', array(1, 2, 3, 4));
$blog_single_is_author_box = get_theme_mod('blog_single_is_author_box', 2);
$blog_is_related        = get_theme_mod('blog_is_related', 2);
$blog_related_title     = get_theme_mod('blog_related_title', esc_html__('Related News', 'bepro'));
$blog_rel_num_of_item   = get_theme_mod('blog_rel_num_of_item', 4);

if(defined('FW')):
    $blog_si_is_content_enable = fw_get_db_post_option(get_the_ID(), 'blog_si_is_content_enable', 2);
    if($blog_si_is_content_enable == 1):
        $blog_si_post_sidebar = fw_get_db_post_option(get_the_ID(), 'blog_si_post_sidebar', 3);
        $blog_si_is_author = fw_get_db_post_option(get_the_ID(), 'blog_si_is_author', 2);
        $blog_si_is_tag = fw_get_db_post_option(get_the_ID(), 'blog_si_is_tag', 1);
        $blog_si_is_share = fw_get_db_post_option(get_the_ID(), 'blog_si_is_share', 2);
        $blog_si_socials = fw_get_db_post_option(get_the_ID(), 'blog_si_socials', array());
        $blog_si_is_author_box = fw_get_db_post_option(get_the_ID(), 'blog_si_is_author_box', 2);
        $post_is_related = fw_get_db_post_option(get_the_ID(), 'post_is_related', 2);
        $post_related_title = fw_get_db_post_option(get_the_ID(), 'post_related_title', '');
        $post_rel_num_of_item = fw_get_db_post_option(get_the_ID(), 'post_rel_num_of_item', 4);
        
        
        $blog_single_sidebar = ($blog_si_post_sidebar > 0 ? $blog_si_post_sidebar : $blog_single_sidebar);
        $blog_single_is_author = ($blog_si_is_author > 0 ? $blog_si_is_author : $blog_single_is_author);
        $blog_single_is_tag = ($blog_si_is_tag > 0 ? $blog_si_is_tag : $blog_single_is_tag);
        $blog_single_is_share = ($blog_si_is_share > 0 ? $blog_si_is_share : $blog_single_is_share);
        if(!empty($blog_si_socials)):
            $blog_single_socials = array();
            foreach($blog_si_socials as $key => $val):
                $blog_single_socials[] = $key;
            endforeach;
        endif;
        $blog_single_is_author_box  = ($blog_si_is_author_box > 0 ? $blog_si_is_author_box : $blog_single_is_author_box);
        $blog_is_related            = ($post_is_related > 0 ? $post_is_related : $blog_is_related);
        $blog_related_title         = ($post_related_title != '' ? $post_related_title : $blog_related_title);
        $blog_rel_num_of_item       = ($post_rel_num_of_item > 0 ? $post_rel_num_of_item : $blog_rel_num_of_item);
    endif; 
endif;

$column  = ($blog_single_sidebar == 1 || !is_active_sidebar('sidebar-1') ? 'col-lg-12' : 'col-lg-8');


$terms = get_the_terms(get_the_ID(), 'category');
$cats  = '';
if (is_array($terms) && count($terms) > 0){
    $p = 1;
    $c = count($terms);
    foreach ($terms as $term) {
        if($p == $c){
            $cats .= '<a href="'.  get_category_link($term->term_id).'">'.$term->name.'</a>';
        }else{
            $cats .= '<a href="'.  get_category_link($term->term_id).'">'.$term->name.'</a>, ';
        }
        $p++;
    }
}

$dateFormat = (get_option('date_format') != '' ? get_option('date_format') : 'j M, Y');

$author_id = get_post_field ('post_author', get_the_ID());
$display_name = get_the_author_meta( 'display_name' , $author_id ); 

?>
<section class="singleBlog">
    <div class="container largeContainer">
        <div class="row">
            <div class="col-lg-12">
                <?php if(has_post_thumbnail()): ?>
                <div class="spThumb">
                    <img src="<?php echo bepro_post_thumbnail(get_the_ID(), 1218, 570); ?>" alt="<?php the_title_attribute() ?>">
                    <p class="bmeta"><i class="twi-clock1"></i><?php echo get_the_time($dateFormat); ?></p>
                </div>
                <?php endif; ?>
                <div class="spMeta <?php if($blog_single_is_author != 1): ?>noAu<?php endif; ?>">
                    <?php if($blog_single_is_author == 1): ?>
                    <div class="spAuthor">
                        <img src="<?php echo esc_url(bepro_get_author_avater_url(get_the_author_meta('ID'))); ?>" alt="<?php echo esc_attr(get_the_author()); ?>">
                        <p><?php echo esc_html__('Author', 'bepro'); ?><a href="<?php echo esc_url( get_author_posts_url($author_id ) ); ?>"><?php echo esc_html($display_name); ?></a></p>
                    </div>
                    <?php endif; ?>
                    <?php if(!has_post_thumbnail()): ?>
                    <div class="spsmeta ct">
                        <?php echo esc_html__('On:', 'bepro'); ?> <?php echo get_the_time($dateFormat); ?>
                    </div>
                    <?php endif; ?>
                    <?php if(!empty($cats)): ?>
                    <div class="spsmeta ct">
                        <?php echo esc_html__('In:', 'bepro'); ?> <?php echo bepro_kses($cats); ?>
                    </div>
                    <?php endif; ?>
                    <div class="spsmeta">
                        <?php echo comments_number( esc_html__('Comments:', 'bepro'), esc_html__('Comment:', 'bepro'), esc_html__('Comments:', 'bepro') ); ?>
                        <span><?php echo get_comments_number(); ?></span>
                    </div>
                </div>
            </div>
            <?php if(is_active_sidebar('sidebar-1') && $blog_single_sidebar == 2): ?>
                <div class="col-lg-4">
                    <div class="sidebar lsb">
                        <?php dynamic_sidebar('sidebar-1'); ?>
                    </div>
                </div>
            <?php endif; ?>
            <div class="<?php echo esc_attr($column); ?>">
                <?php while(have_posts()): the_post(); ?>
                <div class="sic_the_content clearfix">
                    <div class="clearfix"></div>
                    <?php
                        the_content();
                    ?>
                    <?php
                        $defaults = array(
                            'before'           => '<div class="PaginInner clearfix"><strong>' . esc_html__( 'Pages:', 'bepro' ).'</strong>',
                            'after'            => '</div>',
                            'link_before'      => '<span>',
                            'link_after'       => '</span>',
                            'next_or_number'   => 'number',
                            'separator'        => ' ',
                            'nextpagelink'     => '<i class="twi-arrow-left"></i>',
                            'previouspagelink' => '<i class="twi-arrow-right"></i>',
                            'pagelink'         => '%',
                            'echo'             => 1
                        );
                        wp_link_pages( $defaults );
                    ?>
                    <div class="clearfix"></div>
                </div>
                <?php endwhile; ?>
                <?php if(($blog_single_is_tag == 1 && has_tag()) || ($blog_single_is_share == 1 && !empty($blog_single_socials))): ?>
                <div class="postMeta clearfix">
                    <?php if($blog_single_is_tag == 1 && has_tag()): ?>
                    <div class="tags clearfix">
                        <h5><?php echo esc_html__('Tags:', 'bepro'); ?></h5>
                        <?php echo get_the_tag_list('', ', ', ''); ?>
                    </div>
                    <?php endif; ?>
                    <?php if($blog_single_is_share == 1 && !empty($blog_single_socials)): ?>
                    <div class="socialShare">
                        <h5><?php echo esc_html__('Share:', 'bepro'); ?></h5>
                        <?php
                            if(in_array(1, $blog_single_socials)){ echo '<a target="_blank" href="https://www.facebook.com/sharer.php?u='.get_the_permalink().'&title='.esc_url(get_the_title()).'"><i class="twi-facebook-f"></i></a>'; }
                            if(in_array(2, $blog_single_socials)){ echo '<a target="_blank" href="https://twitter.com/intent/tweet?url='.get_the_permalink().'&text='.esc_url(get_the_title()).'"><i class="twi-twitter"></i></a>'; }
                            if(in_array(3, $blog_single_socials)){ echo '<a target="_blank" href="mailto:?subject='.get_the_permalink().'"><i class="twi-envelope"></i></a>'; }
                            if(in_array(4, $blog_single_socials)){ echo '<a target="_blank" href="https://www.linkedin.com/shareArticle?mini=true&url='.get_the_permalink().'&title='.esc_url(get_the_title()).'"><i class="twi-linkedin-in"></i></a>'; }
                            if(in_array(5, $blog_single_socials)){ echo '<a target="_blank" href="https://pinterest.com/pin/create/bookmarklet/?media='.get_the_post_thumbnail_url(get_the_ID(), 'full').'&url='.get_the_permalink().'&is_video=false&description='.esc_url(get_the_title()).'"><i class="twi-pinterest-p"></i></a>'; }
                            if(in_array(6, $blog_single_socials)){ echo '<a target="_blank" href="https://api.whatsapp.com/send?text='.get_the_permalink().'"><i class="twi-whatsapp"></i></a>'; }
                            if(in_array(7, $blog_single_socials)){ echo '<a target="_blank" href="https://digg.com/submit?url='.get_the_permalink().'&title='.esc_url(get_the_title()).'"><i class="twi-digg"></i></a>'; }
                            if(in_array(8, $blog_single_socials)){ echo '<a target="_blank" href="https://www.tumblr.com/widgets/share/tool?canonicalUrl='.get_the_permalink().'&title='.esc_url(get_the_title()).'"><i class="twi-tumblr"></i></a>'; }
                            if(in_array(9, $blog_single_socials)){ echo '<a target="_blank" href="https://reddit.com/submit?url='.get_the_permalink().'&title='.esc_url(get_the_title()).'"><i class="twi-reddit-alien"></i></a>'; }
                        ?>
                    </div>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
                <?php if($blog_single_is_author_box == 1): ?>
                <div class="post_author clearfix">
                    <img src="<?php echo bepro_get_author_avater_url(get_the_author_meta('ID'), 100, 100) ?>" alt="<?php echo esc_attr(get_the_author()); ?>"/>
                    <h5><a href="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>"><?php echo get_the_author(); ?></a></h5>
                    <?php if(get_the_author_meta('description') != ''): ?>
                        <p>
                            <?php echo wp_strip_all_tags(get_the_author_meta('description')); ?>
                        </p>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
                <?php if ( comments_open() || get_comments_number() ): ?>
                    <div class="comment_area">
                        <?php comments_template(); ?>
                    </div>
                <?php endif; ?>
            </div>
            <?php if(is_active_sidebar('sidebar-1') && $blog_single_sidebar == 3): ?>
                <div class="col-lg-4">
                    <div class="sidebar">
                        <?php dynamic_sidebar('sidebar-1'); ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</section>
<?php 
    $single_blog_bloks = get_theme_mod('blog_single_bloks', '');
    if(!empty($single_blog_bloks)){
        foreach($single_blog_bloks as $sb):
            if($sb['block_ids'] != '' && $sb['block_ids'] != 'none'):
                if (class_exists('TW_Assistance')) {
                    Tw_Builder::render_template($sb['block_ids']);
                }
            endif;
        endforeach;
    }
get_footer();