<?php
/**
 * index.php
 *
 * The main template file.
 */
get_header();
$blog_page_ID = get_option('page_for_posts', true);

$blog_is_banner  = get_theme_mod('blog_is_banner', 1);
$blog_sidebar    = get_theme_mod('blog_sidebar', 3);
$blog_view       = get_theme_mod('blog_view', 1);

if(defined('FW') && $blog_page_ID > 0):
    $page_is_settings = fw_get_db_post_option($blog_page_ID, 'page_is_settings', 2);
    $page_is_banner   = fw_get_db_post_option($blog_page_ID, 'page_is_banner', 1);
    $blog_is_banner   = ($page_is_settings == 1 && $page_is_banner > 0 ? $page_is_banner : $blog_is_banner);
endif;

if($blog_is_banner == 1):
    get_template_part('template-parts/header/blog', 'header');
endif;

$area_class     = ($blog_sidebar == 1  || !is_active_sidebar('sidebar-1') ? 'col-lg-12' : 'col-lg-8');
$blog_sidebar   = ($blog_sidebar == 1  || !is_active_sidebar('sidebar-1') ? '1' : $blog_sidebar);

$area_class     = ($blog_view == 2 || $blog_view == 3 ? 'col-lg-12' : $area_class);
$blog_sidebar   = ($blog_view == 2 || $blog_view == 3 ? '1' : $blog_sidebar);

?>
<section class="blogPage <?php if(is_active_sidebar('sidebar-1') && $blog_sidebar == 3): ?>bpsRight <?php endif; ?>">
    <div class="container largeContainer">
        <div class="row">
            <?php if(is_active_sidebar('sidebar-1') && $blog_sidebar == 2): ?>
                <div class="col-lg-4">
                    <div class="sidebar lsb">
                        <?php dynamic_sidebar('sidebar-1'); ?>
                    </div>
                </div>
            <?php endif; ?>
                <div class="<?php echo esc_attr($area_class); ?>">
                    <div class="row <?php if($blog_sidebar == 1): ?>justify-content-center<?php endif; ?>">
                        <?php
                            while(have_posts()):
                                the_post();
                                get_template_part('template-parts/post/content');
                            endwhile;
                        ?>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="bepro_pagination">
                                <?php
                                    the_posts_pagination(
                                        array(
                                            'prev_text'          => bepro_kses('<i class="twi-angle-left"></i>').'<span>'.esc_html__( 'Prev Page', 'bepro').'</span>',
                                            'next_text'          => '<span>'.esc_html__('Next Page', 'bepro').'</span>'.bepro_kses('<i class="twi-angle-right"></i>'),
                                            'before_page_number' => '',
                                            'type'               => 'array'
                                        )
                                    );
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php if(is_active_sidebar('sidebar-1') && $blog_sidebar == 3): ?>
                <div class="col-lg-4">
                    <div class="sidebar">
                        <?php dynamic_sidebar('sidebar-1'); ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</section>
<?php
    $blog_bloks = get_theme_mod('blog_bloks', '');
    if(!empty($blog_bloks)){
        foreach($blog_bloks as $sb):
            if($sb['block_ids'] != '' && $sb['block_ids'] != 'none'):
                if (class_exists('TW_Assistance')) {
                    Tw_Builder::render_template($sb['block_ids']);
                }
            endif;
        endforeach;
    }
get_footer();
