<?php
/* 
 * ThemeWar Hooks Class
 */

class Bepro_Hooks_Class
{

    public static $_instance;

    public function __construct()
    {
        $this->bepro_init();
    }

    /* * ---------------------------------------------------------------
    * Init all hooks and others
    * -------------------------------------------------------------* */

    public function bepro_init()
    {
        add_action('after_setup_theme', array($this, 'bepro_theme_setup'));
        add_action('widgets_init', array($this, 'bepro_widgets_init'));
        
        add_action('wp_enqueue_scripts', array($this, 'bepro_enqueue_style'));
        add_action('wp_enqueue_scripts', array($this, 'bepro_enqueue_script'));
        add_action('admin_enqueue_scripts', array($this, 'bepro_enqueue_style_for_admin'));
        
        add_action('tgmpa_register', array($this, 'bepro_plugin_activation_notive'));
        add_action('admin_menu', array($this,'bepro_remove_theme_settings'),999 );
        add_action('wp_enqueue_scripts', array($this, 'bepro_dequeue_dashicon'));

        add_action('wp_ajax_nopriv_post_like', array($this, 'bepro_ajax_post_like'));
        add_action('wp_ajax_post_like', array($this, 'bepro_ajax_post_like'));
        
        add_filter('fw:option_type:icon-v2:packs', array($this, 'bepro_icon_pack'));
        
        add_action( 'admin_init', array($this, 'bepro_hide_front_page_editor') );

        add_filter( 'comment_form_fields', array($this, 'bepro_rearrange_comment_form') );

        add_filter( 'loop_shop_per_page', array($this, 'bepro_loop_shop_per_page'), 20 );
        add_filter( 'woocommerce_checkout_fields' , array($this, 'bepro_custom_wc_checkout_fields') );
        
        add_filter('woocommerce_add_to_cart_fragments', array($this, 'bepro_cart_button_item_count'));
        
        add_filter( 'body_class', array($this, 'bepro_body_classes') );
        add_filter('fw:ext:backups-demo:demos', array($this, 'bepro_live_demos'));
    }
    
    public function bepro_body_classes($classes){
        $header_style = get_theme_mod('header_style', 1);
        $classes[] = 'active_header_'.$header_style;
        return $classes;
    }
    
    public function bepro_icon_pack($default_packs){
        return array(
                'bepro_flaticon' => array(
                        'name'                  => 'bepro_flaticon',
                        'title'                 => esc_html__('Flaticon for Bepro', 'bepro'),
                        'css_class_prefix'      => '',
                        'css_file'              => BEPRO_ASSETS_CSS_DIR.'/bepro-icon.css',
                        'css_file_uri'          => BEPRO_ASSETS_CSS_URL.'/bepro-icon.css'
                ),
                'bepro_fontawsome' => array(
                        'name'                  => 'bepro_fontawsome',
                        'title'                 => esc_html__('Fontawsome for Bepro', 'bepro'),
                        'css_class_prefix'      => '',
                        'css_file'              => BEPRO_ASSETS_CSS_DIR.'/fontawsome.css',
                        'css_file_uri'          => BEPRO_ASSETS_CSS_URL.'/fontawsome.css'
                ),
        );
    }

    /* * ---------------------------------------------------------------
    * Theme Setup
    * -------------------------------------------------------------* */

    public function bepro_theme_setup(){
        load_theme_textdomain('bepro', get_template_directory() . '/languages');
        $GLOBALS['content_width'] = 1170;

        add_theme_support('automatic-feed-links');
        add_theme_support('post-thumbnails');
        set_post_thumbnail_size(755, 420, true);

        add_theme_support('title-tag');

        register_nav_menu('primary-menu', esc_html__('Primary Menu', 'bepro'));
        register_nav_menu('primary-popup-menu', esc_html__('Primary Popup Menu', 'bepro'));
        register_nav_menu('primary-sidebar-menu', esc_html__('Primary Sidebar Menu', 'bepro'));

        add_theme_support('html5', array('search-form', 'comment-form', 'comment-list', 'script', 'style'));
        add_theme_support( 'post-formats', array('audio', 'video', 'gallery') );

        add_theme_support('woocommerce');
    }

    /* * ---------------------------------------------------------------
    * Widget Init
    * -------------------------------------------------------------* */
    public function bepro_widgets_init(){

        bepro_register_sidebars(
            array(
                'sidebar-1'         => array(
                    'name'          => esc_html__('Blog Sidebar', 'bepro'),
                    'description'   => esc_html__('Blog sidebar, Only for blog pages.', 'bepro')
                ),
                'sidebar-2'         => array(
                    'name'          => esc_html__('Page Sidebar', 'bepro'), 
                    'description'   => esc_html__('Page sidebar, Only for pages.', 'bepro')
                ),
                'sidebar-3'         => array(
                    'name'          => esc_html__('Shop Sidebar', 'bepro'), 
                    'description'   => esc_html__('Shop Sidebar, Only For Shop Related Pages.', 'bepro')
                ),
            ),

            array(
                'before_widget' => '<aside id="%1$s" class="widget %2$s">',
                'after_widget'  => "</aside>",
                'before_title'  => '<h3 class="widget_title">',
                'after_title'   => '</h3>',
            ));

    }

    /* * ---------------------------------------------------------------
    * CSS Enqueue
    * -------------------------------------------------------------* */
    public function bepro_enqueue_style(){
        wp_enqueue_style('bepro-google-fonts', bepro_google_fonts_url());
        wp_enqueue_style('bepro-style', get_stylesheet_uri());
        
        wp_enqueue_style('bootstrap', get_template_directory_uri().'/assets/css/bootstrap.css');
        if(defined('FW')):
            fw()->backend->option_type('icon-v2')->packs_loader->enqueue_frontend_css();
        else:
            wp_enqueue_style('bepro-icon', get_template_directory_uri().'/assets/css/bepro-icon.css');
            wp_enqueue_style('fontawsome', get_template_directory_uri().'/assets/css/fontawsome.css');
        endif;
        
        wp_enqueue_style('owl-theme-default', get_template_directory_uri().'/assets/css/owl.theme.default.min.css');
        wp_enqueue_style('owl-carousel', get_template_directory_uri().'/assets/css/owl.carousel.min.css');
        wp_enqueue_style('animate', get_template_directory_uri().'/assets/css/animate.css');
        wp_enqueue_style('nice-select', get_template_directory_uri().'/assets/css/nice-select.css');
        wp_enqueue_style('slick', get_template_directory_uri().'/assets/css/slick.css');
        wp_enqueue_style('lightslider', get_template_directory_uri().'/assets/css/lightslider.css');
        wp_enqueue_style('lightcase', get_template_directory_uri().'/assets/css/lightcase.css');
        wp_enqueue_style('jquery-mCustomScrollbar', get_template_directory_uri().'/assets/css/jquery.mCustomScrollbar.css');
        wp_enqueue_style('bepro-preset', get_template_directory_uri().'/assets/css/preset.css');
        wp_enqueue_style('bepro-theme', get_template_directory_uri().'/assets/css/theme.css');
        wp_enqueue_style('bepro-responsive', get_template_directory_uri().'/assets/css/responsive.css');
        wp_enqueue_style('bepro-preloader', get_template_directory_uri().'/assets/css/preloader.css');
    }
    
    public function bepro_enqueue_style_for_admin(){
        wp_enqueue_style('bepro-admin-styles', get_template_directory_uri().'/assets/css/themewar-admin-style.css');
    }

    /* * -----------------------------------------------------------
    * JS Enqueue
    * -------------------------------------------------------------* */
    public function bepro_enqueue_script(){
        if (is_singular() && comments_open() && get_option('thread_comments')) {
            wp_enqueue_script('comment-reply');
        }
        wp_enqueue_script('masonry');
        if(class_exists('woocommerce')){
            wp_enqueue_script( 'wc-add-to-cart-variation' );
        }
        wp_enqueue_script('masonry');
        wp_enqueue_script('bootstrap', get_template_directory_uri().'/assets/js/bootstrap.min.js', array('jquery'), '', TRUE);
        wp_enqueue_script('owl-carousel', get_template_directory_uri().'/assets/js/owl.carousel.min.js', array('bootstrap'), '', TRUE);
        wp_enqueue_script('circle-progress', get_template_directory_uri().'/assets/js/circle-progress.js', array('owl-carousel'), '', TRUE);
        wp_enqueue_script('jquery-appear', get_template_directory_uri().'/assets/js/jquery.appear.js', array('circle-progress'), '', TRUE);
        wp_enqueue_script('shuffle', get_template_directory_uri().'/assets/js/shuffle.min.js', array('jquery-appear'), '', TRUE);
        wp_enqueue_script('lightslider', get_template_directory_uri().'/assets/js/lightslider.min.js', array('shuffle'), '', TRUE);
        wp_enqueue_script('tweenmax', get_template_directory_uri().'/assets/js/tweenmax.min.js', array('lightslider'), '', TRUE);
        wp_enqueue_script('nice-select', get_template_directory_uri().'/assets/js/nice-select.js', array('tweenmax'), '', TRUE);
        wp_enqueue_script('slick', get_template_directory_uri().'/assets/js/slick.js', array('nice-select'), '', TRUE);
        wp_enqueue_script('lightcase', get_template_directory_uri().'/assets/js/lightcase.js', array('slick'), '', TRUE);
        wp_enqueue_script('jquery-mCustomScrollbar', get_template_directory_uri().'/assets/js/jquery.mCustomScrollbar.js', array('lightcase'), '', TRUE);
        wp_enqueue_script('bepro-theme', get_template_directory_uri().'/assets/js/theme.js', array('jquery-mCustomScrollbar'), '', TRUE);
        $params = array(
            'ajaxurl' => admin_url('admin-ajax.php'),
            'ajax_nonce' => wp_create_nonce('bepro_security_check'),
        );
        wp_localize_script('bepro-theme', 'bepro_object', $params);
    }
    
    public function bepro_remove_theme_settings() {
        remove_submenu_page( 'themes.php', 'fw-settings' );
    }

    function bepro_dequeue_dashicon() {
        if (current_user_can( 'update_core' )) {
            return;
        }
        wp_deregister_style('dashicons');
    }

    /* * ---------------------------------------------------------------
    * TGMPA Activator
    * -------------------------------------------------------------* */

    public function bepro_plugin_activation_notive(){
        $plugins = array(
            array(
                'name'		 => esc_html__( 'Unyson', 'bepro' ),
                'slug'		 => 'unyson',
                'required'	 => true,
            ),
            array(
                'name'		 => esc_html__( 'Elementor', 'bepro' ),
                'slug'		 => 'elementor',
                'required'	 => true,
            ),
            array(
                'name'		 => esc_html__( 'Kirki', 'bepro' ),
                'slug'		 => 'kirki',
                'required'	 => true,
            ),
            array(
                'name'               => esc_html__('Bepro Assistance', 'bepro'),
                'slug'		         => 'bepro-assistance',
                'required'	         => true,
                'source'	         => 'http://themewar.com/plugins/bepro-assistance.zip' ,
                'version'            => '',
                'force_activation'   => false,
                'force_deactivation' => false,
                'external_url'       => '',
            ),
            array(
                'name'               => esc_html__('Revolution Slider', 'bepro'),
                'slug'		         => 'revslider',
                'required'	         => true,
                'source'	         => 'http://themewar.com/plugins/revslider.zip' ,
                'version'            => '',
                'force_activation'   => false,
                'force_deactivation' => false,
                'external_url'       => '',
            ),
            array(
                'name'       => esc_html__('Contact Form 7', 'bepro'),
                'slug'       => 'contact-form-7',
                'required'   => TRUE,
            ),
            array(
                'name'      => esc_html__('Easy Mailchimp', 'bepro'),
                'slug'      => 'yikes-inc-easy-mailchimp-extender',
                'required'  => false,
            ),
            array(
                'name'      => esc_html__('WooCommerce', 'bepro'),
                'slug'      => 'woocommerce',
                'required'  => false,
            ),
            array(
                'name'      => esc_html__('YITH WooCommerce Wishlist', 'bepro'),
                'slug'      => 'yith-woocommerce-wishlist',
                'required'  => false,
            ),
            array(
                'name'      => esc_html__('Max Mega Menu', 'bepro'),
                'slug'      => 'megamenu',
                'required'  => false,
            ),
        );

        $config = array(
            'id'            => 'bepro',
            'default_path'  => '',
            'menu'          => 'tgmpa-install-plugins',
            'has_notices'   => true,
            'dismissable'   => true,
            'dismiss_msg'   => '',
            'is_automatic'  => false,
            'message'       => '',
        );

        tgmpa($plugins, $config);
    }

    /* * ---------------------------------------------------------------
    * Post Like Submit
    * -------------------------------------------------------------* */
    public function bepro_ajax_post_like(){
        $pid = $_POST['pid'];
        $like = get_post_meta($pid, '_bepro_post_like', true);
        $like = ( empty($like) ) ? 0 : $like;
        $like++;
        update_post_meta($pid, '_bepro_post_like', $like);
        echo bepro_kses($like);
        wp_die();
    }

    /* * ---------------------------------------------------------------
    * Create Instance
    * -------------------------------------------------------------* */
    public static function bepro_instance(){
        if (!isset(self::$_instance)) {
            self::$_instance = new Bepro_Hooks_Class();
        }
        return self::$_instance;

    }
    
    /* * ---------------------------------------------------------------
    * Hide Front Page Editor
    * -------------------------------------------------------------* */
    function bepro_hide_front_page_editor() {
        $post_id = (isset($_GET['post'])) ? $_GET['post'] : '' ;
        if( $post_id < 1 ) return;

        $template_file = get_post_meta($post_id, '_wp_page_template', true);

        if($template_file == 'page-templates/front-page.php'){ 
            remove_post_type_support('page', 'editor');
        }
    }

    /* * ---------------------------------------------------------------
    * Re Arange Comment Form
    * -------------------------------------------------------------* */
    function bepro_rearrange_comment_form( $fields ) {
        global $post;
        $postID = (isset($post->ID) && $post->ID > 0 ? $post->ID : 0);
        $post_type = get_post_type($postID);
        if($post_type && $post_type != 'product'):
            $comment_field              = $fields[ 'comment' ];
            unset( $fields[ 'comment' ] );
            $fields[ 'comment' ]        = $comment_field;
            return $fields;
        else:
            return $fields;
        endif;
    }

    public function bepro_loop_shop_per_page( $cols ) {
        $shop_numof_product = get_theme_mod('shop_numof_product', 8);
        $cols = $shop_numof_product;
        return $cols;
    }
    
    function bepro_custom_wc_checkout_fields( $fields ){
        foreach ($fields as $category => $value) {
            foreach ($fields[$category] as $field => $property) {
                $fields[$category][$field]['label'] = '';
                $placeholder = (isset($property['placeholder']) && $property['placeholder'] != '' ? $property['placeholder'] : $property['label']);
                $placeholder .= (isset($property['required']) && $property['required'] == 1 ? ' *' : '');
                $fields[$category][$field]['placeholder'] = $placeholder;
            }
        }
        
        return $fields;
    }
    
    public function bepro_cart_button_item_count( $fragments ) {
        global $woocommerce;
        ob_start();
        ?>
        <a class="cartBtn bepro_aj_cart" href="javascript:void(0);"><i class="twi-shopping-bag1"></i><span><?php echo sprintf(_n('%d', '%d', $woocommerce->cart->cart_contents_count, 'bepro'), $woocommerce->cart->cart_contents_count);?></span>
        <?php
        $fragments['a.bepro_aj_cart'] = ob_get_clean();
        return $fragments;
    }
    
    public function bepro_live_demos($demos){
        $demos_array = array(
            'bepro-live-demo' => array(
                'title'          => esc_html__('Bepro Live Img Dummy', 'bepro'),
                'screenshot'     => get_template_directory_uri().'/screenshot.png',
                'preview_link'   => 'http://themewar.com/wp/bepro',
            ),
        );

        $download_url = 'http://themewar.com/wp/bepro_dummy_data/';

        foreach ($demos_array as $id => $data) {
            $demo = new FW_Ext_Backups_Demo($id, 'piecemeal', array(
                'url' => $download_url,
                'file_id' => $id,
            ));
            $demo->set_title($data['title']);
            $demo->set_screenshot($data['screenshot']);
            $demo->set_preview_link($data['preview_link']);

            $demos[ $demo->get_id() ] = $demo;

            unset($demo);
        }

        return $demos;
    }
    
}

$bepro_instance = Bepro_Hooks_Class::Bepro_instance();