<?php

if ( !defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$all_header = array(
    '0' => esc_html__('Default Header', 'bepro')
);
global $wpdb; 
$table = $wpdb->prefix.'posts';

$sql = $wpdb->prepare("SELECT * FROM $table WHERE post_type = %s and post_status = %s order by post_title ASC", array('tw-header-builder', 'publish'));
$results = $wpdb->get_results($sql, ARRAY_A);

if(!empty($results)):
    foreach ($results as $rs):
        $all_header[$rs['ID']] = $rs['post_title'];
    endforeach;
endif;

$all_footer = array(
    '0' => esc_html__('Default Footer', 'bepro')
);
global $wpdb; 
$table = $wpdb->prefix.'posts';

$sql = $wpdb->prepare("SELECT * FROM $table WHERE post_type = %s and post_status = %s order by post_title ASC", array('tw-footer-builder', 'publish'));
$results = $wpdb->get_results($sql, ARRAY_A);

if(!empty($results)):
    foreach ($results as $rs):
        $all_footer[$rs['ID']] = $rs['post_title'];
    endforeach;
endif;

$options = array(
	'mains' => array(
		'title'   => esc_html__( 'Page Settings Box', 'bepro' ),
		'type'    => 'box',
		'options' => array(
                        'pageheadersettings' => array(
                                'title'   => esc_html__( 'Custom Header Settings', 'bepro' ),
                                'type'    => 'tab',
                                'options' => array(
                                        'page_header_enabled'     => array(
                                                'type'  => 'switch',
                                                'value' => '2',
                                                'label' => esc_html__('Enable Setting', 'bepro'),
                                                'desc'  => esc_html__('Do you want to enable custom header settings for this page?', 'bepro'),
                                                'right-choice' => array(
                                                    'value' => '1',
                                                    'label' => esc_html__('Yes', 'bepro'),
                                                ),
                                                'left-choice' => array(
                                                    'value' => '2',
                                                    'label' => esc_html__('No', 'bepro'),
                                                ),
                                        ),
                                        'page_header_style'         => array(
                                                'type'    => 'select',
                                                'value'   => '0',
                                                'label'   => esc_html__('Select Header Style', 'bepro'),
                                                'desc'    => esc_html__('Select page header for this page.', 'bepro'),
                                                'choices' => $all_header
                                        ),
                                )
                        ),
                        'footersettings'  => array(
                                'title'   => esc_html__( 'Custom Footer Settings', 'bepro' ),
                                'type'    => 'tab',
                                'options' => array(
                                    'page_footer_enabled'   => array(
                                            'type'          => 'switch',
                                            'value'         => '2',
                                            'label'         => esc_html__('Enable Setting', 'bepro'),
                                            'desc'          => esc_html__('Do you want to enable custom footer settings for this page?', 'bepro'),
                                            'right-choice'  => array(
                                                'value'     => '1',
                                                'label'     => esc_html__('Yes', 'bepro'),
                                            ),
                                            'left-choice'   => array(
                                                'value'     => '2',
                                                'label'     => esc_html__('No', 'bepro'),
                                            ),
                                    ),
                                    'page_footer_style' => array(
                                            'label'     => esc_html__( 'Select Footer Style', 'bepro' ),
                                            'type'      => 'select',
                                            'value'     => '0',
                                            'choices'   => $all_footer
                                    ),
                            ),
                        ),
                        'bannersettings' => array(
                                'title'   => esc_html__( 'Banner Settings', 'bepro' ),
                                'type'    => 'tab',
                                'options' => array(
                                        'page_is_settings'                    => array(
                                                'label'        => esc_html__( 'Enable Settings', 'bepro' ),
                                                'type'         => 'switch',
                                                'right-choice' => array(
                                                        'value' => '1',
                                                        'label' => esc_html__( 'Yes', 'bepro' )
                                                ),
                                                'left-choice'  => array(
                                                        'value' => '2',
                                                        'label' => esc_html__( 'No', 'bepro' )
                                                ),
                                                'value'        => '2',
                                                'desc'         => esc_html__('Enable bellow settings for this page banner.', 'bepro'),
                                        ),
                                        'page_is_banner'                    => array(
                                                'label'        => esc_html__( 'Is Banner', 'bepro' ),
                                                'type'         => 'switch',
                                                'right-choice' => array(
                                                        'value' => '1',
                                                        'label' => esc_html__( 'Show', 'bepro' )
                                                ),
                                                'left-choice'  => array(
                                                        'value' => '2',
                                                        'label' => esc_html__( 'Hide', 'bepro' )
                                                ),
                                                'value'        => '1',
                                                'desc'         => esc_html__('Do you want to hide banner only for this page? Then please turn it to Hide.', 'bepro'),
                                        ),
                                        'page_banner_bg' => array(
                                                'type'	 => 'upload',
                                                'label'	 => esc_html__( 'Banner BG IMG', 'bepro' ),
                                                'desc'	 => esc_html__( 'Upload your page banner bg image and this only work for dark version.', 'bepro' ),
                                        ),
                                        'page_banner_bg_color'	=> array(
                                                'type'          => 'rgba-color-picker',
                                                'value'         => '',
                                                'palettes'      => array(),
                                                'label'         => esc_html__('Banner BG Color', 'bepro'),
                                                'desc'          => esc_html__('Insert your page banner bg color here.', 'bepro'),
                                        ),
                                        'page_banner_overlay_color'  => array(
                                                'type'          => 'rgba-color-picker',
                                                'value'         => '',
                                                'palettes'      => array(),
                                                'label'         => esc_html__('Banner Overlay Color', 'bepro'),
                                                'desc'          => esc_html__('Insert your page banner overlay color here.', 'bepro'),
                                        ),
                                        'page_banner_title'	 => array(
                                                'type'		 => 'text',
                                                'value'		 => '',
                                                'label'		 => esc_html__( 'Banner Title', 'bepro' ),
                                                'desc'		 => esc_html__( 'Insert your page banner title.', 'bepro' ),
                                        ),
                                        'page_is_breadcrumb'   => array(
                                                'label'        => esc_html__( 'Is Breadcrumb?', 'bepro' ),
                                                'type'         => 'switch',
                                                'right-choice' => array(
                                                        'value' => '1',
                                                        'label' => esc_html__( 'Yes', 'bepro' )
                                                ),
                                                'left-choice'  => array(
                                                        'value' => '2',
                                                        'label' => esc_html__( 'No', 'bepro' )
                                                ),
                                                'value'        => '1',
                                                'desc'         => esc_html__('Do you want to show breadcrumb on page banner?', 'bepro'),
                                        ),
                                        'page_banner_alignment'              => array(
                                                'label'   => esc_html__( 'Banner Content Alignment', 'bepro' ),
                                                'type'    => 'short-select',
                                                'value'   => 'center',
                                                'choices' => array(
                                                        'left'         => esc_html__( 'Left', 'bepro' ),
                                                        'center'       => esc_html__( 'Center', 'bepro' ),
                                                        'right'        => esc_html__( 'Right', 'bepro' ),
                                                ),
                                        ),
                                )   
                        ),
                        'pagesettings' => array(
                                'title'   => esc_html__( 'Page Settings', 'bepro' ),
                                'type'    => 'tab',
                                'options' => array(
                                        'page_is_con_settings'                    => array(
                                                'label'        => esc_html__( 'Enable Content Settings', 'bepro' ),
                                                'type'         => 'switch',
                                                'right-choice' => array(
                                                        'value' => '1',
                                                        'label' => esc_html__( 'Yes', 'bepro' )
                                                ),
                                                'left-choice'  => array(
                                                        'value' => '2',
                                                        'label' => esc_html__( 'No', 'bepro' )
                                                ),
                                                'value'        => '2',
                                                'desc'         => esc_html__('Enable bellow settings for this page content are.', 'bepro'),
                                        ),
                                        'page_sidebar'              => array(
                                                'label'   => esc_html__( 'Sidebar Template', 'bepro' ),
                                                'type'    => 'select',
                                                'value'   => '1',
                                                'desc'    => esc_html__( 'Select your page template. This option only work for this page.', 'bepro' ),
                                                'choices' => array(
                                                        '1'         => esc_html__( 'No Sidebar', 'bepro' ),
                                                        '2'         => esc_html__( 'Left Sidebar', 'bepro' ),
                                                        '3'         => esc_html__( 'Right Sidebar', 'bepro' )
                                                ),
                                        ),
                                )
                        ),
                        
                        
		),
	),
);
