<?php
$fields[] = array(
        'type'        => 'custom',
	'settings'    => 'serv_single_custom_01',
	'label'       => FALSE,
	'section'     => 'service_single_settings',
	'default'     => '<div class="customizer_label">'.esc_html__('Banner Settings', 'bepro').'</div>',
);
$fields[]= array(
        'type'        => 'switch',
	'settings'    => 'serv_single_is_banner',
	'label'       => esc_html__( 'Is Banner?', 'bepro' ),
	'section'     => 'service_single_settings',
	'default'     => '1',
	'choices'     => [
		'on'      => esc_html__( 'Enable ', 'bepro' ),
		'off'     => esc_html__( 'Disable ', 'bepro' ),
	],
);
$fields[] = array(
    'type'        => 'background',
	'settings'    => 'serv_single_banner_bg',
	'label'       => esc_html__( 'Banner Background', 'bepro' ),
	'description' => esc_html__( 'Setup you case listing page banner BG.', 'bepro' ),
	'section'     => 'service_single_settings',
	'default'     => [
		'background-color'      => '',
		'background-image'      => '',
		'background-repeat'     => 'no-repeat',
		'background-position'   => 'center center',
		'background-size'       => 'cover',
		'background-attachment' => 'scroll',
	],
    'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.page_banner.service_single_banner',
		]
	],
    'active_callback' => [
            [
                    'setting'  => 'serv_single_is_banner',
                    'operator' => '==',
                    'value'    => true,
            ]
    ],
);
$fields[]= array(
	'type'        => 'color',
	'settings'    => 'serv_single_banner_overlay_color',
	'label'       => esc_html__( 'Banner Overlay Color', 'bepro' ),
	'section'     => 'service_single_settings',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.service_single_banner .overlay',
			'property' => 'background'
		],
	],
	'active_callback' => [
		[
				'setting'  => 'serv_single_is_banner',
				'operator' => '==',
				'value'    => true,
		],
	],
);
$fields[] = array(
        'type'          => 'text',
	'settings'      => 'serv_single_banner_title',
	'label'         => esc_html__('Banner Title', 'bepro'),
	'section'       => 'service_single_settings',
	'default'       => '',
    'transport'     => 'postMessage',
    'js_vars'       => array(
        array(
            'element'  => '.page_banner.service_single_banner .banner-title',
            'function' => 'html'
        ),
    ),
    'active_callback' => [
            [
                    'setting'  => 'serv_single_is_banner',
                    'operator' => '==',
                    'value'    => true,
            ]
    ],
);
$fields[]= array(
        'type'        => 'switch',
	'settings'    => 'serv_single_is_breadcrumb',
	'label'       => esc_html__( 'Is Breadcrumb?', 'bepro' ),
	'section'     => 'service_single_settings',
	'default'     => '1',
	'choices'     => [
		'on'      => esc_html__( 'Show', 'bepro' ),
		'off'     => esc_html__( 'Hide', 'bepro' ),
	],
    'active_callback' => [
            [
                    'setting'  => 'serv_single_is_banner',
                    'operator' => '==',
                    'value'    => true,
            ]
    ],
);
$fields[]= array(
    'type'        => 'radio-buttonset',
	'settings'    => 'serv_single_banner_alignment',
	'label'       => esc_html__( 'Choose your banner text alignment.', 'bepro' ),
	'section'     => 'service_single_settings',
	'default'     => 'center',
	'choices'     => [
		'left'   => esc_html__( 'Left', 'bepro' ),
		'center' => esc_html__( 'Center', 'bepro' ),
		'right'  => esc_html__( 'Right', 'bepro' ),
	],
    'active_callback' => [
            [
                    'setting'  => 'serv_single_is_banner',
                    'operator' => '==',
                    'value'    => true,
            ]
    ],
);