<?php
$fields[] = array(
        'type'        => 'custom',
	'settings'    => 'pages_custom_01',
	'label'       => FALSE,
	'section'     => 'page_settings',
	'default'     => '<div class="customizer_label">'.esc_html__('Banner Settings', 'bepro').'</div>',
);
$fields[]= array(
        'type'        => 'switch',
	'settings'    => 'pages_is_banner',
	'label'       => esc_html__( 'Is Banner?', 'bepro' ),
	'section'     => 'page_settings',
	'default'     => '1',
	'choices'     => [
		'on'      => esc_html__( 'Enable ', 'bepro' ),
		'off'     => esc_html__( 'Disable ', 'bepro' ),
	],
);
$fields[] = array(
        'type'        => 'background',
	'settings'    => 'pages_banner_bg',
	'label'       => esc_html__( 'Banner Background', 'bepro' ),
	'description' => esc_html__( 'Setup you page banner BG.', 'bepro' ),
	'section'     => 'page_settings',
	'default'     => [
		'background-color'      => '',
		'background-image'      => '',
		'background-repeat'     => 'no-repeat',
		'background-position'   => 'center center',
		'background-size'       => 'cover',
		'background-attachment' => 'scroll',
	],
    'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.page_banner',
		]
	],
    'active_callback' => [
            [
                    'setting'  => 'pages_is_banner',
                    'operator' => '==',
                    'value'    => true,
            ]
    ],
);
$fields[]= array(
	'type'        => 'color',
	'settings'    => 'page_banner_overlay_color',
	'label'       => esc_html__( 'Banner Overlay Color', 'bepro' ),
	'section'     => 'page_settings',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.page_banner .overlay',
			'property' => 'background'
		],
	],
	'active_callback' => [
		[
				'setting'  => 'pages_is_banner',
				'operator' => '==',
				'value'    => true,
		],
	],
);
$fields[] = array(
    'type'          => 'text',
	'settings'      => 'pages_banner_title',
	'label'         => esc_html__('Banner Title', 'bepro'),
	'section'       => 'page_settings',
	'default'       => '',
    'transport'     => 'postMessage',
    'js_vars'       => array(
        array(
            'element'  => '.page_banner .banner-title',
            'function' => 'html'
        )
    ),
    'active_callback' => [
            [
                    'setting'  => 'pages_is_banner',
                    'operator' => '==',
                    'value'    => true,
            ]
    ],
);
$fields[]= array(
        'type'        => 'switch',
	'settings'    => 'pages_is_breadcrumb',
	'label'       => esc_html__( 'Is Breadcrumb?', 'bepro' ),
	'section'     => 'page_settings',
	'default'     => '1',
	'choices'     => [
		'on'      => esc_html__( 'Show', 'bepro' ),
		'off'     => esc_html__( 'Hide', 'bepro' ),
	],
    'active_callback' => [
            [
                    'setting'  => 'pages_is_banner',
                    'operator' => '==',
                    'value'    => true,
            ]
    ],
);
$fields[]= array(
        'type'        => 'radio-buttonset',
	'settings'    => 'pages_banner_alignment',
	'label'       => esc_html__( 'Choose your banner text alignment.', 'bepro' ),
	'section'     => 'page_settings',
	'default'     => 'center',
	'choices'     => [
		'left'   => esc_html__( 'Left', 'bepro' ),
		'center' => esc_html__( 'Center', 'bepro' ),
		'right'  => esc_html__( 'Right', 'bepro' ),
	],
    'active_callback' => [
            [
                    'setting'  => 'pages_is_banner',
                    'operator' => '==',
                    'value'    => true,
            ]
    ],
);

$fields[] = array(
        'type'        => 'custom',
	'settings'    => 'pages_custom_02',
	'label'       => FALSE,
	'section'     => 'page_settings',
	'default'     => '<div class="customizer_label mt40">'.esc_html__('Content Settings', 'bepro').'</div>',
);
$fields[] = array(
        'type'        => 'select',
        'settings'    => 'pages_sidebar',
        'label'       => esc_html__( 'Sidebar Template', 'bepro' ),
        'section'     => 'page_settings',
        'default'     => '1',
        'choices'     => array(
                '1'         => esc_html__( 'No Sidebar', 'bepro' ),
                '2'         => esc_html__( 'Left Sidebar', 'bepro' ),
                '3'         => esc_html__( 'Right Sidebar', 'bepro' )
        ),
);