<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Do not proceed if Kirki does not exist.
if ( ! class_exists( 'Kirki' ) ) {
	return;
}

Kirki::add_config( 'bepro_customizer', array(
	'capability'  => 'edit_theme_options',
	'option_type' => 'theme_mod',
) );


function bepro_customizer_sections($wp_customize){
    $wp_customize->add_panel( 'theme_option', array(
        'priority'    => 10,
        'title'       => esc_html__( 'Theme Options', 'bepro' ),
    ) );

    $wp_customize->add_section( 'general_section', array(
            'title'                 => esc_html__( 'General Settings', 'bepro' ),
            'priority'              => 1,
            'description'           => esc_html__( 'to change site loader and google map api.', 'bepro' ),
            'panel'                 => 'theme_option',
    ) );

    $wp_customize->add_section( 'font_section', array(
            'title'                 => esc_html__( 'Typography Settings', 'bepro' ),
            'priority'              => 2,
            'description'           => esc_html__( 'Setup your site typography.', 'bepro' ),
            'panel'                 => 'theme_option',
    ));

    $wp_customize->add_section( 'colorpreset_section', array(
            'title'                 => esc_html__( 'Color Preset Settings', 'bepro' ),
            'priority'              => 3,
            'description'           => esc_html__( 'Setup your site accent color.', 'bepro' ),
            'panel'                 => 'theme_option',
    ));

    $wp_customize->add_section( 'header_settings', array(
            'title'                 => esc_html__( 'Header Settings', 'bepro' ),
            'priority'              => 4,
            'description'           => esc_html__( 'Setup your site header.', 'bepro' ),
            'panel'                 => 'theme_option',
    ) );

    $wp_customize->add_section( 'header_styling', array(
            'title'                 => esc_html__( 'Header Styling', 'bepro' ),
            'priority'              => 5,
            'description'           => esc_html__( 'Style up you site header.', 'bepro' ),
            'panel'                 => 'theme_option',
    ));

    $wp_customize->add_section( 'blog_settings', array(
            'title'                 => esc_html__( 'Blog Settings', 'bepro' ),
            'priority'              => 6,
            'description'           => esc_html__( 'Setup your blog pages.', 'bepro' ),
            'panel'                 => 'theme_option',
    ) );

    $wp_customize->add_section( 'blog_single_settings', array(
            'title'			=> esc_html__( 'Blog Single Settings', 'bepro' ),
            'priority'              => 7,
            'description'           => esc_html__( 'Setup your blog details pages.', 'bepro' ),
            'panel'                 => 'theme_option',
    ) );

    $wp_customize->add_section( 'blog_others_settings', array(
            'title'                 => esc_html__( 'Blog Others Banner Settings', 'bepro' ),
            'priority'              => 9,
            'description'           => esc_html__( 'Setup your blog related others pages banner ( Search, Archive).', 'bepro' ),
            'panel'                 => 'theme_option',
    ) );

    $wp_customize->add_section( 'service_single_settings', array(
            'title'                 => esc_html__( 'Service Single Settings', 'bepro' ),
            'priority'              => 13,
            'description'           => esc_html__( 'Setup your service details page.', 'bepro' ),
            'panel'                 => 'theme_option',
    ));

    $wp_customize->add_section( 'folio_single_settings', array(
            'title'                 => esc_html__( 'Folio Single Settings', 'bepro' ),
            'priority'              => 14,
            'description'           => esc_html__( 'Setup your folio details page.', 'bepro' ),
            'panel'                 => 'theme_option',
    ));

    $wp_customize->add_section( 'folio_cat_settings', array(
            'title'                 => esc_html__( 'Folio Category Settings', 'bepro' ),
            'priority'              => 15,
            'description'           => esc_html__( 'Setup your folio category page.', 'bepro' ),
            'panel'                 => 'theme_option',
    ));

    $wp_customize->add_section( 'member_single_settings', array(
            'title'                 => esc_html__( 'Member Single Settings', 'bepro' ),
            'priority'              => 16,
            'description'           => esc_html__( 'Setup your member details page.', 'bepro' ),
            'panel'                 => 'theme_option',
    ));

    $wp_customize->add_section( 'shop_settings', array(
            'title'                 => esc_html__( 'Shop Settings', 'bepro' ),
            'priority'              => 17,
            'description'           => esc_html__( 'Setup your shop pages.', 'bepro' ),
            'panel'                 => 'theme_option',
    ));

    $wp_customize->add_section( 'shop_product_setting', array(
            'title'                 => esc_html__( 'Shop Product Settings', 'bepro' ),
            'priority'              => 18,
            'description'           => esc_html__( 'Setup your shop product single pages.', 'bepro' ),
            'panel'                 => 'theme_option',
    ));

    $wp_customize->add_section( 'shop_other_settings', array(
            'title'                 => esc_html__( 'Shop Others Banner Settings', 'bepro' ),
            'priority'              => 19,
            'description'           => esc_html__( 'Setup your shop related other pages banner settings here.', 'bepro' ),
            'panel'                 => 'theme_option',
    ));

    $wp_customize->add_section( 'page_settings', array(
            'title'                 => esc_html__( 'Page Settings', 'bepro' ),
            'priority'              => 20,
            'description'           => esc_html__( 'Setup your page global options.', 'bepro' ),
            'panel'                 => 'theme_option',
    ));

    $wp_customize->add_section( 'page_settings', array(
            'title'		    => esc_html__( 'Page Settings', 'bepro' ),
            'priority'              => 21,
            'description'           => esc_html__( 'Setup your page global options.', 'bepro' ),
            'panel'                 => 'theme_option',
    ));

    $wp_customize->add_section( 'footer_settings', array(
            'title'                 => esc_html__( 'Footer Settings', 'bepro' ),
            'priority'              => 22,
            'description'           => esc_html__( 'Setup your site footer here.', 'bepro' ),
            'panel'                 => 'theme_option',
    ));

    $wp_customize->add_section( 'fof_section', array(
            'title' 		    => esc_html__( '404 Settings', 'bepro' ),
            'priority'              => 23,
            'description'           => esc_html__( 'Setting up your 404 page.', 'bepro' ),
            'panel'                 => 'theme_option',
    ));
}

add_action( 'customize_register', 'bepro_customizer_sections' );

require BEPRO_CUSTOMIZER_DIR . 'customizer-fields.php' ;

