<?php
/**
 * The template for displaying comments
 */

if ( post_password_required() ) {
	return;
}
?>

<div id="comments">
    <h3 class="sicc_title cm01"><?php echo get_comments_number(); ?> <?php echo comments_number( esc_html__('Comments', 'bepro'), esc_html__('Comment', 'bepro'), esc_html__('Comments', 'bepro') ); ?></h3>
    <p class="cnotes"><?php echo esc_html__('Your email address will not be published. Required fields are marked *', 'bepro'); ?></p>
    <?php if ( have_comments() ) : ?>
        <div class="sic_comments">
            <ol class="sicc_list">
                <?php wp_list_comments(array('short_ping'  => true, 'style' => 'ol', 'callback'=> 'bepro_comment_listing')); ?>
            </ol>
            <div class="bepro_pagination comentPaginations text-right">
                <?php paginate_comments_links( array('prev_text' => '<i class="twi-arrow-left"></i>', 'next_text' => '<i class="twi-arrow-right"></i>') ) ?>
            </div>
        </div>
    <?php endif; ?>
	<?php
        $class = (is_user_logged_in() ? 'loggedIns' : '');
        $fields = array(
                'author' =>'<div class="col-md-12 name clearfix"><input id="author" placeholder="'.esc_attr__('Your Name *', 'bepro').'" name="author" type="text" value="' .
                            esc_attr( $commenter['comment_author'] ) . '" size="30" /></div>',
                'email'  => '<div class="col-md-6 email clearfix"><input id="email" placeholder="'.esc_attr__('Your Email *', 'bepro').'" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) .
                            '" size="30" /></div>',
                'url'    => '<div class="col-md-6 clearfix"><input id="text" name="url" type="url" value="'.esc_attr( $commenter['comment_author_url'] ).'" placeholder="'.esc_attr__('Website', 'bepro').'" maxlength="200" /></div>',
                'cookies'=> ''
                    
        );
        $fields = apply_filters('comment_form_default_fields', $fields);
        $args = array(
            'fields'               => $fields,
            'comment_field'        => '<div class="col-md-12"><textarea id="comment" class="'.$class.'" name="comment"  placeholder="'.esc_attr__('Your Comment *', 'bepro').'" aria-required="true" required="required"></textarea></div>',
            'logged_in_as'         => '',
            'comment_notes_before' => '',
            'comment_notes_after'  => '',
            'id_form'              => 'comment_form',
            'id_submit'            => 'submit',
            'class_form'           => 'commentForm row '.$class,
            'class_submit'         => 'berpo_btn with_icon04',
            'name_submit'          => 'submit',
            'title_reply'          => esc_html__( 'Leave a Comment' , 'bepro'),
            'title_reply_to'       => esc_html__( 'Leave a Replies to %s', 'bepro'),
            'title_reply_before'   => '<h3 class="sicc_title mb30">',
            'title_reply_after'    => '</h3>',
            'cancel_reply_before'  => '<small class="cancel_reply_btn">',
            'cancel_reply_after'   => '</small>',
            'cancel_reply_link'    => esc_html__( 'Cancel Reply' , 'bepro'),
            'label_submit'         => esc_html__( 'Submit Now' , 'bepro'),
            'submit_button'        => '<div class="col-lg-12"><button type="submit" name="%1$s" id="%2$s" class="%3$s" value="%4$s"><span class="bp-shape"></span><span class="bp-shape"></span><span class="bp-shape"></span><span class="bp-shape"></span><span class="bp-text">%4$s<i class="twi-arrow-right"></i></span></button></div>',
            'submit_field'         => '%1$s %2$s',
        );
    ?>
    <div class="commentForm">
        <?php
            comment_form($args);
        ?>
    </div>
</div>