/*
 Theme Name: Bepro
 Theme URI: https://themeforest.net/user/themewar/portfolio
 Author: themewar
 Author URI: 
 Description: Bepro - Multi-Purpose Business & Consulting WordPress Theme.
 Version: 1.0
 License:
 License URI:
*/
 
/*=======================================================================
 [Table of contents]
 =========================================================================
 1. Init Obj
 2. All Slider
 3. All Skills
 4. Funfact Count
 5. Back To Top
 6. All PopUP
 7. Sticky Header
 8. Mobile Menu
 9. Preloader
 10. Select
 11. Google Maps
 12. Contact Form Submission
 13. Filter & Suffle
 14. Popup Menu
 15. Strech Column
 16. Qty
 17. Sidebar Menu
*/

(function ($) {
    'use strict';
    /*--------------------------------------------------------
    / 1. Init Obj
    /---------------------------------------------------------*/
    var related_carousel        = $(".related_carousel"),
        popup_video             = $('.popup_video'),
        countfact               = $('.countfact'),
        popup_img               = $('.popup_img'),
        select                  = $('.contact_form select, .sorting select'),
        categoryDropdown        = $('.filterBy select'),
        variationSelect         = $('.qty_weight .variations select');
    
    /*--------------------------------------------------------
    / 2. All Slider
    /---------------------------------------------------------*/
    /*--- Team Silder ---*/
    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction('frontend/element_ready/tw-team.default', function ($scope, $) {
            var $wrap   = $scope.find('.tmSlider_wrap');
            var $slide  = $scope.find('.tmSlider');
            var $slide2 = $scope.find('.tmSlider02');
            var $slide3 = $scope.find('.tmSlider03');

            var autoplay = ($wrap.attr('data-autoplay') == '1') ? true : false;
            var loop     = ($wrap.attr('data-loop') == '1') ? true : false;
            var nav      = ($wrap.attr('data-nav') == '1') ? true : false;
            var dots     = ($wrap.attr('data-dots') == '1') ? true : false;
            var item1    = ($wrap.attr('data-item1') != '') ? parseInt($wrap.attr('data-item1'), 10) : 3;
            var item2    = ($wrap.attr('data-item2') != '') ? parseInt($wrap.attr('data-item2'), 10) : 3;
            var item3    = ($wrap.attr('data-item3') != '') ? parseInt($wrap.attr('data-item3'), 10) : 2;
            var gapping  = ($wrap.attr('data-gapping')*1 > 0 ) ? $wrap.attr('data-gapping')*1 : 0;

            if ($slide.length > 0) {
                $slide.owlCarousel({
                    autoplay: autoplay,
                    loop: loop,
                    margin: gapping,
                    nav: nav,
                    navText: ['<i class="twi-angle-left1"></i>', '<i class="twi-angle-right1"></i>'],
                    dots: dots,
                    responsiveClass: true,
                    smartSpeed: 600,
                    responsive: {
                        0: {
                            items: 1,
                        },
                        768: {
                            items: item3
                        },
                        1024: {
                            items: item2
                        },
                        1200: {
                            items: item1
                        }
                    }
                });
            }
            if ($slide2.length > 0) {
                $slide2.owlCarousel({
                    autoplay: autoplay,
                    loop: loop,
                    margin: gapping,
                    nav: nav,
                    navText: ['<i class="twi-arrow-left"></i>', '<i class="twi-arrow-right"></i>'],
                    dots: dots,
                    responsiveClass: true,
                    smartSpeed: 600,
                    responsive: {
                        0: {
                            items: 1,
                        },
                        768: {
                            items: item3
                        },
                        1024: {
                            items: item2
                        },
                        1200: {
                            items: item1
                        }
                    }
                });
            }
            if ($slide3.length > 0) {
                $slide3.owlCarousel({
                    margin: gapping,
                    autoplay: autoplay,
                    loop: loop,
                    nav: false,
                    smartSpeed: 500,
                    dots: dots,
                    responsive: {
                        0: {
                            items: 1,
                        },
                        768: {
                            items: item3
                        },
                        1024: {
                            items: item2
                        },
                        1200: {
                            items: item1
                        }
                    }
                });
                $('.prevArrow').click(function(e){
                    e.preventDefault();
                    $slide2.trigger('next.owl.carousel');
                });
                $('.nextArrow').click(function(e){
                    e.preventDefault();
                    $slide2.trigger('prev.owl.carousel');
                });
            }
        });
    });
    /*--- Service Silder ---*/
    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction('frontend/element_ready/tw-services.default', function ($scope, $) {
            var $wrap  = $scope.find('.serviceSlider_wrap');
            var $slide = $scope.find('.serviceSlider');
            var $slide2 = $scope.find('.serviceSlider02');
            var $slide3 = $scope.find('.serviceSlider03');
            var $slide4 = $scope.find('.serviceSlider04');

            var autoplay = ($wrap.attr('data-autoplay') == '1') ? true : false;
            var loop    = ($wrap.attr('data-loop') == '1') ? true : false;
            var nav     = ($wrap.attr('data-nav') == '1') ? true : false;
            var dots    = ($wrap.attr('data-dots') == '1') ? true : false;
            var item1   = ($wrap.attr('data-item1') != '') ? parseInt($wrap.attr('data-item1'), 10) : 3;
            var item2   = ($wrap.attr('data-item2') != '') ? parseInt($wrap.attr('data-item2'), 10) : 3;
            var item3   = ($wrap.attr('data-item3') != '') ? parseInt($wrap.attr('data-item3'), 10) : 2;
            var gapping = ($wrap.attr('data-gapping')*1 > 0 ) ? $wrap.attr('data-gapping')*1 : 0;

            if ($slide.length > 0) {
                $slide.owlCarousel({
                    autoplay: autoplay,
                    loop: loop,
                    margin: gapping,
                    nav: nav,
                    navText: ['<i class="twi-arrow-left"></i>', '<i class="twi-arrow-right"></i>'],
                    dots: dots,
                    responsiveClass: true,
                    smartSpeed: 600,
                    responsive: {
                        0: {
                            items: 1,
                        },
                        768: {
                            items: item3
                        },
                        1023: {
                            items: item2
                        },
                        1200: {
                            items: item1
                        }
                    }
                });
            }
            if ($slide2.length > 0) {
                $slide2.owlCarousel({
                    autoplay: autoplay,
                    loop: loop,
                    margin: gapping,
                    nav: false,
                    dots: dots,
                    responsiveClass: true,
                    smartSpeed: 600,
                    responsive: {
                        0: {
                            items: 1,
                        },
                        768: {
                            items: item3
                        },
                        992: {
                            items: item2
                        },
                        1200: {
                            items: item1
                        }
                    }
                });
                $('.prevArrow').click(function(e){
                    e.preventDefault();
                    $slide2.trigger('next.owl.carousel');
                });
                $('.nextArrow').click(function(e){
                    e.preventDefault();
                    $slide2.trigger('prev.owl.carousel');
                });
            }
            if ($slide3.length > 0) {
                $slide3.owlCarousel({
                    autoplay: autoplay,
                    loop: loop,
                    margin: gapping,
                    nav: nav,
                    navText: ['<i class="twi-angle-left1"></i>', '<i class="twi-angle-right1"></i>'],
                    dots: dots,
                    responsiveClass: true,
                    smartSpeed: 600,
                    responsive: {
                        0: {
                            items: 1,
                        },
                        768: {
                            items: item3
                        },
                        992: {
                            items: item2
                        },
                        1200: {
                            items: item1
                        }
                    }
                });
            }
            if ($slide4.length > 0) {
                $slide4.owlCarousel({
                    margin: gapping,
                    autoplay: autoplay,
                    loop: loop,
                    nav: nav,
                    navText: ['<i class="twi-arrow-left"></i>', '<i class="twi-arrow-right"></i>'],
                    smartSpeed: 500,
                    dots: dots,
                    responsive: {
                        0: {
                            items: 1,
                        },
                        768: {
                            items: item3
                        },
                        992: {
                            items: item2
                        },
                        1024: {
                            items: item1
                        },
                    }
                });
            }
        });
    });
    /*--- Testimonial Silder ---*/
    $(window).on('elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction('frontend/element_ready/tw-testimonial.default', function($scope, $) {
            var $wrap       = $scope.find('.testi_wrap');
            var tslider1    = $scope.find('.testimonialslider01');
            var tslider2    = $scope.find('.testimonialslider03');
            var tslider3    = $scope.find('.testimonialslider04');
            var tslider4    = $scope.find('.testimonialslider05');
            
            var autoplay = ($wrap.attr('data-autoplay') == 1 ) ? true : false;
            var loop = ($wrap.attr('data-loop') == 1 ) ? true : false;
            var nav = ($wrap.attr('data-nav') == 1 ) ? true : false;
            var dots = ($wrap.attr('data-dots') == 1 ) ? true : false;
            
            if (tslider1.length > 0) {
                var tslider1_obj = tslider1.owlCarousel({
                    margin: 0,
                    autoplay: autoplay,
                    loop: loop,
                    nav: nav,
                    navText: ['<i class="twi-arrow-left1"></i>', '<i class="twi-arrow-right1"></i>'],
                    smartSpeed: 400,
                    animateOut: 'fadeOut',
                    dots: dots,
                    items: 1
                });
            }
            if (tslider2.length > 0) {
                tslider2.slick({
                    dots: dots,
                    arrows: false,
                    vertical: true,
                    infinite: loop,
                    slidesToShow: 2,
                    slidesToScroll: 1,
                    autoplay: autoplay,
                    verticalSwiping: true
                });
                $('.prevArrow').click(function(e){
                    e.preventDefault();
                    tslider2.slick('slickPrev');
                });
                $('.nextArrow').click(function(e){
                    e.preventDefault();
                    tslider2.slick('slickNext');
                });
            }
            if (tslider3.length > 0) {
                tslider3.slick({
                    slidesToShow: 1,
                    slidesToScroll: 1,
                    arrows: false,
                    asNavFor: '.testimonialNav',
                    autoplay: false
                });
                $('.testimonialNav').slick({
                    slidesToShow: 5,
                    slidesToScroll: 1,
                    asNavFor: '.testimonialslider04',
                    dots: false,
                    arrows: false,
                    variableWidth: true,
                    autoplay: false,
                    infinite: true,
                    centerMode: true,
                    centerPadding: '0',
                    focusOnSelect: true,
                    responsive: [{
                        breakpoint: 767,
                        settings: {
                            slidesToShow: 3
                        }
                    }, ]
                });
            }
            if (tslider4.length > 0) {
                tslider4.slick({
                    dots: false,
                    arrows: false,
                    autoplay: autoplay,
                    vertical: true,
                    infinite: loop,
                    slidesToShow: 3,
                    slidesToScroll: 1,
                    centerPadding: '0',
                    verticalSwiping: true
                });
            }
        });
    });
    
    /*--- Client Silder ---*/
    $(window).on('elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction('frontend/element_ready/tw-clients-slider.default', function($scope, $) {
            var $wrap = $scope.find('.clslider_wrap');
            var $slide = $scope.find('.brandSlider');
            
            var autoplay = ($wrap.attr('data-autoplay') == 1 ) ? true : false;
            var loop = ($wrap.attr('data-loop') == 1 ) ? true : false;
            var nav = ($wrap.attr('data-nav') == 1 ) ? true : false;
            var dots = ($wrap.attr('data-dots') == 1 ) ? true : false;
            var item = ($wrap.attr('data-item')*1 > 0 ) ? $wrap.attr('data-item')*1 : 0;
            var item2 = ($wrap.attr('data-item2')*1 > 0 ) ? $wrap.attr('data-item2')*1 : 0;
            var item3 = ($wrap.attr('data-item3')*1 > 0 ) ? $wrap.attr('data-item3')*1 : 0;
            var gapping = ($wrap.attr('data-gapping')*1 > 0 ) ? $wrap.attr('data-gapping')*1 : 0;
            
            if($slide.length > 0){
                $slide.owlCarousel({
                    autoplay: autoplay,
                    loop: loop,
                    margin: gapping,
                    nav: nav,
                    navText: ['<i class="twi-arrow-left1"></i>', '<i class="twi-arrow-right1"></i>'],
                    dots: dots,
                    items: item,
                    smartSpeed: 600,
                    responsiveClass:true,
                    responsive: {
                        0: {
                            items: 1,
                            autoWidth: false
                        },
                        768: {
                            items: item3
                        },
                        992: {
                            items: item2
                        },
                        1200: {
                            items: item
                        }
                    }
                });
            }
        });
    });

    /*--- Folio Silder ---*/
    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction('frontend/element_ready/tw-folio-slide.default', function ($scope, $) {
            var $wrap    = $scope.find('.flsSlider_wrap');
            var $slide   = $scope.find('.folioSlider01');
            var $slide2  = $scope.find('.featuredSlider');

            var autoplay = ($wrap.attr('data-autoplay') == '1') ? true : false;
            var loop     = ($wrap.attr('data-loop') == '1') ? true : false;
            var nav      = ($wrap.attr('data-nav') == '1') ? true : false;
            var dots     = ($wrap.attr('data-dots') == '1') ? true : false;
            var item1    = ($wrap.attr('data-item1') != '') ? parseInt($wrap.attr('data-item1'), 10) : 5;
            var item2    = ($wrap.attr('data-item2') != '') ? parseInt($wrap.attr('data-item2'), 10) : 4;
            var item3    = ($wrap.attr('data-item3') != '') ? parseInt($wrap.attr('data-item3'), 10) : 3;
            var item4    = ($wrap.attr('data-item4') != '') ? parseInt($wrap.attr('data-item4'), 10) : 2;
            var gapping  = ($wrap.attr('data-gapping')*1 > 0 ) ? $wrap.attr('data-gapping')*1 : 0;

            if ($slide.length > 0) {
                $slide.owlCarousel({
                    autoplay: autoplay,
                    loop: loop,
                    margin: gapping,
                    nav: nav,
                    navText: ['<i class="bpro-long-left-arrow"></i>', '<i class="bpro-long-right-arrow"></i>'],
                    dots: dots,
                    responsiveClass: true,
                    animateOut: 'fadeOut',
                    smartSpeed: 600,
                    responsive: {
                        0: {
                            items: 1,
                        },
                        768: {
                            items: item4
                        },
                        992: {
                            items: item3
                        },
                        1200: {
                            items: item2
                        },
                        1600: {
                            items: item1
                        }
                    }
                });
            }

            if ($slide2.length > 0) {
                $slide2.owlCarousel({
                    autoplay: autoplay,
                    loop: loop,
                    margin: gapping,
                    nav: false,
                    smartSpeed: 500,
                    items: 3,
                    center:true,
                    dots: dots,
                    onTranslate: dosomthing,
                    responsive: {
                        0: {
                            items: 1,
                        },
                        768: {
                            items: 3
                        }
                    }
                });
                $('.prevArrow').click(function(e){
                    e.preventDefault();
                    $slide2.trigger('next.owl.carousel');
                });
                $('.nextArrow').click(function(e){
                    e.preventDefault();
                    $slide2.trigger('prev.owl.carousel');
                });
            }
            function dosomthing(event){
                $('.owl-item', $slide)                     
                .removeClass('activeOnMiddle')
                .removeClass('activeOnLeft')
                .removeClass('activeOnRight');

                var middle_item = $('.active.center', $slide2).index();
                
                $('.owl-item.active.center', $slide2).eq(middle_item - 1).addClass('activeOnLeft');
                $('.owl-item.active.center', $slide2).addClass('activeOnMiddle');
                $('.owl-item.active.center', $slide2).eq(middle_item + 1).addClass('activeOnRight');
            }
        });
    });

    /*--- Blog Post Silder ---*/
    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction('frontend/element_ready/tw-latest-blog.default', function ($scope, $) {
            var $wrap = $scope.find('.lb_slider_wrap');
            var $slide = $scope.find('.cmblogSlider');
            var $slide2 = $scope.find('.cmblogSlider02');
            var $slide3 = $scope.find('.blogSlider');
            var $slide4 = $scope.find('.blogSlider02');

            var autoplay = ($wrap.attr('data-autoplay') == 1) ? true : false;
            var loop = ($wrap.attr('data-loop') == 1) ? true : false;
            var nav = ($wrap.attr('data-nav') == 1) ? true : false;
            var dots = ($wrap.attr('data-dots') == 1) ? true : false;

            $slide.owlCarousel({
                autoplay: autoplay,
                loop: loop,
                margin: 30,
                responsiveClass: true,
                nav: nav,
                navText: ['<i class="twi-angle-left1"></i>', '<i class="twi-angle-right1"></i>'],
                dots: dots,
                responsive: {
                    0: {
                        items: 1
                    },
                    768: {
                        items: 2
                    },
                    992: {
                        items: 3
                    }
                }
            });
            $slide2.owlCarousel({
                autoplay: autoplay,
                loop: loop,
                margin: 0,
                responsiveClass: true,
                nav: nav,
                navText: ['<i class="twi-arrow-left1"></i>', '<i class="twi-arrow-right1"></i>'],
                dots: dots,
                items: 1,
            });
            $slide3.owlCarousel({
                autoplay: autoplay,
                loop: loop,
                margin: 30,
                responsiveClass: true,
                nav: nav,
                navText: ['<i class="twi-arrow-left1"></i>', '<i class="twi-arrow-right1"></i>'],
                dots: dots,
                responsive: {
                    0: {
                        items: 1
                    },
                    992: {
                        items: 2
                    }
                }
            });
            $slide4.owlCarousel({
                autoplay: autoplay,
                dots: dots,
                items: 3,
                loop: loop,
                margin: 40,
                nav: nav,
                navText: ['<i class="bpro-long-left-arrow"></i>', '<i class="bpro-long-right-arrow"></i>'],
                responsive: {
                    0: {
                        items: 1
                    },
                    768: {
                        margin: 30,
                        items: 2
                    },
                    992: {
                        margin: 30,
                        items: 3
                    },
                    1200: {
                        margin: 40,
                    }
                }
            });
        });
    });
    
    /*--- Gallery Slider ---*/
    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction('frontend/element_ready/tw-gallery.default', function ($scope, $) {
            var $wrap    = $scope.find('.flsSlider_wrap');
            var $slide   = $scope.find('.gallerySlider');

            $slide.owlCarousel({
                autoplay: true,
                dots: false,
                items: 4,
                loop: true,
                margin: 0,
                nav: false,
                responsive: {
                    0: {
                        items: 1
                    },
                    768: {
                        items: 2
                    },
                    992: {
                        items: 3
                    },
                    1200: {
                        items: 4
                    }
                }
            });
        });
    });

    $(window).on('elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction('frontend/element_ready/tw-image-carousel.default', function($scope, $) {
            var $wrap    = $scope.find('.gallerSliderWraper');
            var $slide   = $scope.find('.gallerSlider');
            var $slide2  = $scope.find('.imageGallery');
            
            var autoplay = ($wrap.attr('data-autoplay') == 1 ) ? true : false;
            var loop     = ($wrap.attr('data-loop') == 1 ) ? true : false;
            var nav      = ($wrap.attr('data-nav') == 1 ) ? true : false;
            var dots     = ($wrap.attr('data-dots') == 1 ) ? true : false;
            
            if ($slide.length > 0) {
                $slide.lightSlider({
                    gallery:true,
                    item:1,
                    thumbItem:3,
                    slideMargin: 0,
                    speed:700,
                    pause: 5000,
                    auto:true,
                    vertical: true,
                    loop:true,
                    galleryMargin: 0,
                    vThumbWidth: 195,
                    thumbMargin: 30,
                    currentPagerPosition: 'left',
                    onSliderLoad: function() {
                        $slide.removeClass('cS-hidden');
                    },
                    responsive : [
                    {
                        breakpoint:1199,
                        settings: {
                            vThumbWidth: 140,
                            thumbMargin: 15,
                            verticalHeight:405,
                          }
                    },
                    {
                        breakpoint:990,
                        settings: {
                            vThumbWidth: 100,
                            thumbMargin: 10,
                            verticalHeight:300,
                          }
                    },
                    {
                        breakpoint:767,
                        settings: {
                            vThumbWidth: 60,
                            thumbMargin: 10,
                            thumbItem:2,
                            verticalHeight:120,
                          }
                    }
                ]
                });
            }
            $slide2.owlCarousel({
                autoplay: autoplay,
                dots: dots,
                items: 1,
                loop: loop,
                animateOut: 'fadeOut',
                margin: 0,
                nav: nav,
                navText: ['<i class="twi-long-arrow-left1"></i>', '<i class="twi-long-arrow-right1"></i>'],
            });
        });
    });

    $(window).on('elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction('frontend/element_ready/tw-text-carousel.default', function($scope, $) {
            var $wrap    = $scope.find('.offerWrap');
            var $slide   = $scope.find('.offerSlider');
            
            var autoplay = ($wrap.attr('data-autoplay') == 1 ) ? true : false;
            var loop     = ($wrap.attr('data-loop') == 1 ) ? true : false;
            var nav      = ($wrap.attr('data-nav') == 1 ) ? true : false;
            var dots     = ($wrap.attr('data-dots') == 1 ) ? true : false;
            
            $slide.owlCarousel({
                autoplay: autoplay,
                dots: dots,
                items: 1,
                loop: loop,
                animateOut: 'fadeOut',
                margin: 0,
                nav: false,
                navText: ['<i class="twi-long-arrow-left1"></i>', '<i class="twi-long-arrow-right1"></i>'],
            });
            $('.next').click(function(e){
                e.preventDefault();
                $slide.trigger('next.owl.carousel');
            });
            $('.prev').click(function(e){
                e.preventDefault();
                $slide.trigger('prev.owl.carousel');
            });
        });
    });

    /*-- Product Gallery Slider --*/
    if ($('.productSlide').length > 0) {
        $('.productSlide').slick({
            autoplay: false,
            autoplaySpeed: 3000,
            slidesToShow: 1,
            slidesToScroll: 1,
            dots: false,
            arrows: false,
            infinite: true,
            centerMode: true,
            asNavFor: '.indicator_slider',
            centerPadding: '0'
        });
        $('.indicator_slider').slick({
            slidesToShow: 4,
            slidesToScroll: 1,
            asNavFor: '.productSlide',
            dots: false,
            arrows: false,
            centerMode: true,
            centerPadding: '0',
            focusOnSelect: true
        });
    }

    $(window).on('elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction('frontend/element_ready/tw-product-slider.default', function($scope, $) {
            var $wrap = $scope.find('.product_carousel_wrap');
            var $slide = $scope.find('.product_carousel');
            
            var autoplay = ($wrap.attr('data-autoplay') == 1 ) ? true : false;
            var loop = ($wrap.attr('data-loop') == 1 ) ? true : false;
            var nav = ($wrap.attr('data-nav') == 1 ) ? true : false;
            var dots = ($wrap.attr('data-dots') == 1 ) ? true : false;
            var gapping = ($wrap.attr('data-gapping')*1 > 0 ) ? $wrap.attr('data-gapping')*1 : 0;
            var item = ($wrap.attr('data-item') > 0 ) ? $wrap.attr('data-item') : 4;
            var item2 = ($wrap.attr('data-item2') > 0 ) ? $wrap.attr('data-item2') : 3;
            var item3 = ($wrap.attr('data-item3') > 0 ) ? $wrap.attr('data-item3') : 2;
            
            if($slide.length > 0){
                $slide.owlCarousel({
                    autoplay: autoplay,
                    loop: loop,
                    margin: gapping,
                    nav: nav,
                    navText: ['<i class="twi-long-arrow-left1"></i>', '<i class="twi-long-arrow-right1"></i>'],
                    dots: dots,
                    responsiveClass:true,
                    responsive:{
                        0:{
                            items: 1
                        },
                        760:{
                            items: item3
                        },
                        992:{
                            items: item2
                        },
                        1200:{
                            items: item
                        }
                    }
                });
            }
        });
    });
    /*-- Related Product Slider --*/
    if(related_carousel.length > 0){
        var related_carousel_obj = related_carousel.owlCarousel({
            margin: 30,
            loop: false,
            dots: false,
            nav: false,
            items: 4,
            responsiveClass:true,
            responsive:{
                0:{
                    items: 1
                },
                768:{
                    items: 2
                },
                991:{
                    items: 3
                },
                1200:{
                    items: 4
                }
            }
        });
    }

    /*--------------------------------------------------------
    / 3. All Skills
    /----------------------------------------------------------*/
    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction('frontend/element_ready/tw-skill-bar.default', function ($scope, $) {
            var $wrap = $scope.find('.single_skill');
            $wrap.appear();
            $wrap.on('appear', loadSkills);
        });
    });
    var coun = true;
    function loadSkills(){
        $(".single_skill").each(function () {
            var datacount = $(this).attr("data-parcent");
            $(".ss_child", this).animate({'width': datacount + '%'}, 2000);
            $(".ss_parent span.runing", this).animate({'left': datacount + '%'}, 2000);
            if (coun){
                $(this).find('.ss_parent span').each(function () {
                    var $this = $(this);
                    $({Counter: 0}).animate({Counter: datacount}, {
                        duration: 2000,
                        easing: 'swing',
                        step: function () {
                            $this.text(Math.ceil(this.Counter) + '%');
                        }
                    });
                });
            }
        });
        coun = false;
    }
    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction('frontend/element_ready/tw-skills.default', function ($scope, $) {
            var $affected = $scope.find('.circle-skill');
            if (!$affected.length) {
                return;
            }
            $affected.appear();
            $(document.body).on('appear', '.circle-skill', function(e, $affected) {
                $affected.each(function() {
                    var $this = $(this);
                    if(!$this.hasClass('appeared')){
                        var point = $this.attr('data-values');
                        var decs = point * 100;
                        var size = $this.attr('data-sizes');
                        var thickness = $this.attr('data-thicknesss');
                        var grs = $(this).attr('data-gradientstart');
                        var gre = $(this).attr('data-gradientend');
                        var emptyFill = $this.attr('data-emptyfills');
                        var lineCap = $this.attr('data-linecaps');

                        $this.circleProgress({
                            value: point,
                            startAngle: -Math.PI / 3 * 1.7,
                            fill: {gradient: [[grs, 1], [gre, .3]], gradientAngle: Math.PI / 4 * 2},
                            emptyFill: emptyFill,
                            lineCap: lineCap,
                            thickness: thickness,
                            animation: {duration: 1800},
                            size: size
                        }).on('circle-animation-progress', function (event, progress) {
                            $this.find('strong').html(parseInt(decs * progress) + '<span>%</span>');
                        });
                        $this.addClass('appeared');
                    }
                });
            });
            var $affected2 = $scope.find('.circle-skill02');
            if (!$affected2.length) {
                return;
            }
            $affected2.appear();
            $(document.body).on('appear', '.circle-skill02', function(e, $affected2) {
                $affected2.each(function() {
                    var $this = $(this);
                    if(!$this.hasClass('appeared')){
                        var point2 = $this.attr('data-values2');
                        var decs2 = point * 100;
                        var size2 = $this.attr('data-sizes2');
                        var thickness2 = $this.attr('data-thicknesss2');
                        var grs2 = $(this).attr('data-gradientstart2');
                        var gre2 = $(this).attr('data-gradientend2');
                        var emptyFill2 = $this.attr('data-emptyfills2');
                        var lineCap2 = $this.attr('data-linecaps2');

                        $this.circleProgress({
                            value: point2,
                            startAngle: -Math.PI / 4 * 0,
                            fill: {gradient: [[grs2, 1], [gre2, .3]], gradientAngle: Math.PI / 4 * 2},
                            emptyFill: emptyFill2,
                            lineCap: lineCap2,
                            thickness: thickness2,
                            animation: {duration: 1800},
                            size: size2
                        }).on('circle-animation-progress', function (event, progress) {
                            $this.find('strong').html(parseInt(decs2 * progress) + '<span>%</span>');
                        });
                        $this.addClass('appeared');
                    }
                });
            });
        });
    });
    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction('frontend/element_ready/tw-skills.default', function ($scope, $) {
            var $affected2 = $scope.find('.circle-skill02');
            if (!$affected2.length) {
                return;
            }
            $affected2.appear();
            $(document.body).on('appear', '.circle-skill02', function(e, $affected2) {
                $affected2.each(function() {
                    var $this = $(this);
                    if(!$this.hasClass('appeared')){
                        var point = $this.attr('data-values');
                        var decs = point * 100;
                        var size = $this.attr('data-sizes');
                        var thickness = $this.attr('data-thicknesss');
                        var grs = $(this).attr('data-gradientstart');
                        var gre = $(this).attr('data-gradientend');
                        var emptyFill = $this.attr('data-emptyfills');
                        var lineCap = $this.attr('data-linecaps');

                        $this.circleProgress({
                            value: point,
                            startAngle: -Math.PI / 4 * 0,
                            fill: {gradient: [[grs, 1], [gre, .3]], gradientAngle: Math.PI / 4 * 2},
                            emptyFill: emptyFill,
                            lineCap: lineCap,
                            thickness: thickness,
                            animation: {duration: 1800},
                            size: size
                        }).on('circle-animation-progress', function (event, progress) {
                            $this.find('strong').html(parseInt(decs * progress) + '<span>%</span>');
                        });
                        $this.addClass('appeared');
                    }
                });
            });
        });
    });
    
    /*--------------------------------------------------------
    / 4. Funfact Count
    /---------------------------------------------------------*/
    var skl = true;
    countfact.appear();
    countfact.on('appear', function() {
        if (skl) {
            countfact.each(function() {
                var $this = $(this);
                jQuery({
                    Counter: 0
                }).animate({
                    Counter: $this.attr('data-count')
                }, {
                    duration: 3000,
                    easing: 'swing',
                    step: function() {
                        var num = Math.ceil(this.Counter).toString();
                        $('.counter', $this).html(num);
                    }
                });
            });
            skl = false;
        }
    });
    
    /*--------------------------------------------------------
    / 5. Back To Top
    /---------------------------------------------------------*/
    var back = $("#backtotop"),
        body = $("body, html");
    $(window).on('scroll', function () {
        if ($(window).scrollTop() > $(window).height()) {
            back.css({bottom: '30px', opacity: '1', visibility: 'visible'});
        } else {
            back.css({bottom: '-30px', opacity: '0', visibility: 'hidden'});
        }
    });
    body.on("click", "#backtotop", function (e) {
        e.preventDefault();
        body.animate({scrollTop: 0}, 800);
        return false;
    });
    
    /*--------------------------------------------------------
    / 6. All PopUP
    /--------------------------------------------------------*/
    popup_video.lightcase({
        transition: 'elastic',
        showSequenceInfo: false,
        slideshow: false,
        swipe: true,
        showTitle: false,
        showCaption: false,
        controls: true
    });
    popup_img.lightcase({
        transition: 'elastic',
        showSequenceInfo: false,
        slideshow: true,
        swipe: true,
        showTitle: false,
        controls: true
    });
    $('.search_btn').on('click', function (e) {
        e.preventDefault();
        $('.popup_search_sec').toggleClass('active');
    });
    $('.popup_search_overlay').on('click', function () {
        $('.popup_search_sec').removeClass('active');
    });
    $('.popup_search_form input').on('focus', function(){
        $('.popup_search_form').addClass('focused');
    });
    $('.popup_search_form input').on('blur', function(){
        $('.popup_search_form').removeClass('focused');
    });

    $('.priceToggle').on('click', function(e){
        var $this = $(this);
        var $price = $('.'+$this.attr('data-toggleclass'));
        $this.siblings('.priceToggle').removeClass('active');
        $this.addClass('active');
        
        $price.siblings('.price_period').removeClass('active');
        $price.addClass('active');
    });
    
    /*--------------------------------------------------------
    / 7. Sticky Header
    /---------------------------------------------------------*/
    if($(".isSticky").length > 0){
        var header_height = $(".isSticky").height();
        $(window).on('scroll', function(){
            if($(window).scrollTop() > 300){
                $(".isSticky").addClass('fixedHeader animated slideInDown');
            }else{
                $(".isSticky").removeClass('fixedHeader animated slideInDown');
            }
        });
    }
    
    /*--------------------------------------------------------
    / 8. Mobile Menu
    /---------------------------------------------------------*/
    $('.mainMenu ul li.menu-item-has-children > a').on('click', function(e){
        e.preventDefault();
        $(this).siblings('ul').slideToggle();
    });
    $('.menu_btn').on('click', function(e){
        e.preventDefault();
        $('.mainMenu').slideToggle();
        $(this).toggleClass('active');
    });
    
    /*--------------------------------------------------------
    / 9. Preloader
    /---------------------------------------------------------*/
    $(window).on('load', function () {
        var preload = $('.preloader');
        if (preload.length > 0) {
            preload.delay(800).fadeOut('slow');
        }
    });

    /*--------------------------------------------------------
    / 10. Select
    /---------------------------------------------------------*/
    if (categoryDropdown.length > 0) {
        categoryDropdown.niceSelect();
        categoryDropdown.parent().addClass('select-area');

        categoryDropdown.on('change', function () {
            var $this = $(this);
            var url = $this.find(':selected').attr('data-termurl');
            if (url != '#') {
                window.location.href = url;
            }
        });
    }
    if (select.length > 0) {
        select.niceSelect();
        select.parent().addClass('select-area');
    };

    if (variationSelect.length > 0) {
        variationSelect.niceSelect();
    };
    $('body').on('click', '.reset_variations', function () {
        variationSelect.niceSelect('update');
    });
    
    /*--------------------------------------------------------
    / 11. Google Maps
    /----------------------------------------------------------*/
    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction('frontend/element_ready/tw-google-map.default', function ($scope, $) {
            var $gmap = $scope.find('.google_map');
            if (!$gmap.length) {
                return;
            }
            $gmap.each(function () {
                var $this = $(this);
                var gmapid = $this.attr('id');
                var $g_map_this = $('#' + gmapid);

                var marker = $g_map_this.attr('data-marker');
                var zoom = parseInt($g_map_this.attr('data-zoom'), 10);
                var style = parseInt($g_map_this.attr('data-map-style'), 10);

                var coordinates = $g_map_this.attr('data-coordinates');
                var coordinates = $.parseJSON(coordinates);
                var primary_lat = '';
                var primary_lon = '';
                var i = 1;
                for (let value of Object.values(coordinates)) {
                    if (i == 1) {
                        primary_lat = value.lati;
                        primary_lon = value.long;
                    }
                    i++;
                }

                var map;
                map = new GMaps({
                    el: '#' + gmapid,
                    lat: primary_lat,
                    lng: primary_lon,
                    scrollwheel: false,
                    zoom: zoom,
                    zoomControl: true,
                    panControl: false,
                    streetViewControl: true,
                    mapTypeControl: true,
                    overviewMapControl: false,
                    clickable: false
                });
                var image = "";
                var i = 1;
                for (let value of Object.values(coordinates)) {
                    if (i == 1) {
                        map.addMarker({
                            lat: value.lati,
                            lng: value.long,
                            icon: marker,
                            animation: google.maps.Animation.DROP,
                            verticalAlign: "bottom",
                            horizontalAlign: "center",
                            backgroundColor: "#d3cfcf"
                        });
                    } else {
                        map.addMarker({
                            lat: value.lati,
                            lng: value.long,
                            icon: marker,
                            animation: google.maps.Animation.DROP,
                            backgroundColor: "#d3cfcf"
                        });
                    }
                    i++;
                }
                if (style != 1) {
                    var styles = [
                        {
                            "featureType": "road",
                            "stylers": [
                                {"color": "#9dbb91"}
                            ]
                        }, {
                            "featureType": "water",
                            "stylers": [
                                {"color": "#aacbd9"}
                            ]
                        }, {
                            "featureType": "landscape",
                            "stylers": [
                                {"color": "#ebf1e9"}
                            ]
                        }, {
                            "elementType": "labels.text.fill",
                            "stylers": [
                                {"color": "#2c2c2c"}
                            ]
                        }, {
                            "featureType": "poi",
                            "stylers": [
                                {"color": "#ceddc8"}
                            ]
                        }, {
                            "elementType": "labels.text",
                            "stylers": [
                                {"saturation": 1},
                                {"weight": 0.1},
                                {"color": "#2c2c2c"}
                            ]
                        }

                    ];
                    map.addStyle({
                        styledMapName: "Styled Map",
                        styles: styles,
                        mapTypeId: "map_style"
                    });
                    map.setStyle("map_style");
                }
            });
        });
    });

    /*--------------------------------------------------------
    / 13. Filter & Suffle
    /---------------------------------------------------------*/
    $(window).on('load', function () {
        if ($(".shaff_grid").length > 0)
        {
            var $grid = $('.shaff_grid');
            $grid.shuffle({
                itemSelector: '.shaff_item',
                sizer: '.shaff_size'
            });
            $('.shaff_filter li').on('click', function () {
                $('.shaff_filter li').removeClass('active');
                $(this).addClass('active');
                var groupName = $(this).attr('data-group');
                $grid.shuffle('shuffle', groupName);
            });
        }
    });

    /*--------------------------------------------------------
    / 14. Popup Menu
    /---------------------------------------------------------*/
    $('.popup_togggle_menu').on('click', function(e) {
        e.preventDefault();
        $("body").addClass("menu__open");
        $('.popup_menu').addClass('active').fadeIn();
        setTimeout(function() {
            if ($('.popup_menu').hasClass('active')) {
                var tlMenu = new TimelineLite();
                tlMenu.set($(".animated_menu"), {
                    y: 80,
                    opacity: 0
                });
                $(".animated_menu").each(function(index, element) {
                    tlMenu.to(element, 0.5, {
                        y: 0,
                        opacity: 1,
                        delay: 0.4,
                        ease: Power2.easeOut
                    }, index * 0.1)
                });
            } else {
                var tlMenu = new TimelineLite();
                $(".animated_menu").each(function(index, element) {
                    tlMenu.to(element, 0.25, {
                        y: -80,
                        opacity: 0,
                        ease: Power2.easeIn
                    }, index * 0.05)
                });
            }
        }, 20)
    });
    $('#close_menu').on('click', function() {
        $("body").removeClass("menu__open");
        var tlMenu = new TimelineLite();
        $(".animated_menu").each(function(index, element) {
            tlMenu.to(element, 0.25, {
                y: -80,
                opacity: 0,
                ease: Power2.easeIn
            }, index * 0.05)
        });
        setTimeout(function() {
            $('.popup_menu').fadeOut()
        }, 500)
    });
    $(window).on("load resize", function (e) {
        if ($(window).width() < 1199) {
            $('.menu_popup ul li.menu-item-has-children > a').on('click', function(e){
                e.preventDefault();
                $(this).siblings('ul').stop(true, true).slideToggle();
                $(this).parent().toggleClass('active');
            });
        };
    });

    /*--------------------------------------------------------
    / 15. Strech Column
    /---------------------------------------------------------*/
    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction('frontend/element_ready/tw-video-btn.default', function ($scope, $) {
            var strech = $scope.find('.tw-stretch-element-inside-column');
            if (!strech.length) {
                return;
            }
            tw_stretch();
        });
    });
    function tw_stretch() {
        var i = $(window).width();
        $(".elementor-section .tw-stretch-element-inside-column").each(function () {
            var $this = $(this),
                    row = $this.closest(".elementor-container"),
                    cols = $this.closest('.elementor-widget-container'),
                    rect = this.getBoundingClientRect(),
                    l = row[0].getBoundingClientRect(),
                    s = cols[0].getBoundingClientRect(),
                    r = rect.left,
                    d = i - rect.right,
                    c = l.left + (parseFloat(row.css("padding-left")) || 0),
                    u = i - l.right + (parseFloat(row.css("padding-right")) || 0),
                    p = s.left,
                    f = i - s.right,
                    styles = {
                        "margin-left": 0,
                        "margin-right": 0
                    };
            if (Math.round(c) === Math.round(p)) {
                var h = parseFloat($this.css("margin-left") || 0);
                styles["margin-left"] = h - r;
            }
            if (Math.round(u) === Math.round(f)) {
                var w = parseFloat($this.css("margin-right") || 0);
                styles["margin-right"] = w - d;
            }
            $this.css(styles);
        });
    }
    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction('frontend/element_ready/tw-about-image.default', function ($scope, $) {
            var strech = $scope.find('.tw-stretch-element-inside-column02');
            if (!strech.length) {
                return;
            }
            tw_stretch();
        });
    });
    function tw_stretch() {
        var i = $(window).width();
        $(".elementor-section .tw-stretch-element-inside-column02").each(function () {
            var $this = $(this),
                    row = $this.closest(".elementor-container"),
                    cols = $this.closest('.elementor-widget-container'),
                    rect = this.getBoundingClientRect(),
                    l = row[0].getBoundingClientRect(),
                    s = cols[0].getBoundingClientRect(),
                    r = rect.left,
                    d = i - rect.right,
                    c = l.left + (parseFloat(row.css("padding-left")) || 0),
                    u = i - l.right + (parseFloat(row.css("padding-right")) || 0),
                    p = s.left,
                    f = i - s.right,
                    styles = {
                        "margin-left": 0,
                        "margin-right": 0
                    };
            if (Math.round(c) === Math.round(p)) {
                var h = parseFloat($this.css("margin-left") || 0);
                styles["margin-left"] = h - r;
            }
            if (Math.round(u) === Math.round(f)) {
                var w = parseFloat($this.css("margin-right") || 0);
                styles["margin-right"] = w - d;
            }
            $this.css(styles);
        });
    }

    /*--------------------------------------------------------
    / 16. Qty
    /----------------------------------------------------------*/
    $("body").on('click', '.btnMinus, .btnPlus', function (e) {
        e.preventDefault();
        let cart_qty = $(this).closest('.pdq_main').find('.carqty'),
            vals = parseInt(cart_qty.val(), 10),
            step = parseInt(cart_qty.attr('step'), 10);
        var min_qty = cart_qty.attr('min');
        let min;
        if (typeof min_qty !== 'undefined' && min_qty !== false && min_qty != ''){
            min = min_qty;
        }else{
            min = 1;
        }
        if (!vals || vals === '' || vals === undefined || isNaN(vals)) vals = 0;
        if (!step || step === '' || step === undefined || isNaN(step)) step = 1;
        if ($(this).is('.btnMinus')) {
            if (vals > 1) {
                vals -= step;
                cart_qty.val(vals).trigger('change');
            } else {
                cart_qty.val(min).trigger('change');
            }
        } else {
            vals += step;
            cart_qty.val(vals).trigger('change');
        }
    });

    /*--------------------------------------------------------
     / 17. Sidebar Menu
     /--------------------------------------------------------*/
     var tt = true;
    $(".popup_togggle_menu02").on('click', function(e) {
        e.preventDefault();
        if (tt){
            $(this).addClass('active');
            $('body').addClass('menuOpened');
            tt = false;
        }else{
            $(this).removeClass('active');
            $('body').removeClass('menuOpened');
            tt = true;
        }
    });
    if ($(".sidebar_menu").length > 0){
        $(".sidebar_menu ul li.menu-item-has-children > a").on('click', function (e) {
            e.preventDefault();
            if ($(this).parent('li').hasClass('active')){
                $(this).parent('li').removeClass('active');
                $(this).next('ul').slideToggle();
            } else {
                $(this).siblings('ul').slideToggle();
                $(this).parent('li').addClass('active');
            }
        });
    }
    $(window).on("load",function(){
        $(".sidebar_menu > ul").mCustomScrollbar({
            setHeight:300
        });
    });
    
    /*--------------------------------------------------------
    / 13. Masonry
    /---------------------------------------------------------*/
    $(window).on('load', function() {
        if ($(".grid").length > 0) {
            $('.grid').masonry({
                itemSelector: '.grid-item',
                columnWidth: '.grid-sizer',
            });
        }
    });

    /*--------------------------------------------------------
    / 17. Accordina Toggler
    /--------------------------------------------------------*/
    $('.bepAccordion .card-header').on('click', function () {
        var $this = $(this);
        $('.bepAccordion .card').removeClass('activeBg');
        if ($('button', $this).hasClass('collapsed')) {
            $this.parent('.faqInner').parent('.card').addClass('activeBg');
        } else {
            $this.parent('.faqInner').parent('.card').removeClass('activeBg');
        }
    });

})(jQuery);