<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Video_Btn_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-video-btn';
    }
    
    public function get_title() {
        return esc_html__( 'Video Btn & Banner', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-favorite';
    }

    public function get_categories() {
        return [ 'bepro-elements' ];
    }
    
    protected function register_controls() {
        $this->start_controls_section(
            'section_tab_1',
            [
                'label'     => esc_html__('Video', 'themewar')
            ]
        );
        $this->add_control(
                'video_style',
                [
                        'label'     => esc_html__( 'Video Btn Style', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 1,
                        'options'   => [
                                1       => esc_html__( 'Only Btn', 'themewar' ),
                                2       => esc_html__( 'Banner Style', 'themewar' ),
                                3       => esc_html__( 'Btn With Title', 'themewar' ),
                                4       => esc_html__( 'Banner Style 02', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'animation_style',
                [
                        'label'     => esc_html__( 'Animation Style', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 1,
                        'options'   => [
                                1       => esc_html__( 'Border Animation', 'themewar' ),
                                2       => esc_html__( 'BG Animation 01', 'themewar' ),
                                3       => esc_html__( 'BG Animation 02', 'themewar' ),
                        ],
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'video_style',
                                        'operator'  => '!in',
                                        'value'     => ['3', '4'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'vbg_img',
                [
                        'label'         => esc_html__( 'Video BG Image', 'themewar' ),
                        'type'          => Controls_Manager::MEDIA,
                        'description'   => esc_html__('Upload you video banner bg image here.', 'themewar'),
                        'conditions'    => [
                                'terms' => [
                                    [
                                            'name'      => 'video_style',
                                            'operator'  => '!in',
                                            'value'     => ['1', '3'],
                                    ]
                                ],
                        ],
                        
                ]
        );
        $this->add_control(
                'is_stretch',
                [
                        'label'             => esc_html__( 'Is Stretch Image?', 'themewar' ),
                        'type'              => Controls_Manager::SWITCHER,
                        'label_on'          => esc_html__( 'Yes', 'themewar' ),
                        'label_off'         => esc_html__( 'No', 'themewar' ),
                        'description'       => esc_html__('Do you want to stretch image inner column?', 'themewar'),
                        'return_value'      => 'yes',
                        'default'           => 'no',
                        'conditions'        => [
                            'terms'         => [
                                [
                                        'name'      => 'video_style',
                                        'operator'  => '==',
                                        'value'     => '2',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'video_icons',
                [
                        'label'         => esc_html__( 'Icon', 'themewar' ),
                        'type'          => Controls_Manager::ICON,
                        'label_block'   => TRUE,
                ]
        );
        $this->add_control(
            'v_title', [
                'label'             => esc_html__( 'Btn Title', 'themewar' ),
                'type'              => Controls_Manager::TEXTAREA,
                'label_block'       => true,
                'default'           => esc_html__( 'insert video btn title.', 'themewar' ),
                'conditions'    => [
                        'terms' => [
                            [
                                    'name'      => 'video_style',
                                    'operator'  => 'in',
                                    'value'     => ['3', '4'],
                            ]
                        ],
                ],
            ]
        );
        $this->add_control(
                'video_url',
                [
                        'label'       => esc_html__( 'Video URL', 'themewar' ),
                        'type'        => Controls_Manager::TEXTAREA,
                        'rows'        => 10,
                        'default'     => '',
                        'description' => esc_html__( 'Insert your video url here.', 'themewar' ),
                ]
        );
        $this->add_responsive_control(
                'video_align', [
                        'label'                     =>esc_html__( 'Alignment', 'themewar' ),
                        'type'                      => Controls_Manager::CHOOSE,
                        'options'                   => [
                                'left'       => [
                                        'title'  => esc_html__( 'Left', 'themewar' ),
                                        'icon'   => 'eicon-text-align-left',
                                ],
                                'center'     => [
                                        'title'  => esc_html__( 'Center', 'themewar' ),
                                        'icon'   => 'eicon-text-align-center',
                                ],
                                'right'      => [
                                        'title'  => esc_html__( 'Right', 'themewar' ),
                                        'icon'   => 'eicon-text-align-right',
                                ]
                        ],
                        'default'                   => 'center',
                        'prefix_class'              => 'video_align elementor%s-align-',
                        'conditions'    => [
                                'terms' => [
                                    [
                                            'name'      => 'video_style',
                                            'operator'  => '==',
                                            'value'     => '1',
                                    ]
                                ],
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_img',[
                    'label'         => esc_html__('Image Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'video_style',
                                    'operator'  => '!in',
                                    'value'     => ['1', '3'],
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
                'v_img_width',
                [
                        'label' => esc_html__( 'Width', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .videoBG img' => 'width: {{SIZE}}{{UNIT}} !important;',
                                '{{WRAPPER}} .tabVideo img' => 'width: {{SIZE}}{{UNIT}} !important;',
                        ],
                ]
            );
            $this->add_responsive_control(
                'v_img_height',
                [
                        'label' => esc_html__( 'Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .videoBG img' => 'height: {{SIZE}}{{UNIT}} !important;',
                                '{{WRAPPER}} .tabVideo img' => 'height: {{SIZE}}{{UNIT}} !important;',
                        ],
                ]
        );
        $this->add_control(
                'v_img_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .videoBG img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .tabVideo img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name' => 'v_img_box_shadow',
                        'label' => esc_html__( 'Box Shadow', 'themewar' ),
                        'selector' => '{{WRAPPER}} .videoBG img, {{WRAPPER}} .tabVideo img',
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_2', [
                'label'  => esc_html__( 'Btn Style', 'themewar' ),
                'tab'    => Controls_Manager::TAB_STYLE,
                'conditions'    => [
                    'terms'     => [
                        [
                                'name'      => 'video_style',
                                'operator'  => '!in',
                                'value'     => ['3', '4'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_control(
                'video_btn_height',
                [
                        'label' => esc_html__( 'BTN Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .popup_video' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
                'video_btn_width',
                [
                        'label' => esc_html__( 'BTN Width', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .popup_video' => 'width: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
                'video_btn_lineheight',
                [
                        'label' => esc_html__( 'BTN Line Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range'     => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                        'step' => 1,
                                ],
                        ],
                        '%' => [
                                'min' => 0,
                                'max' => 100,
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .popup_video' => 'line-height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'video_icon_btn_typography',
                        'label'     => esc_html__( 'Icon Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .popup_video',
                ]
        );
        $this->add_control(
            'btn_border_radius',
            [
                    'label' => esc_html__( 'Border Radius', 'themewar' ),
                    'type'  => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .popup_video'  => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .popup_video i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_control(
                'btn_paddings',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .popup_video' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'btn_left',
                [
                        'label'      => esc_html__( 'Left', 'themewar' ),
                        'type'       => Controls_Manager::SLIDER,
                        'size_units' => [ '%' ],
                        'range'      => [
                                '%'  => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default'   => [],
                        'selectors' => [
                                '{{WRAPPER}} .popup_video' => 'left: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'btn_top',
                [
                        'label'      => esc_html__( 'Top', 'themewar' ),
                        'type'       => Controls_Manager::SLIDER,
                        'size_units' => [ '%' ],
                        'range'      => [
                                '%'  => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default'   => [],
                        'selectors' => [
                                '{{WRAPPER}} .popup_video' => 'top: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->start_controls_tabs('section_tabing_1');
            $this->start_controls_tab(
                    'btn_style_normal',
                    [
                            'label'     => esc_html__( 'Normal', 'themewar' ),
                    ]
            );
                $this->add_control(
                        'btn_color',
                        [
                                'label' => esc_html__( 'Icon Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .popup_video' => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                                'name' => 'v_btn_bg_color',
                                'label' => esc_html__( 'Background', 'themewar' ),
                                'types' => [ 'classic', 'gradient'],
                                'selector' => '{{WRAPPER}} .popup_video',
                                'conditions'    => [
                                    'terms'     => [
                                        [
                                                'name'      => 'video_style',
                                                'operator'  => '!in',
                                                'value'     => ['2'],
                                        ]
                                    ],
                                ],
                        ]
                );
                $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                                'name' => 'v_btn_i_bg_color',
                                'label' => esc_html__( 'Background', 'themewar' ),
                                'types' => [ 'classic', 'gradient'],
                                'selector' => '{{WRAPPER}} .popup_video i',
                                'conditions'    => [
                                    'terms'     => [
                                        [
                                                'name'      => 'video_style',
                                                'operator'  => '==',
                                                'value'     => '2',
                                        ]
                                    ],
                                ],
                        ]
                );
                $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                                'name' => 'btn_box_border',
                                'label' => esc_html__( 'Border', 'themewar' ),
                                'selector' => '{{WRAPPER}} .popup_video',
                        ]
                );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'btn_style_hover',
                    [
                            'label'     => esc_html__( 'Hover', 'themewar' ),
                    ]
            );
                $this->add_control(
                        'btn_color_hover',
                        [
                                'label' => esc_html__( 'Icon Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .popup_video:hover' => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                                'name' => 'v_btn_bg_color_hover',
                                'label' => esc_html__( 'Background', 'themewar' ),
                                'types' => [ 'classic', 'gradient'],
                                'selector' => '{{WRAPPER}} .popup_video:hover',
                                'conditions'    => [
                                    'terms'     => [
                                        [
                                                'name'      => 'video_style',
                                                'operator'  => '!in',
                                                'value'     => ['2'],
                                        ]
                                    ],
                                ],
                        ]
                );
                $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                                'name' => 'v_btn_hover_i_bg_color',
                                'label' => esc_html__( 'Background', 'themewar' ),
                                'types' => [ 'classic', 'gradient'],
                                'selector' => '{{WRAPPER}} .popup_video:hover i',
                                'conditions'    => [
                                    'terms'     => [
                                        [
                                                'name'      => 'video_style',
                                                'operator'  => '==',
                                                'value'     => '2',
                                        ]
                                    ],
                                ],
                        ]
                );
                $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                                'name' => 'btn_box_border_hover',
                                'label' => esc_html__( 'Border', 'themewar' ),
                                'selector' => '{{WRAPPER}} .popup_video:hover',
                        ]
                );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_5', [
                'label'  => esc_html__( 'Btn Style', 'themewar' ),
                'tab'    => Controls_Manager::TAB_STYLE,
                'conditions'    => [
                    'terms'     => [
                        [
                                'name'      => 'video_style',
                                'operator'  => 'in',
                                'value'     => ['3', '4'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_control(
                'video_btn2_height',
                [
                        'label' => esc_html__( 'BTN Icon Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .popup_video.withText i' => 'height: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .tabVideo .popup_video' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
                'video_btn2_width',
                [
                        'label' => esc_html__( 'BTN Icon Width', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .popup_video.withText i' => 'width: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .tabVideo .popup_video' => 'width: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
                'video_btn2_lineheight',
                [
                        'label' => esc_html__( 'BTN Icon Line Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range'     => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                        'step' => 1,
                                ],
                        ],
                        '%' => [
                                'min' => 0,
                                'max' => 100,
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .popup_video.withText i' => 'line-height: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .tabVideo .popup_video' => 'line-height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'video_icon_btn2_typography',
                        'label'     => esc_html__( 'Icon Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .popup_video.withText i, {{WRAPPER}} .tabVideo .popup_video',
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'video_text_btn2_typography',
                        'label'     => esc_html__( 'Text Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .popup_video.withText span, {{WRAPPER}} .tabVideo h5',
                ]
        );
        $this->add_control(
            'btn2_border_radius',
            [
                    'label' => esc_html__( 'Border Radius', 'themewar' ),
                    'type'  => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .popup_video.withText i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .tabVideo .popup_video' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_control(
                'btn2_paddings',
                [
                        'label' => esc_html__( 'Icon Paddings', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .popup_video.withText i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .tabVideo .popup_video' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
                'btn2_margin',
                [
                        'label' => esc_html__( 'Icon Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .popup_video.withText i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .tabVideo .popup_video' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
                'btn2_text_margin',
                [
                        'label' => esc_html__( 'Text Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .popup_video.withText span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .tabVideo h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->start_controls_tabs('section_tabing_12');
            $this->start_controls_tab(
                    'btn2_style_normal',
                    [
                            'label'     => esc_html__( 'Icon Normal', 'themewar' ),
                    ]
            );
                $this->add_control(
                        'btn2_color',
                        [
                                'label' => esc_html__( 'Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .popup_video.withText i' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .tabVideo .popup_video' => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                                'name' => 'v_btn2_bg_color',
                                'label' => esc_html__( 'Background', 'themewar' ),
                                'types' => [ 'classic', 'gradient'],
                                'selector' => '{{WRAPPER}} .popup_video.withText i, {{WRAPPER}} .tabVideo .popup_video',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                                'name' => 'btn2_box_border',
                                'label' => esc_html__( 'Border', 'themewar' ),
                                'selector' => '{{WRAPPER}} .popup_video.withText i, {{WRAPPER}} .tabVideo .popup_video',
                        ]
                );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'btn2_style_hover',
                    [
                            'label'     => esc_html__( 'Icon Hover', 'themewar' ),
                    ]
            );
                $this->add_control(
                        'btn2_color_hover',
                        [
                                'label' => esc_html__( 'Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .popup_video.withText:hover i' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .tabVideo .popup_video:hover' => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                                'name' => 'v_btn2_bg_color_hover',
                                'label' => esc_html__( 'Background', 'themewar' ),
                                'types' => [ 'classic', 'gradient'],
                                'selector' => '{{WRAPPER}} .popup_video.withText:hover i, {{WRAPPER}} .tabVideo .popup_video:hover',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                                'name' => 'btn2_box_border_hover',
                                'label' => esc_html__( 'Border', 'themewar' ),
                                'selector' => '{{WRAPPER}} .popup_video.withText:hover i, {{WRAPPER}} .tabVideo .popup_video:hover',
                        ]
                );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->start_controls_tabs('section_tabing_15');
            $this->start_controls_tab(
                    'btn2text_style_normal',
                    [
                            'label'     => esc_html__( 'Text Normal', 'themewar' ),
                    ]
            );
            $this->add_control(
                    'btn2text_color',
                    [
                            'label' => esc_html__( 'Color', 'themewar' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .popup_video.withText' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .tabVideo h5' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'btn2text_style_hover',
                    [
                            'label'     => esc_html__( 'Text Hover', 'themewar' ),
                    ]
            );
            $this->add_control(
                    'btn2text_color_hover',
                    [
                            'label' => esc_html__( 'Color', 'themewar' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .popup_video.withText:hover' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .tabVideo:hover h5' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_3', [
                'label'  => esc_html__( 'Btn Animation Style', 'themewar' ),
                'tab'    => Controls_Manager::TAB_STYLE,
                'conditions'    => [
                    'terms'     => [
                        [
                                'name'      => 'video_style',
                                'operator'  => '!in',
                                'value'     => ['3', '4'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
                'v_anim_width',
                [
                        'label' => esc_html__( 'Width', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                            '{{WRAPPER}} .borAnim::before' => 'width: {{SIZE}}{{UNIT}};',
                            '{{WRAPPER}} .borAnim::after'  => 'width: {{SIZE}}{{UNIT}};',
                            '{{WRAPPER}} .bgAnim02:after'  => 'width: {{SIZE}}{{UNIT}};',
                        ],
                ]
            );
            $this->add_responsive_control(
                'v_anim_height',
                [
                        'label' => esc_html__( 'Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                            '{{WRAPPER}} .borAnim::before' => 'height: {{SIZE}}{{UNIT}};',
                            '{{WRAPPER}} .borAnim::after'  => 'height: {{SIZE}}{{UNIT}};',
                            '{{WRAPPER}} .bgAnim02:after'  => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'anim_btn_left',
                [
                        'label'      => esc_html__( 'Left', 'themewar' ),
                        'type'       => Controls_Manager::SLIDER,
                        'size_units' => [ '%' ],
                        'range'      => [
                                '%'  => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default'   => [],
                        'selectors' => [
                            '{{WRAPPER}} .borAnim::before' => 'left: {{SIZE}}{{UNIT}};',
                            '{{WRAPPER}} .borAnim::after'  => 'left: {{SIZE}}{{UNIT}};',
                            '{{WRAPPER}} .bgAnim02:after'  => 'left: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'anim_btn_top',
                [
                        'label'      => esc_html__( 'Top', 'themewar' ),
                        'type'       => Controls_Manager::SLIDER,
                        'size_units' => [ '%' ],
                        'range'      => [
                                '%'  => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default'   => [],
                        'selectors' => [
                            '{{WRAPPER}} .borAnim::before' => 'top: {{SIZE}}{{UNIT}};',
                            '{{WRAPPER}} .borAnim::after'  => 'top: {{SIZE}}{{UNIT}};',
                            '{{WRAPPER}} .bgAnim02:after'  => 'top: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
            'anim_border_radius',
            [
                    'label' => esc_html__( 'Border Radius', 'themewar' ),
                    'type'  => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .borAnim::before'  => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .borAnim::after'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .bgAnim02:after'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
                'anim_color',
                [
                        'label' => esc_html__( 'Animation Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .borAnim::before'  => 'border-color: {{VALUE}}',
                                '{{WRAPPER}} .borAnim::after'   => 'border-color: {{VALUE}}',
                                '{{WRAPPER}} .bgAnim02::after' => 'background: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'anim_hover_color',
                [
                        'label' => esc_html__( 'Animation Hover Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .borAnim:hover:before'  => 'border-color: {{VALUE}}',
                                '{{WRAPPER}} .borAnim:hover:after'   => 'border-color: {{VALUE}}',
                                '{{WRAPPER}} .bgAnim02:hover:after' => 'background: {{VALUE}}',
                        ],
                ]
        );
        $this->end_controls_section();
        
    }
    
    protected function render() {
        $settings    = $this->get_settings_for_display();
        $animation   = (isset($settings['animation_style']) && $settings['animation_style'] > 0) ? $settings['animation_style'] : 1;
        $video_style = (isset($settings['video_style']) && $settings['video_style'] > 0) ? $settings['video_style'] : 1;

        $video_icons = (isset($settings['video_icons']) && $settings['video_icons'] != '') ? $settings['video_icons'] : 'twi-play'; 
        $v_title     = (isset($settings['v_title']) && $settings['v_title'] != '') ? $settings['v_title'] : ''; 
        $video_url   = (isset($settings['video_url']) && $settings['video_url'] != '') ? $settings['video_url'] : 'https://player.vimeo.com/video/213907368?h=3685456d6c'; 
        $vbg_img     = (isset($settings['vbg_img']['url']) && $settings['vbg_img']['url'] != '') ? $settings['vbg_img']['url'] : '';

        $is_stretch  = (isset($settings['is_stretch']) && !empty($settings['is_stretch']) ? $settings['is_stretch'] : 'no');

        $anim = '';
        if($animation == 1):
            $anim .= 'borAnim';
        elseif($animation == 3):
            $anim .= 'bgAnim02';
        else:
            $anim .= 'bgAnim';
        endif;
        include dirname(__FILE__).'/style/video/style'.$video_style.'.php';
        
    }
    
    protected function content_template() {
        
    }
}