<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Testimonial_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-testimonial';
    }
    public function get_title() {
        return esc_html__( 'Testimonial', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-testimonial';
    }

    public function get_categories() {
        return [ 'bepro-elements' ];
    }
    
    protected function register_controls() {

        $this->start_controls_section(
            'section_tab_1', [
                'label' => esc_html__( 'Testimonial', 'themewar' ),
            ]
        );
        $this->add_control(
                'testimonial_style',
                [
                        'label'     => esc_html__( 'Testimonial Style', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 1,
                        'options'   => [
                                1       => esc_html__( 'Slider Style 01', 'themewar' ),
                                2       => esc_html__( 'Slider Style 02', 'themewar' ),
                                3       => esc_html__( 'Slider Style 03', 'themewar' ),
                                4       => esc_html__( 'Slider Style 04', 'themewar' ),
                                5       => esc_html__( 'Slider Style 05', 'themewar' ),
                                6       => esc_html__( 'Slider Style 06', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'sub_title',
                [
                        'label'         => esc_html__( 'Section Sub Title', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'label_block'   => true,
                        'placeholder'   => esc_html__('Insert your testimony section sub title.', 'themewar'),
                        'conditions'        => [
                            'terms'         => [
                                [
                                        'name'      => 'testimonial_style',
                                        'operator'  => '==',
                                        'value'     => '3',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'main_title',
                [
                        'label'         => esc_html__( 'Section Main Title', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'label_block'   => true,
                        'placeholder'   => esc_html__('Insert your testimony section main title.', 'themewar'),
                        'conditions'        => [
                            'terms'         => [
                                [
                                        'name'      => 'testimonial_style',
                                        'operator'  => '==',
                                        'value'     => '3',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'description',
                [
                        'label'         => esc_html__( 'Section Description Title', 'themewar' ),
                        'type'          => Controls_Manager::TEXTAREA,
                        'label_block'   => true,
                        'placeholder'   => esc_html__('Insert your testimony section description.', 'themewar'),
                        'conditions'        => [
                            'terms'         => [
                                [
                                        'name'      => 'testimonial_style',
                                        'operator'  => '==',
                                        'value'     => '3',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'test_img',
                [
                        'label'         => esc_html__( 'Testimonial BG Image', 'themewar' ),
                        'type'          => Controls_Manager::MEDIA,
                        'description'   => esc_html__('upload your testmonial item bg area image. image size should be 505x504px.', 'themewar'),
                        'conditions'        => [
                            'terms'         => [
                                [
                                        'name'      => 'testimonial_style',
                                        'operator'  => '==',
                                        'value'     => '5',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'pfi_note',
                [
                        'label' => esc_html__( 'Important Note', 'themewar' ),
                        'type'  => Controls_Manager::RAW_HTML,
                        'raw'   => esc_html__( 'This style slider repeater item should be 4 or less.', 'themewar' ),
                        'content_classes' => 'alert alert-warning',
                        'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'testimonial_style',
                                        'operator'  => '==',
                                        'value'     => '5',
                                ]
                            ],
                        ],
                ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
                'author_rating',
                [
                        'label'         => esc_html__( 'Review Ratings', 'themewar' ),
                        'type'          => Controls_Manager::NUMBER,
                        'min'           => 0,
                        'max'           => 5,
                        'step'          => 1,
                        'default'       => 5,
                        'description'   => esc_html__('insert author review ratings. Rating Out of 5. This option work only for slider style 04.', 'themewar'),
                ]
        );
        $repeater->add_control(
                'quote_img',
                [
                        'label'         => esc_html__( 'Quote Image', 'themewar' ),
                        'type'          => Controls_Manager::MEDIA,
                        'description'   => esc_html__('This option work only for slider style 02 and 05.', 'themewar'),
                        'description'   => esc_html__('upload quote icon image bg.', 'themewar'),
                ]
        );
        $repeater->add_control(
                'ts_title',
                [
                        'label'         => esc_html__( 'Testimonial Top Title', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'label_block'   => true,
                        'description'   => esc_html__('This option work only for slider style 01.', 'themewar'),
                        'placeholder'   => esc_html__('Insert your testimony top title.', 'themewar')
                ]
        );
        $repeater->add_control(
                'quote',
                [
                        'label'         => esc_html__( 'Testimonial Quote', 'themewar' ),
                        'type'          => Controls_Manager::TEXTAREA,
                        'label_block'   => true,
                        'placeholder'   => esc_html__('Insert your testimony content.', 'themewar')
                ]
        );
        $repeater->add_control(
                'au_img',
                [
                        'label'         => esc_html__( 'Author Image', 'themewar' ),
                        'type'          => Controls_Manager::MEDIA,
                        'description'   => esc_html__('Upload square size image.', 'themewar'),
                ]
        );
        $repeater->add_control(
                'title',
                [
                        'label'         => esc_html__( 'Author Name', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'label_block'   => true,
                        'placeholder'   => esc_html__('Author Name', 'themewar')
                ]
        );
        $repeater->add_control(
                'designation',
                [
                        'label'         => esc_html__( 'Author Designation', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'label_block'   => true,
                        'description'   => esc_html__('This option not work for slider style 03 and 06.', 'themewar'),
                        'placeholder'   => esc_html__('Author Designation.', 'themewar')
                ]
        );
        $this->add_control(
            'testimony_list',
            [
                    'label'         => esc_html__( 'Testimonial Slider', 'themewar' ),
                    'type'          => Controls_Manager::REPEATER,
                    'fields'        => $repeater->get_controls(),
                    'default'       => [
                            [
                                    'author_rating'         => '5',
                                    'quote_img'             => '',
                                    'ts_title'              => '',
                                    'quote'                 => '',
                                    'au_img'                => '',
                                    'title'                 => '',
                                    'designation'           => '',
                            ],
                    ],
                    'title_field' => '{{{ title }}}',
            ]
        );
        $this->add_control(
                'testi_slide_autoplay',
                [
                        'label'             => esc_html__( 'Is Autoplay?', 'themewar' ),
                        'type'              => Controls_Manager::SWITCHER,
                        'label_on'          => esc_html__( 'Yes', 'themewar' ),
                        'label_off'         => esc_html__( 'No', 'themewar' ),
                        'description'       => esc_html__('Do you want to make this slider auto play?', 'themewar'),
                        'return_value'      => 'yes',
                        'default'           => 'yes',
                        'conditions'        => [
                            'terms'         => [
                                [
                                        'name'      => 'testimonial_style',
                                        'operator'  => '!in',
                                        'value'     => ['4', '5'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'client_slide_loop',
                [
                        'label'             => esc_html__( 'Is Loop?', 'themewar' ),
                        'type'              => Controls_Manager::SWITCHER,
                        'label_on'          => esc_html__( 'Yes', 'themewar' ),
                        'label_off'         => esc_html__( 'No', 'themewar' ),
                        'description'       => esc_html__('Do you want to make this slider item loop?', 'themewar'),
                        'return_value'      => 'yes',
                        'default'           => 'no',
                        'conditions'        => [
                            'terms'         => [
                                [
                                        'name'      => 'testimonial_style',
                                        'operator'  => '!in',
                                        'value'     => ['4', '5'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'client_slide_nav',
                [
                        'label'             => esc_html__( 'Is Nav?', 'themewar' ),
                        'type'              => Controls_Manager::SWITCHER,
                        'label_on'          => esc_html__( 'Yes', 'themewar' ),
                        'label_off'         => esc_html__( 'No', 'themewar' ),
                        'description'       => esc_html__('Do you want to show slider arrow navigation?', 'themewar'),
                        'return_value'      => 'yes',
                        'default'           => 'no',
                        'conditions'        => [
                            'terms'         => [
                                [
                                        'name'      => 'testimonial_style',
                                        'operator'  => '!in',
                                        'value'     => ['4', '5', '6'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'client_slide_dots',
                [
                        'label'             => esc_html__( 'Is Dots?', 'themewar' ),
                        'type'              => Controls_Manager::SWITCHER,
                        'label_on'          => esc_html__( 'Yes', 'themewar' ),
                        'label_off'         => esc_html__( 'No', 'themewar' ),
                        'description'       => esc_html__('Do you want to show slider bullets item?', 'themewar'),
                        'return_value'      => 'yes',
                        'default'           => 'no',
                        'conditions'        => [
                            'terms'         => [
                                [
                                        'name'      => 'testimonial_style',
                                        'operator'  => '!in',
                                        'value'     => ['4', '5', '6'],
                                ]
                            ],
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_subtitle', [
                    'label'             => esc_html__('Section Sub Title Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                    'conditions'        => [
                        'terms'         => [
                            [
                                    'name'      => 'testimonial_style',
                                    'operator'  => '==',
                                    'value'     => '3',
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
                'tst_subtitle_color',
                [
                        'label' => esc_html__( 'Color', 'themewar' ),
                        'type'  => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .testLeft .subTitle'  => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'tst_subtitle_typo',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .testLeft .subTitle',
                ]
        );
        $this->add_responsive_control(
                'tst_subtitle_margin',
                [
                        'label' => esc_html__( 'Margin', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .testLeft .subTitle'  => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_title', [
                    'label'             => esc_html__('Section Title Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                    'conditions'        => [
                        'terms'         => [
                            [
                                    'name'      => 'testimonial_style',
                                    'operator'  => '==',
                                    'value'     => '3',
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
                'tst_title_color',
                [
                        'label' => esc_html__( 'Color', 'themewar' ),
                        'type'  => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .testLeft .secTitle'  => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'tst_title_typo',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .testLeft .secTitle',
                ]
        );
        $this->add_responsive_control(
                'tst_title_margin',
                [
                        'label' => esc_html__( 'Margin', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .testLeft .secTitle '  => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_desc', [
                    'label'             => esc_html__('Section Description Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                    'conditions'        => [
                        'terms'         => [
                            [
                                    'name'      => 'testimonial_style',
                                    'operator'  => '==',
                                    'value'     => '3',
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
                'tst_desc_color',
                [
                        'label' => esc_html__( 'Color', 'themewar' ),
                        'type'  => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .testLeft p'  => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'tst_desc_typo',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .testLeft p',
                ]
        );
        $this->add_responsive_control(
                'tst_desc_margin',
                [
                        'label' => esc_html__( 'Margin', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .testLeft p '  => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_Bg_image', [
                    'label'             => esc_html__('BG Image Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                    'conditions'        => [
                        'terms'         => [
                            [
                                    'name'      => 'testimonial_style',
                                    'operator'  => '==',
                                    'value'     => '5',
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
                'ts_bg_area_radius',
                [
                        'label' => esc_html__( 'Area Radius', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .testibgThumb'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'ts_bg_area_image_radius',
                [
                        'label' => esc_html__( 'Image Area Radius', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .testibgThumb img'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'ts_bg_area_padding',
                [
                        'label' => esc_html__( 'Area Padding', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .testibgThumb'   => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name'      => 'ts_bg_area_border',
                        'label'     => esc_html__( 'Area Border', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .testibgThumb',
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name'      => 'ts_bg_area_image_border',
                        'label'     => esc_html__( 'Image Border', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .testibgThumb img',
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_200', [
                    'label'             => esc_html__('Area Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                ]
        );
        $this->add_responsive_control(
                'tst_area_padding',
                [
                        'label' => esc_html__( 'Padding', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .testimonialslider01.owl-carousel'   => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .testiItem03'   => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .testiWrap'   => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .testimonial_slider05'   => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .testimonialslider05'   => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'tst_area_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .testimonialslider01.owl-carousel'  => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .testiItem03'     => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .testiWrap'     => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .testimonial_slider05'     => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .testimonialslider05'     => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->start_controls_tabs('area_styling_tab');
            $this->start_controls_tab(
                    'area_styling_tab_normal', [
                        'label' => esc_html__('Normal', 'themewar'),
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name'  => 'tst_area_background',
                            'label' => esc_html__( 'Background', 'themewar' ),
                            'types' => [ 'classic' ],
                            'selector' => '{{WRAPPER}} .testimonialslider01.owl-carousel, {{WRAPPER}} .testiItem03, {{WRAPPER}} .testiWrap, {{WRAPPER}} .testimonial_slider05, {{WRAPPER}} .testimonialslider05:after',
                    ]
            );
            $this->add_control(
                'au_img_01',
                [
                    'label'     => esc_html__( 'Right Align Item BG Style', 'themewar' ),
                    'type'      => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'conditions'        => [
                        'terms'         => [
                            [
                                    'name'      => 'testimonial_style',
                                    'operator'  => '==',
                                    'value'     => '3',
                            ]
                        ],
                    ],
                ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name'  => 'tst_area_right_background',
                            'label' => esc_html__( 'Background', 'themewar' ),
                            'types' => [ 'classic' ],
                            'selector' => '{{WRAPPER}} .testiItem03.RightItem',
                            'conditions'        => [
                                'terms'         => [
                                    [
                                            'name'      => 'testimonial_style',
                                            'operator'  => '==',
                                            'value'     => '3',
                                    ]
                                ],
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'tst_area_radius',
                    [
                            'label' => esc_html__( 'Radius', 'themewar' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .testimonialslider01.owl-carousel'    => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .testiItem03'    => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .testiWrap'    => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .testimonial_slider05'    => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .testimonialslider05:after'    => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'tst_ara_shadow',
                            'label' => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .testimonialslider01.owl-carousel, {{WRAPPER}} .testiItem03, {{WRAPPER}} .testiWrap, {{WRAPPER}} .testimonial_slider05, {{WRAPPER}} .testimonialslider05:after',
                    ]
            );
            $this->end_controls_tab();
                $this->start_controls_tab(
                        'area_styling_tab_hover',
                        [
                                'label' => esc_html__( 'Hover', 'themewar' ),
                        ]
                );
                $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                                'name'  => 'tst_hover_area_background',
                                'label' => esc_html__( 'Background', 'themewar' ),
                                'types' => [ 'classic' ],
                                'selector' => '{{WRAPPER}} .testimonialslider01.owl-carousel:hover, {{WRAPPER}} .testiItem03:hover, {{WRAPPER}} .testiWrap:hover, {{WRAPPER}} .testimonial_slider05:hover, {{WRAPPER}} .testimonialslider05:hover:after',
                        ]
                );
                $this->add_control(
                    'au_img_02',
                    [
                        'label'     => esc_html__( 'Right Align Item BG Style', 'themewar' ),
                        'type'      => Controls_Manager::HEADING,
                        'separator' => 'before',
                        'conditions'        => [
                            'terms'         => [
                                [
                                        'name'      => 'testimonial_style',
                                        'operator'  => '==',
                                        'value'     => '3',
                                ]
                            ],
                        ],
                    ]
                );
                $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                                'name'  => 'tst_area_right_hover_background',
                                'label' => esc_html__( 'Background', 'themewar' ),
                                'types' => [ 'classic' ],
                                'selector' => '{{WRAPPER}} .testiItem03.RightItem:hover',
                                'conditions'        => [
                                    'terms'         => [
                                        [
                                                'name'      => 'testimonial_style',
                                                'operator'  => '==',
                                                'value'     => '3',
                                        ]
                                    ],
                                ],
                        ]
                );
                $this->add_responsive_control(
                        'tst_hover_area_radius',
                        [
                                'label' => esc_html__( 'Radius', 'themewar' ),
                                'type'  => Controls_Manager::DIMENSIONS,
                                'size_units' => [ 'px', '%', 'em' ],
                                'selectors' => [
                                    '{{WRAPPER}} .testimonialslider01.owl-carousel:hover'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                    '{{WRAPPER}} .testiItem03:hover'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                    '{{WRAPPER}} .testiWrap:hover'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                    '{{WRAPPER}} .testimonial_slider05:hover'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                    '{{WRAPPER}} .testimonialslider05:hover:after'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                ],
                        ]
                );
                $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                                'name'     => 'tst_hover_ara_shadow',
                                'label'    => esc_html__( 'Box Shadow', 'themewar' ),
                                'selector' => '{{WRAPPER}} .testimonialslider01.owl-carousel:hover, {{WRAPPER}} .testiItem03:hover, {{WRAPPER}} .testiWrap:hover, {{WRAPPER}} .testimonial_slider05:hover, {{WRAPPER}} .testimonialslider05:hover:after',
                        ]
                );
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_active_teim', [
                    'label'             => esc_html__('Active Item Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                    'conditions'        => [
                        'terms'         => [
                            [
                                    'name'      => 'testimonial_style',
                                    'operator'  => '==',
                                    'value'     => '6',
                            ]
                        ],
                    ],
                ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name'  => 'tst_aactive_hover_background',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic' ],
                        'selector' => '{{WRAPPER}} .testiItem06.slick-slide.slick-current.slick-active',
                ]
        );
        $this->add_responsive_control(
                'tst_active_area_radius',
                [
                        'label' => esc_html__( 'Radius', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .testiItem06.slick-slide.slick-current.slick-active'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name'     => 'tst_active_ara_shadow',
                        'label'    => esc_html__( 'Box Shadow', 'themewar' ),
                        'selector' => '{{WRAPPER}} .testiItem06.slick-slide.slick-current.slick-active',
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_ratings', [
                    'label'             => esc_html__('Ratings Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                    'conditions'        => [
                        'terms'         => [
                            [
                                    'name'      => 'testimonial_style',
                                    'operator'  => '==',
                                    'value'     => '4',
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
                'tst_ratings_color',
                [
                        'label' => esc_html__( 'Color', 'themewar' ),
                        'type'  => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .testimonialslider04 .ratings'  => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'tst_ratings_typo',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .testimonialslider04 .ratings',
                ]
        );
        $this->add_responsive_control(
                'tst_ratings_margin',
                [
                        'label' => esc_html__( 'Margin', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .testimonialslider04 .ratings'  => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_tst_title', [
                    'label'             => esc_html__('Testimonial Top Title Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                    'conditions'        => [
                        'terms'         => [
                            [
                                    'name'      => 'testimonial_style',
                                    'operator'  => '==',
                                    'value'     => '1',
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
                'tst_q3_tst_title',
                [
                        'label' => esc_html__( 'Color', 'themewar' ),
                        'type'  => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .testiItem01 > h5'  => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'tst_tst_title_typo',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .testiItem01 > h5',
                ]
        );
        $this->add_responsive_control(
                'tst_tst_title_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .testiItem01 > h5'  => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_qutation_three', [
                    'label'             => esc_html__('Quotation Content Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                ]
        );
        $this->add_responsive_control(
                'tst_q3_bh',
                [
                        'label' => esc_html__( 'Color', 'themewar' ),
                        'type'  => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .quatation'  => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'tst_q_typo',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .quatation',
                ]
        );
        $this->add_responsive_control(
                'tst_q3_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .quatation'  => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'tst_q3_padding',
                [
                        'label' => esc_html__( 'Padding', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .quatation'  => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_Quote_iocn', [
                    'label'             => esc_html__('Quote Icon Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                    'conditions'        => [
                        'terms'         => [
                            [
                                    'name'      => 'testimonial_style',
                                    'operator'  => '==',
                                    'value'     => '1',
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
                'tst_q5_bh',
                [
                        'label' => esc_html__( 'Color', 'themewar' ),
                        'type'  => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .testiItem06::before'  => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'tst_q5_typo',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .testiItem06::before',
                ]
        );
        $this->add_responsive_control(
                'tst_q5_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .testiItem06::before'  => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_20', [
                    'label'             => esc_html__('Author Image Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                ]
        );
        $this->add_responsive_control(
                'tst3_img_width',
                [
                        'label' => esc_html__( 'Width', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px'],
                        'range' => [
                                'px' => [
                                        'min'  => 0,
                                        'max'  => 400,
                                        'step' => 1,
                                ]
                        ],
                        'default' => [
                                'unit' => 'px',
                                'size' => '',
                        ],
                        'selectors' => [
                                '{{WRAPPER}} .testi_wrap .ts_author img' => 'width: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .ts02 .testiItem02 > img' => 'width: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .testiItem03 .au_quote img' => 'width: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .testimonialNav .slick-slide .autho_thumb img' => 'width: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .testiItem05 .ti_author img' => 'width: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .testiItem06 img' => 'width: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'tst3_img_height',
                [
                        'label' => esc_html__( 'Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px'],
                        'range' => [
                                'px' => [
                                        'min'  => 0,
                                        'max'  => 400,
                                        'step' => 1,
                                ]
                        ],
                        'default' => [
                                'unit' => 'px',
                                'size' => '',
                        ],
                        'selectors' => [
                                '{{WRAPPER}} .testi_wrap .ts_author img' => 'height: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .ts02 .testiItem02 > img'  => 'height: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .testiItem03 .au_quote img'  => 'height: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .testimonialNav .slick-slide .autho_thumb img'  => 'height: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .testiItem05 .ti_author img'  => 'height: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .testiItem06 img'  => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'tst3_area_radius',
                [
                        'label' => esc_html__( 'Radius', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .testi_wrap .ts_author img'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .ts02 .testiItem02 > img'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .testiItem03 .au_quote img'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .testimonialNav .slick-slide .autho_thumb img'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .testimonialNav .slick-slide .autho_thumb'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .testiItem05 .ti_author img'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .testimonial_slider05 .carousel-indicators li'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .testimonial_slider05 .carousel-indicators li img'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .testiItem06 img'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name'     => 'tst_image_shadow',
                        'label'    => esc_html__( 'Box Shadow', 'themewar' ),
                        'selector' => '{{WRAPPER}} .testi_wrap .ts_author img, {{WRAPPER}} .ts02 .testiItem02 > img, {{WRAPPER}} .testiItem03 .au_quote img, {{WRAPPER}} .testimonialNav .slick-slide.slick-current.slick-active.slick-center .autho_thumb, {{WRAPPER}} .testiItem05 .ti_author img, {{WRAPPER}} .testimonial_slider05 .carousel-indicators li, {{WRAPPER}} .testiItem06 img',
                ]
        );
        $this->add_control(
            'au_img_03',
            [
                'label'     => esc_html__( 'Icon Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
                'conditions'        => [
                    'terms'         => [
                        [
                                'name'      => 'testimonial_style',
                                'operator'  => '==',
                                'value'     => '3',
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
                'tst_q_icon_color',
                [
                        'label' => esc_html__( 'Fill Color', 'themewar' ),
                        'type'  => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .testiItem03 .au_quote i' => '-webkit-text-fill-color: {{VALUE}}',
                        ],
                        'conditions'        => [
                            'terms'         => [
                                [
                                        'name'      => 'testimonial_style',
                                        'operator'  => '==',
                                        'value'     => '3',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_responsive_control(
                'tst_q_icon_stroke_color',
                [
                        'label' => esc_html__( 'Stroke Color', 'themewar' ),
                        'type'  => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .testiItem03 .au_quote i' => '-webkit-text-stroke-color: {{VALUE}}',
                        ],
                        'conditions'        => [
                            'terms'         => [
                                [
                                        'name'      => 'testimonial_style',
                                        'operator'  => '==',
                                        'value'     => '3',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'tst_q_icon_typo',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .testiItem03 .au_quote i',
                        'conditions'        => [
                            'terms'         => [
                                [
                                        'name'      => 'testimonial_style',
                                        'operator'  => '==',
                                        'value'     => '3',
                                ]
                            ],
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_100', [
                    'label'             => esc_html__('Author Name Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE
                ]
        );
        $this->add_responsive_control(
                'tst_nm_color',
                [
                        'label' => esc_html__( 'Color', 'themewar' ),
                        'type'  => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .tsauhor' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'tst_nm_typo',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .tsauhor',
                ]
        );
        $this->add_responsive_control(
                'tst_nm_margin',
                [
                        'label' => esc_html__( 'Margin', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .tsauhor'  => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_04', [
                    'label'             => esc_html__('Designation Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                    'conditions'        => [
                        'terms'         => [
                            [
                                    'name'      => 'testimonial_style',
                                    'operator'  => '!in',
                                    'value'     => ['3', '6'],
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
                'tst_mt_color',
                [
                        'label' => esc_html__( 'Color', 'themewar' ),
                        'type'  => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .tsdesignation'  => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'tst_mt_typo',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .tsdesignation',
                ]
        );
        $this->add_responsive_control(
                'tst_mt_margin',
                [
                        'label' => esc_html__( 'Margin', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .tsdesignation'  => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_svg_nav', [
                    'label'             => esc_html__('Nav Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'testimonial_style',
                                    'operator'  => 'in',
                                    'value'     => ['3'],
                            ],
                            [
                                    'name'      => 'client_slide_nav',
                                    'operator'  => '==',
                                    'value'     => 'yes',
                            ]
                        ],
                    ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'nav_svg_typography',
                        'label'     => esc_html__( 'Icon Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .testi_wrap .tsArrows a'
                ]
        );
        $this->start_controls_tabs( 'nav_svg_styling_tab' );
            $this->start_controls_tab(
                    'nav_svg_styling_tab_normal',
                    [
                            'label' => esc_html__( 'Normal', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'bl_nav_svg_color',
                    [
                            'label' => esc_html__( 'Color', 'themewar' ),
                            'type'  => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .testi_wrap .tsArrows a' => 'color: {{VALUE}}'
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'bl_nav_svg_bg_color',
                    [
                            'label' => esc_html__( 'BG Color', 'themewar' ),
                            'type'  => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .testi_wrap .tsArrows a svg path' => 'fill: {{VALUE}}'
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Css_Filter::get_type(),
                    [
                            'name'      => 'box_svg_filter',
                            'label'     => esc_html__( 'BG Shadow', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .testi_wrap .tsArrows a svg',
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'nav_svg_styling_tab_hover',
                    [
                            'label' => esc_html__( 'Hover', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'bl_nav_svg_color_hover',
                    [
                            'label' => esc_html__( 'Nav Color', 'themewar' ),
                            'type'  => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .testi_wrap .tsArrows a:hover' => 'color: {{VALUE}}'
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'bl_nav_svg_hover_bg_color',
                    [
                            'label' => esc_html__( 'BG Color', 'themewar' ),
                            'type'  => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .testi_wrap .tsArrows a:hover svg path' => 'fill: {{VALUE}}'
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Css_Filter::get_type(),
                    [
                            'name'      => 'box_hover_svg_filter',
                            'label'     => esc_html__( 'BG Shadow', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .testi_wrap .tsArrows a:hover svg',
                    ]
            );
            $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_responsive_control(
                    'left_svg_nav_margin',
                    [
                            'label'      => esc_html__( 'Left Margin', 'themewar' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .testi_wrap .tsArrows a.prevArrow' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'right_svg_nav_margin',
                    [
                            'label'      => esc_html__( 'Right Margin', 'themewar' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .testi_wrap .tsArrows a.nextArrow' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_03', [
                    'label'             => esc_html__('Nav Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                    'conditions'        => [
                        'terms'         => [
                            [
                                'name'      => 'testimonial_style',
                                'operator'  => '!in',
                                'value'     => ['3', '6'],
                            ],
                            [
                                'name'      => 'client_slide_nav',
                                'operator'  => '==',
                                'value'     => 'yes',
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
                'nav_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .testi_wrap .owl-carousel .owl-nav button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .testimonial_slider05 .ccnav' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .testimonial_slider05 .ccnav:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                ]
        );
        $this->start_controls_tabs( 'nav_styling_tab' );
        $this->start_controls_tab(
                'nav_styling_tab_normal',
                [
                        'label' => esc_html__( 'Normal', 'themewar' ),
                ]
        );
        $this->add_responsive_control(
                'cl_nav_color',
                [
                        'label' => esc_html__( 'Nav Color', 'themewar' ),
                        'type'  => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .testi_wrap .owl-carousel .owl-nav button' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .testimonial_slider05 .ccnav' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name'      => 'cl_nav_bg',
                        'label'     => esc_html__( 'Background', 'themewar' ),
                        'types'     => [ 'classic', 'gradient'],
                        'selector'  => '{{WRAPPER}} .testi_wrap .owl-carousel .owl-nav button, {{WRAPPER}} .testimonial_slider05 .ccnav',
                ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name' => 'cl_nav_bg_shadow',
                        'label' => esc_html__( 'Boxs Shadow', 'themewar' ),
                        'selector' => '{{WRAPPER}} .testi_wrap .owl-carousel .owl-nav button, {{WRAPPER}} .testimonial_slider05 .ccnav',
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name' => 'cl_nav_bg_border',
                        'label' => esc_html__( 'Border', 'themewar' ),
                        'selector' => '{{WRAPPER}} .testi_wrap .owl-carousel .owl-nav button, {{WRAPPER}} .testimonial_slider05 .ccnav',
                ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
                'nav_styling_tab_hover',
                [
                        'label' => esc_html__( 'Hover', 'themewar' ),
                ]
        );
        $this->add_responsive_control(
                'cl_nav_color_hover',
                [
                        'label' => esc_html__( 'Nav Color', 'themewar' ),
                        'type'  => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .testi_wrap .owl-carousel .owl-nav button:hover' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .testimonial_slider05 .ccnav:hover' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name'      => 'cl_nav_bg_hover',
                        'label'     => esc_html__( 'Background', 'themewar' ),
                        'types'     => [ 'classic', 'gradient'],
                        'selector'  => '{{WRAPPER}} .testi_wrap .owl-carousel .owl-nav button:hover, {{WRAPPER}} .testimonial_slider05 .ccnav:after',
                ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name' => 'cl_nav_bg_shadow_hover',
                        'label' => esc_html__( 'Boxs Shadow', 'themewar' ),
                        'selector' => '{{WRAPPER}} .testi_wrap .owl-carousel .owl-nav button:hover, {{WRAPPER}} .testimonial_slider05 .ccnav:hover',
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name' => 'cl_nav_bg_border_hover',
                        'label' => esc_html__( 'Border', 'themewar' ),
                        'selector' => '{{WRAPPER}} .testi_wrap .owl-carousel .owl-nav button:hover, {{WRAPPER}} .testimonial_slider05 .ccnav:hover',
                ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_responsive_control(
                'arrwo_area_margin',
                [
                        'label'      => esc_html__( 'Area Margin', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .testi_wrap .owl-carousel .owl-nav' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'left_nav_margin',
                [
                        'label'      => esc_html__( 'Left Margin', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .testi_wrap .owl-carousel .owl-nav button.owl-prev' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .testimonial_slider05 .carousel-control-prev' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'right_nav_margin',
                [
                        'label'      => esc_html__( 'Right Margin', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .testi_wrap .owl-carousel .owl-nav button.owl-next' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .testimonial_slider05 .carousel-control-next' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_dots', [
                    'label'             => esc_html__('Dots Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                    'conditions'        => [
                        'terms'         => [
                            [
                                'name'      => 'client_slide_dots',
                                'operator'  => '==',
                                'value'     => 'yes',
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
                'dots_width',
                [
                        'label' => esc_html__( 'Dots Width', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px'],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 30,
                                        'step' => 1,
                                ]
                        ],
                        'default' => [
                                'unit' => 'px',
                                'size' => '',
                        ],
                        'selectors' => [
                                '{{WRAPPER}} .testi_wrap .owl-carousel .owl-dots .owl-dot' => 'width: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .testi_wrap .slick-dots li' => 'width: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'dots_height',
                [
                        'label' => esc_html__( 'Dots Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px'],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 30,
                                        'step' => 1,
                                ]
                        ],
                        'default' => [
                                'unit' => 'px',
                                'size' => '',
                        ],
                        'selectors' => [
                                '{{WRAPPER}} .testi_wrap .owl-carousel .owl-dots .owl-dot' => 'height: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .testi_wrap .slick-dots li' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'dots_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .testi_wrap .owl-carousel .owl-dots .owl-dot' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .testi_wrap .owl-carousel .owl-dots button:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .testi_wrap .slick-dots li' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .testi_wrap .slick-dots li:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                ]
        );
        $this->start_controls_tabs( 'dot_styling_tab' );
            $this->start_controls_tab(
                    'dot_styling_tab_normal',
                    [
                            'label' => esc_html__( 'Normal', 'themewar' ),
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name' => 'cl_dot_bg',
                            'label' => esc_html__( 'Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .testi_wrap .owl-carousel .owl-dots .owl-dot, {{WRAPPER}} .testi_wrap .slick-dots li',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'cl_dot_shadow',
                            'label' => esc_html__( 'Dots Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .testi_wrap .owl-carousel .owl-dots .owl-dot, {{WRAPPER}} .testi_wrap .slick-dots li',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'cl_dot_bg_border',
                            'label' => esc_html__( 'Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .testi_wrap .owl-carousel .owl-dots .owl-dot, {{WRAPPER}} .testi_wrap .slick-dots li',
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'dot_styling_tab_hover',
                    [
                            'label' => esc_html__( 'Hover', 'themewar' ),
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name' => 'cl_dot_hover_bg',
                            'label' => esc_html__( 'Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .testi_wrap .owl-carousel .owl-dots button:after, {{WRAPPER}} .testi_wrap .slick-dots li:after',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'cl_dot_hover_shadow',
                            'label' => esc_html__( 'Dots Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .testi_wrap .owl-carousel .owl-dots .owl-dot:hover, {{WRAPPER}} .testi_wrap .owl-carousel .owl-dots .owl-dot.active, {{WRAPPER}} .testi_wrap .slick-dots li:hover, {{WRAPPER}} .testi_wrap .slick-dots li.slick-active',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'cl_dot_hover_border',
                            'label' => esc_html__( 'Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .testi_wrap .owl-carousel .owl-dots .owl-dot:hover, {{WRAPPER}} .testi_wrap .owl-carousel .owl-dots .owl-dot.active, {{WRAPPER}} .testi_wrap .slick-dots li:hover, {{WRAPPER}} .testi_wrap .slick-dots li.slick-active',
                    ]
            );
            $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_control(
                    'cl_dot_margin',
                    [
                            'label' => esc_html__( 'Dots  Gapping', 'themewar' ),
                            'type'  => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .testi_wrap .owl-carousel .owl-dots .owl-dot' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .testi_wrap .slick-dots li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'cl_dots_margin',
                    [
                            'label' => esc_html__( 'Dot Area Margins', 'themewar' ),
                            'type'  => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .testi_wrap .owl-carousel .owl-dots' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .testi_wrap .slick-dots' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
        $this->end_controls_section();
    }
    
    protected function render() {
        $settings           = $this->get_settings_for_display();
        
        $testimonial_style  = (isset($settings['testimonial_style']) && $settings['testimonial_style'] > 0) ? $settings['testimonial_style'] : 1;

        $testimony_list     = (isset($settings['testimony_list']) && !empty($settings['testimony_list'])) ? $settings['testimony_list'] : array();
        $testimony_lists    = (isset($settings['testimony_lists']) && !empty($settings['testimony_lists'])) ? $settings['testimony_lists'] : array();
        
        $autoplay           = $settings['testi_slide_autoplay'];
        $loop               = $settings['client_slide_loop'];
        $nav                = $settings['client_slide_nav'];
        $dots               = $settings['client_slide_dots'];
        $sub_title          = $settings['sub_title'];
        $main_title         = $settings['main_title'];
        $description        = $settings['description'];
        $test_img           = (isset($settings['test_img']['url']) && $settings['test_img']['url'] != '') ? $settings['test_img']['url'] : '';
        
        include dirname(__FILE__).'/style/testimonial/style'.$testimonial_style.'.php';
    }
        
    protected function content_template() {}
}