<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Skills_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-skills';
    }
    
    public function get_title() {
        return esc_html__( 'Skills Round', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-undo';
    }

    public function get_categories() {
        return [ 'bepro-elements' ];
    }
    
    protected function register_controls() {
        $this->start_controls_section(
            'section_tab_1', [
                'label' => esc_html__( 'Skills', 'themewar' ),
            ]
        );
        $this->add_control(
                'sk_style',
                [
                        'label'     => esc_html__( 'Skills Style', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 1,
                        'options'   => [
                                1       => esc_html__( 'With Icon style', 'themewar' ),
                                2       => esc_html__( 'Without Icon style', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'percent',
                [
                        'label'         => esc_html__( 'Precent', 'themewar' ),
                        'type'          => Controls_Manager::NUMBER,
                        'default'       => 80,
                        'placeholder'   => esc_html__('Precent', 'themewar')
                ]
        );
        $this->add_control(
                'sk_title',
                [
                        'label'         => esc_html__( 'Skill Title', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'label_block'   => TRUE,
                        'default'       => esc_html__('Advanced Analytic', 'themewar'),
                        'placeholder'   => esc_html__('sk title', 'themewar')
                ]
        );
        $this->add_control(
                'icons',
                [
                        'label'     => esc_html__( 'Icon', 'themewar' ),
                        'type'      => Controls_Manager::ICON,
                        'label_block'   => TRUE,
                        'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'sk_style',
                                        'operator'  => '==',
                                        'value'     => '1',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'round_size',
                [
                        'label'         => esc_html__( 'Round Size', 'themewar' ),
                        'type'          => Controls_Manager::NUMBER,
                        'default'       => 151,
                ]
        );
        $this->add_control(
                'border_size',
                [
                        'label'         => esc_html__( 'Border Size', 'themewar' ),
                        'type'          => Controls_Manager::NUMBER,
                        'default'       => 8,
                ]
        );
        $this->add_control(
                'linecap',
                [
                        'label'     => esc_html__( 'LineCap Style', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 1,
                        'options'   => [
                                1       => esc_html__( 'Square', 'themewar' ),
                                2       => esc_html__( 'Round', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'p_bg_color',
                [
                        'label'     => esc_html__( 'Empty Fill Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                ]
        );   
        $this->add_control(
                'start_color',
                [
                        'label'     => esc_html__( 'Start Fill Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                ]
        );
        $this->add_control(
                'end_color',
                [
                        'label'     => esc_html__( 'End Fill Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                ]
        );
        $this->add_responsive_control(
                'sk_alignment', [
                        'label'                     => esc_html__( 'Alignment', 'themewar' ),
                        'type'                      => Controls_Manager::CHOOSE,
                        'options'                   => [
                                'left'           => [
                                        'title'  => esc_html__( 'Left', 'themewar' ),
                                        'icon'   => 'eicon-text-align-left',
                                ],
                                'center'         => [
                                        'title'  => esc_html__( 'Center', 'themewar' ),
                                        'icon'   => 'eicon-text-align-center',
                                ],
                                'right'          => [
                                        'title'  => esc_html__( 'Right', 'themewar' ),
                                        'icon'   => 'eicon-text-align-right',
                                ]
                        ],
                        'default'                   => 'left',
                        'prefix_class'              => 'sk_align elementor%s-align-',
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_4', [
                    'label'         => esc_html__('Skill Area Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name'      => 'bar_normal_background',
                        'label'     => esc_html__( 'Background', 'themewar' ),
                        'types'     => [ 'classic', 'gradient'],
                        'selector'  => '{{WRAPPER}} .cmskRound',
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name' => 'sk_border',
                        'label' => esc_html__( 'Border', 'themewar' ),
                        'selector' => '{{WRAPPER}} .cmskRound',
                ]
        );
        $this->add_control(
                'sk_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .cmskRound' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name' => 'sk_box_shadow',
                        'label' => esc_html__( 'Box Shadow', 'themewar' ),
                        'selector' => '{{WRAPPER}} .cmskRound',
                ]
        );
        $this->add_control(
                'sk_padding',
                [
                        'label'      => esc_html__( 'Padding', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .cmskRound' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
                'sk_margin',
                [
                        'label'      => esc_html__( 'Margins', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .cmskRound' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_5',[
                    'label'     => esc_html__('Skill All Content Style', 'themewar'),
                    'tab'       => Controls_Manager::TAB_STYLE,
                ]
        );
        $this->add_control(
            'sk_title_style',
            [
                'label'     => esc_html__( 'Skill Title Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
                'sk_title_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .cmskRound h5' => 'color: {{VALUE}}',
                        ],
                ]
          );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'sk_title_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .cmskRound p',
                ]
        );
        $this->add_responsive_control(
                'sk_title_margin',
                [
                        'label'      => esc_html__( 'Margins', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .cmskRound p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
            'count_number_style',
            [
                'label'     => esc_html__( 'Number Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
                    'number_color',[
                            'label'     => esc_html__( 'Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .cmskRound strong' => 'color: {{VALUE}}',
                            ],
                    ]
          );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'number_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .cmskRound strong',
                ]
        );
        $this->add_responsive_control(
                'number_margin',
                [
                        'label'      => esc_html__( 'Margins', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .cmskRound strong' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
            'count_precent_style',
            [
                'label'     => esc_html__( 'Percent Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
                    'percent_color',[
                            'label'     => esc_html__( 'Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .cmskRound strong span' => 'color: {{VALUE}}',
                            ],
                    ]
          );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'percent_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .cmskRound strong span',
                ]
        );
        $this->add_responsive_control(
                'percent_margin',
                [
                        'label'      => esc_html__( 'Margins', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .cmskRound strong span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
            'count_icon_style',
            [
                'label'      => esc_html__( 'Icon Style', 'themewar' ),
                'type'       => Controls_Manager::HEADING,
                'separator'  => 'before',
                'conditions' => [
                    'terms'  => [
                        [
                                'name'      => 'sk_style',
                                'operator'  => '==',
                                'value'     => '1',
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
                    'icon_color',[
                            'label'     => esc_html__( 'Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .circle-skill i' => 'color: {{VALUE}}',
                            ],
                            'conditions' => [
                                'terms'  => [
                                    [
                                            'name'      => 'sk_style',
                                            'operator'  => '==',
                                            'value'     => '1',
                                    ]
                                ],
                            ],
                    ]
        );
        $this->add_responsive_control(
                    'icon_bg_color',[
                            'label'     => esc_html__( 'BG Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .circle-skill i' => 'background: {{VALUE}}',
                            ],
                            'conditions' => [
                                'terms'  => [
                                    [
                                            'name'      => 'sk_style',
                                            'operator'  => '==',
                                            'value'     => '1',
                                    ]
                                ],
                            ],
                    ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'icon_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .circle-skill i',
                        'conditions' => [
                            'terms'  => [
                                [
                                        'name'      => 'sk_style',
                                        'operator'  => '==',
                                        'value'     => '1',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_responsive_control(
            'btn_icon_positioning',
            [
                    'label' => esc_html__( 'Position', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px'],
                    'allowed_dimensions' => ['top', 'bottom'],
                    'selectors' => [
                            '{{WRAPPER}} .circle-skill i' => 'top: {{TOP}}{{UNIT}}; bottom: {{BOTTOM}}{{UNIT}};',
                    ],
                    'conditions' => [
                        'terms'  => [
                            [
                                    'name'      => 'sk_style',
                                    'operator'  => '==',
                                    'value'     => '1',
                            ]
                        ],
                    ],
            ]
        );
        $this->add_responsive_control(
            'btn_icon_margin',
            [
                    'label' => esc_html__( 'Margins', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px'],
                    'allowed_dimensions' => ['left', 'right'],
                    'selectors' => [
                            '{{WRAPPER}} .circle-skill i' => 'margin-right: {{RIGHT}}{{UNIT}}; margin-left: {{LEFT}}{{UNIT}};',
                    ],
                    'conditions' => [
                        'terms'  => [
                            [
                                    'name'      => 'sk_style',
                                    'operator'  => '==',
                                    'value'     => '1',
                            ]
                        ],
                    ],
            ]
        );
        $this->end_controls_section();
        
    }
    
    protected function render() {
        $settings       = $this->get_settings_for_display();
        $sk_style       = (isset($settings['sk_style']) && $settings['sk_style'] > 0) ? $settings['sk_style'] : 1;
        $linecap        = (isset($settings['linecap']) && $settings['linecap'] > 0) ? $settings['linecap'] : 1;
        $sk_title       = (isset($settings['sk_title']) && $settings['sk_title'] != '') ? $settings['sk_title'] : esc_html__('Advanced Analytic
', 'themewar');
        $icons          = (isset($settings['icons']) && $settings['icons'] != '') ? $settings['icons'] : 'twi-chart-pie1';
        $percent        = (isset($settings['percent']) && $settings['percent'] != '') ? $settings['percent'] : '80';
        $border_size    = (isset($settings['border_size']) && $settings['border_size'] != '') ? $settings['border_size'] : 8;
        $round_size     = (isset($settings['round_size']) && $settings['round_size'] != '') ? $settings['round_size'] : 151;

        $p_bg_color     = (isset($settings['p_bg_color']) && $settings['p_bg_color'] != '') ? $settings['p_bg_color'] : '#ebebeb';
        $start_color    = (isset($settings['start_color']) && $settings['start_color'] != '') ? $settings['start_color'] : '#bb0b0b';
        $end_color      = (isset($settings['end_color']) && $settings['end_color'] != '') ? $settings['end_color'] : '#bb0b0b';

        $capClass = '';
        if($linecap == 2):
            $capClass .= 'square';
        else:
            $capClass .= 'round';
        endif;
       
        if($sk_style == 2):
        ?>
        <div class="skrItem02 cmskRound">
            <div class="circle-skill02" data-sizes="<?php echo esc_attr($round_size); ?>" data-thicknesss="<?php echo esc_attr($border_size); ?>" data-emptyfills="<?php echo $p_bg_color; ?>" data-values="0.<?php echo esc_attr($percent); ?>" data-gradientstart="<?php echo $start_color; ?>" data-gradientend="<?php echo $end_color; ?>" data-linecaps="<?php echo $capClass; ?>"><strong></strong></div>
            <?php if($sk_title != ''): ?>
                <h5><?php echo wp_kses_post($sk_title); ?></h5>
            <?php endif; ?>
        </div>
        <?php
        else:
            ?>
            <div class="skrItem cmskRound">
                <div class="circle-skill" data-sizes="<?php echo esc_attr($round_size); ?>" data-thicknesss="<?php echo esc_attr($border_size); ?>" data-emptyfills="<?php echo $p_bg_color; ?>" data-values="0.<?php echo esc_attr($percent); ?>" data-gradientstart="<?php echo $start_color; ?>" data-gradientend="<?php echo $end_color; ?>" data-linecaps="<?php echo $capClass; ?>"><strong></strong><i class="<?php echo esc_attr($icons); ?>"></i></div>
                <?php if($sk_title != ''): ?>
                    <h5><?php echo wp_kses_post($sk_title); ?></h5>
                <?php endif; ?>
            </div>
            <?php
        endif;
    }
    
    protected function content_template() {

    }
}