<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Product_Slider_Widges extends Widget_Base{
    
    public function get_name() {
        return 'tw-product-slider';
    }
    
    public function get_title() {
        return esc_html__( 'Product Slider', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-products';
    }

    public function get_categories() {
        return [ 'bepro-elements' ];
    }
    
    protected function register_controls() {
        
        $this->start_controls_section(
                'section_tab_1',
                [
                    'label'     => esc_html__('Product Slider', 'themewar')
                ]
        );
            $this->add_control(
                    'pr_product_type',
                    [
                            'label'         => esc_html__( 'Product Type', 'themewar' ),
                            'type'          => Controls_Manager::SELECT,
                            'description'   => esc_html__('Select which type of product you want to show.', 'themewar'),
                            'default'       => 1,
                            'options'       => [
                                    1       => esc_html__( 'New Product', 'themewar' ),
                                    2       => esc_html__( 'Featured Product', 'themewar' ),
                                    3       => esc_html__( 'Sale Product', 'themewar' ),
                                    4       => esc_html__( 'Popular Product', 'themewar' ),
                                    5       => esc_html__( 'Best Seller Product', 'themewar' ),
                                    6       => esc_html__( 'Top Rated Product', 'themewar' ),
                                    7       => esc_html__( 'Random Product', 'themewar' ),
                            ],
                    ]
            );
            $this->add_control(
                    'pr_product_types',
                    [
                            'label'         => esc_html__( 'Product Types', 'themewar' ),
                            'type'          => Controls_Manager::SELECT2,
                            'description'   => esc_html__('Select types.', 'themewar'),
                            'default'       => ['1', '2', '3', '4'],
                            'multiple'      => true,
                            'options'       => [
                                    1       => esc_html__( 'New Product', 'themewar' ),
                                    2       => esc_html__( 'Featured Product', 'themewar' ),
                                    3       => esc_html__( 'Sale Product', 'themewar' ),
                                    4       => esc_html__( 'Popular Product', 'themewar' ),
                                    5       => esc_html__( 'Best Seller Product', 'themewar' ),
                                    6       => esc_html__( 'Top Rated Product', 'themewar' ),
                                    7       => esc_html__( 'Random Product', 'themewar' ),
                            ],
                    ]
            );
            $this->add_control( 'pr_product_category', [
                    'label' => esc_html__('Product Category', 'themewar'),
                    'type' => 'tw_autocomplete',
                    'description' => esc_html__('Select specific category product.', 'themewar'),
                    'action' => 'tw_get_taxonomy',
                    'taxonomy' => 'product_cat',
                    'multiple' => true,
                ]
            );
            $this->add_control(
                    'show_flashlabels', [
                            'label'             => esc_html__( 'Is Flash Label?', 'themewar' ),
                            'type'              => Controls_Manager::SWITCHER,
                            'label_on'          => esc_html__( 'Yes', 'themewar' ),
                            'label_off'         => esc_html__( 'No', 'themewar' ),
                            'description'       => esc_html__('Dow you want to show flash label on loop product? Turn it to Show.', 'themewar'),
                            'return_value'      => 'yes',
                            'default'           => 'no',
                    ]
            );
            $this->add_control(
                    'shop_is_wishlist_btn', [
                            'label'             => esc_html__( 'Is Wishlist Btn?', 'themewar' ),
                            'type'              => Controls_Manager::SWITCHER,
                            'label_on'          => esc_html__( 'Yes', 'themewar' ),
                            'label_off'         => esc_html__( 'No', 'themewar' ),
                            'description'       => esc_html__('Dow you want to show wishlist btn on loop product? Turn it to Show.', 'themewar'),
                            'return_value'      => 'yes',
                            'default'           => 'no',
                    ]
            );
            $this->add_control(
                    'pr_post_item',
                    [
                            'label'         => esc_html__( 'Large Desktip Item', 'themewar' ),
                            'type'          => Controls_Manager::NUMBER,
                            'min'           => 1,
                            'max'           => 200,
                            'step'          => 1,
                            'default'       => 4,
                            'description'   => esc_html__( 'How many item you want to show on large desktop?', 'themewar' ),
                    ]
            );
            $this->add_control(
                    'pr_post_item2',
                    [
                            'label'         => esc_html__( 'Ipad Pro Item', 'themewar' ),
                            'type'          => Controls_Manager::NUMBER,
                            'min'           => 1,
                            'max'           => 200,
                            'step'          => 1,
                            'default'       => 3,
                            'description'   => esc_html__( 'How many item you want to show on ipad pro?', 'themewar' ),
                    ]
            );
            $this->add_control(
                    'pr_post_item3',
                    [
                            'label'         => esc_html__( 'Tab Item', 'themewar' ),
                            'type'          => Controls_Manager::NUMBER,
                            'min'           => 1,
                            'max'           => 200,
                            'step'          => 1,
                            'default'       => 2,
                            'description'   => esc_html__( 'How many item you want to show on tab?', 'themewar' ),
                    ]
            );
            $this->add_control(
                    'pr_slide_autoplay',
                    [
                            'label'             => esc_html__( 'Is Autoplay?', 'themewar' ),
                            'type'              => Controls_Manager::SWITCHER,
                            'label_on'          => esc_html__( 'Yes', 'themewar' ),
                            'label_off'         => esc_html__( 'No', 'themewar' ),
                            'description'       => esc_html__('Do you want to make this slider auto play?', 'themewar'),
                            'return_value'      => 'yes',
                            'default'           => 'yes',
                    ]
            );
            $this->add_control(
                    'pr_slide_loop',
                    [
                            'label'             => esc_html__( 'Is Loop?', 'themewar' ),
                            'type'              => Controls_Manager::SWITCHER,
                            'label_on'          => esc_html__( 'Yes', 'themewar' ),
                            'label_off'         => esc_html__( 'No', 'themewar' ),
                            'description'       => esc_html__('Do you want to make this slider item loop?', 'themewar'),
                            'return_value'      => 'yes',
                            'default'           => 'yes',
                    ]
            );
            $this->add_control(
                    'pr_slide_nav',
                    [
                            'label'             => esc_html__( 'Is Nav?', 'themewar' ),
                            'type'              => Controls_Manager::SWITCHER,
                            'label_on'          => esc_html__( 'Yes', 'themewar' ),
                            'label_off'         => esc_html__( 'No', 'themewar' ),
                            'description'       => esc_html__('Do you want to show slider arrow navigation?', 'themewar'),
                            'return_value'      => 'yes',
                            'default'           => 'no',
                    ]
            );
            $this->add_control(
                    'pr_slide_dots',
                    [
                            'label'             => esc_html__( 'Is Dots?', 'themewar' ),
                            'type'              => Controls_Manager::SWITCHER,
                            'label_on'          => esc_html__( 'Yes', 'themewar' ),
                            'label_off'         => esc_html__( 'No', 'themewar' ),
                            'description'       => esc_html__('Do you want to show slider bullets item?', 'themewar'),
                            'return_value'      => 'yes',
                            'default'           => 'no',
                    ]
            );
            $this->add_control(
                    'pr_slide_gap',
                    [
                            'label'         => esc_html__( 'Item Gapping', 'themewar' ),
                            'type'          => Controls_Manager::NUMBER,
                            'min'           => 0,
                            'max'           => 100,
                            'step'          => 1,
                            'default'       => 30,
                            'description'   => esc_html__( 'Insert Item gapping amount.', 'themewar' ),
                    ]
            );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_100', [
                'label'         => esc_html__( 'Nav Style', 'themewar' ),
                'tab'           => Controls_Manager::TAB_STYLE,
            ]
            );
            $this->add_control(
                'serv_nav_radius',
                [
                        'label'      => esc_html__( 'Border Radius', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .product_carousel.owl-carousel .owl-nav button'       => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
            $this->start_controls_tabs( 
                    'box_style_tab'
            );
            $this->start_controls_tab(
                    'serv_arr_normal_tab',
                    [
                            'label'         => esc_html__( 'Arrow BTN Normal', 'themewar' ),
                    ]
            );
                $this->add_control(
                        'serv_btn_color',
                        [
                                'label'     => esc_html__( 'Color', 'themewar' ),
                                'type'      => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .product_carousel.owl-carousel .owl-nav button' => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_control(
                        'serv_btn_bg',
                        [
                                'label'     => esc_html__( 'BG Color', 'themewar' ),
                                'type'      => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .product_carousel.owl-carousel .owl-nav button' => 'background-color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                                'name' => 'serv_btn_border',
                                'label' => esc_html__( 'Border', 'themewar' ),
                                'selector' => '{{WRAPPER}} .product_carousel.owl-carousel .owl-nav button',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                                'name'      => 'serv_btn_shadow',
                                'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                                'selector'  => '{{WRAPPER}} .product_carousel.owl-carousel .owl-nav button',
                        ]
                );
                $this->end_controls_tab();
                $this->start_controls_tab(
                        'serv_arr_hover_tab',
                        [
                                'label'         => esc_html__( 'Arrow BTN Hover', 'themewar' ),
                        ]
                );
                    $this->add_control(
                            'serv_btn_color_hvr',
                            [
                                    'label'     => esc_html__( 'Color', 'themewar' ),
                                    'type'      => Controls_Manager::COLOR,
                                    'selectors' => [
                                            '{{WRAPPER}} .product_carousel.owl-carousel .owl-nav button:hover' => 'color: {{VALUE}}'
                                    ],
                            ]
                    );
                    $this->add_control(
                            'serv_btn_bg_hvr',
                            [
                                    'label'     => esc_html__( 'BG Color', 'themewar' ),
                                    'type'      => Controls_Manager::COLOR,
                                    'selectors' => [
                                            '{{WRAPPER}} .product_carousel.owl-carousel .owl-nav button:hover' => 'background-color: {{VALUE}}',
                                    ],
                            ]
                    );
                    $this->add_group_control(
                            Group_Control_Border::get_type(),
                            [
                                    'name' => 'serv_btn_border_hvr',
                                    'label' => esc_html__( 'Border', 'themewar' ),
                                    'selector' => '{{WRAPPER}} .product_carousel.owl-carousel .owl-nav button:hover',
                            ]
                    );
                    $this->add_group_control(
                            Group_Control_Box_Shadow::get_type(),
                            [
                                    'name'      => 'serv_btn_shadow_hvr',
                                    'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                                    'selector'  => '{{WRAPPER}} .product_carousel.owl-carousel .owl-nav button:hover',
                            ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();
        $this->start_controls_section(
            'section_tab_20', [
                'label'         => esc_html__( 'Dot Style', 'themewar' ),
                'tab'           => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'serv_dot_margin',
            [
                    'label'      => esc_html__( 'Bullets Area Margin', 'themewar' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                            '{{WRAPPER}} .product_carousel.owl-carousel .owl-dots'       => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_control(
            'serv_dot_item_margin',
            [
                    'label'      => esc_html__( 'Bullets Item Margin', 'themewar' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                            '{{WRAPPER}} .product_carousel.owl-carousel .owl-dots button'       => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_control(
                'serv_dot_width',
                [
                        'label' => esc_html__( 'Bullets Width', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px'],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 50,
                                        'step' => 1,
                                ],
                        ],
                        'default' => [
                                'unit' => 'px',
                                'size' => 8,
                        ],
                        'selectors' => [
                                '{{WRAPPER}} .product_carousel.owl-carousel .owl-dots button' => 'width: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
                'serv_dot_height',
                [
                        'label' => esc_html__( 'Bullets Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px'],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 50,
                                        'step' => 1,
                                ],
                        ],
                        'default' => [
                                'unit' => 'px',
                                'size' => 8,
                        ],
                        'selectors' => [
                                '{{WRAPPER}} .product_carousel.owl-carousel .owl-dots button' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
            'serv_dot_radius',
            [
                    'label'      => esc_html__( 'Bullets Border Radius', 'themewar' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                            '{{WRAPPER}} .product_carousel.owl-carousel .owl-dots button'       => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->start_controls_tabs( 
                'box_style_tab_2'
        );
            $this->start_controls_tab(
                    'serv_dot_normal_tab',
                    [
                            'label'         => esc_html__( 'Bullets Normal', 'themewar' ),
                    ]
            );
                $this->add_control(
                        'serv_dot_bg',
                        [
                                'label'     => esc_html__( 'BG Color', 'themewar' ),
                                'type'      => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .product_carousel.owl-carousel .owl-dots button' => 'background-color: {{VALUE}}',
                                ],
                        ]
                );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'serv_dot_hover_tab',
                    [
                            'label'         => esc_html__( 'Bullets Hover', 'themewar' ),
                    ]
            );
                $this->add_control(
                        'serv_dot_bg_hvr',
                        [
                                'label'     => esc_html__( 'BG Color', 'themewar' ),
                                'type'      => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .product_carousel.owl-carousel .owl-dots button:hover' => 'background-color: {{VALUE}}',
                                        '{{WRAPPER}} .product_carousel.owl-carousel .owl-dots button.active' => 'background-color: {{VALUE}}'
                                ],
                        ]
                );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        
    }
    protected function render() {
        $settings           = $this->get_settings_for_display();
        
        $product_type       = (isset($settings['pr_product_type']) && $settings['pr_product_type'] > 0 ? $settings['pr_product_type'] : 1);
        $product_types      = (isset($settings['pr_product_types']) && !empty($settings['pr_product_types']) ? $settings['pr_product_types'] : array());
        $product_category   = (isset($settings['pr_product_category']) && !empty($settings['pr_product_category']) ? $settings['pr_product_category'] : array());
        $post_item          = (isset($settings['pr_post_item']) && $settings['pr_product_category'] != '' ? $settings['pr_post_item'] : 4);
        $pr_post_item2      = (isset($settings['pr_post_item2']) && $settings['pr_post_item2'] != '' ? $settings['pr_post_item2'] : 3);
        $pr_post_item3      = (isset($settings['pr_post_item3']) && $settings['pr_post_item3'] != '' ? $settings['pr_post_item3'] : 2);
        
        $autoplay           = (isset($settings['pr_slide_autoplay']) && $settings['pr_slide_autoplay'] != '') ? $settings['pr_slide_autoplay'] : 'yes';
        $loop               = (isset($settings['pr_slide_loop']) && $settings['pr_slide_loop'] != '') ? $settings['pr_slide_loop'] : 'yes';
        $nav                = (isset($settings['pr_slide_nav']) && $settings['pr_slide_nav'] != '') ? $settings['pr_slide_nav'] : 'no';
        $dots               = (isset($settings['pr_slide_dots']) && $settings['pr_slide_dots'] != '') ? $settings['pr_slide_dots'] : 'no';
        $gapping            = (isset($settings['pr_slide_gap'])) ? $settings['pr_slide_gap'] : 30;
        
        $shop_is_wishlist_btn   = (isset($settings['shop_is_wishlist_btn']) && $settings['shop_is_wishlist_btn'] != '') ? $settings['shop_is_wishlist_btn'] : 'no';
        $show_flashlabels   = (isset($settings['show_flashlabels']) && $settings['show_flashlabels'] != '') ? $settings['show_flashlabels'] : 'no';
        
        include dirname(__FILE__).'/style/product-slider/style1.php';
    }
}