<?php

namespace Elementor;

if (!defined('ABSPATH'))
    exit;

class Tw_Header_Widgets extends Widget_Base{
    public function get_name(){
        return 'tw-header';
    }

    public function get_title(){
        return esc_html__('All Headers', 'themewar');
    }

    public function get_icon(){
        return 'eicon-heading';
    }

    public function get_categories(){
        return ['bepro-elements'];
    }

    public function get_menus(){
        $list = array('0' => esc_html('Select Menu', 'themewar'));
        $menus = wp_get_nav_menus();
        foreach ($menus as $menu) {
            $list[$menu->slug] = $menu->name;
        }
        return $list;
    }

    protected function register_controls(){
        $this->start_controls_section(
            'tw_content_tab',
            [
                'label' => esc_html__('Headers', 'themewar'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'header_style', [
                'label' => esc_html__('Select Header Style', 'themewar'),
                'type' => Controls_Manager::SELECT,
                'default' => 1,
                'options' => [
                    1 => esc_html__('Style 01', 'themewar'),
                    2 => esc_html__('Style 02', 'themewar'),
                    3 => esc_html__('Style 03', 'themewar'),
                    4 => esc_html__('Popup Menu', 'themewar'),
                    5 => esc_html__('Sidebar Menu', 'themewar'),
                ],
            ]
        );
        $this->add_control(
            'is_topbar',
            [
                'label' => esc_html__('Is Topbar?', 'themewar'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'themewar'),
                'label_off' => esc_html__('No', 'themewar'),
                'description' => esc_html__('Do you want to show header topbar?', 'themewar'),
                'return_value' => 'yes',
                'default' => 'no',
                'conditions' => [
                    'terms'  => [
                        [
                            'name'      => 'header_style',
                            'operator'  => '!in',
                            'value'     => ['2', '4', '5'],
                        ]
                    ],
                ],
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'icons',
            [
                'label' => esc_html__('Info Icon', 'themewar'),
                'type' => Controls_Manager::ICON,
                'label_block' => TRUE,
            ]
        );
        $repeater->add_control(
            'info_text', [
                'label' => esc_html__('Info Text', 'themewar'),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'label_block' => TRUE,
                'placeholder' => esc_html__('info text', 'themewar'),
            ]
        );
        $repeater->add_control(
            'info_url', [
                'label' => esc_html__('Info Url', 'themewar'),
                'type' => Controls_Manager::URL,
                'input_type' => 'url',
                'placeholder' => esc_html__('https://your-link.com', 'themewar'),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );
        $this->add_control(
            'info_list', [
                'label' => esc_html__('Info Item', 'themewar'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'icons'     => '',
                        'info_text' => '',
                        'info_url'  => '',
                    ],
                ],
                'title_field' => '{{{ info_text }}}',
                'conditions'  => [
                    'terms'   => [
                        [
                            'name'      => 'header_style',
                            'operator'  => '!in',
                            'value'     => ['2', '4'],
                        ],
                        [
                            'name'     => 'is_topbar',
                            'operator' => '==',
                            'value'    => 'yes',
                        ]
                    ],
                ],
            ]
        );
        $repeaters = new \Elementor\Repeater();
        $repeaters->add_control(
            's_icons',
            [
                'label' => esc_html__('Social Icon', 'themewar'),
                'type' => Controls_Manager::ICON,
                'label_block' => TRUE,
            ]
        );
        $repeaters->add_control(
            's_url', [
                'label' => esc_html__('Social Url', 'themewar'),
                'type' => Controls_Manager::URL,
                'input_type' => 'url',
                'placeholder' => esc_html__('https://your-link.com', 'themewar'),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );
        $this->add_control(
            's_list', [
                'label' => esc_html__('Social Item', 'themewar'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeaters->get_controls(),
                'default' => [
                    [
                        's_icons' => '',
                        's_url'   => '',
                    ],
                ],
                'title_field' => '{{{ s_icons }}}',
                'conditions'  => [
                    'terms'   => [
                        [
                            'name'      => 'header_style',
                            'operator'  => '!in',
                            'value'     => ['2', '4'],
                        ],
                        [
                            'name'      => 'is_topbar',
                            'operator'  => '==',
                            'value'     => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->add_control(
            'is_header',
            [
                'label' => esc_html__('Is Main Header?', 'themewar'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'themewar'),
                'label_off' => esc_html__('No', 'themewar'),
                'description' => esc_html__('Do you want to show main header?', 'themewar'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'logo',
            [
                'label' => esc_html__('Logo', 'themewar'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('Upload your site logo.', 'themewar'),
                'conditions' => [
                    'terms' => [
                        [
                            'name'      => 'is_header',
                            'operator'  => '==',
                            'value'     => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->add_control(
            'sticky_logo',
            [
                'label' => esc_html__('Sticky Logo', 'themewar'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('Upload your site sticky logo. this option work only when header is fixed in top.', 'themewar'),
                'conditions' => [
                    'terms' => [
                        [
                            'name'      => 'header_style',
                            'operator'  => '==',
                            'value'     => '4',
                        ],
                        [
                            'name'      => 'is_header',
                            'operator'  => '==',
                            'value'     => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $repeaters2 = new \Elementor\Repeater();
        $repeaters2->add_control(
            's2_icons',
            [
                'label' => esc_html__('Social Icon', 'themewar'),
                'type' => Controls_Manager::ICON,
                'label_block' => TRUE,
            ]
        );
        $repeaters2->add_control(
            's2_url', [
                'label' => esc_html__('Social Url', 'themewar'),
                'type' => Controls_Manager::URL,
                'input_type' => 'url',
                'placeholder' => esc_html__('https://your-link.com', 'themewar'),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );
        $this->add_control(
            's2_list', [
                'label' => esc_html__('Social Item', 'themewar'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeaters2->get_controls(),
                'default' => [
                    [
                        's2_icons' => '',
                        's2_url' => '',
                    ],
                ],
                'title_field' => '{{{ s2_icons }}}',
                'conditions' => [
                    'terms' => [
                        [
                            'name'      => 'header_style',
                            'operator'  => 'in',
                            'value'     => ['2', '5'],
                        ],
                        [
                            'name'     => 'is_header',
                            'operator' => '==',
                            'value'    => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->add_control(
            'is_serch',
            [
                'label' => esc_html__('Is Search?', 'themewar'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'themewar'),
                'label_off' => esc_html__('No', 'themewar'),
                'description' => esc_html__('Do you want to show search popup form?', 'themewar'),
                'return_value' => 'yes',
                'default' => 'no',
                'conditions' => [
                    'terms' => [
                        [
                            'name'      => 'header_style',
                            'operator'  => '!in',
                            'value'     => ['3'],
                        ],
                        [
                            'name'      => 'is_header',
                            'operator'  => '==',
                            'value'     => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->add_control(
            'is_cart',
            [
                'label' => esc_html__('Is Cart?', 'themewar'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'themewar'),
                'label_off' => esc_html__('No', 'themewar'),
                'description' => esc_html__('Do you want to show cart btn?', 'themewar'),
                'return_value' => 'yes',
                'default' => 'no',
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['2','3'],
                        ],
                        [
                            'name' => 'is_header',
                            'operator' => '==',
                            'value' => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->add_control(
            'is_mini_cart',
            [
                'label' => esc_html__('Is Hover Mini Cart?', 'themewar'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'themewar'),
                'label_off' => esc_html__('No', 'themewar'),
                'description' => esc_html__('Do you want to show cart btn hover mini cart?', 'themewar'),
                'return_value' => 'yes',
                'default'    => 'yes',
                'conditions' => [
                    'terms'  => [
                        [
                            'name'      => 'header_style',
                            'operator'  => '!in',
                            'value'     => ['2','3'],
                        ],
                        [
                            'name'      => 'is_header',
                            'operator'  => '==',
                            'value'     => 'yes',
                        ],
                        [
                            'name'      => 'is_cart',
                            'operator'  => '==',
                            'value'     => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->add_control(
            'is_contact_btn',
            [
                'label' => esc_html__('Is Contact Btn?', 'themewar'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'themewar'),
                'label_off' => esc_html__('No', 'themewar'),
                'description' => esc_html__('Do you want to show header contact btn?', 'themewar'),
                'return_value' => 'yes',
                'default' => 'no',
                'conditions' => [
                    'terms'  => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['2','4'],
                        ],
                        [
                            'name'      => 'is_header',
                            'operator'  => '==',
                            'value'     => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->add_control(
            'btn_label', [
                'label' => esc_html__('Btn Label', 'themewar'),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'label_block' => TRUE,
                'placeholder' => esc_html__('Get A Quote', 'themewar'),
                'conditions' => [
                    'terms'  => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['2','4'],
                        ],
                        [
                            'name'      => 'is_header',
                            'operator'  => '==',
                            'value'     => 'yes',
                        ],
                        [
                            'name'      => 'is_contact_btn',
                            'operator'  => '==',
                            'value'     => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->add_control(
                'btn_url',
                [
                        'label'             => esc_html__( 'Btn Url', 'themewar' ),
                        'type'              => Controls_Manager::URL,
                        'placeholder'       => esc_html__( 'https://your-link.com', 'themewar' ),
                        'show_external'     => true,
                        'default'           => [
                                'url'           => '',
                                'is_external'   => true,
                                'nofollow'      => true,
                        ],
                        'conditions' => [
                            'terms'  => [
                                [
                                    'name' => 'header_style',
                                    'operator' => '!in',
                                    'value' => ['2','4'],
                                ],
                                [
                                    'name'      => 'is_header',
                                    'operator'  => '==',
                                    'value'     => 'yes',
                                ],
                                [
                                    'name'      => 'is_contact_btn',
                                    'operator'  => '==',
                                    'value'     => 'yes',
                                ],
                            ],
                        ],
                ]
        );
        $this->add_control(
            'is_info_boxs',
            [
                'label' => esc_html__('Is Info Box?', 'themewar'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'themewar'),
                'label_off' => esc_html__('No', 'themewar'),
                'description' => esc_html__('Do you want to show info box in header?', 'themewar'),
                'return_value' => 'yes',
                'default' => 'no',
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '==',
                            'value' => '2',
                        ],
                        [
                            'name' => 'is_header',
                            'operator' => '==',
                            'value' => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->add_control(
            'i_iconss',
            [
                'label' => esc_html__('Info Icon', 'themewar'),
                'type' => Controls_Manager::ICON,
                'label_block' => TRUE,
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '==',
                            'value' => '2',
                        ],
                        [
                            'name' => 'is_header',
                            'operator' => '==',
                            'value' => 'yes',
                        ],
                        [
                            'name' => 'is_info_boxs',
                            'operator' => '==',
                            'value' => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->add_control(
            'i_labels',
            [
                'label' => esc_html__('Info Label', 'themewar'),
                'type' => Controls_Manager::TEXT,
                'label_block' => TRUE,
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '==',
                            'value' => '2',
                        ],
                        [
                            'name' => 'is_header',
                            'operator' => '==',
                            'value' => 'yes',
                        ],
                        [
                            'name' => 'is_info_boxs',
                            'operator' => '==',
                            'value' => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->add_control(
            'i_values',
            [
                'label' => esc_html__('Info Value', 'themewar'),
                'type' => Controls_Manager::TEXT,
                'label_block' => TRUE,
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '==',
                            'value' => '2',
                        ],
                        [
                            'name' => 'is_header',
                            'operator' => '==',
                            'value' => 'yes',
                        ],
                        [
                            'name' => 'is_info_boxs',
                            'operator' => '==',
                            'value' => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->add_control(
            'is_sticky',
            [
                'label' => esc_html__('Is Sticky Header?', 'themewar'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'themewar'),
                'label_off' => esc_html__('No', 'themewar'),
                'description' => esc_html__('Do you want to show sticky header?', 'themewar'),
                'return_value' => 'yes',
                'default' => 'no',
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'is_header',
                            'operator' => '==',
                            'value' => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_2', [
                'label' => esc_html__('Topbar Style', 'themewar'),
                'tab' => Controls_Manager::TAB_STYLE,
                'conditions' => [
                    'terms'  => [
                        [
                            'name'      => 'is_topbar',
                            'operator'  => '==',
                            'value'     => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'topbar_background',
                'label' => esc_html__('Area Background', 'themewar'),
                'types' => ['classic'],
                'selector' => '{{WRAPPER}} .topbar01, {{WRAPPER}} .topbar02, {{WRAPPER}} .topbar03',
            ]
        );
        $this->add_responsive_control(
            'top_area_radius',
            [
                'label' => esc_html__('Area Radius', 'themewar'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .topbar01' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .topbar02' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .topbar03' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'top_area_border',
                'label' => esc_html__('Border', 'themewar'),
                'selector' => '{{WRAPPER}} .topbar01, {{WRAPPER}} .topbar02, {{WRAPPER}} .topbar03',
            ]
        );
        $this->add_responsive_control(
            'top_area_padding',
            [
                'label' => esc_html__('Area Padding', 'themewar'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .topbar01' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .topbar02' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .topbar03' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'top_area_margin',
            [
                'label' => esc_html__('Area Margins', 'themewar'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .topbar01' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .topbar02' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .topbar03' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'heading_un_one',
            [
                'label' => esc_html__('Info Item Icon Style', 'themewar'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
            'info_icon_color',
            [
                'label' => esc_html__('Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .topbar01 p i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .topbar02 p i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'info_icon_bg_color',
            [
                'label' => esc_html__('BG Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .topbar01 p i' => 'background: {{VALUE}}',
                    '{{WRAPPER}} .topbar02 p i' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'info_icon_typography',
                'label' => esc_html__('Typography', 'themewar'),
                'selector' => '{{WRAPPER}} .topbar01 p i, {{WRAPPER}} .topbar02 p i, {{WRAPPER}} .topbar03 p i',
            ]
        );
        $this->add_control(
            'heading_un_two',
            [
                'label' => esc_html__('Info Item Text Style', 'themewar'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
            'info_text_color',
            [
                'label' => esc_html__('Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .topbar01 p' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .topbar02 p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'info_text_hover_color',
            [
                'label' => esc_html__('Hover Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .topbar01 p a:hover' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .topbar02 p a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'info_text_typography',
                'label' => esc_html__('Typography', 'themewar'),
                'selector' => '{{WRAPPER}} .topbar01 p, {{WRAPPER}} .topbar02 p, {{WRAPPER}} .topbar03 p',
            ]
        );
        $this->add_control(
            'heading_un_three',
            [
                'label' => esc_html__('Social Style', 'themewar'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'is_topbar',
                            'operator' => '==',
                            'value' => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'info_social_color',
            [
                'label' => esc_html__('Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .topsocial a' => 'color: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'is_topbar',
                            'operator' => '==',
                            'value' => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'info_social_bg_color',
            [
                'label' => esc_html__('BG Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .topsocial a' => 'background: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'is_topbar',
                            'operator' => '==',
                            'value' => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'info_social_hover_color',
            [
                'label' => esc_html__('Hover Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .topsocial a:hover' => 'color: {{VALUE}}',
                ],
                'conditions' => [
                    'terms'  => [
                        [
                            'name'      => 'is_topbar',
                            'operator'  => '==',
                            'value'     => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'info_social_hover_bg_color',
            [
                'label' => esc_html__('Hover BG Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .topsocial a:hover' => 'background: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name'      => 'is_topbar',
                            'operator'  => '==',
                            'value'     => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'info_social_typography',
                'label' => esc_html__('Typography', 'themewar'),
                'selector' => '{{WRAPPER}} .topsocial a',
                'conditions' => [
                    'terms' => [
                        [
                            'name'     => 'is_topbar',
                            'operator' => '==',
                            'value'    => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_04', [
                'label' => esc_html__('Main Header Styling', 'themewar'),
                'tab' => Controls_Manager::TAB_STYLE,
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'is_header',
                            'operator' => '==',
                            'value' => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->start_controls_tabs( 'style_tabs_10' );
            $this->start_controls_tab(
                    's_5_style_normal',
                    [
                            'label' => esc_html__( 'Normal', 'themewar' ),
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name'      => 'bar_normal_background',
                            'label'     => esc_html__( 'Background', 'themewar' ),
                            'types'     => [ 'classic', 'gradient'],
                            'selector'  => '{{WRAPPER}} .header01 .navbar01, {{WRAPPER}} .header02, {{WRAPPER}} .header03, {{WRAPPER}} .header04, {{WRAPPER}} .header05',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'sk_border',
                            'label' => esc_html__( 'Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .header01 .navbar01, {{WRAPPER}} .header02, {{WRAPPER}} .header03, {{WRAPPER}} .header04, {{WRAPPER}} .header05',
                    ]
            );
            $this->add_control(
                    'sk_radius',
                    [
                            'label' => esc_html__( 'Border Radius', 'themewar' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .header01 .navbar01' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .header02' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .header03' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .header04' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .header05' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'sk_box_shadow',
                            'label' => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .header01 .navbar01, {{WRAPPER}} .header02, {{WRAPPER}} .header03, {{WRAPPER}} .header04, {{WRAPPER}} .header05',
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    's_5_style_hover',
                    [
                            'label' => esc_html__( 'Sticky', 'themewar' ),
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name'      => 'bar_forground_background',
                            'label'     => esc_html__( 'Background', 'themewar' ),
                            'types'     => [ 'classic', 'gradient'],
                            'selector'  => '{{WRAPPER}} header.fixedHeader, {{WRAPPER}} .fixedHeader.header02, {{WRAPPER}} .header03.fixedHeader, {{WRAPPER}} .header04.fixedHeader, {{WRAPPER}} .fixedHeader.header05',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'sk_f_border',
                            'label' => esc_html__( 'Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} header.fixedHeader, {{WRAPPER}} .fixedHeader.header02, {{WRAPPER}} .header03.fixedHeader, {{WRAPPER}} .header04.fixedHeader, {{WRAPPER}} .fixedHeader.header05',
                    ]
            );
            $this->add_control(
                    'sk_f_radius',
                    [
                            'label' => esc_html__( 'Border Radius', 'themewar' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} header.fixedHeader' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .fixedHeader.header02' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .header03.fixedHeader' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .header04.fixedHeader' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .fixedHeader.header05' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'sk_f_box_shadow',
                            'label' => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} header.fixedHeader, {{WRAPPER}} .fixedHeader.header02, {{WRAPPER}} .header03.fixedHeader, {{WRAPPER}} .header04.fixedHeader, {{WRAPPER}} .fixedHeader.header05',
                    ]
            );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_responsive_control(
            'header_padding',
            [
                'label' => esc_html__('Area Padding', 'themewar'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .header01 .navBar01' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .header02' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .header03' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .header04' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .header05' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'header_margin',
            [
                'label' => esc_html__('Area Margins', 'themewar'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .header01 .navBar01' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .header02' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .header03' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .header04' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .header05' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'heading_un_logo', [
                'label' => esc_html__('Logo Style', 'themewar'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'is_header',
                            'operator' => '==',
                            'value' => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'logo_width', [
                'label' => esc_html__('Width', 'themewar'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .logo img' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'is_header',
                            'operator' => '==',
                            'value' => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'logo_height', [
                'label' => esc_html__('Height', 'themewar'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .logo img' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'is_header',
                            'operator' => '==',
                            'value' => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'logo_padding', [
                'label' => esc_html__('Paddings', 'themewar'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .logo' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'is_header',
                            'operator' => '==',
                            'value' => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'sticky_logo_padding', [
                'label' => esc_html__('Sticky Logo Paddings', 'themewar'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} header.fixedHeader .logo' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'is_header',
                            'operator' => '==',
                            'value' => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'logo_right_border_color',
            [
                'label' => esc_html__('Border Right Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header02 .logo' => 'border-color: {{VALUE}}',
                ],
                'conditions' => [
                    'terms'  => [
                        [
                            'name' => 'header_style',
                            'operator' => 'in',
                            'value' => ['2'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_control(
            'heading_un_menu_btn', [
                'label' => esc_html__('Menu Btn Style', 'themewar'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'conditions' => [
                    'terms'  => [
                        [
                            'name'      => 'header_style',
                            'operator'  => 'in',
                            'value'     => ['4', '5'],
                        ]
                    ],
                ],
            ]
        );
        $this->start_controls_tabs( 'style_tabs_menu_btn' );
            $this->start_controls_tab(
                    'menu_btn_style_normal',
                    [
                            'label' => esc_html__( 'Normal', 'themewar' ),
                            'conditions' => [
                                'terms'  => [
                                    [
                                        'name'      => 'header_style',
                                        'operator'  => 'in',
                                        'value'     => ['4', '5'],
                                    ]
                                ],
                            ],
                    ]
            );
            $this->add_responsive_control(
                'menu_btn_color',
                [
                    'label' => esc_html__('BG Color', 'themewar'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .popup_togggle_menu'   => 'background: {{VALUE}}',
                        '{{WRAPPER}} .popup_togggle_menu02' => 'background: {{VALUE}}',
                    ],
                    'conditions' => [
                        'terms'  => [
                            [
                                'name'      => 'header_style',
                                'operator'  => 'in',
                                'value'     => ['4', '5'],
                            ]
                        ],
                    ],
                ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name'      => 'menu_area_btn_border',
                            'label'     => esc_html__( 'Area Border', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .popup_togggle_menu, {{WRAPPER}} .popup_togggle_menu02',
                            'conditions' => [
                                'terms'  => [
                                    [
                                        'name'      => 'header_style',
                                        'operator'  => 'in',
                                        'value'     => ['4', '5'],
                                    ]
                                ],
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name'      => 'nav_border_background',
                            'label'     => esc_html__( 'Background', 'themewar' ),
                            'types'     => [ 'classic', 'gradient'],
                            'selector'  => '{{WRAPPER}} .popup_togggle_menu span, {{WRAPPER}} .popup_togggle_menu02 span',
                            'conditions' => [
                                'terms'  => [
                                    [
                                        'name'      => 'header_style',
                                        'operator'  => 'in',
                                        'value'     => ['4', '5'],
                                    ]
                                ],
                            ],
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'menu_btn_style_hover',
                    [
                            'label' => esc_html__( 'Hover', 'themewar' ),
                            'conditions' => [
                                'terms'  => [
                                    [
                                        'name'      => 'header_style',
                                        'operator'  => 'in',
                                        'value'     => ['4', '5'],
                                    ]
                                ],
                            ],
                    ]
            );
            $this->add_responsive_control(
                'menu_btn_hover_color',
                [
                    'label' => esc_html__('BG Color', 'themewar'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .popup_togggle_menu:hover' => 'background: {{VALUE}}',
                    ],
                    'conditions' => [
                        'terms'  => [
                            [
                                'name'      => 'header_style',
                                'operator'  => 'in',
                                'value'     => ['4', '5'],
                            ]
                        ],
                    ],
                ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name'      => 'menu_area_hover_btn_border',
                            'label'     => esc_html__( 'Border', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .popup_togggle_menu:hover, {{WRAPPER}} .popup_togggle_menu02:hover',
                            'conditions' => [
                                'terms'  => [
                                    [
                                        'name'      => 'header_style',
                                        'operator'  => 'in',
                                        'value'     => ['4', '5'],
                                    ]
                                ],
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name'      => 'nav_border_hover_background',
                            'label'     => esc_html__( 'Background', 'themewar' ),
                            'types'     => [ 'classic', 'gradient'],
                            'selector'  => '{{WRAPPER}} .popup_togggle_menu span:after, {{WRAPPER}} .popup_togggle_menu02.active span:after, {{WRAPPER}} .popup_togggle_menu02:hover span:after',
                            'conditions' => [
                                'terms'  => [
                                    [
                                        'name'      => 'header_style',
                                        'operator'  => 'in',
                                        'value'     => ['4', '5'],
                                    ]
                                ],
                            ],
                    ]
            );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control(
            'heading_un_menu_area', [
                'label' => esc_html__('Popup / Sidebar Menu Area BG', 'themewar'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'conditions' => [
                    'terms'  => [
                        [
                            'name'      => 'header_style',
                            'operator'  => 'in',
                            'value'     => ['4', '5'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name'      => 'popup_menu_ara_background',
                        'label'     => esc_html__( 'Background', 'themewar' ),
                        'types'     => [ 'classic', 'gradient'],
                        'selector'  => '{{WRAPPER}} .popup_menu, {{WRAPPER}} .sidebarMenu',
                        'conditions' => [
                            'terms'  => [
                                [
                                    'name'      => 'header_style',
                                    'operator'  => 'in',
                                    'value'     => ['4', '5'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
            'heading_un_menu_closeBtn', [
                'label' => esc_html__('Popup Close Btn Style', 'themewar'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'conditions' => [
                    'terms'  => [
                        [
                            'name'      => 'header_style',
                            'operator'  => '==',
                            'value'     => '4',
                        ]
                    ],
                ],
            ]
        );
        $this->start_controls_tabs( 'style_tabs_popup_close' );
            $this->start_controls_tab(
                    'popup_close_style_normal',
                    [
                            'label' => esc_html__( 'Normal', 'themewar' ),
                            'conditions' => [
                                'terms'  => [
                                    [
                                        'name'      => 'header_style',
                                        'operator'  => '==',
                                        'value'     => '4',
                                    ]
                                ],
                            ],
                    ]
            );
        $this->add_responsive_control(
                'popup_close_color',
                [
                    'label' => esc_html__('BG Color', 'themewar'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .close-popup' => 'background: {{VALUE}}',
                    ],
                    'conditions' => [
                        'terms'  => [
                            [
                                'name'      => 'header_style',
                                'operator'  => '==',
                                'value'     => '4',
                            ]
                        ],
                    ],
                ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name'      => 'popup_close_background',
                            'label'     => esc_html__( 'Background', 'themewar' ),
                            'types'     => [ 'classic', 'gradient'],
                            'selector'  => '{{WRAPPER}} .close-popup:after, {{WRAPPER}} .close-popup:before',
                            'conditions' => [
                                'terms'  => [
                                    [
                                        'name'      => 'header_style',
                                        'operator'  => '==',
                                        'value'     => '4',
                                    ]
                                ],
                            ],
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'popup_close_style_hover',
                    [
                            'label' => esc_html__( 'Hover', 'themewar' ),
                            'conditions' => [
                                'terms'  => [
                                    [
                                        'name'      => 'header_style',
                                        'operator'  => '==',
                                        'value'     => '4',
                                    ]
                                ],
                            ],
                    ]
            );
            $this->add_responsive_control(
                'popup_close_hover_color',
                [
                    'label' => esc_html__('BG Color', 'themewar'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .close-popup:hover' => 'background: {{VALUE}}',
                    ],
                    'conditions' => [
                        'terms'  => [
                            [
                                'name'      => 'header_style',
                                'operator'  => '==',
                                'value'     => '4',
                            ]
                        ],
                    ],
                ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name'      => 'popup_close_hover_background',
                            'label'     => esc_html__( 'Background', 'themewar' ),
                            'types'     => [ 'classic', 'gradient'],
                            'selector'  => '{{WRAPPER}} .close-popup:hover:after, {{WRAPPER}} .close-popup:hover:before',
                            'conditions' => [
                                'terms'  => [
                                    [
                                        'name'      => 'header_style',
                                        'operator'  => '==',
                                        'value'     => '4',
                                    ]
                                ],
                            ],
                    ]
            );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control(
            'heading_un_menu', [
                'label' => esc_html__('Menu Level 1 Style', 'themewar'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->start_controls_tabs( 'style_tabs_menu01' );
            $this->start_controls_tab(
                    'menu_01_style_normal',
                    [
                            'label' => esc_html__( 'Normal', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                'menu_color',
                [
                    'label' => esc_html__('Color', 'themewar'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .sidebar_menu ul li a' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .mainMenu ul li a' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .menu_popup ul li a' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .mainMenu #mega-menu-wrap-primary-menu #mega-menu-primary-menu a.mega-menu-link' => 'color: {{VALUE}} !important',
                    ],
                ]
            );
            $this->add_responsive_control(
                'menu_1_border_color',
                [
                    'label' => esc_html__('Border Color', 'themewar'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .sidebar_menu ul li > a:after' => 'background: {{VALUE}}',
                    ],
                    'conditions' => [
                        'terms'  => [
                            [
                                'name'      => 'header_style',
                                'operator'  => '==',
                                'value'     => '5',
                            ]
                        ],
                    ],
                ]
            );
            $this->add_responsive_control(
                'menu_icon_color',
                [
                    'label' => esc_html__('Icon Color', 'themewar'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .mainMenu ul li.menu-item-has-children > a::before' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .menu_popup ul li.menu-item-has-children > a:before' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .mainMenu #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item-has-children > a.mega-menu-link > span.mega-indicator:before' => 'color: {{VALUE}} !important',
                    ],
                    'conditions' => [
                        'terms'  => [
                            [
                                'name'      => 'header_style',
                                'operator'  => '!in',
                                'value'     => ['5'],
                            ]
                        ],
                    ],
                ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'menu_01_style_hover',
                    [
                            'label' => esc_html__( 'Hover', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                'menu_hover_color',
                [
                    'label' => esc_html__('Color', 'themewar'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .sidebar_menu ul li:hover > a' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .sidebar_menu ul li.active > a' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .mainMenu ul li:hover > a' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .mainMenu ul li.current-menu-item > a' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .menu_popup ul li:hover > a' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .menu_popup ul li.current-menu-item > a' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .mainMenu #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-current-menu-item > a.mega-menu-link' => 'color: {{VALUE}} !important',
                        '{{WRAPPER}} .mainMenu #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li:hover > a.mega-menu-link' => 'color: {{VALUE}} !important',
                    ],
                ]
            );
            $this->add_responsive_control(
                'menu_1_border_hover_color',
                [
                    'label' => esc_html__('Border Color', 'themewar'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .sidebar_menu ul li.active > a:after' => 'background: {{VALUE}}',
                        '{{WRAPPER}} .sidebar_menu ul li:hover > a:after' => 'background: {{VALUE}}',
                    ],
                    'conditions' => [
                        'terms'  => [
                            [
                                'name'      => 'header_style',
                                'operator'  => '==',
                                'value'     => '5',
                            ]
                        ],
                    ],
                ]
            );
            $this->add_responsive_control(
                'menu_1_dots_hover_color',
                [
                    'label' => esc_html__('Dots Color', 'themewar'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .sidebar_menu ul li > a:before' => 'background: {{VALUE}}',
                    ],
                    'conditions' => [
                        'terms'  => [
                            [
                                'name'      => 'header_style',
                                'operator'  => '==',
                                'value'     => '5',
                            ]
                        ],
                    ],
                ]
            );
            $this->add_responsive_control(
                'menu_hover_icon_color',
                [
                    'label' => esc_html__('Icon Color', 'themewar'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .mainMenu ul li.menu-item-has-children:hover > a::before' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .mainMenu ul li.menu-item-has-children.current-menu-item > a::before' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .menu_popup ul li.menu-item-has-children:hover > a::before' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .menu_popup ul li.menu-item-has-children.current-menu-item > a::before' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .mainMenu #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-item-has-children.mega-current-menu-item > a.mega-menu-link > span.mega-indicator:before' => 'color: {{VALUE}} !important',
                        '{{WRAPPER}} .mainMenu #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li:hover > a.mega-menu-link > span.mega-indicator:before' => 'color: {{VALUE}} !important',
                    ],
                    'conditions' => [
                        'terms'  => [
                            [
                                'name'      => 'header_style',
                                'operator'  => '!in',
                                'value'     => ['5'],
                            ]
                        ],
                    ],
                ]
            );
            $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control(
            'heading_un_sub_menu', [
                'label' => esc_html__('Menu Level 2 Style', 'themewar'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->start_controls_tabs( 'style_tabs_menu02' );
            $this->start_controls_tab(
                    'menu_02_style_normal',
                    [
                            'label' => esc_html__( 'Normal', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                'submenu_area_bg_color',
                [
                    'label' => esc_html__('BG Color', 'themewar'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .sidebar_menu ul ul.sub-menu' => 'background: {{VALUE}}',
                        '{{WRAPPER}} .mainMenu ul li .sub-menu' => 'background: {{VALUE}}',
                        '{{WRAPPER}} .menu_popup ul li ul.sub-menu' => 'background: {{VALUE}}',
                        '{{WRAPPER}} .menu_popup ul li ul.sub-menu::after' => 'border-right-color: {{VALUE}}',
                        '{{WRAPPER}} .mainMenu #mega-menu-wrap-primary-menu #mega-menu-primary-menu li ul.mega-sub-menu' => 'background: {{VALUE}} !important',
                    ],
                ]
            );
            $this->add_responsive_control(
                'submenu_sc_border_right_color',
                [
                    'label' => esc_html__('Scroll Border Right Color', 'themewar'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar' => 'background: {{VALUE}} !important',
                    ],
                    'conditions' => [
                        'terms'  => [
                            [
                                'name'      => 'header_style',
                                'operator'  => '==',
                                'value'     => '4',
                            ]
                        ],
                    ],
                ]
            );
            $this->add_responsive_control(
                'submenu_border_top_color',
                [
                    'label' => esc_html__('Border Top Color', 'themewar'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .mainMenu ul li .sub-menu' => 'border-color: {{VALUE}}',
                        '{{WRAPPER}} .mainMenu #mega-menu-wrap-primary-menu #mega-menu-primary-menu li ul.mega-sub-menu' => 'border-color: {{VALUE}} !important',
                    ],
                    'conditions' => [
                        'terms'  => [
                            [
                                'name'      => 'header_style',
                                'operator'  => '!in',
                                'value'     => ['5'],
                            ]
                        ],
                    ],
                ]
            );
            $this->add_responsive_control(
                'submenu_color',
                [
                    'label' => esc_html__('Color', 'themewar'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .sidebar_menu ul ul.sub-menu li a' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .mainMenu ul li .sub-menu li a' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .menu_popup ul li ul.sub-menu li a' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .mainMenu #mega-menu-wrap-primary-menu #mega-menu-primary-menu li ul.mega-sub-menu li.mega-menu-item a' => 'color: {{VALUE}} !important',
                    ],
                ]
            );
            $this->add_responsive_control(
                'submenu_bg_color',
                [
                    'label' => esc_html__('Item BG Color', 'themewar'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .sidebar_menu ul ul.sub-menu li a' => 'background: {{VALUE}}',
                        '{{WRAPPER}} .mainMenu ul li .sub-menu li a' => 'background: {{VALUE}}',
                        '{{WRAPPER}} .menu_popup ul li ul.sub-menu li a' => 'background: {{VALUE}}',
                        '{{WRAPPER}} .mainMenu #mega-menu-wrap-primary-menu #mega-menu-primary-menu li ul.mega-sub-menu li.mega-menu-item a' => 'background: {{VALUE}} !important',
                    ],
                ]
            );
            $this->add_responsive_control(
                'submenu_border_color',
                [
                    'label' => esc_html__('Item Border Color', 'themewar'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .sidebar_menu ul ul.sub-menu li > a:after' => 'background: {{VALUE}}',
                        '{{WRAPPER}} .mainMenu ul li .sub-menu li' => 'border-color: {{VALUE}}',
                        '{{WRAPPER}} .mainMenu #mega-menu-wrap-primary-menu #mega-menu-primary-menu li ul.mega-sub-menu li.mega-menu-item' => 'border-color: {{VALUE}} !important',
                    ],
                ]
            );
            $this->add_responsive_control(
                'submenu_dots_color',
                [
                    'label' => esc_html__('Item Dots Color', 'themewar'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .sidebar_menu ul ul.sub-menu li > a:before' => 'background: {{VALUE}}',
                        '{{WRAPPER}} .mainMenu ul .sub-menu li.menu-item-has-children > a::before' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .menu_popup ul .sub-menu li.menu-item-has-children > a::before' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .mainMenu #mega-menu-wrap-primary-menu #mega-menu-primary-menu li ul.mega-sub-menu li.mega-menu-item-has-children > a.mega-menu-link > span.mega-indicator:before' => 'color: {{VALUE}} !important',
                    ],
                ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'menu_02_style_hover',
                    [
                            'label' => esc_html__( 'Hover', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                'submenu_hover_color',
                [
                    'label' => esc_html__('Item Color', 'themewar'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .sidebar_menu ul ul.sub-menu li.active > a'  => 'color: {{VALUE}}',
                        '{{WRAPPER}} .sidebar_menu ul ul.sub-menu li:hover > a' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .mainMenu ul li .sub-menu li.current-menu-item > a' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .mainMenu ul li .sub-menu li:hover > a' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .menu_popup ul li .sub-menu li.current-menu-item > a' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .menu_popup ul li .sub-menu li:hover > a' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .mainMenu #mega-menu-wrap-primary-menu #mega-menu-primary-menu li ul.mega-sub-menu > li.mega-current_page_item > a' => 'color: {{VALUE}} !important',
                        '{{WRAPPER}} .mainMenu #mega-menu-wrap-primary-menu #mega-menu-primary-menu li ul.mega-sub-menu > li.mega-menu-item:hover > a' => 'color: {{VALUE}} !important',
                    ],
                ]
            );
            $this->add_responsive_control(
                'submenu_hover_bg_color',
                [
                    'label' => esc_html__('Item BG Color', 'themewar'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .mainMenu ul li .sub-menu li.current-menu-item > a' => 'background: {{VALUE}}',
                        '{{WRAPPER}} .mainMenu ul li .sub-menu li:hover > a' => 'background: {{VALUE}}',
                        '{{WRAPPER}} .menu_popup ul li .sub-menu li.current-menu-item > a' => 'background: {{VALUE}}',
                        '{{WRAPPER}} .menu_popup ul li .sub-menu li:hover > a' => 'background: {{VALUE}}',
                        '{{WRAPPER}} .mainMenu #mega-menu-wrap-primary-menu #mega-menu-primary-menu li ul.mega-sub-menu > li.mega-current_page_item > a' => 'background: {{VALUE}} !important',
                        '{{WRAPPER}} .mainMenu #mega-menu-wrap-primary-menu #mega-menu-primary-menu li ul.mega-sub-menu > li.mega-menu-item:hover > a' => 'background: {{VALUE}} !important',
                    ],
                ]
            );
            $this->add_responsive_control(
                'submenu_hover_border_color',
                [
                    'label' => esc_html__('Item Border Color', 'themewar'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .sidebar_menu ul ul.sub-menu li.active > a:after' => 'background: {{VALUE}}',
                        '{{WRAPPER}} .sidebar_menu ul ul.sub-menu li:hover > a:after' => 'background: {{VALUE}}',
                        '{{WRAPPER}} .mainMenu ul li .sub-menu li.current-menu-item' => 'border-color: {{VALUE}}',
                        '{{WRAPPER}} .mainMenu ul li .sub-menu li:hover' => 'border-color: {{VALUE}}',
                        '{{WRAPPER}} .mainMenu #mega-menu-wrap-primary-menu #mega-menu-primary-menu li ul.mega-sub-menu li.mega-current_page_item' => 'border-color: {{VALUE}} !important',
                        '{{WRAPPER}} .mainMenu #mega-menu-wrap-primary-menu #mega-menu-primary-menu li ul.mega-sub-menu li.mega-menu-item:hover' => 'border-color: {{VALUE}} !important',
                    ],
                ]
            );
            $this->add_responsive_control(
                'submenu_dots_hover_color',
                [
                    'label' => esc_html__('Item Dots Color', 'themewar'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .sidebar_menu ul ul.sub-menu li.active > a:before' => 'background: {{VALUE}}',
                        '{{WRAPPER}} .sidebar_menu ul ul.sub-menu li:hover > a:before'  => 'background: {{VALUE}}',
                        '{{WRAPPER}} .mainMenu ul .sub-menu li.menu-item-has-children:hover > a::before' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .mainMenu ul .sub-menu li.menu-item-has-children.current-menu-item > a::before' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .menu_popup ul .sub-menu li.menu-item-has-children:hover > a::before' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .menu_popup ul .sub-menu li.menu-item-has-children.current-menu-item > a::before' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .mainMenu #mega-menu-wrap-primary-menu #mega-menu-primary-menu li ul.mega-sub-menu li.mega-menu-item-has-children:hover > a.mega-menu-link > span.mega-indicator:before' => 'color: {{VALUE}} !important',
                        '{{WRAPPER}} .mainMenu #mega-menu-wrap-primary-menu #mega-menu-primary-menu li ul.mega-sub-menu li.mega-menu-item-has-children.mega-current_page_item > a.mega-menu-link > span.mega-indicator:before' => 'color: {{VALUE}} !important',
                    ],
                ]
            );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control(
            'heading_un_showcae', [
                'label' => esc_html__('Home Showcase Menu Style', 'themewar'),
                'type' => Controls_Manager::HEADING,
                'separator'  => 'before',
            ]
        );
        $this->add_responsive_control(
            'showcase_area_bg_color',
            [
                'label' => esc_html__('BG Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mainMenu #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.megamenu > ul.mega-sub-menu' => 'background: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_responsive_control(
            'showcase_border_top_color',
            [
                'label' => esc_html__('Border Top Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mainMenu #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.megamenu > ul.mega-sub-menu' => 'border-color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_responsive_control(
            'showcase_title_color',
            [
                'label' => esc_html__('Item Title Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .showcase h5' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'showcase_title_diff_color',
            [
                'label' => esc_html__('Item Title Different Txt Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .showcase h5 span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'heading_un_moible_menu', [
                'label' => esc_html__('Mobile Menu Btn Style', 'themewar'),
                'type' => Controls_Manager::HEADING,
                'separator'  => 'before',
            ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name'  => 'mobile_menu_btn_bg_background',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic' ],
                        'selector' => '{{WRAPPER}} .menu_btn',
                ]
        );
        $this->add_control(
            'heading_h5_un_socail', [
                'label' => esc_html__('Social Style', 'themewar'),
                'type' => Controls_Manager::HEADING,
                'separator'  => 'before',
                'conditions' => [
                    'terms'  => [
                        [
                            'name'     => 'header_style',
                            'operator' => '==',
                            'value'    => '5',
                        ]
                    ],
                ],
            ]
        );
        $this->start_controls_tabs('style_socail_h5');
        $this->start_controls_tab(
            'socail_icon_h5_style_normal',
            [
                'label' => esc_html__('Normal', 'themewar'),
                'conditions' => [
                    'terms'  => [
                        [
                            'name' => 'header_style',
                            'operator' => '==',
                            'value'     => '5',
                        ]
                    ],
                ],
            ]
        );
        $this->add_control(
            'heading_gr_color_socail', [
                'label' => esc_html__('Social Gradiant Color', 'themewar'),
                'type' => Controls_Manager::HEADING,
                'separator'  => 'before',
                'conditions' => [
                    'terms'  => [
                        [
                            'name'     => 'header_style',
                            'operator' => '==',
                            'value'    => '5',
                        ]
                    ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name'  => 'gr_icon_background',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic' ],
                        'selector' => '{{WRAPPER}} .socials_bottom a i',
                        'conditions' => [
                            'terms'  => [
                                [
                                    'name' => 'header_style',
                                    'operator' => '==',
                                    'value'     => '5',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name'      => 'gr_icon_normal_border',
                        'label'     => esc_html__( 'Border', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .socials_bottom a',
                        'conditions' => [
                            'terms'  => [
                                [
                                    'name' => 'header_style',
                                    'operator' => '==',
                                    'value'     => '5',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name'  => 'gr_icon_bg_background',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic' ],
                        'selector' => '{{WRAPPER}} .socials_bottom a',
                        'conditions' => [
                            'terms'  => [
                                [
                                    'name' => 'header_style',
                                    'operator' => '==',
                                    'value'     => '5',
                                ]
                            ],
                        ],
                ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'socail_icon_h5_style_hover',
            [
                'label' => esc_html__('Hover', 'themewar'),
                'conditions' => [
                    'terms'  => [
                        [
                            'name'      => 'header_style',
                            'operator' => '==',
                            'value'     => '5',
                        ]
                    ],
                ],
            ]
        );
        $this->add_control(
            'heading_gr_color_hover_socail', [
                'label' => esc_html__('Social Gradiant Color', 'themewar'),
                'type' => Controls_Manager::HEADING,
                'separator'  => 'before',
                'conditions' => [
                    'terms'  => [
                        [
                            'name'     => 'header_style',
                            'operator' => '==',
                            'value'    => '5',
                        ]
                    ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name'  => 'gr_icon_hover_background',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic' ],
                        'selector' => '{{WRAPPER}} .socials_bottom a:hover i',
                        'conditions' => [
                            'terms'  => [
                                [
                                    'name' => 'header_style',
                                    'operator' => '==',
                                    'value'     => '5',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name'      => 'gr_icon_hover_border',
                        'label'     => esc_html__( 'Border', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .socials_bottom a:hover',
                        'conditions' => [
                            'terms'  => [
                                [
                                    'name' => 'header_style',
                                    'operator' => '==',
                                    'value'     => '5',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name'  => 'gr_icon_hover_bg_background',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic' ],
                        'selector' => '{{WRAPPER}} .socials_bottom a:hover',
                        'conditions' => [
                            'terms'  => [
                                [
                                    'name' => 'header_style',
                                    'operator' => '==',
                                    'value'     => '5',
                                ]
                            ],
                        ],
                ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control(
            'heading_un_socail', [
                'label' => esc_html__('Social Style', 'themewar'),
                'type' => Controls_Manager::HEADING,
                'separator'  => 'before',
                'conditions' => [
                    'terms'  => [
                        [
                            'name'      => 'header_style',
                            'operator'  => '==',
                            'value'     => '2',
                        ]
                    ],
                ],
            ]
        );
        $this->start_controls_tabs('style_socail');
        $this->start_controls_tab(
            'socail_icon_style_normal',
            [
                'label' => esc_html__('Normal', 'themewar'),
                'conditions' => [
                    'terms'  => [
                        [
                            'name'      => 'header_style',
                            'operator'  => '==',
                            'value'     => '2',
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'socail_icon_border_color',
            [
                'label' => esc_html__('Border Left Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accessNav .topsocial:after' => 'background: {{VALUE}}',
                ],
                'conditions' => [
                    'terms'  => [
                        [
                            'name'      => 'header_style',
                            'operator'  => '==',
                            'value'     => '2',
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'socail_icon_color',
            [
                'label' => esc_html__('Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accessNav .topsocial a' => 'color: {{VALUE}}',
                ],
                'conditions' => [
                    'terms'  => [
                        [
                            'name'      => 'header_style',
                            'operator'  => '==',
                            'value'     => '2',
                        ]
                    ],
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'socail_icon_style_hover',
            [
                'label' => esc_html__('Hover', 'themewar'),
                'conditions' => [
                    'terms'  => [
                        [
                            'name'      => 'header_style',
                            'operator'  => '==',
                            'value'     => '2',
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'socail_icon_hover_color',
            [
                'label' => esc_html__('Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accessNav .topsocial a:hover' => 'color: {{VALUE}}',
                ],
                'conditions' => [
                    'terms'  => [
                        [
                            'name'      => 'header_style',
                            'operator'  => '==',
                            'value'     => '2',
                        ]
                    ],
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control(
            'heading_un_search', [
                'label' => esc_html__('Search Btn Style', 'themewar'),
                'type' => Controls_Manager::HEADING,
                'separator'  => 'before',
                'conditions' => [
                    'terms'  => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['3'],
                        ]
                    ],
                ],
            ]
        );
        $this->start_controls_tabs('style_search');
        $this->start_controls_tab(
            'search_style_normal',
            [
                'label' => esc_html__('Normal', 'themewar'),
                'conditions' => [
                    'terms'  => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['3'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'search_border_color',
            [
                'label' => esc_html__('Border Left Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header02 .accessNav .search_btn:after' => 'background: {{VALUE}}',
                ],
                'conditions' => [
                    'terms'  => [
                        [
                            'name' => 'header_style',
                            'operator' => 'in',
                            'value' => ['2'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'search_label_color',
            [
                'label' => esc_html__('Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accessNav .search_btn' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .accessNav02 a.search_btn' => 'color: {{VALUE}}',
                ],
                'conditions' => [
                    'terms'  => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['3'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name'      => 'btn2_search_border',
                        'label'     => esc_html__( 'Border', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .accessNav02 a.search_btn',
                        'conditions' => [
                            'terms'  => [
                                [
                                    'name' => 'header_style',
                                    'operator' => '==',
                                    'value'     => '5',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_responsive_control(
            'btn_search_bg',
            [
                'label' => esc_html__('BG Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accessNav .search_btn' => 'background: {{VALUE}}',
                    '{{WRAPPER}} .accessNav02 a.search_btn' => 'background: {{VALUE}}',
                ],
                'conditions' => [
                    'terms'  => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['3', '4'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'h4_search_btn_bg',
                    'label' => esc_html__( 'Background', 'themewar' ),
                    'types' => [ 'classic', 'gradient'],
                    'selector' => '{{WRAPPER}} .header04 .accessNav .search_btn',
                    'conditions' => [
                        'terms' => [
                            [
                                'name'      => 'header_style',
                                'operator'  => '==',
                                'value'     => '4',
                            ]
                        ],
                    ],
                ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'search_style_hover',
            [
                'label' => esc_html__('Hover', 'themewar'),
                'conditions' => [
                    'terms'  => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['3'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'search_hover_color',
            [
                'label' => esc_html__('Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accessNav .search_btn:hover' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .accessNav02 a.search_btn:hover' => 'color: {{VALUE}}',
                ],
                'conditions' => [
                    'terms'  => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['3'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name'      => 'btn2_search_hover_border',
                        'label'     => esc_html__( 'Border', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .accessNav02 a.search_btn:hover',
                        'conditions' => [
                            'terms'  => [
                                [
                                    'name' => 'header_style',
                                    'operator' => '==',
                                    'value'     => '5',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_responsive_control(
            'search_1_hover_bg',
            [
                'label' => esc_html__('BG Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accessNav .search_btn:hover' => 'background: {{VALUE}}',
                    '{{WRAPPER}} .accessNav02 a.search_btn:hover' => 'background: {{VALUE}}',
                ],
                'conditions' => [
                    'terms'  => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['3','4'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'h4_search_btn_hover_bg',
                    'label' => esc_html__( 'Background', 'themewar' ),
                    'types' => [ 'classic', 'gradient'],
                    'selector' => '{{WRAPPER}} .header04 .accessNav .search_btn:after',
                    'conditions' => [
                        'terms' => [
                            [
                                'name'      => 'header_style',
                                'operator'  => '==',
                                'value'     => '4',
                            ]
                        ],
                    ],
                ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control(
            'heading_un_search_form', [
                'label' => esc_html__('Search Form Style', 'themewar'),
                'type' => Controls_Manager::HEADING,
                'separator'  => 'before',
                'conditions' => [
                    'terms'  => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['3'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'search_form_bg_color',
            [
                'label' => esc_html__('From BG Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pop_search_background' => 'background: {{VALUE}}',
                ],
                'conditions' => [
                    'terms'  => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['3'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'search_form_overlay_bg_color',
            [
                'label' => esc_html__('From Overlay BG Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .popup_search_overlay' => 'background: {{VALUE}}',
                ],
                'conditions' => [
                    'terms'  => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['3'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'search_form_input_color',
            [
                'label' => esc_html__('From Input Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .popup_search_form input[type="search"]' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .popup_search_form input[type="search"]::-moz-placeholder' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .popup_search_form input[type="search"]::-ms-input-placeholder' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .popup_search_form input[type="search"]::-webkit-input-placeholder' => 'color: {{VALUE}}',
                ],
                'conditions' => [
                    'terms'  => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['3'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'search_form_border_color',
            [
                'label' => esc_html__('From Input Border Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .popup_search_form:after' => 'background: {{VALUE}}',
                ],
                'conditions' => [
                    'terms'  => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['3'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'search_form_hover_border_color',
            [
                'label' => esc_html__('From Input Hover Border Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .popup_search_form:before' => 'background: {{VALUE}}',
                ],
                'conditions' => [
                    'terms'  => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['3'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'search_form_btn_color',
            [
                'label' => esc_html__('From Btn Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .popup_search_form button[type="submit"]' => 'color: {{VALUE}}',
                ],
                'conditions' => [
                    'terms'  => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['3'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'search_form_btn_hover_color',
            [
                'label' => esc_html__('From Btn Hover Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .popup_search_form button[type="submit"]:hover' => 'color: {{VALUE}}',
                ],
                'conditions' => [
                    'terms'  => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['3'],
                        ]
                    ],
                ],
            ]
        );

        $this->add_control(
            'heading_un_wc', [
                'label' => esc_html__('Cart Btn Style', 'themewar'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['2','3'],
                        ]
                    ],
                ],
            ]
        );
        $this->start_controls_tabs('style_wc');
        $this->start_controls_tab(
            'wc_style_normal',
            [
                'label' => esc_html__('Normal', 'themewar'),
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['2','3'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'wc_label_color',
            [
                'label' => esc_html__('Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .shoping_cart a.cartBtn' => 'color: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['2','3'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name'      => 'btn2_cart_btn_border',
                        'label'     => esc_html__( 'Border', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .header05 .shoping_cart a.cartBtn',
                        'conditions' => [
                            'terms'  => [
                                [
                                    'name' => 'header_style',
                                    'operator' => '==',
                                    'value'     => '5',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_responsive_control(
            'btn_wc_bg',
            [
                'label' => esc_html__('BG Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .shoping_cart a.cartBtn' => 'background: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['2','3', '4'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'h4_cart_btn_bg',
                    'label' => esc_html__( 'Background', 'themewar' ),
                    'types' => [ 'classic', 'gradient'],
                    'selector' => '{{WRAPPER}} .header04 .shoping_cart a.cartBtn',
                    'conditions' => [
                        'terms' => [
                            [
                                'name'      => 'header_style',
                                'operator'  => '==',
                                'value'     => '4',
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
            'wc_count_number_color',
            [
                'label' => esc_html__('Number Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .shoping_cart a.cartBtn span' => 'color: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['2','3'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'wc_count_number_bg',
            [
                'label' => esc_html__('Number BG Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .shoping_cart a.cartBtn span' => 'background: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['2','3'],
                        ]
                    ],
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'wc_style_hover',
            [
                'label' => esc_html__('Hover', 'themewar'),
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['2','3'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'wc_label_hover_color',
            [
                'label' => esc_html__('Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .shoping_cart:hover a.cartBtn' => 'color: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['2','3'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name'      => 'btn2_cart_hover_btn_border',
                        'label'     => esc_html__( 'Border', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .header05 .shoping_cart a.cartBtn:hover',
                        'conditions' => [
                            'terms'  => [
                                [
                                    'name' => 'header_style',
                                    'operator' => '==',
                                    'value'     => '5',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_responsive_control(
            'btn_wc_hover_bg',
            [
                'label' => esc_html__('BG Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .shoping_cart:hover a.cartBtn' => 'background: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['2','3', '4'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'h4_cart_btn_hover_bg',
                    'label' => esc_html__( 'Background', 'themewar' ),
                    'types' => [ 'classic', 'gradient'],
                    'selector' => '{{WRAPPER}} .header04 .shoping_cart a.cartBtn:after',
                    'conditions' => [
                        'terms' => [
                            [
                                'name'      => 'header_style',
                                'operator'  => '==',
                                'value'     => '4',
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
            'wc_hover_count_number_color',
            [
                'label' => esc_html__('Number Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .shoping_cart:hover a.cartBtn span' => 'color: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['2','3'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'wc_hover_count_number_bg',
            [
                'label' => esc_html__('Number BG Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .shoping_cart:hover a.cartBtn span' => 'background: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['2','3'],
                        ]
                    ],
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control(
            'heading_un_min_cart', [
                'label' => esc_html__('Mini Cart Style', 'themewar'),
                'type' => Controls_Manager::HEADING,
                'separator'  => 'before',
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['2','3'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'mini_cart_area_bg',
            [
                'label' => esc_html__('Area BG Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .shoping_cart .show_cart_area' => 'background: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['2','3'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'mini_cart_area_border_color',
            [
                'label' => esc_html__('Area Border Top Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .shoping_cart .show_cart_area' => 'border-color: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['2','3'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'mini_cart_cart_bg',
            [
                'label' => esc_html__('Cart Close BG Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .show_cart_area .widget_shopping_cart_content ul li .mc_item .remove' => 'background: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['2','3'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'mini_cart_cart_hover_bg',
            [
                'label' => esc_html__('Cart Close Hover BG Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .show_cart_area .widget_shopping_cart_content ul li .mc_item .remove:hover' => 'background: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['2','3'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'mini_cart_cart_title',
            [
                'label' => esc_html__('Product Title Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .show_cart_area .widget_shopping_cart_content ul li .mc_item h4' => 'color: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['2','3'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'mini_cart_cart_hover_title',
            [
                'label' => esc_html__('Product Title Hover Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .show_cart_area .widget_shopping_cart_content ul li .mc_item h4 a:hover' => 'color: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['2','3'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'mini_cart_cart_subtotal',
            [
                'label' => esc_html__('Sub Total Price Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .widget_shopping_cart_content p.total .amount' => 'color: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['2','3'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'mini_cart_cart_l_btn',
            [
                'label' => esc_html__('Cart Btn BG Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .widget_shopping_cart_content p.buttons .button' => 'background: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['2','3'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'mini_cart_cart_l_hover_btn',
            [
                'label' => esc_html__('Cart Btn Hover BG Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .widget_shopping_cart_content p.buttons .button:before' => 'background: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['2','3'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'mini_cart_checkout_l_btn',
            [
                'label' => esc_html__('Checkout Btn BG Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .widget_shopping_cart_content p.buttons .button.checkout' => 'background: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['2','3'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'mini_cart_checkout_l_hover_btn',
            [
                'label' => esc_html__('Checkout Btn Hover BG Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .widget_shopping_cart_content p.buttons .button.checkout:before' => 'background: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['2','3'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_control(
            'heading_un_btn', [
                'label' => esc_html__('Btn Style', 'themewar'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['2','4'],
                        ]
                    ],
                ],
            ]
        );
        $this->start_controls_tabs('style_btn');
        $this->start_controls_tab(
            'btn_style_normal',
            [
                'label' => esc_html__('Normal', 'themewar'),
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['2','4'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'btn_label_color',
            [
                'label' => esc_html__('Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .berpo_btn' => 'color: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['2','4'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'c_btn_normal_bg',
                    'label' => esc_html__( 'Background', 'themewar' ),
                    'types' => [ 'classic', 'gradient'],
                    'selector' => '{{WRAPPER}} .berpo_btn',
                    'conditions' => [
                        'terms' => [
                            [
                                'name' => 'header_style',
                                'operator' => '!in',
                                'value' => ['2','4'],
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
            'btn_icon_color',
            [
                'label' => esc_html__('Icon Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .berpo_btn.with_icon02 i' => 'color: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name'     => 'header_style',
                            'operator' => '==',
                            'value'    => '3',
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'btn_icon_bg_color',
            [
                'label' => esc_html__('Icon BG Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .berpo_btn.with_icon02 i' => 'background: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name'     => 'header_style',
                            'operator' => '==',
                            'value'    => '3',
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'btn_icon_border_color',
            [
                'label' => esc_html__('Icon Border Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .berpo_btn.with_icon02 i' => 'border-color: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name'     => 'header_style',
                            'operator' => '==',
                            'value'    => '3',
                        ]
                    ],
                ],
            ]
        );
        $this->add_control(
            'btn_c_i_radius',
            [
                    'label' => esc_html__( 'Border Radius', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .berpo_btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .berpo_btn.with_icon02 i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .berpo_btn.with_icon02 .btnwrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'conditions' => [
                        'terms' => [
                            [
                                'name' => 'header_style',
                                'operator' => '!in',
                                'value' => ['2','4'],
                            ]
                        ],
                    ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'btn_style_hover',
            [
                'label' => esc_html__('Hover', 'themewar'),
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['2','4'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'btn_label_hover_color',
            [
                'label' => esc_html__('Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .berpo_btn:hover' => 'color: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '!in',
                            'value' => ['2','4'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'c_btn_hover_bg',
                    'label' => esc_html__( 'Background', 'themewar' ),
                    'types' => [ 'classic', 'gradient'],
                    'selector' => '{{WRAPPER}} .berpo_btn .bp-shape',
                    'conditions' => [
                        'terms' => [
                            [
                                'name' => 'header_style',
                                'operator' => '!in',
                                'value' => ['2','4'],
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
            'btn_icon_hover_color',
            [
                'label' => esc_html__('Icon Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .berpo_btn.with_icon02:hover i' => 'color: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name'     => 'header_style',
                            'operator' => '==',
                            'value'    => '3',
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'btn_icon_hover_bg_color',
            [
                'label' => esc_html__('Icon BG Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .berpo_btn.with_icon02:hover i' => 'background: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name'     => 'header_style',
                            'operator' => '==',
                            'value'    => '3',
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'btn_icon_hover_border_color',
            [
                'label' => esc_html__('Icon Border Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .berpo_btn.with_icon02:hover i' => 'border-color: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name'     => 'header_style',
                            'operator' => '==',
                            'value'    => '3',
                        ]
                    ],
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_responsive_control(
            'hinfo_box_padding',
            [
                'label' => esc_html__('Info Box Area Paddings', 'themewar'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .infoHead' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '==',
                            'value' => '2',
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'hinfo_box_border_left_color',
            [
                'label' => esc_html__('Border Left Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .infoHead:after' => 'background: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '==',
                            'value' => '2',
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'hinfo_box_icon_color',
            [
                'label' => esc_html__('Info Icon Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .infoHead i' => 'color: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '==',
                            'value' => '2',
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'hinfo_box_icon_bg_color',
            [
                'label' => esc_html__('Info Icon BG Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .infoHead i' => 'background: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '==',
                            'value' => '2',
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'hinfo_box_label_color',
            [
                'label' => esc_html__('Info Label Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .infoHead h5' => 'color: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '==',
                            'value' => '2',
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
            'hinfo_box_value_color',
            [
                'label' => esc_html__('Info Value Color', 'themewar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .infoHead h5 span' => 'color: {{VALUE}}',
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'header_style',
                            'operator' => '==',
                            'value' => '2',
                        ]
                    ],
                ],
            ]
        );
        $this->end_controls_section();

    }

    protected function render(){
        $settings = $this->get_settings_for_display();

        $header_style = (isset($settings['header_style']) && $settings['header_style'] > 0) ? $settings['header_style'] : 1;
        $is_topbar  = $settings['is_topbar'];
        $info_list = (isset($settings['info_list']) && !empty($settings['info_list'])) ? $settings['info_list'] : array();
        $s_list     = (isset($settings['s_list']) && !empty($settings['s_list'])) ? $settings['s_list'] : array();


        $is_header      = $settings['is_header'];
        $logo           = (isset($settings['logo']['url']) && $settings['logo']['url'] != '') ? $settings['logo']['url'] : '';
        $sticky_logo    = (isset($settings['sticky_logo']['url']) && $settings['sticky_logo']['url'] != '') ? $settings['sticky_logo']['url'] : '';
        $is_serch       = $settings['is_serch'];
        $is_cart        = $settings['is_cart'];
        $is_mini_cart   = $settings['is_mini_cart'];
        $is_contact_btn = $settings['is_contact_btn'];
        $btn_label      = $settings['btn_label'];

        $target         = isset($settings['btn_url']['is_external']) ? ' target="_blank"' : '' ;
        $nofollow       = isset($settings['btn_url']['nofollow']) ? ' rel="nofollow"' : '' ;
        $btn_url        = (isset($settings['btn_url']['url']) && $settings['btn_url']['url'] != '') ? $settings['btn_url']['url'] : '#';

        $s2_list        = (isset($settings['s2_list']) && !empty($settings['s2_list'])) ? $settings['s2_list'] : array();

        $is_info_boxs   = $settings['is_info_boxs'];
        $i_iconss       = $settings['i_iconss'];
        $i_labels       = $settings['i_labels'];
        $i_values       = $settings['i_values'];

        $is_sticky      = isset($settings['is_sticky']);

        include dirname(__FILE__) . '/style/header/style' . $header_style . '.php';
    }
}