<?php

namespace Elementor;

if( !defined('ABSPATH') )
    exit;

class Tw_Folio_Slide_Widget extends Widget_Base{
    
    public function get_name() {
        return 'tw-folio-slide';
    }

    public function get_title() {
        return esc_html__( 'Portfolio Slider', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-slider-album';
    }

    public function get_categories() {
        return ['bepro-elements'];
    }
    
    protected function register_controls() {
        $fol = array(
            'post_type'         => 'folio',
            'post_status'       => 'publish',
            'order_by'          => 'date',
            'order'             => 'DESC',
            'posts_per_page'    => -1
        );
        $fols = array();
        query_posts($fol);
            if(have_posts()):
                while (have_posts()):
                    the_post();
                    $fols[get_the_ID()] = get_the_title();
                endwhile;
            endif;
        wp_reset_query();
        
        $this->start_controls_section(
                'section_tab', [
                    'label'     => esc_html__('Portfolio Slider', 'themewar')
                ]
        );
        $this->add_control(
                'pfs_view',
                [
                        'label'     => esc_html__( 'View Style', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 1,
                        'options'   => [
                                1       => esc_html__( 'Style 01', 'themewar' ),
                                2       => esc_html__( 'Style 02', 'themewar' ),
                                3       => esc_html__( 'Style 03', 'themewar' ),
                                4       => esc_html__( 'Style 04', 'themewar' ),
                                5       => esc_html__( 'Style 05', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'pfs_folio',
                [
                        'label'         => esc_html__( 'Specific Portfolio', 'themewar' ),
                        'type'          => Controls_Manager::SELECT2,
                        'label_block'   => TRUE,
                        'multiple'      => true,
                        'default'       => 0,
                        'options'       => $fols
                ]
        );
        $this->add_control(
                'pfs_post_item',
                [
                        'label'         => esc_html__( 'Number Of Item', 'themewar' ),
                        'type'          => Controls_Manager::NUMBER,
                        'min'           => 3,
                        'max'           => 200,
                        'step'          => 1,
                        'default'       => 6,
                        'description'   => esc_html__( 'How many item you want to show.', 'themewar' ),
                ]
        );
        $this->add_control(
                'pfs_order_by',
                [
                        'label' => esc_html__( 'Order By', 'themewar' ),
                        'type'  => Controls_Manager::SELECT,
                        'default' => 'date',
                        'options' => [
                                'date'                  => esc_html__( 'Date', 'themewar' ),
                                'title'                 => esc_html__( 'Title', 'themewar' ),
                                'rand'                  => esc_html__( 'Random', 'themewar' )
                        ],
                ]
        );
        $this->add_control(
                'pfs_order',
                [
                        'label' => esc_html__( 'Order', 'themewar' ),
                        'type'  => Controls_Manager::SELECT,
                        'default' => 'desc',
                        'options' => [
                                'asc'        => esc_html__( 'Ascending', 'themewar' ),
                                'desc'       => esc_html__( 'Descending', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'pfs_slide_autoplay',
                [
                        'label'             => esc_html__( 'Is Autoplay?', 'themewar' ),
                        'type'              => Controls_Manager::SWITCHER,
                        'label_on'          => esc_html__( 'Yes', 'themewar' ),
                        'label_off'         => esc_html__( 'No', 'themewar' ),
                        'description'       => esc_html__('Do you want to make this slider auto play?', 'themewar'),
                        'return_value'      => 'yes',
                        'default'           => 'yes',
                ]
        );
        $this->add_control(
                'pfs_slide_loop',
                [
                        'label'             => esc_html__( 'Is Loop?', 'themewar' ),
                        'type'              => Controls_Manager::SWITCHER,
                        'label_on'          => esc_html__( 'Yes', 'themewar' ),
                        'label_off'         => esc_html__( 'No', 'themewar' ),
                        'description'       => esc_html__('Do you want to make this slider item loop?', 'themewar'),
                        'return_value'      => 'yes',
                        'default'           => 'yes',
                ]
        );
        $this->add_control(
                'pfs_slide_nav',
                [
                        'label'             => esc_html__( 'Is Nav?', 'themewar' ),
                        'type'              => Controls_Manager::SWITCHER,
                        'label_on'          => esc_html__( 'Yes', 'themewar' ),
                        'label_off'         => esc_html__( 'No', 'themewar' ),
                        'description'       => esc_html__('Do you want to show slider arrow navigation?', 'themewar'),
                        'return_value'      => 'yes',
                        'default'           => 'no',
                ]
        );
        $this->add_control(
                'pfs_slide_dots',
                [
                        'label'             => esc_html__( 'Is Dots?', 'themewar' ),
                        'type'              => Controls_Manager::SWITCHER,
                        'label_on'          => esc_html__( 'Yes', 'themewar' ),
                        'label_off'         => esc_html__( 'No', 'themewar' ),
                        'description'       => esc_html__('Do you want to show slider bullets item?', 'themewar'),
                        'return_value'      => 'yes',
                        'default'           => 'no'
                ]
        );
        $this->add_control( 'tw_item_per_row_1', [
                'label' => esc_html__('Items XL Device', 'themewar'),
                'type' => Controls_Manager::SELECT,
                'description' => esc_html__('How many item you want to show per row on Extra Large Screen?', 'themewar'),
                'default' => '4',
                'multiple' => false,
                'options' => [
                    1 => esc_html__('1 Items', 'themewar'),
                    2 => esc_html__('2 Items', 'themewar'),
                    3 => esc_html__('3 Items', 'themewar'),
                    4 => esc_html__('4 Items', 'themewar'),
                    5 => esc_html__('5 Items', 'themewar'),
                    6 => esc_html__('6 Items', 'themewar'),
                ],
                'conditions'    => [
                    'terms'     => [
                        [
                                'name'      => 'pfs_view',
                                'operator'  => '!in',
                                'value'     => ['5'],
                        ]
                    ],
                ]
            ]
        );
        $this->add_control( 'tw_item_per_row_2', [
                'label' => esc_html__('Items LG Device', 'themewar'),
                'type' => Controls_Manager::SELECT,
                'description' => esc_html__('How many item you want to show per row on Large Screen?', 'themewar'),
                'default' => '3',
                'multiple' => false,
                'options' => [
                    1 => esc_html__('1 Items', 'themewar'),
                    2 => esc_html__('2 Items', 'themewar'),
                    3 => esc_html__('3 Items', 'themewar'),
                    4 => esc_html__('4 Items', 'themewar'),
                    5 => esc_html__('5 Items', 'themewar'),
                ],
                'conditions'    => [
                    'terms'     => [
                        [
                                'name'      => 'pfs_view',
                                'operator'  => '!in',
                                'value'     => ['5'],
                        ]
                    ],
                ]
            ]
        );
        $this->add_control( 'tw_item_per_row_3', [
                'label' => esc_html__('Items MD Device', 'themewar'),
                'type' => Controls_Manager::SELECT,
                'description' => esc_html__('How many item you want to show per row on Ipad Pro Screen?', 'themewar'),
                'default' => '3',
                'multiple' => false,
                'options' => [
                    1 => esc_html__('1 Items', 'themewar'),
                    2 => esc_html__('2 Items', 'themewar'),
                    3 => esc_html__('3 Items', 'themewar'),
                    4 => esc_html__('4 Items', 'themewar')
                ],
                'conditions'    => [
                    'terms'     => [
                        [
                                'name'      => 'pfs_view',
                                'operator'  => '!in',
                                'value'     => ['5'],
                        ]
                    ],
                ]
            ]
        );
        $this->add_control( 'tw_item_per_row_4', [
                'label' => esc_html__('Items SM Device', 'themewar'),
                'type' => Controls_Manager::SELECT,
                'description' => esc_html__('How many item you want to show per row on Medium Screen?', 'themewar'),
                'default' => '2',
                'multiple' => false,
                'options' => [
                    1 => esc_html__('1 Items', 'themewar'),
                    2 => esc_html__('2 Items', 'themewar'),
                    3 => esc_html__('3 Items', 'themewar'),
                    4 => esc_html__('4 Items', 'themewar')
                ],
                'conditions'    => [
                    'terms'     => [
                        [
                                'name'      => 'pfs_view',
                                'operator'  => '!in',
                                'value'     => ['5'],
                        ]
                    ],
                ]
            ]
        );
        $this->add_control(
                'tw_gapping',
                [
                        'label' => esc_html__( 'Items Gapping', 'themewar' ),
                        'type' => Controls_Manager::NUMBER,
                        'min' => 0,
                        'max' => 200,
                        'step' => 1,
                        'default' => 0,
                        'description'   => esc_html__('Insert items gapping if you want.', 'themewar'),
                ]
        );
        $this->add_control(
                'folio_strlimit',
                [
                        'label'         => esc_html__( 'Content Limit', 'themewar' ),
                        'type'          => Controls_Manager::NUMBER,
                        'min'           => 0,
                        'max'           => 10000,
                        'step'          => 1,
                        'default'       => 97,
                        'description'   => esc_html__( 'Setup your item description text limit.', 'themewar' ),
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'pfs_view',
                                        'operator'  => 'in',
                                        'value'     => ['2', '4'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'is_read_more',
                [
                        'label'             => esc_html__( 'Is Read More Btn?', 'themewar' ),
                        'type'              => Controls_Manager::SWITCHER,
                        'label_on'          => esc_html__( 'Yes', 'themewar' ),
                        'label_off'         => esc_html__( 'No', 'themewar' ),
                        'description'       => esc_html__('Do you want to show read more btn?', 'themewar'),
                        'return_value'      => 'yes',
                        'default'           => 'no',
                        'conditions'        => [
                            'terms'         => [
                                [
                                        'name'      => 'pfs_view',
                                        'operator'  => '!in',
                                        'value'     => ['5'],
                                ]
                            ],
                        ]
                ]
        );
        $this->add_control(
                'rm_label',
                [
                        'label'         => esc_html__( 'Read More Label', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => esc_html__('See More Details', 'themewar'),
                        'label_block'   => TRUE,
                        'conditions'        => [
                                'terms'     => [
                                    [
                                            'name'      => 'pfs_view',
                                            'operator'  => 'in',
                                            'value'     => ['2', '4'],
                                    ],
                                    [
                                            'name'      => 'is_read_more',
                                            'operator'  => '==',
                                            'value'     => 'yes',
                                    ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'shshape',
                [
                        'label' => esc_html__( 'Active Item Image Border', 'themewar' ),
                        'label_block'   => TRUE,
                        'type' => Controls_Manager::MEDIA,
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'pfs_view',
                                        'operator'  => '==',
                                        'value'     => '5',
                                ]
                            ],
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_box_img',[
                    'label'         => esc_html__('Featured Image Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                ]
        );
        $this->add_responsive_control(
                'icon_box_fimg_width',
                [
                        'label' => esc_html__( 'Image Width', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .flsSlider_wrap img' => 'max-width: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_fimg_height',
                [
                        'label' => esc_html__( 'Image Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .flsSlider_wrap img' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name' => 'icon_box_fimg_shadow',
                        'label' => esc_html__( 'Box Shadow', 'themewar' ),
                        'selector' => '{{WRAPPER}} .folioItem01:hover, {{WRAPPER}} .folioItem04:hover',
                ]
        );
        $this->add_responsive_control(
                'icon_box_fimg_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .flsSlider_wrap img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                ]
        );
        $this->add_responsive_control(
                'icon_box_fimg_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .flsSlider_wrap img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_cnarea', [
                    'label'         => esc_html__('Content Area Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'pfs_view',
                                    'operator'  => '==',
                                    'value'     => '4',
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
                'pfs_border_right_color',
                [
                        'label' => esc_html__( 'Border Right Color', 'themewar' ),
                        'type'  => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .workInfo:before' => 'background: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name' => 'icon_box_img_bgcolor_hr',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .workInfo',
                ]
        );
        $this->add_responsive_control(
                'pfs_content_overlay_color',
                [
                        'label' => esc_html__( 'Overlay Color', 'themewar' ),
                        'type'  => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .workInfo:after' => 'background: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name' => 'pfs_content_shadow',
                        'label' => esc_html__( 'Box Shadow', 'themewar' ),
                        'selector' => '{{WRAPPER}} .workInfo',
                ]
        );
        $this->add_responsive_control(
                'pfs_content_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .workInfo' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .workInfo:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                ]
        );
        $this->add_responsive_control(
                'pfs_content_padding',
                [
                        'label'      => esc_html__( 'Paddings', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .workInfo' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'pfs_content_margin',
                [
                        'label'      => esc_html__( 'Margins', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .workInfo' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'pfs_middle_divider_color',
                [
                        'label' => esc_html__( 'Middle Divider Color', 'themewar' ),
                        'type'  => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .wiborder' => 'background: {{VALUE}}',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_overlay',[
                    'label'         => esc_html__('Hover Overlay Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'pfs_view',
                                    'operator'  => '!in',
                                    'value'     => ['4', '5'],
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
                'overlay_color',
                [
                        'label' => esc_html__( 'Overlay Color', 'themewar' ),
                        'type'  => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .folioItem01:after' => 'background: {{VALUE}}',
                                '{{WRAPPER}} .folioItem04:after' => 'background: {{VALUE}}',
                                '{{WRAPPER}} .folioItem03:after' => 'background: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'overlay_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .folioItem01:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .folioItem04:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .folioItem04:before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .folioItem03:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'hover_border_color',
                [
                        'label' => esc_html__( 'Hover Border Color', 'themewar' ),
                        'type'  => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .folioItem04:before' => 'border-color: {{VALUE}}',
                        ],
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'pfs_view',
                                        'operator'  => '==',
                                        'value'     => '2',
                                ]
                            ],
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_subtitle', [
                    'label'         => esc_html__('Sub Title Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'pfs_view',
                                    'operator'  => '!in',
                                    'value'     => ['2', '4', '5'],
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
                'subtitle_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .folioHover p' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .folioHover03 p' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'subtitle_typo',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .folioHover p, {{WRAPPER}} .folioHover03 p',
                ]
        );
        $this->add_responsive_control(
                'subtitle_margin',
                [
                        'label'      => esc_html__( 'Margin', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .folioHover p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .folioHover03 p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_title', [
                    'label'         => esc_html__('Title Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'pfs_view',
                                    'operator'  => '!in',
                                    'value'     => ['4'],
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
                'title_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .folioHover h4' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .folioHover04 h4' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .folioHover03 h4' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .fi03Con h4' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'title_hover_color',[
                        'label'     => esc_html__( 'Hover Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .folioHover h4 a:hover' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .folioHover04 h4 a:hover' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .folioHover03 h4 a:hover' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .fi03Con h4 a:hover' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'title_typo',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .folioHover h4, {{WRAPPER}} .folioHover04 h4, {{WRAPPER}} .folioHover03 h4, {{WRAPPER}} .fi03Con h4',
                ]
        );
        $this->add_responsive_control(
                'title_margin',
                [
                        'label'      => esc_html__( 'Margin', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .folioHover h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .folioHover04 h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .folioHover03 h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .fi03Con h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_content', [
                    'label'         => esc_html__('Content Or Category Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'pfs_view',
                                    'operator'  => 'in',
                                    'value'     => ['2', '4', '5'],
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
                'content_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .folioHover04 p' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .workInfo p' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .fi03Con p' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'content_hover_color',[
                        'label'     => esc_html__( 'hover Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .fi03Con p a:hover' => 'color: {{VALUE}}',
                        ],
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'pfs_view',
                                        'operator'  => 'in',
                                        'value'     => ['5'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'content_typo',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .folioHover04 p, {{WRAPPER}} .workInfo p, {{WRAPPER}} .fi03Con p',
                ]
        );
        $this->add_responsive_control(
                'content_margin',
                [
                        'label'      => esc_html__( 'Margin', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .folioHover04 p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .workInfo p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .fi03Con p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_lv_content', [
                    'label'         => esc_html__('Post Meta (Like and Veiw) Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'pfs_view',
                                    'operator'  => '==',
                                    'value'     => '5',
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
                'content_lv_color',[
                        'label'     => esc_html__( 'Text Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .fimeta a' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'content_lv_icon_color',[
                        'label'     => esc_html__( 'Icon Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .fimeta a i' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'content_lv_hover_color',[
                        'label'     => esc_html__( 'Text Hover Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .fimeta a:hover' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'content_lv_hover_icon_color',[
                        'label'     => esc_html__( 'Icon Hover Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .fimeta a:hover i' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => '_lv__icon_typo',
                        'label'     => esc_html__( 'Text Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .fimeta a',
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => '_lv__text_typo',
                        'label'     => esc_html__( 'Icon Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .fimeta a i',
                ]
        );
        $this->add_responsive_control(
                'content_lv__margin',
                [
                        'label'      => esc_html__( 'Margin', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .fimeta a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_list', [
                    'label'         => esc_html__('List Item Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'pfs_view',
                                    'operator'  => 'in',
                                    'value'     => ['2', '4'],
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
                'content_lst',[
                        'label'     => esc_html__( 'List Title Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .folioHover04 ul li' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .workInfo ul li' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'content_lstv',[
                        'label'     => esc_html__( 'List Value Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .folioHover04 ul li span' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .workInfo ul li span' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'content_lsts',[
                        'label'     => esc_html__( 'List Star Left Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .folioHover04 ul li:after' => 'background: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'ls_typo',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .folioHover04 ul li, {{WRAPPER}} .workInfo ul li',
                ]
        );
        $this->add_responsive_control(
                'ls_margin',
                [
                        'label'      => esc_html__( 'Margin', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .folioHover04 ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .workInfo ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_rmbtn', [
                    'label'             => esc_html__('Read More Btn Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                    'condition'         => ['is_read_more' => 'yes']
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'rmbtn_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .fm-more, {{WRAPPER}} .berpo_btn.btn05, {{WRAPPER}} .folioHover03 > a'
                ]
        );
        $this->add_responsive_control(
                'rmbtn_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .fm-more' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .berpo_btn.btn05' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .folioHover03 > a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->start_controls_tabs( 'rmbtn_styling_tab' );
            $this->start_controls_tab(
                    'rmbtn_styling_tab_normal',
                    [
                            'label' => esc_html__( 'Normal', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'rmbtn_nav_color',
                    [
                            'label' => esc_html__( 'Color', 'themewar' ),
                            'type'  => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .fm-more' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .berpo_btn.btn05' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .folioHover03 > a' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'rmbtn_bg',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .fm-more, {{WRAPPER}} .berpo_btn.btn05, {{WRAPPER}} .folioHover03 > a'
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'rmbtn_bg_shadow',
                            'label' => esc_html__( 'Boxs Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .fm-more, {{WRAPPER}} .berpo_btn.btn05, {{WRAPPER}} .folioHover03 > a'
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'rmbtn_bg_border',
                            'label' => esc_html__( 'Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .fm-more, {{WRAPPER}} .berpo_btn.btn05, {{WRAPPER}} .folioHover03 > a'
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'rmbtn_styling_tab_hover',
                    [
                            'label' => esc_html__( 'Hover', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'rmbtn_color_hover',
                    [
                            'label' => esc_html__( 'Color', 'themewar' ),
                            'type'  => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .fm-more:hover' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .berpo_btn.btn05:hover' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .folioHover03 > a:hover' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'rmbtn_bg_hover',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .fm-more:hover, {{WRAPPER}} .berpo_btn.btn05 .bp-shape, {{WRAPPER}} .folioHover03 > a:hover'
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'rmbtn_bg_shadow_hover',
                            'label' => esc_html__( 'Boxs Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .fm-more:hover, {{WRAPPER}} .berpo_btn.btn05:hover, {{WRAPPER}} .folioHover03 > a:hover'
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'rmbtn_bg_border_hover',
                            'label' => esc_html__( 'Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .fm-more:hover, {{WRAPPER}} .berpo_btn.btn05:hover, {{WRAPPER}} .folioHover03 > a:hover'
                    ]
            );
            $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_responsive_control(
                'rmbtn_margin',
                [
                        'label'      => esc_html__( 'Margins', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .fm-more' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .berpo_btn.btn05' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .folioHover03 > a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_nav', [
                    'label'             => esc_html__('Nav Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'pfs_view',
                                    'operator'  => '!in',
                                    'value'     => ['5'],
                            ],
                            [
                                    'name'      => 'pfs_slide_nav',
                                    'operator'  => '==',
                                    'value'     => 'yes',
                            ]
                        ],
                    ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'nav_i_typography',
                        'label'     => esc_html__( 'Icon Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .flsSlider_wrap .owl-carousel .owl-nav button'
                ]
        );
        $this->add_control(
                'bl_nav_radius',
                [
                        'label' => esc_html__( 'Nav  Radius', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .flsSlider_wrap .owl-carousel .owl-nav button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .flsSlider_wrap .owl-carousel .owl-nav button:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->start_controls_tabs( 'nav_styling_tab' );
            $this->start_controls_tab(
                    'nav_styling_tab_normal',
                    [
                            'label' => esc_html__( 'Normal', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'bl_nav_color',
                    [
                            'label' => esc_html__( 'Nav Color', 'themewar' ),
                            'type'  => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .flsSlider_wrap .owl-carousel .owl-nav button' => 'color: {{VALUE}}'
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'bl_nav_bg',
                        'label' => esc_html__( 'Nav Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .flsSlider_wrap .owl-carousel .owl-nav button',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'bl_nav_bg_shadow',
                            'label' => esc_html__( 'Boxs Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .flsSlider_wrap .owl-carousel .owl-nav button',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'bl_nav_bg_border',
                            'label' => esc_html__( 'Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .flsSlider_wrap .owl-carousel .owl-nav button',
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'nav_styling_tab_hover',
                    [
                            'label' => esc_html__( 'Hover', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'bl_nav_color_hover',
                    [
                            'label' => esc_html__( 'Nav Color', 'themewar' ),
                            'type'  => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .flsSlider_wrap .owl-carousel .owl-nav button:hover' => 'color: {{VALUE}}'
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'bl_nav_bg_hover',
                        'label' => esc_html__( 'Nav Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .flsSlider_wrap .owl-carousel .owl-nav button:after',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'bl_nav_bg_shadow_hover',
                            'label' => esc_html__( 'Boxs Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .flsSlider_wrap .owl-carousel .owl-nav button:hover',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'bl_nav_bg_border_hover',
                            'label' => esc_html__( 'Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .flsSlider_wrap .owl-carousel .owl-nav button:hover',
                    ]
            );
            $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_responsive_control(
                    'left_nav_margin',
                    [
                            'label'      => esc_html__( 'Left Margin', 'themewar' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .flsSlider_wrap .owl-carousel .owl-nav button.owl-prev' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'right_nav_margin',
                    [
                            'label'      => esc_html__( 'Right Margin', 'themewar' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .flsSlider_wrap .owl-carousel .owl-nav button.owl-next' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_svg_nav', [
                    'label'             => esc_html__('Nav Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'pfs_view',
                                    'operator'  => '==',
                                    'value'     => '5',
                            ],
                            [
                                    'name'      => 'pfs_slide_nav',
                                    'operator'  => '==',
                                    'value'     => 'yes',
                            ]
                        ],
                    ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'nav_svg_typography',
                        'label'     => esc_html__( 'Icon Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .flsSlider_wrap .fsArrows a'
                ]
        );
        $this->start_controls_tabs( 'nav_svg_styling_tab' );
            $this->start_controls_tab(
                    'nav_svg_styling_tab_normal',
                    [
                            'label' => esc_html__( 'Normal', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'bl_nav_svg_color',
                    [
                            'label' => esc_html__( 'Color', 'themewar' ),
                            'type'  => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .flsSlider_wrap .fsArrows a' => 'color: {{VALUE}}'
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'bl_nav_svg_bg_color',
                    [
                            'label' => esc_html__( 'BG Color', 'themewar' ),
                            'type'  => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .flsSlider_wrap .fsArrows a svg path' => 'fill: {{VALUE}}'
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Css_Filter::get_type(),
                    [
                            'name'      => 'box_svg_filter',
                            'label'     => esc_html__( 'BG Shadow', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .flsSlider_wrap .fsArrows a svg',
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'nav_svg_styling_tab_hover',
                    [
                            'label' => esc_html__( 'Hover', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'bl_nav_svg_color_hover',
                    [
                            'label' => esc_html__( 'Nav Color', 'themewar' ),
                            'type'  => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .flsSlider_wrap .fsArrows a:hover' => 'color: {{VALUE}}'
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'bl_nav_svg_hover_bg_color',
                    [
                            'label' => esc_html__( 'BG Color', 'themewar' ),
                            'type'  => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .flsSlider_wrap .fsArrows a:hover svg path' => 'fill: {{VALUE}}'
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Css_Filter::get_type(),
                    [
                            'name'      => 'box_hover_svg_filter',
                            'label'     => esc_html__( 'BG Shadow', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .flsSlider_wrap .fsArrows a:hover svg',
                    ]
            );
            $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_responsive_control(
                    'left_svg_nav_margin',
                    [
                            'label'      => esc_html__( 'Left Margin', 'themewar' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .flsSlider_wrap .fsArrows a.prevArrow' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'right_svg_nav_margin',
                    [
                            'label'      => esc_html__( 'Right Margin', 'themewar' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .flsSlider_wrap .fsArrows a.nextArrow' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_04', [
                    'label'             => esc_html__('Dots Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                    'condition'         => ['pfs_slide_dots' => 'yes']
                ]
        );
            $this->add_responsive_control(
                    'dots_width',
                    [
                            'label' => esc_html__( 'Dots Width', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px'],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 50,
                                            'step' => 1,
                                    ]
                            ],
                            'default' => [
                                    'unit' => 'px',
                                    'size' => '',
                            ],
                            'selectors' => [
                                    '{{WRAPPER}} .flsSlider_wrap .owl-carousel .owl-dots button' => 'width: {{SIZE}}{{UNIT}};'
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'dots_height',
                    [
                            'label' => esc_html__( 'Dots Height', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px'],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 50,
                                            'step' => 1,
                                    ]
                            ],
                            'default' => [
                                    'unit' => 'px',
                                    'size' => '',
                            ],
                            'selectors' => [
                                    '{{WRAPPER}} .flsSlider_wrap .owl-carousel .owl-dots button' => 'height: {{SIZE}}{{UNIT}};'
                            ],
                    ]
            );
            $this->start_controls_tabs( 'dot_styling_tab' );
                $this->start_controls_tab(
                        'dot_styling_tab_normal',
                        [
                                'label' => esc_html__( 'Normal', 'themewar' ),
                        ]
                );
                $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'bl_dot_bg',
                            'label' => esc_html__( 'Nav Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .flsSlider_wrap .owl-carousel .owl-dots button',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                                'name' => 'bl_dot_shadow',
                                'label' => esc_html__( 'Dots Shadow', 'themewar' ),
                                'selector' => '{{WRAPPER}} .flsSlider_wrap .owl-carousel .owl-dots button',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                                'name' => 'bl_dot_bg_border',
                                'label' => esc_html__( 'Border', 'themewar' ),
                                'selector' => '{{WRAPPER}} .flsSlider_wrap .owl-carousel .owl-dots button',
                        ]
                );
                $this->end_controls_tab();
                $this->start_controls_tab(
                        'dot_styling_tab_hover',
                        [
                                'label' => esc_html__( 'Hover', 'themewar' ),
                        ]
                );
                $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'bl_dot_hover_bg',
                            'label' => esc_html__( 'Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .flsSlider_wrap .owl-carousel .owl-dots button:hover, {{WRAPPER}} .flsSlider_wrap .owl-carousel .owl-dots button.active',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                                'name' => 'bl_dot_hover_shadow',
                                'label' => esc_html__( 'Dots Shadow', 'themewar' ),
                                'selector' => '{{WRAPPER}} .flsSlider_wrap .owl-carousel .owl-dots button:hover, {{WRAPPER}} .flsSlider_wrap .owl-carousel .owl-dots button.active',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                                'name' => 'bl_dot_hover_border',
                                'label' => esc_html__( 'Border', 'themewar' ),
                                'selector' => '{{WRAPPER}} .flsSlider_wrap .owl-carousel .owl-dots button:after',
                        ]
                );
                $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_responsive_control(
                    'bl_dot_radius',
                    [
                            'label' => esc_html__( 'Dots  Radius', 'themewar' ),
                            'type'  => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .flsSlider_wrap .owl-carousel .owl-dots button:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .serviceSlider_wrap .owl-carousel .owl-dots button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'bl_dot_margin',
                    [
                            'label' => esc_html__( 'Dots  Gapping', 'themewar' ),
                            'type'  => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                    '{{WRAPPER}} .flsSlider_wrap .owl-carousel .owl-dots button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'bl_dots_margin',
                    [
                            'label' => esc_html__( 'Dot Area Margins', 'themewar' ),
                            'type'  => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                    '{{WRAPPER}} .flsSlider_wrap .owl-carousel .owl-dots' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
        $this->end_controls_section();
    }
    
    protected function render() {
        $settings       = $this->get_settings_for_display();
        $pfs_view       = (isset($settings['pfs_view']) && $settings['pfs_view'] > 0 ) ? $settings['pfs_view'] : 1;
        $pfs_folio      = (isset($settings['pfs_folio']) && !empty($settings['pfs_folio']) ) ? $settings['pfs_folio'] : array();
        
        $pfs_post_item  = (isset($settings['pfs_post_item']) && $settings['pfs_post_item'] > 0) ? $settings['pfs_post_item'] : 6;
        $pfs_order_by   = (isset($settings['pfs_order_by']) && $settings['pfs_order_by'] != '') ? $settings['pfs_order_by'] : 'date';
        $pfs_order      = (isset($settings['pfs_order']) && $settings['pfs_order'] != '') ? $settings['pfs_order'] : 'desc';
        
        $autoplay       = (isset($settings['pfs_slide_autoplay'])) ? $settings['pfs_slide_autoplay'] : 'yes';
        $loop           = (isset($settings['pfs_slide_loop'])) ? $settings['pfs_slide_loop'] : 'yes';
        $nav            = (isset($settings['pfs_slide_nav'])) ? $settings['pfs_slide_nav'] : 'no';
        $dots           = (isset($settings['pfs_slide_dots'])) ? $settings['pfs_slide_dots'] : 'no';
        
        $tw_item_per_row_1 = (isset($settings['tw_item_per_row_1']) && $settings['tw_item_per_row_1'] > 0 ? $settings['tw_item_per_row_1'] : 5);
        $tw_item_per_row_2 = (isset($settings['tw_item_per_row_2']) && $settings['tw_item_per_row_2'] > 0 ? $settings['tw_item_per_row_2'] : 4);
        $tw_item_per_row_3 = (isset($settings['tw_item_per_row_3']) && $settings['tw_item_per_row_3'] > 0 ? $settings['tw_item_per_row_3'] : 3);
        $tw_item_per_row_4 = (isset($settings['tw_item_per_row_4']) && $settings['tw_item_per_row_4'] > 0 ? $settings['tw_item_per_row_4'] : 2);
        $tw_gapping        = (isset($settings['tw_gapping']) && $settings['tw_gapping'] != '' ? $settings['tw_gapping'] : 0);

        $folio_strlimit    = (isset($settings['folio_strlimit']) && $settings['folio_strlimit'] > 0 ) ? $settings['folio_strlimit'] : 97;

        $is_read_more      = (isset($settings['is_read_more']) && $settings['is_read_more'] != '' ? $settings['is_read_more'] : 'no');
        $rm_label          = (isset($settings['rm_label']) && $settings['rm_label'] != '') ? $settings['rm_label'] : esc_html__('See More Details', 'themewar');

        $shshape           = (isset($settings['shshape']['url']) && $settings['shshape']['url'] != '') ? $settings['shshape']['url'] : '';
        
        include dirname(__FILE__).'/style/portfolio-slide/style1.php';
    }
    
    protected function content_template() {}
    
}