<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Folio_Grid_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-folio-grid';
    }
    
    public function get_title() {
        return esc_html__( 'Portfolio Grid', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-post-list';
    }

    public function get_categories() {
        return [ 'bepro-elements' ];
    }
    
    protected function register_controls() {
        $folio_cat = array(
            'orderby'       => 'ID',
            'order'         => 'DESC', 
            'hide_empty'    => 1,
            'hierarchical'  => 1,
            'taxonomy'      => 'folio_cat'
        );
        $categories = get_categories( $folio_cat );
        $cats = array('0' => esc_html__('All Categories', 'themewar'));
        if(is_array($categories) && count($categories) > 0){
            foreach ($categories as $cat){
                $cats[$cat->term_id] = $cat->name;
            }
        }
        $folio = array(
            'post_type'         => 'folio',
            'post_status'       => 'publish',
            'order_by'          => 'date',
            'order'             => 'DESC',
            'posts_per_page'    => -1
        );
        $folios = array();
        
        query_posts($folio);
            if(have_posts()):
                while (have_posts()):
                    the_post();
                    $folios[get_the_ID()] = get_the_title();
                endwhile;
            endif;
        wp_reset_query();
        
        $this->start_controls_section(
            'section_tab_1', [
                'label' => esc_html__( 'Portfolio', 'themewar' ),
            ]
        );
        $this->add_control(
                'folio_item_style',
                [
                        'label'         => esc_html__( 'Portfolio Style', 'themewar' ),
                        'type'          => Controls_Manager::SELECT,
                        'description'   => esc_html__('Select your folio item view style', 'themewar'),
                        'default'       => 1,
                        'options'       => [
                                1       => esc_html__( 'Style 01', 'themewar' ),
                                2       => esc_html__( 'Style 02', 'themewar' ),
                                3       => esc_html__( 'Style 03', 'themewar' ),
                                4       => esc_html__( 'Style 04', 'themewar' ),
                                5       => esc_html__( 'Style 05', 'themewar' ),
                                6       => esc_html__( 'Style 06', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'is_filter',
                [
                        'label'             => esc_html__( 'Is Filter?', 'themewar' ),
                        'type'              => Controls_Manager::SWITCHER,
                        'label_on'          => esc_html__( 'Show', 'themewar' ),
                        'label_off'         => esc_html__( 'Hide', 'themewar' ),
                        'return_value'      => 'yes',
                        'default'           => 'no',
                ]
        );
        $this->add_control(
                'filtr_alignment',
                [
                        'label'         => esc_html__( 'Filter Title Alignment', 'themewar' ),
                        'type'          => Controls_Manager::CHOOSE,
                        'options'       => [
                                'left'  => [
                                        'title' => esc_html__( 'Left', 'themewar' ),
                                        'icon' => 'eicon-text-align-left',
                                ],
                                'center' => [
                                        'title' => esc_html__( 'Center', 'themewar' ),
                                        'icon' => 'eicon-text-align-center',
                                ],
                                'right' => [
                                        'title' => esc_html__( 'Right', 'themewar' ),
                                        'icon' => 'eicon-text-align-right',
                                ],
                        ],
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'is_filter',
                                        'operator'  => '==',
                                        'value'     => 'yes',
                                ],
                            ],
                        ],
                        'default' => 'right',
                        'toggle'  => true,
                ]  
        );
        $this->add_control(
                'is_cus_col',
                [
                        'label'             => esc_html__( 'Is Custome Column?', 'themewar' ),
                        'type'              => Controls_Manager::SWITCHER,
                        'label_on'          => esc_html__( 'Show', 'themewar' ),
                        'label_off'         => esc_html__( 'Hide', 'themewar' ),
                        'return_value'      => 'yes',
                        'default'           => 'no',
                ]
        );
        $this->add_control(
                'grid_xl_col',
                [
                        'label'     => esc_html__( 'Select XL Col', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 2,
                        'options'   => [
                                1       => esc_html__( 'Col-Xl-3', 'themewar' ),
                                2       => esc_html__( 'Col-Xl-4', 'themewar' ),
                                3       => esc_html__( 'Col-Xl-6', 'themewar' ),
                        ],
                        'conditions'        => [
                            'terms'         => [
                                [
                                        'name'      => 'is_cus_col',
                                        'operator'  => '==',
                                        'value'     => 'yes',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'grid_lg_col',
                [
                        'label'     => esc_html__( 'Select LG Col', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 2,
                        'options'   => [
                                1       => esc_html__( 'Col-Lg-3', 'themewar' ),
                                2       => esc_html__( 'Col-Lg-4', 'themewar' ),
                                3       => esc_html__( 'Col-Lg-6', 'themewar' ),
                        ],
                        'conditions'        => [
                            'terms'         => [
                                [
                                        'name'      => 'is_cus_col',
                                        'operator'  => '==',
                                        'value'     => 'yes',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'grid_md_col',
                [
                        'label'     => esc_html__( 'Select MD Col', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 2,
                        'options'   => [
                                1       => esc_html__( 'Col-Md-4', 'themewar' ),
                                2       => esc_html__( 'Col-Md-6', 'themewar' ),
                                3       => esc_html__( 'Col-Md-12', 'themewar' ),
                        ],
                        'conditions'        => [
                            'terms'         => [
                                [
                                        'name'      => 'is_cus_col',
                                        'operator'  => '==',
                                        'value'     => 'yes',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control('tw_thumb_width', [
                'label' => esc_html__( 'Thumbnail Width', 'themewar' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 1000,
                'step' => 1,
                'default' => '',
                'conditions'        => [
                    'terms'         => [
                        [
                                'name'      => 'is_cus_col',
                                'operator'  => '==',
                                'value'     => 'yes',
                        ]
                    ],
                ],
            ]
        );
        $this->add_control('tw_thumb_height', [
                'label' => esc_html__( 'Thumbnail Height', 'themewar' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 1000,
                'step' => 1,
                'default' => '',
                'conditions'        => [
                    'terms'         => [
                        [
                                'name'      => 'is_cus_col',
                                'operator'  => '==',
                                'value'     => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->add_control(
                'folio_category',
                [
                        'label'         => esc_html__( 'Specific Category', 'themewar' ),
                        'type'          => Controls_Manager::SELECT2,
                        'description'   => esc_html__('Select category to show specific category items.', 'themewar'),
                        'label_block'   => TRUE,
                        'multiple'      => true,
                        'default'       => array('0'),
                        'options'       => $cats
                ]
        );
        $this->add_control(
                'pfs_folio',
                [
                        'label'         => esc_html__( 'Specific Portfolio', 'themewar' ),
                        'type'          => Controls_Manager::SELECT2,
                        'label_block'   => TRUE,
                        'multiple'      => true,
                        'default'       => array('0'),
                        'options'       => $folios
                ]
        );
        $this->add_control(
                'folio_no_item',
                [
                        'label'     => esc_html__( 'Item Per Page', 'themewar' ),
                        'type'      => Controls_Manager::NUMBER,
                        'min'       => 1,
                        'max'       => 500,
                        'step'      => 1,
                        'default'   => 4,
                ]
        );
        $this->add_control(
                'folio_order_by',
                [
                        'label' => esc_html__( 'Order By', 'themewar' ),
                        'type'  => Controls_Manager::SELECT,
                        'default' => 'date',
                        'options' => [
                                'ID'         => esc_html__( 'ID', 'themewar' ),
                                'date'       => esc_html__( 'Date', 'themewar' ),
                                'title'      => esc_html__( 'Title', 'themewar' ),
                                'rand'       => esc_html__( 'Random', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'folio_order',
                [
                        'label' => esc_html__( 'Order', 'themewar' ),
                        'type'  => Controls_Manager::SELECT,
                        'default' => 'desc',
                        'options' => [
                                'asc'       => esc_html__( 'Ascending', 'themewar' ),
                                'desc'      => esc_html__( 'Descending', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'folio_strlimit',
                [
                        'label'         => esc_html__( 'Content Limit', 'themewar' ),
                        'type'          => Controls_Manager::NUMBER,
                        'min'           => 0,
                        'max'           => 10000,
                        'step'          => 1,
                        'default'       => 250,
                        'description'   => esc_html__( 'Setup your item description text limit.', 'themewar' ),
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'folio_item_style',
                                        'operator'  => '==',
                                        'value'     => '6',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'lm_more',
                [
                        'label'         => esc_html__( 'Learn More Label', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => esc_html__('See Detail', 'themewar'),
                        'description'   => esc_html__('Do you want to show learn more btn, then insert label.', 'themewar'),
                        'label_block'   => TRUE,
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'folio_item_style',
                                        'operator'  => '==',
                                        'value'     => '6',
                                ],
                            ],
                        ],
                ]
        );
        $this->add_control(
                'is_pagination',
                [
                        'label'             => esc_html__( 'Is Pagination?', 'themewar' ),
                        'type'              => Controls_Manager::SWITCHER,
                        'label_on'          => esc_html__( 'Show', 'themewar' ),
                        'label_off'         => esc_html__( 'Hide', 'themewar' ),
                        'return_value'      => 'yes',
                        'default'           => 'no',
                ]
        );
        $this->end_controls_section();  
        
        $this->start_controls_section(
            'section_tab_navigation',
            [
                'label'         => esc_html__('Filter Title Style', 'themewar'),
                'tab'           => Controls_Manager::TAB_STYLE,
                'conditions'        => [
                    'terms'         => [
                        [
                                'name'      => 'is_filter',
                                'operator'  => '==',
                                'value'     => 'yes',
                        ]
                    ],
                ],
            ]
        );
        $this->start_controls_tabs( 'style_tabs_12' );
                $this->start_controls_tab(
                        'btn_1_button_style_normal',
                        [
                                'label' => esc_html__( 'Normal', 'themewar' ),
                        ]
                );
                $this->add_responsive_control(
                        'btn_1_label_color',
                        [
                                'label' => esc_html__( 'Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .filter_menu li'   => 'color: {{VALUE}}',
                                        '{{WRAPPER}} .filter_menu02 li'   => 'color: {{VALUE}}',
                                        '{{WRAPPER}} .filter_menu03 li'   => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_responsive_control(
                        'btn_1_slash_color',
                        [
                                'label' => esc_html__( 'Slash Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .filter_menu li span'   => 'color: {{VALUE}}',
                                ],
                                'conditions'    => [
                                    'terms'     => [
                                        [
                                                'name'      => 'folio_item_style',
                                                'operator'  => 'in',
                                                'value'     => ['1', '4', '5', '6'],
                                        ],
                                    ],
                                ],
                        ]
                );
                $this->add_responsive_control(
                        'btn_1_number_color',
                        [
                                'label' => esc_html__( 'Number Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .filter_menu03 li span'   => 'color: {{VALUE}}',
                                ],
                                'conditions'    => [
                                    'terms'     => [
                                        [
                                                'name'      => 'folio_item_style',
                                                'operator'  => 'in',
                                                'value'     => ['3'],
                                        ],
                                    ],
                                ],
                        ]
                );
                $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                                'name' => 'btn_1_bg',
                                'label' => esc_html__( 'Box Background', 'themewar' ),
                                'types' => [ 'classic', 'gradient'],
                                'selector' => '{{WRAPPER}} .filter_menu li, {{WRAPPER}} .filter_menu02 li, {{WRAPPER}} .filter_menu03 li',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                                'name' => 'icon_box_i_border_hr',
                                'label' => esc_html__( 'Border', 'themewar' ),
                                'selector' => '{{WRAPPER}} .filter_menu li, {{WRAPPER}} .filter_menu02 li, {{WRAPPER}} .filter_menu03 li',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                                'name' => 'icon_box_i__shadow',
                                'label' => esc_html__( 'Box Shadow', 'themewar' ),
                                'selector' => '{{WRAPPER}} .filter_menu li, {{WRAPPER}} .filter_menu02 li, {{WRAPPER}} .filter_menu03 li',
                        ]
                );
                $this->end_controls_tab();
                $this->start_controls_tab(
                        'btn_1_button_style_hover',
                        [
                                'label' => esc_html__( 'Hover', 'themewar' ),
                        ]
                );
                $this->add_responsive_control(
                        'btn_label_hover_color',
                        [
                                'label'     => esc_html__( 'Color', 'themewar' ),
                                'type'      => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .filter_menu li.active'   => 'color: {{VALUE}}',
                                        '{{WRAPPER}} .filter_menu li:hover'    => 'color: {{VALUE}}',
                                        '{{WRAPPER}} .filter_menu02 li.active'   => 'color: {{VALUE}}',
                                        '{{WRAPPER}} .filter_menu02 li:hover'    => 'color: {{VALUE}}',
                                        '{{WRAPPER}} .filter_menu03 li.active'   => 'color: {{VALUE}}',
                                        '{{WRAPPER}} .filter_menu03 li:hover'    => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_responsive_control(
                        'btn_1_slash_hover_color',
                        [
                                'label' => esc_html__( 'Slash Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .filter_menu li.active span'   => 'color: {{VALUE}}',
                                        '{{WRAPPER}} .filter_menu li:hover span'   => 'color: {{VALUE}}',
                                ],
                                'conditions'    => [
                                    'terms'     => [
                                        [
                                                'name'      => 'folio_item_style',
                                                'operator'  => 'in',
                                                'value'     => ['1', '4', '5', '6'],
                                        ],
                                    ],
                                ],
                        ]
                );
                $this->add_responsive_control(
                        'btn_1_border_hover_color',
                        [
                                'label' => esc_html__( 'Active / Hover Border Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .filter_menu li i:after'   => 'background: {{VALUE}}',
                                ],
                                'conditions'    => [
                                    'terms'     => [
                                        [
                                                'name'      => 'folio_item_style',
                                                'operator'  => 'in',
                                                'value'     => ['5', '6'],
                                        ],
                                    ],
                                ],
                        ]
                );
                $this->add_responsive_control(
                        'btn_1_number_hover_color',
                        [
                                'label' => esc_html__( 'Number Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .filter_menu03 li.active span'   => 'color: {{VALUE}}',
                                        '{{WRAPPER}} .filter_menu03 li:hover span'   => 'color: {{VALUE}}',
                                ],
                                'conditions'    => [
                                    'terms'     => [
                                        [
                                                'name'      => 'folio_item_style',
                                                'operator'  => 'in',
                                                'value'     => ['3'],
                                        ],
                                    ],
                                ],
                        ]
                );
                $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                                'name' => 'btn_1_hover_bg',
                                'label' => esc_html__( 'Box Background', 'themewar' ),
                                'types' => [ 'classic', 'gradient'],
                                'selector' => '{{WRAPPER}} .filter_menu li.active, {{WRAPPER}} .filter_menu li:hover, {{WRAPPER}} .filter_menu02 li:after, {{WRAPPER}} .filter_menu03 li:hover',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                                'name' => 'icon_box_i_hover_border_hr',
                                'label' => esc_html__( 'Border', 'themewar' ),
                                'selector' => '{{WRAPPER}} .filter_menu li.active, {{WRAPPER}} .filter_menu li:hover, {{WRAPPER}} .filter_menu02 li:hover, {{WRAPPER}} .filter_menu03 li:hover',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                                'name' => 'icon_box_i_hover_shadow',
                                'label' => esc_html__( 'Box Shadow', 'themewar' ),
                                'selector' => '{{WRAPPER}} .filter_menu li.active, {{WRAPPER}} .filter_menu li:hover, {{WRAPPER}} .filter_menu02 li:hover, {{WRAPPER}} .filter_menu03 li:hover',
                        ]
                );
                $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_responsive_control(
                'btn_1_width',
                [
                    'label' => esc_html__( 'Width', 'themewar' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [],
                    'selectors' => [
                        '{{WRAPPER}} .filter_menu li'   => 'width: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .filter_menu02 li' => 'width: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .filter_menu03 li' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                 'btn_1_height',
                [
                    'label' => esc_html__( 'Height', 'themewar' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 200,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [],
                    'selectors' => [
                        '{{WRAPPER}} .filter_menu li' => 'height: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .filter_menu02 li' => 'height: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .filter_menu03 li' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );                                
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'btn_1_typography',
                        'label' => esc_html__( 'Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .filter_menu li, {{WRAPPER}} .filter_menu02 li, {{WRAPPER}} .filter_menu03 li',
                ]
        );
        $this->add_responsive_control(
            'border_radius',
            [
                    'label' => esc_html__( 'Border Radius', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .filter_menu li'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .filter_menu02 li'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .filter_menu02 li:after'  => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .filter_menu03 li'  => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
            'btn_1_padding',
            [
                    'label' => esc_html__( 'Paddings', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                            '{{WRAPPER}} .filter_menu li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .filter_menu02 li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .filter_menu03 li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
            'btn_1_margin',
            [
                    'label' => esc_html__( 'Item Margins', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                            '{{WRAPPER}} .filter_menu li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .filter_menu02 li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .filter_menu03 li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
            'btn_1_slash_margin',
            [
                    'label' => esc_html__( 'Slash Margins', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                            '{{WRAPPER}} .filter_menu li span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'folio_item_style',
                                    'operator'  => 'in',
                                    'value'     => ['1', '4', '5', '6'],
                            ],
                        ],
                    ],
            ]
        );
        $this->add_responsive_control(
            'btn_1_number_margin',
            [
                    'label' => esc_html__( 'Number Margins', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                            '{{WRAPPER}} .filter_menu03 li span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'folio_item_style',
                                    'operator'  => 'in',
                                    'value'     => ['3'],
                            ],
                        ],
                    ],
            ]
        );
        $this->add_responsive_control(
            'btn_1_area_margin',
            [
                    'label' => esc_html__( 'Area Margins', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                            '{{WRAPPER}} .filter_menu' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .filter_menu02' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .filter_menu03' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_box_img',[
                    'label'         => esc_html__('Featured Image Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                ]
        );
        $this->add_responsive_control(
                'icon_box_fimg_width',
                [
                        'label' => esc_html__( 'Image Width', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .cmfoliItem img' => 'max-width: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_fimg_height',
                [
                        'label' => esc_html__( 'Image Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .cmfoliItem img' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name' => 'icon_box_fimg_shadow',
                        'label' => esc_html__( 'Box Shadow', 'themewar' ),
                        'selector' => '{{WRAPPER}} .cmfoliItem img',
                ]
        );
        $this->add_responsive_control(
                'icon_box_fimg_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .cmfoliItem img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_overlay', [
                    'label'         => esc_html__('Folio Overlay Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'        => [
                        'terms'         => [
                            [   
                                    'name'      => 'folio_item_style',
                                    'operator'  => '!in',
                                    'value'     => ['1'],
                            ],
                        ],
                    ],
                ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name' => 'overlay_bg',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .folioItem03:after, {{WRAPPER}} .folioItem05:after, {{WRAPPER}} .folioItem01:after, {{WRAPPER}} .folioItem06:after, {{WRAPPER}} .folioItem07:after',
                ]
        );
        $this->add_responsive_control(
                'overlay_border_radius',
                [
                        'label' => esc_html__( 'Overlay Border Radius', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .folioItem01:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .folioItem03:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .folioItem05:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .folioItem06:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .folioItem07:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_8', [
                    'label'         => esc_html__('Folio Content Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'        => [
                        'terms'         => [
                            [   
                                    'name'      => 'folio_item_style',
                                    'operator'  => '!in',
                                    'value'     => ['5'],
                            ],
                        ],
                    ],
                ]
        );
        $this->add_control(
            'content_area_style',
            [
                'label'     => esc_html__( 'Area Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name' => 'folio_area_bg',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .folioHover02, {{WRAPPER}} .folioHover03, {{WRAPPER}} .folioHover',
                ]
        );
        $this->add_control(
            'content_area_border_radius',
            [
                    'label' => esc_html__( 'Border Radius', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .folioHover02'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .folioHover03'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name' => 'content_area_shadow',
                        'label' => esc_html__( 'Box Shadow', 'themewar' ),
                        'selector' => '{{WRAPPER}} .folioHover02, {{WRAPPER}} .folioHover03',
                ]
        );
        $this->add_responsive_control(
            'content_area_padding',
            [
                    'label' => esc_html__( 'Paddings', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .folioHover02'   => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .folioHover03'   => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
            'content_area_margin',
            [
                    'label' => esc_html__( 'Margin', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .folioHover02' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .folioHover03'   => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_control(
            'folio_cts_style',
            [
                'label'     => esc_html__( 'Category / Sub title Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
                'cts_title_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .cmfoliItem p'     => 'color: {{VALUE}}',
                                '{{WRAPPER}} .cmfoliItem .cat'     => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'cts_title_hover_color',[
                        'label'     => esc_html__( 'Hover Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .cmfoliItem p a:hover'     => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'cts_title_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .cmfoliItem p{{WRAPPER}} .cmfoliItem .cat',
                ]
        );
        $this->add_responsive_control(
                'cts_title_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .cmfoliItem p'     => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .cmfoliItem .cat'     => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
            'folio_title_style',
            [
                'label'     => esc_html__( 'Folio Title Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
                'fl_title_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .cmfoliItem h4'     => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'fl_title_hover_color',[
                        'label'     => esc_html__( 'Hover Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .cmfoliItem h4 a:hover'     => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'fl_title_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .cmfoliItem h4',
                ]
        );
        $this->add_responsive_control(
                'fl_title_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .cmfoliItem h4'     => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
            'folio_content_style',
            [
                'label'     => esc_html__( 'Folio Content Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
                'conditions'        => [
                    'terms'         => [
                        [   
                                'name'      => 'folio_item_style',
                                'operator'  => '==',
                                'value'     => '6',
                        ],
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
                'fl_content_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .flc06'     => 'color: {{VALUE}}',
                        ],
                        'conditions'        => [
                            'terms'         => [
                                [   
                                        'name'      => 'folio_item_style',
                                        'operator'  => '==',
                                        'value'     => '6',
                                ],
                            ],
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'fl_content_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .flc06',
                        'conditions'        => [
                            'terms'         => [
                                [   
                                        'name'      => 'folio_item_style',
                                        'operator'  => '==',
                                        'value'     => '6',
                                ],
                            ],
                        ],
                ]
        );
        $this->add_responsive_control(
                'fl_content_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .flc06'     => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'conditions'        => [
                            'terms'         => [
                                [   
                                        'name'      => 'folio_item_style',
                                        'operator'  => '==',
                                        'value'     => '6',
                                ],
                            ],
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_rmbtn', [
                    'label'             => esc_html__(' Btn Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                    'conditions'        => [
                        'terms'         => [
                            [   
                                    'name'      => 'folio_item_style',
                                    'operator'  => '!in',
                                    'value'     => ['1'],
                            ],
                        ],
                    ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'rmbtn_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .crm, {{WRAPPER}} .berpo_btn, {{WRAPPER}} .folioHover03 > a, {{WRAPPER}} .fm-more, {{WRAPPER}} .folioItem06 a'
                ]
        );
        $this->add_responsive_control(
                'rmbtn_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .folioItem06 a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .fm-more' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .crm' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .berpo_btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .folioHover03 > a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->start_controls_tabs( 'rmbtn_styling_tab' );
            $this->start_controls_tab(
                    'rmbtn_styling_tab_normal',
                    [
                            'label' => esc_html__( 'Normal', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'rmbtn_nav_color',
                    [
                            'label' => esc_html__( 'Color', 'themewar' ),
                            'type'  => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .folioItem06 a' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .fm-more' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .crm' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .berpo_btn' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .folioHover03 > a' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'rmbtn_bg',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .crm, {{WRAPPER}} .berpo_btn, {{WRAPPER}} .folioHover03 > a, {{WRAPPER}} .fm-more, {{WRAPPER}} .folioItem06 a'
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'rmbtn_bg_shadow',
                            'label' => esc_html__( 'Boxs Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .crm, {{WRAPPER}} .berpo_btn, {{WRAPPER}} .folioHover03 > a, {{WRAPPER}} .fm-more, {{WRAPPER}} .folioItem06 a'
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'rmbtn_bg_border',
                            'label' => esc_html__( 'Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .crm, {{WRAPPER}} .berpo_btn, {{WRAPPER}} .folioHover03 > a, {{WRAPPER}} .fm-more, {{WRAPPER}} .folioItem06 a'
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'rmbtn_styling_tab_hover',
                    [
                            'label' => esc_html__( 'Hover', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'rmbtn_color_hover',
                    [
                            'label' => esc_html__( 'Color', 'themewar' ),
                            'type'  => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .folioItem06 a:hover' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .fm-more:hover' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .crm:hover' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .berpo_btn:hover' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .folioHover03 > a:hover' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'rmbtn_bg_hover',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .crm:hover, {{WRAPPER}} .berpo_btn .bp-shape, {{WRAPPER}} .folioHover03 > a:hover, {{WRAPPER}} .fm-more:hover, {{WRAPPER}} .folioItem06 a:hover'
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'rmbtn_bg_shadow_hover',
                            'label' => esc_html__( 'Boxs Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .crm:hover, {{WRAPPER}} .berpo_btn:hover, {{WRAPPER}} .folioHover03 > a:hover, {{WRAPPER}} .fm-more:hover, {{WRAPPER}} .folioItem06 a:hover'
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'rmbtn_bg_border_hover',
                            'label' => esc_html__( 'Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .crm:hover, {{WRAPPER}} .berpo_btn:hover, {{WRAPPER}} .folioHover03 > a:hover, {{WRAPPER}} .fm-more:hover, {{WRAPPER}} .folioItem06 a:hover'
                    ]
            );
            $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_responsive_control(
                'rmbtn_margin',
                [
                        'label'      => esc_html__( 'Margins', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .folioItem06 a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .fm-more' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .crm' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .berpo_btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .folioHover03 > a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_10', [
                'label'         => esc_html__( 'Pagination Style', 'themewar' ),
                'tab'           => Controls_Manager::TAB_STYLE,
                'conditions'        => [
                    'terms'         => [
                        [
                                'name'      => 'is_pagination',
                                'operator'  => '==',
                                'value'     => 'yes',
                        ]
                    ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name' => 'icon_page_area_hr',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .bepro_pagination',
                ]
        );
        $this->add_responsive_control(
            'serv_pagi_radius',
            [
                    'label'      => esc_html__( 'Border Radius', 'themewar' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                        '{{WRAPPER}} .bepro_pagination'  => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
            'serv_pagi_padding',
            [
                    'label'      => esc_html__( 'Paddings', 'themewar' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                        '{{WRAPPER}} .bepro_pagination'       => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
            'serv_pagi_margin',
            [
                    'label'      => esc_html__( 'Margin', 'themewar' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                        '{{WRAPPER}} .bepro_pagination'       => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->end_controls_section();

        
        
    }
    
    protected function render() {
        $settings               = $this->get_settings_for_display();
        $folio_item_style       = (isset($settings['folio_item_style']) && $settings['folio_item_style'] > 0 ? $settings['folio_item_style'] : 1);
        $is_filter              = (isset($settings['is_filter']) && !empty($settings['is_filter']) ? $settings['is_filter'] : 'no');

        $is_cus_col             = (isset($settings['is_cus_col']) && !empty($settings['is_cus_col']) ? $settings['is_cus_col'] : 'no');
        $grid_xl_col            = (isset($settings['grid_xl_col']) && $settings['grid_xl_col'] > 0) ? $settings['grid_xl_col'] : 2;
        $grid_lg_col            = (isset($settings['grid_lg_col']) && $settings['grid_lg_col'] > 0) ? $settings['grid_lg_col'] : 2;
        $grid_md_col            = (isset($settings['grid_md_col']) && $settings['grid_md_col'] > 0) ? $settings['grid_md_col'] : 2;
        $tw_thumb_width         = (isset($settings['tw_thumb_width']) && $settings['tw_thumb_width'] > 0 ? $settings['tw_thumb_width'] : 0);
        $tw_thumb_height        = (isset($settings['tw_thumb_height']) && $settings['tw_thumb_height'] > 0 ? $settings['tw_thumb_height'] : 0);

        $folio_category         = (isset($settings['folio_category']) && !empty($settings['folio_category'])? $settings['folio_category'] : array());
        $pfs_folio              = (isset($settings['pfs_folio']) && !empty($settings['pfs_folio'])? $settings['pfs_folio'] : array());
        
        $folio_no_item          = (isset($settings['folio_no_item']) && !empty($settings['folio_no_item'])? $settings['folio_no_item'] : 4);
        $folio_order_by         = (isset($settings['folio_order_by']) && !empty($settings['folio_order_by'])? $settings['folio_order_by'] : 'date');
        $folio_order            = (isset($settings['folio_order']) && !empty($settings['folio_order'])? $settings['folio_order'] : 'desc');
        $is_pagination          = (isset($settings['is_pagination']) && !empty($settings['is_pagination'])? $settings['is_pagination'] : 'no');
        $pagination_alignment   = (isset($settings['pagination_alignment']) && !empty($settings['pagination_alignment'])? $settings['pagination_alignment'] : 'center');
        $filtr_alignment        = (isset($settings['filtr_alignment']) && !empty($settings['filtr_alignment'])? $settings['filtr_alignment'] : 'right');

        $folio_strlimit         = (isset($settings['folio_strlimit']) && $settings['folio_strlimit'] > 0 ) ? $settings['folio_strlimit'] : 250;
        $lm_more                = (isset($settings['lm_more'])) && $settings['lm_more'] != '' ? $settings['lm_more']  : esc_html__('See Detail', 'themewar');
        
        if($grid_xl_col == 1):
            $xl = 'col-xl-3 ';
        elseif($grid_xl_col == 3):
            $xl = 'col-xl-6 ';
        else:
            $xl = 'col-xl-4 ';
        endif;

        if($grid_lg_col == 1):
            $lg = 'col-lg-3';
        elseif($grid_lg_col == 3):
            $lg = 'col-lg-6';
        else:
            $lg = 'col-lg-4';
        endif;

        if($grid_md_col == 1):
            $md = ' col-md-4';
        elseif($grid_md_col == 3):
            $md = ' col-md-12';
        else:
            $md = ' col-md-6';
        endif;

        include dirname(__FILE__).'/style/portfolio-grid/style'.$folio_item_style.'.php';
        
    }
    
    protected function content_template() {}
}