<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Cta_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-cta';
    }
    
    public function get_title() {
        return esc_html__( 'Call To Action Content', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-text';
    }

    public function get_categories() {
        return [ 'bepro-elements' ];
    }
    
    protected function register_controls() {
        $this->start_controls_section(
            'section_tab', [
                'label' => esc_html__( 'CTA Content', 'themewar' ),
            ]
        );
        $this->add_control(
                'title_01', [
                        'label'         => esc_html__( 'Cta title Top', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => esc_html__("{We're} Creative", 'themewar'),
                        'label_block'   => TRUE,
                        'description'   => esc_html__('Use {} for Different text.', 'themewar'),
                        'placeholder'   => esc_html__('cta top title', 'themewar'),
                ]
        );
        $this->add_control(
                'title_02', [
                        'label'         => esc_html__( 'Cta title Middle', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => esc_html__("BUSINESS", 'themewar'),
                        'label_block'   => TRUE,
                        'placeholder'   => esc_html__('cta middle title', 'themewar'),
                ]
        );
        $this->add_control(
                'title_03', [
                        'label'         => esc_html__( 'Cta title Bottom', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => esc_html__("{Solutions} Agency", 'themewar'),
                        'label_block'   => TRUE,
                        'description'   => esc_html__('Use {} for Different text.', 'themewar'),
                        'placeholder'   => esc_html__('cta bottom title', 'themewar'),
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_top_araa', [
                'label'     => esc_html__( 'Area Styling', 'themewar' ),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
                '_area_padding', [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .ctaCon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                '_area_margin', [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .ctaCon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_top_sub', [
                'label'     => esc_html__( 'Top Title Styling', 'themewar' ),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => '_top_title_typography',
                        'label' => esc_html__( 'Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .ctaCon h4',
                ]
        );
        $this->add_responsive_control(
                'top_title_nr_color', [
                        'label' => esc_html__( 'Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .ctaCon h4' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                '_top_title_margin', [
                        'label' => esc_html__( 'Margin', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .ctaCon h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'heading_rotate',
                [
                        'label'     => esc_html__('Rotate', 'themewar'),
                        'type'      => Controls_Manager::SLIDER,
                        'default'   => [
                            'size'  => -9,
                            'unit'  => 'deg',
                        ],
                        'selectors' => [
                                '{{WRAPPER}} .ctaCon h4' => 'transform: rotate({{SIZE}}{{UNIT}});',
                        ],
                ]
        );
        $this->add_control(
            'heading_un_one',
            [
                'label'     => esc_html__( 'Different Text Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
                'df_color', [
                        'label'      => esc_html__( 'Color', 'themewar' ),
                        'type'       => Controls_Manager::COLOR,
                        'selectors'  => [
                            '{{WRAPPER}} .ctaCon h4 span' => 'color: {{VALUE}};'
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'df_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .ctaCon h4 span',
                ]
        );
        $this->add_responsive_control(
                'df_margin',
                [
                        'label' => esc_html__( 'Marign', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .ctaCon h4 span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_middle_sub', [
                'label'     => esc_html__( 'Middle Title Styling', 'themewar' ),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => '_top2_title_typography',
                        'label' => esc_html__( 'Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .ctaCon h2',
                ]
        );
        $this->add_responsive_control(
                'top2_title_nr_color', [
                        'label' => esc_html__( 'Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .ctaCon h2' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                '_top2_title_margin', [
                        'label' => esc_html__( 'Margin', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .ctaCon h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'heading2_rotate',
                [
                        'label'     => esc_html__('Rotate', 'themewar'),
                        'type'      => Controls_Manager::SLIDER,
                        'default'   => [
                            'size'  => -9,
                            'unit'  => 'deg',
                        ],
                        'selectors' => [
                                '{{WRAPPER}} .ctaCon h2' => 'transform: rotate({{SIZE}}{{UNIT}});',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_ta_bottom_sub', [
                'label'     => esc_html__( 'Bottom Title Styling', 'themewar' ),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => '_top3_title_typography',
                        'label' => esc_html__( 'Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .ctaCon h3',
                ]
        );
        $this->add_responsive_control(
                'top3_title_nr_color', [
                        'label' => esc_html__( 'Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .ctaCon h3' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                '_top3_title_margin', [
                        'label' => esc_html__( 'Margin', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .ctaCon h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'heading_rotate3',
                [
                        'label'     => esc_html__('Rotate', 'themewar'),
                        'type'      => Controls_Manager::SLIDER,
                        'default'   => [
                            'size'  => -9,
                            'unit'  => 'deg',
                        ],
                        'selectors' => [
                                '{{WRAPPER}} .ctaCon h3' => 'transform: rotate({{SIZE}}{{UNIT}});',
                        ],
                ]
        );
        $this->add_control(
            'heading_un_one3',
            [
                'label'     => esc_html__( 'Different Text Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
                'df3_color', [
                        'label'      => esc_html__( 'Color', 'themewar' ),
                        'type'       => Controls_Manager::COLOR,
                        'selectors'  => [
                            '{{WRAPPER}} .ctaCon h3 span' => 'color: {{VALUE}};'
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'df3_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .ctaCon h3 span',
                ]
        );
        $this->add_responsive_control(
                'df3_margin',
                [
                        'label' => esc_html__( 'Marign', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .ctaCon h3 span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
    }
    
    protected function render() {
        $settings      = $this->get_settings_for_display();;
        $title_01      = (isset($settings['title_01']) && $settings['title_01'] != '') ? $settings['title_01'] : esc_html__("{We're} Creative", 'themewar');
        $title_02      = (isset($settings['title_02']) && $settings['title_02'] != '') ? $settings['title_02'] : esc_html__("BUSINESS", 'themewar');
        $title_03      = (isset($settings['title_03']) && $settings['title_03'] != '') ? $settings['title_03'] : esc_html__("{Solutions} Agency", 'themewar');

        $title_01s     = str_replace(['{', '}'], ['<span>', '</span>'], $title_01);
        $title_03s     = str_replace(['{', '}'], ['<span>', '</span>'], $title_03);

        ?>
        <div class="ctaCon">
            <?php if($title_01s != ''): ?>
                <h4><?php echo wp_kses_post($title_01s); ?></h4>
            <?php endif; ?>
            <?php if($title_02 != ''): ?>
                <h2><?php echo wp_kses_post($title_02); ?></h2>
            <?php endif; ?>
            <?php if($title_03s != ''): ?>
                <h3><?php echo wp_kses_post($title_03s); ?></h3>
            <?php endif; ?>
        </div>
        <?php
        
    }
    
    protected function content_template() {}
    
    
}