<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Client_Review_Widget extends Widget_Base{
    
    public function get_name() {
        return 'tw-client-review';
    }
    
    public function get_title() {
        return esc_html__( 'Clinet Ratings', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-rating';
    }

    public function get_categories() {
        return [ 'bepro-elements' ];
    }
    
    protected function register_controls() {
        $this->start_controls_section(
                'section_tab_1',
                [
                    'label'     => esc_html__('Clinet Ratings', 'themewar')
                ]
        );
        $this->add_control(
                'cl_style',
                [
                        'label' => esc_html__( 'Clinet Review Style', 'themewar' ),
                        'type'  => Controls_Manager::SELECT,
                        'default' => 1,
                        'options' => [
                                1                 => esc_html__( 'Style 01', 'themewar' ),
                                2                 => esc_html__( 'Style 02', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'cv_img_1',
                [
                        'label'         => esc_html__( 'Clinet Image 01', 'themewar' ),
                        'type'          => Controls_Manager::MEDIA,
                        'description'   => esc_html__('clinet reviwer image', 'themewar'),
                ]
        );
        $this->add_control(
                'cv_img_2',
                [
                        'label'         => esc_html__( 'Clinet Image 02', 'themewar' ),
                        'type'          => Controls_Manager::MEDIA,
                        'description'   => esc_html__('clinet reviwer image', 'themewar'),
                        'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'cl_style',
                                        'operator'  => '==',
                                        'value'     => '1',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'cv_img_3',
                [
                        'label'         => esc_html__( 'Clinet Image 03', 'themewar' ),
                        'type'          => Controls_Manager::MEDIA,
                        'description'   => esc_html__('clinet reviwer image', 'themewar'),
                        'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'cl_style',
                                        'operator'  => '==',
                                        'value'     => '1',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'box_title',
                [
                        'label'         => esc_html__( 'Review Title', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => esc_html__('Happy Clients & Rating', 'themewar'),
                        'label_block'   => TRUE,
                        'placeholder'   => esc_html__('Box Title', 'themewar'),
                ]
        );
        $this->add_control(
                'avarage_rate',
                [
                        'label'         => esc_html__( 'Avarage Rating', 'themewar' ),
                        'type'          => Controls_Manager::NUMBER,
                        'default'       => esc_html__('4.8', 'themewar'),
                        'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'cl_style',
                                        'operator'  => '==',
                                        'value'     => '1',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'total_reviwer',
                [
                        'label'         => esc_html__( 'Total Reviewer', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => esc_html__('( 8,090 )', 'themewar'),
                ]
        );
        $this->add_control(
                'is_check',
                [
                        'label'             => esc_html__( 'Is Check Icon?', 'themewar' ),
                        'type'              => Controls_Manager::SWITCHER,
                        'label_on'          => esc_html__( 'Yes', 'themewar' ),
                        'label_off'         => esc_html__( 'No', 'themewar' ),
                        'description'       => esc_html__('Do you want to show check btn icon?', 'themewar'),
                        'return_value'      => 'yes',
                        'default'           => 'yes',
                        'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'cl_style',
                                        'operator'  => '==',
                                        'value'     => '1',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_responsive_control(
                'ff_alignment', [
                        'label'                     => esc_html__( 'Alignment', 'themewar' ),
                        'type'                      => Controls_Manager::CHOOSE,
                        'options'                   => [
                                'left'       => [
                                        'title'  => esc_html__( 'Left', 'themewar' ),
                                        'icon'   => 'eicon-text-align-left',
                                ],
                                'center'     => [
                                        'title'  => esc_html__( 'Center', 'themewar' ),
                                        'icon'   => 'eicon-text-align-center',
                                ],
                                'right'      => [
                                        'title'  => esc_html__( 'Right', 'themewar' ),
                                        'icon'   => 'eicon-text-align-right',
                                ]
                        ],
                        'default'                   => 'left',
                        'prefix_class'              => 'ff_content elementor%s-align-',
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_2', [
                    'label'         => esc_html__('Area Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name' => 'icon_box_bg',
                        'label' => esc_html__( 'Box Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .happyClinets, {{WRAPPER}} .abclinets',
                ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name' => 'icon_box_shadow',
                        'label' => esc_html__( 'Box Shadow', 'themewar' ),
                        'selector' => '{{WRAPPER}} .happyClinets, {{WRAPPER}} .abclinets',
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name' => 'box_border',
                        'label' => esc_html__( 'Border', 'themewar' ),
                        'selector' => '{{WRAPPER}} .happyClinets, {{WRAPPER}} .abclinets',
                ]
        );
        $this->add_responsive_control(
                'icon_box_radius',
                [
                        'label' => esc_html__( 'Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .happyClinets' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .abclinets' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .happyClinets' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .abclinets' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .happyClinets' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .abclinets' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_3', [
                'label'     => esc_html__( 'Author Image Styling', 'themewar' ),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'au_img_01',
            [
                'label'     => esc_html__( 'Image 01 Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
                'ab1_img_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .cThumb img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .abclinets img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name'      => 'ab1_img_shadow',
                        'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .cThumb img, {{WRAPPER}} .abclinets img',
                ]
        );
        $this->add_control(
            'ab1_img_radius',
            [
                    'label'      => esc_html__( 'Border Radius', 'themewar' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                            '{{WRAPPER}} .cThumb img'       => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .abclinets img'    => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_control(
            'au_img_02',
            [
                'label'     => esc_html__( 'Image 02 Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
                'ab2_img_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .cThumb img:nth-child(2)' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name'      => 'ab2_img_shadow',
                        'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .cThumb img:nth-child(2)',
                ]
        );
        $this->add_control(
            'ab2_img_radius',
            [
                    'label'      => esc_html__( 'Border Radius', 'themewar' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                            '{{WRAPPER}} .cThumb img:nth-child(2)'       => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_control(
            'au_img_03',
            [
                'label'     => esc_html__( 'Image 03 Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
                'ab3_img_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .cThumb img:nth-child(3)' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name'      => 'ab3_img_shadow',
                        'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .cThumb img:nth-child(3)',
                ]
        );
        $this->add_control(
            'ab3_img_radius',
            [
                    'label'      => esc_html__( 'Border Radius', 'themewar' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                        '{{WRAPPER}} .cThumb img:nth-child(3)'       => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_06', [
                    'label'         => esc_html__('Title Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                ]
        ); 
        $this->add_control(
                'ff_title_color',
                [
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .hcCon h5' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .abclinets p' => 'color: {{VALUE}}',
                        ],
                ]
        );    
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'ff_title_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .hcCon h5, {{WRAPPER}} .abclinets p',
                ]
        );
        $this->add_control(
                'ff_title_margin',
                [
                        'label' => esc_html__( 'Marigns', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .hcCon h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .abclinets p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
                'ff_title_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .hcCon h5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .abclinets p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name' => 'title_border',
                        'label' => esc_html__( 'Border', 'themewar' ),
                        'selector' => '{{WRAPPER}} .hcCon h5, {{WRAPPER}} .abclinets p',
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_07', [
                    'label'         => esc_html__('Review Number Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'cl_style',
                                    'operator'  => '==',
                                    'value'     => '1',
                            ]
                        ],
                    ],
                ]
        ); 
        $this->add_responsive_control(
                'ff_number_color',
                [
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .hcCon p' => 'color: {{VALUE}}',
                        ],
                ]
        );    
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'ff_number_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .hcCon p',
                ]
        );
        $this->add_responsive_control(
                'ff_number_margin',
                [
                        'label' => esc_html__( 'Marigns', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .hcCon p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
            'rate_icon',
            [
                'label'     => esc_html__( 'Rating Icon Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
                'r_icon_color',
                [
                        'label' => esc_html__( 'Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .hcCon p i'   => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'r_icon_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .hcCon p i',
                ]
        );
        $this->add_responsive_control(
                'ff_rate_margin',
                [
                        'label' => esc_html__( 'Marigns', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .hcCon p i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_08', [
                    'label'         => esc_html__('Check Icon Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'cl_style',
                                    'operator'  => '==',
                                    'value'     => '1',
                            ]
                        ],
                    ],
                ]
        ); 
        $this->add_responsive_control(
                'check_icon_color',
                [
                        'label' => esc_html__( 'Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .happyClinets > i'   => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'check_icon_bg_color',
                [
                        'label' => esc_html__( 'BG Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .happyClinets > i'   => 'background: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'check_icon_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .happyClinets > i',
                ]
        );
        $this->add_responsive_control(
                'check_icon_margin',
                [
                        'label' => esc_html__( 'Marigns', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .happyClinets > i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        
        
    }
    protected function render() {
        $settings     = $this->get_settings_for_display();

        $cl_style     = (isset($settings['cl_style']) && $settings['cl_style'] > 0) ? $settings['cl_style'] : 1;

        $cv_img_1     = (isset($settings['cv_img_1']['url']) && $settings['cv_img_1']['url'] != '') ? $settings['cv_img_1']['url'] : '';
        $cv_img_2     = (isset($settings['cv_img_2']['url']) && $settings['cv_img_2']['url'] != '') ? $settings['cv_img_2']['url'] : '';
        $cv_img_3     = (isset($settings['cv_img_3']['url']) && $settings['cv_img_3']['url'] != '') ? $settings['cv_img_3']['url'] : '';

        $box_title    = (isset($settings['box_title']) && $settings['box_title'] != '') ? $settings['box_title'] : esc_html__('Happy Clients & Rating', 'themewar');
        $avarage_rate   = (isset($settings['avarage_rate']) && $settings['avarage_rate'] != '') ? $settings['avarage_rate'] : '4.8';
        $total_reviwer  = (isset($settings['total_reviwer']) && $settings['total_reviwer'] != '') ? $settings['total_reviwer'] : '( 8,090 )';
        $is_check       = $settings['is_check'];

        if($cl_style == 2):
            ?>
            <div class="abclinets">
                <?php if($cv_img_1 != ''): ?>
                    <img src="<?php echo esc_url($cv_img_1); ?>" alt="<?php echo esc_attr__('author', 'themewar'); ?>">
                <?php endif; ?>
                <?php if($total_reviwer != ''): ?>
                    <h2><?php echo wp_kses_post($total_reviwer); ?></h2>
                <?php endif; ?>
                <?php if($box_title != ''): ?>
                    <p><?php echo wp_kses_post($box_title); ?></p>
                <?php endif; ?>
            </div>
            <?php
        else:
            ?>
            <div class="happyClinets">
                <div class="cThumb">
                    <?php if($cv_img_1 != ''): ?>
                        <img class="abbg" src="<?php echo esc_url($cv_img_1); ?>" alt="<?php echo esc_attr__('autho 01', 'themewar'); ?>">
                    <?php endif; ?>
                    <?php if($cv_img_2 != ''): ?>
                        <img class="abbg" src="<?php echo esc_url($cv_img_2); ?>" alt="<?php echo esc_attr__('autho 02', 'themewar'); ?>">
                    <?php endif; ?>
                    <?php if($cv_img_3 != ''): ?>
                        <img class="abbg" src="<?php echo esc_url($cv_img_3); ?>" alt="<?php echo esc_attr__('autho 03', 'themewar'); ?>">
                    <?php endif; ?>
                </div>
                <div class="hcCon">
                    <?php if($box_title != ''): ?>
                        <h5><?php echo wp_kses_post($box_title); ?></h5>
                    <?php endif; ?>
                    <?php if($avarage_rate != '' || $total_reviwer != '' ): ?>
                    <p><i class="twi-star"></i><?php echo wp_kses_post($avarage_rate); ?> <?php echo wp_kses_post($total_reviwer); ?></p>
                    <?php endif; ?>
                </div>
                <?php if($is_check == 'yes'): ?>
                    <i class="twi-check-circle1"></i>
                <?php endif; ?>
            </div>
            <?php
        endif;
        
    }
    
    protected function content_template() {
        
    }
}