<?php

namespace Elementor;

if( !defined('ABSPATH') )
    exit;

class Tw_Button_Widget extends Widget_Base{
    
    public function get_name() {
        return 'tw-button';
    }
    public function get_title() {
        return esc_html__( 'Bepro Button', 'themewar' );
    }
    public function get_icon() {
        return 'eicon-button';
    }
    public function get_categories() {
        return ['bepro-elements'];
    }
    
    protected function register_controls() {
        $this->start_controls_section(
                'section_tab', [
                    'label'     => esc_html__('Button Label', 'themewar')
                ]
        );
        $this->add_control(
                'btn_style',
                [
                        'label'     => esc_html__( 'Button Style', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'label_block'   => TRUE,
                        'default'   => 1,
                        'options'   => [
                                1       => esc_html__( 'Sample Style', 'themewar' ),
                                2       => esc_html__( 'Icon Style 01', 'themewar' ),
                                3       => esc_html__( 'Icon Style 02', 'themewar' ),
                                4       => esc_html__( 'Gradient Style', 'themewar' ),
                                5       => esc_html__( 'App Store Style', 'themewar' ),
                                6       => esc_html__( 'Download Btn Style', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
               'btn_sublabel', [
                    'label'             => esc_html__('Button Sub Label', 'themewar'),
                    'type'              => Controls_Manager::TEXT,
                    'label_block'       => true,
                    'default'           => '',
                    'placeholder'       => esc_html__('Inser Button Sub Label', 'themewar'),
                    'conditions'        => [
                        'terms'         => [
                            [
                                    'name'      => 'btn_style',
                                    'operator'  => 'in',
                                    'value'     => ['5'],
                            ]
                        ],
                    ],
                ]
        );
        $this->add_control(
               'btn_label', [
                    'label'             => esc_html__('Button Label', 'themewar'),
                    'type'              => Controls_Manager::TEXT,
                    'label_block'       => true,
                    'default'           => '',
                    'placeholder'       => esc_html__('Inser Button Label', 'themewar'),
                ]
        );
        $this->add_control(
                'image',
                [
                        'label' => esc_html__( 'Btn Image', 'themewar' ),
                        'label_block'   => TRUE,
                        'type' => Controls_Manager::MEDIA,
                        'default' => [],
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'btn_style',
                                        'operator'  => 'in',
                                        'value'     => ['5'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'btn_icons',
                [
                        'label'         => esc_html__( 'Button Icon', 'themewar' ),
                        'type'          => Controls_Manager::ICON,
                        'label_block'   => TRUE,
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'btn_style',
                                        'operator'  => '!in',
                                        'value'     => ['1', '5'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'btn_icon_position',
                [
                        'label'   => esc_html__( 'Icon Position', 'themewar' ),
                        'type'    => Controls_Manager::SELECT,
                        'default' => 'in_right',
                        'options' => [
                                'in_left'       => esc_html__( 'Left', 'themewar' ),
                                'in_right'      => esc_html__( 'Right', 'themewar' )
                        ],
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'btn_style',
                                        'operator'  => '!in',
                                        'value'     => ['1', '5', '6'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'btn_url', [
                    'label'             => esc_html__( 'URL', 'themewar' ),
                    'type'              => Controls_Manager::URL,
                    'input_type'        => 'url',
                    'placeholder'       => esc_html__( 'https://your-link.com', 'themewar' ),
                    'show_external'     => true,
                    'default'           => [
                            'url'            => '',
                            'is_external'    => true,
                            'nofollow'       => true,
                    ],
                ]
        );
        $this->add_responsive_control(
                'btn_align', [
                        'label'                     => esc_html__( 'Alignment', 'themewar' ),
                        'type'                      => Controls_Manager::CHOOSE,
                        'options'                   => [
                                'left'       => [
                                        'title'  => esc_html__( 'Left', 'themewar' ),
                                        'icon'   => 'eicon-text-align-left',
                                ],
                                'center'     => [
                                        'title'  => esc_html__( 'Center', 'themewar' ),
                                        'icon'   => 'eicon-text-align-center',
                                ],
                                'right'      => [
                                        'title'  => esc_html__( 'Right', 'themewar' ),
                                        'icon'   => 'eicon-text-align-right',
                                ]
                        ],
                        'default'                   => 'center',
                        'prefix_class'              => 'btn_align elementor%s-align-',
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_2',
            [
                'label'         => esc_html__('Button Style', 'themewar'),
                'tab'           => Controls_Manager::TAB_STYLE
            ]
        );
        $this->start_controls_tabs( 'style_tabs_1' );
            $this->start_controls_tab(
                    'btn_1_button_style_normal',
                    [
                            'label' => esc_html__( 'Normal', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'btn_1_label_color',
                    [
                            'label' => esc_html__( 'Color', 'themewar' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .berpo_btn'   => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .storeBtn'    => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name' => 'btn_1_bg',
                            'label' => esc_html__( 'Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .berpo_btn, {{WRAPPER}} .storeBtn',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name'      => 'btn_border',
                            'label'     => esc_html__( 'Border', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .berpo_btn, {{WRAPPER}} .storeBtn',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name'      => 'btn_box_shadow',
                            'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .berpo_btn, {{WRAPPER}} .storeBtn',
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'btn_1_button_style_hover',
                    [
                            'label' => esc_html__( 'Hover', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'btn_label_hover_color',
                    [
                            'label'     => esc_html__( 'Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .berpo_btn:hover'   => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .storeBtn:hover'    => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name' => 'btn_hover__bg',
                            'label' => esc_html__( 'Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .berpo_btn .bp-shape, {{WRAPPER}} .berpo_btn.with_icon03:after, {{WRAPPER}} .storeBtn:hover',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name'      => 'btn_hover_border',
                            'label'     => esc_html__( 'Border', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .berpo_btn:hover, {{WRAPPER}} .storeBtn:hover',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name'      => 'btn_hover_box_shadow',
                            'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .berpo_btn:hover, {{WRAPPER}} .storeBtn:hover',
                    ]
            );
            $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_responsive_control(
			'btn_1_width',
			[
				'label' => esc_html__( 'Width', 'themewar' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [],
				'selectors' => [
					'{{WRAPPER}} .berpo_btn' => 'width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .storeBtn' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
			'btn_1_height',
			[
				'label' => esc_html__( 'Height', 'themewar' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [],
				'selectors' => [
                    '{{WRAPPER}} .berpo_btn' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .storeBtn' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'btn_1_typography',
                        'label' => esc_html__( 'Button Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .berpo_btn, {{WRAPPER}} .storeBtn',
                ]
        );
        $this->add_responsive_control(
            'border_radius',
            [
                    'label' => esc_html__( 'Border Radius', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .berpo_btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .btnwrap'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .storeBtn'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
            'btn_1_padding',
            [
                    'label' => esc_html__( 'Paddings', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .berpo_btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .btnwrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .storeBtn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
            'btn_1_margin',
            [
                    'label' => esc_html__( 'Margin', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .berpo_btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .storeBtn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_3',
            [
                'label'         => esc_html__('Icon Style', 'themewar'),
                'tab'           => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'btn_icon_typography',
                        'label' => esc_html__( 'Icon Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .berpo_btn i',
                ]
        );
        $this->add_responsive_control(
            'icon_border_radius',
            [
                    'label' => esc_html__( 'Border Radius', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .berpo_btn i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->start_controls_tabs( 'style_tabs_2' );
            $this->start_controls_tab(
                    'icon_button_style_normal',
                    [
                            'label' => esc_html__( 'Normal', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'icon_label_color',
                    [
                            'label' => esc_html__( 'Color', 'themewar' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .berpo_btn i'   => 'color: {{VALUE}}'
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name' => 'icon_1_bg',
                            'label' => esc_html__( 'Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .berpo_btn i',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name'      => 'icon_border',
                            'label'     => esc_html__( 'Border', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .berpo_btn i',
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'icon_button_style_hover',
                    [
                            'label' => esc_html__( 'Hover', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'icon_label_hover_color',
                    [
                            'label'     => esc_html__( 'Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .berpo_btn:hover i'   => 'color: {{VALUE}}'
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name' => 'icon_1_hover_bg',
                            'label' => esc_html__( 'Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .berpo_btn:hover i',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name'      => 'icon_hover_border',
                            'label'     => esc_html__( 'Border', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .berpo_btn:hover i',
                    ]
            );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_responsive_control(
                    'icon_1_width',
                    [
                            'label' => esc_html__( 'Width', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 1000,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .berpo_btn i' => 'width: {{SIZE}}{{UNIT}};'
                            ],
                    ]
            );
        $this->add_responsive_control(
                    'icon_1_height',
                    [
                            'label' => esc_html__( 'Height', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 1000,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .berpo_btn i' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                    ]
            );
        $this->add_responsive_control(
            'btn_icon_positioning',
            [
                    'label' => esc_html__( 'Icon Position', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px'],
                    'allowed_dimensions' => ['top', 'bottom'],
                    'selectors' => [
                            '{{WRAPPER}} .berpo_btn i' => 'top: {{TOP}}{{UNIT}}; bottom: {{BOTTOM}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
            'btn_icon_margin',
            [
                    'label' => esc_html__( 'Icon Margin', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px'],
                    'allowed_dimensions' => ['left', 'right'],
                    'selectors' => [
                            '{{WRAPPER}} .berpo_btn i' => 'margin-right: {{RIGHT}}{{UNIT}}; margin-left: {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->end_controls_section();
        
    }
    
    protected function render() {
        $settings       = $this->get_settings_for_display();

        $btn_style      = (isset($settings['btn_style']) && $settings['btn_style'] !='') ? $settings['btn_style'] : 1;

        $btn_sublabel   = (isset($settings['btn_sublabel']) && $settings['btn_sublabel'] != '') ? $settings['btn_sublabel'] : '';
        $btn_label      = (isset($settings['btn_label']) && $settings['btn_label'] != '') ? $settings['btn_label'] : esc_html__('Click Me', 'themewar');
        $icons          = (isset($settings['btn_icons']) && $settings['btn_icons'] != '') ? '<i class="'.$settings['btn_icons'].'"></i>' : '<i class="twi-arrow-right"></i>';
        $dicons          = (isset($settings['btn_icons']) && $settings['btn_icons'] != '') ? $settings['btn_icons'] : 'twi-file-pdf';
        
        $target         = isset($settings['btn_url']['is_external']) ? ' target="_blank"' : '' ;
        $nofollow       = isset($settings['btn_url']['nofollow']) ? ' rel="nofollow"' : '' ;
        $btn_url        = (isset($settings['btn_url']['url']) && $settings['btn_url']['url'] != '') ? $settings['btn_url']['url'] : '#';

        $image          = (isset($settings['image']['url']) && $settings['image']['url'] != '') ? $settings['image']['url'] : '';
        
        $icon_position  = (isset($settings['btn_icon_position']) && $settings['btn_icon_position'] != '' ? $settings['btn_icon_position'] : 'in_right');
        $btn_html       = ($icon_position == 'in_left' ? $icons : '');
        $btn_html       .= $btn_label;
        $btn_html       .= ($icon_position == 'in_right' ? $icons : '');
        
        if($btn_style == 2):
        ?>
        <a class="berpo_btn with_icon <?php echo ($icon_position != '' && $icons != '' ? $icon_position : '') ?>" <?php echo esc_attr($target.' '.$nofollow); ?> href="<?php echo esc_url($btn_url); ?>">
            <span class="bp-shape"></span>
            <span class="bp-shape"></span>
            <span class="bp-shape"></span>
            <span class="bp-shape"></span>
            <span class="bp-text"><?php echo wp_kses_post($btn_html); ?></span>
        </a>
        <?php
        elseif($btn_style == 3):
            ?>
                <a class="berpo_btn with_icon02 <?php echo ($icon_position != '' && $icons != '' ? $icon_position : '') ?>" <?php echo esc_attr($target.' '.$nofollow); ?> href="<?php echo esc_url($btn_url); ?>"><?php if($icon_position == 'in_left'): echo $icons; endif; ?><span class="btnwrap"><span class="bp-shape"></span><span class="bp-shape"></span><span class="bp-shape"></span><span class="bp-shape"></span><span class="bp-text"><?php echo wp_kses_post($btn_label); ?></span></span><?php if($icon_position == 'in_right'): echo $icons; endif; ?></a>
            <?php
        elseif($btn_style == 4):
            ?>
                <a class="berpo_btn with_icon03 <?php echo ($icon_position != '' && $icons != '' ? $icon_position : '') ?>" <?php echo esc_attr($target.' '.$nofollow); ?> href="<?php echo esc_url($btn_url); ?>"><?php echo wp_kses_post($btn_html); ?></a>
            <?php
        elseif($btn_style == 5):
            ?>
                <a class="storeBtn" <?php echo esc_attr($target.' '.$nofollow); ?> href="<?php echo esc_url($btn_url); ?>"><?php if($image != ''): ?><img src="<?php echo esc_url($image); ?>" alt="<?php echo esc_attr__('btn', 'themewar'); ?>"><?php if($btn_sublabel != ''): ?><span><?php endif; ?><?php echo wp_kses_post($btn_sublabel); ?></span><?php endif; ?><?php echo wp_kses_post($btn_label); ?></a>
            <?php
        elseif($btn_style == 6):
            ?>
                <a class="berpo_btn downloadbtn" <?php echo esc_attr($target.' '.$nofollow); ?> href="<?php echo esc_url($btn_url); ?>">
                    <span class="bp-shape"></span>
                    <span class="bp-shape"></span>
                    <span class="bp-shape"></span>
                    <span class="bp-shape"></span>
                    <span class="bp-text"><i class="<?php echo esc_attr($dicons); ?>"></i><?php echo wp_kses_post($btn_label); ?></span>
                </a>
            <?php
        else:
            ?>
            <a class="berpo_btn" <?php echo esc_attr($target.' '.$nofollow); ?> href="<?php echo esc_url($btn_url); ?>">
                <span class="bp-shape"></span>
                <span class="bp-shape"></span>
                <span class="bp-shape"></span>
                <span class="bp-shape"></span>
                <span class="bp-text"><?php echo wp_kses_post($btn_label); ?></span>
            </a>
            <?php
        endif;
    }
    
    protected function content_template() {
        
    }
            
}