<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_About_Widgets extends Widget_Base {
    public function get_name() {
        return 'tw-about';
    }

    public function get_title() {
        return esc_html__('About Us', 'themewar');
    }

    public function get_icon() {
        return 'eicon-wordart';
    }

    public function get_categories() {
        return ['bepro-footer-elements'];
    }
    
    protected function register_controls() {
        $this->start_controls_section(
            'section_tab', [
                'label'         => esc_html__( 'About Us', 'themewar' ),
            ]
        );
        $this->add_control(
                'ab_style',
                [
                        'label' => esc_html__( 'About Widget Style', 'themewar' ),
                        'type'  => Controls_Manager::SELECT,
                        'default' => 1,
                        'options' => [
                                1                 => esc_html__( 'Style 01', 'themewar' ),
                                2                 => esc_html__( 'Style 02', 'themewar' ),
                                3                 => esc_html__( 'Style 03', 'themewar' ),
                                4                 => esc_html__( 'Style 04', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'widget_title', [
                    'label'             => esc_html__('Widget Title', 'themewar'),
                    'type'              => Controls_Manager::TEXT,
                    'label_block'       => TRUE,
                    'default'           => '',
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'ab_style',
                                    'operator'  => 'in',
                                    'value'     => ['1'],
                            ]
                        ],
                    ],
                ]
        );
        $this->add_control(
                'logo_images',
                [
                        'label'         => esc_html__( 'About Logo Image', 'themewar' ),
                        'label_block'   => TRUE,
                        'type'          => Controls_Manager::MEDIA,
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'ab_style',
                                        'operator'  => 'in',
                                        'value'     => ['2', '3', '4'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'widget_content', [
                    'label'             => esc_html__('Widget Content', 'themewar'),
                    'type'              => Controls_Manager::TEXTAREA,
                    'label_block'       => TRUE,
                    'default'           => esc_html__('add description.', 'themewar')
                ]
        );
        $this->add_control(
                'email', [
                    'label'             => esc_html__('Email Info', 'themewar'),
                    'type'              => Controls_Manager::TEXT,
                    'label_block'       => TRUE,
                    'default'           => esc_html__('hello@bepro.com', 'themewar'),
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'ab_style',
                                    'operator'  => '==',
                                    'value'     => '4',
                            ]
                        ],
                    ],
                ]
        );
        $this->add_control(
                'tw_name', [
                    'label'             => esc_html__('Twitter Author Name', 'themewar'),
                    'type'              => Controls_Manager::TEXTAREA,
                    'label_block'       => TRUE,
                    'default'           => esc_html__('Mark Richarson {admin@}', 'themewar'),
                    'description'       => esc_html__('Use {} for admin sub name.', 'themewar'),
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'ab_style',
                                    'operator'  => 'in',
                                    'value'     => ['3'],
                            ]
                        ],
                    ],
                ]
        );
        $repeaters = new \Elementor\Repeater();
        $repeaters->add_control(
                's_icons',
                [
                        'label'         => esc_html__( 'Social Icon', 'themewar' ),
                        'type'          => Controls_Manager::ICON,
                        'label_block'   => TRUE,
                ]
        );
        $repeaters->add_control(
                's_url', [
                    'label'             => esc_html__( 'Social Url', 'themewar' ),
                    'type'              => Controls_Manager::URL,
                    'input_type'        => 'url',
                    'placeholder'       => esc_html__( 'https://your-link.com', 'themewar' ),
                    'show_external'     => true,
                    'default'           => [
                            'url'            => '',
                            'is_external'    => true,
                            'nofollow'       => true,
                    ],
                ]
        );
        $this->add_control(
            's_list',[
                    'label'         => esc_html__( 'Social Item', 'themewar' ),
                    'type'          => Controls_Manager::REPEATER,
                    'fields'        => $repeaters->get_controls(),
                    'default'       => [
                            [
                                    's_icons'            => '',
                                    's_url'              => '',
                            ],
                    ],
                    'title_field' => '{{{ s_icons }}}',
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'ab_style',
                                    'operator'  => 'in',
                                    'value'     => ['1', '4'],
                            ]
                        ],
                    ],
            ]
        );
        $this->add_responsive_control(
                'st_alignment', [
                        'label'                     => esc_html__( 'Alignment', 'themewar' ),
                        'type'                      => Controls_Manager::CHOOSE,
                        'options'                   => [
                                'left'       => [
                                        'title'  => esc_html__( 'Left', 'themewar' ),
                                        'icon'   => 'eicon-text-align-left',
                                ],
                                'center'     => [
                                        'title'  => esc_html__( 'Center', 'themewar' ),
                                        'icon'   => 'eicon-text-align-center',
                                ],
                                'right'      => [
                                        'title'  => esc_html__( 'Right', 'themewar' ),
                                        'icon'   => 'eicon-text-align-right',
                                ]
                        ],
                        'default'                   => 'left',
                        'prefix_class'              => 'about_align elementor%s-align-',
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab__title', [
                'label'         => esc_html__( 'Title Style', 'themewar' ),
                'tab'           => Controls_Manager::TAB_STYLE,
                'conditions'    => [
                    'terms'     => [
                        [
                                'name'      => 'ab_style',
                                'operator'  => 'in',
                                'value'     => ['1'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
                'mt_title_color', [
                        'label'      => esc_html__( 'Color', 'themewar' ),
                        'type'       => Controls_Manager::COLOR,
                        'selectors'  => [
                            '{{WRAPPER}} .fwtitle' => 'color: {{VALUE}};'
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'mt_title_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .fwtitle',
                ]
        );
        $this->add_responsive_control(
                'mt_title_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .fwtitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'mt_title_margin',
                [
                        'label' => esc_html__( 'Marigns', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .fwtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab__logo', [
                'label'         => esc_html__( 'Logo Style', 'themewar' ),
                'tab'           => Controls_Manager::TAB_STYLE,
                'conditions'    => [
                    'terms'     => [
                        [
                                'name'      => 'ab_style',
                                'operator'  => 'in',
                                'value'     => ['2', '3', '4'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
                'logo_box_height',
                [
                        'label'      => esc_html__( 'Height', 'themewar' ),
                        'type'       => Controls_Manager::SLIDER,
                        'size_units' => 'px',
                        'range'      => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                        'step' => 1,
                                ],
                        ],
                        'selectors' => [
                                '{{WRAPPER}} .aboutWidget img' => 'height: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .aboutWidget03 img' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'logo_box_width',
                [
                        'label'      => esc_html__( 'Width', 'themewar' ),
                        'type'       => Controls_Manager::SLIDER,
                        'size_units' => 'px',
                        'range'      => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                        'step' => 1,
                                ],
                        ],
                        'selectors' => [
                                '{{WRAPPER}} .aboutWidget img' => 'width: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .aboutWidget03 img' => 'width: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'logo_margin',
                [
                        'label' => esc_html__( 'Marigns', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .aboutWidget img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .aboutWidget03 img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_4', [
                'label'         => esc_html__( 'Content Style', 'themewar' ),
                'tab'           => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
                'mt_color', [
                        'label'		 => esc_html__( 'Color', 'themewar' ),
                        'type'		 => Controls_Manager::COLOR,
                        'selectors'	 => [
                            '{{WRAPPER}} .fwdesc' => 'color: {{VALUE}};'
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'mt_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .fwdesc',
                ]
        );
        $this->add_responsive_control(
                'mt_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .fwdesc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'mt_margin',
                [
                        'label' => esc_html__( 'Marigns', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .fwdesc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_email', [
                'label'         => esc_html__( 'Email Style', 'themewar' ),
                'tab'           => Controls_Manager::TAB_STYLE,
                'conditions'    => [
                    'terms'     => [
                        [
                                'name'      => 'ab_style',
                                'operator'  => '==',
                                'value'     => '4',
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
                'mt_email_color', [
                        'label'      => esc_html__( 'Color', 'themewar' ),
                        'type'       => Controls_Manager::COLOR,
                        'selectors'  => [
                            '{{WRAPPER}} .email' => 'color: {{VALUE}};'
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name'      => 'email_border',
                        'label'     => esc_html__( 'Border', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .email',
                ]
        );
        $this->add_responsive_control(
                'mt_email_hover_color', [
                        'label'      => esc_html__( 'Hover Color', 'themewar' ),
                        'type'       => Controls_Manager::COLOR,
                        'selectors'  => [
                            '{{WRAPPER}} .email:hover' => 'color: {{VALUE}};'
                        ],
                ]
        );
        $this->add_responsive_control(
                'mt_email_hover_border_color', [
                        'label'      => esc_html__( 'Hover Border Color', 'themewar' ),
                        'type'       => Controls_Manager::COLOR,
                        'selectors'  => [
                            '{{WRAPPER}} .email:hover' => 'border-color: {{VALUE}};'
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'mt_email_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .email',
                ]
        );
        $this->add_responsive_control(
                'mt_email_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .email' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'mt_email_margin',
                [
                        'label' => esc_html__( 'Marigns', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .email' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_2', [
                    'label'         => esc_html__('Social Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'ab_style',
                                    'operator'  => 'in',
                                    'value'     => ['1', '4'],
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_border_radius',
                [
                        'label'         => esc_html__( 'Border Radius', 'themewar' ),
                        'type'          => Controls_Manager::DIMENSIONS,
                        'size_units'    => [ 'px', '%', 'em' ],
                        'selectors'     => [
                            '{{WRAPPER}} .abcmsocial a'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_height',
                [
                        'label'      => esc_html__( 'Height', 'themewar' ),
                        'type'       => Controls_Manager::SLIDER,
                        'size_units' => 'px',
                        'range'      => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                        'step' => 1,
                                ],
                        ],
                        'selectors' => [
                                '{{WRAPPER}} .abcmsocial a' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_width',
                [
                        'label'      => esc_html__( 'Width', 'themewar' ),
                        'type'       => Controls_Manager::SLIDER,
                        'size_units' => 'px',
                        'range'      => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                        'step' => 1,
                                ],
                        ],
                        'selectors' => [
                                '{{WRAPPER}} .abcmsocial a' => 'width: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'          => 'icon_typography',
                        'label'         => esc_html__( 'Icon Typography', 'themewar' ),
                        'selector'      => '{{WRAPPER}} .abcmsocial a',
                ]
        );
        $this->add_responsive_control(
                'icon_box_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .abcmsocial a'  => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .abcmsocial a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->start_controls_tabs( 'social_styling_tab' );
            $this->start_controls_tab(
                    'social_tab_normal',
                    [
                            'label' => esc_html__( 'Normal', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'social_icon_color',
                    [
                            'label'     => esc_html__( 'Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .abcmsocial a'    => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name' => 'social_bg',
                            'label' => esc_html__( 'Box Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .abcmsocial a',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name'      => 's_border',
                            'label'     => esc_html__( 'Border', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .abcmsocial a',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name'      => 's_box_shadow',
                            'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .abcmsocial a',
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'social_tab_hover',
                    [
                            'label' => esc_html__( 'Hover', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'social_icon_hover_color',
                    [
                            'label'     => esc_html__( 'Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .abcmsocial a:hover'    => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name' => 'social_hover_bg',
                            'label' => esc_html__( 'Box Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .abcmsocial a:hover',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name'      => 's_hover_border',
                            'label'     => esc_html__( 'Border', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .abcmsocial a:hover',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name'      => 's_hover_box_shadow',
                            'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .abcmsocial a:hover',
                    ]
            );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_tw_cion',[
                    'label'         => esc_html__('Twitter Icon Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'ab_style',
                                    'operator'  => 'in',
                                    'value'     => ['3'],
                            ]
                        ],
                    ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'icon_box_i_typography',
                        'label'     => esc_html__( 'Icon Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .twiiterFedd i'
                ]
        );
        $this->add_responsive_control(
                'icon_box_i_color',[
                        'label'     => esc_html__( 'Icon Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .twiiterFedd i' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name' => 'icon_box_i_bg_color',
                        'label' => esc_html__( 'Box Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .twiiterFedd i',
                ]
        );
        $this->add_control(
            'icon_box_i_radius',
            [
                    'label' => esc_html__( 'Border Radius', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .twiiterFedd i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
                'icon_box_i_width',
                [
                        'label' => __( 'Width', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .twiiterFedd i' => 'width: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_i_height',
                [
                        'label' => __( 'Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .twiiterFedd i' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name' => 'icon_box_i_border_hr',
                        'label' => esc_html__( 'Border', 'themewar' ),
                        'selector' => '{{WRAPPER}} .twiiterFedd i',
                ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name' => 'icon_box_i__shadow',
                        'label' => esc_html__( 'Box Shadow', 'themewar' ),
                        'selector' => '{{WRAPPER}} .twiiterFedd i',
                ]
        );
        $this->add_responsive_control(
                'icon_box_i_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .twiiterFedd i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                ]
        );
        $this->add_responsive_control(
                'icon_box_i_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .twiiterFedd i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_tw_anme', [
                'label'         => esc_html__( 'Twitter Author Name Style', 'themewar' ),
                'tab'           => Controls_Manager::TAB_STYLE,
                'conditions'    => [
                    'terms'     => [
                        [
                                'name'      => 'ab_style',
                                'operator'  => 'in',
                                'value'     => ['3'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'icon_tw_anme_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .twiiterFedd h5'
                ]
        );
        $this->add_responsive_control(
                'icon_tw_anme_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .twiiterFedd h5' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'tw_anme_margin',
                [
                        'label' => esc_html__( 'Marigns', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .twiiterFedd h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
            'heading_gradian',
            [
                'label'     => esc_html__( 'Sub Name Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'icon_tw_sub_anme_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .twiiterFedd h5 span'
                ]
        );
        $this->add_responsive_control(
                'icon_tw_sub_anme_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .twiiterFedd h5 span' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'tw_sub_anme_margin',
                [
                        'label' => esc_html__( 'Marigns', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .twiiterFedd h5 span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
    }
    
    protected function render() {
        $settings           = $this->get_settings_for_display();

        $ab_style           = (isset($settings['ab_style']) && $settings['ab_style'] > 0) ? $settings['ab_style'] : 1;
        
        $widget_title       = (isset($settings['widget_title']) && $settings['widget_title'] !='') ? $settings['widget_title'] : '';
        
        $logo_images        = (isset($settings['logo_images']['url']) && $settings['logo_images']['url'] != '') ? $settings['logo_images']['url'] : '';
        $widget_content     = (isset($settings['widget_content']) && $settings['widget_content'] !='') ? $settings['widget_content'] : '';
        $email              = (isset($settings['email']) && $settings['email'] !='') ? $settings['email'] : '';
        $tw_name            = (isset($settings['tw_name']) && $settings['tw_name'] !='') ? $settings['tw_name'] : esc_html__('Mark Richarson {admin@}', 'themewar');
        $para               = str_replace(['{', '}'], ['<span">', '</span>'], $tw_name);
        
        $s_list             = (isset($settings['s_list']) && !empty($settings['s_list'])) ? $settings['s_list'] : array();
        
        if($ab_style == 2):
        ?>
        <div class="aboutWidget">
            <?php if($logo_images != ''): ?>
                <a href="<?php echo esc_url(home_url('/')); ?>"><img src="<?php echo esc_url($logo_images); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>"></a>
            <?php endif; ?>
            <?php if($widget_content != ''): ?>
                <p class="fwdesc"><?php echo wp_kses_post($widget_content); ?></p>
            <?php endif; ?>
        </div>
        <?php
        elseif($ab_style == 3):
        ?>
        <div class="aboutWidget abw02">
            <?php if($logo_images != ''): ?>
                <a href="<?php echo esc_url(home_url('/')); ?>"><img src="<?php echo esc_url($logo_images); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>"></a>
            <?php endif; ?>
            <?php if($widget_content != ''): ?>
                <p class="fwdesc"><?php echo wp_kses_post($widget_content); ?></p>
            <?php endif; ?>
            <div class="twiiterFedd">
                <i class="twi-twitter"></i>
                <h5><?php echo wp_kses_post($para); ?></h5>
            </div>
        </div>
        <?php
        elseif($ab_style == 4):
        ?>
        <div class="aboutWidget03">
            <?php if($logo_images != ''): ?>
                <a href="<?php echo esc_url(home_url('/')); ?>"><img src="<?php echo esc_url($logo_images); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>"></a>
            <?php endif; ?>
            <?php if($widget_content != ''): ?>
                <p class="fwdesc"><?php echo wp_kses_post($widget_content); ?></p>
            <?php endif; ?>
            <?php if($email != ''): ?>
                <a class="email" href="mailto:<?php echo esc_attr($email); ?>"><?php echo wp_kses_post($email); ?></a>
            <?php endif; ?>
            <div class="absocaila abcmsocial">
                <?php 
                if(!empty($s_list)):
                    foreach($s_list as $sl):
                        $s_icons      = (isset($sl['s_icons']) ? $sl['s_icons'] : '');
                        $s_url        = (isset($sl['s_url']['url']) ? $sl['s_url']['url'] : '');
                        $target       = $sl['s_url']['is_external'] ? ' target="_blank"' : '' ;
                        $nofollow     = $sl['s_url']['nofollow'] ? ' rel="nofollow"' : '' ;
                        
                        if($s_icons != ''):
                        ?>
                        <a <?php echo esc_attr($target.' '.$nofollow); ?> href="<?php echo $s_url; ?>"><i class="<?php echo esc_attr($s_icons); ?>"></i></a>
                        <?php
                        endif;
                    endforeach;
                endif;
                ?>
            </div>
        </div>
        <?php
        else:
        ?>
        <div class="aboutWidget04">
            <?php if($widget_title != ''): ?>
                <h4 class="fwtitle"><?php echo wp_kses_post($widget_title); ?></h4>
            <?php endif; ?>
            <?php if($widget_content != ''): ?>
                <p class="fwdesc"><?php echo wp_kses_post($widget_content); ?></p>
            <?php endif; ?>
            <div class="abcmsocial">
            <?php 
                if(!empty($s_list)):
                    foreach($s_list as $sl):
                        $s_icons      = (isset($sl['s_icons']) ? $sl['s_icons'] : '');
                        $s_url        = (isset($sl['s_url']['url']) ? $sl['s_url']['url'] : '');
                        $target       = $sl['s_url']['is_external'] ? ' target="_blank"' : '' ;
                        $nofollow     = $sl['s_url']['nofollow'] ? ' rel="nofollow"' : '' ;
                        
                        if($s_icons != ''):
                        ?>
                        <a <?php echo esc_attr($target.' '.$nofollow); ?> href="<?php echo $s_url; ?>"><i class="<?php echo esc_attr($s_icons); ?>"></i></a>
                        <?php
                        endif;
                    endforeach;
                endif;
                ?>
            </div>
        </div>
        <?php
        endif;
    }
    
    protected function content_template() {}
}