<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_About_Image_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-about-image';
    }
    
    public function get_title() {
        return esc_html__( 'About Image', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-image';
    }

    public function get_categories() {
        return [ 'bepro-elements' ];
    }
    
    protected function register_controls() {
        $this->start_controls_section(
                'section_tab_1',
                [
                    'label'     => esc_html__('Image', 'themewar')
                ]
        );
        $this->add_control(
                'exp_style',
                [
                        'label' => esc_html__( 'Ab Image Style', 'themewar' ),
                        'type'  => Controls_Manager::SELECT,
                        'default' => 1,
                        'options' => [
                                1                 => esc_html__( 'Image With BG', 'themewar' ),
                                2                 => esc_html__( 'Stratch Image', 'themewar' ),
                                3                 => esc_html__( 'About Quote', 'themewar' ),
                                4                 => esc_html__( 'About Multi Image', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'abimages',
                [
                        'label' => esc_html__( 'About Image', 'themewar' ),
                        'label_block'   => TRUE,
                        'type' => Controls_Manager::MEDIA,
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'exp_style',
                                        'operator'  => '!in',
                                        'value'     => ['3'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'abimg02',
                [
                        'label'         => esc_html__( 'About Image 02', 'themewar' ),
                        'label_block'   => TRUE,
                        'type'          => Controls_Manager::MEDIA,
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'exp_style',
                                        'operator'  => '==',
                                        'value'     => '4',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'img_floating',
                [
                        'label'     => esc_html__( 'Image Alignment', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 0,
                        'options'   => [
                                0                  => esc_html__( 'Default', 'themewar' ),
                                1                  => esc_html__( 'Left', 'themewar' ),
                                2                  => esc_html__( 'Right', 'themewar' ),
                        ],
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'exp_style',
                                        'operator'  => 'in',
                                        'value'     => ['2'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'box_desc',
                [
                        'label'         => esc_html__( 'Quote Content', 'themewar' ),
                        'type'          => Controls_Manager::TEXTAREA,
                        'default'       => esc_html__('about quote content here', 'themewar'),
                        'placeholder'   => esc_html__('Insert quote Content Here', 'themewar'),
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'exp_style',
                                        'operator'  => '==',
                                        'value'     => '3',
                                ]
                            ],
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_3', [
                    'label'         => esc_html__('Area Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name' => 'icon_box_bg',
                        'label' => esc_html__( 'Box Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .abbgThumb, {{WRAPPER}} .abImg, {{WRAPPER}} .abpageThumb, {{WRAPPER}} .expCount03',
                ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name' => 'icon_box_shadow',
                        'label' => esc_html__( 'Box Shadow', 'themewar' ),
                        'selector' => '{{WRAPPER}} .abbgThumb, {{WRAPPER}} .abImg, {{WRAPPER}} .abpageThumb, {{WRAPPER}} .expCount03',
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name' => 'box_border',
                        'label' => esc_html__( 'Box Border', 'themewar' ),
                        'selector' => '{{WRAPPER}} .abbgThumb, {{WRAPPER}} .abImg, {{WRAPPER}} .abpageThumb, {{WRAPPER}} .expCount03',
                ]
        );
        $this->add_responsive_control(
                'icon_box_radius',
                [
                        'label' => esc_html__( 'Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .abbgThumb' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .abImg' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .abpageThumb' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .expCount03' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .abbgThumb' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .abImg' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .abpageThumb' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .expCount03' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .abbgThumb' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .abImg' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .abpageThumb' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .expCount03' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_box_img',[
                    'label'         => esc_html__('Image Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                ]
        );
        $this->add_responsive_control(
                'icon_box_fimg_width',
                [
                        'label' => esc_html__( 'Image Width', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .abbgThumb img' => 'max-width: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .abImg img' => 'max-width: {{SIZE}}{{UNIT}} !important;',
                                '{{WRAPPER}} .abpageThumb > img' => 'max-width: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_fimg_height',
                [
                        'label' => esc_html__( 'Image Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .abbgThumb img' => 'height: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .abImg img' => 'height: {{SIZE}}{{UNIT}} !important;',
                                '{{WRAPPER}} .abpageThumb > img' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name' => 'icon_box_fimg_shadow',
                        'label' => esc_html__( 'Box Shadow', 'themewar' ),
                        'selector' => '{{WRAPPER}} .abbgThumb img, {{WRAPPER}} .abImg img, {{WRAPPER}} .abpageThumb > img',
                ]
        );
        $this->add_responsive_control(
                'icon_box_fimg_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .abbgThumb img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .abImg img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .abpageThumb > img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                ]
        );
        $this->add_responsive_control(
                'icon_box_fimg_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .abbgThumb' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .abImg img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .abpageThumb > img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                ]
        );
        $this->add_control(
            'heading_hover_gradian',
            [
                'label'     => esc_html__( 'Image 02 Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'after',
                'conditions'    => [
                        'terms' => [
                            [
                                    'name'      => 'exp_style',
                                    'operator'  => '==',
                                    'value'     => '4',
                            ]
                        ],
                ],
            ]
        );
        $this->add_responsive_control(
                'icon_box_fimg2_width',
                [
                        'label' => esc_html__( 'Image Width', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .abInner img' => 'max-width: {{SIZE}}{{UNIT}};',
                        ],
                        'conditions'    => [
                                'terms' => [
                                    [
                                            'name'      => 'exp_style',
                                            'operator'  => '==',
                                            'value'     => '4',
                                    ]
                                ],
                        ]
                ]
        );
        $this->add_responsive_control(
                'icon_box_fimg2_height',
                [
                        'label' => esc_html__( 'Image Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .abInner img' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                        'conditions'    => [
                                'terms' => [
                                    [
                                            'name'      => 'exp_style',
                                            'operator'  => '==',
                                            'value'     => '4',
                                    ]
                                ],
                        ]
                ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name' => 'icon_box_fimg2_shadow',
                        'label' => esc_html__( 'Box Shadow', 'themewar' ),
                        'selector' => '{{WRAPPER}} .abInner img',
                        'conditions'    => [
                                'terms' => [
                                    [
                                            'name'      => 'exp_style',
                                            'operator'  => '==',
                                            'value'     => '4',
                                    ]
                                ],
                        ]
                ]
        );
        $this->add_responsive_control(
                'icon_box_fimg2_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .abInner img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'conditions'    => [
                                'terms' => [
                                    [
                                            'name'      => 'exp_style',
                                            'operator'  => '==',
                                            'value'     => '4',
                                    ]
                                ],
                        ]
                ]
        );
        $this->add_responsive_control(
            'tab_area_tp2_positioning',
            [
                    'label' => esc_html__( 'Top Position', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px'],
                    'allowed_dimensions' => ['top'],
                    'selectors' => [
                        '{{WRAPPER}} .abInner'   => 'top: {{TOP}}{{UNIT}};',
                    ],
                    'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'exp_style',
                                        'operator'  => '==',
                                        'value'     => '4',
                                ]
                            ],
                    ]
            ]
        );
        $this->add_responsive_control(
            'tab_area_rp2_positioning',
            [
                    'label' => esc_html__( 'Right Position', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px'],
                    'allowed_dimensions' => ['right'],
                    'selectors' => [
                        '{{WRAPPER}} .abInner'   => 'right: {{RIGHT}}{{UNIT}};',
                    ],
                    'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'exp_style',
                                        'operator'  => '==',
                                        'value'     => '4',
                                ]
                            ],
                    ]
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_5', [
                    'label'         => esc_html__('Border Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'exp_style',
                                    'operator'  => 'in',
                                    'value'     => ['2', '4']
                            ]
                        ],
                    ],
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name' => 'box_border_border',
                        'label' => esc_html__( 'Border', 'themewar' ),
                        'selector' => '{{WRAPPER}} .abInner:after',
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'exp_style',
                                        'operator'  => '==',
                                        'value'     => '4'
                                ]
                            ],
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_border_radius',
                [
                        'label' => esc_html__( 'Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .abInner:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'exp_style',
                                        'operator'  => '==',
                                        'value'     => '4'
                                ]
                            ],
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'tab_area__bg',
                    'label' => esc_html__( 'Background', 'themewar' ),
                    'types' => [ 'classic', 'gradient'],
                    'selector' => '{{WRAPPER}} .withborder',
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'exp_style',
                                    'operator'  => 'in',
                                    'value'     => ['2']
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_border_width',
                [
                        'label' => esc_html__( 'Width', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .withborder' => 'max-width: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .abInner:after' => 'width: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_border_height',
                [
                        'label' => esc_html__( 'Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .withborder' => 'height: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .abInner:after' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
            'tab_area_tp_positioning',
            [
                    'label' => esc_html__( 'Top Position', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px'],
                    'allowed_dimensions' => ['top'],
                    'selectors' => [
                        '{{WRAPPER}} .withborder'   => 'top: {{TOP}}{{UNIT}};',
                        '{{WRAPPER}} .abInner:after'   => 'top: {{TOP}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
            'tab_area_rp_positioning',
            [
                    'label' => esc_html__( 'Right Position', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px'],
                    'allowed_dimensions' => ['right'],
                    'selectors' => [
                        '{{WRAPPER}} .withborder'   => 'right: {{RIGHT}}{{UNIT}};',
                        '{{WRAPPER}} .abInner:after'   => 'right: {{RIGHT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
            'tab_area_bp_positioning',
            [
                    'label' => esc_html__( 'Bottom Position', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px'],
                    'allowed_dimensions' => ['bottom'],
                    'selectors' => [
                        '{{WRAPPER}} .withborder' => 'bottom: {{BOTTOM}}{{UNIT}};',
                        '{{WRAPPER}} .abInner:after' => 'bottom: {{BOTTOM}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
            'tab_area_lp_positioning',
            [
                    'label' => esc_html__( 'Left Position', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px'],
                    'allowed_dimensions' => ['left'],
                    'selectors' => [
                        '{{WRAPPER}} .withborder' => 'left: {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .abInner:after' => 'left: {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->end_controls_section();
        
    }
    protected function render() {
        $settings       = $this->get_settings_for_display();
        $exp_style      = (isset($settings['exp_style']) && $settings['exp_style'] > 0) ? $settings['exp_style'] : 1;

        $abimages       = (isset($settings['abimages']['url']) && $settings['abimages']['url'] != '') ? $settings['abimages']['url'] : '';

        $abimg02        = (isset($settings['abimg02']['url']) && $settings['abimg02']['url'] != '') ? $settings['abimg02']['url'] : '';

        $box_desc       = (isset($settings['box_desc']) && $settings['box_desc'] != '') ? $settings['box_desc'] : '';

        $img_floating   = (isset($settings['img_floating']) && $settings['img_floating'] > 0) ? $settings['img_floating'] : 0;

        $img_class = '';
        if($img_floating == 1){
            $img_class = 'float-left';
        }elseif ($img_floating == 2) {
            $img_class = 'float-right';
        }else{
            $img_class = '';
        }
        
        if($exp_style == 2):
        ?>
        <div class="tw-stretch-element-inside-column02">
            <div class="withborder"></div>
            <?php if($abimages != ''): ?>
                <div class="abImg <?php echo esc_attr($img_class); ?>">
                    <img src="<?php echo esc_url($abimages); ?>" alt="<?php the_title_attribute(); ?>"/>
                </div>
            <?php endif; ?>
        </div>
        <?php
        elseif($exp_style == 3):
        ?>
        <?php if($box_desc != ''): ?>
        <div class="abquote"><?php echo wp_kses_post($box_desc); ?></div>
        <?php endif; ?>
        <?php
        elseif($exp_style == 4):
        ?>
        <div class="abpageThumb">
            <?php if($abimages != ''): ?>
                <img src="<?php echo esc_url($abimages); ?>" alt="<?php the_title_attribute(); ?>"/>
            <?php endif; ?>
            <div class="abInner">
                <?php if($abimg02 != ''): ?>
                    <img src="<?php echo esc_url($abimg02); ?>" alt="<?php the_title_attribute(); ?>"/>
                <?php endif; ?>
            </div>
        </div>
        <?php
        else:
            if($abimages != ''): ?>
                <div class="abbgThumb">
                    <img src="<?php echo esc_url($abimages); ?>" alt="<?php echo esc_attr__('abbgThumb', 'themewar'); ?>">
                </div>
                <?php
            endif;
        endif;
        
    }
    
    protected function content_template() {}
}