<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_About_Experince_Widget extends Widget_Base{
    
    public function get_name() {
        return 'tw-about-experince';
    }
    
    public function get_title() {
        return esc_html__( 'About Experience', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-counter';
    }

    public function get_categories() {
        return [ 'bepro-elements' ];
    }
    
    protected function register_controls() {
        $this->start_controls_section(
                'section_tab_1',
                [
                    'label'     => esc_html__('Image', 'themewar')
                ]
        );
        $this->add_control(
                'exp_style',
                [
                        'label' => esc_html__( 'Experience Style', 'themewar' ),
                        'type'  => Controls_Manager::SELECT,
                        'default' => 1,
                        'options' => [
                                1                 => esc_html__( 'Style 01', 'themewar' ),
                                2                 => esc_html__( 'Style 02', 'themewar' ),
                                3                 => esc_html__( 'Style 03', 'themewar' ),
                                4                 => esc_html__( 'Style 04', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'yeare_of_exp',
                [
                        'label'         => esc_html__( 'Exp Number', 'themewar' ),
                        'type'          => Controls_Manager::NUMBER,
                        'min'           => 1,
                        'max'           => 500,
                        'step'          => 1,
                        'default'       => 80,
                ]
        );
        $this->add_control(
                'yoe_suffix',
                [
                        'label'         => esc_html__( 'Year Suffix', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'description'   => esc_html__( 'Insert suffix for Years.', 'themewar' ),
                        'default'       => '',
                ]
        );
        $this->add_control(
                'exp_label',
                [
                        'label'         => esc_html__( 'Experience Label', 'themewar' ),
                        'type'          => Controls_Manager::TEXTAREA,
                        'description'   => esc_html__( 'Insert experience label.', 'themewar' ),
                        'default'       => esc_html__( 'Partners in world wide', 'themewar' ),
                ]
        );
        $this->add_responsive_control(
                'box_alignment', [
                        'label'                     =>esc_html__( 'Box Alignment', 'themewar' ),
                        'type'                      => Controls_Manager::CHOOSE,
                        'options'                   => [
                                'left'       => [
                                        'title'  => esc_html__( 'Left', 'themewar' ),
                                        'icon'   => 'eicon-text-align-left',
                                ],
                                'center'     => [
                                        'title'  => esc_html__( 'Center', 'themewar' ),
                                        'icon'   => 'eicon-text-align-center',
                                ],
                                'right'      => [
                                        'title'  => esc_html__( 'Right', 'themewar' ),
                                        'icon'   => 'eicon-text-align-right',
                                ]
                        ],
                        'default'                   => 'left',
                        'prefix_class'              => 'box_holder elementor%s-align-',
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'exp_style',
                                        'operator'  => 'in',
                                        'value'     => ['4'],
                                ]
                            ],
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_3', [
                    'label'         => esc_html__('Area Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                ]
        );
        $this->add_responsive_control(
                'icon_box_radius',
                [
                        'label' => esc_html__( 'Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .ClientNumber' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .expCount' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .expCount02' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .expCount03' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .ClientNumber' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .expCount' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .expCount02' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .expCount03' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .ClientNumber' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .expCount' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .expCount02' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .expCount03' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->start_controls_tabs( 'ib_box_tot' );
            $this->start_controls_tab(
                'ib_box_nr', [ 'label' => esc_html__( 'Normal', 'themewar' )]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name' => 'icon_box_bg',
                            'label' => esc_html__( 'Box Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .ClientNumber, {{WRAPPER}} .expCount, {{WRAPPER}} .expCount02, {{WRAPPER}} .expCount03',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'icon_box_shadow',
                            'label' => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .ClientNumber, {{WRAPPER}} .expCount, {{WRAPPER}} .expCount02, {{WRAPPER}} .expCount03',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'box_border',
                            'label' => esc_html__( 'Box Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .ClientNumber, {{WRAPPER}} .expCount, {{WRAPPER}} .expCount02, {{WRAPPER}} .expCount03',
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                'ib_box_hr', [ 'label' => esc_html__( 'Hover', 'themewar' )]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name' => 'icon_box_bg_hr',
                            'label' => esc_html__( 'Box Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .ClientNumber:hover, {{WRAPPER}} .expCount:hover, {{WRAPPER}} .expCount02:hover, {{WRAPPER}} .expCount03:hover',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'icon_box_shadow_hr',
                            'label' => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .ClientNumber:hover, {{WRAPPER}} .expCount:hover, {{WRAPPER}} .expCount02:hover, {{WRAPPER}} .expCount03:hover',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'box_border_hr',
                            'label' => esc_html__( 'Box Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .ClientNumber:hover, {{WRAPPER}} .expCount:hover, {{WRAPPER}} .expCount02:hover, {{WRAPPER}} .expCount03:hover',
                    ]
            );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_responsive_control(
                'white_border_color',
                [
                        'label'     => esc_html__( 'Area White Border Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .expCount:before' => 'background: {{VALUE}}',
                            '{{WRAPPER}} .expCount:after'  => 'background: {{VALUE}}',
                        ],
                        'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'exp_style',
                                        'operator'  => 'in',
                                        'value'     => ['2'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_responsive_control(
                'ht_bor_height',
                [
                        'label' => __( 'Area White Border Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .expCount:before' => 'height: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .expCount:after' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                        'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'exp_style',
                                        'operator'  => 'in',
                                        'value'     => ['2'],
                                ]
                            ],
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_4', [
                'label'     => esc_html__( 'Exp Number Styling', 'themewar' ),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
                'years_color',
                [
                        'label'     => esc_html__( 'Normal Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .cnuumber' => 'color: {{VALUE}}'
                        ],
                ]
        );
        $this->add_control(
            'heading_un_one',
            [
                'label'     => esc_html__( 'Gradina Color and BG Image Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name' => 'exp_number_ccolor',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .expCount03 h2, {{WRAPPER}} .expCount02 h2',
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'years_typo',
                        'label' => esc_html__( 'Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .cnuumber',
                ]
        );
        $this->add_responsive_control(
            'years_margin',
            [
                    'label' => esc_html__( 'Margins', 'themewar' ),
                    'type'  => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                            '{{WRAPPER}} .cnuumber' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_control(
            'heading_un_two',
            [
                'label'     => esc_html__( 'Suffix Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
                'suffix_color',
                [
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .cnuumber sup' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .expCount02 .cnuumber sup' => '-webkit-text-fill-color: {{VALUE}}',
                            '{{WRAPPER}} .expCount03 .cnuumber sup' => '-webkit-text-fill-color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'suffix_typo',
                        'label' => esc_html__( 'Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .cnuumber sup',
                ]
        );
        $this->add_responsive_control(
            'suffix_positioning',
            [
                    'label' => esc_html__( 'Icon Position', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px'],
                    'allowed_dimensions' => ['top', 'bottom'],
                    'selectors' => [
                            '{{WRAPPER}} .cnuumber sup' => 'top: {{TOP}}{{UNIT}}; bottom: {{BOTTOM}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
            'suffix_margin',
            [
                    'label' => esc_html__( 'Icon Margin', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px'],
                    'allowed_dimensions' => ['left', 'right'],
                    'selectors' => [
                            '{{WRAPPER}} .cnuumber sup' => 'margin-right: {{RIGHT}}{{UNIT}}; margin-left: {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_5', [
                'label'     => esc_html__( 'Exp Label Styling', 'themewar' ),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
                'exp_color',
                [
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .exp_label' => 'color: {{VALUE}}'
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'exp_typo',
                        'label' => esc_html__( 'Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .exp_label',
                ]
        );
        $this->add_responsive_control(
            'exp_margin',
            [
                    'label' => esc_html__( ' Margins', 'themewar' ),
                    'type'  => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                            '{{WRAPPER}} .exp_label' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->end_controls_section();
        
    }
    protected function render() {
        $settings       = $this->get_settings_for_display();
        $exp_style      = (isset($settings['exp_style']) && $settings['exp_style'] > 0) ? $settings['exp_style'] : 1;

        $yeare_of_exp   = (isset($settings['yeare_of_exp']) && $settings['yeare_of_exp'] > 0 ? $settings['yeare_of_exp'] : 80);
        $yoe_suffix     = (isset($settings['yoe_suffix']) && $settings['yoe_suffix'] != '' ? $settings['yoe_suffix'] : '');
        $exp_label      = (isset($settings['exp_label']) && $settings['exp_label'] != '' ? $settings['exp_label'] : esc_html__('Partners in world wide', 'themewar'));
        
        if($exp_style == 2):
        ?>
        <div class="expCount countfact" data-count="<?php echo esc_attr($yeare_of_exp); ?>">
            <h2 class="cnuumber"><span class="counter"><?php echo esc_html($yeare_of_exp); ?></span><sup><?php echo esc_html($yoe_suffix); ?></sup></h2>
            <?php if($exp_label != ''): ?>
                <p class="exp_label"><?php echo wp_kses_post($exp_label); ?></p>
            <?php endif; ?>
        </div>
        <?php
        elseif($exp_style == 3):
        ?>
        <div class="expCount02 countfact" data-count="<?php echo esc_attr($yeare_of_exp); ?>">
            <h2 class="cnuumber"><span class="counter"><?php echo esc_html($yeare_of_exp); ?></span><sup><?php echo esc_html($yoe_suffix); ?></sup></h2>
            <?php if($exp_label != ''): ?>
                <h5 class="exp_label"><?php echo wp_kses_post($exp_label); ?></h5>
            <?php endif; ?>
        </div>
        <?php
        elseif($exp_style == 4):
        ?>
        <div class="expCount03 countfact" data-count="<?php echo esc_attr($yeare_of_exp); ?>">
            <h2 class="cnuumber"><span class="counter"><?php echo esc_html($yeare_of_exp); ?></span><sup><?php echo esc_html($yoe_suffix); ?></sup></h2>
            <?php if($exp_label != ''): ?>
                <h5 class="exp_label"><?php echo wp_kses_post($exp_label); ?></h5>
            <?php endif; ?>
        </div>
        <?php
        else:
            ?>
            <div class="ClientNumber countfact" data-count="<?php echo esc_attr($yeare_of_exp); ?>">
                <h2 class="cnuumber"><span class="counter"><?php echo esc_html($yeare_of_exp); ?></span><sup><?php echo esc_html($yoe_suffix); ?></sup></h2>
                <?php if($exp_label != ''): ?>
                    <h5 class="exp_label"><?php echo wp_kses_post($exp_label); ?></h5>
                <?php endif; ?>
            </div>
            <?php
        endif;
        
    }
    
    protected function content_template() {}
}