<?php
if (($key = array_search(0, $product_category)) !== false) {
    unset($product_category[$key]);
}
if(empty($product_category)):
    $product_cat = array(
        'orderby'       => 'ID',
        'order'         => 'DESC', 
        'hide_empty'    => 1,
        'hierarchical'  => 1,
        'taxonomy'      => 'product_cat'
    );
    $categories = get_categories( $product_cat );
    foreach ($categories as $term) {
        $product_category[] = $term->term_id;
    }
endif;
$tabs_id        = uniqid('tw-tabs-');
if(!empty($product_category)): ?>
    <div class="prodocut_tab">
        <div class="row">
            <div class="col-lg-12">
                <ul class="nav filter_menu02 text-<?php echo esc_attr($text_align); ?>" id="<?php echo esc_attr($tabs_id); ?>" role="tablist">
                    <?php 
                        $i = 1;
                        foreach ($product_category as $key => $cat):
                            $term = get_term_by('id', $cat, 'product_cat');
                            ?>
                                <li class="nav-item">
                                    <a class="<?php if($i == 1){ echo 'active'; } ?>" id="<?php echo esc_attr($tabs_id . '-' . ($key + 1)); ?>-tab" data-toggle="tab" href="#<?php echo esc_attr($tabs_id . '-' . ($key + 1)); ?>" role="tab" aria-controls="<?php echo esc_attr($tabs_id . '-' . ($key + 1)); ?>" aria-selected="<?php if($i != 1){ echo 'false'; }else{ echo 'true';} ?>"><?php echo esc_html($term->name); ?></a>
                                </li>
                            <?php
                        $i++;
                        endforeach;
                    ?>
                </ul>
            </div>
        </div>
        <div class="tab-content woocommerce">
            <?php 
                $i = 1;
                foreach ($product_category as $key => $cat):
                    $desi   = (isset($des['tab_content'])) ? $des['tab_content'] : '';
                    ?>
                    <div class="tab-pane fade <?php if($i == 1){ echo ' active show '; } ?>" id="<?php echo esc_attr($tabs_id . '-' . ($key + 1)); ?>" role="tabpanel" aria-labelledby="<?php echo esc_attr($tabs_id . '-' . ($key + 1)); ?>-tab">
                        <?php 
                        $pro = array(
                            'post_type'         => array('product'),
                            'post_status'       => array('publish'),
                            'posts_per_page'    => $post_item
                        );
                        $pro['tax_query']   = array(
                            'relation'      => 'AND', 
                            array(
                                'taxonomy'  => 'product_cat', 
                                'field'     => 'id', 
                                'terms'     => array($cat),
                                'operator'  => 'IN'
                            ) 
                        );
                        $pro['orderby']           = 'date';
                        $pro['order']             = 'DESC';
                        
                        $pros = new WP_Query($pro);
                        if($pros->have_posts()):
                        ?>
                        <div class="row">
                            <?php
                                while($pros->have_posts()):
                                    $pros->the_post();
                                    $product = wc_get_product(get_the_ID());
                                    ?>
                                    <div class="col-xl-<?php echo (12 / $pr_column); ?> col-lg-4 col-md-6">
                                        <div <?php wc_product_class('bepro_product_wrapper', $product); ?>>
                                            <div class="productItem01">
                                                <div class="proThumb">
                                                    <img src="<?php echo bepro_post_thumbnail(get_the_ID(), 386, 400); ?>" alt="<?php echo get_the_title(); ?>">
                                                    <?php if ($show_flashlabels == 'yes'): ?>
                                                    <?php echo(function_exists('bepro_product_flash_notice_label') ? bepro_product_flash_notice_label() : '') ?>
                                                    <?php endif; ?>
                                                    <div class="piActionBtns">
                                                        <?php if (shortcode_exists('yith_wcwl_add_to_wishlist') && $shop_is_wishlist_btn == 'yes'): ?>
                                                            <?php echo do_shortcode('[yith_wcwl_add_to_wishlist]'); ?>
                                                        <?php endif; ?>
                                                        <?php function_exists('bepro_add_to_cart') ? bepro_add_to_cart() : '' ?>
                                                        <a class="quickview" href="<?php echo get_the_permalink() ?>"><i class="bpro-search-icon"></i></a>
                                                    </div>
                                                </div>
                                                <div class="product_content">
                                                    <div class="ratings">
                                                        <?php if (function_exists('woocommerce_template_loop_rating')): ?>
                                                            <?php echo woocommerce_template_loop_rating(); ?>
                                                        <?php endif; ?>
                                                    </div>
                                                    <h3><a href="<?php echo get_the_permalink() ?>"><?php echo get_the_title() ?></a></h3>
                                                    <div class="pi01Price">
                                                        <?php echo bepro_kses($product->get_price_html()); ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php
                                    $i++;
                                endwhile;
                            ?>
                        </div>
                        <?php endif; wp_reset_postdata(); ?>
                    </div>
                <?php 
                $i++;
                endforeach 
            ?>
        </div>
    </div>   
<?php endif;