<?php if ($is_topbar == 'yes'): ?>
    <!-- Header Topbar -->
    <section class="topbar02">
        <div class="container largeContainer">
            <div class="row">
                <div class="col-md-9">
                    <?php
                        if (!empty($info_list)):
                            foreach ($info_list as $ts):
                                $icons      = (isset($ts['icons']) ? $ts['icons'] : '');
                                $info_text  = (isset($ts['info_text']) ? $ts['info_text'] : '');
                                $info_url   = (isset($ts['info_url']['url']) ? $ts['info_url']['url'] : '');
                                if ($info_text != ''): ?>
                                    <p><?php if ($icons != ''): ?><i class="<?php echo esc_attr($icons); ?>"></i><?php endif; ?><?php if ($info_url != ''): ?><a href="<?php echo $info_url; ?>"><?php endif; ?><?php echo wp_kses_post($info_text); ?><?php if ($info_url != ''): ?></a><?php endif; ?></p>
                                <?php endif;
                            endforeach;
                        endif;
                    ?>
                </div>
                <div class="col-md-3">
                    <div class="topsocial">
                        <?php
                            if (!empty($s_list)):
                                foreach ($s_list as $sl):
                                    $s_icons = (isset($sl['s_icons']) ? $sl['s_icons'] : '');
                                    $s_url = (isset($sl['s_url']['url']) ? $sl['s_url']['url'] : '');
                                    $target = $sl['s_url']['is_external'] ? ' target="_blank"' : '';
                                    $nofollow = $sl['s_url']['nofollow'] ? ' rel="nofollow"' : '';

                                    if ($s_icons != ''):
                                        ?>
                                        <a <?php echo esc_attr($target . ' ' . $nofollow); ?> href="<?php echo esc_url($s_url); ?>"><i class="<?php echo esc_attr($s_icons); ?>"></i></a>
                                    <?php
                                    endif;
                                endforeach;
                            endif;
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Header Topbar -->
<?php endif; ?>
<?php if ($is_header == 'yes'): ?>
    <!-- Header Start -->
    <header class="header03 <?php if ($is_sticky == 'yes'): ?>isSticky<?php endif; ?>">
        <div class="container largeContainer">
            <div class="row">
                <div class="col-lg-12">
                    <div class="navbar01">
                        <div class="logo">
                            <?php if (!empty($logo)): ?>
                                <a href="<?php echo esc_url(home_url('/')); ?>">
                                    <img src="<?php echo esc_url($logo); ?>" alt="<?php echo get_bloginfo(); ?>"/>
                                </a>
                            <?php else: ?>
                                <a class="text" href="<?php echo esc_url(home_url('/')); ?>"><?php echo get_bloginfo('name'); ?></a>
                            <?php endif; ?>
                        </div>
                        <a href="javascript:void(0)" class="menu_btn"><i class="twi-bars2"></i></a>
                        <nav class="mainMenu">
                            <?php
                            if (has_nav_menu('primary-menu')) {
                                wp_nav_menu(array(
                                    'theme_location' => 'primary-menu',
                                    'container' => FALSE,
                                    'menu_class' => '',
                                    'menu_id' => '',
                                    'echo' => true
                                ));
                            } else {
                                if(is_user_logged_in()){
                                    echo '<ul>';
                                    echo '<li><a href="javascript:void(0)">' . esc_html__('No Menu', 'themewar') . '</a></li>';
                                    echo '</ul>';
                                }
                            }
                            ?>
                        </nav>
                        <?php if ($is_contact_btn == 'yes' && $btn_label != ''): ?>
                            <a class="berpo_btn with_icon02" <?php echo esc_attr($target.' '.$nofollow); ?> href="<?php echo esc_url($btn_url); ?>"><span class="btnwrap"><span class="bp-shape"></span><span class="bp-shape"></span><span class="bp-shape"></span><span class="bp-shape"></span><span class="bp-text"><?php echo esc_html($btn_label); ?></span></span><i class="twi-arrow-right"></i></a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <!-- Header End -->
<?php endif; ?>