<?php
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

/**
 * A Font Icon select box.
 *
 * @property array $icons   A list of font-icon classes. [ 'class-name' => 'nicename', ... ]
 *                          Default Font Awesome icons. @see Control_Icon::get_icons().
 * @property array $include list of classes to include form the $icons property
 * @property array $exclude list of classes to exclude form the $icons property
 *
 * @since 1.0.0
 */

class Tw_Icon_Controler extends Elementor\Base_Data_Control {

    public function get_type() {
        return 'icon';
    }

    /**
     * Get icons list
     *
     * @return array
     */
    public static function get_icons() {

        $icons = array(
            'bpro-long-right-arrow' => 'bpro-long-right-arrow',
            'bpro-long-left-arrow' => 'bpro-long-left-arrow',
            'bpro-coffee-cup-2' => 'bpro-coffee-cup-2',
            'bpro-idea-3' => 'bpro-idea-3',
            'bpro-smily' => 'bpro-smily',
            'bpro-d' => 'bpro-d',
            'bpro-active-arrow-left' => 'bpro-active-arrow-left',
            'bpro-active-arrow-right' => 'bpro-active-arrow-right',
            'bpro-Add-to-cart-icon' => 'bpro-Add-to-cart-icon',
            'bpro-analytics' => 'bpro-analytics',
            'bpro-analytics-2' => 'bpro-analytics-2',
            'bpro-analytics-3' => 'bpro-analytics-3',
            'bpro-arrow-board' => 'bpro-arrow-board',
            'bpro-bike-insurance' => 'bpro-bike-insurance',
            'bpro-browser' => 'bpro-browser',
            'bpro-browser-2' => 'bpro-browser-2',
            'bpro-browser-edit' => 'bpro-browser-edit',
            'bpro-car' => 'bpro-car',
            'bpro-car-insurance' => 'bpro-car-insurance',
            'bpro-chart' => 'bpro-chart',
            'bpro-check-list' => 'bpro-check-list',
            'bpro-clock' => 'bpro-clock',
            'bpro-coffee-cup' => 'bpro-coffee-cup',
            'bpro-consultation' => 'bpro-consultation',
            'bpro-Cube-layer' => 'bpro-Cube-layer',
            'bpro-dashboard' => 'bpro-dashboard',
            'bpro-database' => 'bpro-database',
            'bpro-decorating' => 'bpro-decorating',
            'bpro-development' => 'bpro-development',
            'bpro-diagram' => 'bpro-diagram',
            'bpro-email-1' => 'bpro-email-1',
            'bpro-home-insurance' => 'bpro-home-insurance',
            'bpro-idea' => 'bpro-idea',
            'bpro-idea-2' => 'bpro-idea-2',
            'bpro-insurance-card' => 'bpro-insurance-card',
            'bpro-interview' => 'bpro-interview',
            'bpro-keyword' => 'bpro-keyword',
            'bpro-laptop' => 'bpro-laptop',
            'bpro-location' => 'bpro-location',
            'bpro-mail' => 'bpro-mail',
            'bpro-mail-2' => 'bpro-mail-2',
            'bpro-mail-3' => 'bpro-mail-3',
            'bpro-marketing' => 'bpro-marketing',
            'bpro-megaphone' => 'bpro-megaphone',
            'bpro-motorbike' => 'bpro-motorbike',
            'bpro-partners-icons-12' => 'bpro-partners-icons-12',
            'bpro-phone-call-1' => 'bpro-phone-call-1',
            'bpro-phone-ringing' => 'bpro-phone-ringing',
            'bpro-pie-chart' => 'bpro-pie-chart',
            'bpro-pie-chart-2' => 'bpro-pie-chart-2',
            'bpro-play' => 'bpro-play',
            'bpro-presentation-2' => 'bpro-presentation-2',
            'bpro-puzzle' => 'bpro-puzzle',
            'bpro-puzzle-2' => 'bpro-puzzle-2',
            'bpro-question' => 'bpro-question',
            'bpro-recommended' => 'bpro-recommended',
            'bpro-Search' => 'bpro-Search',
            'bpro-search-icon' => 'bpro-search-icon',
            'bpro-search-impression' => 'bpro-search-impression',
            'bpro-sketch' => 'bpro-sketch',
            'bpro-skyline' => 'bpro-skyline',
            'bpro-upstairs' => 'bpro-upstairs',
            'bpro-users' => 'bpro-users',
            'bpro-viber' => 'bpro-viber',
            'bpro-waiter' => 'bpro-waiter',
            'bpro-winning' => 'bpro-winning',
            'bpro-Wishlist-icon' => 'bpro-Wishlist-icon',

            'icon-local_9' => 'icon-local_9',
            'icon-local_11' => 'icon-local_11',
            'icon-Wemseu01' => 'icon-Wemseu01',
            'icon-XjxC7N01' => 'icon-XjxC7N01',
            'icon-utBlv01' => 'icon-utBlv01',
            'icon-gGaLLZ01' => 'icon-gGaLLZ01',
            'icon-local_1-1' => 'icon-local_1-1',
            'icon-local_1' => 'icon-local_1',
            'icon-local_3-1' => 'icon-local_3-1',
            'icon-local_3' => 'icon-local_3',
            'icon-local_5' => 'icon-local_5',
            'icon-local_7-1' => 'icon-local_7-1',
            'icon-local_7' => 'icon-local_7',
            
            'twi-abacus' => 'twi-abacus',
            'twi-acorn' => 'twi-acorn',
            'twi-ad' => 'twi-ad',
            'twi-address-book' => 'twi-address-book',
            'twi-address-card' => 'twi-address-card',
            'twi-adjust' => 'twi-adjust',
            'twi-air-freshener' => 'twi-air-freshener',
            'twi-alarm-clock' => 'twi-alarm-clock',
            'twi-alicorn' => 'twi-alicorn',
            'twi-align-center' => 'twi-align-center',
            'twi-align-justify' => 'twi-align-justify',
            'twi-align-left' => 'twi-align-left',
            'twi-align-right' => 'twi-align-right',
            'twi-allergies' => 'twi-allergies',
            'twi-ambulance' => 'twi-ambulance',
            'twi-american-sign-language-interpreting' => 'twi-american-sign-language-interpreting',
            'twi-analytics' => 'twi-analytics',
            'twi-anchor' => 'twi-anchor',
            'twi-angel' => 'twi-angel',
            'twi-angle-double-down' => 'twi-angle-double-down',
            'twi-angle-double-left' => 'twi-angle-double-left',
            'twi-angle-double-right' => 'twi-angle-double-right',
            'twi-angle-double-up' => 'twi-angle-double-up',
            'twi-angle-down' => 'twi-angle-down',
            'twi-angle-left' => 'twi-angle-left',
            'twi-angle-right' => 'twi-angle-right',
            'twi-angle-up' => 'twi-angle-up',
            'twi-angry' => 'twi-angry',
            'twi-ankh' => 'twi-ankh',
            'twi-apple-alt' => 'twi-apple-alt',
            'twi-apple-crate' => 'twi-apple-crate',
            'twi-archive' => 'twi-archive',
            'twi-archway' => 'twi-archway',
            'twi-arrow-alt-circle-down' => 'twi-arrow-alt-circle-down',
            'twi-arrow-alt-circle-left' => 'twi-arrow-alt-circle-left',
            'twi-arrow-alt-circle-right' => 'twi-arrow-alt-circle-right',
            'twi-arrow-alt-circle-up' => 'twi-arrow-alt-circle-up',
            'twi-arrow-alt-down' => 'twi-arrow-alt-down',
            'twi-arrow-alt-from-bottom' => 'twi-arrow-alt-from-bottom',
            'twi-arrow-alt-from-left' => 'twi-arrow-alt-from-left',
            'twi-arrow-alt-from-right' => 'twi-arrow-alt-from-right',
            'twi-arrow-alt-from-top' => 'twi-arrow-alt-from-top',
            'twi-arrow-alt-left' => 'twi-arrow-alt-left',
            'twi-arrow-alt-right' => 'twi-arrow-alt-right',
            'twi-arrow-alt-square-down' => 'twi-arrow-alt-square-down',
            'twi-arrow-alt-square-left' => 'twi-arrow-alt-square-left',
            'twi-arrow-alt-square-right' => 'twi-arrow-alt-square-right',
            'twi-arrow-alt-square-up' => 'twi-arrow-alt-square-up',
            'twi-arrow-alt-to-bottom' => 'twi-arrow-alt-to-bottom',
            'twi-arrow-alt-to-left' => 'twi-arrow-alt-to-left',
            'twi-arrow-alt-to-right' => 'twi-arrow-alt-to-right',
            'twi-arrow-alt-to-top' => 'twi-arrow-alt-to-top',
            'twi-arrow-alt-up' => 'twi-arrow-alt-up',
            'twi-arrow-circle-down' => 'twi-arrow-circle-down',
            'twi-arrow-circle-left' => 'twi-arrow-circle-left',
            'twi-arrow-circle-right' => 'twi-arrow-circle-right',
            'twi-arrow-circle-up' => 'twi-arrow-circle-up',
            'twi-arrow-down' => 'twi-arrow-down',
            'twi-arrow-from-bottom' => 'twi-arrow-from-bottom',
            'twi-arrow-from-left' => 'twi-arrow-from-left',
            'twi-arrow-from-right' => 'twi-arrow-from-right',
            'twi-arrow-from-top' => 'twi-arrow-from-top',
            'twi-arrow-left' => 'twi-arrow-left',
            'twi-arrow-right' => 'twi-arrow-right',
            'twi-arrows' => 'twi-arrows',
            'twi-arrows-alt' => 'twi-arrows-alt',
            'twi-arrows-alt-h' => 'twi-arrows-alt-h',
            'twi-arrows-alt-v' => 'twi-arrows-alt-v',
            'twi-arrows-h' => 'twi-arrows-h',
            'twi-arrow-square-down' => 'twi-arrow-square-down',
            'twi-arrow-square-left' => 'twi-arrow-square-left',
            'twi-arrow-square-right' => 'twi-arrow-square-right',
            'twi-arrow-square-up' => 'twi-arrow-square-up',
            'twi-arrows-v' => 'twi-arrows-v',
            'twi-arrow-to-bottom' => 'twi-arrow-to-bottom',
            'twi-arrow-to-left' => 'twi-arrow-to-left',
            'twi-arrow-to-right' => 'twi-arrow-to-right',
            'twi-arrow-to-top' => 'twi-arrow-to-top',
            'twi-arrow-up' => 'twi-arrow-up',
            'twi-assistive-listening-systems' => 'twi-assistive-listening-systems',
            'twi-asterisk' => 'twi-asterisk',
            'twi-at' => 'twi-at',
            'twi-atlas' => 'twi-atlas',
            'twi-atom' => 'twi-atom',
            'twi-atom-alt' => 'twi-atom-alt',
            'twi-audio-description' => 'twi-audio-description',
            'twi-award' => 'twi-award',
            'twi-axe' => 'twi-axe',
            'twi-axe-battle' => 'twi-axe-battle',
            'twi-baby' => 'twi-baby',
            'twi-baby-carriage' => 'twi-baby-carriage',
            'twi-backpack' => 'twi-backpack',
            'twi-backspace' => 'twi-backspace',
            'twi-backward' => 'twi-backward',
            'twi-bacon' => 'twi-bacon',
            'twi-badge' => 'twi-badge',
            'twi-badge-check' => 'twi-badge-check',
            'twi-badge-dollar' => 'twi-badge-dollar',
            'twi-badge-percent' => 'twi-badge-percent',
            'twi-badger-honey' => 'twi-badger-honey',
            'twi-balance-scale' => 'twi-balance-scale',
            'twi-balance-scale-left' => 'twi-balance-scale-left',
            'twi-balance-scale-right' => 'twi-balance-scale-right',
            'twi-ballot' => 'twi-ballot',
            'twi-ballot-check' => 'twi-ballot-check',
            'twi-ball-pile' => 'twi-ball-pile',
            'twi-ban' => 'twi-ban',
            'twi-band-aid' => 'twi-band-aid',
            'twi-barcode' => 'twi-barcode',
            'twi-barcode-alt' => 'twi-barcode-alt',
            'twi-barcode-read' => 'twi-barcode-read',
            'twi-barcode-scan' => 'twi-barcode-scan',
            'twi-bars' => 'twi-bars',
            'twi-baseball' => 'twi-baseball',
            'twi-baseball-ball' => 'twi-baseball-ball',
            'twi-basketball-ball' => 'twi-basketball-ball',
            'twi-basketball-hoop' => 'twi-basketball-hoop',
            'twi-bat' => 'twi-bat',
            'twi-bath' => 'twi-bath',
            'twi-battery-bolt' => 'twi-battery-bolt',
            'twi-battery-empty' => 'twi-battery-empty',
            'twi-battery-full' => 'twi-battery-full',
            'twi-battery-half' => 'twi-battery-half',
            'twi-battery-quarter' => 'twi-battery-quarter',
            'twi-battery-slash' => 'twi-battery-slash',
            'twi-battery-three-quarters' => 'twi-battery-three-quarters',
            'twi-bed' => 'twi-bed',
            'twi-beer' => 'twi-beer',
            'twi-bell' => 'twi-bell',
            'twi-bells' => 'twi-bells',
            'twi-bell-school' => 'twi-bell-school',
            'twi-bell-school-slash' => 'twi-bell-school-slash',
            'twi-bell-slash' => 'twi-bell-slash',
            'twi-bezier-curve' => 'twi-bezier-curve',
            'twi-bible' => 'twi-bible',
            'twi-bicycle' => 'twi-bicycle',
            'twi-binoculars' => 'twi-binoculars',
            'twi-biohazard' => 'twi-biohazard',
            'twi-birthday-cake' => 'twi-birthday-cake',
            'twi-blanket' => 'twi-blanket',
            'twi-blender' => 'twi-blender',
            'twi-blender-phone' => 'twi-blender-phone',
            'twi-blind' => 'twi-blind',
            'twi-blog' => 'twi-blog',
            'twi-bold' => 'twi-bold',
            'twi-bolt' => 'twi-bolt',
            'twi-bomb' => 'twi-bomb',
            'twi-bone' => 'twi-bone',
            'twi-bone-break' => 'twi-bone-break',
            'twi-bong' => 'twi-bong',
            'twi-book' => 'twi-book',
            'twi-book-alt' => 'twi-book-alt',
            'twi-book-dead' => 'twi-book-dead',
            'twi-book-heart' => 'twi-book-heart',
            'twi-bookmark' => 'twi-bookmark',
            'twi-book-medical' => 'twi-book-medical',
            'twi-book-open' => 'twi-book-open',
            'twi-book-reader' => 'twi-book-reader',
            'twi-books' => 'twi-books',
            'twi-books-medical' => 'twi-books-medical',
            'twi-book-spells' => 'twi-book-spells',
            'twi-book-user' => 'twi-book-user',
            'twi-boot' => 'twi-boot',
            'twi-booth-curtain' => 'twi-booth-curtain',
            'twi-bow-arrow' => 'twi-bow-arrow',
            'twi-bowling-ball' => 'twi-bowling-ball',
            'twi-bowling-pins' => 'twi-bowling-pins',
            'twi-box' => 'twi-box',
            'twi-box-alt' => 'twi-box-alt',
            'twi-box-ballot' => 'twi-box-ballot',
            'twi-box-check' => 'twi-box-check',
            'twi-boxes' => 'twi-boxes',
            'twi-boxes-alt' => 'twi-boxes-alt',
            'twi-box-fragile' => 'twi-box-fragile',
            'twi-box-full' => 'twi-box-full',
            'twi-box-heart' => 'twi-box-heart',
            'twi-boxing-glove' => 'twi-boxing-glove',
            'twi-box-open' => 'twi-box-open',
            'twi-box-up' => 'twi-box-up',
            'twi-box-usd' => 'twi-box-usd',
            'twi-brackets' => 'twi-brackets',
            'twi-brackets-curly' => 'twi-brackets-curly',
            'twi-braille' => 'twi-braille',
            'twi-brain' => 'twi-brain',
            'twi-bread-loaf' => 'twi-bread-loaf',
            'twi-bread-slice' => 'twi-bread-slice',
            'twi-briefcase' => 'twi-briefcase',
            'twi-briefcase-medical' => 'twi-briefcase-medical',
            'twi-broadcast-tower' => 'twi-broadcast-tower',
            'twi-broom' => 'twi-broom',
            'twi-browser' => 'twi-browser',
            'twi-brush' => 'twi-brush',
            'twi-bug' => 'twi-bug',
            'twi-building' => 'twi-building',
            'twi-bullhorn' => 'twi-bullhorn',
            'twi-bullseye' => 'twi-bullseye',
            'twi-bullseye-arrow' => 'twi-bullseye-arrow',
            'twi-bullseye-pointer' => 'twi-bullseye-pointer',
            'twi-burn' => 'twi-burn',
            'twi-burrito' => 'twi-burrito',
            'twi-bus' => 'twi-bus',
            'twi-bus-alt' => 'twi-bus-alt',
            'twi-business-time' => 'twi-business-time',
            'twi-bus-school' => 'twi-bus-school',
            'twi-cabinet-filing' => 'twi-cabinet-filing',
            'twi-calculator' => 'twi-calculator',
            'twi-calculator-alt' => 'twi-calculator-alt',
            'twi-calendar' => 'twi-calendar',
            'twi-calendar-alt' => 'twi-calendar-alt',
            'twi-calendar-check' => 'twi-calendar-check',
            'twi-calendar-day' => 'twi-calendar-day',
            'twi-calendar-edit' => 'twi-calendar-edit',
            'twi-calendar-exclamation' => 'twi-calendar-exclamation',
            'twi-calendar-minus' => 'twi-calendar-minus',
            'twi-calendar-plus' => 'twi-calendar-plus',
            'twi-calendar-star' => 'twi-calendar-star',
            'twi-calendar-times' => 'twi-calendar-times',
            'twi-calendar-week' => 'twi-calendar-week',
            'twi-camera' => 'twi-camera',
            'twi-camera-alt' => 'twi-camera-alt',
            'twi-camera-retro' => 'twi-camera-retro',
            'twi-campfire' => 'twi-campfire',
            'twi-campground' => 'twi-campground',
            'twi-candle-holder' => 'twi-candle-holder',
            'twi-candy-cane' => 'twi-candy-cane',
            'twi-candy-corn' => 'twi-candy-corn',
            'twi-cannabis' => 'twi-cannabis',
            'twi-capsules' => 'twi-capsules',
            'twi-car' => 'twi-car',
            'twi-car-alt' => 'twi-car-alt',
            'twi-car-battery' => 'twi-car-battery',
            'twi-car-bump' => 'twi-car-bump',
            'twi-car-crash' => 'twi-car-crash',
            'twi-caret-circle-down' => 'twi-caret-circle-down',
            'twi-caret-circle-left' => 'twi-caret-circle-left',
            'twi-caret-circle-right' => 'twi-caret-circle-right',
            'twi-caret-circle-up' => 'twi-caret-circle-up',
            'twi-caret-down' => 'twi-caret-down',
            'twi-caret-left' => 'twi-caret-left',
            'twi-caret-right' => 'twi-caret-right',
            'twi-caret-square-down' => 'twi-caret-square-down',
            'twi-caret-square-left' => 'twi-caret-square-left',
            'twi-caret-square-right' => 'twi-caret-square-right',
            'twi-caret-square-up' => 'twi-caret-square-up',
            'twi-caret-up' => 'twi-caret-up',
            'twi-car-garage' => 'twi-car-garage',
            'twi-car-mechanic' => 'twi-car-mechanic',
            'twi-carrot' => 'twi-carrot',
            'twi-car-side' => 'twi-car-side',
            'twi-cart-arrow-down' => 'twi-cart-arrow-down',
            'twi-car-tilt' => 'twi-car-tilt',
            'twi-cart-plus' => 'twi-cart-plus',
            'twi-car-wash' => 'twi-car-wash',
            'twi-cash-register' => 'twi-cash-register',
            'twi-cat' => 'twi-cat',
            'twi-cauldron' => 'twi-cauldron',
            'twi-certificate' => 'twi-certificate',
            'twi-chair' => 'twi-chair',
            'twi-chair-office' => 'twi-chair-office',
            'twi-chalkboard' => 'twi-chalkboard',
            'twi-chalkboard-teacher' => 'twi-chalkboard-teacher',
            'twi-charging-station' => 'twi-charging-station',
            'twi-chart-area' => 'twi-chart-area',
            'twi-chart-bar' => 'twi-chart-bar',
            'twi-chart-line' => 'twi-chart-line',
            'twi-chart-line-down' => 'twi-chart-line-down',
            'twi-chart-network' => 'twi-chart-network',
            'twi-chart-pie' => 'twi-chart-pie',
            'twi-chart-pie-alt' => 'twi-chart-pie-alt',
            'twi-chart-scatter' => 'twi-chart-scatter',
            'twi-check' => 'twi-check',
            'twi-check-circle' => 'twi-check-circle',
            'twi-check-double' => 'twi-check-double',
            'twi-check-square' => 'twi-check-square',
            'twi-cheese' => 'twi-cheese',
            'twi-cheeseburger' => 'twi-cheeseburger',
            'twi-cheese-swiss' => 'twi-cheese-swiss',
            'twi-chess' => 'twi-chess',
            'twi-chess-bishop' => 'twi-chess-bishop',
            'twi-chess-bishop-alt' => 'twi-chess-bishop-alt',
            'twi-chess-board' => 'twi-chess-board',
            'twi-chess-clock' => 'twi-chess-clock',
            'twi-chess-clock-alt' => 'twi-chess-clock-alt',
            'twi-chess-king' => 'twi-chess-king',
            'twi-chess-king-alt' => 'twi-chess-king-alt',
            'twi-chess-knight' => 'twi-chess-knight',
            'twi-chess-knight-alt' => 'twi-chess-knight-alt',
            'twi-chess-pawn' => 'twi-chess-pawn',
            'twi-chess-pawn-alt' => 'twi-chess-pawn-alt',
            'twi-chess-queen' => 'twi-chess-queen',
            'twi-chess-queen-alt' => 'twi-chess-queen-alt',
            'twi-chess-rook' => 'twi-chess-rook',
            'twi-chess-rook-alt' => 'twi-chess-rook-alt',
            'twi-chevron-circle-down' => 'twi-chevron-circle-down',
            'twi-chevron-circle-left' => 'twi-chevron-circle-left',
            'twi-chevron-circle-right' => 'twi-chevron-circle-right',
            'twi-chevron-circle-up' => 'twi-chevron-circle-up',
            'twi-chevron-double-down' => 'twi-chevron-double-down',
            'twi-chevron-double-left' => 'twi-chevron-double-left',
            'twi-chevron-double-right' => 'twi-chevron-double-right',
            'twi-chevron-double-up' => 'twi-chevron-double-up',
            'twi-chevron-down' => 'twi-chevron-down',
            'twi-chevron-left' => 'twi-chevron-left',
            'twi-chevron-right' => 'twi-chevron-right',
            'twi-chevron-square-down' => 'twi-chevron-square-down',
            'twi-chevron-square-left' => 'twi-chevron-square-left',
            'twi-chevron-square-right' => 'twi-chevron-square-right',
            'twi-chevron-square-up' => 'twi-chevron-square-up',
            'twi-chevron-up' => 'twi-chevron-up',
            'twi-child' => 'twi-child',
            'twi-chimney' => 'twi-chimney',
            'twi-church' => 'twi-church',
            'twi-circle' => 'twi-circle',
            'twi-circle-notch' => 'twi-circle-notch',
            'twi-city' => 'twi-city',
            'twi-claw-marks' => 'twi-claw-marks',
            'twi-clinic-medical' => 'twi-clinic-medical',
            'twi-clipboard' => 'twi-clipboard',
            'twi-clipboard-check' => 'twi-clipboard-check',
            'twi-clipboard-list' => 'twi-clipboard-list',
            'twi-clipboard-list-check' => 'twi-clipboard-list-check',
            'twi-clipboard-prescription' => 'twi-clipboard-prescription',
            'twi-clipboard-user' => 'twi-clipboard-user',
            'twi-clock' => 'twi-clock',
            'twi-clone' => 'twi-clone',
            'twi-closed-captioning' => 'twi-closed-captioning',
            'twi-cloud' => 'twi-cloud',
            'twi-cloud-download' => 'twi-cloud-download',
            'twi-cloud-download-alt' => 'twi-cloud-download-alt',
            'twi-cloud-drizzle' => 'twi-cloud-drizzle',
            'twi-cloud-hail' => 'twi-cloud-hail',
            'twi-cloud-hail-mixed' => 'twi-cloud-hail-mixed',
            'twi-cloud-meatball' => 'twi-cloud-meatball',
            'twi-cloud-moon' => 'twi-cloud-moon',
            'twi-cloud-moon-rain' => 'twi-cloud-moon-rain',
            'twi-cloud-rain' => 'twi-cloud-rain',
            'twi-cloud-rainbow' => 'twi-cloud-rainbow',
            'twi-clouds' => 'twi-clouds',
            'twi-cloud-showers' => 'twi-cloud-showers',
            'twi-cloud-showers-heavy' => 'twi-cloud-showers-heavy',
            'twi-cloud-sleet' => 'twi-cloud-sleet',
            'twi-clouds-moon' => 'twi-clouds-moon',
            'twi-cloud-snow' => 'twi-cloud-snow',
            'twi-clouds-sun' => 'twi-clouds-sun',
            'twi-cloud-sun' => 'twi-cloud-sun',
            'twi-cloud-sun-rain' => 'twi-cloud-sun-rain',
            'twi-cloud-upload' => 'twi-cloud-upload',
            'twi-cloud-upload-alt' => 'twi-cloud-upload-alt',
            'twi-club' => 'twi-club',
            'twi-cocktail' => 'twi-cocktail',
            'twi-code' => 'twi-code',
            'twi-code-branch' => 'twi-code-branch',
            'twi-code-commit' => 'twi-code-commit',
            'twi-code-merge' => 'twi-code-merge',
            'twi-coffee' => 'twi-coffee',
            'twi-coffee-togo' => 'twi-coffee-togo',
            'twi-coffin' => 'twi-coffin',
            'twi-cog' => 'twi-cog',
            'twi-cogs' => 'twi-cogs',
            'twi-coins' => 'twi-coins',
            'twi-columns' => 'twi-columns',
            'twi-comment' => 'twi-comment',
            'twi-comment-alt' => 'twi-comment-alt',
            'twi-comment-alt-check' => 'twi-comment-alt-check',
            'twi-comment-alt-dollar' => 'twi-comment-alt-dollar',
            'twi-comment-alt-dots' => 'twi-comment-alt-dots',
            'twi-comment-alt-edit' => 'twi-comment-alt-edit',
            'twi-comment-alt-exclamation' => 'twi-comment-alt-exclamation',
            'twi-comment-alt-lines' => 'twi-comment-alt-lines',
            'twi-comment-alt-medical' => 'twi-comment-alt-medical',
            'twi-comment-alt-minus' => 'twi-comment-alt-minus',
            'twi-comment-alt-plus' => 'twi-comment-alt-plus',
            'twi-comment-alt-slash' => 'twi-comment-alt-slash',
            'twi-comment-alt-smile' => 'twi-comment-alt-smile',
            'twi-comment-alt-times' => 'twi-comment-alt-times',
            'twi-comment-check' => 'twi-comment-check',
            'twi-comment-dollar' => 'twi-comment-dollar',
            'twi-comment-dots' => 'twi-comment-dots',
            'twi-comment-edit' => 'twi-comment-edit',
            'twi-comment-exclamation' => 'twi-comment-exclamation',
            'twi-comment-lines' => 'twi-comment-lines',
            'twi-comment-medical' => 'twi-comment-medical',
            'twi-comment-minus' => 'twi-comment-minus',
            'twi-comment-plus' => 'twi-comment-plus',
            'twi-comments' => 'twi-comments',
            'twi-comments-alt' => 'twi-comments-alt',
            'twi-comments-alt-dollar' => 'twi-comments-alt-dollar',
            'twi-comments-dollar' => 'twi-comments-dollar',
            'twi-comment-slash' => 'twi-comment-slash',
            'twi-comment-smile' => 'twi-comment-smile',
            'twi-comment-times' => 'twi-comment-times',
            'twi-compact-disc' => 'twi-compact-disc',
            'twi-compass' => 'twi-compass',
            'twi-compass-slash' => 'twi-compass-slash',
            'twi-compress' => 'twi-compress',
            'twi-compress-alt' => 'twi-compress-alt',
            'twi-compress-arrows-alt' => 'twi-compress-arrows-alt',
            'twi-compress-wide' => 'twi-compress-wide',
            'twi-concierge-bell' => 'twi-concierge-bell',
            'twi-container-storage' => 'twi-container-storage',
            'twi-conveyor-belt' => 'twi-conveyor-belt',
            'twi-conveyor-belt-alt' => 'twi-conveyor-belt-alt',
            'twi-cookie' => 'twi-cookie',
            'twi-cookie-bite' => 'twi-cookie-bite',
            'twi-copy' => 'twi-copy',
            'twi-copyright' => 'twi-copyright',
            'twi-corn' => 'twi-corn',
            'twi-couch' => 'twi-couch',
            'twi-cow' => 'twi-cow',
            'twi-credit-card' => 'twi-credit-card',
            'twi-credit-card-blank' => 'twi-credit-card-blank',
            'twi-credit-card-front' => 'twi-credit-card-front',
            'twi-cricket' => 'twi-cricket',
            'twi-croissant' => 'twi-croissant',
            'twi-crop' => 'twi-crop',
            'twi-crop-alt' => 'twi-crop-alt',
            'twi-cross' => 'twi-cross',
            'twi-crosshairs' => 'twi-crosshairs',
            'twi-crow' => 'twi-crow',
            'twi-crown' => 'twi-crown',
            'twi-crutch' => 'twi-crutch',
            'twi-crutches' => 'twi-crutches',
            'twi-cube' => 'twi-cube',
            'twi-cubes' => 'twi-cubes',
            'twi-curling' => 'twi-curling',
            'twi-cut' => 'twi-cut',
            'twi-dagger' => 'twi-dagger',
            'twi-database' => 'twi-database',
            'twi-deaf' => 'twi-deaf',
            'twi-debug' => 'twi-debug',
            'twi-deer' => 'twi-deer',
            'twi-deer-rudolph' => 'twi-deer-rudolph',
            'twi-democrat' => 'twi-democrat',
            'twi-desktop' => 'twi-desktop',
            'twi-desktop-alt' => 'twi-desktop-alt',
            'twi-dewpoint' => 'twi-dewpoint',
            'twi-dharmachakra' => 'twi-dharmachakra',
            'twi-diagnoses' => 'twi-diagnoses',
            'twi-diamond' => 'twi-diamond',
            'twi-dice' => 'twi-dice',
            'twi-dice-d4' => 'twi-dice-d4',
            'twi-dice-d6' => 'twi-dice-d6',
            'twi-dice-d8' => 'twi-dice-d8',
            'twi-dice-d10' => 'twi-dice-d10',
            'twi-dice-d12' => 'twi-dice-d12',
            'twi-dice-d20' => 'twi-dice-d20',
            'twi-dice-five' => 'twi-dice-five',
            'twi-dice-four' => 'twi-dice-four',
            'twi-dice-one' => 'twi-dice-one',
            'twi-dice-six' => 'twi-dice-six',
            'twi-dice-three' => 'twi-dice-three',
            'twi-dice-two' => 'twi-dice-two',
            'twi-digital-tachograph' => 'twi-digital-tachograph',
            'twi-diploma' => 'twi-diploma',
            'twi-directions' => 'twi-directions',
            'twi-disease' => 'twi-disease',
            'twi-divide' => 'twi-divide',
            'twi-dizzy' => 'twi-dizzy',
            'twi-dna' => 'twi-dna',
            'twi-dog' => 'twi-dog',
            'twi-dog-leashed' => 'twi-dog-leashed',
            'twi-dollar-sign' => 'twi-dollar-sign',
            'twi-dolly' => 'twi-dolly',
            'twi-dolly-empty' => 'twi-dolly-empty',
            'twi-dolly-flatbed' => 'twi-dolly-flatbed',
            'twi-dolly-flatbed-alt' => 'twi-dolly-flatbed-alt',
            'twi-dolly-flatbed-empty' => 'twi-dolly-flatbed-empty',
            'twi-donate' => 'twi-donate',
            'twi-do-not-enter' => 'twi-do-not-enter',
            'twi-door-closed' => 'twi-door-closed',
            'twi-door-open' => 'twi-door-open',
            'twi-dot-circle' => 'twi-dot-circle',
            'twi-dove' => 'twi-dove',
            'twi-download' => 'twi-download',
            'twi-drafting-compass' => 'twi-drafting-compass',
            'twi-dragon' => 'twi-dragon',
            'twi-draw-circle' => 'twi-draw-circle',
            'twi-draw-polygon' => 'twi-draw-polygon',
            'twi-draw-square' => 'twi-draw-square',
            'twi-dreidel' => 'twi-dreidel',
            'twi-drum' => 'twi-drum',
            'twi-drum-steelpan' => 'twi-drum-steelpan',
            'twi-drumstick' => 'twi-drumstick',
            'twi-drumstick-bite' => 'twi-drumstick-bite',
            'twi-duck' => 'twi-duck',
            'twi-dumbbell' => 'twi-dumbbell',
            'twi-dumpster' => 'twi-dumpster',
            'twi-dumpster-fire' => 'twi-dumpster-fire',
            'twi-dungeon' => 'twi-dungeon',
            'twi-ear' => 'twi-ear',
            'twi-ear-muffs' => 'twi-ear-muffs',
            'twi-eclipse' => 'twi-eclipse',
            'twi-eclipse-alt' => 'twi-eclipse-alt',
            'twi-edit' => 'twi-edit',
            'twi-egg' => 'twi-egg',
            'twi-egg-fried' => 'twi-egg-fried',
            'twi-eject' => 'twi-eject',
            'twi-elephant' => 'twi-elephant',
            'twi-ellipsis-h' => 'twi-ellipsis-h',
            'twi-ellipsis-h-alt' => 'twi-ellipsis-h-alt',
            'twi-ellipsis-v' => 'twi-ellipsis-v',
            'twi-ellipsis-v-alt' => 'twi-ellipsis-v-alt',
            'twi-empty-set' => 'twi-empty-set',
            'twi-engine-warning' => 'twi-engine-warning',
            'twi-envelope' => 'twi-envelope',
            'twi-envelope-open' => 'twi-envelope-open',
            'twi-envelope-open-dollar' => 'twi-envelope-open-dollar',
            'twi-envelope-open-text' => 'twi-envelope-open-text',
            'twi-envelope-square' => 'twi-envelope-square',
            'twi-equals' => 'twi-equals',
            'twi-eraser' => 'twi-eraser',
            'twi-ethernet' => 'twi-ethernet',
            'twi-euro-sign' => 'twi-euro-sign',
            'twi-exchange' => 'twi-exchange',
            'twi-exchange-alt' => 'twi-exchange-alt',
            'twi-exclamation' => 'twi-exclamation',
            'twi-exclamation-circle' => 'twi-exclamation-circle',
            'twi-exclamation-square' => 'twi-exclamation-square',
            'twi-exclamation-triangle' => 'twi-exclamation-triangle',
            'twi-expand' => 'twi-expand',
            'twi-expand-alt' => 'twi-expand-alt',
            'twi-expand-arrows' => 'twi-expand-arrows',
            'twi-expand-arrows-alt' => 'twi-expand-arrows-alt',
            'twi-expand-wide' => 'twi-expand-wide',
            'twi-external-link' => 'twi-external-link',
            'twi-external-link-alt' => 'twi-external-link-alt',
            'twi-external-link-square' => 'twi-external-link-square',
            'twi-external-link-square-alt' => 'twi-external-link-square-alt',
            'twi-eye' => 'twi-eye',
            'twi-eye-dropper' => 'twi-eye-dropper',
            'twi-eye-evil' => 'twi-eye-evil',
            'twi-eye-slash' => 'twi-eye-slash',
            'twi-fast-backward' => 'twi-fast-backward',
            'twi-fast-forward' => 'twi-fast-forward',
            'twi-fax' => 'twi-fax',
            'twi-feather' => 'twi-feather',
            'twi-feather-alt' => 'twi-feather-alt',
            'twi-female' => 'twi-female',
            'twi-field-hockey' => 'twi-field-hockey',
            'twi-fighter-jet' => 'twi-fighter-jet',
            'twi-file' => 'twi-file',
            'twi-file-alt' => 'twi-file-alt',
            'twi-file-archive' => 'twi-file-archive',
            'twi-file-audio' => 'twi-file-audio',
            'twi-file-certificate' => 'twi-file-certificate',
            'twi-file-chart-line' => 'twi-file-chart-line',
            'twi-file-chart-pie' => 'twi-file-chart-pie',
            'twi-file-check' => 'twi-file-check',
            'twi-file-code' => 'twi-file-code',
            'twi-file-contract' => 'twi-file-contract',
            'twi-file-csv' => 'twi-file-csv',
            'twi-file-download' => 'twi-file-download',
            'twi-file-edit' => 'twi-file-edit',
            'twi-file-excel' => 'twi-file-excel',
            'twi-file-exclamation' => 'twi-file-exclamation',
            'twi-file-export' => 'twi-file-export',
            'twi-file-image' => 'twi-file-image',
            'twi-file-import' => 'twi-file-import',
            'twi-file-invoice' => 'twi-file-invoice',
            'twi-file-invoice-dollar' => 'twi-file-invoice-dollar',
            'twi-file-medical' => 'twi-file-medical',
            'twi-file-medical-alt' => 'twi-file-medical-alt',
            'twi-file-minus' => 'twi-file-minus',
            'twi-file-pdf' => 'twi-file-pdf',
            'twi-file-plus' => 'twi-file-plus',
            'twi-file-powerpoint' => 'twi-file-powerpoint',
            'twi-file-prescription' => 'twi-file-prescription',
            'twi-file-signature' => 'twi-file-signature',
            'twi-files-medical' => 'twi-files-medical',
            'twi-file-spreadsheet' => 'twi-file-spreadsheet',
            'twi-file-times' => 'twi-file-times',
            'twi-file-upload' => 'twi-file-upload',
            'twi-file-user' => 'twi-file-user',
            'twi-file-video' => 'twi-file-video',
            'twi-file-word' => 'twi-file-word',
            'twi-fill' => 'twi-fill',
            'twi-fill-drip' => 'twi-fill-drip',
            'twi-film' => 'twi-film',
            'twi-film-alt' => 'twi-film-alt',
            'twi-filter' => 'twi-filter',
            'twi-fingerprint' => 'twi-fingerprint',
            'twi-fire' => 'twi-fire',
            'twi-fire-alt' => 'twi-fire-alt',
            'twi-fire-extinguisher' => 'twi-fire-extinguisher',
            'twi-fireplace' => 'twi-fireplace',
            'twi-fire-smoke' => 'twi-fire-smoke',
            'twi-first-aid' => 'twi-first-aid',
            'twi-fish' => 'twi-fish',
            'twi-fish-cooked' => 'twi-fish-cooked',
            'twi-fist-raised' => 'twi-fist-raised',
            'twi-flag' => 'twi-flag',
            'twi-flag-alt' => 'twi-flag-alt',
            'twi-flag-checkered' => 'twi-flag-checkered',
            'twi-flag-usa' => 'twi-flag-usa',
            'twi-flame' => 'twi-flame',
            'twi-flask' => 'twi-flask',
            'twi-flask-poison' => 'twi-flask-poison',
            'twi-flask-potion' => 'twi-flask-potion',
            'twi-flower' => 'twi-flower',
            'twi-flower-daffodil' => 'twi-flower-daffodil',
            'twi-flower-tulip' => 'twi-flower-tulip',
            'twi-flushed' => 'twi-flushed',
            'twi-fog' => 'twi-fog',
            'twi-folder' => 'twi-folder',
            'twi-folder-minus' => 'twi-folder-minus',
            'twi-folder-open' => 'twi-folder-open',
            'twi-folder-plus' => 'twi-folder-plus',
            'twi-folders' => 'twi-folders',
            'twi-folder-times' => 'twi-folder-times',
            'twi-folder-tree' => 'twi-folder-tree',
            'twi-font' => 'twi-font',
            'twi-font-awesome-logo-full' => 'twi-font-awesome-logo-full',
            'twi-football-ball' => 'twi-football-ball',
            'twi-football-helmet' => 'twi-football-helmet',
            'twi-forklift' => 'twi-forklift',
            'twi-forward' => 'twi-forward',
            'twi-fragile' => 'twi-fragile',
            'twi-french-fries' => 'twi-french-fries',
            'twi-frog' => 'twi-frog',
            'twi-frosty-head' => 'twi-frosty-head',
            'twi-frown' => 'twi-frown',
            'twi-frown-open' => 'twi-frown-open',
            'twi-function' => 'twi-function',
            'twi-funnel-dollar' => 'twi-funnel-dollar',
            'twi-futbol' => 'twi-futbol',
            'twi-gamepad' => 'twi-gamepad',
            'twi-gas-pump' => 'twi-gas-pump',
            'twi-gas-pump-slash' => 'twi-gas-pump-slash',
            'twi-gavel' => 'twi-gavel',
            'twi-gem' => 'twi-gem',
            'twi-genderless' => 'twi-genderless',
            'twi-ghost' => 'twi-ghost',
            'twi-gift' => 'twi-gift',
            'twi-gift-card' => 'twi-gift-card',
            'twi-gifts' => 'twi-gifts',
            'twi-gingerbread-man' => 'twi-gingerbread-man',
            'twi-glass' => 'twi-glass',
            'twi-glass-champagne' => 'twi-glass-champagne',
            'twi-glass-cheers' => 'twi-glass-cheers',
            'twi-glasses' => 'twi-glasses',
            'twi-glasses-alt' => 'twi-glasses-alt',
            'twi-glass-martini' => 'twi-glass-martini',
            'twi-glass-martini-alt' => 'twi-glass-martini-alt',
            'twi-glass-whiskey' => 'twi-glass-whiskey',
            'twi-glass-whiskey-rocks' => 'twi-glass-whiskey-rocks',
            'twi-globe' => 'twi-globe',
            'twi-globe-africa' => 'twi-globe-africa',
            'twi-globe-americas' => 'twi-globe-americas',
            'twi-globe-asia' => 'twi-globe-asia',
            'twi-globe-europe' => 'twi-globe-europe',
            'twi-globe-snow' => 'twi-globe-snow',
            'twi-globe-stand' => 'twi-globe-stand',
            'twi-golf-ball' => 'twi-golf-ball',
            'twi-golf-club' => 'twi-golf-club',
            'twi-gopuram' => 'twi-gopuram',
            'twi-graduation-cap' => 'twi-graduation-cap',
            'twi-greater-than' => 'twi-greater-than',
            'twi-greater-than-equal' => 'twi-greater-than-equal',
            'twi-grimace' => 'twi-grimace',
            'twi-grin' => 'twi-grin',
            'twi-grin-alt' => 'twi-grin-alt',
            'twi-grin-beam' => 'twi-grin-beam',
            'twi-grin-beam-sweat' => 'twi-grin-beam-sweat',
            'twi-grin-hearts' => 'twi-grin-hearts',
            'twi-grin-squint' => 'twi-grin-squint',
            'twi-grin-squint-tears' => 'twi-grin-squint-tears',
            'twi-grin-stars' => 'twi-grin-stars',
            'twi-grin-tears' => 'twi-grin-tears',
            'twi-grin-tongue' => 'twi-grin-tongue',
            'twi-grin-tongue-squint' => 'twi-grin-tongue-squint',
            'twi-grin-tongue-wink' => 'twi-grin-tongue-wink',
            'twi-grin-wink' => 'twi-grin-wink',
            'twi-grip-horizontal' => 'twi-grip-horizontal',
            'twi-grip-lines' => 'twi-grip-lines',
            'twi-grip-lines-vertical' => 'twi-grip-lines-vertical',
            'twi-grip-vertical' => 'twi-grip-vertical',
            'twi-guitar' => 'twi-guitar',
            'twi-h1' => 'twi-h1',
            'twi-h2' => 'twi-h2',
            'twi-h3' => 'twi-h3',
            'twi-hamburger' => 'twi-hamburger',
            'twi-hammer' => 'twi-hammer',
            'twi-hammer-war' => 'twi-hammer-war',
            'twi-hamsa' => 'twi-hamsa',
            'twi-hand-heart' => 'twi-hand-heart',
            'twi-hand-holding' => 'twi-hand-holding',
            'twi-hand-holding-box' => 'twi-hand-holding-box',
            'twi-hand-holding-heart' => 'twi-hand-holding-heart',
            'twi-hand-holding-magic' => 'twi-hand-holding-magic',
            'twi-hand-holding-seedling' => 'twi-hand-holding-seedling',
            'twi-hand-holding-usd' => 'twi-hand-holding-usd',
            'twi-hand-holding-water' => 'twi-hand-holding-water',
            'twi-hand-lizard' => 'twi-hand-lizard',
            'twi-hand-middle-finger' => 'twi-hand-middle-finger',
            'twi-hand-paper' => 'twi-hand-paper',
            'twi-hand-peace' => 'twi-hand-peace',
            'twi-hand-point-down' => 'twi-hand-point-down',
            'twi-hand-pointer' => 'twi-hand-pointer',
            'twi-hand-point-left' => 'twi-hand-point-left',
            'twi-hand-point-right' => 'twi-hand-point-right',
            'twi-hand-point-up' => 'twi-hand-point-up',
            'twi-hand-receiving' => 'twi-hand-receiving',
            'twi-hand-rock' => 'twi-hand-rock',
            'twi-hands' => 'twi-hands',
            'twi-hand-scissors' => 'twi-hand-scissors',
            'twi-handshake' => 'twi-handshake',
            'twi-handshake-alt' => 'twi-handshake-alt',
            'twi-hands-heart' => 'twi-hands-heart',
            'twi-hands-helping' => 'twi-hands-helping',
            'twi-hand-spock' => 'twi-hand-spock',
            'twi-hands-usd' => 'twi-hands-usd',
            'twi-hanukiah' => 'twi-hanukiah',
            'twi-hard-hat' => 'twi-hard-hat',
            'twi-hashtag' => 'twi-hashtag',
            'twi-hat-santa' => 'twi-hat-santa',
            'twi-hat-winter' => 'twi-hat-winter',
            'twi-hat-witch' => 'twi-hat-witch',
            'twi-hat-wizard' => 'twi-hat-wizard',
            'twi-haykal' => 'twi-haykal',
            'twi-hdd' => 'twi-hdd',
            'twi-heading' => 'twi-heading',
            'twi-headphones' => 'twi-headphones',
            'twi-headphones-alt' => 'twi-headphones-alt',
            'twi-headset' => 'twi-headset',
            'twi-head-side' => 'twi-head-side',
            'twi-head-side-brain' => 'twi-head-side-brain',
            'twi-head-side-medical' => 'twi-head-side-medical',
            'twi-head-vr' => 'twi-head-vr',
            'twi-heart' => 'twi-heart',
            'twi-heartbeat' => 'twi-heartbeat',
            'twi-heart-broken' => 'twi-heart-broken',
            'twi-heart-circle' => 'twi-heart-circle',
            'twi-heart-rate' => 'twi-heart-rate',
            'twi-heart-square' => 'twi-heart-square',
            'twi-helicopter' => 'twi-helicopter',
            'twi-helmet-battle' => 'twi-helmet-battle',
            'twi-hexagon' => 'twi-hexagon',
            'twi-highlighter' => 'twi-highlighter',
            'twi-hiking' => 'twi-hiking',
            'twi-hippo' => 'twi-hippo',
            'twi-history' => 'twi-history',
            'twi-hockey-mask' => 'twi-hockey-mask',
            'twi-hockey-puck' => 'twi-hockey-puck',
            'twi-hockey-sticks' => 'twi-hockey-sticks',
            'twi-holly-berry' => 'twi-holly-berry',
            'twi-home' => 'twi-home',
            'twi-home-alt' => 'twi-home-alt',
            'twi-home-heart' => 'twi-home-heart',
            'twi-home-lg' => 'twi-home-lg',
            'twi-home-lg-alt' => 'twi-home-lg-alt',
            'twi-hood-cloak' => 'twi-hood-cloak',
            'twi-horse' => 'twi-horse',
            'twi-horse-head' => 'twi-horse-head',
            'twi-hospital' => 'twi-hospital',
            'twi-hospital-alt' => 'twi-hospital-alt',
            'twi-hospitals' => 'twi-hospitals',
            'twi-hospital-symbol' => 'twi-hospital-symbol',
            'twi-hospital-user' => 'twi-hospital-user',
            'twi-hotdog' => 'twi-hotdog',
            'twi-hotel' => 'twi-hotel',
            'twi-hot-tub' => 'twi-hot-tub',
            'twi-hourglass' => 'twi-hourglass',
            'twi-hourglass-end' => 'twi-hourglass-end',
            'twi-hourglass-half' => 'twi-hourglass-half',
            'twi-hourglass-start' => 'twi-hourglass-start',
            'twi-house-damage' => 'twi-house-damage',
            'twi-house-flood' => 'twi-house-flood',
            'twi-hryvnia' => 'twi-hryvnia',
            'twi-h-square' => 'twi-h-square',
            'twi-humidity' => 'twi-humidity',
            'twi-hurricane' => 'twi-hurricane',
            'twi-ice-cream' => 'twi-ice-cream',
            'twi-ice-skate' => 'twi-ice-skate',
            'twi-icicles' => 'twi-icicles',
            'twi-i-cursor' => 'twi-i-cursor',
            'twi-id-badge' => 'twi-id-badge',
            'twi-id-card' => 'twi-id-card',
            'twi-id-card-alt' => 'twi-id-card-alt',
            'twi-igloo' => 'twi-igloo',
            'twi-image' => 'twi-image',
            'twi-images' => 'twi-images',
            'twi-inbox' => 'twi-inbox',
            'twi-inbox-in' => 'twi-inbox-in',
            'twi-inbox-out' => 'twi-inbox-out',
            'twi-indent' => 'twi-indent',
            'twi-industry' => 'twi-industry',
            'twi-industry-alt' => 'twi-industry-alt',
            'twi-infinity' => 'twi-infinity',
            'twi-info' => 'twi-info',
            'twi-info-circle' => 'twi-info-circle',
            'twi-info-square' => 'twi-info-square',
            'twi-inhaler' => 'twi-inhaler',
            'twi-integral' => 'twi-integral',
            'twi-intersection' => 'twi-intersection',
            'twi-inventory' => 'twi-inventory',
            'twi-island-tropical' => 'twi-island-tropical',
            'twi-italic' => 'twi-italic',
            'twi-jack-o-lantern' => 'twi-jack-o-lantern',
            'twi-jedi' => 'twi-jedi',
            'twi-joint' => 'twi-joint',
            'twi-journal-whills' => 'twi-journal-whills',
            'twi-kaaba' => 'twi-kaaba',
            'twi-key' => 'twi-key',
            'twi-keyboard' => 'twi-keyboard',
            'twi-keynote' => 'twi-keynote',
            'twi-key-skeleton' => 'twi-key-skeleton',
            'twi-khanda' => 'twi-khanda',
            'twi-kidneys' => 'twi-kidneys',
            'twi-kiss' => 'twi-kiss',
            'twi-kiss-beam' => 'twi-kiss-beam',
            'twi-kiss-wink-heart' => 'twi-kiss-wink-heart',
            'twi-kite' => 'twi-kite',
            'twi-kiwi-bird' => 'twi-kiwi-bird',
            'twi-knife-kitchen' => 'twi-knife-kitchen',
            'twi-lambda' => 'twi-lambda',
            'twi-lamp' => 'twi-lamp',
            'twi-landmark' => 'twi-landmark',
            'twi-landmark-alt' => 'twi-landmark-alt',
            'twi-language' => 'twi-language',
            'twi-laptop' => 'twi-laptop',
            'twi-laptop-code' => 'twi-laptop-code',
            'twi-laptop-medical' => 'twi-laptop-medical',
            'twi-laugh' => 'twi-laugh',
            'twi-laugh-beam' => 'twi-laugh-beam',
            'twi-laugh-squint' => 'twi-laugh-squint',
            'twi-laugh-wink' => 'twi-laugh-wink',
            'twi-layer-group' => 'twi-layer-group',
            'twi-layer-minus' => 'twi-layer-minus',
            'twi-layer-plus' => 'twi-layer-plus',
            'twi-leaf' => 'twi-leaf',
            'twi-leaf-heart' => 'twi-leaf-heart',
            'twi-leaf-maple' => 'twi-leaf-maple',
            'twi-leaf-oak' => 'twi-leaf-oak',
            'twi-lemon' => 'twi-lemon',
            'twi-less-than' => 'twi-less-than',
            'twi-less-than-equal' => 'twi-less-than-equal',
            'twi-level-down' => 'twi-level-down',
            'twi-level-down-alt' => 'twi-level-down-alt',
            'twi-level-up' => 'twi-level-up',
            'twi-level-up-alt' => 'twi-level-up-alt',
            'twi-life-ring' => 'twi-life-ring',
            'twi-lightbulb' => 'twi-lightbulb',
            'twi-lightbulb-dollar' => 'twi-lightbulb-dollar',
            'twi-lightbulb-exclamation' => 'twi-lightbulb-exclamation',
            'twi-lightbulb-on' => 'twi-lightbulb-on',
            'twi-lightbulb-slash' => 'twi-lightbulb-slash',
            'twi-lights-holiday' => 'twi-lights-holiday',
            'twi-link' => 'twi-link',
            'twi-lips' => 'twi-lips',
            'twi-lira-sign' => 'twi-lira-sign',
            'twi-list' => 'twi-list',
            'twi-list-alt' => 'twi-list-alt',
            'twi-list-ol' => 'twi-list-ol',
            'twi-list-ul' => 'twi-list-ul',
            'twi-location' => 'twi-location',
            'twi-location-arrow' => 'twi-location-arrow',
            'twi-location-circle' => 'twi-location-circle',
            'twi-location-slash' => 'twi-location-slash',
            'twi-lock' => 'twi-lock',
            'twi-lock-alt' => 'twi-lock-alt',
            'twi-lock-open' => 'twi-lock-open',
            'twi-lock-open-alt' => 'twi-lock-open-alt',
            'twi-long-arrow-alt-down' => 'twi-long-arrow-alt-down',
            'twi-long-arrow-alt-left' => 'twi-long-arrow-alt-left',
            'twi-long-arrow-alt-right' => 'twi-long-arrow-alt-right',
            'twi-long-arrow-alt-up' => 'twi-long-arrow-alt-up',
            'twi-long-arrow-down' => 'twi-long-arrow-down',
            'twi-long-arrow-left' => 'twi-long-arrow-left',
            'twi-long-arrow-right' => 'twi-long-arrow-right',
            'twi-long-arrow-up' => 'twi-long-arrow-up',
            'twi-loveseat' => 'twi-loveseat',
            'twi-low-vision' => 'twi-low-vision',
            'twi-luchador' => 'twi-luchador',
            'twi-luggage-cart' => 'twi-luggage-cart',
            'twi-lungs' => 'twi-lungs',
            'twi-mace' => 'twi-mace',
            'twi-magic' => 'twi-magic',
            'twi-magnet' => 'twi-magnet',
            'twi-mailbox' => 'twi-mailbox',
            'twi-mail-bulk' => 'twi-mail-bulk',
            'twi-male' => 'twi-male',
            'twi-mandolin' => 'twi-mandolin',
            'twi-map' => 'twi-map',
            'twi-map-marked' => 'twi-map-marked',
            'twi-map-marked-alt' => 'twi-map-marked-alt',
            'twi-map-marker' => 'twi-map-marker',
            'twi-map-marker-alt' => 'twi-map-marker-alt',
            'twi-map-marker-alt-slash' => 'twi-map-marker-alt-slash',
            'twi-map-marker-check' => 'twi-map-marker-check',
            'twi-map-marker-edit' => 'twi-map-marker-edit',
            'twi-map-marker-exclamation' => 'twi-map-marker-exclamation',
            'twi-map-marker-minus' => 'twi-map-marker-minus',
            'twi-map-marker-plus' => 'twi-map-marker-plus',
            'twi-map-marker-question' => 'twi-map-marker-question',
            'twi-map-marker-slash' => 'twi-map-marker-slash',
            'twi-map-marker-smile' => 'twi-map-marker-smile',
            'twi-map-marker-times' => 'twi-map-marker-times',
            'twi-map-pin' => 'twi-map-pin',
            'twi-map-signs' => 'twi-map-signs',
            'twi-marker' => 'twi-marker',
            'twi-mars' => 'twi-mars',
            'twi-mars-double' => 'twi-mars-double',
            'twi-mars-stroke' => 'twi-mars-stroke',
            'twi-mars-stroke-h' => 'twi-mars-stroke-h',
            'twi-mars-stroke-v' => 'twi-mars-stroke-v',
            'twi-mask' => 'twi-mask',
            'twi-meat' => 'twi-meat',
            'twi-medal' => 'twi-medal',
            'twi-medkit' => 'twi-medkit',
            'twi-megaphone' => 'twi-megaphone',
            'twi-meh' => 'twi-meh',
            'twi-meh-blank' => 'twi-meh-blank',
            'twi-meh-rolling-eyes' => 'twi-meh-rolling-eyes',
            'twi-memory' => 'twi-memory',
            'twi-menorah' => 'twi-menorah',
            'twi-mercury' => 'twi-mercury',
            'twi-meteor' => 'twi-meteor',
            'twi-microchip' => 'twi-microchip',
            'twi-microphone' => 'twi-microphone',
            'twi-microphone-alt' => 'twi-microphone-alt',
            'twi-microphone-alt-slash' => 'twi-microphone-alt-slash',
            'twi-microphone-slash' => 'twi-microphone-slash',
            'twi-microscope' => 'twi-microscope',
            'twi-mind-share' => 'twi-mind-share',
            'twi-minus' => 'twi-minus',
            'twi-minus-circle' => 'twi-minus-circle',
            'twi-minus-hexagon' => 'twi-minus-hexagon',
            'twi-minus-octagon' => 'twi-minus-octagon',
            'twi-minus-square' => 'twi-minus-square',
            'twi-mistletoe' => 'twi-mistletoe',
            'twi-mitten' => 'twi-mitten',
            'twi-mobile' => 'twi-mobile',
            'twi-mobile-alt' => 'twi-mobile-alt',
            'twi-mobile-android' => 'twi-mobile-android',
            'twi-mobile-android-alt' => 'twi-mobile-android-alt',
            'twi-money-bill' => 'twi-money-bill',
            'twi-money-bill-alt' => 'twi-money-bill-alt',
            'twi-money-bill-wave' => 'twi-money-bill-wave',
            'twi-money-bill-wave-alt' => 'twi-money-bill-wave-alt',
            'twi-money-check' => 'twi-money-check',
            'twi-money-check-alt' => 'twi-money-check-alt',
            'twi-monitor-heart-rate' => 'twi-monitor-heart-rate',
            'twi-monkey' => 'twi-monkey',
            'twi-monument' => 'twi-monument',
            'twi-moon' => 'twi-moon',
            'twi-moon-cloud' => 'twi-moon-cloud',
            'twi-moon-stars' => 'twi-moon-stars',
            'twi-mortar-pestle' => 'twi-mortar-pestle',
            'twi-mosque' => 'twi-mosque',
            'twi-motorcycle' => 'twi-motorcycle',
            'twi-mountain' => 'twi-mountain',
            'twi-mountains' => 'twi-mountains',
            'twi-mouse-pointer' => 'twi-mouse-pointer',
            'twi-mug-hot' => 'twi-mug-hot',
            'twi-mug-marshmallows' => 'twi-mug-marshmallows',
            'twi-music' => 'twi-music',
            'twi-narwhal' => 'twi-narwhal',
            'twi-network-wired' => 'twi-network-wired',
            'twi-neuter' => 'twi-neuter',
            'twi-newspaper' => 'twi-newspaper',
            'twi-not-equal' => 'twi-not-equal',
            'twi-notes-medical' => 'twi-notes-medical',
            'twi-object-group' => 'twi-object-group',
            'twi-object-ungroup' => 'twi-object-ungroup',
            'twi-octagon' => 'twi-octagon',
            'twi-oil-can' => 'twi-oil-can',
            'twi-oil-temp' => 'twi-oil-temp',
            'twi-om' => 'twi-om',
            'twi-omega' => 'twi-omega',
            'twi-ornament' => 'twi-ornament',
            'twi-otter' => 'twi-otter',
            'twi-outdent' => 'twi-outdent',
            'twi-pager' => 'twi-pager',
            'twi-paint-brush' => 'twi-paint-brush',
            'twi-paint-brush-alt' => 'twi-paint-brush-alt',
            'twi-paint-roller' => 'twi-paint-roller',
            'twi-palette' => 'twi-palette',
            'twi-pallet' => 'twi-pallet',
            'twi-pallet-alt' => 'twi-pallet-alt',
            'twi-paperclip' => 'twi-paperclip',
            'twi-paper-plane' => 'twi-paper-plane',
            'twi-parachute-box' => 'twi-parachute-box',
            'twi-paragraph' => 'twi-paragraph',
            'twi-parking' => 'twi-parking',
            'twi-parking-circle' => 'twi-parking-circle',
            'twi-parking-circle-slash' => 'twi-parking-circle-slash',
            'twi-parking-slash' => 'twi-parking-slash',
            'twi-passport' => 'twi-passport',
            'twi-pastafarianism' => 'twi-pastafarianism',
            'twi-paste' => 'twi-paste',
            'twi-pause' => 'twi-pause',
            'twi-pause-circle' => 'twi-pause-circle',
            'twi-paw' => 'twi-paw',
            'twi-paw-alt' => 'twi-paw-alt',
            'twi-paw-claws' => 'twi-paw-claws',
            'twi-peace' => 'twi-peace',
            'twi-pegasus' => 'twi-pegasus',
            'twi-pen' => 'twi-pen',
            'twi-pen-alt' => 'twi-pen-alt',
            'twi-pencil' => 'twi-pencil',
            'twi-pencil-alt' => 'twi-pencil-alt',
            'twi-pencil-paintbrush' => 'twi-pencil-paintbrush',
            'twi-pencil-ruler' => 'twi-pencil-ruler',
            'twi-pen-fancy' => 'twi-pen-fancy',
            'twi-pennant' => 'twi-pennant',
            'twi-pen-nib' => 'twi-pen-nib',
            'twi-pen-square' => 'twi-pen-square',
            'twi-people-carry' => 'twi-people-carry',
            'twi-pepper-hot' => 'twi-pepper-hot',
            'twi-percent' => 'twi-percent',
            'twi-percentage' => 'twi-percentage',
            'twi-person-booth' => 'twi-person-booth',
            'twi-person-carry' => 'twi-person-carry',
            'twi-person-dolly' => 'twi-person-dolly',
            'twi-person-dolly-empty' => 'twi-person-dolly-empty',
            'twi-person-sign' => 'twi-person-sign',
            'twi-phone' => 'twi-phone',
            'twi-phone-office' => 'twi-phone-office',
            'twi-phone-plus' => 'twi-phone-plus',
            'twi-phone-slash' => 'twi-phone-slash',
            'twi-phone-square' => 'twi-phone-square',
            'twi-phone-volume' => 'twi-phone-volume',
            'twi-pi' => 'twi-pi',
            'twi-pie' => 'twi-pie',
            'twi-pig' => 'twi-pig',
            'twi-piggy-bank' => 'twi-piggy-bank',
            'twi-pills' => 'twi-pills',
            'twi-pizza' => 'twi-pizza',
            'twi-pizza-slice' => 'twi-pizza-slice',
            'twi-place-of-worship' => 'twi-place-of-worship',
            'twi-plane' => 'twi-plane',
            'twi-plane-alt' => 'twi-plane-alt',
            'twi-plane-arrival' => 'twi-plane-arrival',
            'twi-plane-departure' => 'twi-plane-departure',
            'twi-play' => 'twi-play',
            'twi-play-circle' => 'twi-play-circle',
            'twi-plug' => 'twi-plug',
            'twi-plus' => 'twi-plus',
            'twi-plus-circle' => 'twi-plus-circle',
            'twi-plus-hexagon' => 'twi-plus-hexagon',
            'twi-plus-octagon' => 'twi-plus-octagon',
            'twi-plus-square' => 'twi-plus-square',
            'twi-podcast' => 'twi-podcast',
            'twi-podium' => 'twi-podium',
            'twi-podium-star' => 'twi-podium-star',
            'twi-poll' => 'twi-poll',
            'twi-poll-h' => 'twi-poll-h',
            'twi-poll-people' => 'twi-poll-people',
            'twi-poo' => 'twi-poo',
            'twi-poop' => 'twi-poop',
            'twi-poo-storm' => 'twi-poo-storm',
            'twi-popcorn' => 'twi-popcorn',
            'twi-portrait' => 'twi-portrait',
            'twi-pound-sign' => 'twi-pound-sign',
            'twi-power-off' => 'twi-power-off',
            'twi-pray' => 'twi-pray',
            'twi-praying-hands' => 'twi-praying-hands',
            'twi-prescription' => 'twi-prescription',
            'twi-prescription-bottle' => 'twi-prescription-bottle',
            'twi-prescription-bottle-alt' => 'twi-prescription-bottle-alt',
            'twi-presentation' => 'twi-presentation',
            'twi-print' => 'twi-print',
            'twi-print-search' => 'twi-print-search',
            'twi-print-slash' => 'twi-print-slash',
            'twi-procedures' => 'twi-procedures',
            'twi-project-diagram' => 'twi-project-diagram',
            'twi-pumpkin' => 'twi-pumpkin',
            'twi-puzzle-piece' => 'twi-puzzle-piece',
            'twi-qrcode' => 'twi-qrcode',
            'twi-question' => 'twi-question',
            'twi-question-circle' => 'twi-question-circle',
            'twi-question-square' => 'twi-question-square',
            'twi-quidditch' => 'twi-quidditch',
            'twi-quote-left' => 'twi-quote-left',
            'twi-quote-right' => 'twi-quote-right',
            'twi-quran' => 'twi-quran',
            'twi-rabbit' => 'twi-rabbit',
            'twi-rabbit-fast' => 'twi-rabbit-fast',
            'twi-racquet' => 'twi-racquet',
            'twi-radiation' => 'twi-radiation',
            'twi-radiation-alt' => 'twi-radiation-alt',
            'twi-rainbow' => 'twi-rainbow',
            'twi-raindrops' => 'twi-raindrops',
            'twi-ram' => 'twi-ram',
            'twi-ramp-loading' => 'twi-ramp-loading',
            'twi-random' => 'twi-random',
            'twi-receipt' => 'twi-receipt',
            'twi-rectangle-landscape' => 'twi-rectangle-landscape',
            'twi-rectangle-portrait' => 'twi-rectangle-portrait',
            'twi-rectangle-wide' => 'twi-rectangle-wide',
            'twi-recycle' => 'twi-recycle',
            'twi-redo' => 'twi-redo',
            'twi-redo-alt' => 'twi-redo-alt',
            'twi-registered' => 'twi-registered',
            'twi-repeat' => 'twi-repeat',
            'twi-repeat-1' => 'twi-repeat-1',
            'twi-repeat-1-alt' => 'twi-repeat-1-alt',
            'twi-repeat-alt' => 'twi-repeat-alt',
            'twi-reply' => 'twi-reply',
            'twi-reply-all' => 'twi-reply-all',
            'twi-republican' => 'twi-republican',
            'twi-restroom' => 'twi-restroom',
            'twi-retweet' => 'twi-retweet',
            'twi-retweet-alt' => 'twi-retweet-alt',
            'twi-ribbon' => 'twi-ribbon',
            'twi-ring' => 'twi-ring',
            'twi-rings-wedding' => 'twi-rings-wedding',
            'twi-road' => 'twi-road',
            'twi-robot' => 'twi-robot',
            'twi-rocket' => 'twi-rocket',
            'twi-route' => 'twi-route',
            'twi-route-highway' => 'twi-route-highway',
            'twi-route-interstate' => 'twi-route-interstate',
            'twi-rss' => 'twi-rss',
            'twi-rss-square' => 'twi-rss-square',
            'twi-ruble-sign' => 'twi-ruble-sign',
            'twi-ruler' => 'twi-ruler',
            'twi-ruler-combined' => 'twi-ruler-combined',
            'twi-ruler-horizontal' => 'twi-ruler-horizontal',
            'twi-ruler-triangle' => 'twi-ruler-triangle',
            'twi-ruler-vertical' => 'twi-ruler-vertical',
            'twi-running' => 'twi-running',
            'twi-rupee-sign' => 'twi-rupee-sign',
            'twi-rv' => 'twi-rv',
            'twi-sack' => 'twi-sack',
            'twi-sack-dollar' => 'twi-sack-dollar',
            'twi-sad-cry' => 'twi-sad-cry',
            'twi-sad-tear' => 'twi-sad-tear',
            'twi-salad' => 'twi-salad',
            'twi-sandwich' => 'twi-sandwich',
            'twi-satellite' => 'twi-satellite',
            'twi-satellite-dish' => 'twi-satellite-dish',
            'twi-sausage' => 'twi-sausage',
            'twi-save' => 'twi-save',
            'twi-scalpel' => 'twi-scalpel',
            'twi-scalpel-path' => 'twi-scalpel-path',
            'twi-scanner' => 'twi-scanner',
            'twi-scanner-keyboard' => 'twi-scanner-keyboard',
            'twi-scanner-touchscreen' => 'twi-scanner-touchscreen',
            'twi-scarecrow' => 'twi-scarecrow',
            'twi-scarf' => 'twi-scarf',
            'twi-school' => 'twi-school',
            'twi-screwdriver' => 'twi-screwdriver',
            'twi-scroll' => 'twi-scroll',
            'twi-scroll-old' => 'twi-scroll-old',
            'twi-scrubber' => 'twi-scrubber',
            'twi-scythe' => 'twi-scythe',
            'twi-sd-card' => 'twi-sd-card',
            'twi-search' => 'twi-search',
            'twi-search-dollar' => 'twi-search-dollar',
            'twi-search-location' => 'twi-search-location',
            'twi-search-minus' => 'twi-search-minus',
            'twi-search-plus' => 'twi-search-plus',
            'twi-seedling' => 'twi-seedling',
            'twi-server' => 'twi-server',
            'twi-shapes' => 'twi-shapes',
            'twi-share' => 'twi-share',
            'twi-share-all' => 'twi-share-all',
            'twi-share-alt' => 'twi-share-alt',
            'twi-share-alt-square' => 'twi-share-alt-square',
            'twi-share-square' => 'twi-share-square',
            'twi-sheep' => 'twi-sheep',
            'twi-shekel-sign' => 'twi-shekel-sign',
            'twi-shield' => 'twi-shield',
            'twi-shield-alt' => 'twi-shield-alt',
            'twi-shield-check' => 'twi-shield-check',
            'twi-shield-cross' => 'twi-shield-cross',
            'twi-ship' => 'twi-ship',
            'twi-shipping-fast' => 'twi-shipping-fast',
            'twi-shipping-timed' => 'twi-shipping-timed',
            'twi-shish-kebab' => 'twi-shish-kebab',
            'twi-shoe-prints' => 'twi-shoe-prints',
            'twi-shopping-bag' => 'twi-shopping-bag',
            'twi-shopping-basket' => 'twi-shopping-basket',
            'twi-shopping-cart' => 'twi-shopping-cart',
            'twi-shovel' => 'twi-shovel',
            'twi-shovel-snow' => 'twi-shovel-snow',
            'twi-shower' => 'twi-shower',
            'twi-shredder' => 'twi-shredder',
            'twi-shuttlecock' => 'twi-shuttlecock',
            'twi-shuttle-van' => 'twi-shuttle-van',
            'twi-sickle' => 'twi-sickle',
            'twi-sigma' => 'twi-sigma',
            'twi-sign' => 'twi-sign',
            'twi-signal' => 'twi-signal',
            'twi-signal-1' => 'twi-signal-1',
            'twi-signal-2' => 'twi-signal-2',
            'twi-signal-3' => 'twi-signal-3',
            'twi-signal-4' => 'twi-signal-4',
            'twi-signal-alt' => 'twi-signal-alt',
            'twi-signal-alt-1' => 'twi-signal-alt-1',
            'twi-signal-alt-2' => 'twi-signal-alt-2',
            'twi-signal-alt-3' => 'twi-signal-alt-3',
            'twi-signal-alt-slash' => 'twi-signal-alt-slash',
            'twi-signal-slash' => 'twi-signal-slash',
            'twi-signature' => 'twi-signature',
            'twi-sign-in' => 'twi-sign-in',
            'twi-sign-in-alt' => 'twi-sign-in-alt',
            'twi-sign-language' => 'twi-sign-language',
            'twi-sign-out' => 'twi-sign-out',
            'twi-sign-out-alt' => 'twi-sign-out-alt',
            'twi-sim-card' => 'twi-sim-card',
            'twi-sitemap' => 'twi-sitemap',
            'twi-skating' => 'twi-skating',
            'twi-skeleton' => 'twi-skeleton',
            'twi-skiing' => 'twi-skiing',
            'twi-skiing-nordic' => 'twi-skiing-nordic',
            'twi-ski-jump' => 'twi-ski-jump',
            'twi-ski-lift' => 'twi-ski-lift',
            'twi-skull' => 'twi-skull',
            'twi-skull-crossbones' => 'twi-skull-crossbones',
            'twi-slash' => 'twi-slash',
            'twi-sledding' => 'twi-sledding',
            'twi-sleigh' => 'twi-sleigh',
            'twi-sliders-h' => 'twi-sliders-h',
            'twi-sliders-h-square' => 'twi-sliders-h-square',
            'twi-sliders-v' => 'twi-sliders-v',
            'twi-sliders-v-square' => 'twi-sliders-v-square',
            'twi-smile' => 'twi-smile',
            'twi-smile-beam' => 'twi-smile-beam',
            'twi-smile-plus' => 'twi-smile-plus',
            'twi-smile-wink' => 'twi-smile-wink',
            'twi-smog' => 'twi-smog',
            'twi-smoke' => 'twi-smoke',
            'twi-smoking' => 'twi-smoking',
            'twi-smoking-ban' => 'twi-smoking-ban',
            'twi-sms' => 'twi-sms',
            'twi-snake' => 'twi-snake',
            'twi-snow-blowing' => 'twi-snow-blowing',
            'twi-snowboarding' => 'twi-snowboarding',
            'twi-snowflake' => 'twi-snowflake',
            'twi-snowflakes' => 'twi-snowflakes',
            'twi-snowman' => 'twi-snowman',
            'twi-snowmobile' => 'twi-snowmobile',
            'twi-snowplow' => 'twi-snowplow',
            'twi-socks' => 'twi-socks',
            'twi-solar-panel' => 'twi-solar-panel',
            'twi-sort' => 'twi-sort',
            'twi-sort-alpha-down' => 'twi-sort-alpha-down',
            'twi-sort-alpha-up' => 'twi-sort-alpha-up',
            'twi-sort-amount-down' => 'twi-sort-amount-down',
            'twi-sort-amount-up' => 'twi-sort-amount-up',
            'twi-sort-down' => 'twi-sort-down',
            'twi-sort-numeric-down' => 'twi-sort-numeric-down',
            'twi-sort-numeric-up' => 'twi-sort-numeric-up',
            'twi-sort-up' => 'twi-sort-up',
            'twi-soup' => 'twi-soup',
            'twi-spa' => 'twi-spa',
            'twi-space-shuttle' => 'twi-space-shuttle',
            'twi-spade' => 'twi-spade',
            'twi-spider' => 'twi-spider',
            'twi-spider-black-widow' => 'twi-spider-black-widow',
            'twi-spider-web' => 'twi-spider-web',
            'twi-spinner' => 'twi-spinner',
            'twi-spinner-third' => 'twi-spinner-third',
            'twi-splotch' => 'twi-splotch',
            'twi-spray-can' => 'twi-spray-can',
            'twi-square' => 'twi-square',
            'twi-square-full' => 'twi-square-full',
            'twi-square-root' => 'twi-square-root',
            'twi-square-root-alt' => 'twi-square-root-alt',
            'twi-squirrel' => 'twi-squirrel',
            'twi-staff' => 'twi-staff',
            'twi-stamp' => 'twi-stamp',
            'twi-star' => 'twi-star',
            'twi-star-and-crescent' => 'twi-star-and-crescent',
            'twi-star-christmas' => 'twi-star-christmas',
            'twi-star-exclamation' => 'twi-star-exclamation',
            'twi-star-half' => 'twi-star-half',
            'twi-star-half-alt' => 'twi-star-half-alt',
            'twi-star-of-david' => 'twi-star-of-david',
            'twi-star-of-life' => 'twi-star-of-life',
            'twi-stars' => 'twi-stars',
            'twi-steak' => 'twi-steak',
            'twi-steering-wheel' => 'twi-steering-wheel',
            'twi-step-backward' => 'twi-step-backward',
            'twi-step-forward' => 'twi-step-forward',
            'twi-stethoscope' => 'twi-stethoscope',
            'twi-sticky-note' => 'twi-sticky-note',
            'twi-stocking' => 'twi-stocking',
            'twi-stomach' => 'twi-stomach',
            'twi-stop' => 'twi-stop',
            'twi-stop-circle' => 'twi-stop-circle',
            'twi-stopwatch' => 'twi-stopwatch',
            'twi-store' => 'twi-store',
            'twi-store-alt' => 'twi-store-alt',
            'twi-stream' => 'twi-stream',
            'twi-street-view' => 'twi-street-view',
            'twi-stretcher' => 'twi-stretcher',
            'twi-strikethrough' => 'twi-strikethrough',
            'twi-stroopwafel' => 'twi-stroopwafel',
            'twi-subscript' => 'twi-subscript',
            'twi-subway' => 'twi-subway',
            'twi-suitcase' => 'twi-suitcase',
            'twi-suitcase-rolling' => 'twi-suitcase-rolling',
            'twi-sun' => 'twi-sun',
            'twi-sun-cloud' => 'twi-sun-cloud',
            'twi-sun-dust' => 'twi-sun-dust',
            'twi-sun-haze' => 'twi-sun-haze',
            'twi-sunrise' => 'twi-sunrise',
            'twi-sunset' => 'twi-sunset',
            'twi-superscript' => 'twi-superscript',
            'twi-surprise' => 'twi-surprise',
            'twi-swatchbook' => 'twi-swatchbook',
            'twi-swimmer' => 'twi-swimmer',
            'twi-swimming-pool' => 'twi-swimming-pool',
            'twi-sword' => 'twi-sword',
            'twi-swords' => 'twi-swords',
            'twi-synagogue' => 'twi-synagogue',
            'twi-sync' => 'twi-sync',
            'twi-sync-alt' => 'twi-sync-alt',
            'twi-syringe' => 'twi-syringe',
            'twi-table' => 'twi-table',
            'twi-tablet' => 'twi-tablet',
            'twi-tablet-alt' => 'twi-tablet-alt',
            'twi-tablet-android' => 'twi-tablet-android',
            'twi-tablet-android-alt' => 'twi-tablet-android-alt',
            'twi-table-tennis' => 'twi-table-tennis',
            'twi-tablet-rugged' => 'twi-tablet-rugged',
            'twi-tablets' => 'twi-tablets',
            'twi-tachometer' => 'twi-tachometer',
            'twi-tachometer-alt' => 'twi-tachometer-alt',
            'twi-tachometer-alt-average' => 'twi-tachometer-alt-average',
            'twi-tachometer-alt-fast' => 'twi-tachometer-alt-fast',
            'twi-tachometer-alt-fastest' => 'twi-tachometer-alt-fastest',
            'twi-tachometer-alt-slow' => 'twi-tachometer-alt-slow',
            'twi-tachometer-alt-slowest' => 'twi-tachometer-alt-slowest',
            'twi-tachometer-average' => 'twi-tachometer-average',
            'twi-tachometer-fast' => 'twi-tachometer-fast',
            'twi-tachometer-fastest' => 'twi-tachometer-fastest',
            'twi-tachometer-slow' => 'twi-tachometer-slow',
            'twi-tachometer-slowest' => 'twi-tachometer-slowest',
            'twi-taco' => 'twi-taco',
            'twi-tag' => 'twi-tag',
            'twi-tags' => 'twi-tags',
            'twi-tally' => 'twi-tally',
            'twi-tanakh' => 'twi-tanakh',
            'twi-tape' => 'twi-tape',
            'twi-tasks' => 'twi-tasks',
            'twi-tasks-alt' => 'twi-tasks-alt',
            'twi-taxi' => 'twi-taxi',
            'twi-teeth' => 'twi-teeth',
            'twi-teeth-open' => 'twi-teeth-open',
            'twi-temperature-frigid' => 'twi-temperature-frigid',
            'twi-temperature-high' => 'twi-temperature-high',
            'twi-temperature-hot' => 'twi-temperature-hot',
            'twi-temperature-low' => 'twi-temperature-low',
            'twi-tenge' => 'twi-tenge',
            'twi-tennis-ball' => 'twi-tennis-ball',
            'twi-terminal' => 'twi-terminal',
            'twi-text-height' => 'twi-text-height',
            'twi-text-width' => 'twi-text-width',
            'twi-th' => 'twi-th',
            'twi-theater-masks' => 'twi-theater-masks',
            'twi-thermometer' => 'twi-thermometer',
            'twi-thermometer-empty' => 'twi-thermometer-empty',
            'twi-thermometer-full' => 'twi-thermometer-full',
            'twi-thermometer-half' => 'twi-thermometer-half',
            'twi-thermometer-quarter' => 'twi-thermometer-quarter',
            'twi-thermometer-three-quarters' => 'twi-thermometer-three-quarters',
            'twi-theta' => 'twi-theta',
            'twi-th-large' => 'twi-th-large',
            'twi-th-list' => 'twi-th-list',
            'twi-thumbs-down' => 'twi-thumbs-down',
            'twi-thumbs-up' => 'twi-thumbs-up',
            'twi-thumbtack' => 'twi-thumbtack',
            'twi-thunderstorm' => 'twi-thunderstorm',
            'twi-thunderstorm-moon' => 'twi-thunderstorm-moon',
            'twi-thunderstorm-sun' => 'twi-thunderstorm-sun',
            'twi-ticket' => 'twi-ticket',
            'twi-ticket-alt' => 'twi-ticket-alt',
            'twi-tilde' => 'twi-tilde',
            'twi-times' => 'twi-times',
            'twi-times-circle' => 'twi-times-circle',
            'twi-times-hexagon' => 'twi-times-hexagon',
            'twi-times-octagon' => 'twi-times-octagon',
            'twi-times-square' => 'twi-times-square',
            'twi-tint' => 'twi-tint',
            'twi-tint-slash' => 'twi-tint-slash',
            'twi-tire' => 'twi-tire',
            'twi-tired' => 'twi-tired',
            'twi-tire-flat' => 'twi-tire-flat',
            'twi-tire-pressure-warning' => 'twi-tire-pressure-warning',
            'twi-tire-rugged' => 'twi-tire-rugged',
            'twi-toggle-off' => 'twi-toggle-off',
            'twi-toggle-on' => 'twi-toggle-on',
            'twi-toilet' => 'twi-toilet',
            'twi-toilet-paper' => 'twi-toilet-paper',
            'twi-toilet-paper-alt' => 'twi-toilet-paper-alt',
            'twi-tombstone' => 'twi-tombstone',
            'twi-tombstone-alt' => 'twi-tombstone-alt',
            'twi-toolbox' => 'twi-toolbox',
            'twi-tools' => 'twi-tools',
            'twi-tooth' => 'twi-tooth',
            'twi-toothbrush' => 'twi-toothbrush',
            'twi-torah' => 'twi-torah',
            'twi-torii-gate' => 'twi-torii-gate',
            'twi-tornado' => 'twi-tornado',
            'twi-tractor' => 'twi-tractor',
            'twi-trademark' => 'twi-trademark',
            'twi-traffic-cone' => 'twi-traffic-cone',
            'twi-traffic-light' => 'twi-traffic-light',
            'twi-traffic-light-go' => 'twi-traffic-light-go',
            'twi-traffic-light-slow' => 'twi-traffic-light-slow',
            'twi-traffic-light-stop' => 'twi-traffic-light-stop',
            'twi-train' => 'twi-train',
            'twi-tram' => 'twi-tram',
            'twi-transgender' => 'twi-transgender',
            'twi-transgender-alt' => 'twi-transgender-alt',
            'twi-trash' => 'twi-trash',
            'twi-trash-alt' => 'twi-trash-alt',
            'twi-trash-restore' => 'twi-trash-restore',
            'twi-trash-restore-alt' => 'twi-trash-restore-alt',
            'twi-treasure-chest' => 'twi-treasure-chest',
            'twi-tree' => 'twi-tree',
            'twi-tree-alt' => 'twi-tree-alt',
            'twi-tree-christmas' => 'twi-tree-christmas',
            'twi-tree-decorated' => 'twi-tree-decorated',
            'twi-tree-large' => 'twi-tree-large',
            'twi-tree-palm' => 'twi-tree-palm',
            'twi-trees' => 'twi-trees',
            'twi-triangle' => 'twi-triangle',
            'twi-trophy' => 'twi-trophy',
            'twi-trophy-alt' => 'twi-trophy-alt',
            'twi-truck' => 'twi-truck',
            'twi-truck-container' => 'twi-truck-container',
            'twi-truck-couch' => 'twi-truck-couch',
            'twi-truck-loading' => 'twi-truck-loading',
            'twi-truck-monster' => 'twi-truck-monster',
            'twi-truck-moving' => 'twi-truck-moving',
            'twi-truck-pickup' => 'twi-truck-pickup',
            'twi-truck-plow' => 'twi-truck-plow',
            'twi-truck-ramp' => 'twi-truck-ramp',
            'twi-tshirt' => 'twi-tshirt',
            'twi-tty' => 'twi-tty',
            'twi-turkey' => 'twi-turkey',
            'twi-turtle' => 'twi-turtle',
            'twi-tv' => 'twi-tv',
            'twi-tv-retro' => 'twi-tv-retro',
            'twi-umbrella' => 'twi-umbrella',
            'twi-umbrella-beach' => 'twi-umbrella-beach',
            'twi-underline' => 'twi-underline',
            'twi-undo' => 'twi-undo',
            'twi-undo-alt' => 'twi-undo-alt',
            'twi-unicorn' => 'twi-unicorn',
            'twi-union' => 'twi-union',
            'twi-universal-access' => 'twi-universal-access',
            'twi-university' => 'twi-university',
            'twi-unlink' => 'twi-unlink',
            'twi-unlock' => 'twi-unlock',
            'twi-unlock-alt' => 'twi-unlock-alt',
            'twi-upload' => 'twi-upload',
            'twi-usd-circle' => 'twi-usd-circle',
            'twi-usd-square' => 'twi-usd-square',
            'twi-user' => 'twi-user',
            'twi-user-alt' => 'twi-user-alt',
            'twi-user-alt-slash' => 'twi-user-alt-slash',
            'twi-user-astronaut' => 'twi-user-astronaut',
            'twi-user-chart' => 'twi-user-chart',
            'twi-user-check' => 'twi-user-check',
            'twi-user-circle' => 'twi-user-circle',
            'twi-user-clock' => 'twi-user-clock',
            'twi-user-cog' => 'twi-user-cog',
            'twi-user-crown' => 'twi-user-crown',
            'twi-user-edit' => 'twi-user-edit',
            'twi-user-friends' => 'twi-user-friends',
            'twi-user-graduate' => 'twi-user-graduate',
            'twi-user-hard-hat' => 'twi-user-hard-hat',
            'twi-user-headset' => 'twi-user-headset',
            'twi-user-injured' => 'twi-user-injured',
            'twi-user-lock' => 'twi-user-lock',
            'twi-user-md' => 'twi-user-md',
            'twi-user-md-chat' => 'twi-user-md-chat',
            'twi-user-minus' => 'twi-user-minus',
            'twi-user-ninja' => 'twi-user-ninja',
            'twi-user-nurse' => 'twi-user-nurse',
            'twi-user-plus' => 'twi-user-plus',
            'twi-users' => 'twi-users',
            'twi-users-class' => 'twi-users-class',
            'twi-users-cog' => 'twi-users-cog',
            'twi-users-crown' => 'twi-users-crown',
            'twi-user-secret' => 'twi-user-secret',
            'twi-user-shield' => 'twi-user-shield',
            'twi-user-slash' => 'twi-user-slash',
            'twi-users-medical' => 'twi-users-medical',
            'twi-user-tag' => 'twi-user-tag',
            'twi-user-tie' => 'twi-user-tie',
            'twi-user-times' => 'twi-user-times',
            'twi-utensil-fork' => 'twi-utensil-fork',
            'twi-utensil-knife' => 'twi-utensil-knife',
            'twi-utensils' => 'twi-utensils',
            'twi-utensils-alt' => 'twi-utensils-alt',
            'twi-utensil-spoon' => 'twi-utensil-spoon',
            'twi-value-absolute' => 'twi-value-absolute',
            'twi-vector-square' => 'twi-vector-square',
            'twi-venus' => 'twi-venus',
            'twi-venus-double' => 'twi-venus-double',
            'twi-venus-mars' => 'twi-venus-mars',
            'twi-vial' => 'twi-vial',
            'twi-vials' => 'twi-vials',
            'twi-video' => 'twi-video',
            'twi-video-plus' => 'twi-video-plus',
            'twi-video-slash' => 'twi-video-slash',
            'twi-vihara' => 'twi-vihara',
            'twi-volcano' => 'twi-volcano',
            'twi-volleyball-ball' => 'twi-volleyball-ball',
            'twi-volume' => 'twi-volume',
            'twi-volume-down' => 'twi-volume-down',
            'twi-volume-mute' => 'twi-volume-mute',
            'twi-volume-off' => 'twi-volume-off',
            'twi-volume-slash' => 'twi-volume-slash',
            'twi-volume-up' => 'twi-volume-up',
            'twi-vote-nay' => 'twi-vote-nay',
            'twi-vote-yea' => 'twi-vote-yea',
            'twi-vr-cardboard' => 'twi-vr-cardboard',
            'twi-walker' => 'twi-walker',
            'twi-walking' => 'twi-walking',
            'twi-wallet' => 'twi-wallet',
            'twi-wand' => 'twi-wand',
            'twi-wand-magic' => 'twi-wand-magic',
            'twi-warehouse' => 'twi-warehouse',
            'twi-warehouse-alt' => 'twi-warehouse-alt',
            'twi-watch' => 'twi-watch',
            'twi-watch-fitness' => 'twi-watch-fitness',
            'twi-water' => 'twi-water',
            'twi-water-lower' => 'twi-water-lower',
            'twi-water-rise' => 'twi-water-rise',
            'twi-wave-square' => 'twi-wave-square',
            'twi-webcam' => 'twi-webcam',
            'twi-webcam-slash' => 'twi-webcam-slash',
            'twi-weight' => 'twi-weight',
            'twi-weight-hanging' => 'twi-weight-hanging',
            'twi-whale' => 'twi-whale',
            'twi-wheat' => 'twi-wheat',
            'twi-wheelchair' => 'twi-wheelchair',
            'twi-whistle' => 'twi-whistle',
            'twi-wifi' => 'twi-wifi',
            'twi-wifi-1' => 'twi-wifi-1',
            'twi-wifi-2' => 'twi-wifi-2',
            'twi-wifi-slash' => 'twi-wifi-slash',
            'twi-wind' => 'twi-wind',
            'twi-window' => 'twi-window',
            'twi-window-alt' => 'twi-window-alt',
            'twi-window-close' => 'twi-window-close',
            'twi-window-maximize' => 'twi-window-maximize',
            'twi-window-minimize' => 'twi-window-minimize',
            'twi-window-restore' => 'twi-window-restore',
            'twi-windsock' => 'twi-windsock',
            'twi-wind-warning' => 'twi-wind-warning',
            'twi-wine-bottle' => 'twi-wine-bottle',
            'twi-wine-glass' => 'twi-wine-glass',
            'twi-wine-glass-alt' => 'twi-wine-glass-alt',
            'twi-won-sign' => 'twi-won-sign',
            'twi-wreath' => 'twi-wreath',
            'twi-wrench' => 'twi-wrench',
            'twi-x-ray' => 'twi-x-ray',
            'twi-yen-sign' => 'twi-yen-sign',
            'twi-yin-yang' => 'twi-yin-yang',
            'twi-abacus1' => 'twi-abacus1',
            'twi-acorn1' => 'twi-acorn1',
            'twi-ad1' => 'twi-ad1',
            'twi-address-book1' => 'twi-address-book1',
            'twi-address-card1' => 'twi-address-card1',
            'twi-adjust1' => 'twi-adjust1',
            'twi-air-freshener1' => 'twi-air-freshener1',
            'twi-alarm-clock1' => 'twi-alarm-clock1',
            'twi-alicorn1' => 'twi-alicorn1',
            'twi-align-center1' => 'twi-align-center1',
            'twi-align-justify1' => 'twi-align-justify1',
            'twi-align-left1' => 'twi-align-left1',
            'twi-align-right1' => 'twi-align-right1',
            'twi-allergies1' => 'twi-allergies1',
            'twi-ambulance1' => 'twi-ambulance1',
            'twi-american-sign-language-interpreting1' => 'twi-american-sign-language-interpreting1',
            'twi-analytics1' => 'twi-analytics1',
            'twi-anchor1' => 'twi-anchor1',
            'twi-angel1' => 'twi-angel1',
            'twi-angle-double-down1' => 'twi-angle-double-down1',
            'twi-angle-double-left1' => 'twi-angle-double-left1',
            'twi-angle-double-right1' => 'twi-angle-double-right1',
            'twi-angle-double-up1' => 'twi-angle-double-up1',
            'twi-angle-down1' => 'twi-angle-down1',
            'twi-angle-left1' => 'twi-angle-left1',
            'twi-angle-right1' => 'twi-angle-right1',
            'twi-angle-up1' => 'twi-angle-up1',
            'twi-angry1' => 'twi-angry1',
            'twi-ankh1' => 'twi-ankh1',
            'twi-apple-alt1' => 'twi-apple-alt1',
            'twi-apple-crate1' => 'twi-apple-crate1',
            'twi-archive1' => 'twi-archive1',
            'twi-archway1' => 'twi-archway1',
            'twi-arrow-alt-circle-down1' => 'twi-arrow-alt-circle-down1',
            'twi-arrow-alt-circle-left1' => 'twi-arrow-alt-circle-left1',
            'twi-arrow-alt-circle-right1' => 'twi-arrow-alt-circle-right1',
            'twi-arrow-alt-circle-up1' => 'twi-arrow-alt-circle-up1',
            'twi-arrow-alt-down1' => 'twi-arrow-alt-down1',
            'twi-arrow-alt-from-bottom1' => 'twi-arrow-alt-from-bottom1',
            'twi-arrow-alt-from-left1' => 'twi-arrow-alt-from-left1',
            'twi-arrow-alt-from-right1' => 'twi-arrow-alt-from-right1',
            'twi-arrow-alt-from-top1' => 'twi-arrow-alt-from-top1',
            'twi-arrow-alt-left1' => 'twi-arrow-alt-left1',
            'twi-arrow-alt-right1' => 'twi-arrow-alt-right1',
            'twi-arrow-alt-square-down1' => 'twi-arrow-alt-square-down1',
            'twi-arrow-alt-square-left1' => 'twi-arrow-alt-square-left1',
            'twi-arrow-alt-square-right1' => 'twi-arrow-alt-square-right1',
            'twi-arrow-alt-square-up1' => 'twi-arrow-alt-square-up1',
            'twi-arrow-alt-to-bottom1' => 'twi-arrow-alt-to-bottom1',
            'twi-arrow-alt-to-left1' => 'twi-arrow-alt-to-left1',
            'twi-arrow-alt-to-right1' => 'twi-arrow-alt-to-right1',
            'twi-arrow-alt-to-top1' => 'twi-arrow-alt-to-top1',
            'twi-arrow-alt-up1' => 'twi-arrow-alt-up1',
            'twi-arrow-circle-down1' => 'twi-arrow-circle-down1',
            'twi-arrow-circle-left1' => 'twi-arrow-circle-left1',
            'twi-arrow-circle-right1' => 'twi-arrow-circle-right1',
            'twi-arrow-circle-up1' => 'twi-arrow-circle-up1',
            'twi-arrow-down1' => 'twi-arrow-down1',
            'twi-arrow-from-bottom1' => 'twi-arrow-from-bottom1',
            'twi-arrow-from-left1' => 'twi-arrow-from-left1',
            'twi-arrow-from-right1' => 'twi-arrow-from-right1',
            'twi-arrow-from-top1' => 'twi-arrow-from-top1',
            'twi-arrow-left1' => 'twi-arrow-left1',
            'twi-arrow-right1' => 'twi-arrow-right1',
            'twi-arrows1' => 'twi-arrows1',
            'twi-arrows-alt1' => 'twi-arrows-alt1',
            'twi-arrows-alt-h1' => 'twi-arrows-alt-h1',
            'twi-arrows-alt-v1' => 'twi-arrows-alt-v1',
            'twi-arrows-h1' => 'twi-arrows-h1',
            'twi-arrow-square-down1' => 'twi-arrow-square-down1',
            'twi-arrow-square-left1' => 'twi-arrow-square-left1',
            'twi-arrow-square-right1' => 'twi-arrow-square-right1',
            'twi-arrow-square-up1' => 'twi-arrow-square-up1',
            'twi-arrows-v1' => 'twi-arrows-v1',
            'twi-arrow-to-bottom1' => 'twi-arrow-to-bottom1',
            'twi-arrow-to-left1' => 'twi-arrow-to-left1',
            'twi-arrow-to-right1' => 'twi-arrow-to-right1',
            'twi-arrow-to-top1' => 'twi-arrow-to-top1',
            'twi-arrow-up1' => 'twi-arrow-up1',
            'twi-assistive-listening-systems1' => 'twi-assistive-listening-systems1',
            'twi-asterisk1' => 'twi-asterisk1',
            'twi-at1' => 'twi-at1',
            'twi-atlas1' => 'twi-atlas1',
            'twi-atom1' => 'twi-atom1',
            'twi-atom-alt1' => 'twi-atom-alt1',
            'twi-audio-description1' => 'twi-audio-description1',
            'twi-award1' => 'twi-award1',
            'twi-axe1' => 'twi-axe1',
            'twi-axe-battle1' => 'twi-axe-battle1',
            'twi-baby1' => 'twi-baby1',
            'twi-baby-carriage1' => 'twi-baby-carriage1',
            'twi-backpack1' => 'twi-backpack1',
            'twi-backspace1' => 'twi-backspace1',
            'twi-backward1' => 'twi-backward1',
            'twi-bacon1' => 'twi-bacon1',
            'twi-badge1' => 'twi-badge1',
            'twi-badge-check1' => 'twi-badge-check1',
            'twi-badge-dollar1' => 'twi-badge-dollar1',
            'twi-badge-percent1' => 'twi-badge-percent1',
            'twi-badger-honey1' => 'twi-badger-honey1',
            'twi-balance-scale1' => 'twi-balance-scale1',
            'twi-balance-scale-left1' => 'twi-balance-scale-left1',
            'twi-balance-scale-right1' => 'twi-balance-scale-right1',
            'twi-ballot1' => 'twi-ballot1',
            'twi-ballot-check1' => 'twi-ballot-check1',
            'twi-ball-pile1' => 'twi-ball-pile1',
            'twi-ban1' => 'twi-ban1',
            'twi-band-aid1' => 'twi-band-aid1',
            'twi-barcode1' => 'twi-barcode1',
            'twi-barcode-alt1' => 'twi-barcode-alt1',
            'twi-barcode-read1' => 'twi-barcode-read1',
            'twi-barcode-scan1' => 'twi-barcode-scan1',
            'twi-bars1' => 'twi-bars1',
            'twi-baseball1' => 'twi-baseball1',
            'twi-baseball-ball1' => 'twi-baseball-ball1',
            'twi-basketball-ball1' => 'twi-basketball-ball1',
            'twi-basketball-hoop1' => 'twi-basketball-hoop1',
            'twi-bat1' => 'twi-bat1',
            'twi-bath1' => 'twi-bath1',
            'twi-battery-bolt1' => 'twi-battery-bolt1',
            'twi-battery-empty1' => 'twi-battery-empty1',
            'twi-battery-full1' => 'twi-battery-full1',
            'twi-battery-half1' => 'twi-battery-half1',
            'twi-battery-quarter1' => 'twi-battery-quarter1',
            'twi-battery-slash1' => 'twi-battery-slash1',
            'twi-battery-three-quarters1' => 'twi-battery-three-quarters1',
            'twi-bed1' => 'twi-bed1',
            'twi-beer1' => 'twi-beer1',
            'twi-bell1' => 'twi-bell1',
            'twi-bells1' => 'twi-bells1',
            'twi-bell-school1' => 'twi-bell-school1',
            'twi-bell-school-slash1' => 'twi-bell-school-slash1',
            'twi-bell-slash1' => 'twi-bell-slash1',
            'twi-bezier-curve1' => 'twi-bezier-curve1',
            'twi-bible1' => 'twi-bible1',
            'twi-bicycle1' => 'twi-bicycle1',
            'twi-binoculars1' => 'twi-binoculars1',
            'twi-biohazard1' => 'twi-biohazard1',
            'twi-birthday-cake1' => 'twi-birthday-cake1',
            'twi-blanket1' => 'twi-blanket1',
            'twi-blender1' => 'twi-blender1',
            'twi-blender-phone1' => 'twi-blender-phone1',
            'twi-blind1' => 'twi-blind1',
            'twi-blog1' => 'twi-blog1',
            'twi-bold1' => 'twi-bold1',
            'twi-bolt1' => 'twi-bolt1',
            'twi-bomb1' => 'twi-bomb1',
            'twi-bone1' => 'twi-bone1',
            'twi-bone-break1' => 'twi-bone-break1',
            'twi-bong1' => 'twi-bong1',
            'twi-book1' => 'twi-book1',
            'twi-book-alt1' => 'twi-book-alt1',
            'twi-book-dead1' => 'twi-book-dead1',
            'twi-book-heart1' => 'twi-book-heart1',
            'twi-bookmark1' => 'twi-bookmark1',
            'twi-book-medical1' => 'twi-book-medical1',
            'twi-book-open1' => 'twi-book-open1',
            'twi-book-reader1' => 'twi-book-reader1',
            'twi-books1' => 'twi-books1',
            'twi-books-medical1' => 'twi-books-medical1',
            'twi-book-spells1' => 'twi-book-spells1',
            'twi-book-user1' => 'twi-book-user1',
            'twi-boot1' => 'twi-boot1',
            'twi-booth-curtain1' => 'twi-booth-curtain1',
            'twi-bow-arrow1' => 'twi-bow-arrow1',
            'twi-bowling-ball1' => 'twi-bowling-ball1',
            'twi-bowling-pins1' => 'twi-bowling-pins1',
            'twi-box1' => 'twi-box1',
            'twi-box-alt1' => 'twi-box-alt1',
            'twi-box-ballot1' => 'twi-box-ballot1',
            'twi-box-check1' => 'twi-box-check1',
            'twi-boxes1' => 'twi-boxes1',
            'twi-boxes-alt1' => 'twi-boxes-alt1',
            'twi-box-fragile1' => 'twi-box-fragile1',
            'twi-box-full1' => 'twi-box-full1',
            'twi-box-heart1' => 'twi-box-heart1',
            'twi-boxing-glove1' => 'twi-boxing-glove1',
            'twi-box-open1' => 'twi-box-open1',
            'twi-box-up1' => 'twi-box-up1',
            'twi-box-usd1' => 'twi-box-usd1',
            'twi-brackets1' => 'twi-brackets1',
            'twi-brackets-curly1' => 'twi-brackets-curly1',
            'twi-braille1' => 'twi-braille1',
            'twi-brain1' => 'twi-brain1',
            'twi-bread-loaf1' => 'twi-bread-loaf1',
            'twi-bread-slice1' => 'twi-bread-slice1',
            'twi-briefcase1' => 'twi-briefcase1',
            'twi-briefcase-medical1' => 'twi-briefcase-medical1',
            'twi-broadcast-tower1' => 'twi-broadcast-tower1',
            'twi-broom1' => 'twi-broom1',
            'twi-browser1' => 'twi-browser1',
            'twi-brush1' => 'twi-brush1',
            'twi-bug1' => 'twi-bug1',
            'twi-building1' => 'twi-building1',
            'twi-bullhorn1' => 'twi-bullhorn1',
            'twi-bullseye1' => 'twi-bullseye1',
            'twi-bullseye-arrow1' => 'twi-bullseye-arrow1',
            'twi-bullseye-pointer1' => 'twi-bullseye-pointer1',
            'twi-burn1' => 'twi-burn1',
            'twi-burrito1' => 'twi-burrito1',
            'twi-bus1' => 'twi-bus1',
            'twi-bus-alt1' => 'twi-bus-alt1',
            'twi-business-time1' => 'twi-business-time1',
            'twi-bus-school1' => 'twi-bus-school1',
            'twi-cabinet-filing1' => 'twi-cabinet-filing1',
            'twi-calculator1' => 'twi-calculator1',
            'twi-calculator-alt1' => 'twi-calculator-alt1',
            'twi-calendar1' => 'twi-calendar1',
            'twi-calendar-alt1' => 'twi-calendar-alt1',
            'twi-calendar-check1' => 'twi-calendar-check1',
            'twi-calendar-day1' => 'twi-calendar-day1',
            'twi-calendar-edit1' => 'twi-calendar-edit1',
            'twi-calendar-exclamation1' => 'twi-calendar-exclamation1',
            'twi-calendar-minus1' => 'twi-calendar-minus1',
            'twi-calendar-plus1' => 'twi-calendar-plus1',
            'twi-calendar-star1' => 'twi-calendar-star1',
            'twi-calendar-times1' => 'twi-calendar-times1',
            'twi-calendar-week1' => 'twi-calendar-week1',
            'twi-camera1' => 'twi-camera1',
            'twi-camera-alt1' => 'twi-camera-alt1',
            'twi-camera-retro1' => 'twi-camera-retro1',
            'twi-campfire1' => 'twi-campfire1',
            'twi-campground1' => 'twi-campground1',
            'twi-candle-holder1' => 'twi-candle-holder1',
            'twi-candy-cane1' => 'twi-candy-cane1',
            'twi-candy-corn1' => 'twi-candy-corn1',
            'twi-cannabis1' => 'twi-cannabis1',
            'twi-capsules1' => 'twi-capsules1',
            'twi-car1' => 'twi-car1',
            'twi-car-alt1' => 'twi-car-alt1',
            'twi-car-battery1' => 'twi-car-battery1',
            'twi-car-bump1' => 'twi-car-bump1',
            'twi-car-crash1' => 'twi-car-crash1',
            'twi-caret-circle-down1' => 'twi-caret-circle-down1',
            'twi-caret-circle-left1' => 'twi-caret-circle-left1',
            'twi-caret-circle-right1' => 'twi-caret-circle-right1',
            'twi-caret-circle-up1' => 'twi-caret-circle-up1',
            'twi-caret-down1' => 'twi-caret-down1',
            'twi-caret-left1' => 'twi-caret-left1',
            'twi-caret-right1' => 'twi-caret-right1',
            'twi-caret-square-down1' => 'twi-caret-square-down1',
            'twi-caret-square-left1' => 'twi-caret-square-left1',
            'twi-caret-square-right1' => 'twi-caret-square-right1',
            'twi-caret-square-up1' => 'twi-caret-square-up1',
            'twi-caret-up1' => 'twi-caret-up1',
            'twi-car-garage1' => 'twi-car-garage1',
            'twi-car-mechanic1' => 'twi-car-mechanic1',
            'twi-carrot1' => 'twi-carrot1',
            'twi-car-side1' => 'twi-car-side1',
            'twi-cart-arrow-down1' => 'twi-cart-arrow-down1',
            'twi-car-tilt1' => 'twi-car-tilt1',
            'twi-cart-plus1' => 'twi-cart-plus1',
            'twi-car-wash1' => 'twi-car-wash1',
            'twi-cash-register1' => 'twi-cash-register1',
            'twi-cat1' => 'twi-cat1',
            'twi-cauldron1' => 'twi-cauldron1',
            'twi-certificate1' => 'twi-certificate1',
            'twi-chair1' => 'twi-chair1',
            'twi-chair-office1' => 'twi-chair-office1',
            'twi-chalkboard1' => 'twi-chalkboard1',
            'twi-chalkboard-teacher1' => 'twi-chalkboard-teacher1',
            'twi-charging-station1' => 'twi-charging-station1',
            'twi-chart-area1' => 'twi-chart-area1',
            'twi-chart-bar1' => 'twi-chart-bar1',
            'twi-chart-line1' => 'twi-chart-line1',
            'twi-chart-line-down1' => 'twi-chart-line-down1',
            'twi-chart-network1' => 'twi-chart-network1',
            'twi-chart-pie1' => 'twi-chart-pie1',
            'twi-chart-pie-alt1' => 'twi-chart-pie-alt1',
            'twi-chart-scatter1' => 'twi-chart-scatter1',
            'twi-check1' => 'twi-check1',
            'twi-check-circle1' => 'twi-check-circle1',
            'twi-check-double1' => 'twi-check-double1',
            'twi-check-square1' => 'twi-check-square1',
            'twi-cheese1' => 'twi-cheese1',
            'twi-cheeseburger1' => 'twi-cheeseburger1',
            'twi-cheese-swiss1' => 'twi-cheese-swiss1',
            'twi-chess1' => 'twi-chess1',
            'twi-chess-bishop1' => 'twi-chess-bishop1',
            'twi-chess-bishop-alt1' => 'twi-chess-bishop-alt1',
            'twi-chess-board1' => 'twi-chess-board1',
            'twi-chess-clock1' => 'twi-chess-clock1',
            'twi-chess-clock-alt1' => 'twi-chess-clock-alt1',
            'twi-chess-king1' => 'twi-chess-king1',
            'twi-chess-king-alt1' => 'twi-chess-king-alt1',
            'twi-chess-knight1' => 'twi-chess-knight1',
            'twi-chess-knight-alt1' => 'twi-chess-knight-alt1',
            'twi-chess-pawn1' => 'twi-chess-pawn1',
            'twi-chess-pawn-alt1' => 'twi-chess-pawn-alt1',
            'twi-chess-queen1' => 'twi-chess-queen1',
            'twi-chess-queen-alt1' => 'twi-chess-queen-alt1',
            'twi-chess-rook1' => 'twi-chess-rook1',
            'twi-chess-rook-alt1' => 'twi-chess-rook-alt1',
            'twi-chevron-circle-down1' => 'twi-chevron-circle-down1',
            'twi-chevron-circle-left1' => 'twi-chevron-circle-left1',
            'twi-chevron-circle-right1' => 'twi-chevron-circle-right1',
            'twi-chevron-circle-up1' => 'twi-chevron-circle-up1',
            'twi-chevron-double-down1' => 'twi-chevron-double-down1',
            'twi-chevron-double-left1' => 'twi-chevron-double-left1',
            'twi-chevron-double-right1' => 'twi-chevron-double-right1',
            'twi-chevron-double-up1' => 'twi-chevron-double-up1',
            'twi-chevron-down1' => 'twi-chevron-down1',
            'twi-chevron-left1' => 'twi-chevron-left1',
            'twi-chevron-right1' => 'twi-chevron-right1',
            'twi-chevron-square-down1' => 'twi-chevron-square-down1',
            'twi-chevron-square-left1' => 'twi-chevron-square-left1',
            'twi-chevron-square-right1' => 'twi-chevron-square-right1',
            'twi-chevron-square-up1' => 'twi-chevron-square-up1',
            'twi-chevron-up1' => 'twi-chevron-up1',
            'twi-child1' => 'twi-child1',
            'twi-chimney1' => 'twi-chimney1',
            'twi-church1' => 'twi-church1',
            'twi-circle1' => 'twi-circle1',
            'twi-circle-notch1' => 'twi-circle-notch1',
            'twi-city1' => 'twi-city1',
            'twi-claw-marks1' => 'twi-claw-marks1',
            'twi-clinic-medical1' => 'twi-clinic-medical1',
            'twi-clipboard1' => 'twi-clipboard1',
            'twi-clipboard-check1' => 'twi-clipboard-check1',
            'twi-clipboard-list1' => 'twi-clipboard-list1',
            'twi-clipboard-list-check1' => 'twi-clipboard-list-check1',
            'twi-clipboard-prescription1' => 'twi-clipboard-prescription1',
            'twi-clipboard-user1' => 'twi-clipboard-user1',
            'twi-clock1' => 'twi-clock1',
            'twi-clone1' => 'twi-clone1',
            'twi-closed-captioning1' => 'twi-closed-captioning1',
            'twi-cloud1' => 'twi-cloud1',
            'twi-cloud-download1' => 'twi-cloud-download1',
            'twi-cloud-download-alt1' => 'twi-cloud-download-alt1',
            'twi-cloud-drizzle1' => 'twi-cloud-drizzle1',
            'twi-cloud-hail1' => 'twi-cloud-hail1',
            'twi-cloud-hail-mixed1' => 'twi-cloud-hail-mixed1',
            'twi-cloud-meatball1' => 'twi-cloud-meatball1',
            'twi-cloud-moon1' => 'twi-cloud-moon1',
            'twi-cloud-moon-rain1' => 'twi-cloud-moon-rain1',
            'twi-cloud-rain1' => 'twi-cloud-rain1',
            'twi-cloud-rainbow1' => 'twi-cloud-rainbow1',
            'twi-clouds1' => 'twi-clouds1',
            'twi-cloud-showers1' => 'twi-cloud-showers1',
            'twi-cloud-showers-heavy1' => 'twi-cloud-showers-heavy1',
            'twi-cloud-sleet1' => 'twi-cloud-sleet1',
            'twi-clouds-moon1' => 'twi-clouds-moon1',
            'twi-cloud-snow1' => 'twi-cloud-snow1',
            'twi-clouds-sun1' => 'twi-clouds-sun1',
            'twi-cloud-sun1' => 'twi-cloud-sun1',
            'twi-cloud-sun-rain1' => 'twi-cloud-sun-rain1',
            'twi-cloud-upload1' => 'twi-cloud-upload1',
            'twi-cloud-upload-alt1' => 'twi-cloud-upload-alt1',
            'twi-club1' => 'twi-club1',
            'twi-cocktail1' => 'twi-cocktail1',
            'twi-code1' => 'twi-code1',
            'twi-code-branch1' => 'twi-code-branch1',
            'twi-code-commit1' => 'twi-code-commit1',
            'twi-code-merge1' => 'twi-code-merge1',
            'twi-coffee1' => 'twi-coffee1',
            'twi-coffee-togo1' => 'twi-coffee-togo1',
            'twi-coffin1' => 'twi-coffin1',
            'twi-cog1' => 'twi-cog1',
            'twi-cogs1' => 'twi-cogs1',
            'twi-coins1' => 'twi-coins1',
            'twi-columns1' => 'twi-columns1',
            'twi-comment1' => 'twi-comment1',
            'twi-comment-alt1' => 'twi-comment-alt1',
            'twi-comment-alt-check1' => 'twi-comment-alt-check1',
            'twi-comment-alt-dollar1' => 'twi-comment-alt-dollar1',
            'twi-comment-alt-dots1' => 'twi-comment-alt-dots1',
            'twi-comment-alt-edit1' => 'twi-comment-alt-edit1',
            'twi-comment-alt-exclamation1' => 'twi-comment-alt-exclamation1',
            'twi-comment-alt-lines1' => 'twi-comment-alt-lines1',
            'twi-comment-alt-medical1' => 'twi-comment-alt-medical1',
            'twi-comment-alt-minus1' => 'twi-comment-alt-minus1',
            'twi-comment-alt-plus1' => 'twi-comment-alt-plus1',
            'twi-comment-alt-slash1' => 'twi-comment-alt-slash1',
            'twi-comment-alt-smile1' => 'twi-comment-alt-smile1',
            'twi-comment-alt-times1' => 'twi-comment-alt-times1',
            'twi-comment-check1' => 'twi-comment-check1',
            'twi-comment-dollar1' => 'twi-comment-dollar1',
            'twi-comment-dots1' => 'twi-comment-dots1',
            'twi-comment-edit1' => 'twi-comment-edit1',
            'twi-comment-exclamation1' => 'twi-comment-exclamation1',
            'twi-comment-lines1' => 'twi-comment-lines1',
            'twi-comment-medical1' => 'twi-comment-medical1',
            'twi-comment-minus1' => 'twi-comment-minus1',
            'twi-comment-plus1' => 'twi-comment-plus1',
            'twi-comments1' => 'twi-comments1',
            'twi-comments-alt1' => 'twi-comments-alt1',
            'twi-comments-alt-dollar1' => 'twi-comments-alt-dollar1',
            'twi-comments-dollar1' => 'twi-comments-dollar1',
            'twi-comment-slash1' => 'twi-comment-slash1',
            'twi-comment-smile1' => 'twi-comment-smile1',
            'twi-comment-times1' => 'twi-comment-times1',
            'twi-compact-disc1' => 'twi-compact-disc1',
            'twi-compass1' => 'twi-compass1',
            'twi-compass-slash1' => 'twi-compass-slash1',
            'twi-compress1' => 'twi-compress1',
            'twi-compress-alt1' => 'twi-compress-alt1',
            'twi-compress-arrows-alt1' => 'twi-compress-arrows-alt1',
            'twi-compress-wide1' => 'twi-compress-wide1',
            'twi-concierge-bell1' => 'twi-concierge-bell1',
            'twi-container-storage1' => 'twi-container-storage1',
            'twi-conveyor-belt1' => 'twi-conveyor-belt1',
            'twi-conveyor-belt-alt1' => 'twi-conveyor-belt-alt1',
            'twi-cookie1' => 'twi-cookie1',
            'twi-cookie-bite1' => 'twi-cookie-bite1',
            'twi-copy1' => 'twi-copy1',
            'twi-copyright1' => 'twi-copyright1',
            'twi-corn1' => 'twi-corn1',
            'twi-couch1' => 'twi-couch1',
            'twi-cow1' => 'twi-cow1',
            'twi-credit-card1' => 'twi-credit-card1',
            'twi-credit-card-blank1' => 'twi-credit-card-blank1',
            'twi-credit-card-front1' => 'twi-credit-card-front1',
            'twi-cricket1' => 'twi-cricket1',
            'twi-croissant1' => 'twi-croissant1',
            'twi-crop1' => 'twi-crop1',
            'twi-crop-alt1' => 'twi-crop-alt1',
            'twi-cross1' => 'twi-cross1',
            'twi-crosshairs1' => 'twi-crosshairs1',
            'twi-crow1' => 'twi-crow1',
            'twi-crown1' => 'twi-crown1',
            'twi-crutch1' => 'twi-crutch1',
            'twi-crutches1' => 'twi-crutches1',
            'twi-cube1' => 'twi-cube1',
            'twi-cubes1' => 'twi-cubes1',
            'twi-curling1' => 'twi-curling1',
            'twi-cut1' => 'twi-cut1',
            'twi-dagger1' => 'twi-dagger1',
            'twi-database1' => 'twi-database1',
            'twi-deaf1' => 'twi-deaf1',
            'twi-debug1' => 'twi-debug1',
            'twi-deer1' => 'twi-deer1',
            'twi-deer-rudolph1' => 'twi-deer-rudolph1',
            'twi-democrat1' => 'twi-democrat1',
            'twi-desktop1' => 'twi-desktop1',
            'twi-desktop-alt1' => 'twi-desktop-alt1',
            'twi-dewpoint1' => 'twi-dewpoint1',
            'twi-dharmachakra1' => 'twi-dharmachakra1',
            'twi-diagnoses1' => 'twi-diagnoses1',
            'twi-diamond1' => 'twi-diamond1',
            'twi-dice1' => 'twi-dice1',
            'twi-dice-d41' => 'twi-dice-d41',
            'twi-dice-d61' => 'twi-dice-d61',
            'twi-dice-d81' => 'twi-dice-d81',
            'twi-dice-d101' => 'twi-dice-d101',
            'twi-dice-d121' => 'twi-dice-d121',
            'twi-dice-d201' => 'twi-dice-d201',
            'twi-dice-five1' => 'twi-dice-five1',
            'twi-dice-four1' => 'twi-dice-four1',
            'twi-dice-one1' => 'twi-dice-one1',
            'twi-dice-six1' => 'twi-dice-six1',
            'twi-dice-three1' => 'twi-dice-three1',
            'twi-dice-two1' => 'twi-dice-two1',
            'twi-digital-tachograph1' => 'twi-digital-tachograph1',
            'twi-diploma1' => 'twi-diploma1',
            'twi-directions1' => 'twi-directions1',
            'twi-disease1' => 'twi-disease1',
            'twi-divide1' => 'twi-divide1',
            'twi-dizzy1' => 'twi-dizzy1',
            'twi-dna1' => 'twi-dna1',
            'twi-dog1' => 'twi-dog1',
            'twi-dog-leashed1' => 'twi-dog-leashed1',
            'twi-dollar-sign1' => 'twi-dollar-sign1',
            'twi-dolly1' => 'twi-dolly1',
            'twi-dolly-empty1' => 'twi-dolly-empty1',
            'twi-dolly-flatbed1' => 'twi-dolly-flatbed1',
            'twi-dolly-flatbed-alt1' => 'twi-dolly-flatbed-alt1',
            'twi-dolly-flatbed-empty1' => 'twi-dolly-flatbed-empty1',
            'twi-donate1' => 'twi-donate1',
            'twi-do-not-enter1' => 'twi-do-not-enter1',
            'twi-door-closed1' => 'twi-door-closed1',
            'twi-door-open1' => 'twi-door-open1',
            'twi-dot-circle1' => 'twi-dot-circle1',
            'twi-dove1' => 'twi-dove1',
            'twi-download1' => 'twi-download1',
            'twi-drafting-compass1' => 'twi-drafting-compass1',
            'twi-dragon1' => 'twi-dragon1',
            'twi-draw-circle1' => 'twi-draw-circle1',
            'twi-draw-polygon1' => 'twi-draw-polygon1',
            'twi-draw-square1' => 'twi-draw-square1',
            'twi-dreidel1' => 'twi-dreidel1',
            'twi-drum1' => 'twi-drum1',
            'twi-drum-steelpan1' => 'twi-drum-steelpan1',
            'twi-drumstick1' => 'twi-drumstick1',
            'twi-drumstick-bite1' => 'twi-drumstick-bite1',
            'twi-duck1' => 'twi-duck1',
            'twi-dumbbell1' => 'twi-dumbbell1',
            'twi-dumpster1' => 'twi-dumpster1',
            'twi-dumpster-fire1' => 'twi-dumpster-fire1',
            'twi-dungeon1' => 'twi-dungeon1',
            'twi-ear1' => 'twi-ear1',
            'twi-ear-muffs1' => 'twi-ear-muffs1',
            'twi-eclipse1' => 'twi-eclipse1',
            'twi-eclipse-alt1' => 'twi-eclipse-alt1',
            'twi-edit1' => 'twi-edit1',
            'twi-egg1' => 'twi-egg1',
            'twi-egg-fried1' => 'twi-egg-fried1',
            'twi-eject1' => 'twi-eject1',
            'twi-elephant1' => 'twi-elephant1',
            'twi-ellipsis-h1' => 'twi-ellipsis-h1',
            'twi-ellipsis-h-alt1' => 'twi-ellipsis-h-alt1',
            'twi-ellipsis-v1' => 'twi-ellipsis-v1',
            'twi-ellipsis-v-alt1' => 'twi-ellipsis-v-alt1',
            'twi-empty-set1' => 'twi-empty-set1',
            'twi-engine-warning1' => 'twi-engine-warning1',
            'twi-envelope1' => 'twi-envelope1',
            'twi-envelope-open1' => 'twi-envelope-open1',
            'twi-envelope-open-dollar1' => 'twi-envelope-open-dollar1',
            'twi-envelope-open-text1' => 'twi-envelope-open-text1',
            'twi-envelope-square1' => 'twi-envelope-square1',
            'twi-equals1' => 'twi-equals1',
            'twi-eraser1' => 'twi-eraser1',
            'twi-ethernet1' => 'twi-ethernet1',
            'twi-euro-sign1' => 'twi-euro-sign1',
            'twi-exchange1' => 'twi-exchange1',
            'twi-exchange-alt1' => 'twi-exchange-alt1',
            'twi-exclamation1' => 'twi-exclamation1',
            'twi-exclamation-circle1' => 'twi-exclamation-circle1',
            'twi-exclamation-square1' => 'twi-exclamation-square1',
            'twi-exclamation-triangle1' => 'twi-exclamation-triangle1',
            'twi-expand1' => 'twi-expand1',
            'twi-expand-alt1' => 'twi-expand-alt1',
            'twi-expand-arrows1' => 'twi-expand-arrows1',
            'twi-expand-arrows-alt1' => 'twi-expand-arrows-alt1',
            'twi-expand-wide1' => 'twi-expand-wide1',
            'twi-external-link1' => 'twi-external-link1',
            'twi-external-link-alt1' => 'twi-external-link-alt1',
            'twi-external-link-square1' => 'twi-external-link-square1',
            'twi-external-link-square-alt1' => 'twi-external-link-square-alt1',
            'twi-eye1' => 'twi-eye1',
            'twi-eye-dropper1' => 'twi-eye-dropper1',
            'twi-eye-evil1' => 'twi-eye-evil1',
            'twi-eye-slash1' => 'twi-eye-slash1',
            'twi-fast-backward1' => 'twi-fast-backward1',
            'twi-fast-forward1' => 'twi-fast-forward1',
            'twi-fax1' => 'twi-fax1',
            'twi-feather1' => 'twi-feather1',
            'twi-feather-alt1' => 'twi-feather-alt1',
            'twi-female1' => 'twi-female1',
            'twi-field-hockey1' => 'twi-field-hockey1',
            'twi-fighter-jet1' => 'twi-fighter-jet1',
            'twi-file1' => 'twi-file1',
            'twi-file-alt1' => 'twi-file-alt1',
            'twi-file-archive1' => 'twi-file-archive1',
            'twi-file-audio1' => 'twi-file-audio1',
            'twi-file-certificate1' => 'twi-file-certificate1',
            'twi-file-chart-line1' => 'twi-file-chart-line1',
            'twi-file-chart-pie1' => 'twi-file-chart-pie1',
            'twi-file-check1' => 'twi-file-check1',
            'twi-file-code1' => 'twi-file-code1',
            'twi-file-contract1' => 'twi-file-contract1',
            'twi-file-csv1' => 'twi-file-csv1',
            'twi-file-download1' => 'twi-file-download1',
            'twi-file-edit1' => 'twi-file-edit1',
            'twi-file-excel1' => 'twi-file-excel1',
            'twi-file-exclamation1' => 'twi-file-exclamation1',
            'twi-file-export1' => 'twi-file-export1',
            'twi-file-image1' => 'twi-file-image1',
            'twi-file-import1' => 'twi-file-import1',
            'twi-file-invoice1' => 'twi-file-invoice1',
            'twi-file-invoice-dollar1' => 'twi-file-invoice-dollar1',
            'twi-file-medical1' => 'twi-file-medical1',
            'twi-file-medical-alt1' => 'twi-file-medical-alt1',
            'twi-file-minus1' => 'twi-file-minus1',
            'twi-file-pdf1' => 'twi-file-pdf1',
            'twi-file-plus1' => 'twi-file-plus1',
            'twi-file-powerpoint1' => 'twi-file-powerpoint1',
            'twi-file-prescription1' => 'twi-file-prescription1',
            'twi-file-signature1' => 'twi-file-signature1',
            'twi-files-medical1' => 'twi-files-medical1',
            'twi-file-spreadsheet1' => 'twi-file-spreadsheet1',
            'twi-file-times1' => 'twi-file-times1',
            'twi-file-upload1' => 'twi-file-upload1',
            'twi-file-user1' => 'twi-file-user1',
            'twi-file-video1' => 'twi-file-video1',
            'twi-file-word1' => 'twi-file-word1',
            'twi-fill1' => 'twi-fill1',
            'twi-fill-drip1' => 'twi-fill-drip1',
            'twi-film1' => 'twi-film1',
            'twi-film-alt1' => 'twi-film-alt1',
            'twi-filter1' => 'twi-filter1',
            'twi-fingerprint1' => 'twi-fingerprint1',
            'twi-fire1' => 'twi-fire1',
            'twi-fire-alt1' => 'twi-fire-alt1',
            'twi-fire-extinguisher1' => 'twi-fire-extinguisher1',
            'twi-fireplace1' => 'twi-fireplace1',
            'twi-fire-smoke1' => 'twi-fire-smoke1',
            'twi-first-aid1' => 'twi-first-aid1',
            'twi-fish1' => 'twi-fish1',
            'twi-fish-cooked1' => 'twi-fish-cooked1',
            'twi-fist-raised1' => 'twi-fist-raised1',
            'twi-flag1' => 'twi-flag1',
            'twi-flag-alt1' => 'twi-flag-alt1',
            'twi-flag-checkered1' => 'twi-flag-checkered1',
            'twi-flag-usa1' => 'twi-flag-usa1',
            'twi-flame1' => 'twi-flame1',
            'twi-flask1' => 'twi-flask1',
            'twi-flask-poison1' => 'twi-flask-poison1',
            'twi-flask-potion1' => 'twi-flask-potion1',
            'twi-flower1' => 'twi-flower1',
            'twi-flower-daffodil1' => 'twi-flower-daffodil1',
            'twi-flower-tulip1' => 'twi-flower-tulip1',
            'twi-flushed1' => 'twi-flushed1',
            'twi-fog1' => 'twi-fog1',
            'twi-folder1' => 'twi-folder1',
            'twi-folder-minus1' => 'twi-folder-minus1',
            'twi-folder-open1' => 'twi-folder-open1',
            'twi-folder-plus1' => 'twi-folder-plus1',
            'twi-folders1' => 'twi-folders1',
            'twi-folder-times1' => 'twi-folder-times1',
            'twi-folder-tree1' => 'twi-folder-tree1',
            'twi-font1' => 'twi-font1',
            'twi-font-awesome-logo-full1' => 'twi-font-awesome-logo-full1',
            'twi-football-ball1' => 'twi-football-ball1',
            'twi-football-helmet1' => 'twi-football-helmet1',
            'twi-forklift1' => 'twi-forklift1',
            'twi-forward1' => 'twi-forward1',
            'twi-fragile1' => 'twi-fragile1',
            'twi-french-fries1' => 'twi-french-fries1',
            'twi-frog1' => 'twi-frog1',
            'twi-frosty-head1' => 'twi-frosty-head1',
            'twi-frown1' => 'twi-frown1',
            'twi-frown-open1' => 'twi-frown-open1',
            'twi-function1' => 'twi-function1',
            'twi-funnel-dollar1' => 'twi-funnel-dollar1',
            'twi-futbol1' => 'twi-futbol1',
            'twi-gamepad1' => 'twi-gamepad1',
            'twi-gas-pump1' => 'twi-gas-pump1',
            'twi-gas-pump-slash1' => 'twi-gas-pump-slash1',
            'twi-gavel1' => 'twi-gavel1',
            'twi-gem1' => 'twi-gem1',
            'twi-genderless1' => 'twi-genderless1',
            'twi-ghost1' => 'twi-ghost1',
            'twi-gift1' => 'twi-gift1',
            'twi-gift-card1' => 'twi-gift-card1',
            'twi-gifts1' => 'twi-gifts1',
            'twi-gingerbread-man1' => 'twi-gingerbread-man1',
            'twi-glass1' => 'twi-glass1',
            'twi-glass-champagne1' => 'twi-glass-champagne1',
            'twi-glass-cheers1' => 'twi-glass-cheers1',
            'twi-glasses1' => 'twi-glasses1',
            'twi-glasses-alt1' => 'twi-glasses-alt1',
            'twi-glass-martini1' => 'twi-glass-martini1',
            'twi-glass-martini-alt1' => 'twi-glass-martini-alt1',
            'twi-glass-whiskey1' => 'twi-glass-whiskey1',
            'twi-glass-whiskey-rocks1' => 'twi-glass-whiskey-rocks1',
            'twi-globe1' => 'twi-globe1',
            'twi-globe-africa1' => 'twi-globe-africa1',
            'twi-globe-americas1' => 'twi-globe-americas1',
            'twi-globe-asia1' => 'twi-globe-asia1',
            'twi-globe-europe1' => 'twi-globe-europe1',
            'twi-globe-snow1' => 'twi-globe-snow1',
            'twi-globe-stand1' => 'twi-globe-stand1',
            'twi-golf-ball1' => 'twi-golf-ball1',
            'twi-golf-club1' => 'twi-golf-club1',
            'twi-gopuram1' => 'twi-gopuram1',
            'twi-graduation-cap1' => 'twi-graduation-cap1',
            'twi-greater-than1' => 'twi-greater-than1',
            'twi-greater-than-equal1' => 'twi-greater-than-equal1',
            'twi-grimace1' => 'twi-grimace1',
            'twi-grin1' => 'twi-grin1',
            'twi-grin-alt1' => 'twi-grin-alt1',
            'twi-grin-beam1' => 'twi-grin-beam1',
            'twi-grin-beam-sweat1' => 'twi-grin-beam-sweat1',
            'twi-grin-hearts1' => 'twi-grin-hearts1',
            'twi-grin-squint1' => 'twi-grin-squint1',
            'twi-grin-squint-tears1' => 'twi-grin-squint-tears1',
            'twi-grin-stars1' => 'twi-grin-stars1',
            'twi-grin-tears1' => 'twi-grin-tears1',
            'twi-grin-tongue1' => 'twi-grin-tongue1',
            'twi-grin-tongue-squint1' => 'twi-grin-tongue-squint1',
            'twi-grin-tongue-wink1' => 'twi-grin-tongue-wink1',
            'twi-grin-wink1' => 'twi-grin-wink1',
            'twi-grip-horizontal1' => 'twi-grip-horizontal1',
            'twi-grip-lines1' => 'twi-grip-lines1',
            'twi-grip-lines-vertical1' => 'twi-grip-lines-vertical1',
            'twi-grip-vertical1' => 'twi-grip-vertical1',
            'twi-guitar1' => 'twi-guitar1',
            'twi-h11' => 'twi-h11',
            'twi-h21' => 'twi-h21',
            'twi-h31' => 'twi-h31',
            'twi-hamburger1' => 'twi-hamburger1',
            'twi-hammer1' => 'twi-hammer1',
            'twi-hammer-war1' => 'twi-hammer-war1',
            'twi-hamsa1' => 'twi-hamsa1',
            'twi-hand-heart1' => 'twi-hand-heart1',
            'twi-hand-holding1' => 'twi-hand-holding1',
            'twi-hand-holding-box1' => 'twi-hand-holding-box1',
            'twi-hand-holding-heart1' => 'twi-hand-holding-heart1',
            'twi-hand-holding-magic1' => 'twi-hand-holding-magic1',
            'twi-hand-holding-seedling1' => 'twi-hand-holding-seedling1',
            'twi-hand-holding-usd1' => 'twi-hand-holding-usd1',
            'twi-hand-holding-water1' => 'twi-hand-holding-water1',
            'twi-hand-lizard1' => 'twi-hand-lizard1',
            'twi-hand-middle-finger1' => 'twi-hand-middle-finger1',
            'twi-hand-paper1' => 'twi-hand-paper1',
            'twi-hand-peace1' => 'twi-hand-peace1',
            'twi-hand-point-down1' => 'twi-hand-point-down1',
            'twi-hand-pointer1' => 'twi-hand-pointer1',
            'twi-hand-point-left1' => 'twi-hand-point-left1',
            'twi-hand-point-right1' => 'twi-hand-point-right1',
            'twi-hand-point-up1' => 'twi-hand-point-up1',
            'twi-hand-receiving1' => 'twi-hand-receiving1',
            'twi-hand-rock1' => 'twi-hand-rock1',
            'twi-hands1' => 'twi-hands1',
            'twi-hand-scissors1' => 'twi-hand-scissors1',
            'twi-handshake1' => 'twi-handshake1',
            'twi-handshake-alt1' => 'twi-handshake-alt1',
            'twi-hands-heart1' => 'twi-hands-heart1',
            'twi-hands-helping1' => 'twi-hands-helping1',
            'twi-hand-spock1' => 'twi-hand-spock1',
            'twi-hands-usd1' => 'twi-hands-usd1',
            'twi-hanukiah1' => 'twi-hanukiah1',
            'twi-hard-hat1' => 'twi-hard-hat1',
            'twi-hashtag1' => 'twi-hashtag1',
            'twi-hat-santa1' => 'twi-hat-santa1',
            'twi-hat-winter1' => 'twi-hat-winter1',
            'twi-hat-witch1' => 'twi-hat-witch1',
            'twi-hat-wizard1' => 'twi-hat-wizard1',
            'twi-haykal1' => 'twi-haykal1',
            'twi-hdd1' => 'twi-hdd1',
            'twi-heading1' => 'twi-heading1',
            'twi-headphones1' => 'twi-headphones1',
            'twi-headphones-alt1' => 'twi-headphones-alt1',
            'twi-headset1' => 'twi-headset1',
            'twi-head-side1' => 'twi-head-side1',
            'twi-head-side-brain1' => 'twi-head-side-brain1',
            'twi-head-side-medical1' => 'twi-head-side-medical1',
            'twi-head-vr1' => 'twi-head-vr1',
            'twi-heart1' => 'twi-heart1',
            'twi-heartbeat1' => 'twi-heartbeat1',
            'twi-heart-broken1' => 'twi-heart-broken1',
            'twi-heart-circle1' => 'twi-heart-circle1',
            'twi-heart-rate1' => 'twi-heart-rate1',
            'twi-heart-square1' => 'twi-heart-square1',
            'twi-helicopter1' => 'twi-helicopter1',
            'twi-helmet-battle1' => 'twi-helmet-battle1',
            'twi-hexagon1' => 'twi-hexagon1',
            'twi-highlighter1' => 'twi-highlighter1',
            'twi-hiking1' => 'twi-hiking1',
            'twi-hippo1' => 'twi-hippo1',
            'twi-history1' => 'twi-history1',
            'twi-hockey-mask1' => 'twi-hockey-mask1',
            'twi-hockey-puck1' => 'twi-hockey-puck1',
            'twi-hockey-sticks1' => 'twi-hockey-sticks1',
            'twi-holly-berry1' => 'twi-holly-berry1',
            'twi-home1' => 'twi-home1',
            'twi-home-alt1' => 'twi-home-alt1',
            'twi-home-heart1' => 'twi-home-heart1',
            'twi-home-lg1' => 'twi-home-lg1',
            'twi-home-lg-alt1' => 'twi-home-lg-alt1',
            'twi-hood-cloak1' => 'twi-hood-cloak1',
            'twi-horse1' => 'twi-horse1',
            'twi-horse-head1' => 'twi-horse-head1',
            'twi-hospital1' => 'twi-hospital1',
            'twi-hospital-alt1' => 'twi-hospital-alt1',
            'twi-hospitals1' => 'twi-hospitals1',
            'twi-hospital-symbol1' => 'twi-hospital-symbol1',
            'twi-hospital-user1' => 'twi-hospital-user1',
            'twi-hotdog1' => 'twi-hotdog1',
            'twi-hotel1' => 'twi-hotel1',
            'twi-hot-tub1' => 'twi-hot-tub1',
            'twi-hourglass1' => 'twi-hourglass1',
            'twi-hourglass-end1' => 'twi-hourglass-end1',
            'twi-hourglass-half1' => 'twi-hourglass-half1',
            'twi-hourglass-start1' => 'twi-hourglass-start1',
            'twi-house-damage1' => 'twi-house-damage1',
            'twi-house-flood1' => 'twi-house-flood1',
            'twi-hryvnia1' => 'twi-hryvnia1',
            'twi-h-square1' => 'twi-h-square1',
            'twi-humidity1' => 'twi-humidity1',
            'twi-hurricane1' => 'twi-hurricane1',
            'twi-ice-cream1' => 'twi-ice-cream1',
            'twi-ice-skate1' => 'twi-ice-skate1',
            'twi-icicles1' => 'twi-icicles1',
            'twi-i-cursor1' => 'twi-i-cursor1',
            'twi-id-badge1' => 'twi-id-badge1',
            'twi-id-card1' => 'twi-id-card1',
            'twi-id-card-alt1' => 'twi-id-card-alt1',
            'twi-igloo1' => 'twi-igloo1',
            'twi-image1' => 'twi-image1',
            'twi-images1' => 'twi-images1',
            'twi-inbox1' => 'twi-inbox1',
            'twi-inbox-in1' => 'twi-inbox-in1',
            'twi-inbox-out1' => 'twi-inbox-out1',
            'twi-indent1' => 'twi-indent1',
            'twi-industry1' => 'twi-industry1',
            'twi-industry-alt1' => 'twi-industry-alt1',
            'twi-infinity1' => 'twi-infinity1',
            'twi-info1' => 'twi-info1',
            'twi-info-circle1' => 'twi-info-circle1',
            'twi-info-square1' => 'twi-info-square1',
            'twi-inhaler1' => 'twi-inhaler1',
            'twi-integral1' => 'twi-integral1',
            'twi-intersection1' => 'twi-intersection1',
            'twi-inventory1' => 'twi-inventory1',
            'twi-island-tropical1' => 'twi-island-tropical1',
            'twi-italic1' => 'twi-italic1',
            'twi-jack-o-lantern1' => 'twi-jack-o-lantern1',
            'twi-jedi1' => 'twi-jedi1',
            'twi-joint1' => 'twi-joint1',
            'twi-journal-whills1' => 'twi-journal-whills1',
            'twi-kaaba1' => 'twi-kaaba1',
            'twi-key1' => 'twi-key1',
            'twi-keyboard1' => 'twi-keyboard1',
            'twi-keynote1' => 'twi-keynote1',
            'twi-key-skeleton1' => 'twi-key-skeleton1',
            'twi-khanda1' => 'twi-khanda1',
            'twi-kidneys1' => 'twi-kidneys1',
            'twi-kiss1' => 'twi-kiss1',
            'twi-kiss-beam1' => 'twi-kiss-beam1',
            'twi-kiss-wink-heart1' => 'twi-kiss-wink-heart1',
            'twi-kite1' => 'twi-kite1',
            'twi-kiwi-bird1' => 'twi-kiwi-bird1',
            'twi-knife-kitchen1' => 'twi-knife-kitchen1',
            'twi-lambda1' => 'twi-lambda1',
            'twi-lamp1' => 'twi-lamp1',
            'twi-landmark1' => 'twi-landmark1',
            'twi-landmark-alt1' => 'twi-landmark-alt1',
            'twi-language1' => 'twi-language1',
            'twi-laptop1' => 'twi-laptop1',
            'twi-laptop-code1' => 'twi-laptop-code1',
            'twi-laptop-medical1' => 'twi-laptop-medical1',
            'twi-laugh1' => 'twi-laugh1',
            'twi-laugh-beam1' => 'twi-laugh-beam1',
            'twi-laugh-squint1' => 'twi-laugh-squint1',
            'twi-laugh-wink1' => 'twi-laugh-wink1',
            'twi-layer-group1' => 'twi-layer-group1',
            'twi-layer-minus1' => 'twi-layer-minus1',
            'twi-layer-plus1' => 'twi-layer-plus1',
            'twi-leaf1' => 'twi-leaf1',
            'twi-leaf-heart1' => 'twi-leaf-heart1',
            'twi-leaf-maple1' => 'twi-leaf-maple1',
            'twi-leaf-oak1' => 'twi-leaf-oak1',
            'twi-lemon1' => 'twi-lemon1',
            'twi-less-than1' => 'twi-less-than1',
            'twi-less-than-equal1' => 'twi-less-than-equal1',
            'twi-level-down1' => 'twi-level-down1',
            'twi-level-down-alt1' => 'twi-level-down-alt1',
            'twi-level-up1' => 'twi-level-up1',
            'twi-level-up-alt1' => 'twi-level-up-alt1',
            'twi-life-ring1' => 'twi-life-ring1',
            'twi-lightbulb1' => 'twi-lightbulb1',
            'twi-lightbulb-dollar1' => 'twi-lightbulb-dollar1',
            'twi-lightbulb-exclamation1' => 'twi-lightbulb-exclamation1',
            'twi-lightbulb-on1' => 'twi-lightbulb-on1',
            'twi-lightbulb-slash1' => 'twi-lightbulb-slash1',
            'twi-lights-holiday1' => 'twi-lights-holiday1',
            'twi-link1' => 'twi-link1',
            'twi-lips1' => 'twi-lips1',
            'twi-lira-sign1' => 'twi-lira-sign1',
            'twi-list1' => 'twi-list1',
            'twi-list-alt1' => 'twi-list-alt1',
            'twi-list-ol1' => 'twi-list-ol1',
            'twi-list-ul1' => 'twi-list-ul1',
            'twi-location1' => 'twi-location1',
            'twi-location-arrow1' => 'twi-location-arrow1',
            'twi-location-circle1' => 'twi-location-circle1',
            'twi-location-slash1' => 'twi-location-slash1',
            'twi-lock1' => 'twi-lock1',
            'twi-lock-alt1' => 'twi-lock-alt1',
            'twi-lock-open1' => 'twi-lock-open1',
            'twi-lock-open-alt1' => 'twi-lock-open-alt1',
            'twi-long-arrow-alt-down1' => 'twi-long-arrow-alt-down1',
            'twi-long-arrow-alt-left1' => 'twi-long-arrow-alt-left1',
            'twi-long-arrow-alt-right1' => 'twi-long-arrow-alt-right1',
            'twi-long-arrow-alt-up1' => 'twi-long-arrow-alt-up1',
            'twi-long-arrow-down1' => 'twi-long-arrow-down1',
            'twi-long-arrow-left1' => 'twi-long-arrow-left1',
            'twi-long-arrow-right1' => 'twi-long-arrow-right1',
            'twi-long-arrow-up1' => 'twi-long-arrow-up1',
            'twi-loveseat1' => 'twi-loveseat1',
            'twi-low-vision1' => 'twi-low-vision1',
            'twi-luchador1' => 'twi-luchador1',
            'twi-luggage-cart1' => 'twi-luggage-cart1',
            'twi-lungs1' => 'twi-lungs1',
            'twi-mace1' => 'twi-mace1',
            'twi-magic1' => 'twi-magic1',
            'twi-magnet1' => 'twi-magnet1',
            'twi-mailbox1' => 'twi-mailbox1',
            'twi-mail-bulk1' => 'twi-mail-bulk1',
            'twi-male1' => 'twi-male1',
            'twi-mandolin1' => 'twi-mandolin1',
            'twi-map1' => 'twi-map1',
            'twi-map-marked1' => 'twi-map-marked1',
            'twi-map-marked-alt1' => 'twi-map-marked-alt1',
            'twi-map-marker1' => 'twi-map-marker1',
            'twi-map-marker-alt1' => 'twi-map-marker-alt1',
            'twi-map-marker-alt-slash1' => 'twi-map-marker-alt-slash1',
            'twi-map-marker-check1' => 'twi-map-marker-check1',
            'twi-map-marker-edit1' => 'twi-map-marker-edit1',
            'twi-map-marker-exclamation1' => 'twi-map-marker-exclamation1',
            'twi-map-marker-minus1' => 'twi-map-marker-minus1',
            'twi-map-marker-plus1' => 'twi-map-marker-plus1',
            'twi-map-marker-question1' => 'twi-map-marker-question1',
            'twi-map-marker-slash1' => 'twi-map-marker-slash1',
            'twi-map-marker-smile1' => 'twi-map-marker-smile1',
            'twi-map-marker-times1' => 'twi-map-marker-times1',
            'twi-map-pin1' => 'twi-map-pin1',
            'twi-map-signs1' => 'twi-map-signs1',
            'twi-marker1' => 'twi-marker1',
            'twi-mars1' => 'twi-mars1',
            'twi-mars-double1' => 'twi-mars-double1',
            'twi-mars-stroke1' => 'twi-mars-stroke1',
            'twi-mars-stroke-h1' => 'twi-mars-stroke-h1',
            'twi-mars-stroke-v1' => 'twi-mars-stroke-v1',
            'twi-mask1' => 'twi-mask1',
            'twi-meat1' => 'twi-meat1',
            'twi-medal1' => 'twi-medal1',
            'twi-medkit1' => 'twi-medkit1',
            'twi-megaphone1' => 'twi-megaphone1',
            'twi-meh1' => 'twi-meh1',
            'twi-meh-blank1' => 'twi-meh-blank1',
            'twi-meh-rolling-eyes1' => 'twi-meh-rolling-eyes1',
            'twi-memory1' => 'twi-memory1',
            'twi-menorah1' => 'twi-menorah1',
            'twi-mercury1' => 'twi-mercury1',
            'twi-meteor1' => 'twi-meteor1',
            'twi-microchip1' => 'twi-microchip1',
            'twi-microphone1' => 'twi-microphone1',
            'twi-microphone-alt1' => 'twi-microphone-alt1',
            'twi-microphone-alt-slash1' => 'twi-microphone-alt-slash1',
            'twi-microphone-slash1' => 'twi-microphone-slash1',
            'twi-microscope1' => 'twi-microscope1',
            'twi-mind-share1' => 'twi-mind-share1',
            'twi-minus1' => 'twi-minus1',
            'twi-minus-circle1' => 'twi-minus-circle1',
            'twi-minus-hexagon1' => 'twi-minus-hexagon1',
            'twi-minus-octagon1' => 'twi-minus-octagon1',
            'twi-minus-square1' => 'twi-minus-square1',
            'twi-mistletoe1' => 'twi-mistletoe1',
            'twi-mitten1' => 'twi-mitten1',
            'twi-mobile1' => 'twi-mobile1',
            'twi-mobile-alt1' => 'twi-mobile-alt1',
            'twi-mobile-android1' => 'twi-mobile-android1',
            'twi-mobile-android-alt1' => 'twi-mobile-android-alt1',
            'twi-money-bill1' => 'twi-money-bill1',
            'twi-money-bill-alt1' => 'twi-money-bill-alt1',
            'twi-money-bill-wave1' => 'twi-money-bill-wave1',
            'twi-money-bill-wave-alt1' => 'twi-money-bill-wave-alt1',
            'twi-money-check1' => 'twi-money-check1',
            'twi-money-check-alt1' => 'twi-money-check-alt1',
            'twi-monitor-heart-rate1' => 'twi-monitor-heart-rate1',
            'twi-monkey1' => 'twi-monkey1',
            'twi-monument1' => 'twi-monument1',
            'twi-moon1' => 'twi-moon1',
            'twi-moon-cloud1' => 'twi-moon-cloud1',
            'twi-moon-stars1' => 'twi-moon-stars1',
            'twi-mortar-pestle1' => 'twi-mortar-pestle1',
            'twi-mosque1' => 'twi-mosque1',
            'twi-motorcycle1' => 'twi-motorcycle1',
            'twi-mountain1' => 'twi-mountain1',
            'twi-mountains1' => 'twi-mountains1',
            'twi-mouse-pointer1' => 'twi-mouse-pointer1',
            'twi-mug-hot1' => 'twi-mug-hot1',
            'twi-mug-marshmallows1' => 'twi-mug-marshmallows1',
            'twi-music1' => 'twi-music1',
            'twi-narwhal1' => 'twi-narwhal1',
            'twi-network-wired1' => 'twi-network-wired1',
            'twi-neuter1' => 'twi-neuter1',
            'twi-newspaper1' => 'twi-newspaper1',
            'twi-not-equal1' => 'twi-not-equal1',
            'twi-notes-medical1' => 'twi-notes-medical1',
            'twi-object-group1' => 'twi-object-group1',
            'twi-object-ungroup1' => 'twi-object-ungroup1',
            'twi-octagon1' => 'twi-octagon1',
            'twi-oil-can1' => 'twi-oil-can1',
            'twi-oil-temp1' => 'twi-oil-temp1',
            'twi-om1' => 'twi-om1',
            'twi-omega1' => 'twi-omega1',
            'twi-ornament1' => 'twi-ornament1',
            'twi-otter1' => 'twi-otter1',
            'twi-outdent1' => 'twi-outdent1',
            'twi-pager1' => 'twi-pager1',
            'twi-paint-brush1' => 'twi-paint-brush1',
            'twi-paint-brush-alt1' => 'twi-paint-brush-alt1',
            'twi-paint-roller1' => 'twi-paint-roller1',
            'twi-palette1' => 'twi-palette1',
            'twi-pallet1' => 'twi-pallet1',
            'twi-pallet-alt1' => 'twi-pallet-alt1',
            'twi-paperclip1' => 'twi-paperclip1',
            'twi-paper-plane1' => 'twi-paper-plane1',
            'twi-parachute-box1' => 'twi-parachute-box1',
            'twi-paragraph1' => 'twi-paragraph1',
            'twi-parking1' => 'twi-parking1',
            'twi-parking-circle1' => 'twi-parking-circle1',
            'twi-parking-circle-slash1' => 'twi-parking-circle-slash1',
            'twi-parking-slash1' => 'twi-parking-slash1',
            'twi-passport1' => 'twi-passport1',
            'twi-pastafarianism1' => 'twi-pastafarianism1',
            'twi-paste1' => 'twi-paste1',
            'twi-pause1' => 'twi-pause1',
            'twi-pause-circle1' => 'twi-pause-circle1',
            'twi-paw1' => 'twi-paw1',
            'twi-paw-alt1' => 'twi-paw-alt1',
            'twi-paw-claws1' => 'twi-paw-claws1',
            'twi-peace1' => 'twi-peace1',
            'twi-pegasus1' => 'twi-pegasus1',
            'twi-pen1' => 'twi-pen1',
            'twi-pen-alt1' => 'twi-pen-alt1',
            'twi-pencil1' => 'twi-pencil1',
            'twi-pencil-alt1' => 'twi-pencil-alt1',
            'twi-pencil-paintbrush1' => 'twi-pencil-paintbrush1',
            'twi-pencil-ruler1' => 'twi-pencil-ruler1',
            'twi-pen-fancy1' => 'twi-pen-fancy1',
            'twi-pennant1' => 'twi-pennant1',
            'twi-pen-nib1' => 'twi-pen-nib1',
            'twi-pen-square1' => 'twi-pen-square1',
            'twi-people-carry1' => 'twi-people-carry1',
            'twi-pepper-hot1' => 'twi-pepper-hot1',
            'twi-percent1' => 'twi-percent1',
            'twi-percentage1' => 'twi-percentage1',
            'twi-person-booth1' => 'twi-person-booth1',
            'twi-person-carry1' => 'twi-person-carry1',
            'twi-person-dolly1' => 'twi-person-dolly1',
            'twi-person-dolly-empty1' => 'twi-person-dolly-empty1',
            'twi-person-sign1' => 'twi-person-sign1',
            'twi-phone1' => 'twi-phone1',
            'twi-phone-office1' => 'twi-phone-office1',
            'twi-phone-plus1' => 'twi-phone-plus1',
            'twi-phone-slash1' => 'twi-phone-slash1',
            'twi-phone-square1' => 'twi-phone-square1',
            'twi-phone-volume1' => 'twi-phone-volume1',
            'twi-pi1' => 'twi-pi1',
            'twi-pie1' => 'twi-pie1',
            'twi-pig1' => 'twi-pig1',
            'twi-piggy-bank1' => 'twi-piggy-bank1',
            'twi-pills1' => 'twi-pills1',
            'twi-pizza1' => 'twi-pizza1',
            'twi-pizza-slice1' => 'twi-pizza-slice1',
            'twi-place-of-worship1' => 'twi-place-of-worship1',
            'twi-plane1' => 'twi-plane1',
            'twi-plane-alt1' => 'twi-plane-alt1',
            'twi-plane-arrival1' => 'twi-plane-arrival1',
            'twi-plane-departure1' => 'twi-plane-departure1',
            'twi-play1' => 'twi-play1',
            'twi-play-circle1' => 'twi-play-circle1',
            'twi-plug1' => 'twi-plug1',
            'twi-plus1' => 'twi-plus1',
            'twi-plus-circle1' => 'twi-plus-circle1',
            'twi-plus-hexagon1' => 'twi-plus-hexagon1',
            'twi-plus-octagon1' => 'twi-plus-octagon1',
            'twi-plus-square1' => 'twi-plus-square1',
            'twi-podcast1' => 'twi-podcast1',
            'twi-podium1' => 'twi-podium1',
            'twi-podium-star1' => 'twi-podium-star1',
            'twi-poll1' => 'twi-poll1',
            'twi-poll-h1' => 'twi-poll-h1',
            'twi-poll-people1' => 'twi-poll-people1',
            'twi-poo1' => 'twi-poo1',
            'twi-poop1' => 'twi-poop1',
            'twi-poo-storm1' => 'twi-poo-storm1',
            'twi-popcorn1' => 'twi-popcorn1',
            'twi-portrait1' => 'twi-portrait1',
            'twi-pound-sign1' => 'twi-pound-sign1',
            'twi-power-off1' => 'twi-power-off1',
            'twi-pray1' => 'twi-pray1',
            'twi-praying-hands1' => 'twi-praying-hands1',
            'twi-prescription1' => 'twi-prescription1',
            'twi-prescription-bottle1' => 'twi-prescription-bottle1',
            'twi-prescription-bottle-alt1' => 'twi-prescription-bottle-alt1',
            'twi-presentation1' => 'twi-presentation1',
            'twi-print1' => 'twi-print1',
            'twi-print-search1' => 'twi-print-search1',
            'twi-print-slash1' => 'twi-print-slash1',
            'twi-procedures1' => 'twi-procedures1',
            'twi-project-diagram1' => 'twi-project-diagram1',
            'twi-pumpkin1' => 'twi-pumpkin1',
            'twi-puzzle-piece1' => 'twi-puzzle-piece1',
            'twi-qrcode1' => 'twi-qrcode1',
            'twi-question1' => 'twi-question1',
            'twi-question-circle1' => 'twi-question-circle1',
            'twi-question-square1' => 'twi-question-square1',
            'twi-quidditch1' => 'twi-quidditch1',
            'twi-quote-left1' => 'twi-quote-left1',
            'twi-quote-right1' => 'twi-quote-right1',
            'twi-quran1' => 'twi-quran1',
            'twi-rabbit1' => 'twi-rabbit1',
            'twi-rabbit-fast1' => 'twi-rabbit-fast1',
            'twi-racquet1' => 'twi-racquet1',
            'twi-radiation1' => 'twi-radiation1',
            'twi-radiation-alt1' => 'twi-radiation-alt1',
            'twi-rainbow1' => 'twi-rainbow1',
            'twi-raindrops1' => 'twi-raindrops1',
            'twi-ram1' => 'twi-ram1',
            'twi-ramp-loading1' => 'twi-ramp-loading1',
            'twi-random1' => 'twi-random1',
            'twi-receipt1' => 'twi-receipt1',
            'twi-rectangle-landscape1' => 'twi-rectangle-landscape1',
            'twi-rectangle-portrait1' => 'twi-rectangle-portrait1',
            'twi-rectangle-wide1' => 'twi-rectangle-wide1',
            'twi-recycle1' => 'twi-recycle1',
            'twi-redo1' => 'twi-redo1',
            'twi-redo-alt1' => 'twi-redo-alt1',
            'twi-registered1' => 'twi-registered1',
            'twi-repeat1' => 'twi-repeat1',
            'twi-repeat-11' => 'twi-repeat-11',
            'twi-repeat-1-alt1' => 'twi-repeat-1-alt1',
            'twi-repeat-alt1' => 'twi-repeat-alt1',
            'twi-reply1' => 'twi-reply1',
            'twi-reply-all1' => 'twi-reply-all1',
            'twi-republican1' => 'twi-republican1',
            'twi-restroom1' => 'twi-restroom1',
            'twi-retweet1' => 'twi-retweet1',
            'twi-retweet-alt1' => 'twi-retweet-alt1',
            'twi-ribbon1' => 'twi-ribbon1',
            'twi-ring1' => 'twi-ring1',
            'twi-rings-wedding1' => 'twi-rings-wedding1',
            'twi-road1' => 'twi-road1',
            'twi-robot1' => 'twi-robot1',
            'twi-rocket1' => 'twi-rocket1',
            'twi-route1' => 'twi-route1',
            'twi-route-highway1' => 'twi-route-highway1',
            'twi-route-interstate1' => 'twi-route-interstate1',
            'twi-rss1' => 'twi-rss1',
            'twi-rss-square1' => 'twi-rss-square1',
            'twi-ruble-sign1' => 'twi-ruble-sign1',
            'twi-ruler1' => 'twi-ruler1',
            'twi-ruler-combined1' => 'twi-ruler-combined1',
            'twi-ruler-horizontal1' => 'twi-ruler-horizontal1',
            'twi-ruler-triangle1' => 'twi-ruler-triangle1',
            'twi-ruler-vertical1' => 'twi-ruler-vertical1',
            'twi-running1' => 'twi-running1',
            'twi-rupee-sign1' => 'twi-rupee-sign1',
            'twi-rv1' => 'twi-rv1',
            'twi-sack1' => 'twi-sack1',
            'twi-sack-dollar1' => 'twi-sack-dollar1',
            'twi-sad-cry1' => 'twi-sad-cry1',
            'twi-sad-tear1' => 'twi-sad-tear1',
            'twi-salad1' => 'twi-salad1',
            'twi-sandwich1' => 'twi-sandwich1',
            'twi-satellite1' => 'twi-satellite1',
            'twi-satellite-dish1' => 'twi-satellite-dish1',
            'twi-sausage1' => 'twi-sausage1',
            'twi-save1' => 'twi-save1',
            'twi-scalpel1' => 'twi-scalpel1',
            'twi-scalpel-path1' => 'twi-scalpel-path1',
            'twi-scanner1' => 'twi-scanner1',
            'twi-scanner-keyboard1' => 'twi-scanner-keyboard1',
            'twi-scanner-touchscreen1' => 'twi-scanner-touchscreen1',
            'twi-scarecrow1' => 'twi-scarecrow1',
            'twi-scarf1' => 'twi-scarf1',
            'twi-school1' => 'twi-school1',
            'twi-screwdriver1' => 'twi-screwdriver1',
            'twi-scroll1' => 'twi-scroll1',
            'twi-scroll-old1' => 'twi-scroll-old1',
            'twi-scrubber1' => 'twi-scrubber1',
            'twi-scythe1' => 'twi-scythe1',
            'twi-sd-card1' => 'twi-sd-card1',
            'twi-search1' => 'twi-search1',
            'twi-search-dollar1' => 'twi-search-dollar1',
            'twi-search-location1' => 'twi-search-location1',
            'twi-search-minus1' => 'twi-search-minus1',
            'twi-search-plus1' => 'twi-search-plus1',
            'twi-seedling1' => 'twi-seedling1',
            'twi-server1' => 'twi-server1',
            'twi-shapes1' => 'twi-shapes1',
            'twi-share1' => 'twi-share1',
            'twi-share-all1' => 'twi-share-all1',
            'twi-share-alt1' => 'twi-share-alt1',
            'twi-share-alt-square1' => 'twi-share-alt-square1',
            'twi-share-square1' => 'twi-share-square1',
            'twi-sheep1' => 'twi-sheep1',
            'twi-shekel-sign1' => 'twi-shekel-sign1',
            'twi-shield1' => 'twi-shield1',
            'twi-shield-alt1' => 'twi-shield-alt1',
            'twi-shield-check1' => 'twi-shield-check1',
            'twi-shield-cross1' => 'twi-shield-cross1',
            'twi-ship1' => 'twi-ship1',
            'twi-shipping-fast1' => 'twi-shipping-fast1',
            'twi-shipping-timed1' => 'twi-shipping-timed1',
            'twi-shish-kebab1' => 'twi-shish-kebab1',
            'twi-shoe-prints1' => 'twi-shoe-prints1',
            'twi-shopping-bag1' => 'twi-shopping-bag1',
            'twi-shopping-basket1' => 'twi-shopping-basket1',
            'twi-shopping-cart1' => 'twi-shopping-cart1',
            'twi-shovel1' => 'twi-shovel1',
            'twi-shovel-snow1' => 'twi-shovel-snow1',
            'twi-shower1' => 'twi-shower1',
            'twi-shredder1' => 'twi-shredder1',
            'twi-shuttlecock1' => 'twi-shuttlecock1',
            'twi-shuttle-van1' => 'twi-shuttle-van1',
            'twi-sickle1' => 'twi-sickle1',
            'twi-sigma1' => 'twi-sigma1',
            'twi-sign1' => 'twi-sign1',
            'twi-signal1' => 'twi-signal1',
            'twi-signal-11' => 'twi-signal-11',
            'twi-signal-21' => 'twi-signal-21',
            'twi-signal-31' => 'twi-signal-31',
            'twi-signal-41' => 'twi-signal-41',
            'twi-signal-alt1' => 'twi-signal-alt1',
            'twi-signal-alt-11' => 'twi-signal-alt-11',
            'twi-signal-alt-21' => 'twi-signal-alt-21',
            'twi-signal-alt-31' => 'twi-signal-alt-31',
            'twi-signal-alt-slash1' => 'twi-signal-alt-slash1',
            'twi-signal-slash1' => 'twi-signal-slash1',
            'twi-signature1' => 'twi-signature1',
            'twi-sign-in1' => 'twi-sign-in1',
            'twi-sign-in-alt1' => 'twi-sign-in-alt1',
            'twi-sign-language1' => 'twi-sign-language1',
            'twi-sign-out1' => 'twi-sign-out1',
            'twi-sign-out-alt1' => 'twi-sign-out-alt1',
            'twi-sim-card1' => 'twi-sim-card1',
            'twi-sitemap1' => 'twi-sitemap1',
            'twi-skating1' => 'twi-skating1',
            'twi-skeleton1' => 'twi-skeleton1',
            'twi-skiing1' => 'twi-skiing1',
            'twi-skiing-nordic1' => 'twi-skiing-nordic1',
            'twi-ski-jump1' => 'twi-ski-jump1',
            'twi-ski-lift1' => 'twi-ski-lift1',
            'twi-skull1' => 'twi-skull1',
            'twi-skull-crossbones1' => 'twi-skull-crossbones1',
            'twi-slash1' => 'twi-slash1',
            'twi-sledding1' => 'twi-sledding1',
            'twi-sleigh1' => 'twi-sleigh1',
            'twi-sliders-h1' => 'twi-sliders-h1',
            'twi-sliders-h-square1' => 'twi-sliders-h-square1',
            'twi-sliders-v1' => 'twi-sliders-v1',
            'twi-sliders-v-square1' => 'twi-sliders-v-square1',
            'twi-smile1' => 'twi-smile1',
            'twi-smile-beam1' => 'twi-smile-beam1',
            'twi-smile-plus1' => 'twi-smile-plus1',
            'twi-smile-wink1' => 'twi-smile-wink1',
            'twi-smog1' => 'twi-smog1',
            'twi-smoke1' => 'twi-smoke1',
            'twi-smoking1' => 'twi-smoking1',
            'twi-smoking-ban1' => 'twi-smoking-ban1',
            'twi-sms1' => 'twi-sms1',
            'twi-snake1' => 'twi-snake1',
            'twi-snow-blowing1' => 'twi-snow-blowing1',
            'twi-snowboarding1' => 'twi-snowboarding1',
            'twi-snowflake1' => 'twi-snowflake1',
            'twi-snowflakes1' => 'twi-snowflakes1',
            'twi-snowman1' => 'twi-snowman1',
            'twi-snowmobile1' => 'twi-snowmobile1',
            'twi-snowplow1' => 'twi-snowplow1',
            'twi-socks1' => 'twi-socks1',
            'twi-solar-panel1' => 'twi-solar-panel1',
            'twi-sort1' => 'twi-sort1',
            'twi-sort-alpha-down1' => 'twi-sort-alpha-down1',
            'twi-sort-alpha-up1' => 'twi-sort-alpha-up1',
            'twi-sort-amount-down1' => 'twi-sort-amount-down1',
            'twi-sort-amount-up1' => 'twi-sort-amount-up1',
            'twi-sort-down1' => 'twi-sort-down1',
            'twi-sort-numeric-down1' => 'twi-sort-numeric-down1',
            'twi-sort-numeric-up1' => 'twi-sort-numeric-up1',
            'twi-sort-up1' => 'twi-sort-up1',
            'twi-soup1' => 'twi-soup1',
            'twi-spa1' => 'twi-spa1',
            'twi-space-shuttle1' => 'twi-space-shuttle1',
            'twi-spade1' => 'twi-spade1',
            'twi-spider1' => 'twi-spider1',
            'twi-spider-black-widow1' => 'twi-spider-black-widow1',
            'twi-spider-web1' => 'twi-spider-web1',
            'twi-spinner1' => 'twi-spinner1',
            'twi-spinner-third1' => 'twi-spinner-third1',
            'twi-splotch1' => 'twi-splotch1',
            'twi-spray-can1' => 'twi-spray-can1',
            'twi-square1' => 'twi-square1',
            'twi-square-full1' => 'twi-square-full1',
            'twi-square-root1' => 'twi-square-root1',
            'twi-square-root-alt1' => 'twi-square-root-alt1',
            'twi-squirrel1' => 'twi-squirrel1',
            'twi-staff1' => 'twi-staff1',
            'twi-stamp1' => 'twi-stamp1',
            'twi-star1' => 'twi-star1',
            'twi-star-and-crescent1' => 'twi-star-and-crescent1',
            'twi-star-christmas1' => 'twi-star-christmas1',
            'twi-star-exclamation1' => 'twi-star-exclamation1',
            'twi-star-half1' => 'twi-star-half1',
            'twi-star-half-alt1' => 'twi-star-half-alt1',
            'twi-star-of-david1' => 'twi-star-of-david1',
            'twi-star-of-life1' => 'twi-star-of-life1',
            'twi-stars1' => 'twi-stars1',
            'twi-steak1' => 'twi-steak1',
            'twi-steering-wheel1' => 'twi-steering-wheel1',
            'twi-step-backward1' => 'twi-step-backward1',
            'twi-step-forward1' => 'twi-step-forward1',
            'twi-stethoscope1' => 'twi-stethoscope1',
            'twi-sticky-note1' => 'twi-sticky-note1',
            'twi-stocking1' => 'twi-stocking1',
            'twi-stomach1' => 'twi-stomach1',
            'twi-stop1' => 'twi-stop1',
            'twi-stop-circle1' => 'twi-stop-circle1',
            'twi-stopwatch1' => 'twi-stopwatch1',
            'twi-store1' => 'twi-store1',
            'twi-store-alt1' => 'twi-store-alt1',
            'twi-stream1' => 'twi-stream1',
            'twi-street-view1' => 'twi-street-view1',
            'twi-stretcher1' => 'twi-stretcher1',
            'twi-strikethrough1' => 'twi-strikethrough1',
            'twi-stroopwafel1' => 'twi-stroopwafel1',
            'twi-subscript1' => 'twi-subscript1',
            'twi-subway1' => 'twi-subway1',
            'twi-suitcase1' => 'twi-suitcase1',
            'twi-suitcase-rolling1' => 'twi-suitcase-rolling1',
            'twi-sun1' => 'twi-sun1',
            'twi-sun-cloud1' => 'twi-sun-cloud1',
            'twi-sun-dust1' => 'twi-sun-dust1',
            'twi-sun-haze1' => 'twi-sun-haze1',
            'twi-sunrise1' => 'twi-sunrise1',
            'twi-sunset1' => 'twi-sunset1',
            'twi-superscript1' => 'twi-superscript1',
            'twi-surprise1' => 'twi-surprise1',
            'twi-swatchbook1' => 'twi-swatchbook1',
            'twi-swimmer1' => 'twi-swimmer1',
            'twi-swimming-pool1' => 'twi-swimming-pool1',
            'twi-sword1' => 'twi-sword1',
            'twi-swords1' => 'twi-swords1',
            'twi-synagogue1' => 'twi-synagogue1',
            'twi-sync1' => 'twi-sync1',
            'twi-sync-alt1' => 'twi-sync-alt1',
            'twi-syringe1' => 'twi-syringe1',
            'twi-table1' => 'twi-table1',
            'twi-tablet1' => 'twi-tablet1',
            'twi-tablet-alt1' => 'twi-tablet-alt1',
            'twi-tablet-android1' => 'twi-tablet-android1',
            'twi-tablet-android-alt1' => 'twi-tablet-android-alt1',
            'twi-table-tennis1' => 'twi-table-tennis1',
            'twi-tablet-rugged1' => 'twi-tablet-rugged1',
            'twi-tablets1' => 'twi-tablets1',
            'twi-tachometer1' => 'twi-tachometer1',
            'twi-tachometer-alt1' => 'twi-tachometer-alt1',
            'twi-tachometer-alt-average1' => 'twi-tachometer-alt-average1',
            'twi-tachometer-alt-fast1' => 'twi-tachometer-alt-fast1',
            'twi-tachometer-alt-fastest1' => 'twi-tachometer-alt-fastest1',
            'twi-tachometer-alt-slow1' => 'twi-tachometer-alt-slow1',
            'twi-tachometer-alt-slowest1' => 'twi-tachometer-alt-slowest1',
            'twi-tachometer-average1' => 'twi-tachometer-average1',
            'twi-tachometer-fast1' => 'twi-tachometer-fast1',
            'twi-tachometer-fastest1' => 'twi-tachometer-fastest1',
            'twi-tachometer-slow1' => 'twi-tachometer-slow1',
            'twi-tachometer-slowest1' => 'twi-tachometer-slowest1',
            'twi-taco1' => 'twi-taco1',
            'twi-tag1' => 'twi-tag1',
            'twi-tags1' => 'twi-tags1',
            'twi-tally1' => 'twi-tally1',
            'twi-tanakh1' => 'twi-tanakh1',
            'twi-tape1' => 'twi-tape1',
            'twi-tasks1' => 'twi-tasks1',
            'twi-tasks-alt1' => 'twi-tasks-alt1',
            'twi-taxi1' => 'twi-taxi1',
            'twi-teeth1' => 'twi-teeth1',
            'twi-teeth-open1' => 'twi-teeth-open1',
            'twi-temperature-frigid1' => 'twi-temperature-frigid1',
            'twi-temperature-high1' => 'twi-temperature-high1',
            'twi-temperature-hot1' => 'twi-temperature-hot1',
            'twi-temperature-low1' => 'twi-temperature-low1',
            'twi-tenge1' => 'twi-tenge1',
            'twi-tennis-ball1' => 'twi-tennis-ball1',
            'twi-terminal1' => 'twi-terminal1',
            'twi-text-height1' => 'twi-text-height1',
            'twi-text-width1' => 'twi-text-width1',
            'twi-th1' => 'twi-th1',
            'twi-theater-masks1' => 'twi-theater-masks1',
            'twi-thermometer1' => 'twi-thermometer1',
            'twi-thermometer-empty1' => 'twi-thermometer-empty1',
            'twi-thermometer-full1' => 'twi-thermometer-full1',
            'twi-thermometer-half1' => 'twi-thermometer-half1',
            'twi-thermometer-quarter1' => 'twi-thermometer-quarter1',
            'twi-thermometer-three-quarters1' => 'twi-thermometer-three-quarters1',
            'twi-theta1' => 'twi-theta1',
            'twi-th-large1' => 'twi-th-large1',
            'twi-th-list1' => 'twi-th-list1',
            'twi-thumbs-down1' => 'twi-thumbs-down1',
            'twi-thumbs-up1' => 'twi-thumbs-up1',
            'twi-thumbtack1' => 'twi-thumbtack1',
            'twi-thunderstorm1' => 'twi-thunderstorm1',
            'twi-thunderstorm-moon1' => 'twi-thunderstorm-moon1',
            'twi-thunderstorm-sun1' => 'twi-thunderstorm-sun1',
            'twi-ticket1' => 'twi-ticket1',
            'twi-ticket-alt1' => 'twi-ticket-alt1',
            'twi-tilde1' => 'twi-tilde1',
            'twi-times1' => 'twi-times1',
            'twi-times-circle1' => 'twi-times-circle1',
            'twi-times-hexagon1' => 'twi-times-hexagon1',
            'twi-times-octagon1' => 'twi-times-octagon1',
            'twi-times-square1' => 'twi-times-square1',
            'twi-tint1' => 'twi-tint1',
            'twi-tint-slash1' => 'twi-tint-slash1',
            'twi-tire1' => 'twi-tire1',
            'twi-tired1' => 'twi-tired1',
            'twi-tire-flat1' => 'twi-tire-flat1',
            'twi-tire-pressure-warning1' => 'twi-tire-pressure-warning1',
            'twi-tire-rugged1' => 'twi-tire-rugged1',
            'twi-toggle-off1' => 'twi-toggle-off1',
            'twi-toggle-on1' => 'twi-toggle-on1',
            'twi-toilet1' => 'twi-toilet1',
            'twi-toilet-paper1' => 'twi-toilet-paper1',
            'twi-toilet-paper-alt1' => 'twi-toilet-paper-alt1',
            'twi-tombstone1' => 'twi-tombstone1',
            'twi-tombstone-alt1' => 'twi-tombstone-alt1',
            'twi-toolbox1' => 'twi-toolbox1',
            'twi-tools1' => 'twi-tools1',
            'twi-tooth1' => 'twi-tooth1',
            'twi-toothbrush1' => 'twi-toothbrush1',
            'twi-torah1' => 'twi-torah1',
            'twi-torii-gate1' => 'twi-torii-gate1',
            'twi-tornado1' => 'twi-tornado1',
            'twi-tractor1' => 'twi-tractor1',
            'twi-trademark1' => 'twi-trademark1',
            'twi-traffic-cone1' => 'twi-traffic-cone1',
            'twi-traffic-light1' => 'twi-traffic-light1',
            'twi-traffic-light-go1' => 'twi-traffic-light-go1',
            'twi-traffic-light-slow1' => 'twi-traffic-light-slow1',
            'twi-traffic-light-stop1' => 'twi-traffic-light-stop1',
            'twi-train1' => 'twi-train1',
            'twi-tram1' => 'twi-tram1',
            'twi-transgender1' => 'twi-transgender1',
            'twi-transgender-alt1' => 'twi-transgender-alt1',
            'twi-trash1' => 'twi-trash1',
            'twi-trash-alt1' => 'twi-trash-alt1',
            'twi-trash-restore1' => 'twi-trash-restore1',
            'twi-trash-restore-alt1' => 'twi-trash-restore-alt1',
            'twi-treasure-chest1' => 'twi-treasure-chest1',
            'twi-tree1' => 'twi-tree1',
            'twi-tree-alt1' => 'twi-tree-alt1',
            'twi-tree-christmas1' => 'twi-tree-christmas1',
            'twi-tree-decorated1' => 'twi-tree-decorated1',
            'twi-tree-large1' => 'twi-tree-large1',
            'twi-tree-palm1' => 'twi-tree-palm1',
            'twi-trees1' => 'twi-trees1',
            'twi-triangle1' => 'twi-triangle1',
            'twi-trophy1' => 'twi-trophy1',
            'twi-trophy-alt1' => 'twi-trophy-alt1',
            'twi-truck1' => 'twi-truck1',
            'twi-truck-container1' => 'twi-truck-container1',
            'twi-truck-couch1' => 'twi-truck-couch1',
            'twi-truck-loading1' => 'twi-truck-loading1',
            'twi-truck-monster1' => 'twi-truck-monster1',
            'twi-truck-moving1' => 'twi-truck-moving1',
            'twi-truck-pickup1' => 'twi-truck-pickup1',
            'twi-truck-plow1' => 'twi-truck-plow1',
            'twi-truck-ramp1' => 'twi-truck-ramp1',
            'twi-tshirt1' => 'twi-tshirt1',
            'twi-tty1' => 'twi-tty1',
            'twi-turkey1' => 'twi-turkey1',
            'twi-turtle1' => 'twi-turtle1',
            'twi-tv1' => 'twi-tv1',
            'twi-tv-retro1' => 'twi-tv-retro1',
            'twi-umbrella1' => 'twi-umbrella1',
            'twi-umbrella-beach1' => 'twi-umbrella-beach1',
            'twi-underline1' => 'twi-underline1',
            'twi-undo1' => 'twi-undo1',
            'twi-undo-alt1' => 'twi-undo-alt1',
            'twi-unicorn1' => 'twi-unicorn1',
            'twi-union1' => 'twi-union1',
            'twi-universal-access1' => 'twi-universal-access1',
            'twi-university1' => 'twi-university1',
            'twi-unlink1' => 'twi-unlink1',
            'twi-unlock1' => 'twi-unlock1',
            'twi-unlock-alt1' => 'twi-unlock-alt1',
            'twi-upload1' => 'twi-upload1',
            'twi-usd-circle1' => 'twi-usd-circle1',
            'twi-usd-square1' => 'twi-usd-square1',
            'twi-user1' => 'twi-user1',
            'twi-user-alt1' => 'twi-user-alt1',
            'twi-user-alt-slash1' => 'twi-user-alt-slash1',
            'twi-user-astronaut1' => 'twi-user-astronaut1',
            'twi-user-chart1' => 'twi-user-chart1',
            'twi-user-check1' => 'twi-user-check1',
            'twi-user-circle1' => 'twi-user-circle1',
            'twi-user-clock1' => 'twi-user-clock1',
            'twi-user-cog1' => 'twi-user-cog1',
            'twi-user-crown1' => 'twi-user-crown1',
            'twi-user-edit1' => 'twi-user-edit1',
            'twi-user-friends1' => 'twi-user-friends1',
            'twi-user-graduate1' => 'twi-user-graduate1',
            'twi-user-hard-hat1' => 'twi-user-hard-hat1',
            'twi-user-headset1' => 'twi-user-headset1',
            'twi-user-injured1' => 'twi-user-injured1',
            'twi-user-lock1' => 'twi-user-lock1',
            'twi-user-md1' => 'twi-user-md1',
            'twi-user-md-chat1' => 'twi-user-md-chat1',
            'twi-user-minus1' => 'twi-user-minus1',
            'twi-user-ninja1' => 'twi-user-ninja1',
            'twi-user-nurse1' => 'twi-user-nurse1',
            'twi-user-plus1' => 'twi-user-plus1',
            'twi-users1' => 'twi-users1',
            'twi-users-class1' => 'twi-users-class1',
            'twi-users-cog1' => 'twi-users-cog1',
            'twi-users-crown1' => 'twi-users-crown1',
            'twi-user-secret1' => 'twi-user-secret1',
            'twi-user-shield1' => 'twi-user-shield1',
            'twi-user-slash1' => 'twi-user-slash1',
            'twi-users-medical1' => 'twi-users-medical1',
            'twi-user-tag1' => 'twi-user-tag1',
            'twi-user-tie1' => 'twi-user-tie1',
            'twi-user-times1' => 'twi-user-times1',
            'twi-utensil-fork1' => 'twi-utensil-fork1',
            'twi-utensil-knife1' => 'twi-utensil-knife1',
            'twi-utensils1' => 'twi-utensils1',
            'twi-utensils-alt1' => 'twi-utensils-alt1',
            'twi-utensil-spoon1' => 'twi-utensil-spoon1',
            'twi-value-absolute1' => 'twi-value-absolute1',
            'twi-vector-square1' => 'twi-vector-square1',
            'twi-venus1' => 'twi-venus1',
            'twi-venus-double1' => 'twi-venus-double1',
            'twi-venus-mars1' => 'twi-venus-mars1',
            'twi-vial1' => 'twi-vial1',
            'twi-vials1' => 'twi-vials1',
            'twi-video1' => 'twi-video1',
            'twi-video-plus1' => 'twi-video-plus1',
            'twi-video-slash1' => 'twi-video-slash1',
            'twi-vihara1' => 'twi-vihara1',
            'twi-volcano1' => 'twi-volcano1',
            'twi-volleyball-ball1' => 'twi-volleyball-ball1',
            'twi-volume1' => 'twi-volume1',
            'twi-volume-down1' => 'twi-volume-down1',
            'twi-volume-mute1' => 'twi-volume-mute1',
            'twi-volume-off1' => 'twi-volume-off1',
            'twi-volume-slash1' => 'twi-volume-slash1',
            'twi-volume-up1' => 'twi-volume-up1',
            'twi-vote-nay1' => 'twi-vote-nay1',
            'twi-vote-yea1' => 'twi-vote-yea1',
            'twi-vr-cardboard1' => 'twi-vr-cardboard1',
            'twi-walker1' => 'twi-walker1',
            'twi-walking1' => 'twi-walking1',
            'twi-wallet1' => 'twi-wallet1',
            'twi-wand1' => 'twi-wand1',
            'twi-wand-magic1' => 'twi-wand-magic1',
            'twi-warehouse1' => 'twi-warehouse1',
            'twi-warehouse-alt1' => 'twi-warehouse-alt1',
            'twi-watch1' => 'twi-watch1',
            'twi-watch-fitness1' => 'twi-watch-fitness1',
            'twi-water1' => 'twi-water1',
            'twi-water-lower1' => 'twi-water-lower1',
            'twi-water-rise1' => 'twi-water-rise1',
            'twi-wave-square1' => 'twi-wave-square1',
            'twi-webcam1' => 'twi-webcam1',
            'twi-webcam-slash1' => 'twi-webcam-slash1',
            'twi-weight1' => 'twi-weight1',
            'twi-weight-hanging1' => 'twi-weight-hanging1',
            'twi-whale1' => 'twi-whale1',
            'twi-wheat1' => 'twi-wheat1',
            'twi-wheelchair1' => 'twi-wheelchair1',
            'twi-whistle1' => 'twi-whistle1',
            'twi-wifi1' => 'twi-wifi1',
            'twi-wifi-11' => 'twi-wifi-11',
            'twi-wifi-21' => 'twi-wifi-21',
            'twi-wifi-slash1' => 'twi-wifi-slash1',
            'twi-wind1' => 'twi-wind1',
            'twi-window1' => 'twi-window1',
            'twi-window-alt1' => 'twi-window-alt1',
            'twi-window-close1' => 'twi-window-close1',
            'twi-window-maximize1' => 'twi-window-maximize1',
            'twi-window-minimize1' => 'twi-window-minimize1',
            'twi-window-restore1' => 'twi-window-restore1',
            'twi-windsock1' => 'twi-windsock1',
            'twi-wind-warning1' => 'twi-wind-warning1',
            'twi-wine-bottle1' => 'twi-wine-bottle1',
            'twi-wine-glass1' => 'twi-wine-glass1',
            'twi-wine-glass-alt1' => 'twi-wine-glass-alt1',
            'twi-won-sign1' => 'twi-won-sign1',
            'twi-wreath1' => 'twi-wreath1',
            'twi-wrench1' => 'twi-wrench1',
            'twi-x-ray1' => 'twi-x-ray1',
            'twi-yen-sign1' => 'twi-yen-sign1',
            'twi-yin-yang1' => 'twi-yin-yang1',
            'twi-abacus2' => 'twi-abacus2',
            'twi-acorn2' => 'twi-acorn2',
            'twi-ad2' => 'twi-ad2',
            'twi-address-book2' => 'twi-address-book2',
            'twi-address-card2' => 'twi-address-card2',
            'twi-adjust2' => 'twi-adjust2',
            'twi-air-freshener2' => 'twi-air-freshener2',
            'twi-alarm-clock2' => 'twi-alarm-clock2',
            'twi-alicorn2' => 'twi-alicorn2',
            'twi-align-center2' => 'twi-align-center2',
            'twi-align-justify2' => 'twi-align-justify2',
            'twi-align-left2' => 'twi-align-left2',
            'twi-align-right2' => 'twi-align-right2',
            'twi-allergies2' => 'twi-allergies2',
            'twi-ambulance2' => 'twi-ambulance2',
            'twi-american-sign-language-interpreting2' => 'twi-american-sign-language-interpreting2',
            'twi-analytics2' => 'twi-analytics2',
            'twi-anchor2' => 'twi-anchor2',
            'twi-angel2' => 'twi-angel2',
            'twi-angle-double-down2' => 'twi-angle-double-down2',
            'twi-angle-double-left2' => 'twi-angle-double-left2',
            'twi-angle-double-right2' => 'twi-angle-double-right2',
            'twi-angle-double-up2' => 'twi-angle-double-up2',
            'twi-angle-down2' => 'twi-angle-down2',
            'twi-angle-left2' => 'twi-angle-left2',
            'twi-angle-right2' => 'twi-angle-right2',
            'twi-angle-up2' => 'twi-angle-up2',
            'twi-angry2' => 'twi-angry2',
            'twi-ankh2' => 'twi-ankh2',
            'twi-apple-alt2' => 'twi-apple-alt2',
            'twi-apple-crate2' => 'twi-apple-crate2',
            'twi-archive2' => 'twi-archive2',
            'twi-archway2' => 'twi-archway2',
            'twi-arrow-alt-circle-down2' => 'twi-arrow-alt-circle-down2',
            'twi-arrow-alt-circle-left2' => 'twi-arrow-alt-circle-left2',
            'twi-arrow-alt-circle-right2' => 'twi-arrow-alt-circle-right2',
            'twi-arrow-alt-circle-up2' => 'twi-arrow-alt-circle-up2',
            'twi-arrow-alt-down2' => 'twi-arrow-alt-down2',
            'twi-arrow-alt-from-bottom2' => 'twi-arrow-alt-from-bottom2',
            'twi-arrow-alt-from-left2' => 'twi-arrow-alt-from-left2',
            'twi-arrow-alt-from-right2' => 'twi-arrow-alt-from-right2',
            'twi-arrow-alt-from-top2' => 'twi-arrow-alt-from-top2',
            'twi-arrow-alt-left2' => 'twi-arrow-alt-left2',
            'twi-arrow-alt-right2' => 'twi-arrow-alt-right2',
            'twi-arrow-alt-square-down2' => 'twi-arrow-alt-square-down2',
            'twi-arrow-alt-square-left2' => 'twi-arrow-alt-square-left2',
            'twi-arrow-alt-square-right2' => 'twi-arrow-alt-square-right2',
            'twi-arrow-alt-square-up2' => 'twi-arrow-alt-square-up2',
            'twi-arrow-alt-to-bottom2' => 'twi-arrow-alt-to-bottom2',
            'twi-arrow-alt-to-left2' => 'twi-arrow-alt-to-left2',
            'twi-arrow-alt-to-right2' => 'twi-arrow-alt-to-right2',
            'twi-arrow-alt-to-top2' => 'twi-arrow-alt-to-top2',
            'twi-arrow-alt-up2' => 'twi-arrow-alt-up2',
            'twi-arrow-circle-down2' => 'twi-arrow-circle-down2',
            'twi-arrow-circle-left2' => 'twi-arrow-circle-left2',
            'twi-arrow-circle-right2' => 'twi-arrow-circle-right2',
            'twi-arrow-circle-up2' => 'twi-arrow-circle-up2',
            'twi-arrow-down2' => 'twi-arrow-down2',
            'twi-arrow-from-bottom2' => 'twi-arrow-from-bottom2',
            'twi-arrow-from-left2' => 'twi-arrow-from-left2',
            'twi-arrow-from-right2' => 'twi-arrow-from-right2',
            'twi-arrow-from-top2' => 'twi-arrow-from-top2',
            'twi-arrow-left2' => 'twi-arrow-left2',
            'twi-arrow-right2' => 'twi-arrow-right2',
            'twi-arrows2' => 'twi-arrows2',
            'twi-arrows-alt2' => 'twi-arrows-alt2',
            'twi-arrows-alt-h2' => 'twi-arrows-alt-h2',
            'twi-arrows-alt-v2' => 'twi-arrows-alt-v2',
            'twi-arrows-h2' => 'twi-arrows-h2',
            'twi-arrow-square-down2' => 'twi-arrow-square-down2',
            'twi-arrow-square-left2' => 'twi-arrow-square-left2',
            'twi-arrow-square-right2' => 'twi-arrow-square-right2',
            'twi-arrow-square-up2' => 'twi-arrow-square-up2',
            'twi-arrows-v2' => 'twi-arrows-v2',
            'twi-arrow-to-bottom2' => 'twi-arrow-to-bottom2',
            'twi-arrow-to-left2' => 'twi-arrow-to-left2',
            'twi-arrow-to-right2' => 'twi-arrow-to-right2',
            'twi-arrow-to-top2' => 'twi-arrow-to-top2',
            'twi-arrow-up2' => 'twi-arrow-up2',
            'twi-assistive-listening-systems2' => 'twi-assistive-listening-systems2',
            'twi-asterisk2' => 'twi-asterisk2',
            'twi-at2' => 'twi-at2',
            'twi-atlas2' => 'twi-atlas2',
            'twi-atom2' => 'twi-atom2',
            'twi-atom-alt2' => 'twi-atom-alt2',
            'twi-audio-description2' => 'twi-audio-description2',
            'twi-award2' => 'twi-award2',
            'twi-axe2' => 'twi-axe2',
            'twi-axe-battle2' => 'twi-axe-battle2',
            'twi-baby2' => 'twi-baby2',
            'twi-baby-carriage2' => 'twi-baby-carriage2',
            'twi-backpack2' => 'twi-backpack2',
            'twi-backspace2' => 'twi-backspace2',
            'twi-backward2' => 'twi-backward2',
            'twi-bacon2' => 'twi-bacon2',
            'twi-badge2' => 'twi-badge2',
            'twi-badge-check2' => 'twi-badge-check2',
            'twi-badge-dollar2' => 'twi-badge-dollar2',
            'twi-badge-percent2' => 'twi-badge-percent2',
            'twi-badger-honey2' => 'twi-badger-honey2',
            'twi-balance-scale2' => 'twi-balance-scale2',
            'twi-balance-scale-left2' => 'twi-balance-scale-left2',
            'twi-balance-scale-right2' => 'twi-balance-scale-right2',
            'twi-ballot2' => 'twi-ballot2',
            'twi-ballot-check2' => 'twi-ballot-check2',
            'twi-ball-pile2' => 'twi-ball-pile2',
            'twi-ban2' => 'twi-ban2',
            'twi-band-aid2' => 'twi-band-aid2',
            'twi-barcode2' => 'twi-barcode2',
            'twi-barcode-alt2' => 'twi-barcode-alt2',
            'twi-barcode-read2' => 'twi-barcode-read2',
            'twi-barcode-scan2' => 'twi-barcode-scan2',
            'twi-bars2' => 'twi-bars2',
            'twi-baseball2' => 'twi-baseball2',
            'twi-baseball-ball2' => 'twi-baseball-ball2',
            'twi-basketball-ball2' => 'twi-basketball-ball2',
            'twi-basketball-hoop2' => 'twi-basketball-hoop2',
            'twi-bat2' => 'twi-bat2',
            'twi-bath2' => 'twi-bath2',
            'twi-battery-bolt2' => 'twi-battery-bolt2',
            'twi-battery-empty2' => 'twi-battery-empty2',
            'twi-battery-full2' => 'twi-battery-full2',
            'twi-battery-half2' => 'twi-battery-half2',
            'twi-battery-quarter2' => 'twi-battery-quarter2',
            'twi-battery-slash2' => 'twi-battery-slash2',
            'twi-battery-three-quarters2' => 'twi-battery-three-quarters2',
            'twi-bed2' => 'twi-bed2',
            'twi-beer2' => 'twi-beer2',
            'twi-bell2' => 'twi-bell2',
            'twi-bells2' => 'twi-bells2',
            'twi-bell-school2' => 'twi-bell-school2',
            'twi-bell-school-slash2' => 'twi-bell-school-slash2',
            'twi-bell-slash2' => 'twi-bell-slash2',
            'twi-bezier-curve2' => 'twi-bezier-curve2',
            'twi-bible2' => 'twi-bible2',
            'twi-bicycle2' => 'twi-bicycle2',
            'twi-binoculars2' => 'twi-binoculars2',
            'twi-biohazard2' => 'twi-biohazard2',
            'twi-birthday-cake2' => 'twi-birthday-cake2',
            'twi-blanket2' => 'twi-blanket2',
            'twi-blender2' => 'twi-blender2',
            'twi-blender-phone2' => 'twi-blender-phone2',
            'twi-blind2' => 'twi-blind2',
            'twi-blog2' => 'twi-blog2',
            'twi-bold2' => 'twi-bold2',
            'twi-bolt2' => 'twi-bolt2',
            'twi-bomb2' => 'twi-bomb2',
            'twi-bone2' => 'twi-bone2',
            'twi-bone-break2' => 'twi-bone-break2',
            'twi-bong2' => 'twi-bong2',
            'twi-book2' => 'twi-book2',
            'twi-book-alt2' => 'twi-book-alt2',
            'twi-book-dead2' => 'twi-book-dead2',
            'twi-book-heart2' => 'twi-book-heart2',
            'twi-bookmark2' => 'twi-bookmark2',
            'twi-book-medical2' => 'twi-book-medical2',
            'twi-book-open2' => 'twi-book-open2',
            'twi-book-reader2' => 'twi-book-reader2',
            'twi-books2' => 'twi-books2',
            'twi-books-medical2' => 'twi-books-medical2',
            'twi-book-spells2' => 'twi-book-spells2',
            'twi-book-user2' => 'twi-book-user2',
            'twi-boot2' => 'twi-boot2',
            'twi-booth-curtain2' => 'twi-booth-curtain2',
            'twi-bow-arrow2' => 'twi-bow-arrow2',
            'twi-bowling-ball2' => 'twi-bowling-ball2',
            'twi-bowling-pins2' => 'twi-bowling-pins2',
            'twi-box2' => 'twi-box2',
            'twi-box-alt2' => 'twi-box-alt2',
            'twi-box-ballot2' => 'twi-box-ballot2',
            'twi-box-check2' => 'twi-box-check2',
            'twi-boxes2' => 'twi-boxes2',
            'twi-boxes-alt2' => 'twi-boxes-alt2',
            'twi-box-fragile2' => 'twi-box-fragile2',
            'twi-box-full2' => 'twi-box-full2',
            'twi-box-heart2' => 'twi-box-heart2',
            'twi-boxing-glove2' => 'twi-boxing-glove2',
            'twi-box-open2' => 'twi-box-open2',
            'twi-box-up2' => 'twi-box-up2',
            'twi-box-usd2' => 'twi-box-usd2',
            'twi-brackets2' => 'twi-brackets2',
            'twi-brackets-curly2' => 'twi-brackets-curly2',
            'twi-braille2' => 'twi-braille2',
            'twi-brain2' => 'twi-brain2',
            'twi-bread-loaf2' => 'twi-bread-loaf2',
            'twi-bread-slice2' => 'twi-bread-slice2',
            'twi-briefcase2' => 'twi-briefcase2',
            'twi-briefcase-medical2' => 'twi-briefcase-medical2',
            'twi-broadcast-tower2' => 'twi-broadcast-tower2',
            'twi-broom2' => 'twi-broom2',
            'twi-browser2' => 'twi-browser2',
            'twi-brush2' => 'twi-brush2',
            'twi-bug2' => 'twi-bug2',
            'twi-building2' => 'twi-building2',
            'twi-bullhorn2' => 'twi-bullhorn2',
            'twi-bullseye2' => 'twi-bullseye2',
            'twi-bullseye-arrow2' => 'twi-bullseye-arrow2',
            'twi-bullseye-pointer2' => 'twi-bullseye-pointer2',
            'twi-burn2' => 'twi-burn2',
            'twi-burrito2' => 'twi-burrito2',
            'twi-bus2' => 'twi-bus2',
            'twi-bus-alt2' => 'twi-bus-alt2',
            'twi-business-time2' => 'twi-business-time2',
            'twi-bus-school2' => 'twi-bus-school2',
            'twi-cabinet-filing2' => 'twi-cabinet-filing2',
            'twi-calculator2' => 'twi-calculator2',
            'twi-calculator-alt2' => 'twi-calculator-alt2',
            'twi-calendar2' => 'twi-calendar2',
            'twi-calendar-alt2' => 'twi-calendar-alt2',
            'twi-calendar-check2' => 'twi-calendar-check2',
            'twi-calendar-day2' => 'twi-calendar-day2',
            'twi-calendar-edit2' => 'twi-calendar-edit2',
            'twi-calendar-exclamation2' => 'twi-calendar-exclamation2',
            'twi-calendar-minus2' => 'twi-calendar-minus2',
            'twi-calendar-plus2' => 'twi-calendar-plus2',
            'twi-calendar-star2' => 'twi-calendar-star2',
            'twi-calendar-times2' => 'twi-calendar-times2',
            'twi-calendar-week2' => 'twi-calendar-week2',
            'twi-camera2' => 'twi-camera2',
            'twi-camera-alt2' => 'twi-camera-alt2',
            'twi-camera-retro2' => 'twi-camera-retro2',
            'twi-campfire2' => 'twi-campfire2',
            'twi-campground2' => 'twi-campground2',
            'twi-candle-holder2' => 'twi-candle-holder2',
            'twi-candy-cane2' => 'twi-candy-cane2',
            'twi-candy-corn2' => 'twi-candy-corn2',
            'twi-cannabis2' => 'twi-cannabis2',
            'twi-capsules2' => 'twi-capsules2',
            'twi-car2' => 'twi-car2',
            'twi-car-alt2' => 'twi-car-alt2',
            'twi-car-battery2' => 'twi-car-battery2',
            'twi-car-bump2' => 'twi-car-bump2',
            'twi-car-crash2' => 'twi-car-crash2',
            'twi-caret-circle-down2' => 'twi-caret-circle-down2',
            'twi-caret-circle-left2' => 'twi-caret-circle-left2',
            'twi-caret-circle-right2' => 'twi-caret-circle-right2',
            'twi-caret-circle-up2' => 'twi-caret-circle-up2',
            'twi-caret-down2' => 'twi-caret-down2',
            'twi-caret-left2' => 'twi-caret-left2',
            'twi-caret-right2' => 'twi-caret-right2',
            'twi-caret-square-down2' => 'twi-caret-square-down2',
            'twi-caret-square-left2' => 'twi-caret-square-left2',
            'twi-caret-square-right2' => 'twi-caret-square-right2',
            'twi-caret-square-up2' => 'twi-caret-square-up2',
            'twi-caret-up2' => 'twi-caret-up2',
            'twi-car-garage2' => 'twi-car-garage2',
            'twi-car-mechanic2' => 'twi-car-mechanic2',
            'twi-carrot2' => 'twi-carrot2',
            'twi-car-side2' => 'twi-car-side2',
            'twi-cart-arrow-down2' => 'twi-cart-arrow-down2',
            'twi-car-tilt2' => 'twi-car-tilt2',
            'twi-cart-plus2' => 'twi-cart-plus2',
            'twi-car-wash2' => 'twi-car-wash2',
            'twi-cash-register2' => 'twi-cash-register2',
            'twi-cat2' => 'twi-cat2',
            'twi-cauldron2' => 'twi-cauldron2',
            'twi-certificate2' => 'twi-certificate2',
            'twi-chair2' => 'twi-chair2',
            'twi-chair-office2' => 'twi-chair-office2',
            'twi-chalkboard2' => 'twi-chalkboard2',
            'twi-chalkboard-teacher2' => 'twi-chalkboard-teacher2',
            'twi-charging-station2' => 'twi-charging-station2',
            'twi-chart-area2' => 'twi-chart-area2',
            'twi-chart-bar2' => 'twi-chart-bar2',
            'twi-chart-line2' => 'twi-chart-line2',
            'twi-chart-line-down2' => 'twi-chart-line-down2',
            'twi-chart-network2' => 'twi-chart-network2',
            'twi-chart-pie2' => 'twi-chart-pie2',
            'twi-chart-pie-alt2' => 'twi-chart-pie-alt2',
            'twi-chart-scatter2' => 'twi-chart-scatter2',
            'twi-check2' => 'twi-check2',
            'twi-check-circle2' => 'twi-check-circle2',
            'twi-check-double2' => 'twi-check-double2',
            'twi-check-square2' => 'twi-check-square2',
            'twi-cheese2' => 'twi-cheese2',
            'twi-cheeseburger2' => 'twi-cheeseburger2',
            'twi-cheese-swiss2' => 'twi-cheese-swiss2',
            'twi-chess2' => 'twi-chess2',
            'twi-chess-bishop2' => 'twi-chess-bishop2',
            'twi-chess-bishop-alt2' => 'twi-chess-bishop-alt2',
            'twi-chess-board2' => 'twi-chess-board2',
            'twi-chess-clock2' => 'twi-chess-clock2',
            'twi-chess-clock-alt2' => 'twi-chess-clock-alt2',
            'twi-chess-king2' => 'twi-chess-king2',
            'twi-chess-king-alt2' => 'twi-chess-king-alt2',
            'twi-chess-knight2' => 'twi-chess-knight2',
            'twi-chess-knight-alt2' => 'twi-chess-knight-alt2',
            'twi-chess-pawn2' => 'twi-chess-pawn2',
            'twi-chess-pawn-alt2' => 'twi-chess-pawn-alt2',
            'twi-chess-queen2' => 'twi-chess-queen2',
            'twi-chess-queen-alt2' => 'twi-chess-queen-alt2',
            'twi-chess-rook2' => 'twi-chess-rook2',
            'twi-chess-rook-alt2' => 'twi-chess-rook-alt2',
            'twi-chevron-circle-down2' => 'twi-chevron-circle-down2',
            'twi-chevron-circle-left2' => 'twi-chevron-circle-left2',
            'twi-chevron-circle-right2' => 'twi-chevron-circle-right2',
            'twi-chevron-circle-up2' => 'twi-chevron-circle-up2',
            'twi-chevron-double-down2' => 'twi-chevron-double-down2',
            'twi-chevron-double-left2' => 'twi-chevron-double-left2',
            'twi-chevron-double-right2' => 'twi-chevron-double-right2',
            'twi-chevron-double-up2' => 'twi-chevron-double-up2',
            'twi-chevron-down2' => 'twi-chevron-down2',
            'twi-chevron-left2' => 'twi-chevron-left2',
            'twi-chevron-right2' => 'twi-chevron-right2',
            'twi-chevron-square-down2' => 'twi-chevron-square-down2',
            'twi-chevron-square-left2' => 'twi-chevron-square-left2',
            'twi-chevron-square-right2' => 'twi-chevron-square-right2',
            'twi-chevron-square-up2' => 'twi-chevron-square-up2',
            'twi-chevron-up2' => 'twi-chevron-up2',
            'twi-child2' => 'twi-child2',
            'twi-chimney2' => 'twi-chimney2',
            'twi-church2' => 'twi-church2',
            'twi-circle2' => 'twi-circle2',
            'twi-circle-notch2' => 'twi-circle-notch2',
            'twi-city2' => 'twi-city2',
            'twi-claw-marks2' => 'twi-claw-marks2',
            'twi-clinic-medical2' => 'twi-clinic-medical2',
            'twi-clipboard2' => 'twi-clipboard2',
            'twi-clipboard-check2' => 'twi-clipboard-check2',
            'twi-clipboard-list2' => 'twi-clipboard-list2',
            'twi-clipboard-list-check2' => 'twi-clipboard-list-check2',
            'twi-clipboard-prescription2' => 'twi-clipboard-prescription2',
            'twi-clipboard-user2' => 'twi-clipboard-user2',
            'twi-clock2' => 'twi-clock2',
            'twi-clone2' => 'twi-clone2',
            'twi-closed-captioning2' => 'twi-closed-captioning2',
            'twi-cloud2' => 'twi-cloud2',
            'twi-cloud-download2' => 'twi-cloud-download2',
            'twi-cloud-download-alt2' => 'twi-cloud-download-alt2',
            'twi-cloud-drizzle2' => 'twi-cloud-drizzle2',
            'twi-cloud-hail2' => 'twi-cloud-hail2',
            'twi-cloud-hail-mixed2' => 'twi-cloud-hail-mixed2',
            'twi-cloud-meatball2' => 'twi-cloud-meatball2',
            'twi-cloud-moon2' => 'twi-cloud-moon2',
            'twi-cloud-moon-rain2' => 'twi-cloud-moon-rain2',
            'twi-cloud-rain2' => 'twi-cloud-rain2',
            'twi-cloud-rainbow2' => 'twi-cloud-rainbow2',
            'twi-clouds2' => 'twi-clouds2',
            'twi-cloud-showers2' => 'twi-cloud-showers2',
            'twi-cloud-showers-heavy2' => 'twi-cloud-showers-heavy2',
            'twi-cloud-sleet2' => 'twi-cloud-sleet2',
            'twi-clouds-moon2' => 'twi-clouds-moon2',
            'twi-cloud-snow2' => 'twi-cloud-snow2',
            'twi-clouds-sun2' => 'twi-clouds-sun2',
            'twi-cloud-sun2' => 'twi-cloud-sun2',
            'twi-cloud-sun-rain2' => 'twi-cloud-sun-rain2',
            'twi-cloud-upload2' => 'twi-cloud-upload2',
            'twi-cloud-upload-alt2' => 'twi-cloud-upload-alt2',
            'twi-club2' => 'twi-club2',
            'twi-cocktail2' => 'twi-cocktail2',
            'twi-code2' => 'twi-code2',
            'twi-code-branch2' => 'twi-code-branch2',
            'twi-code-commit2' => 'twi-code-commit2',
            'twi-code-merge2' => 'twi-code-merge2',
            'twi-coffee2' => 'twi-coffee2',
            'twi-coffee-togo2' => 'twi-coffee-togo2',
            'twi-coffin2' => 'twi-coffin2',
            'twi-cog2' => 'twi-cog2',
            'twi-cogs2' => 'twi-cogs2',
            'twi-coins2' => 'twi-coins2',
            'twi-columns2' => 'twi-columns2',
            'twi-comment2' => 'twi-comment2',
            'twi-comment-alt2' => 'twi-comment-alt2',
            'twi-comment-alt-check2' => 'twi-comment-alt-check2',
            'twi-comment-alt-dollar2' => 'twi-comment-alt-dollar2',
            'twi-comment-alt-dots2' => 'twi-comment-alt-dots2',
            'twi-comment-alt-edit2' => 'twi-comment-alt-edit2',
            'twi-comment-alt-exclamation2' => 'twi-comment-alt-exclamation2',
            'twi-comment-alt-lines2' => 'twi-comment-alt-lines2',
            'twi-comment-alt-medical2' => 'twi-comment-alt-medical2',
            'twi-comment-alt-minus2' => 'twi-comment-alt-minus2',
            'twi-comment-alt-plus2' => 'twi-comment-alt-plus2',
            'twi-comment-alt-slash2' => 'twi-comment-alt-slash2',
            'twi-comment-alt-smile2' => 'twi-comment-alt-smile2',
            'twi-comment-alt-times2' => 'twi-comment-alt-times2',
            'twi-comment-check2' => 'twi-comment-check2',
            'twi-comment-dollar2' => 'twi-comment-dollar2',
            'twi-comment-dots2' => 'twi-comment-dots2',
            'twi-comment-edit2' => 'twi-comment-edit2',
            'twi-comment-exclamation2' => 'twi-comment-exclamation2',
            'twi-comment-lines2' => 'twi-comment-lines2',
            'twi-comment-medical2' => 'twi-comment-medical2',
            'twi-comment-minus2' => 'twi-comment-minus2',
            'twi-comment-plus2' => 'twi-comment-plus2',
            'twi-comments2' => 'twi-comments2',
            'twi-comments-alt2' => 'twi-comments-alt2',
            'twi-comments-alt-dollar2' => 'twi-comments-alt-dollar2',
            'twi-comments-dollar2' => 'twi-comments-dollar2',
            'twi-comment-slash2' => 'twi-comment-slash2',
            'twi-comment-smile2' => 'twi-comment-smile2',
            'twi-comment-times2' => 'twi-comment-times2',
            'twi-compact-disc2' => 'twi-compact-disc2',
            'twi-compass2' => 'twi-compass2',
            'twi-compass-slash2' => 'twi-compass-slash2',
            'twi-compress2' => 'twi-compress2',
            'twi-compress-alt2' => 'twi-compress-alt2',
            'twi-compress-arrows-alt2' => 'twi-compress-arrows-alt2',
            'twi-compress-wide2' => 'twi-compress-wide2',
            'twi-concierge-bell2' => 'twi-concierge-bell2',
            'twi-container-storage2' => 'twi-container-storage2',
            'twi-conveyor-belt2' => 'twi-conveyor-belt2',
            'twi-conveyor-belt-alt2' => 'twi-conveyor-belt-alt2',
            'twi-cookie2' => 'twi-cookie2',
            'twi-cookie-bite2' => 'twi-cookie-bite2',
            'twi-copy2' => 'twi-copy2',
            'twi-copyright2' => 'twi-copyright2',
            'twi-corn2' => 'twi-corn2',
            'twi-couch2' => 'twi-couch2',
            'twi-cow2' => 'twi-cow2',
            'twi-credit-card2' => 'twi-credit-card2',
            'twi-credit-card-blank2' => 'twi-credit-card-blank2',
            'twi-credit-card-front2' => 'twi-credit-card-front2',
            'twi-cricket2' => 'twi-cricket2',
            'twi-croissant2' => 'twi-croissant2',
            'twi-crop2' => 'twi-crop2',
            'twi-crop-alt2' => 'twi-crop-alt2',
            'twi-cross2' => 'twi-cross2',
            'twi-crosshairs2' => 'twi-crosshairs2',
            'twi-crow2' => 'twi-crow2',
            'twi-crown2' => 'twi-crown2',
            'twi-crutch2' => 'twi-crutch2',
            'twi-crutches2' => 'twi-crutches2',
            'twi-cube2' => 'twi-cube2',
            'twi-cubes2' => 'twi-cubes2',
            'twi-curling2' => 'twi-curling2',
            'twi-cut2' => 'twi-cut2',
            'twi-dagger2' => 'twi-dagger2',
            'twi-database2' => 'twi-database2',
            'twi-deaf2' => 'twi-deaf2',
            'twi-debug2' => 'twi-debug2',
            'twi-deer2' => 'twi-deer2',
            'twi-deer-rudolph2' => 'twi-deer-rudolph2',
            'twi-democrat2' => 'twi-democrat2',
            'twi-desktop2' => 'twi-desktop2',
            'twi-desktop-alt2' => 'twi-desktop-alt2',
            'twi-dewpoint2' => 'twi-dewpoint2',
            'twi-dharmachakra2' => 'twi-dharmachakra2',
            'twi-diagnoses2' => 'twi-diagnoses2',
            'twi-diamond2' => 'twi-diamond2',
            'twi-dice2' => 'twi-dice2',
            'twi-dice-d42' => 'twi-dice-d42',
            'twi-dice-d62' => 'twi-dice-d62',
            'twi-dice-d82' => 'twi-dice-d82',
            'twi-dice-d102' => 'twi-dice-d102',
            'twi-dice-d122' => 'twi-dice-d122',
            'twi-dice-d202' => 'twi-dice-d202',
            'twi-dice-five2' => 'twi-dice-five2',
            'twi-dice-four2' => 'twi-dice-four2',
            'twi-dice-one2' => 'twi-dice-one2',
            'twi-dice-six2' => 'twi-dice-six2',
            'twi-dice-three2' => 'twi-dice-three2',
            'twi-dice-two2' => 'twi-dice-two2',
            'twi-digital-tachograph2' => 'twi-digital-tachograph2',
            'twi-diploma2' => 'twi-diploma2',
            'twi-directions2' => 'twi-directions2',
            'twi-disease2' => 'twi-disease2',
            'twi-divide2' => 'twi-divide2',
            'twi-dizzy2' => 'twi-dizzy2',
            'twi-dna2' => 'twi-dna2',
            'twi-dog2' => 'twi-dog2',
            'twi-dog-leashed2' => 'twi-dog-leashed2',
            'twi-dollar-sign2' => 'twi-dollar-sign2',
            'twi-dolly2' => 'twi-dolly2',
            'twi-dolly-empty2' => 'twi-dolly-empty2',
            'twi-dolly-flatbed2' => 'twi-dolly-flatbed2',
            'twi-dolly-flatbed-alt2' => 'twi-dolly-flatbed-alt2',
            'twi-dolly-flatbed-empty2' => 'twi-dolly-flatbed-empty2',
            'twi-donate2' => 'twi-donate2',
            'twi-do-not-enter2' => 'twi-do-not-enter2',
            'twi-door-closed2' => 'twi-door-closed2',
            'twi-door-open2' => 'twi-door-open2',
            'twi-dot-circle2' => 'twi-dot-circle2',
            'twi-dove2' => 'twi-dove2',
            'twi-download2' => 'twi-download2',
            'twi-drafting-compass2' => 'twi-drafting-compass2',
            'twi-dragon2' => 'twi-dragon2',
            'twi-draw-circle2' => 'twi-draw-circle2',
            'twi-draw-polygon2' => 'twi-draw-polygon2',
            'twi-draw-square2' => 'twi-draw-square2',
            'twi-dreidel2' => 'twi-dreidel2',
            'twi-drum2' => 'twi-drum2',
            'twi-drum-steelpan2' => 'twi-drum-steelpan2',
            'twi-drumstick2' => 'twi-drumstick2',
            'twi-drumstick-bite2' => 'twi-drumstick-bite2',
            'twi-duck2' => 'twi-duck2',
            'twi-dumbbell2' => 'twi-dumbbell2',
            'twi-dumpster2' => 'twi-dumpster2',
            'twi-dumpster-fire2' => 'twi-dumpster-fire2',
            'twi-dungeon2' => 'twi-dungeon2',
            'twi-ear2' => 'twi-ear2',
            'twi-ear-muffs2' => 'twi-ear-muffs2',
            'twi-eclipse2' => 'twi-eclipse2',
            'twi-eclipse-alt2' => 'twi-eclipse-alt2',
            'twi-edit2' => 'twi-edit2',
            'twi-egg2' => 'twi-egg2',
            'twi-egg-fried2' => 'twi-egg-fried2',
            'twi-eject2' => 'twi-eject2',
            'twi-elephant2' => 'twi-elephant2',
            'twi-ellipsis-h2' => 'twi-ellipsis-h2',
            'twi-ellipsis-h-alt2' => 'twi-ellipsis-h-alt2',
            'twi-ellipsis-v2' => 'twi-ellipsis-v2',
            'twi-ellipsis-v-alt2' => 'twi-ellipsis-v-alt2',
            'twi-empty-set2' => 'twi-empty-set2',
            'twi-engine-warning2' => 'twi-engine-warning2',
            'twi-envelope2' => 'twi-envelope2',
            'twi-envelope-open2' => 'twi-envelope-open2',
            'twi-envelope-open-dollar2' => 'twi-envelope-open-dollar2',
            'twi-envelope-open-text2' => 'twi-envelope-open-text2',
            'twi-envelope-square2' => 'twi-envelope-square2',
            'twi-equals2' => 'twi-equals2',
            'twi-eraser2' => 'twi-eraser2',
            'twi-ethernet2' => 'twi-ethernet2',
            'twi-euro-sign2' => 'twi-euro-sign2',
            'twi-exchange2' => 'twi-exchange2',
            'twi-exchange-alt2' => 'twi-exchange-alt2',
            'twi-exclamation2' => 'twi-exclamation2',
            'twi-exclamation-circle2' => 'twi-exclamation-circle2',
            'twi-exclamation-square2' => 'twi-exclamation-square2',
            'twi-exclamation-triangle2' => 'twi-exclamation-triangle2',
            'twi-expand2' => 'twi-expand2',
            'twi-expand-alt2' => 'twi-expand-alt2',
            'twi-expand-arrows2' => 'twi-expand-arrows2',
            'twi-expand-arrows-alt2' => 'twi-expand-arrows-alt2',
            'twi-expand-wide2' => 'twi-expand-wide2',
            'twi-external-link2' => 'twi-external-link2',
            'twi-external-link-alt2' => 'twi-external-link-alt2',
            'twi-external-link-square2' => 'twi-external-link-square2',
            'twi-external-link-square-alt2' => 'twi-external-link-square-alt2',
            'twi-eye2' => 'twi-eye2',
            'twi-eye-dropper2' => 'twi-eye-dropper2',
            'twi-eye-evil2' => 'twi-eye-evil2',
            'twi-eye-slash2' => 'twi-eye-slash2',
            'twi-fast-backward2' => 'twi-fast-backward2',
            'twi-fast-forward2' => 'twi-fast-forward2',
            'twi-fax2' => 'twi-fax2',
            'twi-feather2' => 'twi-feather2',
            'twi-feather-alt2' => 'twi-feather-alt2',
            'twi-female2' => 'twi-female2',
            'twi-field-hockey2' => 'twi-field-hockey2',
            'twi-fighter-jet2' => 'twi-fighter-jet2',
            'twi-file2' => 'twi-file2',
            'twi-file-alt2' => 'twi-file-alt2',
            'twi-file-archive2' => 'twi-file-archive2',
            'twi-file-audio2' => 'twi-file-audio2',
            'twi-file-certificate2' => 'twi-file-certificate2',
            'twi-file-chart-line2' => 'twi-file-chart-line2',
            'twi-file-chart-pie2' => 'twi-file-chart-pie2',
            'twi-file-check2' => 'twi-file-check2',
            'twi-file-code2' => 'twi-file-code2',
            'twi-file-contract2' => 'twi-file-contract2',
            'twi-file-csv2' => 'twi-file-csv2',
            'twi-file-download2' => 'twi-file-download2',
            'twi-file-edit2' => 'twi-file-edit2',
            'twi-file-excel2' => 'twi-file-excel2',
            'twi-file-exclamation2' => 'twi-file-exclamation2',
            'twi-file-export2' => 'twi-file-export2',
            'twi-file-image2' => 'twi-file-image2',
            'twi-file-import2' => 'twi-file-import2',
            'twi-file-invoice2' => 'twi-file-invoice2',
            'twi-file-invoice-dollar2' => 'twi-file-invoice-dollar2',
            'twi-file-medical2' => 'twi-file-medical2',
            'twi-file-medical-alt2' => 'twi-file-medical-alt2',
            'twi-file-minus2' => 'twi-file-minus2',
            'twi-file-pdf2' => 'twi-file-pdf2',
            'twi-file-plus2' => 'twi-file-plus2',
            'twi-file-powerpoint2' => 'twi-file-powerpoint2',
            'twi-file-prescription2' => 'twi-file-prescription2',
            'twi-file-signature2' => 'twi-file-signature2',
            'twi-files-medical2' => 'twi-files-medical2',
            'twi-file-spreadsheet2' => 'twi-file-spreadsheet2',
            'twi-file-times2' => 'twi-file-times2',
            'twi-file-upload2' => 'twi-file-upload2',
            'twi-file-user2' => 'twi-file-user2',
            'twi-file-video2' => 'twi-file-video2',
            'twi-file-word2' => 'twi-file-word2',
            'twi-fill2' => 'twi-fill2',
            'twi-fill-drip2' => 'twi-fill-drip2',
            'twi-film2' => 'twi-film2',
            'twi-film-alt2' => 'twi-film-alt2',
            'twi-filter2' => 'twi-filter2',
            'twi-fingerprint2' => 'twi-fingerprint2',
            'twi-fire2' => 'twi-fire2',
            'twi-fire-alt2' => 'twi-fire-alt2',
            'twi-fire-extinguisher2' => 'twi-fire-extinguisher2',
            'twi-fireplace2' => 'twi-fireplace2',
            'twi-fire-smoke2' => 'twi-fire-smoke2',
            'twi-first-aid2' => 'twi-first-aid2',
            'twi-fish2' => 'twi-fish2',
            'twi-fish-cooked2' => 'twi-fish-cooked2',
            'twi-fist-raised2' => 'twi-fist-raised2',
            'twi-flag2' => 'twi-flag2',
            'twi-flag-alt2' => 'twi-flag-alt2',
            'twi-flag-checkered2' => 'twi-flag-checkered2',
            'twi-flag-usa2' => 'twi-flag-usa2',
            'twi-flame2' => 'twi-flame2',
            'twi-flask2' => 'twi-flask2',
            'twi-flask-poison2' => 'twi-flask-poison2',
            'twi-flask-potion2' => 'twi-flask-potion2',
            'twi-flower2' => 'twi-flower2',
            'twi-flower-daffodil2' => 'twi-flower-daffodil2',
            'twi-flower-tulip2' => 'twi-flower-tulip2',
            'twi-flushed2' => 'twi-flushed2',
            'twi-fog2' => 'twi-fog2',
            'twi-folder2' => 'twi-folder2',
            'twi-folder-minus2' => 'twi-folder-minus2',
            'twi-folder-open2' => 'twi-folder-open2',
            'twi-folder-plus2' => 'twi-folder-plus2',
            'twi-folders2' => 'twi-folders2',
            'twi-folder-times2' => 'twi-folder-times2',
            'twi-folder-tree2' => 'twi-folder-tree2',
            'twi-font2' => 'twi-font2',
            'twi-font-awesome-logo-full2' => 'twi-font-awesome-logo-full2',
            'twi-football-ball2' => 'twi-football-ball2',
            'twi-football-helmet2' => 'twi-football-helmet2',
            'twi-forklift2' => 'twi-forklift2',
            'twi-forward2' => 'twi-forward2',
            'twi-fragile2' => 'twi-fragile2',
            'twi-french-fries2' => 'twi-french-fries2',
            'twi-frog2' => 'twi-frog2',
            'twi-frosty-head2' => 'twi-frosty-head2',
            'twi-frown2' => 'twi-frown2',
            'twi-frown-open2' => 'twi-frown-open2',
            'twi-function2' => 'twi-function2',
            'twi-funnel-dollar2' => 'twi-funnel-dollar2',
            'twi-futbol2' => 'twi-futbol2',
            'twi-gamepad2' => 'twi-gamepad2',
            'twi-gas-pump2' => 'twi-gas-pump2',
            'twi-gas-pump-slash2' => 'twi-gas-pump-slash2',
            'twi-gavel2' => 'twi-gavel2',
            'twi-gem2' => 'twi-gem2',
            'twi-genderless2' => 'twi-genderless2',
            'twi-ghost2' => 'twi-ghost2',
            'twi-gift2' => 'twi-gift2',
            'twi-gift-card2' => 'twi-gift-card2',
            'twi-gifts2' => 'twi-gifts2',
            'twi-gingerbread-man2' => 'twi-gingerbread-man2',
            'twi-glass2' => 'twi-glass2',
            'twi-glass-champagne2' => 'twi-glass-champagne2',
            'twi-glass-cheers2' => 'twi-glass-cheers2',
            'twi-glasses2' => 'twi-glasses2',
            'twi-glasses-alt2' => 'twi-glasses-alt2',
            'twi-glass-martini2' => 'twi-glass-martini2',
            'twi-glass-martini-alt2' => 'twi-glass-martini-alt2',
            'twi-glass-whiskey2' => 'twi-glass-whiskey2',
            'twi-glass-whiskey-rocks2' => 'twi-glass-whiskey-rocks2',
            'twi-globe2' => 'twi-globe2',
            'twi-globe-africa2' => 'twi-globe-africa2',
            'twi-globe-americas2' => 'twi-globe-americas2',
            'twi-globe-asia2' => 'twi-globe-asia2',
            'twi-globe-europe2' => 'twi-globe-europe2',
            'twi-globe-snow2' => 'twi-globe-snow2',
            'twi-globe-stand2' => 'twi-globe-stand2',
            'twi-golf-ball2' => 'twi-golf-ball2',
            'twi-golf-club2' => 'twi-golf-club2',
            'twi-gopuram2' => 'twi-gopuram2',
            'twi-graduation-cap2' => 'twi-graduation-cap2',
            'twi-greater-than2' => 'twi-greater-than2',
            'twi-greater-than-equal2' => 'twi-greater-than-equal2',
            'twi-grimace2' => 'twi-grimace2',
            'twi-grin2' => 'twi-grin2',
            'twi-grin-alt2' => 'twi-grin-alt2',
            'twi-grin-beam2' => 'twi-grin-beam2',
            'twi-grin-beam-sweat2' => 'twi-grin-beam-sweat2',
            'twi-grin-hearts2' => 'twi-grin-hearts2',
            'twi-grin-squint2' => 'twi-grin-squint2',
            'twi-grin-squint-tears2' => 'twi-grin-squint-tears2',
            'twi-grin-stars2' => 'twi-grin-stars2',
            'twi-grin-tears2' => 'twi-grin-tears2',
            'twi-grin-tongue2' => 'twi-grin-tongue2',
            'twi-grin-tongue-squint2' => 'twi-grin-tongue-squint2',
            'twi-grin-tongue-wink2' => 'twi-grin-tongue-wink2',
            'twi-grin-wink2' => 'twi-grin-wink2',
            'twi-grip-horizontal2' => 'twi-grip-horizontal2',
            'twi-grip-lines2' => 'twi-grip-lines2',
            'twi-grip-lines-vertical2' => 'twi-grip-lines-vertical2',
            'twi-grip-vertical2' => 'twi-grip-vertical2',
            'twi-guitar2' => 'twi-guitar2',
            'twi-h12' => 'twi-h12',
            'twi-h22' => 'twi-h22',
            'twi-h32' => 'twi-h32',
            'twi-hamburger2' => 'twi-hamburger2',
            'twi-hammer2' => 'twi-hammer2',
            'twi-hammer-war2' => 'twi-hammer-war2',
            'twi-hamsa2' => 'twi-hamsa2',
            'twi-hand-heart2' => 'twi-hand-heart2',
            'twi-hand-holding2' => 'twi-hand-holding2',
            'twi-hand-holding-box2' => 'twi-hand-holding-box2',
            'twi-hand-holding-heart2' => 'twi-hand-holding-heart2',
            'twi-hand-holding-magic2' => 'twi-hand-holding-magic2',
            'twi-hand-holding-seedling2' => 'twi-hand-holding-seedling2',
            'twi-hand-holding-usd2' => 'twi-hand-holding-usd2',
            'twi-hand-holding-water2' => 'twi-hand-holding-water2',
            'twi-hand-lizard2' => 'twi-hand-lizard2',
            'twi-hand-middle-finger2' => 'twi-hand-middle-finger2',
            'twi-hand-paper2' => 'twi-hand-paper2',
            'twi-hand-peace2' => 'twi-hand-peace2',
            'twi-hand-point-down2' => 'twi-hand-point-down2',
            'twi-hand-pointer2' => 'twi-hand-pointer2',
            'twi-hand-point-left2' => 'twi-hand-point-left2',
            'twi-hand-point-right2' => 'twi-hand-point-right2',
            'twi-hand-point-up2' => 'twi-hand-point-up2',
            'twi-hand-receiving2' => 'twi-hand-receiving2',
            'twi-hand-rock2' => 'twi-hand-rock2',
            'twi-hands2' => 'twi-hands2',
            'twi-hand-scissors2' => 'twi-hand-scissors2',
            'twi-handshake2' => 'twi-handshake2',
            'twi-handshake-alt2' => 'twi-handshake-alt2',
            'twi-hands-heart2' => 'twi-hands-heart2',
            'twi-hands-helping2' => 'twi-hands-helping2',
            'twi-hand-spock2' => 'twi-hand-spock2',
            'twi-hands-usd2' => 'twi-hands-usd2',
            'twi-hanukiah2' => 'twi-hanukiah2',
            'twi-hard-hat2' => 'twi-hard-hat2',
            'twi-hashtag2' => 'twi-hashtag2',
            'twi-hat-santa2' => 'twi-hat-santa2',
            'twi-hat-winter2' => 'twi-hat-winter2',
            'twi-hat-witch2' => 'twi-hat-witch2',
            'twi-hat-wizard2' => 'twi-hat-wizard2',
            'twi-haykal2' => 'twi-haykal2',
            'twi-hdd2' => 'twi-hdd2',
            'twi-heading2' => 'twi-heading2',
            'twi-headphones2' => 'twi-headphones2',
            'twi-headphones-alt2' => 'twi-headphones-alt2',
            'twi-headset2' => 'twi-headset2',
            'twi-head-side2' => 'twi-head-side2',
            'twi-head-side-brain2' => 'twi-head-side-brain2',
            'twi-head-side-medical2' => 'twi-head-side-medical2',
            'twi-head-vr2' => 'twi-head-vr2',
            'twi-heart2' => 'twi-heart2',
            'twi-heartbeat2' => 'twi-heartbeat2',
            'twi-heart-broken2' => 'twi-heart-broken2',
            'twi-heart-circle2' => 'twi-heart-circle2',
            'twi-heart-rate2' => 'twi-heart-rate2',
            'twi-heart-square2' => 'twi-heart-square2',
            'twi-helicopter2' => 'twi-helicopter2',
            'twi-helmet-battle2' => 'twi-helmet-battle2',
            'twi-hexagon2' => 'twi-hexagon2',
            'twi-highlighter2' => 'twi-highlighter2',
            'twi-hiking2' => 'twi-hiking2',
            'twi-hippo2' => 'twi-hippo2',
            'twi-history2' => 'twi-history2',
            'twi-hockey-mask2' => 'twi-hockey-mask2',
            'twi-hockey-puck2' => 'twi-hockey-puck2',
            'twi-hockey-sticks2' => 'twi-hockey-sticks2',
            'twi-holly-berry2' => 'twi-holly-berry2',
            'twi-home2' => 'twi-home2',
            'twi-home-alt2' => 'twi-home-alt2',
            'twi-home-heart2' => 'twi-home-heart2',
            'twi-home-lg2' => 'twi-home-lg2',
            'twi-home-lg-alt2' => 'twi-home-lg-alt2',
            'twi-hood-cloak2' => 'twi-hood-cloak2',
            'twi-horse2' => 'twi-horse2',
            'twi-horse-head2' => 'twi-horse-head2',
            'twi-hospital2' => 'twi-hospital2',
            'twi-hospital-alt2' => 'twi-hospital-alt2',
            'twi-hospitals2' => 'twi-hospitals2',
            'twi-hospital-symbol2' => 'twi-hospital-symbol2',
            'twi-hospital-user2' => 'twi-hospital-user2',
            'twi-hotdog2' => 'twi-hotdog2',
            'twi-hotel2' => 'twi-hotel2',
            'twi-hot-tub2' => 'twi-hot-tub2',
            'twi-hourglass2' => 'twi-hourglass2',
            'twi-hourglass-end2' => 'twi-hourglass-end2',
            'twi-hourglass-half2' => 'twi-hourglass-half2',
            'twi-hourglass-start2' => 'twi-hourglass-start2',
            'twi-house-damage2' => 'twi-house-damage2',
            'twi-house-flood2' => 'twi-house-flood2',
            'twi-hryvnia2' => 'twi-hryvnia2',
            'twi-h-square2' => 'twi-h-square2',
            'twi-humidity2' => 'twi-humidity2',
            'twi-hurricane2' => 'twi-hurricane2',
            'twi-ice-cream2' => 'twi-ice-cream2',
            'twi-ice-skate2' => 'twi-ice-skate2',
            'twi-icicles2' => 'twi-icicles2',
            'twi-i-cursor2' => 'twi-i-cursor2',
            'twi-id-badge2' => 'twi-id-badge2',
            'twi-id-card2' => 'twi-id-card2',
            'twi-id-card-alt2' => 'twi-id-card-alt2',
            'twi-igloo2' => 'twi-igloo2',
            'twi-image2' => 'twi-image2',
            'twi-images2' => 'twi-images2',
            'twi-inbox2' => 'twi-inbox2',
            'twi-inbox-in2' => 'twi-inbox-in2',
            'twi-inbox-out2' => 'twi-inbox-out2',
            'twi-indent2' => 'twi-indent2',
            'twi-industry2' => 'twi-industry2',
            'twi-industry-alt2' => 'twi-industry-alt2',
            'twi-infinity2' => 'twi-infinity2',
            'twi-info2' => 'twi-info2',
            'twi-info-circle2' => 'twi-info-circle2',
            'twi-info-square2' => 'twi-info-square2',
            'twi-inhaler2' => 'twi-inhaler2',
            'twi-integral2' => 'twi-integral2',
            'twi-intersection2' => 'twi-intersection2',
            'twi-inventory2' => 'twi-inventory2',
            'twi-island-tropical2' => 'twi-island-tropical2',
            'twi-italic2' => 'twi-italic2',
            'twi-jack-o-lantern2' => 'twi-jack-o-lantern2',
            'twi-jedi2' => 'twi-jedi2',
            'twi-joint2' => 'twi-joint2',
            'twi-journal-whills2' => 'twi-journal-whills2',
            'twi-kaaba2' => 'twi-kaaba2',
            'twi-key2' => 'twi-key2',
            'twi-keyboard2' => 'twi-keyboard2',
            'twi-keynote2' => 'twi-keynote2',
            'twi-key-skeleton2' => 'twi-key-skeleton2',
            'twi-khanda2' => 'twi-khanda2',
            'twi-kidneys2' => 'twi-kidneys2',
            'twi-kiss2' => 'twi-kiss2',
            'twi-kiss-beam2' => 'twi-kiss-beam2',
            'twi-kiss-wink-heart2' => 'twi-kiss-wink-heart2',
            'twi-kite2' => 'twi-kite2',
            'twi-kiwi-bird2' => 'twi-kiwi-bird2',
            'twi-knife-kitchen2' => 'twi-knife-kitchen2',
            'twi-lambda2' => 'twi-lambda2',
            'twi-lamp2' => 'twi-lamp2',
            'twi-landmark2' => 'twi-landmark2',
            'twi-landmark-alt2' => 'twi-landmark-alt2',
            'twi-language2' => 'twi-language2',
            'twi-laptop2' => 'twi-laptop2',
            'twi-laptop-code2' => 'twi-laptop-code2',
            'twi-laptop-medical2' => 'twi-laptop-medical2',
            'twi-laugh2' => 'twi-laugh2',
            'twi-laugh-beam2' => 'twi-laugh-beam2',
            'twi-laugh-squint2' => 'twi-laugh-squint2',
            'twi-laugh-wink2' => 'twi-laugh-wink2',
            'twi-layer-group2' => 'twi-layer-group2',
            'twi-layer-minus2' => 'twi-layer-minus2',
            'twi-layer-plus2' => 'twi-layer-plus2',
            'twi-leaf2' => 'twi-leaf2',
            'twi-leaf-heart2' => 'twi-leaf-heart2',
            'twi-leaf-maple2' => 'twi-leaf-maple2',
            'twi-leaf-oak2' => 'twi-leaf-oak2',
            'twi-lemon2' => 'twi-lemon2',
            'twi-less-than2' => 'twi-less-than2',
            'twi-less-than-equal2' => 'twi-less-than-equal2',
            'twi-level-down2' => 'twi-level-down2',
            'twi-level-down-alt2' => 'twi-level-down-alt2',
            'twi-level-up2' => 'twi-level-up2',
            'twi-level-up-alt2' => 'twi-level-up-alt2',
            'twi-life-ring2' => 'twi-life-ring2',
            'twi-lightbulb2' => 'twi-lightbulb2',
            'twi-lightbulb-dollar2' => 'twi-lightbulb-dollar2',
            'twi-lightbulb-exclamation2' => 'twi-lightbulb-exclamation2',
            'twi-lightbulb-on2' => 'twi-lightbulb-on2',
            'twi-lightbulb-slash2' => 'twi-lightbulb-slash2',
            'twi-lights-holiday2' => 'twi-lights-holiday2',
            'twi-link2' => 'twi-link2',
            'twi-lips2' => 'twi-lips2',
            'twi-lira-sign2' => 'twi-lira-sign2',
            'twi-list2' => 'twi-list2',
            'twi-list-alt2' => 'twi-list-alt2',
            'twi-list-ol2' => 'twi-list-ol2',
            'twi-list-ul2' => 'twi-list-ul2',
            'twi-location2' => 'twi-location2',
            'twi-location-arrow2' => 'twi-location-arrow2',
            'twi-location-circle2' => 'twi-location-circle2',
            'twi-location-slash2' => 'twi-location-slash2',
            'twi-lock2' => 'twi-lock2',
            'twi-lock-alt2' => 'twi-lock-alt2',
            'twi-lock-open2' => 'twi-lock-open2',
            'twi-lock-open-alt2' => 'twi-lock-open-alt2',
            'twi-long-arrow-alt-down2' => 'twi-long-arrow-alt-down2',
            'twi-long-arrow-alt-left2' => 'twi-long-arrow-alt-left2',
            'twi-long-arrow-alt-right2' => 'twi-long-arrow-alt-right2',
            'twi-long-arrow-alt-up2' => 'twi-long-arrow-alt-up2',
            'twi-long-arrow-down2' => 'twi-long-arrow-down2',
            'twi-long-arrow-left2' => 'twi-long-arrow-left2',
            'twi-long-arrow-right2' => 'twi-long-arrow-right2',
            'twi-long-arrow-up2' => 'twi-long-arrow-up2',
            'twi-loveseat2' => 'twi-loveseat2',
            'twi-low-vision2' => 'twi-low-vision2',
            'twi-luchador2' => 'twi-luchador2',
            'twi-luggage-cart2' => 'twi-luggage-cart2',
            'twi-lungs2' => 'twi-lungs2',
            'twi-mace2' => 'twi-mace2',
            'twi-magic2' => 'twi-magic2',
            'twi-magnet2' => 'twi-magnet2',
            'twi-mailbox2' => 'twi-mailbox2',
            'twi-mail-bulk2' => 'twi-mail-bulk2',
            'twi-male2' => 'twi-male2',
            'twi-mandolin2' => 'twi-mandolin2',
            'twi-map2' => 'twi-map2',
            'twi-map-marked2' => 'twi-map-marked2',
            'twi-map-marked-alt2' => 'twi-map-marked-alt2',
            'twi-map-marker2' => 'twi-map-marker2',
            'twi-map-marker-alt2' => 'twi-map-marker-alt2',
            'twi-map-marker-alt-slash2' => 'twi-map-marker-alt-slash2',
            'twi-map-marker-check2' => 'twi-map-marker-check2',
            'twi-map-marker-edit2' => 'twi-map-marker-edit2',
            'twi-map-marker-exclamation2' => 'twi-map-marker-exclamation2',
            'twi-map-marker-minus2' => 'twi-map-marker-minus2',
            'twi-map-marker-plus2' => 'twi-map-marker-plus2',
            'twi-map-marker-question2' => 'twi-map-marker-question2',
            'twi-map-marker-slash2' => 'twi-map-marker-slash2',
            'twi-map-marker-smile2' => 'twi-map-marker-smile2',
            'twi-map-marker-times2' => 'twi-map-marker-times2',
            'twi-map-pin2' => 'twi-map-pin2',
            'twi-map-signs2' => 'twi-map-signs2',
            'twi-marker2' => 'twi-marker2',
            'twi-mars2' => 'twi-mars2',
            'twi-mars-double2' => 'twi-mars-double2',
            'twi-mars-stroke2' => 'twi-mars-stroke2',
            'twi-mars-stroke-h2' => 'twi-mars-stroke-h2',
            'twi-mars-stroke-v2' => 'twi-mars-stroke-v2',
            'twi-mask2' => 'twi-mask2',
            'twi-meat2' => 'twi-meat2',
            'twi-medal2' => 'twi-medal2',
            'twi-medkit2' => 'twi-medkit2',
            'twi-megaphone2' => 'twi-megaphone2',
            'twi-meh2' => 'twi-meh2',
            'twi-meh-blank2' => 'twi-meh-blank2',
            'twi-meh-rolling-eyes2' => 'twi-meh-rolling-eyes2',
            'twi-memory2' => 'twi-memory2',
            'twi-menorah2' => 'twi-menorah2',
            'twi-mercury2' => 'twi-mercury2',
            'twi-meteor2' => 'twi-meteor2',
            'twi-microchip2' => 'twi-microchip2',
            'twi-microphone2' => 'twi-microphone2',
            'twi-microphone-alt2' => 'twi-microphone-alt2',
            'twi-microphone-alt-slash2' => 'twi-microphone-alt-slash2',
            'twi-microphone-slash2' => 'twi-microphone-slash2',
            'twi-microscope2' => 'twi-microscope2',
            'twi-mind-share2' => 'twi-mind-share2',
            'twi-minus2' => 'twi-minus2',
            'twi-minus-circle2' => 'twi-minus-circle2',
            'twi-minus-hexagon2' => 'twi-minus-hexagon2',
            'twi-minus-octagon2' => 'twi-minus-octagon2',
            'twi-minus-square2' => 'twi-minus-square2',
            'twi-mistletoe2' => 'twi-mistletoe2',
            'twi-mitten2' => 'twi-mitten2',
            'twi-mobile2' => 'twi-mobile2',
            'twi-mobile-alt2' => 'twi-mobile-alt2',
            'twi-mobile-android2' => 'twi-mobile-android2',
            'twi-mobile-android-alt2' => 'twi-mobile-android-alt2',
            'twi-money-bill2' => 'twi-money-bill2',
            'twi-money-bill-alt2' => 'twi-money-bill-alt2',
            'twi-money-bill-wave2' => 'twi-money-bill-wave2',
            'twi-money-bill-wave-alt2' => 'twi-money-bill-wave-alt2',
            'twi-money-check2' => 'twi-money-check2',
            'twi-money-check-alt2' => 'twi-money-check-alt2',
            'twi-monitor-heart-rate2' => 'twi-monitor-heart-rate2',
            'twi-monkey2' => 'twi-monkey2',
            'twi-monument2' => 'twi-monument2',
            'twi-moon2' => 'twi-moon2',
            'twi-moon-cloud2' => 'twi-moon-cloud2',
            'twi-moon-stars2' => 'twi-moon-stars2',
            'twi-mortar-pestle2' => 'twi-mortar-pestle2',
            'twi-mosque2' => 'twi-mosque2',
            'twi-motorcycle2' => 'twi-motorcycle2',
            'twi-mountain2' => 'twi-mountain2',
            'twi-mountains2' => 'twi-mountains2',
            'twi-mouse-pointer2' => 'twi-mouse-pointer2',
            'twi-mug-hot2' => 'twi-mug-hot2',
            'twi-mug-marshmallows2' => 'twi-mug-marshmallows2',
            'twi-music2' => 'twi-music2',
            'twi-narwhal2' => 'twi-narwhal2',
            'twi-network-wired2' => 'twi-network-wired2',
            'twi-neuter2' => 'twi-neuter2',
            'twi-newspaper2' => 'twi-newspaper2',
            'twi-not-equal2' => 'twi-not-equal2',
            'twi-notes-medical2' => 'twi-notes-medical2',
            'twi-object-group2' => 'twi-object-group2',
            'twi-object-ungroup2' => 'twi-object-ungroup2',
            'twi-octagon2' => 'twi-octagon2',
            'twi-oil-can2' => 'twi-oil-can2',
            'twi-oil-temp2' => 'twi-oil-temp2',
            'twi-om2' => 'twi-om2',
            'twi-omega2' => 'twi-omega2',
            'twi-ornament2' => 'twi-ornament2',
            'twi-otter2' => 'twi-otter2',
            'twi-outdent2' => 'twi-outdent2',
            'twi-pager2' => 'twi-pager2',
            'twi-paint-brush2' => 'twi-paint-brush2',
            'twi-paint-brush-alt2' => 'twi-paint-brush-alt2',
            'twi-paint-roller2' => 'twi-paint-roller2',
            'twi-palette2' => 'twi-palette2',
            'twi-pallet2' => 'twi-pallet2',
            'twi-pallet-alt2' => 'twi-pallet-alt2',
            'twi-paperclip2' => 'twi-paperclip2',
            'twi-paper-plane2' => 'twi-paper-plane2',
            'twi-parachute-box2' => 'twi-parachute-box2',
            'twi-paragraph2' => 'twi-paragraph2',
            'twi-parking2' => 'twi-parking2',
            'twi-parking-circle2' => 'twi-parking-circle2',
            'twi-parking-circle-slash2' => 'twi-parking-circle-slash2',
            'twi-parking-slash2' => 'twi-parking-slash2',
            'twi-passport2' => 'twi-passport2',
            'twi-pastafarianism2' => 'twi-pastafarianism2',
            'twi-paste2' => 'twi-paste2',
            'twi-pause2' => 'twi-pause2',
            'twi-pause-circle2' => 'twi-pause-circle2',
            'twi-paw2' => 'twi-paw2',
            'twi-paw-alt2' => 'twi-paw-alt2',
            'twi-paw-claws2' => 'twi-paw-claws2',
            'twi-peace2' => 'twi-peace2',
            'twi-pegasus2' => 'twi-pegasus2',
            'twi-pen2' => 'twi-pen2',
            'twi-pen-alt2' => 'twi-pen-alt2',
            'twi-pencil2' => 'twi-pencil2',
            'twi-pencil-alt2' => 'twi-pencil-alt2',
            'twi-pencil-paintbrush2' => 'twi-pencil-paintbrush2',
            'twi-pencil-ruler2' => 'twi-pencil-ruler2',
            'twi-pen-fancy2' => 'twi-pen-fancy2',
            'twi-pennant2' => 'twi-pennant2',
            'twi-pen-nib2' => 'twi-pen-nib2',
            'twi-pen-square2' => 'twi-pen-square2',
            'twi-people-carry2' => 'twi-people-carry2',
            'twi-pepper-hot2' => 'twi-pepper-hot2',
            'twi-percent2' => 'twi-percent2',
            'twi-percentage2' => 'twi-percentage2',
            'twi-person-booth2' => 'twi-person-booth2',
            'twi-person-carry2' => 'twi-person-carry2',
            'twi-person-dolly2' => 'twi-person-dolly2',
            'twi-person-dolly-empty2' => 'twi-person-dolly-empty2',
            'twi-person-sign2' => 'twi-person-sign2',
            'twi-phone2' => 'twi-phone2',
            'twi-phone-office2' => 'twi-phone-office2',
            'twi-phone-plus2' => 'twi-phone-plus2',
            'twi-phone-slash2' => 'twi-phone-slash2',
            'twi-phone-square2' => 'twi-phone-square2',
            'twi-phone-volume2' => 'twi-phone-volume2',
            'twi-pi2' => 'twi-pi2',
            'twi-pie2' => 'twi-pie2',
            'twi-pig2' => 'twi-pig2',
            'twi-piggy-bank2' => 'twi-piggy-bank2',
            'twi-pills2' => 'twi-pills2',
            'twi-pizza2' => 'twi-pizza2',
            'twi-pizza-slice2' => 'twi-pizza-slice2',
            'twi-place-of-worship2' => 'twi-place-of-worship2',
            'twi-plane2' => 'twi-plane2',
            'twi-plane-alt2' => 'twi-plane-alt2',
            'twi-plane-arrival2' => 'twi-plane-arrival2',
            'twi-plane-departure2' => 'twi-plane-departure2',
            'twi-play2' => 'twi-play2',
            'twi-play-circle2' => 'twi-play-circle2',
            'twi-plug2' => 'twi-plug2',
            'twi-plus2' => 'twi-plus2',
            'twi-plus-circle2' => 'twi-plus-circle2',
            'twi-plus-hexagon2' => 'twi-plus-hexagon2',
            'twi-plus-octagon2' => 'twi-plus-octagon2',
            'twi-plus-square2' => 'twi-plus-square2',
            'twi-podcast2' => 'twi-podcast2',
            'twi-podium2' => 'twi-podium2',
            'twi-podium-star2' => 'twi-podium-star2',
            'twi-poll2' => 'twi-poll2',
            'twi-poll-h2' => 'twi-poll-h2',
            'twi-poll-people2' => 'twi-poll-people2',
            'twi-poo2' => 'twi-poo2',
            'twi-poop2' => 'twi-poop2',
            'twi-poo-storm2' => 'twi-poo-storm2',
            'twi-popcorn2' => 'twi-popcorn2',
            'twi-portrait2' => 'twi-portrait2',
            'twi-pound-sign2' => 'twi-pound-sign2',
            'twi-power-off2' => 'twi-power-off2',
            'twi-pray2' => 'twi-pray2',
            'twi-praying-hands2' => 'twi-praying-hands2',
            'twi-prescription2' => 'twi-prescription2',
            'twi-prescription-bottle2' => 'twi-prescription-bottle2',
            'twi-prescription-bottle-alt2' => 'twi-prescription-bottle-alt2',
            'twi-presentation2' => 'twi-presentation2',
            'twi-print2' => 'twi-print2',
            'twi-print-search2' => 'twi-print-search2',
            'twi-print-slash2' => 'twi-print-slash2',
            'twi-procedures2' => 'twi-procedures2',
            'twi-project-diagram2' => 'twi-project-diagram2',
            'twi-pumpkin2' => 'twi-pumpkin2',
            'twi-puzzle-piece2' => 'twi-puzzle-piece2',
            'twi-qrcode2' => 'twi-qrcode2',
            'twi-question2' => 'twi-question2',
            'twi-question-circle2' => 'twi-question-circle2',
            'twi-question-square2' => 'twi-question-square2',
            'twi-quidditch2' => 'twi-quidditch2',
            'twi-quote-left2' => 'twi-quote-left2',
            'twi-quote-right2' => 'twi-quote-right2',
            'twi-quran2' => 'twi-quran2',
            'twi-rabbit2' => 'twi-rabbit2',
            'twi-rabbit-fast2' => 'twi-rabbit-fast2',
            'twi-racquet2' => 'twi-racquet2',
            'twi-radiation2' => 'twi-radiation2',
            'twi-radiation-alt2' => 'twi-radiation-alt2',
            'twi-rainbow2' => 'twi-rainbow2',
            'twi-raindrops2' => 'twi-raindrops2',
            'twi-ram2' => 'twi-ram2',
            'twi-ramp-loading2' => 'twi-ramp-loading2',
            'twi-random2' => 'twi-random2',
            'twi-receipt2' => 'twi-receipt2',
            'twi-rectangle-landscape2' => 'twi-rectangle-landscape2',
            'twi-rectangle-portrait2' => 'twi-rectangle-portrait2',
            'twi-rectangle-wide2' => 'twi-rectangle-wide2',
            'twi-recycle2' => 'twi-recycle2',
            'twi-redo2' => 'twi-redo2',
            'twi-redo-alt2' => 'twi-redo-alt2',
            'twi-registered2' => 'twi-registered2',
            'twi-repeat2' => 'twi-repeat2',
            'twi-repeat-12' => 'twi-repeat-12',
            'twi-repeat-1-alt2' => 'twi-repeat-1-alt2',
            'twi-repeat-alt2' => 'twi-repeat-alt2',
            'twi-reply2' => 'twi-reply2',
            'twi-reply-all2' => 'twi-reply-all2',
            'twi-republican2' => 'twi-republican2',
            'twi-restroom2' => 'twi-restroom2',
            'twi-retweet2' => 'twi-retweet2',
            'twi-retweet-alt2' => 'twi-retweet-alt2',
            'twi-ribbon2' => 'twi-ribbon2',
            'twi-ring2' => 'twi-ring2',
            'twi-rings-wedding2' => 'twi-rings-wedding2',
            'twi-road2' => 'twi-road2',
            'twi-robot2' => 'twi-robot2',
            'twi-rocket2' => 'twi-rocket2',
            'twi-route2' => 'twi-route2',
            'twi-route-highway2' => 'twi-route-highway2',
            'twi-route-interstate2' => 'twi-route-interstate2',
            'twi-rss2' => 'twi-rss2',
            'twi-rss-square2' => 'twi-rss-square2',
            'twi-ruble-sign2' => 'twi-ruble-sign2',
            'twi-ruler2' => 'twi-ruler2',
            'twi-ruler-combined2' => 'twi-ruler-combined2',
            'twi-ruler-horizontal2' => 'twi-ruler-horizontal2',
            'twi-ruler-triangle2' => 'twi-ruler-triangle2',
            'twi-ruler-vertical2' => 'twi-ruler-vertical2',
            'twi-running2' => 'twi-running2',
            'twi-rupee-sign2' => 'twi-rupee-sign2',
            'twi-rv2' => 'twi-rv2',
            'twi-sack2' => 'twi-sack2',
            'twi-sack-dollar2' => 'twi-sack-dollar2',
            'twi-sad-cry2' => 'twi-sad-cry2',
            'twi-sad-tear2' => 'twi-sad-tear2',
            'twi-salad2' => 'twi-salad2',
            'twi-sandwich2' => 'twi-sandwich2',
            'twi-satellite2' => 'twi-satellite2',
            'twi-satellite-dish2' => 'twi-satellite-dish2',
            'twi-sausage2' => 'twi-sausage2',
            'twi-save2' => 'twi-save2',
            'twi-scalpel2' => 'twi-scalpel2',
            'twi-scalpel-path2' => 'twi-scalpel-path2',
            'twi-scanner2' => 'twi-scanner2',
            'twi-scanner-keyboard2' => 'twi-scanner-keyboard2',
            'twi-scanner-touchscreen2' => 'twi-scanner-touchscreen2',
            'twi-scarecrow2' => 'twi-scarecrow2',
            'twi-scarf2' => 'twi-scarf2',
            'twi-school2' => 'twi-school2',
            'twi-screwdriver2' => 'twi-screwdriver2',
            'twi-scroll2' => 'twi-scroll2',
            'twi-scroll-old2' => 'twi-scroll-old2',
            'twi-scrubber2' => 'twi-scrubber2',
            'twi-scythe2' => 'twi-scythe2',
            'twi-sd-card2' => 'twi-sd-card2',
            'twi-search2' => 'twi-search2',
            'twi-search-dollar2' => 'twi-search-dollar2',
            'twi-search-location2' => 'twi-search-location2',
            'twi-search-minus2' => 'twi-search-minus2',
            'twi-search-plus2' => 'twi-search-plus2',
            'twi-seedling2' => 'twi-seedling2',
            'twi-server2' => 'twi-server2',
            'twi-shapes2' => 'twi-shapes2',
            'twi-share2' => 'twi-share2',
            'twi-share-all2' => 'twi-share-all2',
            'twi-share-alt2' => 'twi-share-alt2',
            'twi-share-alt-square2' => 'twi-share-alt-square2',
            'twi-share-square2' => 'twi-share-square2',
            'twi-sheep2' => 'twi-sheep2',
            'twi-shekel-sign2' => 'twi-shekel-sign2',
            'twi-shield2' => 'twi-shield2',
            'twi-shield-alt2' => 'twi-shield-alt2',
            'twi-shield-check2' => 'twi-shield-check2',
            'twi-shield-cross2' => 'twi-shield-cross2',
            'twi-ship2' => 'twi-ship2',
            'twi-shipping-fast2' => 'twi-shipping-fast2',
            'twi-shipping-timed2' => 'twi-shipping-timed2',
            'twi-shish-kebab2' => 'twi-shish-kebab2',
            'twi-shoe-prints2' => 'twi-shoe-prints2',
            'twi-shopping-bag2' => 'twi-shopping-bag2',
            'twi-shopping-basket2' => 'twi-shopping-basket2',
            'twi-shopping-cart2' => 'twi-shopping-cart2',
            'twi-shovel2' => 'twi-shovel2',
            'twi-shovel-snow2' => 'twi-shovel-snow2',
            'twi-shower2' => 'twi-shower2',
            'twi-shredder2' => 'twi-shredder2',
            'twi-shuttlecock2' => 'twi-shuttlecock2',
            'twi-shuttle-van2' => 'twi-shuttle-van2',
            'twi-sickle2' => 'twi-sickle2',
            'twi-sigma2' => 'twi-sigma2',
            'twi-sign2' => 'twi-sign2',
            'twi-signal2' => 'twi-signal2',
            'twi-signal-12' => 'twi-signal-12',
            'twi-signal-22' => 'twi-signal-22',
            'twi-signal-32' => 'twi-signal-32',
            'twi-signal-42' => 'twi-signal-42',
            'twi-signal-alt2' => 'twi-signal-alt2',
            'twi-signal-alt-12' => 'twi-signal-alt-12',
            'twi-signal-alt-22' => 'twi-signal-alt-22',
            'twi-signal-alt-32' => 'twi-signal-alt-32',
            'twi-signal-alt-slash2' => 'twi-signal-alt-slash2',
            'twi-signal-slash2' => 'twi-signal-slash2',
            'twi-signature2' => 'twi-signature2',
            'twi-sign-in2' => 'twi-sign-in2',
            'twi-sign-in-alt2' => 'twi-sign-in-alt2',
            'twi-sign-language2' => 'twi-sign-language2',
            'twi-sign-out2' => 'twi-sign-out2',
            'twi-sign-out-alt2' => 'twi-sign-out-alt2',
            'twi-sim-card2' => 'twi-sim-card2',
            'twi-sitemap2' => 'twi-sitemap2',
            'twi-skating2' => 'twi-skating2',
            'twi-skeleton2' => 'twi-skeleton2',
            'twi-skiing2' => 'twi-skiing2',
            'twi-skiing-nordic2' => 'twi-skiing-nordic2',
            'twi-ski-jump2' => 'twi-ski-jump2',
            'twi-ski-lift2' => 'twi-ski-lift2',
            'twi-skull2' => 'twi-skull2',
            'twi-skull-crossbones2' => 'twi-skull-crossbones2',
            'twi-slash2' => 'twi-slash2',
            'twi-sledding2' => 'twi-sledding2',
            'twi-sleigh2' => 'twi-sleigh2',
            'twi-sliders-h2' => 'twi-sliders-h2',
            'twi-sliders-h-square2' => 'twi-sliders-h-square2',
            'twi-sliders-v2' => 'twi-sliders-v2',
            'twi-sliders-v-square2' => 'twi-sliders-v-square2',
            'twi-smile2' => 'twi-smile2',
            'twi-smile-beam2' => 'twi-smile-beam2',
            'twi-smile-plus2' => 'twi-smile-plus2',
            'twi-smile-wink2' => 'twi-smile-wink2',
            'twi-smog2' => 'twi-smog2',
            'twi-smoke2' => 'twi-smoke2',
            'twi-smoking2' => 'twi-smoking2',
            'twi-smoking-ban2' => 'twi-smoking-ban2',
            'twi-sms2' => 'twi-sms2',
            'twi-snake2' => 'twi-snake2',
            'twi-snow-blowing2' => 'twi-snow-blowing2',
            'twi-snowboarding2' => 'twi-snowboarding2',
            'twi-snowflake2' => 'twi-snowflake2',
            'twi-snowflakes2' => 'twi-snowflakes2',
            'twi-snowman2' => 'twi-snowman2',
            'twi-snowmobile2' => 'twi-snowmobile2',
            'twi-snowplow2' => 'twi-snowplow2',
            'twi-socks2' => 'twi-socks2',
            'twi-solar-panel2' => 'twi-solar-panel2',
            'twi-sort2' => 'twi-sort2',
            'twi-sort-alpha-down2' => 'twi-sort-alpha-down2',
            'twi-sort-alpha-up2' => 'twi-sort-alpha-up2',
            'twi-sort-amount-down2' => 'twi-sort-amount-down2',
            'twi-sort-amount-up2' => 'twi-sort-amount-up2',
            'twi-sort-down2' => 'twi-sort-down2',
            'twi-sort-numeric-down2' => 'twi-sort-numeric-down2',
            'twi-sort-numeric-up2' => 'twi-sort-numeric-up2',
            'twi-sort-up2' => 'twi-sort-up2',
            'twi-soup2' => 'twi-soup2',
            'twi-spa2' => 'twi-spa2',
            'twi-space-shuttle2' => 'twi-space-shuttle2',
            'twi-spade2' => 'twi-spade2',
            'twi-spider2' => 'twi-spider2',
            'twi-spider-black-widow2' => 'twi-spider-black-widow2',
            'twi-spider-web2' => 'twi-spider-web2',
            'twi-spinner2' => 'twi-spinner2',
            'twi-spinner-third2' => 'twi-spinner-third2',
            'twi-splotch2' => 'twi-splotch2',
            'twi-spray-can2' => 'twi-spray-can2',
            'twi-square2' => 'twi-square2',
            'twi-square-full2' => 'twi-square-full2',
            'twi-square-root2' => 'twi-square-root2',
            'twi-square-root-alt2' => 'twi-square-root-alt2',
            'twi-squirrel2' => 'twi-squirrel2',
            'twi-staff2' => 'twi-staff2',
            'twi-stamp2' => 'twi-stamp2',
            'twi-star2' => 'twi-star2',
            'twi-star-and-crescent2' => 'twi-star-and-crescent2',
            'twi-star-christmas2' => 'twi-star-christmas2',
            'twi-star-exclamation2' => 'twi-star-exclamation2',
            'twi-star-half2' => 'twi-star-half2',
            'twi-star-half-alt2' => 'twi-star-half-alt2',
            'twi-star-of-david2' => 'twi-star-of-david2',
            'twi-star-of-life2' => 'twi-star-of-life2',
            'twi-stars2' => 'twi-stars2',
            'twi-steak2' => 'twi-steak2',
            'twi-steering-wheel2' => 'twi-steering-wheel2',
            'twi-step-backward2' => 'twi-step-backward2',
            'twi-step-forward2' => 'twi-step-forward2',
            'twi-stethoscope2' => 'twi-stethoscope2',
            'twi-sticky-note2' => 'twi-sticky-note2',
            'twi-stocking2' => 'twi-stocking2',
            'twi-stomach2' => 'twi-stomach2',
            'twi-stop2' => 'twi-stop2',
            'twi-stop-circle2' => 'twi-stop-circle2',
            'twi-stopwatch2' => 'twi-stopwatch2',
            'twi-store2' => 'twi-store2',
            'twi-store-alt2' => 'twi-store-alt2',
            'twi-stream2' => 'twi-stream2',
            'twi-street-view2' => 'twi-street-view2',
            'twi-stretcher2' => 'twi-stretcher2',
            'twi-strikethrough2' => 'twi-strikethrough2',
            'twi-stroopwafel2' => 'twi-stroopwafel2',
            'twi-subscript2' => 'twi-subscript2',
            'twi-subway2' => 'twi-subway2',
            'twi-suitcase2' => 'twi-suitcase2',
            'twi-suitcase-rolling2' => 'twi-suitcase-rolling2',
            'twi-sun2' => 'twi-sun2',
            'twi-sun-cloud2' => 'twi-sun-cloud2',
            'twi-sun-dust2' => 'twi-sun-dust2',
            'twi-sun-haze2' => 'twi-sun-haze2',
            'twi-sunrise2' => 'twi-sunrise2',
            'twi-sunset2' => 'twi-sunset2',
            'twi-superscript2' => 'twi-superscript2',
            'twi-surprise2' => 'twi-surprise2',
            'twi-swatchbook2' => 'twi-swatchbook2',
            'twi-swimmer2' => 'twi-swimmer2',
            'twi-swimming-pool2' => 'twi-swimming-pool2',
            'twi-sword2' => 'twi-sword2',
            'twi-swords2' => 'twi-swords2',
            'twi-synagogue2' => 'twi-synagogue2',
            'twi-sync2' => 'twi-sync2',
            'twi-sync-alt2' => 'twi-sync-alt2',
            'twi-syringe2' => 'twi-syringe2',
            'twi-table2' => 'twi-table2',
            'twi-tablet2' => 'twi-tablet2',
            'twi-tablet-alt2' => 'twi-tablet-alt2',
            'twi-tablet-android2' => 'twi-tablet-android2',
            'twi-tablet-android-alt2' => 'twi-tablet-android-alt2',
            'twi-table-tennis2' => 'twi-table-tennis2',
            'twi-tablet-rugged2' => 'twi-tablet-rugged2',
            'twi-tablets2' => 'twi-tablets2',
            'twi-tachometer2' => 'twi-tachometer2',
            'twi-tachometer-alt2' => 'twi-tachometer-alt2',
            'twi-tachometer-alt-average2' => 'twi-tachometer-alt-average2',
            'twi-tachometer-alt-fast2' => 'twi-tachometer-alt-fast2',
            'twi-tachometer-alt-fastest2' => 'twi-tachometer-alt-fastest2',
            'twi-tachometer-alt-slow2' => 'twi-tachometer-alt-slow2',
            'twi-tachometer-alt-slowest2' => 'twi-tachometer-alt-slowest2',
            'twi-tachometer-average2' => 'twi-tachometer-average2',
            'twi-tachometer-fast2' => 'twi-tachometer-fast2',
            'twi-tachometer-fastest2' => 'twi-tachometer-fastest2',
            'twi-tachometer-slow2' => 'twi-tachometer-slow2',
            'twi-tachometer-slowest2' => 'twi-tachometer-slowest2',
            'twi-taco2' => 'twi-taco2',
            'twi-tag2' => 'twi-tag2',
            'twi-tags2' => 'twi-tags2',
            'twi-tally2' => 'twi-tally2',
            'twi-tanakh2' => 'twi-tanakh2',
            'twi-tape2' => 'twi-tape2',
            'twi-tasks2' => 'twi-tasks2',
            'twi-tasks-alt2' => 'twi-tasks-alt2',
            'twi-taxi2' => 'twi-taxi2',
            'twi-teeth2' => 'twi-teeth2',
            'twi-teeth-open2' => 'twi-teeth-open2',
            'twi-temperature-frigid2' => 'twi-temperature-frigid2',
            'twi-temperature-high2' => 'twi-temperature-high2',
            'twi-temperature-hot2' => 'twi-temperature-hot2',
            'twi-temperature-low2' => 'twi-temperature-low2',
            'twi-tenge2' => 'twi-tenge2',
            'twi-tennis-ball2' => 'twi-tennis-ball2',
            'twi-terminal2' => 'twi-terminal2',
            'twi-text-height2' => 'twi-text-height2',
            'twi-text-width2' => 'twi-text-width2',
            'twi-th2' => 'twi-th2',
            'twi-theater-masks2' => 'twi-theater-masks2',
            'twi-thermometer2' => 'twi-thermometer2',
            'twi-thermometer-empty2' => 'twi-thermometer-empty2',
            'twi-thermometer-full2' => 'twi-thermometer-full2',
            'twi-thermometer-half2' => 'twi-thermometer-half2',
            'twi-thermometer-quarter2' => 'twi-thermometer-quarter2',
            'twi-thermometer-three-quarters2' => 'twi-thermometer-three-quarters2',
            'twi-theta2' => 'twi-theta2',
            'twi-th-large2' => 'twi-th-large2',
            'twi-th-list2' => 'twi-th-list2',
            'twi-thumbs-down2' => 'twi-thumbs-down2',
            'twi-thumbs-up2' => 'twi-thumbs-up2',
            'twi-thumbtack2' => 'twi-thumbtack2',
            'twi-thunderstorm2' => 'twi-thunderstorm2',
            'twi-thunderstorm-moon2' => 'twi-thunderstorm-moon2',
            'twi-thunderstorm-sun2' => 'twi-thunderstorm-sun2',
            'twi-ticket2' => 'twi-ticket2',
            'twi-ticket-alt2' => 'twi-ticket-alt2',
            'twi-tilde2' => 'twi-tilde2',
            'twi-times2' => 'twi-times2',
            'twi-times-circle2' => 'twi-times-circle2',
            'twi-times-hexagon2' => 'twi-times-hexagon2',
            'twi-times-octagon2' => 'twi-times-octagon2',
            'twi-times-square2' => 'twi-times-square2',
            'twi-tint2' => 'twi-tint2',
            'twi-tint-slash2' => 'twi-tint-slash2',
            'twi-tire2' => 'twi-tire2',
            'twi-tired2' => 'twi-tired2',
            'twi-tire-flat2' => 'twi-tire-flat2',
            'twi-tire-pressure-warning2' => 'twi-tire-pressure-warning2',
            'twi-tire-rugged2' => 'twi-tire-rugged2',
            'twi-toggle-off2' => 'twi-toggle-off2',
            'twi-toggle-on2' => 'twi-toggle-on2',
            'twi-toilet2' => 'twi-toilet2',
            'twi-toilet-paper2' => 'twi-toilet-paper2',
            'twi-toilet-paper-alt2' => 'twi-toilet-paper-alt2',
            'twi-tombstone2' => 'twi-tombstone2',
            'twi-tombstone-alt2' => 'twi-tombstone-alt2',
            'twi-toolbox2' => 'twi-toolbox2',
            'twi-tools2' => 'twi-tools2',
            'twi-tooth2' => 'twi-tooth2',
            'twi-toothbrush2' => 'twi-toothbrush2',
            'twi-torah2' => 'twi-torah2',
            'twi-torii-gate2' => 'twi-torii-gate2',
            'twi-tornado2' => 'twi-tornado2',
            'twi-tractor2' => 'twi-tractor2',
            'twi-trademark2' => 'twi-trademark2',
            'twi-traffic-cone2' => 'twi-traffic-cone2',
            'twi-traffic-light2' => 'twi-traffic-light2',
            'twi-traffic-light-go2' => 'twi-traffic-light-go2',
            'twi-traffic-light-slow2' => 'twi-traffic-light-slow2',
            'twi-traffic-light-stop2' => 'twi-traffic-light-stop2',
            'twi-train2' => 'twi-train2',
            'twi-tram2' => 'twi-tram2',
            'twi-transgender2' => 'twi-transgender2',
            'twi-transgender-alt2' => 'twi-transgender-alt2',
            'twi-trash2' => 'twi-trash2',
            'twi-trash-alt2' => 'twi-trash-alt2',
            'twi-trash-restore2' => 'twi-trash-restore2',
            'twi-trash-restore-alt2' => 'twi-trash-restore-alt2',
            'twi-treasure-chest2' => 'twi-treasure-chest2',
            'twi-tree2' => 'twi-tree2',
            'twi-tree-alt2' => 'twi-tree-alt2',
            'twi-tree-christmas2' => 'twi-tree-christmas2',
            'twi-tree-decorated2' => 'twi-tree-decorated2',
            'twi-tree-large2' => 'twi-tree-large2',
            'twi-tree-palm2' => 'twi-tree-palm2',
            'twi-trees2' => 'twi-trees2',
            'twi-triangle2' => 'twi-triangle2',
            'twi-trophy2' => 'twi-trophy2',
            'twi-trophy-alt2' => 'twi-trophy-alt2',
            'twi-truck2' => 'twi-truck2',
            'twi-truck-container2' => 'twi-truck-container2',
            'twi-truck-couch2' => 'twi-truck-couch2',
            'twi-truck-loading2' => 'twi-truck-loading2',
            'twi-truck-monster2' => 'twi-truck-monster2',
            'twi-truck-moving2' => 'twi-truck-moving2',
            'twi-truck-pickup2' => 'twi-truck-pickup2',
            'twi-truck-plow2' => 'twi-truck-plow2',
            'twi-truck-ramp2' => 'twi-truck-ramp2',
            'twi-tshirt2' => 'twi-tshirt2',
            'twi-tty2' => 'twi-tty2',
            'twi-turkey2' => 'twi-turkey2',
            'twi-turtle2' => 'twi-turtle2',
            'twi-tv2' => 'twi-tv2',
            'twi-tv-retro2' => 'twi-tv-retro2',
            'twi-umbrella2' => 'twi-umbrella2',
            'twi-umbrella-beach2' => 'twi-umbrella-beach2',
            'twi-underline2' => 'twi-underline2',
            'twi-undo2' => 'twi-undo2',
            'twi-undo-alt2' => 'twi-undo-alt2',
            'twi-unicorn2' => 'twi-unicorn2',
            'twi-union2' => 'twi-union2',
            'twi-universal-access2' => 'twi-universal-access2',
            'twi-university2' => 'twi-university2',
            'twi-unlink2' => 'twi-unlink2',
            'twi-unlock2' => 'twi-unlock2',
            'twi-unlock-alt2' => 'twi-unlock-alt2',
            'twi-upload2' => 'twi-upload2',
            'twi-usd-circle2' => 'twi-usd-circle2',
            'twi-usd-square2' => 'twi-usd-square2',
            'twi-user2' => 'twi-user2',
            'twi-user-alt2' => 'twi-user-alt2',
            'twi-user-alt-slash2' => 'twi-user-alt-slash2',
            'twi-user-astronaut2' => 'twi-user-astronaut2',
            'twi-user-chart2' => 'twi-user-chart2',
            'twi-user-check2' => 'twi-user-check2',
            'twi-user-circle2' => 'twi-user-circle2',
            'twi-user-clock2' => 'twi-user-clock2',
            'twi-user-cog2' => 'twi-user-cog2',
            'twi-user-crown2' => 'twi-user-crown2',
            'twi-user-edit2' => 'twi-user-edit2',
            'twi-user-friends2' => 'twi-user-friends2',
            'twi-user-graduate2' => 'twi-user-graduate2',
            'twi-user-hard-hat2' => 'twi-user-hard-hat2',
            'twi-user-headset2' => 'twi-user-headset2',
            'twi-user-injured2' => 'twi-user-injured2',
            'twi-user-lock2' => 'twi-user-lock2',
            'twi-user-md2' => 'twi-user-md2',
            'twi-user-md-chat2' => 'twi-user-md-chat2',
            'twi-user-minus2' => 'twi-user-minus2',
            'twi-user-ninja2' => 'twi-user-ninja2',
            'twi-user-nurse2' => 'twi-user-nurse2',
            'twi-user-plus2' => 'twi-user-plus2',
            'twi-users2' => 'twi-users2',
            'twi-users-class2' => 'twi-users-class2',
            'twi-users-cog2' => 'twi-users-cog2',
            'twi-users-crown2' => 'twi-users-crown2',
            'twi-user-secret2' => 'twi-user-secret2',
            'twi-user-shield2' => 'twi-user-shield2',
            'twi-user-slash2' => 'twi-user-slash2',
            'twi-users-medical2' => 'twi-users-medical2',
            'twi-user-tag2' => 'twi-user-tag2',
            'twi-user-tie2' => 'twi-user-tie2',
            'twi-user-times2' => 'twi-user-times2',
            'twi-utensil-fork2' => 'twi-utensil-fork2',
            'twi-utensil-knife2' => 'twi-utensil-knife2',
            'twi-utensils2' => 'twi-utensils2',
            'twi-utensils-alt2' => 'twi-utensils-alt2',
            'twi-utensil-spoon2' => 'twi-utensil-spoon2',
            'twi-value-absolute2' => 'twi-value-absolute2',
            'twi-vector-square2' => 'twi-vector-square2',
            'twi-venus2' => 'twi-venus2',
            'twi-venus-double2' => 'twi-venus-double2',
            'twi-venus-mars2' => 'twi-venus-mars2',
            'twi-vial2' => 'twi-vial2',
            'twi-vials2' => 'twi-vials2',
            'twi-video2' => 'twi-video2',
            'twi-video-plus2' => 'twi-video-plus2',
            'twi-video-slash2' => 'twi-video-slash2',
            'twi-vihara2' => 'twi-vihara2',
            'twi-volcano2' => 'twi-volcano2',
            'twi-volleyball-ball2' => 'twi-volleyball-ball2',
            'twi-volume2' => 'twi-volume2',
            'twi-volume-down2' => 'twi-volume-down2',
            'twi-volume-mute2' => 'twi-volume-mute2',
            'twi-volume-off2' => 'twi-volume-off2',
            'twi-volume-slash2' => 'twi-volume-slash2',
            'twi-volume-up2' => 'twi-volume-up2',
            'twi-vote-nay2' => 'twi-vote-nay2',
            'twi-vote-yea2' => 'twi-vote-yea2',
            'twi-vr-cardboard2' => 'twi-vr-cardboard2',
            'twi-walker2' => 'twi-walker2',
            'twi-walking2' => 'twi-walking2',
            'twi-wallet2' => 'twi-wallet2',
            'twi-wand2' => 'twi-wand2',
            'twi-wand-magic2' => 'twi-wand-magic2',
            'twi-warehouse2' => 'twi-warehouse2',
            'twi-warehouse-alt2' => 'twi-warehouse-alt2',
            'twi-watch2' => 'twi-watch2',
            'twi-watch-fitness2' => 'twi-watch-fitness2',
            'twi-water2' => 'twi-water2',
            'twi-water-lower2' => 'twi-water-lower2',
            'twi-water-rise2' => 'twi-water-rise2',
            'twi-wave-square2' => 'twi-wave-square2',
            'twi-webcam2' => 'twi-webcam2',
            'twi-webcam-slash2' => 'twi-webcam-slash2',
            'twi-weight2' => 'twi-weight2',
            'twi-weight-hanging2' => 'twi-weight-hanging2',
            'twi-whale2' => 'twi-whale2',
            'twi-wheat2' => 'twi-wheat2',
            'twi-wheelchair2' => 'twi-wheelchair2',
            'twi-whistle2' => 'twi-whistle2',
            'twi-wifi2' => 'twi-wifi2',
            'twi-wifi-12' => 'twi-wifi-12',
            'twi-wifi-22' => 'twi-wifi-22',
            'twi-wifi-slash2' => 'twi-wifi-slash2',
            'twi-wind2' => 'twi-wind2',
            'twi-window2' => 'twi-window2',
            'twi-window-alt2' => 'twi-window-alt2',
            'twi-window-close2' => 'twi-window-close2',
            'twi-window-maximize2' => 'twi-window-maximize2',
            'twi-window-minimize2' => 'twi-window-minimize2',
            'twi-window-restore2' => 'twi-window-restore2',
            'twi-windsock2' => 'twi-windsock2',
            'twi-wind-warning2' => 'twi-wind-warning2',
            'twi-wine-bottle2' => 'twi-wine-bottle2',
            'twi-wine-glass2' => 'twi-wine-glass2',
            'twi-wine-glass-alt2' => 'twi-wine-glass-alt2',
            'twi-won-sign2' => 'twi-won-sign2',
            'twi-wreath2' => 'twi-wreath2',
            'twi-wrench2' => 'twi-wrench2',
            'twi-x-ray2' => 'twi-x-ray2',
            'twi-yen-sign2' => 'twi-yen-sign2',
            'twi-yin-yang2' => 'twi-yin-yang2',
            'twi-px' => 'twi-px',
            'twi-accessible-icon' => 'twi-accessible-icon',
            'twi-accusoft' => 'twi-accusoft',
            'twi-acquisitions-incorporated' => 'twi-acquisitions-incorporated',
            'twi-adn' => 'twi-adn',
            'twi-adobe' => 'twi-adobe',
            'twi-adversal' => 'twi-adversal',
            'twi-affiliatetheme' => 'twi-affiliatetheme',
            'twi-airbnb' => 'twi-airbnb',
            'twi-algolia' => 'twi-algolia',
            'twi-alipay' => 'twi-alipay',
            'twi-amazon' => 'twi-amazon',
            'twi-amazon-pay' => 'twi-amazon-pay',
            'twi-amilia' => 'twi-amilia',
            'twi-android' => 'twi-android',
            'twi-angellist' => 'twi-angellist',
            'twi-angrycreative' => 'twi-angrycreative',
            'twi-angular' => 'twi-angular',
            'twi-apper' => 'twi-apper',
            'twi-apple' => 'twi-apple',
            'twi-apple-pay' => 'twi-apple-pay',
            'twi-app-store' => 'twi-app-store',
            'twi-app-store-ios' => 'twi-app-store-ios',
            'twi-artstation' => 'twi-artstation',
            'twi-asymmetrik' => 'twi-asymmetrik',
            'twi-atlassian' => 'twi-atlassian',
            'twi-audible' => 'twi-audible',
            'twi-autoprefixer' => 'twi-autoprefixer',
            'twi-avianex' => 'twi-avianex',
            'twi-aviato' => 'twi-aviato',
            'twi-aws' => 'twi-aws',
            'twi-bandcamp' => 'twi-bandcamp',
            'twi-battle-net' => 'twi-battle-net',
            'twi-behance' => 'twi-behance',
            'twi-behance-square' => 'twi-behance-square',
            'twi-bimobject' => 'twi-bimobject',
            'twi-bitbucket' => 'twi-bitbucket',
            'twi-bitcoin' => 'twi-bitcoin',
            'twi-bity' => 'twi-bity',
            'twi-blackberry' => 'twi-blackberry',
            'twi-black-tie' => 'twi-black-tie',
            'twi-blogger' => 'twi-blogger',
            'twi-blogger-b' => 'twi-blogger-b',
            'twi-bluetooth' => 'twi-bluetooth',
            'twi-bluetooth-b' => 'twi-bluetooth-b',
            'twi-bootstrap' => 'twi-bootstrap',
            'twi-btc' => 'twi-btc',
            'twi-buffer' => 'twi-buffer',
            'twi-buromobelexperte' => 'twi-buromobelexperte',
            'twi-buysellads' => 'twi-buysellads',
            'twi-canadian-maple-leaf' => 'twi-canadian-maple-leaf',
            'twi-cc-amazon-pay' => 'twi-cc-amazon-pay',
            'twi-cc-amex' => 'twi-cc-amex',
            'twi-cc-apple-pay' => 'twi-cc-apple-pay',
            'twi-cc-diners-club' => 'twi-cc-diners-club',
            'twi-cc-discover' => 'twi-cc-discover',
            'twi-cc-jcb' => 'twi-cc-jcb',
            'twi-cc-mastercard' => 'twi-cc-mastercard',
            'twi-cc-paypal' => 'twi-cc-paypal',
            'twi-cc-stripe' => 'twi-cc-stripe',
            'twi-cc-visa' => 'twi-cc-visa',
            'twi-centercode' => 'twi-centercode',
            'twi-centos' => 'twi-centos',
            'twi-chrome' => 'twi-chrome',
            'twi-chromecast' => 'twi-chromecast',
            'twi-cloudscale' => 'twi-cloudscale',
            'twi-cloudsmith' => 'twi-cloudsmith',
            'twi-cloudversify' => 'twi-cloudversify',
            'twi-codepen' => 'twi-codepen',
            'twi-codiepie' => 'twi-codiepie',
            'twi-confluence' => 'twi-confluence',
            'twi-connectdevelop' => 'twi-connectdevelop',
            'twi-contao' => 'twi-contao',
            'twi-cpanel' => 'twi-cpanel',
            'twi-creative-commons' => 'twi-creative-commons',
            'twi-creative-commons-by' => 'twi-creative-commons-by',
            'twi-creative-commons-nc' => 'twi-creative-commons-nc',
            'twi-creative-commons-nc-eu' => 'twi-creative-commons-nc-eu',
            'twi-creative-commons-nc-jp' => 'twi-creative-commons-nc-jp',
            'twi-creative-commons-nd' => 'twi-creative-commons-nd',
            'twi-creative-commons-pd' => 'twi-creative-commons-pd',
            'twi-creative-commons-pd-alt' => 'twi-creative-commons-pd-alt',
            'twi-creative-commons-remix' => 'twi-creative-commons-remix',
            'twi-creative-commons-sa' => 'twi-creative-commons-sa',
            'twi-creative-commons-sampling' => 'twi-creative-commons-sampling',
            'twi-creative-commons-sampling-plus' => 'twi-creative-commons-sampling-plus',
            'twi-creative-commons-share' => 'twi-creative-commons-share',
            'twi-creative-commons-zero' => 'twi-creative-commons-zero',
            'twi-critical-role' => 'twi-critical-role',
            'twi-css3' => 'twi-css3',
            'twi-css3-alt' => 'twi-css3-alt',
            'twi-cuttlefish' => 'twi-cuttlefish',
            'twi-d-and-d' => 'twi-d-and-d',
            'twi-d-and-d-beyond' => 'twi-d-and-d-beyond',
            'twi-dashcube' => 'twi-dashcube',
            'twi-delicious' => 'twi-delicious',
            'twi-deploydog' => 'twi-deploydog',
            'twi-deskpro' => 'twi-deskpro',
            'twi-dev' => 'twi-dev',
            'twi-deviantart' => 'twi-deviantart',
            'twi-dhl' => 'twi-dhl',
            'twi-diaspora' => 'twi-diaspora',
            'twi-digg' => 'twi-digg',
            'twi-digital-ocean' => 'twi-digital-ocean',
            'twi-discord' => 'twi-discord',
            'twi-discourse' => 'twi-discourse',
            'twi-dochub' => 'twi-dochub',
            'twi-docker' => 'twi-docker',
            'twi-draft2digital' => 'twi-draft2digital',
            'twi-dribbble' => 'twi-dribbble',
            'twi-dribbble-square' => 'twi-dribbble-square',
            'twi-dropbox' => 'twi-dropbox',
            'twi-drupal' => 'twi-drupal',
            'twi-dyalog' => 'twi-dyalog',
            'twi-earlybirds' => 'twi-earlybirds',
            'twi-ebay' => 'twi-ebay',
            'twi-edge' => 'twi-edge',
            'twi-elementor' => 'twi-elementor',
            'twi-ello' => 'twi-ello',
            'twi-ember' => 'twi-ember',
            'twi-empire' => 'twi-empire',
            'twi-envira' => 'twi-envira',
            'twi-erlang' => 'twi-erlang',
            'twi-ethereum' => 'twi-ethereum',
            'twi-etsy' => 'twi-etsy',
            'twi-evernote' => 'twi-evernote',
            'twi-expeditedssl' => 'twi-expeditedssl',
            'twi-facebook' => 'twi-facebook',
            'twi-facebook-f' => 'twi-facebook-f',
            'twi-facebook-messenger' => 'twi-facebook-messenger',
            'twi-facebook-square' => 'twi-facebook-square',
            'twi-fantasy-flight-games' => 'twi-fantasy-flight-games',
            'twi-fedex' => 'twi-fedex',
            'twi-fedora' => 'twi-fedora',
            'twi-figma' => 'twi-figma',
            'twi-firefox' => 'twi-firefox',
            'twi-firstdraft' => 'twi-firstdraft',
            'twi-first-order' => 'twi-first-order',
            'twi-first-order-alt' => 'twi-first-order-alt',
            'twi-flickr' => 'twi-flickr',
            'twi-flipboard' => 'twi-flipboard',
            'twi-fly' => 'twi-fly',
            'twi-font-awesome' => 'twi-font-awesome',
            'twi-font-awesome-alt' => 'twi-font-awesome-alt',
            'twi-font-awesome-flag' => 'twi-font-awesome-flag',
            'twi-font-awesome-logo-full3' => 'twi-font-awesome-logo-full3',
            'twi-fonticons' => 'twi-fonticons',
            'twi-fonticons-fi' => 'twi-fonticons-fi',
            'twi-fort-awesome' => 'twi-fort-awesome',
            'twi-fort-awesome-alt' => 'twi-fort-awesome-alt',
            'twi-forumbee' => 'twi-forumbee',
            'twi-foursquare' => 'twi-foursquare',
            'twi-freebsd' => 'twi-freebsd',
            'twi-free-code-camp' => 'twi-free-code-camp',
            'twi-fulcrum' => 'twi-fulcrum',
            'twi-galactic-republic' => 'twi-galactic-republic',
            'twi-galactic-senate' => 'twi-galactic-senate',
            'twi-get-pocket' => 'twi-get-pocket',
            'twi-gg' => 'twi-gg',
            'twi-gg-circle' => 'twi-gg-circle',
            'twi-git' => 'twi-git',
            'twi-github' => 'twi-github',
            'twi-github-alt' => 'twi-github-alt',
            'twi-github-square' => 'twi-github-square',
            'twi-gitkraken' => 'twi-gitkraken',
            'twi-gitlab' => 'twi-gitlab',
            'twi-git-square' => 'twi-git-square',
            'twi-gitter' => 'twi-gitter',
            'twi-glide' => 'twi-glide',
            'twi-glide-g' => 'twi-glide-g',
            'twi-gofore' => 'twi-gofore',
            'twi-goodreads' => 'twi-goodreads',
            'twi-goodreads-g' => 'twi-goodreads-g',
            'twi-google' => 'twi-google',
            'twi-google-drive' => 'twi-google-drive',
            'twi-google-play' => 'twi-google-play',
            'twi-google-plus' => 'twi-google-plus',
            'twi-google-plus-g' => 'twi-google-plus-g',
            'twi-google-plus-square' => 'twi-google-plus-square',
            'twi-google-wallet' => 'twi-google-wallet',
            'twi-gratipay' => 'twi-gratipay',
            'twi-grav' => 'twi-grav',
            'twi-gripfire' => 'twi-gripfire',
            'twi-grunt' => 'twi-grunt',
            'twi-gulp' => 'twi-gulp',
            'twi-hacker-news' => 'twi-hacker-news',
            'twi-hacker-news-square' => 'twi-hacker-news-square',
            'twi-hackerrank' => 'twi-hackerrank',
            'twi-hips' => 'twi-hips',
            'twi-hire-a-helper' => 'twi-hire-a-helper',
            'twi-hooli' => 'twi-hooli',
            'twi-hornbill' => 'twi-hornbill',
            'twi-hotjar' => 'twi-hotjar',
            'twi-houzz' => 'twi-houzz',
            'twi-html5' => 'twi-html5',
            'twi-hubspot' => 'twi-hubspot',
            'twi-imdb' => 'twi-imdb',
            'twi-instagram' => 'twi-instagram',
            'twi-intercom' => 'twi-intercom',
            'twi-internet-explorer' => 'twi-internet-explorer',
            'twi-invision' => 'twi-invision',
            'twi-ioxhost' => 'twi-ioxhost',
            'twi-itch-io' => 'twi-itch-io',
            'twi-itunes' => 'twi-itunes',
            'twi-itunes-note' => 'twi-itunes-note',
            'twi-java' => 'twi-java',
            'twi-jedi-order' => 'twi-jedi-order',
            'twi-jenkins' => 'twi-jenkins',
            'twi-jira' => 'twi-jira',
            'twi-joget' => 'twi-joget',
            'twi-joomla' => 'twi-joomla',
            'twi-js' => 'twi-js',
            'twi-jsfiddle' => 'twi-jsfiddle',
            'twi-js-square' => 'twi-js-square',
            'twi-kaggle' => 'twi-kaggle',
            'twi-keybase' => 'twi-keybase',
            'twi-keycdn' => 'twi-keycdn',
            'twi-kickstarter' => 'twi-kickstarter',
            'twi-kickstarter-k' => 'twi-kickstarter-k',
            'twi-korvue' => 'twi-korvue',
            'twi-laravel' => 'twi-laravel',
            'twi-lastfm' => 'twi-lastfm',
            'twi-lastfm-square' => 'twi-lastfm-square',
            'twi-leanpub' => 'twi-leanpub',
            'twi-less' => 'twi-less',
            'twi-line' => 'twi-line',
            'twi-linkedin' => 'twi-linkedin',
            'twi-linkedin-in' => 'twi-linkedin-in',
            'twi-linode' => 'twi-linode',
            'twi-linux' => 'twi-linux',
            'twi-lyft' => 'twi-lyft',
            'twi-magento' => 'twi-magento',
            'twi-mailchimp' => 'twi-mailchimp',
            'twi-mandalorian' => 'twi-mandalorian',
            'twi-markdown' => 'twi-markdown',
            'twi-mastodon' => 'twi-mastodon',
            'twi-maxcdn' => 'twi-maxcdn',
            'twi-medapps' => 'twi-medapps',
            'twi-medium' => 'twi-medium',
            'twi-medium-m' => 'twi-medium-m',
            'twi-medrt' => 'twi-medrt',
            'twi-meetup' => 'twi-meetup',
            'twi-megaport' => 'twi-megaport',
            'twi-mendeley' => 'twi-mendeley',
            'twi-microsoft' => 'twi-microsoft',
            'twi-mix' => 'twi-mix',
            'twi-mixcloud' => 'twi-mixcloud',
            'twi-mizuni' => 'twi-mizuni',
            'twi-modx' => 'twi-modx',
            'twi-monero' => 'twi-monero',
            'twi-napster' => 'twi-napster',
            'twi-neos' => 'twi-neos',
            'twi-nimblr' => 'twi-nimblr',
            'twi-nintendo-switch' => 'twi-nintendo-switch',
            'twi-node' => 'twi-node',
            'twi-node-js' => 'twi-node-js',
            'twi-npm' => 'twi-npm',
            'twi-ns8' => 'twi-ns8',
            'twi-nutritionix' => 'twi-nutritionix',
            'twi-odnoklassniki' => 'twi-odnoklassniki',
            'twi-odnoklassniki-square' => 'twi-odnoklassniki-square',
            'twi-old-republic' => 'twi-old-republic',
            'twi-opencart' => 'twi-opencart',
            'twi-openid' => 'twi-openid',
            'twi-opera' => 'twi-opera',
            'twi-optin-monster' => 'twi-optin-monster',
            'twi-osi' => 'twi-osi',
            'twi-page4' => 'twi-page4',
            'twi-pagelines' => 'twi-pagelines',
            'twi-palfed' => 'twi-palfed',
            'twi-patreon' => 'twi-patreon',
            'twi-paypal' => 'twi-paypal',
            'twi-penny-arcade' => 'twi-penny-arcade',
            'twi-periscope' => 'twi-periscope',
            'twi-phabricator' => 'twi-phabricator',
            'twi-phoenix-framework' => 'twi-phoenix-framework',
            'twi-phoenix-squadron' => 'twi-phoenix-squadron',
            'twi-php' => 'twi-php',
            'twi-pied-piper' => 'twi-pied-piper',
            'twi-pied-piper-alt' => 'twi-pied-piper-alt',
            'twi-pied-piper-hat' => 'twi-pied-piper-hat',
            'twi-pied-piper-pp' => 'twi-pied-piper-pp',
            'twi-pinterest' => 'twi-pinterest',
            'twi-pinterest-p' => 'twi-pinterest-p',
            'twi-pinterest-square' => 'twi-pinterest-square',
            'twi-playstation' => 'twi-playstation',
            'twi-product-hunt' => 'twi-product-hunt',
            'twi-pushed' => 'twi-pushed',
            'twi-python' => 'twi-python',
            'twi-qq' => 'twi-qq',
            'twi-quinscape' => 'twi-quinscape',
            'twi-quora' => 'twi-quora',
            'twi-raspberry-pi' => 'twi-raspberry-pi',
            'twi-ravelry' => 'twi-ravelry',
            'twi-react' => 'twi-react',
            'twi-reacteurope' => 'twi-reacteurope',
            'twi-readme' => 'twi-readme',
            'twi-rebel' => 'twi-rebel',
            'twi-reddit' => 'twi-reddit',
            'twi-reddit-alien' => 'twi-reddit-alien',
            'twi-reddit-square' => 'twi-reddit-square',
            'twi-redhat' => 'twi-redhat',
            'twi-red-river' => 'twi-red-river',
            'twi-renren' => 'twi-renren',
            'twi-replyd' => 'twi-replyd',
            'twi-researchgate' => 'twi-researchgate',
            'twi-resolving' => 'twi-resolving',
            'twi-rev' => 'twi-rev',
            'twi-rocketchat' => 'twi-rocketchat',
            'twi-rockrms' => 'twi-rockrms',
            'twi-r-project' => 'twi-r-project',
            'twi-safari' => 'twi-safari',
            'twi-salesforce' => 'twi-salesforce',
            'twi-sass' => 'twi-sass',
            'twi-schlix' => 'twi-schlix',
            'twi-scribd' => 'twi-scribd',
            'twi-searchengin' => 'twi-searchengin',
            'twi-sellcast' => 'twi-sellcast',
            'twi-sellsy' => 'twi-sellsy',
            'twi-servicestack' => 'twi-servicestack',
            'twi-shirtsinbulk' => 'twi-shirtsinbulk',
            'twi-shopware' => 'twi-shopware',
            'twi-simplybuilt' => 'twi-simplybuilt',
            'twi-sistrix' => 'twi-sistrix',
            'twi-sith' => 'twi-sith',
            'twi-sketch' => 'twi-sketch',
            'twi-skyatlas' => 'twi-skyatlas',
            'twi-skype' => 'twi-skype',
            'twi-slack' => 'twi-slack',
            'twi-slack-hash' => 'twi-slack-hash',
            'twi-slideshare' => 'twi-slideshare',
            'twi-snapchat' => 'twi-snapchat',
            'twi-snapchat-ghost' => 'twi-snapchat-ghost',
            'twi-snapchat-square' => 'twi-snapchat-square',
            'twi-soundcloud' => 'twi-soundcloud',
            'twi-sourcetree' => 'twi-sourcetree',
            'twi-speakap' => 'twi-speakap',
            'twi-speaker-deck' => 'twi-speaker-deck',
            'twi-spotify' => 'twi-spotify',
            'twi-squarespace' => 'twi-squarespace',
            'twi-stack-exchange' => 'twi-stack-exchange',
            'twi-stack-overflow' => 'twi-stack-overflow',
            'twi-staylinked' => 'twi-staylinked',
            'twi-steam' => 'twi-steam',
            'twi-steam-square' => 'twi-steam-square',
            'twi-steam-symbol' => 'twi-steam-symbol',
            'twi-sticker-mule' => 'twi-sticker-mule',
            'twi-strava' => 'twi-strava',
            'twi-stripe' => 'twi-stripe',
            'twi-stripe-s' => 'twi-stripe-s',
            'twi-studiovinari' => 'twi-studiovinari',
            'twi-stumbleupon' => 'twi-stumbleupon',
            'twi-stumbleupon-circle' => 'twi-stumbleupon-circle',
            'twi-superpowers' => 'twi-superpowers',
            'twi-supple' => 'twi-supple',
            'twi-suse' => 'twi-suse',
            'twi-symfony' => 'twi-symfony',
            'twi-teamspeak' => 'twi-teamspeak',
            'twi-telegram' => 'twi-telegram',
            'twi-telegram-plane' => 'twi-telegram-plane',
            'twi-tencent-weibo' => 'twi-tencent-weibo',
            'twi-themeco' => 'twi-themeco',
            'twi-themeisle' => 'twi-themeisle',
            'twi-the-red-yeti' => 'twi-the-red-yeti',
            'twi-think-peaks' => 'twi-think-peaks',
            'twi-trade-federation' => 'twi-trade-federation',
            'twi-trello' => 'twi-trello',
            'twi-tripadvisor' => 'twi-tripadvisor',
            'twi-tumblr' => 'twi-tumblr',
            'twi-tumblr-square' => 'twi-tumblr-square',
            'twi-twitch' => 'twi-twitch',
            'twi-twitter' => 'twi-twitter',
            'twi-twitter-square' => 'twi-twitter-square',
            'twi-typo3' => 'twi-typo3',
            'twi-uber' => 'twi-uber',
            'twi-ubuntu' => 'twi-ubuntu',
            'twi-uikit' => 'twi-uikit',
            'twi-uniregistry' => 'twi-uniregistry',
            'twi-untappd' => 'twi-untappd',
            'twi-ups' => 'twi-ups',
            'twi-usb' => 'twi-usb',
            'twi-usps' => 'twi-usps',
            'twi-ussunnah' => 'twi-ussunnah',
            'twi-vaadin' => 'twi-vaadin',
            'twi-viacoin' => 'twi-viacoin',
            'twi-viadeo' => 'twi-viadeo',
            'twi-viadeo-square' => 'twi-viadeo-square',
            'twi-viber' => 'twi-viber',
            'twi-vimeo' => 'twi-vimeo',
            'twi-vimeo-square' => 'twi-vimeo-square',
            'twi-vimeo-v' => 'twi-vimeo-v',
            'twi-vine' => 'twi-vine',
            'twi-vk' => 'twi-vk',
            'twi-vnv' => 'twi-vnv',
            'twi-vuejs' => 'twi-vuejs',
            'twi-waze' => 'twi-waze',
            'twi-weebly' => 'twi-weebly',
            'twi-weibo' => 'twi-weibo',
            'twi-weixin' => 'twi-weixin',
            'twi-whatsapp' => 'twi-whatsapp',
            'twi-whatsapp-square' => 'twi-whatsapp-square',
            'twi-whmcs' => 'twi-whmcs',
            'twi-wikipedia-w' => 'twi-wikipedia-w',
            'twi-windows' => 'twi-windows',
            'twi-wix' => 'twi-wix',
            'twi-wizards-of-the-coast' => 'twi-wizards-of-the-coast',
            'twi-wolf-pack-battalion' => 'twi-wolf-pack-battalion',
            'twi-wordpress' => 'twi-wordpress',
            'twi-wordpress-simple' => 'twi-wordpress-simple',
            'twi-wpbeginner' => 'twi-wpbeginner',
            'twi-wpexplorer' => 'twi-wpexplorer',
            'twi-wpforms' => 'twi-wpforms',
            'twi-wpressr' => 'twi-wpressr',
            'twi-xbox' => 'twi-xbox',
            'twi-xing' => 'twi-xing',
            'twi-xing-square' => 'twi-xing-square',
            'twi-yahoo' => 'twi-yahoo',
            'twi-yammer' => 'twi-yammer',
            'twi-yandex' => 'twi-yandex',
            'twi-yandex-international' => 'twi-yandex-international',
            'twi-yarn' => 'twi-yarn',
            'twi-y-combinator' => 'twi-y-combinator',
            'twi-yelp' => 'twi-yelp',
            'twi-yoast' => 'twi-yoast',
            'twi-youtube' => 'twi-youtube',
            'twi-youtube-square' => 'twi-youtube-square',
            'twi-zhihu' => 'twi-zhihu',
            'twi-amilia1' => 'twi-amilia1',
            'twi-android1' => 'twi-android1',
            'twi-angellist1' => 'twi-angellist1',
            'twi-angrycreative1' => 'twi-angrycreative1',
            'twi-angular1' => 'twi-angular1',
            'twi-apper1' => 'twi-apper1',
            'twi-apple1' => 'twi-apple1',
            'twi-apple-pay1' => 'twi-apple-pay1',
            'twi-app-store1' => 'twi-app-store1',
            'twi-app-store-ios1' => 'twi-app-store-ios1',
            'twi-artstation1' => 'twi-artstation1',
            'twi-asymmetrik1' => 'twi-asymmetrik1',
            'twi-atlassian1' => 'twi-atlassian1',
            'twi-audible1' => 'twi-audible1',
            'twi-autoprefixer1' => 'twi-autoprefixer1',
            'twi-avianex1' => 'twi-avianex1',
            'twi-aviato1' => 'twi-aviato1',
            'twi-aws1' => 'twi-aws1',
            'twi-bandcamp1' => 'twi-bandcamp1',
            'twi-battle-net1' => 'twi-battle-net1',
            'twi-behance1' => 'twi-behance1',
            'twi-behance-square1' => 'twi-behance-square1',
            'twi-bimobject1' => 'twi-bimobject1',
            'twi-bitbucket1' => 'twi-bitbucket1',
            'twi-bitcoin1' => 'twi-bitcoin1',
            'twi-bity1' => 'twi-bity1',
            'twi-blackberry1' => 'twi-blackberry1',
            'twi-black-tie1' => 'twi-black-tie1',
            'twi-blogger1' => 'twi-blogger1',
            'twi-blogger-b1' => 'twi-blogger-b1',
            'twi-bluetooth1' => 'twi-bluetooth1',
            'twi-bluetooth-b1' => 'twi-bluetooth-b1',
            'twi-bootstrap1' => 'twi-bootstrap1',
            'twi-btc1' => 'twi-btc1',
            'twi-buffer1' => 'twi-buffer1',
            'twi-buromobelexperte1' => 'twi-buromobelexperte1',
            'twi-buysellads1' => 'twi-buysellads1',
            'twi-canadian-maple-leaf1' => 'twi-canadian-maple-leaf1',
            'twi-cc-amazon-pay1' => 'twi-cc-amazon-pay1',
            'twi-cc-amex1' => 'twi-cc-amex1',
            'twi-cc-apple-pay1' => 'twi-cc-apple-pay1',
            'twi-cc-diners-club1' => 'twi-cc-diners-club1',
            'twi-cc-discover1' => 'twi-cc-discover1',
            'twi-cc-jcb1' => 'twi-cc-jcb1',
            'twi-cc-mastercard1' => 'twi-cc-mastercard1',
            'twi-cc-paypal1' => 'twi-cc-paypal1',
            'twi-cc-stripe1' => 'twi-cc-stripe1',
            'twi-cc-visa1' => 'twi-cc-visa1',
            'twi-centercode1' => 'twi-centercode1',
            'twi-centos1' => 'twi-centos1',
            'twi-chrome1' => 'twi-chrome1',
            'twi-chromecast1' => 'twi-chromecast1',
            'twi-cloudscale1' => 'twi-cloudscale1',
            'twi-cloudsmith1' => 'twi-cloudsmith1',
            'twi-cloudversify1' => 'twi-cloudversify1',
            'twi-codepen1' => 'twi-codepen1',
            'twi-codiepie1' => 'twi-codiepie1',
            'twi-confluence1' => 'twi-confluence1',
            'twi-connectdevelop1' => 'twi-connectdevelop1',
            'twi-contao1' => 'twi-contao1',
            'twi-cpanel1' => 'twi-cpanel1',
            'twi-creative-commons1' => 'twi-creative-commons1',
            'twi-creative-commons-by1' => 'twi-creative-commons-by1',
            'twi-creative-commons-nc1' => 'twi-creative-commons-nc1',
            'twi-creative-commons-nc-eu1' => 'twi-creative-commons-nc-eu1',
            'twi-creative-commons-nc-jp1' => 'twi-creative-commons-nc-jp1',
            'twi-creative-commons-nd1' => 'twi-creative-commons-nd1',
            'twi-creative-commons-pd1' => 'twi-creative-commons-pd1',
            'twi-creative-commons-pd-alt1' => 'twi-creative-commons-pd-alt1',
            'twi-creative-commons-remix1' => 'twi-creative-commons-remix1',
            'twi-creative-commons-sa1' => 'twi-creative-commons-sa1',
            'twi-creative-commons-sampling1' => 'twi-creative-commons-sampling1',
            'twi-creative-commons-sampling-plus1' => 'twi-creative-commons-sampling-plus1',
            'twi-creative-commons-share1' => 'twi-creative-commons-share1',
            'twi-creative-commons-zero1' => 'twi-creative-commons-zero1',
            'twi-critical-role1' => 'twi-critical-role1',
            'twi-css31' => 'twi-css31',
            'twi-css3-alt1' => 'twi-css3-alt1',
            'twi-cuttlefish1' => 'twi-cuttlefish1',
            'twi-d-and-d1' => 'twi-d-and-d1',
            'twi-d-and-d-beyond1' => 'twi-d-and-d-beyond1',
            'twi-dashcube1' => 'twi-dashcube1',
            'twi-delicious1' => 'twi-delicious1',
            'twi-deploydog1' => 'twi-deploydog1',
            'twi-deskpro1' => 'twi-deskpro1',
            'twi-dev1' => 'twi-dev1',
            'twi-deviantart1' => 'twi-deviantart1',
            'twi-dhl1' => 'twi-dhl1',
            'twi-diaspora1' => 'twi-diaspora1',
            'twi-digg1' => 'twi-digg1',
            'twi-digital-ocean1' => 'twi-digital-ocean1',
            'twi-discord1' => 'twi-discord1',
            'twi-discourse1' => 'twi-discourse1',
            'twi-dochub1' => 'twi-dochub1',
            'twi-docker1' => 'twi-docker1',
            'twi-draft2digital1' => 'twi-draft2digital1',
            'twi-dribbble1' => 'twi-dribbble1',
            'twi-dribbble-square1' => 'twi-dribbble-square1',
            'twi-dropbox1' => 'twi-dropbox1',
            'twi-drupal1' => 'twi-drupal1',
            'twi-dyalog1' => 'twi-dyalog1',
            'twi-earlybirds1' => 'twi-earlybirds1',
            'twi-ebay1' => 'twi-ebay1',
            'twi-edge1' => 'twi-edge1',
            'twi-elementor1' => 'twi-elementor1',
            'twi-ello1' => 'twi-ello1',
            'twi-ember1' => 'twi-ember1',
            'twi-empire1' => 'twi-empire1',
            'twi-envira1' => 'twi-envira1',
            'twi-erlang1' => 'twi-erlang1',
            'twi-ethereum1' => 'twi-ethereum1',
            'twi-etsy1' => 'twi-etsy1',
            'twi-evernote1' => 'twi-evernote1',
            'twi-expeditedssl1' => 'twi-expeditedssl1',
            'twi-facebook1' => 'twi-facebook1',
            'twi-facebook-f1' => 'twi-facebook-f1',
            'twi-facebook-messenger1' => 'twi-facebook-messenger1',
            'twi-facebook-square1' => 'twi-facebook-square1',
            'twi-fantasy-flight-games1' => 'twi-fantasy-flight-games1',
            'twi-fedex1' => 'twi-fedex1',
            'twi-fedora1' => 'twi-fedora1',
            'twi-figma1' => 'twi-figma1',
            'twi-firefox1' => 'twi-firefox1',
            'twi-firstdraft1' => 'twi-firstdraft1',
            'twi-first-order1' => 'twi-first-order1',
            'twi-first-order-alt1' => 'twi-first-order-alt1',
            'twi-flickr1' => 'twi-flickr1',
            'twi-flipboard1' => 'twi-flipboard1',
            'twi-fly1' => 'twi-fly1',
            'twi-font-awesome1' => 'twi-font-awesome1',
            'twi-font-awesome-alt1' => 'twi-font-awesome-alt1',
            'twi-font-awesome-flag1' => 'twi-font-awesome-flag1',
            'twi-font-awesome-logo-full4' => 'twi-font-awesome-logo-full4',
            'twi-fonticons1' => 'twi-fonticons1',
            'twi-fonticons-fi1' => 'twi-fonticons-fi1',
            'twi-fort-awesome1' => 'twi-fort-awesome1',
            'twi-fort-awesome-alt1' => 'twi-fort-awesome-alt1',
            'twi-forumbee1' => 'twi-forumbee1',
            'twi-foursquare1' => 'twi-foursquare1',
            'twi-freebsd1' => 'twi-freebsd1',
            'twi-free-code-camp1' => 'twi-free-code-camp1',
            'twi-fulcrum1' => 'twi-fulcrum1',
            'twi-galactic-republic1' => 'twi-galactic-republic1',
            'twi-galactic-senate1' => 'twi-galactic-senate1',
            'twi-get-pocket1' => 'twi-get-pocket1',
            'twi-gg1' => 'twi-gg1',
            'twi-gg-circle1' => 'twi-gg-circle1',
            'twi-git1' => 'twi-git1',
            'twi-github1' => 'twi-github1',
            'twi-github-alt1' => 'twi-github-alt1',
            'twi-github-square1' => 'twi-github-square1',
            'twi-gitkraken1' => 'twi-gitkraken1',
            'twi-gitlab1' => 'twi-gitlab1',
            'twi-git-square1' => 'twi-git-square1',
            'twi-gitter1' => 'twi-gitter1',
            'twi-glide1' => 'twi-glide1',
            'twi-glide-g1' => 'twi-glide-g1',
            'twi-gofore1' => 'twi-gofore1',
            'twi-goodreads1' => 'twi-goodreads1',
            'twi-goodreads-g1' => 'twi-goodreads-g1',
            'twi-google1' => 'twi-google1',
            'twi-google-drive1' => 'twi-google-drive1',
            'twi-google-play1' => 'twi-google-play1',
            'twi-google-plus1' => 'twi-google-plus1',
            'twi-google-plus-g1' => 'twi-google-plus-g1',
            'twi-google-plus-square1' => 'twi-google-plus-square1',
            'twi-google-wallet1' => 'twi-google-wallet1',
            'twi-gratipay1' => 'twi-gratipay1',
            'twi-grav1' => 'twi-grav1',
            'twi-gripfire1' => 'twi-gripfire1',
            'twi-grunt1' => 'twi-grunt1',
            'twi-gulp1' => 'twi-gulp1',
            'twi-hacker-news1' => 'twi-hacker-news1',
            'twi-hacker-news-square1' => 'twi-hacker-news-square1',
            'twi-hackerrank1' => 'twi-hackerrank1',
            'twi-hips1' => 'twi-hips1',
            'twi-hire-a-helper1' => 'twi-hire-a-helper1',
            'twi-hooli1' => 'twi-hooli1',
            'twi-hornbill1' => 'twi-hornbill1',
            'twi-hotjar1' => 'twi-hotjar1',
            'twi-houzz1' => 'twi-houzz1',
            'twi-html51' => 'twi-html51',
            'twi-hubspot1' => 'twi-hubspot1',
            'twi-imdb1' => 'twi-imdb1',
            'twi-instagram1' => 'twi-instagram1',
            'twi-intercom1' => 'twi-intercom1',
            'twi-internet-explorer1' => 'twi-internet-explorer1',
            'twi-invision1' => 'twi-invision1',
            'twi-ioxhost1' => 'twi-ioxhost1',
            'twi-itch-io1' => 'twi-itch-io1',
            'twi-itunes1' => 'twi-itunes1',
            'twi-itunes-note1' => 'twi-itunes-note1',
            'twi-java1' => 'twi-java1',
            'twi-jedi-order1' => 'twi-jedi-order1',
            'twi-jenkins1' => 'twi-jenkins1',
            'twi-jira1' => 'twi-jira1',
            'twi-joget1' => 'twi-joget1',
            'twi-joomla1' => 'twi-joomla1',
            'twi-js1' => 'twi-js1',
            'twi-jsfiddle1' => 'twi-jsfiddle1',
            'twi-js-square1' => 'twi-js-square1',
            'twi-kaggle1' => 'twi-kaggle1',
            'twi-keybase1' => 'twi-keybase1',
            'twi-keycdn1' => 'twi-keycdn1',
            'twi-kickstarter1' => 'twi-kickstarter1',
            'twi-kickstarter-k1' => 'twi-kickstarter-k1',
            'twi-korvue1' => 'twi-korvue1',
            'twi-laravel1' => 'twi-laravel1',
            'twi-lastfm1' => 'twi-lastfm1',
            'twi-lastfm-square1' => 'twi-lastfm-square1',
            'twi-leanpub1' => 'twi-leanpub1',
            'twi-less1' => 'twi-less1',
            'twi-line1' => 'twi-line1',
            'twi-linkedin1' => 'twi-linkedin1',
            'twi-linkedin-in1' => 'twi-linkedin-in1',
            'twi-linode1' => 'twi-linode1',
            'twi-linux1' => 'twi-linux1',
            'twi-lyft1' => 'twi-lyft1',
            'twi-magento1' => 'twi-magento1',
            'twi-mailchimp1' => 'twi-mailchimp1',
            'twi-mandalorian1' => 'twi-mandalorian1',
            'twi-markdown1' => 'twi-markdown1',
            'twi-mastodon1' => 'twi-mastodon1',
            'twi-maxcdn1' => 'twi-maxcdn1',
            'twi-medapps1' => 'twi-medapps1',
            'twi-medium1' => 'twi-medium1',
            'twi-medium-m1' => 'twi-medium-m1',
            'twi-medrt1' => 'twi-medrt1',
            'twi-meetup1' => 'twi-meetup1',
            'twi-megaport1' => 'twi-megaport1',
            'twi-mendeley1' => 'twi-mendeley1',
            'twi-microsoft1' => 'twi-microsoft1',
            'twi-mix1' => 'twi-mix1',
            'twi-mixcloud1' => 'twi-mixcloud1',
            'twi-mizuni1' => 'twi-mizuni1',
            'twi-modx1' => 'twi-modx1',
            'twi-monero1' => 'twi-monero1',
            'twi-napster1' => 'twi-napster1',
            'twi-neos1' => 'twi-neos1',
            'twi-nimblr1' => 'twi-nimblr1',
            'twi-nintendo-switch1' => 'twi-nintendo-switch1',
            'twi-node1' => 'twi-node1',
            'twi-node-js1' => 'twi-node-js1',
            'twi-npm1' => 'twi-npm1',
            'twi-ns81' => 'twi-ns81',
            'twi-nutritionix1' => 'twi-nutritionix1',
            'twi-odnoklassniki1' => 'twi-odnoklassniki1',
            'twi-odnoklassniki-square1' => 'twi-odnoklassniki-square1',
            'twi-old-republic1' => 'twi-old-republic1',
            'twi-opencart1' => 'twi-opencart1',
            'twi-openid1' => 'twi-openid1',
            'twi-opera1' => 'twi-opera1',
            'twi-optin-monster1' => 'twi-optin-monster1',
            'twi-osi1' => 'twi-osi1',
            'twi-page41' => 'twi-page41',
            'twi-pagelines1' => 'twi-pagelines1',
            'twi-palfed1' => 'twi-palfed1',
            'twi-patreon1' => 'twi-patreon1',
            'twi-paypal1' => 'twi-paypal1',
            'twi-penny-arcade1' => 'twi-penny-arcade1',
            'twi-periscope1' => 'twi-periscope1',
            'twi-phabricator1' => 'twi-phabricator1',
            'twi-phoenix-framework1' => 'twi-phoenix-framework1',
            'twi-phoenix-squadron1' => 'twi-phoenix-squadron1',
            'twi-php1' => 'twi-php1',
            'twi-pied-piper1' => 'twi-pied-piper1',
            'twi-pied-piper-alt1' => 'twi-pied-piper-alt1',
            'twi-pied-piper-hat1' => 'twi-pied-piper-hat1',
            'twi-pied-piper-pp1' => 'twi-pied-piper-pp1',
            'twi-pinterest1' => 'twi-pinterest1',
            'twi-pinterest-p1' => 'twi-pinterest-p1',
            'twi-pinterest-square1' => 'twi-pinterest-square1',
            'twi-playstation1' => 'twi-playstation1',
            'twi-product-hunt1' => 'twi-product-hunt1',
            'twi-pushed1' => 'twi-pushed1',
            'twi-python1' => 'twi-python1',
            'twi-qq1' => 'twi-qq1',
            'twi-quinscape1' => 'twi-quinscape1',
            'twi-quora1' => 'twi-quora1',
            'twi-raspberry-pi1' => 'twi-raspberry-pi1',
            'twi-ravelry1' => 'twi-ravelry1',
            'twi-react1' => 'twi-react1',
            'twi-reacteurope1' => 'twi-reacteurope1',
            'twi-readme1' => 'twi-readme1',
            'twi-rebel1' => 'twi-rebel1',
            'twi-reddit1' => 'twi-reddit1',
            'twi-reddit-alien1' => 'twi-reddit-alien1',
            'twi-reddit-square1' => 'twi-reddit-square1',
            'twi-redhat1' => 'twi-redhat1',
            'twi-red-river1' => 'twi-red-river1',
            'twi-renren1' => 'twi-renren1',
            'twi-replyd1' => 'twi-replyd1',
            'twi-researchgate1' => 'twi-researchgate1',
            'twi-resolving1' => 'twi-resolving1',
            'twi-rev1' => 'twi-rev1',
            'twi-rocketchat1' => 'twi-rocketchat1',
            'twi-rockrms1' => 'twi-rockrms1',
            'twi-r-project1' => 'twi-r-project1',
            'twi-safari1' => 'twi-safari1',
            'twi-salesforce1' => 'twi-salesforce1',
            'twi-sass1' => 'twi-sass1',
            'twi-schlix1' => 'twi-schlix1',
            'twi-scribd1' => 'twi-scribd1',
            'twi-searchengin1' => 'twi-searchengin1',
            'twi-sellcast1' => 'twi-sellcast1',
            'twi-sellsy1' => 'twi-sellsy1',
            'twi-servicestack1' => 'twi-servicestack1',
            'twi-shirtsinbulk1' => 'twi-shirtsinbulk1',
            'twi-shopware1' => 'twi-shopware1',
            'twi-simplybuilt1' => 'twi-simplybuilt1',
            'twi-sistrix1' => 'twi-sistrix1',
            'twi-sith1' => 'twi-sith1',
            'twi-sketch1' => 'twi-sketch1',
            'twi-skyatlas1' => 'twi-skyatlas1',
            'twi-skype1' => 'twi-skype1',
            'twi-slack1' => 'twi-slack1',
            'twi-slack-hash1' => 'twi-slack-hash1',
            'twi-slideshare1' => 'twi-slideshare1',
            'twi-snapchat1' => 'twi-snapchat1',
            'twi-snapchat-ghost1' => 'twi-snapchat-ghost1',
            'twi-snapchat-square1' => 'twi-snapchat-square1',
            'twi-soundcloud1' => 'twi-soundcloud1',
            'twi-sourcetree1' => 'twi-sourcetree1',
            'twi-speakap1' => 'twi-speakap1',
            'twi-speaker-deck1' => 'twi-speaker-deck1',
            'twi-spotify1' => 'twi-spotify1',
            'twi-squarespace1' => 'twi-squarespace1',
            'twi-stack-exchange1' => 'twi-stack-exchange1',
            'twi-stack-overflow1' => 'twi-stack-overflow1',
            'twi-staylinked1' => 'twi-staylinked1',
            'twi-steam1' => 'twi-steam1',
            'twi-steam-square1' => 'twi-steam-square1',
            'twi-steam-symbol1' => 'twi-steam-symbol1',
            'twi-sticker-mule1' => 'twi-sticker-mule1',
            'twi-strava1' => 'twi-strava1',
            'twi-stripe1' => 'twi-stripe1',
            'twi-stripe-s1' => 'twi-stripe-s1',
            'twi-studiovinari1' => 'twi-studiovinari1',
            'twi-stumbleupon1' => 'twi-stumbleupon1',
            'twi-stumbleupon-circle1' => 'twi-stumbleupon-circle1',
            'twi-superpowers1' => 'twi-superpowers1',
            'twi-supple1' => 'twi-supple1',
            'twi-suse1' => 'twi-suse1',
            'twi-symfony1' => 'twi-symfony1',
            'twi-teamspeak1' => 'twi-teamspeak1',
            'twi-telegram1' => 'twi-telegram1',
            'twi-telegram-plane1' => 'twi-telegram-plane1',
            'twi-tencent-weibo1' => 'twi-tencent-weibo1',
            'twi-themeco1' => 'twi-themeco1',
            'twi-themeisle1' => 'twi-themeisle1',
            'twi-the-red-yeti1' => 'twi-the-red-yeti1',
            'twi-think-peaks1' => 'twi-think-peaks1',
            'twi-trade-federation1' => 'twi-trade-federation1',
            'twi-trello1' => 'twi-trello1',
            'twi-tripadvisor1' => 'twi-tripadvisor1',
            'twi-tumblr1' => 'twi-tumblr1',
            'twi-tumblr-square1' => 'twi-tumblr-square1',
            'twi-twitch1' => 'twi-twitch1',
            'twi-twitter1' => 'twi-twitter1',
            'twi-twitter-square1' => 'twi-twitter-square1',
            'twi-typo31' => 'twi-typo31',
            'twi-uber1' => 'twi-uber1',
            'twi-ubuntu1' => 'twi-ubuntu1',
            'twi-uikit1' => 'twi-uikit1',
            'twi-uniregistry1' => 'twi-uniregistry1',
            'twi-untappd1' => 'twi-untappd1',
            'twi-ups1' => 'twi-ups1',
            'twi-usb1' => 'twi-usb1',
            'twi-usps1' => 'twi-usps1',
            'twi-ussunnah1' => 'twi-ussunnah1',
            'twi-vaadin1' => 'twi-vaadin1',
            'twi-viacoin1' => 'twi-viacoin1',
            'twi-viadeo1' => 'twi-viadeo1',
            'twi-viadeo-square1' => 'twi-viadeo-square1',
            'twi-viber1' => 'twi-viber1',
            'twi-vimeo1' => 'twi-vimeo1',
            'twi-vimeo-square1' => 'twi-vimeo-square1',
            'twi-vimeo-v1' => 'twi-vimeo-v1',
            'twi-vine1' => 'twi-vine1',
            'twi-vk1' => 'twi-vk1',
            'twi-vnv1' => 'twi-vnv1',
            'twi-vuejs1' => 'twi-vuejs1',
            'twi-waze1' => 'twi-waze1',
            'twi-weebly1' => 'twi-weebly1',
            'twi-weibo1' => 'twi-weibo1',
            'twi-weixin1' => 'twi-weixin1',
            'twi-whatsapp1' => 'twi-whatsapp1',
            'twi-whatsapp-square1' => 'twi-whatsapp-square1',
            'twi-whmcs1' => 'twi-whmcs1',
            'twi-wikipedia-w1' => 'twi-wikipedia-w1',
            'twi-windows1' => 'twi-windows1',
            'twi-wix1' => 'twi-wix1',
            'twi-wizards-of-the-coast1' => 'twi-wizards-of-the-coast1',
            'twi-wolf-pack-battalion1' => 'twi-wolf-pack-battalion1',
            'twi-wordpress1' => 'twi-wordpress1',
            'twi-wordpress-simple1' => 'twi-wordpress-simple1',
            'twi-wpbeginner1' => 'twi-wpbeginner1',
            'twi-wpexplorer1' => 'twi-wpexplorer1',
            'twi-wpforms1' => 'twi-wpforms1',
            'twi-wpressr1' => 'twi-wpressr1',
            'twi-xbox1' => 'twi-xbox1',
            'twi-xing1' => 'twi-xing1',
            'twi-xing-square1' => 'twi-xing-square1',
            'twi-yahoo1' => 'twi-yahoo1',
            'twi-yammer1' => 'twi-yammer1',
            'twi-yandex1' => 'twi-yandex1',
            'twi-yandex-international1' => 'twi-yandex-international1',
            'twi-yarn1' => 'twi-yarn1',
            'twi-y-combinator1' => 'twi-y-combinator1',
            'twi-yelp1' => 'twi-yelp1',
            'twi-yoast1' => 'twi-yoast1',
            'twi-youtube1' => 'twi-youtube1',
            'twi-youtube-square1' => 'twi-youtube-square1',
            'twi-zhihu1' => 'twi-zhihu1',
            'twi-px1' => 'twi-px1',
            'twi-accessible-icon1' => 'twi-accessible-icon1',
            'twi-accusoft1' => 'twi-accusoft1',
            'twi-acquisitions-incorporated1' => 'twi-acquisitions-incorporated1',
            'twi-adn1' => 'twi-adn1',
            'twi-adobe1' => 'twi-adobe1',
            'twi-adversal1' => 'twi-adversal1',
            'twi-affiliatetheme1' => 'twi-affiliatetheme1',
            'twi-airbnb1' => 'twi-airbnb1',
            'twi-algolia1' => 'twi-algolia1',
            'twi-alipay1' => 'twi-alipay1',
            'twi-amazon1' => 'twi-amazon1',
            'twi-amazon-pay1' => 'twi-amazon-pay1',
        );

        return $icons;
    }

    /**
     * Retrieve icons control default settings.
     *
     * Get the default settings of the icons control. Used to return the default
     * settings while initializing the icons control.
     *
     * @since 1.0.0
     * @access protected
     *
     * @return array Control default settings.
     */
    protected function get_default_settings() {
        return [
            'options' => self::get_icons(),
        ];
    }

    /**
     * Render icons control output in the editor.
     *
     * Used to generate the control HTML in the editor using Underscore JS
     * template. The variables for the class are available using `data` JS
     * object.
     *
     * @since 1.0.0
     * @access public
     */
    public function content_template() {
        ?>
        <div class="elementor-control-field">
            <label class="elementor-control-title">{{{ data.label }}}</label>
            <div class="elementor-control-input-wrapper">
                <select class="elementor-control-icon" data-setting="{{ data.name }}" data-placeholder="<?php _e('Select Icon', 'themewar'); ?>">
                    <option value=""><?php _e('Select Icon', 'themewar'); ?></option>
                    <# _.each( data.options, function( option_title, option_value ) { #>
                    <option value="{{ option_value }}">{{{ option_title }}}</option>
                    <# } ); #>
                </select>
            </div>
        </div>
        <# if ( data.description ) { #>
        <div class="elementor-control-field-description">{{ data.description }}</div>
        <# } #>
        <?php
    }

}
