<?php
    /**
     * Class For Builder
     */
    class ConsuaBuilder{

        function __construct(){
            // register admin menus
        	add_action( 'admin_menu', [$this, 'register_settings_menus'] );

            // Custom Footer Builder With Post Type
			add_action( 'init',[ $this,'post_type' ],0 );

 		    add_action( 'elementor/frontend/after_enqueue_scripts', [ $this,'widget_scripts'] );

			add_filter( 'single_template', [ $this, 'load_canvas_template' ] );

            add_action( 'elementor/element/wp-page/document_settings/after_section_end', [ $this,'consua_add_elementor_page_settings_controls' ],10,2 );

		}

		public function widget_scripts( ) {
			wp_enqueue_script( 'consua-core',CONSUA_PLUGDIRURI.'assets/js/consua-core.js',array( 'jquery' ),'1.0',true );
		}


        public function consua_add_elementor_page_settings_controls( \Elementor\Core\DocumentTypes\Page $page ){

			$page->start_controls_section(
                'consua_header_option',
                [
                    'label'     => __( 'Header Option', 'consua' ),
                    'tab'       => \Elementor\Controls_Manager::TAB_SETTINGS,
                ]
            );


            $page->add_control(
                'consua_header_style',
                [
                    'label'     => __( 'Header Option', 'consua' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => [
    					'prebuilt'             => __( 'Pre Built', 'consua' ),
    					'header_builder'       => __( 'Header Builder', 'consua' ),
    				],
                    'default'   => 'prebuilt',
                ]
			);

            $page->add_control(
                'consua_header_builder_option',
                [
                    'label'     => __( 'Header Name', 'consua' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => $this->consua_header_choose_option(),
                    'condition' => [ 'consua_header_style' => 'header_builder'],
                    'default'	=> ''
                ]
            );

            $page->end_controls_section();

            $page->start_controls_section(
                'consua_footer_option',
                [
                    'label'     => __( 'Footer Option', 'consua' ),
                    'tab'       => \Elementor\Controls_Manager::TAB_SETTINGS,
                ]
            );
            $page->add_control(
    			'consua_footer_choice',
    			[
    				'label'         => __( 'Enable Footer?', 'consua' ),
    				'type'          => \Elementor\Controls_Manager::SWITCHER,
    				'label_on'      => __( 'Yes', 'consua' ),
    				'label_off'     => __( 'No', 'consua' ),
    				'return_value'  => 'yes',
    				'default'       => 'yes',
    			]
    		);
            $page->add_control(
                'consua_footer_style',
                [
                    'label'     => __( 'Footer Style', 'consua' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => [
    					'prebuilt'             => __( 'Pre Built', 'consua' ),
    					'footer_builder'       => __( 'Footer Builder', 'consua' ),
    				],
                    'default'   => 'prebuilt',
                    'condition' => [ 'consua_footer_choice' => 'yes' ],
                ]
            );
            $page->add_control(
                'consua_footer_builder_option',
                [
                    'label'     => __( 'Footer Name', 'consua' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => $this->consua_footer_choose_option(),
                    'condition' => [ 'consua_footer_style' => 'footer_builder','consua_footer_choice' => 'yes' ],
                    'default'	=> ''
                ]
            );

			$page->end_controls_section();

        }

		public function register_settings_menus(){
			add_menu_page(
				esc_html__( 'Consua Builder', 'consua' ),
            	esc_html__( 'Consua Builder', 'consua' ),
				'manage_options',
				'consua',
				[$this,'register_settings_contents__settings'],
				'dashicons-admin-site',
				2
			);

			add_submenu_page('consua', esc_html__('Footer Builder', 'consua'), esc_html__('Footer Builder', 'consua'), 'manage_options', 'edit.php?post_type=consua_footer');
			add_submenu_page('consua', esc_html__('Header Builder', 'consua'), esc_html__('Header Builder', 'consua'), 'manage_options', 'edit.php?post_type=consua_header');
            add_submenu_page('consua', esc_html__('Tab Builder', 'consua'), esc_html__('Tab Builder', 'consua'), 'manage_options', 'edit.php?post_type=consua_tab_builder');
		}

		// Callback Function
		public function register_settings_contents__settings(){
            echo '<h2>';
			    echo esc_html__( 'Welcome To Header And Footer Builder Of This Theme','consua' );
            echo '</h2>';
		}

		public function post_type() {

			$labels = array(
				'name'               => __( 'Footer', 'consua' ),
				'singular_name'      => __( 'Footer', 'consua' ),
				'menu_name'          => __( 'consua Footer Builder', 'consua' ),
				'name_admin_bar'     => __( 'Footer', 'consua' ),
				'add_new'            => __( 'Add New', 'consua' ),
				'add_new_item'       => __( 'Add New Footer', 'consua' ),
				'new_item'           => __( 'New Footer', 'consua' ),
				'edit_item'          => __( 'Edit Footer', 'consua' ),
				'view_item'          => __( 'View Footer', 'consua' ),
				'all_items'          => __( 'All Footer', 'consua' ),
				'search_items'       => __( 'Search Footer', 'consua' ),
				'parent_item_colon'  => __( 'Parent Footer:', 'consua' ),
				'not_found'          => __( 'No Footer found.', 'consua' ),
				'not_found_in_trash' => __( 'No Footer found in Trash.', 'consua' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'consua_footer', $args );

			$labels = array(
				'name'               => __( 'Header', 'consua' ),
				'singular_name'      => __( 'Header', 'consua' ),
				'menu_name'          => __( 'consua Header Builder', 'consua' ),
				'name_admin_bar'     => __( 'Header', 'consua' ),
				'add_new'            => __( 'Add New', 'consua' ),
				'add_new_item'       => __( 'Add New Header', 'consua' ),
				'new_item'           => __( 'New Header', 'consua' ),
				'edit_item'          => __( 'Edit Header', 'consua' ),
				'view_item'          => __( 'View Header', 'consua' ),
				'all_items'          => __( 'All Header', 'consua' ),
				'search_items'       => __( 'Search Header', 'consua' ),
				'parent_item_colon'  => __( 'Parent Header:', 'consua' ),
				'not_found'          => __( 'No Header found.', 'consua' ),
				'not_found_in_trash' => __( 'No Header found in Trash.', 'consua' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'consua_header', $args );

            $labels = array(
				'name'               => __( 'Tab Builder', 'consua' ),
				'singular_name'      => __( 'Tab Builder', 'consua' ),
				'menu_name'          => __( 'consua Tab Builder', 'consua' ),
				'name_admin_bar'     => __( 'Tab Builder', 'consua' ),
				'add_new'            => __( 'Add New', 'consua' ),
				'add_new_item'       => __( 'Add New Tab Builder', 'consua' ),
				'new_item'           => __( 'New Tab Builder', 'consua' ),
				'edit_item'          => __( 'Edit Tab Builder', 'consua' ),
				'view_item'          => __( 'View Tab Builder', 'consua' ),
				'all_items'          => __( 'All Tab Builder', 'consua' ),
				'search_items'       => __( 'Search Tab Builder', 'consua' ),
				'parent_item_colon'  => __( 'Parent Tab Builder:', 'consua' ),
				'not_found'          => __( 'No Tab Builder found.', 'consua' ),
				'not_found_in_trash' => __( 'No Tab Builder found in Trash.', 'consua' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'consua_tab_builder', $args );

		}

		function load_canvas_template( $single_template ) {

			global $post;

			if ( 'consua_footer' == $post->post_type || 'consua_header' == $post->post_type || 'consua_tab_builder' == $post->post_type ) {

				$elementor_2_0_canvas = ELEMENTOR_PATH . '/modules/page-templates/templates/canvas.php';

				if ( file_exists( $elementor_2_0_canvas ) ) {
					return $elementor_2_0_canvas;
				} else {
					return ELEMENTOR_PATH . '/includes/page-templates/canvas.php';
				}
			}

			return $single_template;
		}

        public function consua_footer_choose_option(){

			$consua_post_query = new WP_Query( array(
				'post_type'			=> 'consua_footer',
				'posts_per_page'	    => -1,
			) );

			$consua_builder_post_title = array();
			$consua_builder_post_title[''] = __('Select a Footer','consua');

			while( $consua_post_query->have_posts() ) {
				$consua_post_query->the_post();
				$consua_builder_post_title[ get_the_ID() ] =  get_the_title();
			}
			wp_reset_postdata();

			return $consua_builder_post_title;

		}

		public function consua_header_choose_option(){

			$consua_post_query = new WP_Query( array(
				'post_type'			=> 'consua_header',
				'posts_per_page'	    => -1,
			) );

			$consua_builder_post_title = array();
			$consua_builder_post_title[''] = __('Select a Header','consua');

			while( $consua_post_query->have_posts() ) {
				$consua_post_query->the_post();
				$consua_builder_post_title[ get_the_ID() ] =  get_the_title();
			}
			wp_reset_postdata();

			return $consua_builder_post_title;

        }

    }

    $builder_execute = new ConsuaBuilder();