<?php 

$this->start_controls_section(
	'testimonial_content_style_option',
	[
		'label'			=> esc_html__( 'Content Style','consua-core' ),
		'tab' 			=> \Elementor\Controls_Manager::TAB_STYLE,
	]
);

$this->add_control(
	'section_title_option',
	[
		'label' 		=> esc_html__( 'Title Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
		'condition'		=> [ 'style'	=>	'2' ],
	]
);
$this->add_control(
	'section_title_color',
	[
		'label' 		=> esc_html__( 'Title Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .site-heading .title' => 'color: {{VALUE}}',
		],
		'condition'		=> [ 'style'	=>	'2' ],
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'heading_title_typography',
		'label' 		=> esc_html__( 'Title Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .site-heading .title',
		'condition'		=> [ 'style'	=>	'2' ],
	]
);

$this->add_control(
	'section_subtitle_option',
	[
		'label' 		=> esc_html__( 'Sub-Title Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
		'condition'		=> [ 'style'	=>	'2' ],
	]
);
$this->add_control(
	'section_subtitle_color',
	[
		'label' 		=> esc_html__( 'Subtitle Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .bg-dark .sub-heading' => 'background: {{VALUE}}',
		],
		'condition'		=> [ 'style'	=>	'2' ],
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'section_subtitle_typography',
		'label' 		=> esc_html__( 'Subtitle Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .bg-dark .sub-heading',
		'condition'		=> [ 'style'	=>	'2' ],
	]
);

$this->add_control(
	'content_title_option',
	[
		'label' 		=> esc_html__( 'Title Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
	]
);
$this->add_control(
	'content_title_color',
	[
		'label' 		=> esc_html__( 'Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .testimonial-style-two .top-info h3,{{WRAPPER}} .testimonial-style-one h2' => 'color: {{VALUE}}',
		],
	]
);
$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'content_title_typography',
		'label' 		=> esc_html__( 'Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .testimonial-style-two .top-info h3,{{WRAPPER}} .testimonial-style-one h2',
	]
);

$this->add_control(
	'content_name_option',
	[
		'label' 		=> esc_html__( 'Name Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
	]
);
$this->add_control(
	'content_name_color',
	[
		'label' 		=> esc_html__( 'Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .testimonial-style-one h4,{{WRAPPER}} .testimonial-style-two .provider h4' => 'color: {{VALUE}}',
		],
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'content_name_typography',
		'label' 		=> esc_html__( 'Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .testimonial-style-one h4,{{WRAPPER}} .testimonial-style-two .provider h4',
	]
);

$this->add_control(
	'content_country_option',
	[
		'label' 		=> esc_html__( 'Country Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
		'condition'		=> [ 'style'	=>	'2' ],
	]
);
$this->add_control(
	'content_country_color',
	[
		'label' 		=> esc_html__( 'Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .provider .content span' => 'color: {{VALUE}}',
		],
		'condition'		=> [ 'style'	=>	'2' ],
	]
);
$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'content_country_typography',
		'label' 		=> esc_html__( 'Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .provider .content span',
		'condition'		=> [ 'style'	=>	'2' ],
	]
);

$this->add_control(
	'content_designation_option',
	[
		'label' 		=> esc_html__( 'Designation Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
		'condition'		=> [ 'style'	=>	'1' ],
	]
);
$this->add_control(
	'content_designation_color',
	[
		'label' 		=> esc_html__( 'Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .testimonial-style-one span' => 'color: {{VALUE}}',
		],
		'condition'		=> [ 'style'	=>	'1' ],
	]
);
$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'content_designation_typography',
		'label' 		=> esc_html__( 'Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .testimonial-style-one span',
		'condition'		=> [ 'style'	=>	'1' ],
	]
);

$this->add_control(
	'testimonial_option',
	[
		'label' 		=> esc_html__( 'Testimonial Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
	]
);
$this->add_control(
	'testimonial_color',
	[
		'label' 		=> esc_html__( 'Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .testimonial-style-one p,{{WRAPPER}} .testimonial-style-two p' => 'color: {{VALUE}}',
		],
	]
);
$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'testimonial_typography',
		'label' 		=> esc_html__( 'Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .testimonial-style-one p,{{WRAPPER}} .testimonial-style-two p',
	]
);

$this->end_controls_section();