<?php 

$this->start_controls_section(
	'service_section_style_option',
	[
		'label'			=> esc_html__( 'Section Style','consua-core' ),
		'tab' 			=> \Elementor\Controls_Manager::TAB_STYLE,
	]
);

$this->add_control(
	'section_title_option',
	[
		'label' 		=> esc_html__( 'Title Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
	]
);
$this->add_control(
	'section_title_color',
	[
		'label' 		=> esc_html__( 'Title Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .services-style-two-area .title,{{WRAPPER}} .site-heading .title' => 'color: {{VALUE}}',
		],
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'heading_title_typography',
		'label' 		=> esc_html__( 'Title Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .services-style-two-area .title,{{WRAPPER}} .site-heading .title',
	]
);

$this->add_control(
	'section_subtitle_option',
	[
		'label' 		=> esc_html__( 'Sub-Title Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
	]
);
$this->add_control(
	'section_subtitle_color',
	[
		'label' 		=> esc_html__( 'Subtitle Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .sub-heading,{{WRAPPER}} .home-solar .sub-heading' => 'background: {{VALUE}}',
		],
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'section_subtitle_typography',
		'label' 		=> esc_html__( 'Subtitle Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .sub-heading,{{WRAPPER}} .home-solar .sub-heading',
	]
);

$this->end_controls_section();

$this->start_controls_section(
	'service_content_style_option',
	[
		'label'			=> esc_html__( 'Content Style','consua-core' ),
		'tab' 			=> \Elementor\Controls_Manager::TAB_STYLE,
	]
);

$this->add_control(
	'content_title_option',
	[
		'label' 		=> esc_html__( 'Title Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
	]
);
$this->add_control(
	'content_title_color',
	[
		'label' 		=> esc_html__( 'Title Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .services-style-two .thumb .title h4,{{WRAPPER}} .service-style-four h4 a, {{WRAPPER}} .services-style-three h3 a' => 'color: {{VALUE}}',
		],
	]
);
$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'content_title_typography',
		'label' 		=> esc_html__( 'Title Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .services-style-two .thumb .title h4,{{WRAPPER}} .service-style-four h4 a,{{WRAPPER}} .services-style-three h3 a',
	]
);

$this->add_control(
	'content_subtitle_option',
	[
		'label' 		=> esc_html__( 'Sub-Title Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
	]
);
$this->add_control(
	'content_subtitle_color',
	[
		'label' 		=> esc_html__( 'Subtitle Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .services-style-two .info p,{{WRAPPER}} .service-style-four p,{{WRAPPER}} .services-style-three .info p' => 'color: {{VALUE}}',
		],
	]
);
$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'content_subtitle_typography',
		'label' 		=> esc_html__( 'Subtitle Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .services-style-two .info p,{{WRAPPER}} .service-style-four p,{{WRAPPER}} .services-style-three .info p',
	]
);

$this->add_control(
	'content_read_more_option',
	[
		'label' 		=> esc_html__( 'Read More Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
		'condition'		=> [ 'style'	=>	['4'] ],
	]
);
$this->add_control(
	'content_read_more_color',
	[
		'label' 		=> esc_html__( 'Read More  Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .services-style-two .button a,{{WRAPPER}} .service-style-four .info .icon .link' => 'color: {{VALUE}}',
		'condition'		=> [ 'style'	=>	['4'] ],
		],
	]
);
$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'content_read_more_typography',
		'label' 		=> esc_html__( 'Read More Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .services-style-two .button a,{{WRAPPER}} .service-style-four .info .icon .link',
		'condition'		=> [ 'style'	=>	['4'] ],
	]
);

$this->end_controls_section();