<?php 

$this->start_controls_section(
	'funfact_style',
	[
		'label'			=> esc_html__( 'Style','consua-core' ),
		'tab' 			=> \Elementor\Controls_Manager::TAB_STYLE,
	]
);

$this->add_control(
	'section_title_option',
	[
		'label' 		=> esc_html__( 'Title Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'condition'		=> [ 'style'	=>	['1','5'] ],
		'separator' 	=> 'before',
	]
);

$this->add_control(
	'section_title_color',
	[
		'label' 		=> esc_html__( 'Title Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'condition'		=> [ 'style'	=>	['1','5'] ],
		'selectors' => [
			'{{WRAPPER}} .title' => 'color: {{VALUE}}',
		],
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'section_title_typography',
		'label' 		=> esc_html__( 'Title Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .title',
		'condition'		=> [ 'style'	=>	['1','5'] ],
	]
);

$this->add_control(
	'section_subtitle_option',
	[
		'label' 		=> esc_html__( 'SubTitle Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
		'condition'		=> [ 'style'	=>	['1','5'] ],
	]
);

$this->add_control(
	'section_subtitle_color',
	[
		'label' 		=> esc_html__( 'SubTitle Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' => [
			'{{WRAPPER}} .feature-style-one-heading.text-light p,{{WRAPPER}} .secondary .sub-heading' => 'color: {{VALUE}}',
		],
		'condition'		=> [ 'style'	=>	['1','5'] ],
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'section_subtitle_typography',
		'label' 		=> esc_html__( 'SubTitle Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .feature-style-one-heading.text-light p,{{WRAPPER}} .secondary .sub-heading',
		'condition'		=> [ 'style'	=>	['1','5'] ],
	]
);

$this->add_control(
	'counter_option',
	[
		'label' 		=> esc_html__( 'Counter Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'condition'		=> [ 'style'	=>	'1' ],
		'separator' 	=> 'before',
	]
);

$this->add_control(
	'counter_title_color',
	[
		'label' 		=> esc_html__( 'Counter Title Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' => [
			'{{WRAPPER}} .circle-progress .progressbar h4' => 'color: {{VALUE}}',
		],
		'condition'		=> [ 'style'	=>	'1' ],
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'counter_title_typography',
		'label' 		=> esc_html__( 'Counter Title Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .circle-progress .progressbar h4',
		'condition'		=> [ 'style'	=>	'1' ],
	]
);

$this->add_control(
	'feature_title_option',
	[
		'label' 		=> esc_html__( 'Feature Title Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
		'condition'		=> [ 'style'	=>	['2','1','3','4','5'] ],
	]
);

$this->add_control(
	'feature_title_color',
	[
		'label' 		=> esc_html__( 'Feature Title Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' => [
			'{{WRAPPER}} .feature-style-one h4,{{WRAPPER}} .feature-style-two-area h4 a,{{WRAPPER}} .feature-style-three h4,{{WRAPPER}} .feature-style-four-area h4 a,{{WRAPPER}} .feature-style-five h3' => 'color: {{VALUE}}',
		],
		'condition'		=> [ 'style'	=>	['2','1','3','4','5'] ],
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'feature_title_typography',
		'label' 		=> esc_html__( 'Feature Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .feature-style-one h4,{{WRAPPER}} .feature-style-two-area h4 a,{{WRAPPER}} .feature-style-three h4,{{WRAPPER}} .feature-style-four-area h4 a,{{WRAPPER}} .feature-style-five h3',
		'condition'		=> [ 'style'	=>	['2','1','3','4','5'] ],
	]
);

$this->add_control(
	'feature_sibtitle_option',
	[
		'label' 		=> esc_html__( 'Feature Subtitle Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
		'condition'		=> [ 'style'	=>	['2','1','3','4','5'] ],
	]
);

$this->add_control(
	'feature_sibtitle_color',
	[
		'label' 		=> esc_html__( 'Feature Subtitle Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' => [
			'{{WRAPPER}} .feature-style-one p,{{WRAPPER}} .feature-style-two p,{{WRAPPER}} .feature-style-three p,{{WRAPPER}} .feature-style-four p,{{WRAPPER}} .feature-style-five p' => 'color: {{VALUE}}',
		],
		'condition'		=> [ 'style'	=>	['2','1','3','4','5'] ],
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'feature_sibtitle_typography',
		'label' 		=> esc_html__( 'Feature Subtitle Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .feature-style-one p,{{WRAPPER}} .feature-style-two p,{{WRAPPER}} .feature-style-three p,{{WRAPPER}} .feature-style-four p,{{WRAPPER}} .feature-style-five p',
		'condition'		=> [ 'style'	=>	['2','1','3','4','5'] ],
	]
);


$this->end_controls_section();