<?php 

$this->start_controls_section(
	'contact_content_style_option',
	[
		'label'			=> esc_html__( 'Content Style','consua-core' ),
		'tab' 			=> \Elementor\Controls_Manager::TAB_STYLE,
	]
);

$this->add_control(
	'section_title_option',
	[
		'label' 		=> esc_html__( 'Section Title Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
	]
);

$this->add_control(
	'section_title_color',
	[
		'label' 		=> esc_html__( 'Title Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .contact-style-one-info h2,{{WRAPPER}} .title' => 'color: {{VALUE}}',
		],
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'heading_title_typography',
		'label' 		=> esc_html__( 'Title Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .contact-style-one-info h2,{{WRAPPER}} .title',
	]
);

$this->add_control(
	'section_subtitle_option',
	[
		'label' 		=> esc_html__( 'Section Sub-Title Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
	]
);
$this->add_control(
	'section_subtitle_color',
	[
		'label' 		=> esc_html__( 'Subtitle Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .contact-style-one-info p,{{WRAPPER}} .sub-heading' => 'color: {{VALUE}}',
		],
	]
);
$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'section_subtitle_typography',
		'label' 		=> esc_html__( 'Subtitle Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .contact-style-one-info p,{{WRAPPER}} .sub-heading',
	]
);

$this->add_control(
	'conatct_info_title_option',
	[
		'label' 		=> esc_html__( 'Title Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
		'condition' => [
            'style' => ['1','2']
        ]
	]
);
$this->add_control(
	'conatct_info_title_color',
	[
		'label' 		=> esc_html__( 'Title Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .contact-style-one-info li h5' => 'color: {{VALUE}}',
		],
		'condition' => [
            'style' => ['1','2']
        ]
	]
);
$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'conatct_info_title_typography',
		'label' 		=> esc_html__( 'Title Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .contact-style-one-info li h5',
		'condition' => [
            'style' => ['1','2']
        ]
	]
);

$this->add_control(
	'content_info_option',
	[
		'label' 		=> esc_html__( 'Contact Info Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
		'condition' => [
            'style' => ['1','2']
        ]
	]
);
$this->add_control(
	'content_tagline_color',
	[
		'label' 		=> esc_html__( 'Contact Info Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .contact-style-one-info li a' => 'color: {{VALUE}}',
		],
		'condition' => [
            'style' => ['1','2']
        ]
	]
);
$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'content_tagline_typography',
		'label' 		=> esc_html__( 'Contact Info Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .contact-style-one-info li a',
		'condition' => [
            'style' => ['1','2']
        ]
	]
);

$this->add_control(
	'form_title_option',
	[
		'label' 		=> esc_html__( 'Form Title Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
		'condition' => [
            'style' => ['1','2']
        ]
	]
);

$this->add_control(
	'form_title_color',
	[
		'label' 		=> esc_html__( 'Title Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .contact-form-style-one .heading' => 'color: {{VALUE}}',
		],
		'condition' => [
            'style' => ['1','2']
        ]
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'form_title_typography',
		'label' 		=> esc_html__( 'Title Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .contact-form-style-one .heading',
		'condition' => [
            'style' => ['1','2']
        ]
	]
);

$this->add_control(
	'formn_subtitle_option',
	[
		'label' 		=> esc_html__( 'Form Sub-Title Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
		'condition' => [
            'style' => ['1','2']
        ]
	]
);
$this->add_control(
	'form_subtitle_color',
	[
		'label' 		=> esc_html__( 'Subtitle Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .contact-form-style-one .sub-heading' => 'color: {{VALUE}}',
		],
		'condition' => [
            'style' => ['1','2']
        ]
	]
);
$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'form_subtitle_typography',
		'label' 		=> esc_html__( 'Subtitle Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .contact-form-style-one .sub-heading',
		'condition' => [
            'style' => ['1','2']
        ]
	]
);


$this->end_controls_section();