<?php
	/**
	* Elementor Consua Testimonial Widget.
	*
	* Elementor widget that inserts an embbedable content into the page, from any given URL.
	*
	* @since 1.0.0
	*/
class Elementor_Consua_Testomonial_Carousel_Widget extends \Elementor\Widget_Base {

	/**
	* Get widget name.
	*
	* Retrieve Testimonial widget name.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget name.
	*/
	public function get_name() {
		return 'consua_testimoanial_carousel';
	}

	/**
	* Get widget title.
	*
	* Retrieve Testimonial Nav Tab widget title.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget title.
	*/
	public function get_title() {
		return esc_html__( 'Testimoanial Carousel', 'consua-core' );
	}

	/**
	* Get widget icon.
	*
	* Retrieve Testimonial Nav Tab widget icon.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget icon.
	*/
	public function get_icon() {
		return 'eicon-code';
	}

	/**
	* Get widget categories.
	*
	* Retrieve the list of categories the Testimonial Nav Tab widget belongs to.
	*
	* @since 1.0.0
	* @access public
	*
	* @return array Widget categories.
	*/
	public function get_categories() {
		return [ 'consua_elements' ];
	}
	
	// Add The Input For User
	protected function register_controls(){

		$this->start_controls_section(
			'consua_testimoanial_carousel_style',
			[
				'label'		=> esc_html__( 'Testimonial Content Style','consua-core' ),
				'tab'		=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'style',
			[
				'label' 	=> esc_html__( 'Service Style', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Style One', 'consua-core' ),
					'2' 	=> esc_html__( 'Style Two', 'consua-core' ),
				],
			]
		);


		$this->add_control(
			'section_title',
			[
				'label' 		=> esc_html__( 'Section Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'section title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Section Title', 'consua-core' ),
				'rows'          => '2',
				'condition'		=> [ 'style'	=>	'2' ],
			]

		);

		$this->add_control(
			'section_subtitle',
			[
				'label' 		=> esc_html__( 'Section Subtitle', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'section subtitle', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Section Sub Title', 'consua-core' ),
				'rows'          => '2',
				'condition'		=> [ 'style'	=>	'2' ],
			]

		);

		
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'name', [
				'label' 		=> esc_html__( 'Name', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'name', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Name', 'consua-core' ),
				'rows' 			=> '1',	
				'label_block' 	=> true,
			]
		);

		$repeater->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Title', 'consua-core' ),
				'rows' 			=> '1',	
				'label_block' 	=> true,
			]
		);

		$repeater->add_control(
			'designation', [
				'label' 		=> esc_html__( 'Designation', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'designation', 'consua-core' ),
				'default' 		=> esc_html__( 'Default designation', 'consua-core' ),
				'rows' 			=> '1',	
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'content', [
				'label' 		=> esc_html__( 'Content', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'content', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Content', 'consua-core' ),
				'label_block' 	=> true,
			]
		);

		$repeater->add_control(
		    'rating',
		    [
		        'label' => __('Rating', 'apsro-addon'),
		        'type' => \Elementor\Controls_Manager::SLIDER,
		        'size_units' => ['count'],
		        'range' => [
		            'count' => [
		                'min' => 1,
		                'max' => 5,
		                'step' => 1,
		            ],
		        ],
		        'default' => [
		            'unit' => 'count',
		            'size' => 5,
		        ],
		    ]
		);


		$this->add_control(
			'testimonail_list',
			[
				'label' 	=> esc_html__( 'Testimonial', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
				'default' 	=> [
					[
						'list_title' => esc_html__( 'Add Testimonial', 'consua-core' ),
					],
				],
				'condition'		=> [ 'style'	=>	'1' ],
				'title_field' => '{{{ name }}}',
			]
		);

		$testimonial_list_two = new \Elementor\Repeater();

		$testimonial_list_two->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows' 			=> '1',	
				'label_block' 	=> true,
			]
		);

		$testimonial_list_two->add_control(
			'name', [
				'label' 		=> esc_html__( 'Name', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows' 			=> '1',	
				'label_block' 	=> true,
			]
		);

		$testimonial_list_two->add_control(
			'country', [
				'label' 		=> esc_html__( 'Country', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows' 			=> '1',	
				'label_block' 	=> true,
			]
		);

		$testimonial_list_two->add_control(
			'testimonial', [
				'label' 		=> esc_html__( 'Testimonial', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
			]
		);

		$testimonial_list_two->add_control(
			'logo',
			[
				'label'			=> esc_html__( 'Add Logo','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);

		$testimonial_list_two->add_control(
			'shape',
			[
				'label'			=> esc_html__( 'Add Shape','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);

		$testimonial_list_two->add_control(
		    'rating',
		    [
		        'label' => __('Rating', 'apsro-addon'),
		        'type' => \Elementor\Controls_Manager::SLIDER,
		        'size_units' => ['count'],
		        'range' => [
		            'count' => [
		                'min' => 1,
		                'max' => 5,
		                'step' => 1,
		            ],
		        ],
		        'default' => [
		            'unit' => 'count',
		            'size' => 5,
		        ],
		    ]
		);

		$this->add_control(
			'testimonail_list_two',
			[
				'label' 	=> esc_html__( 'Testimonial', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $testimonial_list_two->get_controls(),
				'default' 	=> [
					[
						'list_title' => esc_html__( 'Add Testimonial', 'consua-core' ),
					],
				],
				'condition'		=> [ 'style'	=>	'2' ],
				'title_field' => '{{{ name }}}',
			]
		);

		$this->add_control(
			'image',
			[
				'label'			=> esc_html__( 'Image','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition'		=> [ 'style'	=>	'1' ],
			]
		);

		$this->add_control(
			'shape',
			[
				'label'			=> esc_html__( 'Shape','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);


		$this->end_controls_section();

		INCLUDE CONSUA_PLUGIN_WIDGET_STYLE_PATH . 'testimonial-style.php';
	}

	// Output For User
	protected function render(){	
	$consua_testimonial_carosel_output = $this->get_settings_for_display();
	if($consua_testimonial_carosel_output['style'] == '1'):
	?>
    <!-- Start Testimonials Style One
    ============================================= -->
    <div class="testimonial-style-one-area default-padding">
        <div class="container">
            <div class="row align-center">

                <div class="col-lg-4">
                    <div class="testimonial-thumb">
                        <div class="thumb-item">
                        	<?php
					        	if(!empty($consua_testimonial_carosel_output['image']['url'])): 
						        	echo consua_img_tag( array(
							            'url'   => esc_url( $consua_testimonial_carosel_output['image']['url'] )
							    	) );
					        	endif;
						    if(!empty($consua_testimonial_carosel_output['shape']['url'])): ?>
	                            <div class="mini-shape">
	                                <?php
							        	echo consua_img_tag( array(
								            'url'   => esc_url( $consua_testimonial_carosel_output['shape']['url'] )
								    	) );
							    	?>
	                            </div>
                        	<?php endif;?>
                        </div>
                    </div>
                </div>

                <div class="col-lg-7 offset-lg-1">
                    <div class="testimonial-carousel swiper">
                        <!-- Additional required wrapper -->
                        <div class="swiper-wrapper">
							<?php foreach($consua_testimonial_carosel_output['testimonail_list'] as $single_testimonial):?>
	                            <!-- Single item -->
	                            <div class="swiper-slide">
	                                <div class="testimonial-style-one">
	                                    
	                                    <div class="item">
	                                        <div class="content">
	                                        	 <div class="rating">
	                                                <?php for ($i = 0; $i < $single_testimonial['rating']['size']; $i++) : ?>
				                                        <i class="fas fa-star"></i>
				                                    <?php endfor; ?>
	                                            </div>
                                           		 <h2><?php echo wp_kses_post($single_testimonial['title'],'consua_kses_allowed_html');?></h2>
	                                            <p>
	                                                <?php echo htmlspecialchars_decode(esc_html($single_testimonial['content'],'consua-core')); ?>
	                                            </p>
	                                        </div>
	                                        <div class="provider">
	                                            <i class="flaticon-quote"></i>
	                                            <div class="info">
	                                                <?php if(!empty($single_testimonial['name'])):?>
					                                    <h4> <?php echo htmlspecialchars_decode(esc_html($single_testimonial['name'],'consua-core')); ?></h4>
					                                <?php endif;?>
					                                <?php if(!empty($single_testimonial['designation'])):?>
					                                    <span> <?php echo htmlspecialchars_decode(esc_html($single_testimonial['designation'],'consua-core')); ?></span>
					                                <?php endif;?>
	                                            </div>
	                                        </div>
	                                    </div>
	                                </div>
	                            </div>
	                            <!-- End Single item -->
	               			<?php endforeach;?>   
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <!-- End Testimonails Style One  -->

	<?php elseif($consua_testimonial_carosel_output['style'] == '2'): ?>

	<!-- Start Testimonials Style Two  
    ============================================= -->
    <div class="testimonials-style-two-area bg-dark default-padding-top half-shape-light-bottom" style="background-image: url(<?php echo esc_url($consua_testimonial_carosel_output['shape']['url']);?>);">
    	<?php if(!empty($consua_testimonial_carosel_output['section_subtitle'] || $consua_testimonial_carosel_output['section_title'])):?>
	        <div class="container">
	            <div class="row">
	                <div class="col-lg-8 offset-lg-2">
	                    <div class="site-heading text-light text-center">
	                    	<?php if(!empty($consua_testimonial_carosel_output['section_subtitle'])):?>
	                        	<h4 class="sub-heading"><?php echo wp_kses_post($consua_testimonial_carosel_output['section_subtitle'],'consua_kses_allowed_html');?></h4>
	                    	<?php endif;?>
	                    	<?php if(!empty($consua_testimonial_carosel_output['section_title'])):?>
	                        	<h2 class="title"><?php echo wp_kses_post($consua_testimonial_carosel_output['section_title'],'consua_kses_allowed_html');?></h2>
	                        <?php endif;?>
	                        <div class="devider"></div>
	                    </div>
	                </div>
	            </div>
	        </div>
	    <?php endif;?>
        <div class="container-fill">
            <div class="row">
                <div class="testimonial-style-two-carousel swiper">
                    <!-- Additional required wrapper -->
                    <div class="swiper-wrapper">
						<?php foreach($consua_testimonial_carosel_output['testimonail_list_two'] as $single_testimonial):
							?>
                        	<!-- Single Item -->
	                        <div class="swiper-slide">
	                            <div class="testimonial-style-two">
	                                <?php
		                                if(!empty($single_testimonial['shape']['url'])): ?>
		                                  <img src="<?php echo esc_url($single_testimonial['shape']['url']);?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
		                            <?php endif;
									?>
	                                <div class="top-info">
	                                    <h3><?php echo esc_html($single_testimonial['title'],'consua-core'); ?></h3>
	                                    <div class="testimonial-rating">
			                                <?php for ($i = 0; $i < $single_testimonial['rating']['size']; $i++) : ?>
		                                        <i class="fas fa-star"></i>
		                                    <?php endfor; ?>
	                                    </div>
	                                </div>
	                                <div class="info">
	                                    <p>
	                                       <?php echo esc_html($single_testimonial['testimonial'],'consua-core'); ?>
	                                    </p>
	                                </div>
	                                <div class="provider">
	                                    <div class="content">
	                                        <h4><?php echo esc_html($single_testimonial['name'],'consua-core'); ?></h4>
	                                        <span><?php echo esc_html($single_testimonial['country'],'consua-core'); ?></span>
	                                    </div>
	                                    <?php if(!empty($single_testimonial['logo']['url'])):?>
		                                    <div class="thumb">
		                                      <img src="<?php echo esc_url($single_testimonial['logo']['url']);?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
		                                    </div>
	                                	<?php endif;?>
	                                </div>
	                            </div>
	                        </div>
	                        <!-- End Single Item -->
                        <?php endforeach; ?>	
                    </div>

                    <!-- Pagination -->
                    <div class="swiper-pagination"></div>

                </div>
            </div>
        </div>
    </div>
    <!-- End Testimonials Style Two  -->	
    <?php
	endif;
    }
}