<?php
	/**
	* Elementor Service Cta Widget.
	*
	* Elementor widget that inserts an embbedable content into the page, from any given URL.
	*
	* @since 1.0.0
	*/
class Elementor_Consua_Service_Cta_Widget extends \Elementor\Widget_Base {

	/**
	* Get widget name.
	*
	* Retrieve Service Cta widget name.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget name.
	*/
	public function get_name() {
		return 'consua_service_cta';
	}

	/**
	* Get widget title.
	*
	* Retrieve Service Cta widget title.
	*
	* @since 1.0.0
	* @access public 
	*
	* @return string Widget title.
	*/
	public function get_title() {
		return esc_html__( 'Service CTA', 'consua-core' );
	}

	/**
	* Get widget icon.
	*
	* Retrieve Service Cta widget icon.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget icon.
	*/
	public function get_icon() {
		return 'eicon-code';
	}

	/**
	* Get widget categories.
	*
	* Retrieve the list of categories the Service Cta widget belongs to.
	*
	* @since 1.0.0
	* @access public
	*
	* @return array Widget categories.
	*/
	public function get_categories() {
		return [ 'consua_elements'];
	}

	public function get_script_depends() {
        return array('main');
    }

	// Add The Input For User
	protected function register_controls(){
		

		$this->start_controls_section(
			'service_cta_content',
			[
				'label'		=> esc_html__( 'Set Content','consua-core' ),
				'tab'		=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'rows'          => '2',
				'placeholder' 	=> esc_html__( 'Title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Title', 'consua-core' ),
				'label_block' 	=> true,
			]
		);

		$this->add_control(
			'subtitle', [
				'label' 		=> esc_html__( 'SubTitle', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'rows'          => '2',
				'placeholder' 	=> esc_html__( 'SubTitle', 'consua-core' ),
				'default' 		=> esc_html__( 'Default SubTitle', 'consua-core' ),
				'label_block' 	=> true,
			]
		);

		$this->add_control(
			'number', [
				'label' 		=> esc_html__( 'Number', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows'          => '2',
				'label_block' 	=> true,
				'placeholder' 	=> esc_html__( 'number', 'consua-core' ),
				'default' 		=> esc_html__( 'Number', 'consua-core' ),
				'label_block' 	=> true,
			]
		);

		$this->add_control(
			'mail', [
				'label' 		=> esc_html__( 'Mail', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows'          => '2',
				'label_block' 	=> true,
				'placeholder' 	=> esc_html__( 'mail', 'consua-core' ),
				'default' 		=> esc_html__( 'Mail', 'consua-core' ),
				'label_block' 	=> true,
			]
		);

		$this->add_control(
			'button_label', [
				'label' 		=> esc_html__( 'Button Label', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'button label', 'consua-core' ),
				'default' 		=> esc_html__( 'Button Label', 'consua-core' ),
				'label_block' 	=> true,
			]
		);

		$this->add_control(
			'url',
			[
				'label' 		=> esc_html__( 'URL', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'consua-core' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);

		$this->add_control(
			'shape',
			[
				'label' 	=> esc_html__( 'Background Shape', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::MEDIA,
			]
		);
		
		$this->end_controls_section();

		INCLUDE CONSUA_PLUGIN_WIDGET_STYLE_PATH . 'service-cta-style.php';	
	}

	// Output For User
	protected function render(){
	$consua_service_cta = $this->get_settings_for_display();
	?>
    <!-- Start Service CTA
    ============================================= -->
    <div class="single-widget bg-dark quick-contact-widget text-light" style="background-image: url(<?php echo esc_url($consua_service_cta['shape']['url']);?>);">
        <div class="content">
            <h3><?php echo wp_kses_post($consua_service_cta['title'],'consua_kses_allowed_html');?></h3>
            <p>
              <?php echo wp_kses_post($consua_service_cta['subtitle'],'consua_kses_allowed_html');?>
            </p>
            <?php echo wp_kses_post($consua_service_cta['number'],'consua_kses_allowed_html');?>
            <?php echo wp_kses_post($consua_service_cta['mail'],'consua_kses_allowed_html');?>
            <?php if(!empty($consua_service_cta['button_label'])):?>
            	<a class="btn mt-30 circle btn-sm btn-gradient" href="<?php echo esc_url($consua_service_cta['url']['url']);?>"><?php echo wp_kses_post($consua_service_cta['button_label'],'consua_kses_allowed_html');?></a>
        	<?php endif;?>
        </div>
    </div>
    <!-- End Service CTA -->
	<?php 
	}
}