<?php
	/**
	* Elementor consua Request Call Back Widget.
	*
	* Elementor widget that inserts an embbedable content into the page, from any given URL.
	*
	* @since 1.0.0
	*/
class Elementor_Consua_Request_Callback_Widget extends \Elementor\Widget_Base {

	/**
	* Get widget name.
	*
	* Retrieve Request Call Back widget name.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget name.
	*/
	public function get_name() {
		return 'consua_request_callback';
	}

	/**
	* Get widget title.
	*
	* Retrieve Request Call Back Nav Tab widget title.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget title.
	*/
	public function get_title() {
		return esc_html__( 'Request Call Back', 'consua-core' );
	}

	/**
	* Get widget icon.
	*
	* Retrieve Request Call Back Nav Tab widget icon.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget icon.
	*/
	public function get_icon() {
		return 'eicon-code';
	}

	/**
	* Get widget categories.
	*
	* Retrieve the list of categories the Request Call Back Nav Tab widget belongs to.
	*
	* @since 1.0.0
	* @access public
	*
	* @return array Widget categories.
	*/
	public function get_categories() {
		return [ 'consua_elements' ];
	}
	
	// Add The Input For User
	protected function register_controls(){

		$this->start_controls_section(
			'consua_request_call_back_style',
			[
				'label'		=> esc_html__( 'Request Call Back Content Style','consua-core' ),
				'tab'		=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'style',
			[
				'label' 		=> __( 'Style', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  		=> __( 'Style One', 'consua-core' ),
					'2' 		=> __( 'Style Two', 'consua-core' ),
				],
			]
		);

		$this->add_control(
			'bg_image',
			[
				'label'			=> esc_html__( 'Background Image','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'heading', [
				'label' 		=> esc_html__( 'Heading', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'condition'		=> [ 'style'	=>	['1','2'] ],
			]
		);

		$this->add_control(
			'button_label', [
				'label' 		=> esc_html__( 'Button Label', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'label_block' 	=> true,
				'condition'		=> [ 'style'	=>	'1' ],
			]
		);

		$this->add_control(
			'button_url',
			[
				'label' 		=> __( 'URL', 'consua' ),
				'type' 			=> \Elementor\Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'consua' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
				'condition'		=> [ 'style'	=>	'1' ],
			]
		);

		$this->add_control(
			'request_shortcode',
			[
				'label' 		=> esc_html__( 'Request Form Shortcode', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'placeholder' 	=> esc_html__( 'Put your shortcode Here', 'consua-core' ),
				'condition'		=> [ 'style'	=>	'2' ],
			]

		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'number', [
				'label' 		=> esc_html__( 'Number', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'label_block' 	=> true,
			]
		);

		$repeater->add_control(
			'operator', [
				'label' 		=> esc_html__( 'Operator', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'label_block' 	=> true,
			]
		);

		$repeater->add_control(
			'icon_style',
			[
				'label' 	=> esc_html__( 'Icon Style', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Flaticon', 'consua-core' ),
					'3' 	=> esc_html__( 'Icon Image', 'consua-core' ),
					'2'  	=> esc_html__( 'Custom Icon', 'consua-core' ),
				],
			]
		);

		$repeater->add_control(
			'flat_icon',
			[
                'label'      => esc_html__('Icon One', 'consua-core'),
                'type'       => \Elementor\Controls_Manager::ICON,
                'options'    => consua_flaticons(),
                'include'    => consua_include_flaticons(),
                'default'    => 'flaticon-vegetables',
                'condition' => [
                    'icon_style' => '1'
                ]
            ]
		);

		$repeater->add_control(
			'custom_icon', [
				'label' 		=> esc_html__( 'Custom Icon', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'condition' => [
                    'icon_style' => '2'
                ]
			]
		);


		$repeater->add_control(
			'icon_image',
			[
				'label'			=> esc_html__( 'Add Image Icon','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'icon_style' => '3'
                ]
			]
		);
		
		$this->add_control(
			'request_callback_list',
			[
				'label' 	=> esc_html__( 'Request CallBack  List', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
				'prevent_empty' => 'false',
				'title_field' => '{{{ title }}}',
				'condition'		=> [ 'style'	=>	['1','2'] ],
			]
		);

		$this->end_controls_section();

		include CONSUA_PLUGIN_WIDGET_STYLE_PATH . 'request-callback-style.php';
	}

	// Output For User
	protected function render(){	
	$consua_request_callback_output = $this->get_settings_for_display();
	if($consua_request_callback_output['style'] == '1'): 
	?>

    <!-- Start Request Call Back 
    ============================================= -->
    <div class="request-call-back-area text-light default-padding" style="background-image: url(<?php echo esc_url($consua_request_callback_output['bg_image']['url']) ?>);">
        <div class="container">
            <div class="row align-center">
                <div class="col-lg-6">
                    <h2 class="title"><?php echo htmlspecialchars_decode(esc_html($consua_request_callback_output['heading'],'consua-core')); ?></h2>
                    <?php if(!empty($consua_request_callback_output['button_label'])):?>
                    	<a class="btn circle btn-light mt-30 mt-md-15 mt-xs-10 btn-md radius animation" href="<?php echo esc_url($consua_request_callback_output['button_url']['url']); ?>"><?php echo esc_html($consua_request_callback_output['button_label']);?></a>
                	<?php endif;?>
                </div>
                <div class="col-lg-6 text-end">
                    <div class="achivement-counter">
                        <ul>
                        	<?php foreach($consua_request_callback_output['request_callback_list'] as $item): ?>
	                            <li>
                                    <div class="icon">
				                       <?php if(!empty($item['flat_icon'])):?>
				                        <i class="<?php echo esc_attr($item['flat_icon']); ?>"></i>
					                    <?php endif;?>
				                    <?php if(!empty($item['icon_image'])):?>
				                        <img src="<?php echo esc_url($item['icon_image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
				                    <?php endif;?>
				                    <?php 
				                    if(!empty($item['custom_icon'])):?>
				                        <i class="<?php echo esc_attr($item['custom_icon']); ?>"></i>
				                    <?php endif;?>
				                    </div>
	                                <div class="fun-fact">
	                                    <div class="counter">
	                                        <div class="timer" data-to="<?php echo esc_attr($item['number']);?>" data-speed="2000"><?php echo esc_html($item['number']);?></div>
	                                        <div class="operator"><?php echo esc_html($item['operator']);?></div>
	                                    </div>
	                                    <span class="medium"><?php echo esc_html($item['title']);?></span>
	                                </div>
	                            </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Request Call Back  -->

    <?php elseif($consua_request_callback_output['style'] == '2'): ?>

    <!-- Start Check SEO
    ============================================= -->
    <div class="request-call-back-area secondary text-light default-padding" style="background-image: url(<?php echo esc_url($consua_request_callback_output['bg_image']['url']) ?>);">
        <div class="container">
            <div class="row align-center">
                <div class="col-lg-6">
                    <h2 class="title"><?php echo wp_kses_post($consua_request_callback_output['heading'],'consua_kses_allowed_html');?></h2>
                   	<?php
                   		 echo str_replace("<br />", "", trim(do_shortcode($consua_request_callback_output['request_shortcode'])));
                   	?>
                </div>
                <div class="col-lg-6 text-end">
                    <div class="achivement-counter">
                        <ul>
                        	<?php foreach($consua_request_callback_output['request_callback_list'] as $item): ?>
	                            <li>
	                                <div class="icon">
	                                    <?php if(!empty($item['flat_icon'])):?>
				                        <i class="<?php echo esc_attr($item['flat_icon']); ?>"></i>
					                    <?php endif;?>
					                    <?php if(!empty($item['icon_image'])):?>
					                        <img src="<?php echo esc_url($item['icon_image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
					                    <?php endif;?>
					                    <?php 
					                    if(!empty($item['custom_icon'])):?>
					                        <i class="<?php echo esc_attr($item['custom_icon']); ?>"></i>
					                    <?php endif;?>
	                                </div>
	                                <div class="fun-fact">
	                                    <div class="counter">
	                                        <div class="timer" data-to="<?php echo esc_attr($item['number']);?>" data-speed="2000"><?php echo esc_html($item['number']);?></div>
	                                        <div class="operator"><?php echo esc_html($item['operator']);?></div>
	                                    </div>
	                                    <span class="medium"><?php echo wp_kses_post($item['title'],'consua_kses_allowed_html');?></span>
	                                </div>
	                            </li>
                            <?php endforeach;?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Check SEO  -->
    <?php
	endif;
    }
}