<?php
	/**
	* Elementor Consua Project Widget.
	*
	* Elementor widget that inserts an embbedable content into the page, from any given URL.
	*
	* @since 1.0.0
	*/
class Elementor_Consua_Project_Info_Widget extends \Elementor\Widget_Base {

	/**
	* Get widget name.
	*
	* Retrieve Project widget name.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget name.
	*/
	public function get_name() {
		return 'consua_project_info';
	}

	/**
	* Get widget title.
	*
	* Retrieve Project Nav Tab widget title.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget title.
	*/
	public function get_title() {
		return esc_html__( 'Project Info', 'consua-core' );
	}

	/**
	* Get widget icon.
	*
	* Retrieve Project Nav Tab widget icon.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget icon.
	*/
	public function get_icon() {
		return 'eicon-code';
	}

	/**
	* Get widget categories.
	*
	* Retrieve the list of categories the Project Nav Tab widget belongs to.
	*
	* @since 1.0.0
	* @access public
	*
	* @return array Widget categories.
	*/
	public function get_categories() {
		return [ 'consua_elements' ];
	}
	
	// Add The Input For User
	protected function register_controls(){

		$this->start_controls_section(
			'consua_project_info_style',
			[
				'label'		=> esc_html__( 'Project Style','consua-core' ),
				'tab'		=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


		$this->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows'          => '2',
				'placeholder' 	=> esc_html__( 'Title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Title', 'consua-core' ),
				'label_block' 	=> true,
			]
		);
		
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows' 			=>'2',
				'placeholder' 	=> esc_html__( 'title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Title', 'consua-core' ),
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'info', [
				'label' 		=> esc_html__( 'Info', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows' 			=>'1',
				'placeholder' 	=> esc_html__( 'info', 'consua-core' ),
				'default' 		=> esc_html__( 'Default info', 'consua-core' ), 	
				'label_block' 	=> true,
			]
		);

		$this->add_control(
			'project_info_list',
			[
				'label' 	=> esc_html__( 'Project List', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
				'default' 	=> [
					[
						'list_title' => esc_html__( 'Add Project', 'consua-core' ),
					],
				],
				'title_field' => '{{{ title }}}',
				'prevent_empty' => false
			]
		);

		$social = new \Elementor\Repeater();

		$social->add_control(
			'icon_style',
			[
				'label' 	=> esc_html__( 'Icon Style', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Flaticon', 'consua-core' ),
					'3' 	=> esc_html__( 'Icon Image', 'consua-core' ),
					'2'  	=> esc_html__( 'Custom Icon', 'consua-core' ),
				],
			]
		);

		$social->add_control(
			'flat_icon',
			[
                'label'      => esc_html__('Icon One', 'cleanu-core'),
                'type'       => \Elementor\Controls_Manager::ICON,
                'options'    => consua_flaticons(),
                'include'    => consua_include_flaticons(),
                'default'    => 'flaticon-budget',
                'condition' => [
                    'icon_style' => '1'
                ]
            ]
		);

		$social->add_control(
			'custom_icon', [
				'label' 		=> esc_html__( 'Custom Icon', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'label_block' 	=> true,
				'condition' => [
                    'icon_style' => '2'
                ]
			]
		);


		$social->add_control(
			'icon_image',
			[
				'label'			=> esc_html__( 'Add Image Icon','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'icon_style' => '3'
                ]
			]
		);

		$social->add_control(
		    'url',
		    [
		        'label' => __('Add Url', 'apsro-addon'),
		        'type' => \Elementor\Controls_Manager::URL,
		        'placeholder' => __('#', 'apsro-addon'),
		        'show_external' => false,
		        'default' => [
		            'url' => '#',
		            'is_external' => false,
		            'nofollow' => false,
		        ],
		        'show_label' => false,
		    ]
		);

		$this->add_control(
		    'social_list',
		    [
		        'label' => __('Social List', 'apsro-addon'),
		        'type' => \Elementor\Controls_Manager::REPEATER,
		        'fields' => $social->get_controls(),
		        'prevent_empty' => false,
		        'default' => [
		            [
		                'social_url' => [
		                    'url' => '#',
		                    'is_external' => false,
		                    'nofollow' => false,
		                ],
		            ],
		        ],

		    ]
		);

		$this->add_control(
			'bg_image',
			[
				'label'			=> esc_html__( 'Add Image','Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' 	=> [
					'url' 		=> \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->end_controls_section();

		INCLUDE CONSUA_PLUGIN_WIDGET_STYLE_PATH . 'project-info-style.php';	
	}

	// Output For User
	protected function render(){	
	$consua_project_info_output = $this->get_settings_for_display();
	?>
    <!-- Start Project Style One
    ============================================= -->
    <div class="order-lg-last right-info">
        <div class="project-info mt-15" style="background-image: url(<?php echo esc_url($consua_project_info_output['bg_image']['url']);?>);">
            <h4 class="title"><?php echo wp_kses($consua_project_info_output['title'], 'consua_allowed_tags'); ?></h4>
            <ul>
            	<?php 
                	foreach($consua_project_info_output['project_info_list'] as $single_project_info): 
                ?>
	                <li>
	                    <?php echo wp_kses($single_project_info['title'], 'consua_allowed_tags'); ?> <span><?php echo wp_kses($single_project_info['info'], 'consua_allowed_tags'); ?></span>
	                </li>
                <?php endforeach;?>
            </ul>
            <ul class="social">
                <?php 
	            	foreach ($consua_project_info_output['social_list'] as $single_item):
	            ?>
                    <li>
                        <a href="<?php echo esc_url($single_item['url']['url']);?>">
                           <?php if(!empty($single_item['flat_icon'])):?>
		                    <i class="<?php echo esc_attr($single_item['flat_icon']); ?>"></i>
		                    <?php endif;?>
		                    <?php if(!empty($single_item['icon_image']['url'])):?>
		                        <img src="<?php echo esc_url($single_item['icon_image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
		                    <?php endif;?>
		                    <?php 
		                    	if(!empty($single_item['custom_icon'])):?>
		                        <i class="<?php echo esc_attr($single_item['custom_icon']); ?>"></i>
		                    <?php endif;?>
                        </a>
                    </li>
               	<?php endforeach;?>
            </ul>
        </div>
    </div>
    <!-- End Project Style One -->
    <?php 	
    }
}