<?php
	/**
	* Elementor Consua Process Widget.
	*
	* Elementor widget that inserts an embbedable content into the page, from any given URL.
	*
	* @since 1.0.0
	*/
class Elementor_Consua_Process_Widget extends \Elementor\Widget_Base {

	/**
	* Get widget name.
	*
	* Retrieve Process widget name.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget name.
	*/
	public function get_name() {
		return 'consua_process';
	}

	/**
	* Get widget title.
	*
	* Retrieve Process Nav Tab widget title.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget title.
	*/
	public function get_title() {
		return esc_html__( 'Process', 'Consua-core' );
	}

	/**
	* Get widget icon.
	*
	* Retrieve Process Nav Tab widget icon.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget icon.
	*/
	public function get_icon() {
		return 'eicon-code';
	}

	/**
	* Get widget categories.
	*
	* Retrieve the list of categories the Process Nav Tab widget belongs to.
	*
	* @since 1.0.0
	* @access public
	*
	* @return array Widget categories.
	*/
	public function get_categories() {
		return [ 'consua_elements' ];
	}
	
	// Add The Input For User
	protected function register_controls(){
		$this->start_controls_section(
			'process_content_style',
			[
				'label'		=> esc_html__( 'Content Style','Consua-core' ),
				'tab'		=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'style',
			[
				'label' 	=> esc_html__( 'Style', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Style One', 'consua-core' ),
					'2'  	=> esc_html__( 'Style Two', 'consua-core' )
				],
			]
		);

		$this->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows'   		=>'4',
				'label_block' 	=> true,
			]
		);

		$this->add_control(
			'subtitle', [
				'label' 		=> esc_html__( 'Sub-Title', 'Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows'   		=>'4',
				'label_block' 	=> true,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows'   		=>'2',
				'label_block' 	=> true,
			]
		);

		$repeater->add_control(
			'summary', [
				'label' 		=> esc_html__( 'Summary', 'Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows'   		=>'4',
				'label_block' 	=> true,
			]
		);

		$repeater->add_control(
			'image',
			[
				'label'			=> esc_html__( 'Add Image','Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' 	=> [
					'url' 		=> \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		
		$this->add_control(
			'process_list',
			[
				'label' 	=> esc_html__( 'Process List', 'Consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
				'prevent_empty' => false,
				'title_field' => '{{{ title }}}',
				'condition' => [
                    'style' => '1'
                ]
			]
		);

		$process_list_two = new \Elementor\Repeater();

		$process_list_two->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows'   		=>'2',
				'label_block' 	=> true,
			]
		);

		$process_list_two->add_control(
			'image',
			[
				'label'			=> esc_html__( 'Add Image','Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' 	=> [
					'url' 		=> \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		
		$this->add_control(
			'process_list_two',
			[
				'label' 	=> esc_html__( 'Process List', 'Consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $process_list_two->get_controls(),
				'prevent_empty' => false,
				'title_field' => '{{{ title }}}',
				'condition' => [
                    'style' => '2'
                ]
			]
		);

		$this->add_control(
			'process_bac_shape',
			[
				'label'			=> esc_html__( 'Bacground Shape','Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);

		$this->end_controls_section();

		INCLUDE CONSUA_PLUGIN_WIDGET_STYLE_PATH . 'process-style.php';	
	}

	// Output For User
	protected function render(){	
	$consua_process_output = $this->get_settings_for_display();
	if($consua_process_output['style'] == '1'):
	?>

    <!-- Start Process
    ============================================= -->
    <div class="process-style-one-area text-center default-padding">
    	<?php if (!empty($consua_process_output['process_bac_shape']['url'])) : ?>
	        <div class="large-shape">
	            <img src="<?php echo esc_url($consua_process_output['process_bac_shape']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
	        </div>
	    <?php endif;?>
        <?php if(!empty($consua_process_output['title'] || $consua_process_output['subtitle'])):?>
        <div class="container">
            <div class="row">
                <div class="col-lg-8 offset-lg-2">
                    <div class="site-heading text-center">
                        <h4 class="sub-heading"><?php echo wp_kses($consua_process_output['subtitle'], 'consua_allowed_tags'); ?></h4>
                        <h2 class="title"><?php echo wp_kses($consua_process_output['title'], 'consua_allowed_tags'); ?></h2>
                        <div class="devider"></div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif;?>
        <div class="container">
            <div class="row">
        		<?php if (is_array($consua_process_output['process_list'])) : 
        			$i = 1;
                	foreach($consua_process_output['process_list'] as $process_item):?>
	                <!-- Single Item -->
	                <div class="col-lg-4">
	                    <div class="process-style-one<?php if($i == '1'){echo esc_attr(" active");}?>">
	                    	<?php if (!empty($process_item['image']['url'])) : ?>
		                        <div class="thumb">
		                            <img src="<?php echo esc_url($process_item['image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
		                            <span><?php echo esc_attr("0",'consua-core'); ?><?php echo esc_attr($i);?></span>
		                        </div>
	                    	<?php endif;?>
	                        <h4><?php echo wp_kses($process_item['title'], 'consua_allowed_tags'); ?></h4>
	                        <p>
	                           <?php echo wp_kses($process_item['summary'], 'consua_allowed_tags'); ?>
	                        </p>
	                    </div>
	                </div>
	                <!-- End Single Item -->
           		<?php $i++; endforeach; endif;?>
            </div>
        </div>
    </div>
    <!-- End Process -->

	<?php elseif($consua_process_output['style'] == '2'):?>

	<!-- Start Process Style Two
    ============================================= -->
    <div class="process-style-two-area text-center default-padding" style="background-image: url(<?php echo esc_url($consua_process_output['process_bac_shape']['url']); ?>);">

    	<?php if(!empty($consua_process_output['title'] || $consua_process_output['subtitle'])):?>
	        <div class="container">
	            <div class="row">
	                <div class="col-lg-8 offset-lg-2">
	                    <div class="site-heading text-center">
	                        <h4 class="sub-heading"><?php echo wp_kses($consua_process_output['subtitle'], 'consua_allowed_tags'); ?></h4>
	                        <h2 class="title"><?php echo wp_kses($consua_process_output['title'], 'consua_allowed_tags'); ?></h2>
	                        <div class="devider"></div>
	                    </div>
	                </div>
	            </div>
	        </div>
        <?php endif;?>

        <div class="container">
            <div class="process-style-two-items">
                <div class="row">

					<?php 
	        			$i = 1;
	                	foreach($consua_process_output['process_list_two'] as $process_item):?>
	                    <!-- Single item -->
	                    <div class="col-lg-4">
	                        <div class="process-style-two">
	                        	<?php if (!empty($process_item['image']['url'])) : ?>
		                            <div class="thumb">
		                                <img src="<?php echo esc_url($process_item['image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
		                                <span><?php echo esc_attr("0",'consua-core'); ?><?php echo esc_attr($i);?></span>
		                            </div>
	                        	<?php endif;?>
	                            <h3><?php echo wp_kses($process_item['title'], 'consua_allowed_tags'); ?></h3>
	                        </div>
	                    </div>
	                    <!-- End Single item -->
	                <?php $i++; endforeach; ?>
                  
                </div>
            </div>
        </div>
    </div>
    <!-- End Process Style Two -->

    <?php
	endif;
    }
}