<?php
	/**
	* Elementor Consua Header Widget.
	*
	* Elementor widget that inserts an embbedable content into the page, from any given URL.
	*
	* @since 1.0.0
	*/
class Elementor_Consua_Header_Widget extends \Elementor\Widget_Base {

	/**
	* Get widget name.
	*
	* Retrieve Header widget name.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget name.
	*/
	public function get_name() {
		return 'consua_header';
	}

	/**
	* Get widget title.
	*
	* Retrieve Header Nav Tab widget title.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget title.
	*/
	public function get_title() {
		return esc_html__( 'Consua Header', 'Consua-core' );
	}

	/**
	* Get widget icon.
	*
	* Retrieve Farmer Info Nav Tab widget icon.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget icon.
	*/
	public function get_icon() {
		return 'eicon-code';
	}

	/**
	* Get widget categories.
	*
	* Retrieve the list of categories the Farmers Nav Tab widget belongs to.
	*
	* @since 1.0.0
	* @access public
	*
	* @return array Widget categories.
	*/
	public function get_categories() {
		return [ 'consua_elements' ];
	}
	
	// Add The Input For User
	protected function register_controls(){

		$this->start_controls_section(
			'ag_header_style',
			[
				'label'		=> esc_html__( 'Header Style','Consua-core' ),
				'tab'		=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'style',
			[
				'label' 	=> esc_html__( 'Style', 'Consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Style One', 'Consua-core' ),
					'2' 	=> esc_html__( 'Style Two', 'Consua-core' ),
					'3' 	=> esc_html__( 'Style Three', 'Consua-core' ),
					'4' 	=> esc_html__( 'Style Four', 'Consua-core' ),
					'5' 	=> esc_html__( 'Style Five', 'Consua-core' ),
					'6' 	=> esc_html__( 'Style Six', 'Consua-core' ),
					'7' 	=> esc_html__( 'Style Seven', 'Consua-core' ),
				],
			]
		);

		$this->add_control(
			'header_logo_desktop',
			[
				'label'			=> esc_html__( 'Header Logo Desktop','Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'header_logo_scroll',
			[
				'label'			=> esc_html__( 'Header Logo Scroll','Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'style' => ['3','5','6','4']
                ]
			]
		);

		$this->add_control(
			'header_logo_mobile',
			[
				'label'			=> esc_html__( 'Header Logo Mobile','Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
		    'nav_menu',
		    [
		        'label' => __('Select Nav Menu', 'consua-addon'),
		        'type' => \Elementor\Controls_Manager::SELECT2,
		        'options' => consua_get_nav_menu(),
		        'label_block' => true,
		    ]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'info', [
				'label' 		=> esc_html__( 'Info', 'Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows'      	=> '2', 	
				'label_block' 	=> true,
			]
		);

		$repeater->add_control(
			'icon_style',
			[
				'label' 	=> esc_html__( 'Icon Style', 'Consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Flaticon', 'Consua-core' ),
					'3' 	=> esc_html__( 'Icon Image', 'Consua-core' ),
					'2'  	=> esc_html__( 'Custom Icon', 'Consua-core' ),
				],
			]
		);

		$repeater->add_control(
			'flat_icon',
			[
                'label'      => esc_html__('Icon One', 'cleanu-core'),
                'type'       => \Elementor\Controls_Manager::ICON,
                'options'    => Consua_flaticons(),
                'include'    => Consua_include_flaticons(),
                'condition' => [
                    'icon_style' => '1'
                ]
            ]
		);

		$repeater->add_control(
			'custom_icon', [
				'label' 		=> esc_html__( 'Custom Icon', 'Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'rows'  		=>'2',
				'condition' => [
                    'icon_style' => '2'
                ]
			]
		);


		$repeater->add_control(
			'icon_image',
			[
				'label'			=> esc_html__( 'Add Image Icon','Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'icon_style' => '3'
                ]
			]
		);
		
		$this->add_control(
			'header_contact_info_list',
			[
				'label' 	=> esc_html__( 'Contact Info List', 'Consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
				'prevent_empty' =>false,
				'default' 	=> [
					[
						'list_title' => esc_html__( 'Add Contact Info', 'consua-core' ),
					],
				],
				'title_field' => '{{{ info }}}',
				'condition' => [
                    'style' => ['1','2','5','6','4','7']
                ]
			]
		);
		
		$this->add_control(
            'wishlist_enable',
            [
                'label' => __('Enable Wishlist?', 'consua-addon'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'consua-addon'),
                'label_off' => __('No', 'consua-addon'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'style' => ['7']
                ]
            ]
        );
        
        $this->add_control(
            'cart_enable',
            [
                'label' => __('Enable Cart?', 'consua-addon'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'consua-addon'),
                'label_off' => __('No', 'consua-addon'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'style' => ['7']
                ]
            ]
        );


        $social = new \Elementor\Repeater();

		$social->add_control(
			'icon_style',
			[
				'label' 	=> esc_html__( 'Icon Style', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Flaticon', 'consua-core' ),
					'3' 	=> esc_html__( 'Icon Image', 'consua-core' ),
					'2'  	=> esc_html__( 'Custom Icon', 'consua-core' ),
				],
			]
		);

		$social->add_control(
			'flat_icon',
			[
                'label'      => esc_html__('Icon One', 'cleanu-core'),
                'type'       => \Elementor\Controls_Manager::ICON,
                'options'    => consua_flaticons(),
                'include'    => consua_include_flaticons(),
                'default'    => 'flaticon-budget',
                'condition' => [
                    'icon_style' => '1'
                ]
            ]
		);

		$social->add_control(
			'custom_icon', [
				'label' 		=> esc_html__( 'Custom Icon', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'label_block' 	=> true,
				'condition' => [
                    'icon_style' => '2'
                ]
			]
		);


		$social->add_control(
			'icon_image',
			[
				'label'			=> esc_html__( 'Add Image Icon','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'icon_style' => '3'
                ]
			]
		);

		$social->add_control(
		    'url',
		    [
		        'label' => __('Add Url', 'apsro-addon'),
		        'type' => \Elementor\Controls_Manager::URL,
		        'placeholder' => __('#', 'apsro-addon'),
		        'show_external' => false,
		        'default' => [
		            'url' => '#',
		            'is_external' => false,
		            'nofollow' => false,
		        ],
		        'show_label' => false,
		    ]
		);

		$this->add_control(
		    'social_list',
		    [
		        'label' => __('Social List', 'apsro-addon'),
		        'type' => \Elementor\Controls_Manager::REPEATER,
		        'fields' => $social->get_controls(),
		        'prevent_empty' => false,
		        'default' => [
		            [
		                'social_url' => [
		                    'url' => '#',
		                    'is_external' => false,
		                    'nofollow' => false,
		                ],
		            ],
		        ],
		        'condition' => [
                    'style' => ['1','5','7']
                ]

		    ]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'info', [
				'label' 		=> esc_html__( 'Info', 'Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows'      	=> '2', 	
				'label_block' 	=> true,
			]
		);

		$repeater->add_control(
			'icon_style',
			[
				'label' 	=> esc_html__( 'Icon Style', 'Consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Flaticon', 'Consua-core' ),
					'3' 	=> esc_html__( 'Icon Image', 'Consua-core' ),
					'2'  	=> esc_html__( 'Custom Icon', 'Consua-core' ),
				],
			]
		);

		$repeater->add_control(
			'flat_icon',
			[
                'label'      => esc_html__('Icon One', 'cleanu-core'),
                'type'       => \Elementor\Controls_Manager::ICON,
                'options'    => Consua_flaticons(),
                'include'    => Consua_include_flaticons(),
                'condition' => [
                    'icon_style' => '1'
                ]
            ]
		);

		$repeater->add_control(
			'custom_icon', [
				'label' 		=> esc_html__( 'Custom Icon', 'Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'rows'  		=>'2',
				'condition' => [
                    'icon_style' => '2'
                ]
			]
		);


		$repeater->add_control(
			'icon_image',
			[
				'label'			=> esc_html__( 'Add Image Icon','Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'icon_style' => '3'
                ]
			]
		);
		
		$this->add_control(
			'header_contact_info_list_two',
			[
				'label' 	=> esc_html__( 'Contact Info List Two', 'Consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
				'prevent_empty' =>false,
				'default' 	=> [
					[
						'list_title' => esc_html__( 'Add Contact Info', 'Consua-core' ),
					],
				],
				'title_field' => '{{{ info }}}',
				'condition' => [
                    'style' => ['4']
                ]
			]
		);

		$this->add_control(
			'button_label',
			[
				'label' 	=> __( 'Button Label', 'consua' ),
                'type' 		=>  \Elementor\Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( 'Button Label', 'consua' ),
                'condition' => [
                    'style' => ['1','3','5','6','7']
                ]
			]
        );

        $this->add_control(
			'button_link',
			[
				'label' 		=> __( 'Link', 'consua' ),
				'type' 			=>  \Elementor\Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'consua' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
				'condition' => [
                    'style' => ['1','3','5','6','7']
                ]
			]
		);



		$this->end_controls_section();

		$this->start_controls_section(
			'consua_side_menu_style',
			[
				'label'		=> esc_html__( 'Sidemenu Style','Consua-core' ),
				'tab'		=> \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
                    'style' => ['4']
                ]
			]
		);

		$this->add_control(
			'sidemenu_position',
			[
				'label' => __( 'Sidemenu Show/Hide', 'Consua-core' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'Consua-core' ),
				'label_off' => __( 'Hide', 'Consua-core' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'sidemenu_logo',
			[
				'label'			=> esc_html__( 'Sidemenu Logo','Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'sidemenu_position' => 'yes'
                ]
			]
		);
		$this->add_control(
			'sidemenu_content', [
				'label' 		=> esc_html__( 'Content', 'Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'condition' => [
                    'sidemenu_position' => 'yes'
                ]
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'rows' 			=>'2'
			]
		);

		$repeater->add_control(
			'content', [
				'label' 		=> esc_html__( 'Content', 'Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'rows' 			=>'3'
			]
		);

		
		$this->add_control(
			'sidemenu_info_list',
			[
				'label' 	=> esc_html__( 'Sidemanu Info List', 'Consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
				'default' 	=> [
					[
						'list_title' => esc_html__( 'Add Sidemanu Info', 'Consua-core' ),
					],
				],
				'prevent_empty' => false,
				'title_field' => '{{{ title }}}',
				'condition' => [
                    'sidemenu_position' => 'yes'
                ]
			]
		);

		$this->add_control(
			'newsletter_title',
			[
				'label'     => __( 'Newsletter Title', 'consua-core' ),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'default'   => __( 'Title', 'consua-core' )
			]
        );

		$this->add_control(
			'newsletter_placeholder',
			[
				'label'     => __( 'Newsletter Placeholder Text', 'consua-core' ),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'default'   => __( 'Newsletter Placeholder Text', 'consua-core' ),
			]
        );

		$social = new \Elementor\Repeater();

		$social->add_control(
			'icon_style',
			[
				'label' 	=> esc_html__( 'Icon Style', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Flaticon', 'consua-core' ),
					'3' 	=> esc_html__( 'Icon Image', 'consua-core' ),
					'2'  	=> esc_html__( 'Custom Icon', 'consua-core' ),
				],
			]
		);

		$social->add_control(
			'flat_icon',
			[
                'label'      => esc_html__('Icon One', 'cleanu-core'),
                'type'       => \Elementor\Controls_Manager::ICON,
                'options'    => consua_flaticons(),
                'include'    => consua_include_flaticons(),
                'default'    => 'flaticon-budget',
                'condition' => [
                    'icon_style' => '1'
                ]
            ]
		);

		$social->add_control(
			'custom_icon', [
				'label' 		=> esc_html__( 'Custom Icon', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'label_block' 	=> true,
				'condition' => [
                    'icon_style' => '2'
                ]
			]
		);


		$social->add_control(
			'icon_image',
			[
				'label'			=> esc_html__( 'Add Image Icon','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'icon_style' => '3'
                ]
			]
		);

		$social->add_control(
		    'url',
		    [
		        'label' => __('Add Url', 'apsro-addon'),
		        'type' => \Elementor\Controls_Manager::URL,
		        'placeholder' => __('#', 'apsro-addon'),
		        'show_external' => false,
		        'default' => [
		            'url' => '#',
		            'is_external' => false,
		            'nofollow' => false,
		        ],
		        'show_label' => false,
		    ]
		);

		$this->add_control(
		    'sidemenu_social_list',
		    [
		        'label' => __('Social List', 'apsro-addon'),
		        'type' => \Elementor\Controls_Manager::REPEATER,
		        'fields' => $social->get_controls(),
		        'prevent_empty' => false,
		        'default' => [
		            [
		                'social_url' => [
		                    'url' => '#',
		                    'is_external' => false,
		                    'nofollow' => false,
		                ],
		            ],
		        ],

		    ]
		);
		
		$this->end_controls_section();

		$this->start_controls_section(
			'consua_header_style_section',
			[
				'label' 	=> __( 'Header Style', 'appku' ),
				'tab' 		=> \Elementor\Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
			'ag_header_icon_color',
			[
				'label' 		=> __( 'Header Menu Icon Color', 'appku' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .navbar.validnavs.navbar-common .attr-right .attr-nav li .call i' => 'color: {{VALUE}}!important;',
                ],
			]
        );

        $this->end_controls_section();

	}
	// Output For User
	protected function render(){	
	$consua_header_output = $this->get_settings_for_display();
	if($consua_header_output['style'] == '1'):
	?>
	<!-- Header Style One
    ============================================= -->

    <div class="top-bar-area top-bar-style-one bg-dark text-light">
        <div class="container">
            <div class="row align-center">
                <div class="col-xl-6 col-lg-8 offset-xl-3 pl-30 pl-md-15 pl-xs-15">

                    <ul class="item-flex">
						<?php foreach($consua_header_output['header_contact_info_list'] as $single_header_con_info): ?>
	                        <li>
	                          	<?php if(!empty($single_header_con_info['flat_icon'])):?>
			                        <i class="<?php echo esc_attr($single_header_con_info['flat_icon']); ?>"></i>
			                    <?php endif;?>
			                    <?php if(!empty($single_header_con_info['icon_image'])):?>
			                        <img src="<?php echo esc_url($single_header_con_info['icon_image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
			                    <?php endif;?>
			                    <?php 
			                    if(!empty($single_header_con_info['custom_icon'])):?>
			                        <i class="<?php echo esc_attr($single_header_con_info['custom_icon']); ?>"></i><?php endif; ?><?php echo wp_kses($single_header_con_info['info'], 'consua_allowed_tags'); ?>
	                        </li>
	                    <?php endforeach;?>
                    </ul>

                </div>
                <?php if(!empty($consua_header_output['social_list'])):?>
	                <div class="col-xl-3 col-lg-4 text-end">
	                    <div class="social">
	                        <ul>
								<?php 
					            	foreach ($consua_header_output['social_list'] as $single_item):
					            ?>
		                            <li>
		                                <a href="<?php echo esc_url($single_item['url']['url']);?>">
		                                   <?php if(!empty($single_item['flat_icon'])):?>
						                    <i class="<?php echo esc_attr($single_item['flat_icon']); ?>"></i>
						                    <?php endif;?>
						                    <?php if(!empty($single_item['icon_image']['url'])):?>
						                        <img src="<?php echo esc_url($single_item['icon_image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
						                    <?php endif;?>
						                    <?php 
						                    	if(!empty($single_item['custom_icon'])):?>
						                        <i class="<?php echo esc_attr($single_item['custom_icon']); ?>"></i>
						                    <?php endif;?>
		                                </a>
		                            </li>
	                           <?php endforeach;?>
	                        </ul>
	                    </div>
	                </div>
            	<?php endif;?>
            </div>
        </div>
    </div>
    <!-- End Header Top -->

    <header>
        <!-- Start Navigation -->
        <nav class="navbar mobile-sidenav navbar-style-one navbar-sticky navbar-default validnavs white navbar-fixed no-background">

            <div class="container">
                <div class="row align-center">

                    <!-- Start Header Navigation -->
                    <div class="col-xl-2 col-lg-3 col-md-2 col-sm-1 col-1">
                        <div class="navbar-header">
                            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#navbar-menu">
                                <i class="fa fa-bars"></i>
                            </button>
                            <?php if(!empty($consua_header_output['header_logo_desktop']['url'])):?>	
		                        <a class="navbar-brand" href="<?php echo esc_url(home_url());?>"><img src="<?php echo esc_url($consua_header_output['header_logo_desktop']['url']);?>" class="logo" alt="<?php echo get_bloginfo( 'name' ); ?>"></a>
		                    <?php endif;?>
                        </div>
                    </div>
                    <!-- End Header Navigation -->

                    <!-- Collect the nav links, forms, and other content for toggling -->
                    <div class="col-xl-6 offset-xl-1 col-lg-6 col-md-4 col-sm-4 col-4">
                        <div class="collapse navbar-collapse" id="navbar-menu">

 							<?php if(!empty($consua_header_output['header_logo_mobile']['url'])):?>
                            	<img src="<?php echo esc_url($consua_header_output['header_logo_mobile']['url']);?>" alt="?php echo get_bloginfo( 'name' ); ?>">
                             <?php endif;?>
                            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#navbar-menu">
                                <i class="fa fa-times"></i>
                            </button>
                            <?php
								wp_nav_menu(
									array(
										'menu' => $consua_header_output['nav_menu'],
										'menu_class'      => 'nav navbar-nav navbar-center',
			                            'fallback_cb'     => 'Consua_Bootstrap_Navwalker::fallback',
			                            'walker'          => new Consua_Bootstrap_Navwalker(),
			                            'items_wrap'      => '<ul data-in="fadeInDown" data-out="fadeOutUp" class="%2$s" id="%1$s">%3$s</ul>'));
							?>

                        </div>
                    </div>
                    <!-- /.navbar-collapse -->

                    <?php if(!empty($consua_header_output['button_link']['url'])):?>
	                    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-7 col-7">
	                        <div class="attr-right">
	                            <!-- Start Atribute Navigation -->
	                            <div class="attr-nav">
	                                <ul>
	                                    <li class="button">
	                                        <a href="<?php echo esc_url($consua_header_output['button_link']['url']);?>"><?php echo esc_html($consua_header_output['button_label']);?></a>
	                                    </li>
	                                </ul>
	                            </div>
	                            <!-- End Atribute Navigation -->
	        
	                        </div>
	                    </div>
                	<?php endif;?>

                </div>         
                <!-- Main Nav -->

                <!-- Overlay screen for menu -->
                <div class="overlay-screen"></div>
                <!-- End Overlay screen for menu -->
            </div>   
        </nav>
        <!-- End Navigation -->
    </header>

    <!-- End Header Style One -->

	<?php elseif($consua_header_output['style'] == '2'):?>

	<!-- Header Style Two 
    ============================================= -->
    <header>
        <!-- Start Navigation -->
        <nav class="navbar mobile-sidenav navbar-sticky navbar-default validnavs navbar-fixed dark  no-background">

            <div class="container d-flex justify-content-between align-items-center">            
                

                <!-- Start Header Navigation -->
                <div class="navbar-header">
                    <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#navbar-menu">
                        <i class="fa fa-bars"></i>
                    </button>
                    <?php if(!empty($consua_header_output['header_logo_desktop']['url'])):?>	
                        <a class="navbar-brand" href="<?php echo esc_url(home_url());?>"><img src="<?php echo esc_url($consua_header_output['header_logo_desktop']['url']);?>" class="logo" alt="<?php echo get_bloginfo( 'name' ); ?>"></a>
                    <?php endif;?>
                </div>
                <!-- End Header Navigation -->

                <!-- Collect the nav links, forms, and other content for toggling -->
                <div class="collapse navbar-collapse" id="navbar-menu">

                    <div class="collapse-header">
                        <?php
                   		 	if(!empty($consua_header_output['header_logo_mobile']['url'])):?>
                        	<img src="<?php echo esc_url($consua_header_output['header_logo_mobile']['url']);?>" alt="?php echo get_bloginfo( 'name' ); ?>">
                        <?php endif;?>
                        <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#navbar-menu">
                            <i class="fa fa-times"></i>
                        </button>
                    </div>
                    
                    <?php
						wp_nav_menu(
							array(
								'menu' => $consua_header_output['nav_menu'],
								'menu_class'      => 'nav navbar-nav navbar-center',
	                            'fallback_cb'     => 'Consua_Bootstrap_Navwalker::fallback',
	                            'walker'          => new Consua_Bootstrap_Navwalker(),
	                            'items_wrap'      => '<ul data-in="fadeInDown" data-out="fadeOutUp" class="%2$s" id="%1$s">%3$s</ul>'));
					?>
                </div><!-- /.navbar-collapse -->

                <?php if(!empty($consua_header_output['header_contact_info_list'])):?>
	                <div class="attr-right">
	                    <!-- Start Atribute Navigation -->
	                    <div class="attr-nav">
	                        <ul>
								<?php foreach($consua_header_output['header_contact_info_list'] as $single_header_con_info): ?>
		                            <li class="contact">
		                                <div class="call">
		                                    <div class="icon">
		                                        <?php if(!empty($single_header_con_info['flat_icon'])):?>
							                        <i class="<?php echo esc_attr($single_header_con_info['flat_icon']); ?>"></i>
							                    <?php endif;?>
							                    <?php if(!empty($single_header_con_info['icon_image'])):?>
							                        <img src="<?php echo esc_url($single_header_con_info['icon_image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
							                    <?php endif;?>
							                    <?php 
							                    if(!empty($single_header_con_info['custom_icon'])):?>
							                        <i class="<?php echo esc_attr($single_header_con_info['custom_icon']); ?>"></i>
										        <?php endif; ?>
		                                    </div>
		                                    <div class="info">
		                                        <?php echo wp_kses($single_header_con_info['info'], 'consua_allowed_tags'); ?>
		                                    </div>
		                                </div>
		                            </li>
		                        <?php endforeach;?>

	                        </ul>
	                    </div>
	                    <!-- End Atribute Navigation -->
	                </div>
            	<?php endif;?>

            </div>   
            <!-- Overlay screen for menu -->
            <div class="overlay-screen"></div>
            <!-- End Overlay screen for menu -->
        </nav>
        <!-- End Navigation -->
    </header>
    <!-- End Header Style Two -->

    <?php elseif($consua_header_output['style'] == '3'):?>

    <!-- Header Style Three
    ============================================= -->
    <header>
        <!-- Start Navigation -->
        <nav class="navbar secondary mobile-sidenav navbar-sticky navbar-default validnavs navbar-fixed white no-background">

            <div class="container d-flex justify-content-between align-items-center">            
                <!-- Start Header Navigation -->
                <div class="navbar-header">
                    <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#navbar-menu">
                        <i class="fa fa-bars"></i>
                    </button>	
                    <a class="navbar-brand" href="<?php echo esc_url(home_url());?>">
                    	<img src="<?php echo esc_url($consua_header_output['header_logo_desktop']['url']);?>" class="logo logo-display" alt="<?php echo get_bloginfo( 'name' ); ?>">
                    	<img src="<?php echo esc_url($consua_header_output['header_logo_scroll']['url']);?>" class="logo logo-scrolled" alt="<?php echo get_bloginfo( 'name' ); ?>">
                    </a>
                </div>
                <!-- End Header Navigation -->

                <!-- Collect the nav links, forms, and other content for toggling -->
                <div class="collapse navbar-collapse" id="navbar-menu">

                    <div class="collapse-header">
                 		<?php if(!empty($consua_header_output['header_logo_mobile']['url'])):?>
	                    	<img src="<?php echo esc_url($consua_header_output['header_logo_mobile']['url']);?>" alt="?php echo get_bloginfo( 'name' ); ?>">
	                    <?php endif;?>
                        <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#navbar-menu">
                            <i class="fa fa-times"></i>
                        </button>
                    </div>
                    
                    <?php
						wp_nav_menu(
							array(
								'menu' => $consua_header_output['nav_menu'],
								'menu_class'      => 'nav navbar-nav navbar-center',
	                            'fallback_cb'     => 'Consua_Bootstrap_Navwalker::fallback',
	                            'walker'          => new Consua_Bootstrap_Navwalker(),
	                            'items_wrap'      => '<ul data-in="fadeInDown" data-out="fadeOutUp" class="%2$s" id="%1$s">%3$s</ul>'));
					?>

                </div><!-- /.navbar-collapse -->

	 			<?php if(!empty($consua_header_output['button_link']['url'])):?>
	                <div class="attr-right">
	                    <!-- Start Atribute Navigation -->
	                    <div class="attr-nav">
	                        <ul>
	                            <li class="button light">
	                                <a href="<?php echo esc_url($consua_header_output['button_link']['url']);?>"><?php echo esc_html($consua_header_output['button_label']);?></a>
	                            </li>
	                        </ul>
	                    </div>
	                    <!-- End Atribute Navigation -->
	                </div>
	            <?php endif;?>

            </div>   
            <!-- Overlay screen for menu -->
            <div class="overlay-screen"></div>
            <!-- End Overlay screen for menu -->
        </nav>
        <!-- End Navigation -->
    </header>
    <!-- End Header Style Three -->

    <?php elseif($consua_header_output['style'] == '4'):?>

    <!-- Start Header Four 
    ============================================= -->
    <div class="top-bar-area top-bar-style-two">
        <div class="container">
            <div class="row align-center">
                <div class="col-lg-8">
                    <ul class="item-flex">
                    	<?php foreach($consua_header_output['header_contact_info_list'] as $single_header_con_info): ?>
	                        <li>
	                            <div class="icon">
	                           	<?php if(!empty($single_header_con_info['flat_icon'])):?>
			                        <i class="<?php echo esc_attr($single_header_con_info['flat_icon']); ?>"></i>
			                    <?php endif;?>
			                    <?php if(!empty($single_header_con_info['icon_image'])):?>
			                        <img src="<?php echo esc_url($single_header_con_info['icon_image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
			                    <?php endif;?>
			                    <?php 
			                    if(!empty($single_header_con_info['custom_icon'])):?>
			                        <i class="<?php echo esc_attr($single_header_con_info['custom_icon']); ?>"></i>
						        <?php endif; ?>
	                            </div> 
	                            <div class="info">
	                               <?php echo wp_kses($single_header_con_info['info'], 'consua_allowed_tags'); ?>
	                            </div>
	                        </li>
                    	<?php endforeach;?>
                       
                    </ul>
                </div>
                <div class="col-lg-4 text-end">
                	<?php foreach($consua_header_output['header_contact_info_list_two'] as $single_header_con_info): ?>
	                    <div class="call-entry">
	                        <div class="icon">
	                           <?php if(!empty($single_header_con_info['flat_icon'])):?>
			                        <i class="<?php echo esc_attr($single_header_con_info['flat_icon']); ?>"></i>
			                    <?php endif;?>
			                    <?php if(!empty($single_header_con_info['icon_image'])):?>
			                        <img src="<?php echo esc_url($single_header_con_info['icon_image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
			                    <?php endif;?>
			                    <?php 
			                    if(!empty($single_header_con_info['custom_icon'])):?>
			                        <i class="<?php echo esc_attr($single_header_con_info['custom_icon']); ?>"></i>
						        <?php endif; ?>
	                        </div>
	                        <div class="info">
	                            <?php echo wp_kses($single_header_con_info['info'], 'consua_allowed_tags'); ?>
	                        </div>
	                    </div>
                    <?php endforeach;?>
                </div>
            </div>
        </div>
    </div>

     <!-- Header 
    ============================================= -->
    <header>
        <!-- Start Navigation -->
        <nav class="navbar mobile-sidenav navbar-theme-secodnary navbar-common navbar-sticky navbar-default validnavs">

            <!-- Start Top Search -->
            <div class="top-search">
                <div class="container-xl">
                	<form role="search" method="get" action="<?php echo esc_url(home_url('/')); ?>">
	                    <div class="input-group">
	                        <span class="input-group-addon"><i class="fa fa-search"></i></span>
	                        <input type="search" name="s" id="search" value="<?php echo esc_attr(get_search_query()); ?>" class="form-control" placeholder="Search">
	                        <span class="input-group-addon close-search"><i class="fa fa-times"></i></span>
	                    </div>
                	</form>
                </div>
            </div>
            <!-- End Top Search -->

            <div class="container nav-box d-flex justify-content-between align-items-center">            

                <!-- Start Header Navigation -->
                <div class="navbar-header">
                    <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#navbar-menu">
                        <i class="fa fa-bars"></i>
                    </button>
                    <a class="navbar-brand" href="<?php echo esc_url(home_url());?>">
                    	<img src="<?php echo esc_url($consua_header_output['header_logo_desktop']['url']);?>" class="logo logo-display" alt="<?php echo get_bloginfo( 'name' ); ?>">
                    	<img src="<?php echo esc_url($consua_header_output['header_logo_scroll']['url']);?>" class="logo logo-scrolled" alt="<?php echo get_bloginfo( 'name' ); ?>">
                    </a>
                </div>
                <!-- End Header Navigation -->

                <!-- Main Nav -->
                <div class="main-nav-content">
                    <!-- Collect the nav links, forms, and other content for toggling -->
                    <div class="collapse navbar-collapse" id="navbar-menu">

                        <?php if(!empty($consua_header_output['header_logo_mobile']['url'])):?>
	                    	<img src="<?php echo esc_url($consua_header_output['header_logo_mobile']['url']);?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
	                    <?php endif;?>
                        <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#navbar-menu">
                            <i class="fa fa-times"></i>
                        </button>
                        
                        <?php
							wp_nav_menu(
								array(
									'menu' => $consua_header_output['nav_menu'],
									'menu_class'      => 'nav navbar-nav navbar-right',
		                            'fallback_cb'     => 'Consua_Bootstrap_Navwalker::fallback',
		                            'walker'          => new Consua_Bootstrap_Navwalker(),
		                            'items_wrap'      => '<ul data-in="fadeInDown" data-out="fadeOutUp" class="%2$s" id="%1$s">%3$s</ul>'));
						?>


                    </div><!-- /.navbar-collapse -->

                    <div class="attr-right">
                        <!-- Start Atribute Navigation -->
                        <div class="attr-nav attr-box">
                            <ul>
                                <li class="search"><a href="#"><i class="far fa-search"></i></a></li>
                                <li class="side-menu">
                                <a href="#">
                                    <span class="bar-1"></span>
                                    <span class="bar-2"></span>
                                    <span class="bar-3"></span>
                                </a>
                            </li>
                            </ul>
                        </div>
                        <!-- End Atribute Navigation -->
                    </div>

					<?php

					if('yes' == $consua_header_output['sidemenu_position']):?>
	                    <!-- Start Side Menu -->
	                    <div class="side">
	                        <a href="#" class="close-side"><i class="icon_close"></i></a>
	                        <div class="widget">
	                        	<?php if(!empty($consua_header_output['sidemenu_logo']['url'])):?>
		                            <div class="logo">
		                                <img src="<?php echo esc_url($consua_header_output['sidemenu_logo']['url']);?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
		                            </div>
	                        	<?php endif;?>
	                        	<?php if(!empty($consua_header_output['sidemenu_content'])):?>
		                            <p>
		                                <?php echo wp_kses($consua_header_output['sidemenu_content'], 'consua_allowed_tags'); ?>
		                            </p>
	                            
	                            <?php endif;?>
	                        </div>
	                        <?php if(!empty($consua_header_output['sidemenu_info_list'])):?>
		                        <div class="widget address">
		                            <div>
		                                <ul>
		 									<?php 
								            	foreach ($consua_header_output['sidemenu_info_list'] as $single_item):
								            ?>
		                                    <li>
		                                        <div class="content">
		                                            <p><?php echo wp_kses($single_item['title'], 'consua_allowed_tags'); ?></p> 
		                                            <strong><?php echo wp_kses($single_item['content'], 'consua_allowed_tags'); ?></strong>
		                                        </div>
		                                    </li>
		                                    <?php endforeach;?>
		                                </ul>
		                            </div>
		                        </div>
	                        <?php endif;?>
	                        <div class="widget newsletter">
	                            <h4 class="title"><?php echo esc_html($consua_header_output['newsletter_title']);?></h4>
	                            <form class="newsletter-form">
	                                <div class="input-group stylish-input-group">
	                                    <input type="email" placeholder="<?php echo esc_attr($consua_header_output['newsletter_placeholder']);?>" class="form-control" name="email">
	                                    <span class="input-group-addon">
	                                        <button type="submit">
	                                            <i class="arrow_right"></i>
	                                        </button>  
	                                    </span>
	                                </div>
	                            </form>
	                        </div>
	                        <?php if(!empty($consua_header_output['sidemenu_social_list'])):?>
		                        <div class="widget social">
		                            <ul class="link">
		                                <?php 
							            	foreach ($consua_header_output['sidemenu_social_list'] as $single_item):
							            ?>
								            <li>
								                <a href="<?php echo esc_url($single_item['url']['url']);?>">
								                   <?php if(!empty($single_item['flat_icon'])):?>
								                    <i class="<?php echo esc_attr($single_item['flat_icon']); ?>"></i>
								                    <?php endif;?>
								                    <?php if(!empty($single_item['icon_image']['url'])):?>
								                        <img src="<?php echo esc_url($single_item['icon_image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
								                    <?php endif;?>
								                    <?php 
								                    	if(!empty($single_item['custom_icon'])):?>
								                        <i class="<?php echo esc_attr($single_item['custom_icon']); ?>"></i>
								                    <?php endif;?>
								                </a>
								            </li>
							        	<?php endforeach;?>
		                            </ul>
		                        </div>
	                    	<?php endif;?>

	                    </div>
	                    <!-- End Side Menu -->
                    <?php endif;?>

                    <!-- Overlay screen for menu -->
                    <div class="overlay-screen"></div>
                    <!-- End Overlay screen for menu -->

                </div>
                <!-- Main Nav -->

            </div>   
            <!-- Overlay screen for menu -->
            <div class="overlay-screen"></div>
            <!-- End Overlay screen for menu -->
        </nav>
        <!-- End Navigation -->
    </header>
    <!-- End Header -->

    <!-- End Header Four -->

    <?php elseif($consua_header_output['style'] == '5'):?>

    <!-- Start Header  
    ============================================= -->
    <div class="top-bar-area top-bar-style-three text-light">
        <div class="container">
            <div class="row align-center">
            	<?php if(!empty($consua_header_output['header_contact_info_list'])):?>
	                <div class="col-lg-7">

	                    <ul class="item-flex">
	                    	<?php foreach($consua_header_output['header_contact_info_list'] as $single_header_con_info): ?>
		                        <li>
		                            <?php if(!empty($single_header_con_info['flat_icon'])):?>
				                        <i class="<?php echo esc_attr($single_header_con_info['flat_icon']); ?>"></i>
				                    <?php endif;?>
				                    <?php if(!empty($single_header_con_info['icon_image'])):?>
				                        <img src="<?php echo esc_url($single_header_con_info['icon_image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
				                    <?php endif;?>
				                    <?php 
				                    if(!empty($single_header_con_info['custom_icon'])):?>
				                        <i class="<?php echo esc_attr($single_header_con_info['custom_icon']); ?>"></i>
							        <?php endif; ?><?php echo wp_kses($single_header_con_info['info'], 'consua_allowed_tags'); ?>
		                        </li>
	                    	<?php endforeach;?>
	                    </ul>

	                </div>
                <?php endif;?> 

                <?php if(!empty($consua_header_output['social_list'])):?>
	                <div class="col-lg-5 text-end">
	                    <div class="social">
	                        <ul>
	                            <?php 
					            	foreach ($consua_header_output['social_list'] as $single_item):
					            ?>
		                            <li>
		                                <a href="<?php echo esc_url($single_item['url']['url']);?>">
		                                   <?php if(!empty($single_item['flat_icon'])):?>
						                    <i class="<?php echo esc_attr($single_item['flat_icon']); ?>"></i>
						                    <?php endif;?>
						                    <?php if(!empty($single_item['icon_image']['url'])):?>
						                        <img src="<?php echo esc_url($single_item['icon_image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
						                    <?php endif;?>
						                    <?php 
						                    	if(!empty($single_item['custom_icon'])):?>
						                        <i class="<?php echo esc_attr($single_item['custom_icon']); ?>"></i>
						                    <?php endif;?>
		                                </a>
		                            </li>
	                           	<?php endforeach;?>
	                        </ul>
	                    </div>
	                </div>
	            <?php endif;?>    
            </div>
        </div>
    </div>
    <!-- End Header Top -->

    <!-- Header 
    ============================================= -->
    <header>
        <!-- Start Navigation -->
        <nav class="navbar mobile-sidenav navbar-style-three navbar-sticky navbar-default validnavs navbar-fixed white no-background">


            <div class="container d-flex justify-content-between align-items-center">            

                <!-- Start Header Navigation -->
                <div class="navbar-header">
                    <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#navbar-menu">
                        <i class="fa fa-bars"></i>
                    </button>
	
                    <a class="navbar-brand" href="<?php echo esc_url(home_url());?>">
                    	<?php if(!empty($consua_header_output['header_logo_desktop']['url'])):?>
                        	<img src="<?php echo esc_url($consua_header_output['header_logo_desktop']['url']);?>" class="logo logo-display" alt="<?php echo get_bloginfo( 'name' ); ?>">
                        <?php endif;?>
                        <?php if(!empty($consua_header_output['header_logo_scroll']['url'])):?>
                    		<img src="<?php echo esc_url($consua_header_output['header_logo_scroll']['url']);?>" class="logo logo-scrolled" alt="<?php echo get_bloginfo( 'name' ); ?>">
                    	<?php endif;?>
                    </a>
                </div>
                <!-- End Header Navigation -->

                <div class="navbar-right-part">
                    <!-- Collect the nav links, forms, and other content for toggling -->
                    <div class="collapse navbar-collapse" id="navbar-menu">

                       	<?php if(!empty($consua_header_output['header_logo_mobile']['url'])):?>
                        	<img src="<?php echo esc_url($consua_header_output['header_logo_mobile']['url']);?>" alt="?php echo get_bloginfo( 'name' ); ?>">
                        <?php endif;?>
                        <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#navbar-menu">
                            <i class="fa fa-times"></i>
                        </button>
                        
                        <?php
						wp_nav_menu(
							array(
								'menu' => $consua_header_output['nav_menu'],
								'menu_class'      => 'nav navbar-nav navbar-right',
	                            'fallback_cb'     => 'Consua_Bootstrap_Navwalker::fallback',
	                            'walker'          => new Consua_Bootstrap_Navwalker(),
	                            'items_wrap'      => '<ul data-in="fadeInDown" data-out="fadeOutUp" class="%2$s" id="%1$s">%3$s</ul>'));
						?>

                    </div><!-- /.navbar-collapse -->

                    <?php if(!empty($consua_header_output['button_link']['url'])):?>
	                    <div class="attr-right">
	                        <!-- Start Atribute Navigation -->
	                        <div class="attr-nav">
	                            <ul>
	                            	<li class="button">
	                                	<a href="<?php echo esc_url($consua_header_output['button_link']['url']);?>"><?php echo esc_html($consua_header_output['button_label']);?></a>
	                            	</li>
	                            </ul>
	                        </div>
	                        <!-- End Atribute Navigation -->
	                    </div>
	                    <!-- Main Nav -->
	                <?php endif;?>     
                </div>

            </div>   
            <!-- Overlay screen for menu -->
            <div class="overlay-screen"></div>
            <!-- End Overlay screen for menu -->
        </nav>
        <!-- End Navigation -->
    </header>
    <!-- End Header Five -->

	<?php elseif($consua_header_output['style'] == '6'):?>

	<!-- Header Six
    ============================================= -->
    <header>
        <!-- Start Navigation -->
        <nav class="navbar secondary mobile-sidenav navbar-sticky navbar-default validnavs navbar-fixed white no-background">

            <div class="container d-flex justify-content-between align-items-center">            
                

                <!-- Start Header Navigation -->
                <div class="navbar-header">
                    <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#navbar-menu">
                        <i class="fa fa-bars"></i>
                    </button>
                    <a class="navbar-brand" href="<?php echo esc_url(home_url());?>">
                    	<?php if(!empty($consua_header_output['header_logo_desktop']['url'])):?>
                        	<img src="<?php echo esc_url($consua_header_output['header_logo_desktop']['url']);?>" class="logo logo-display" alt="<?php echo get_bloginfo( 'name' ); ?>">
                        <?php endif;?>
                        <?php if(!empty($consua_header_output['header_logo_scroll']['url'])):?>
                    		<img src="<?php echo esc_url($consua_header_output['header_logo_scroll']['url']);?>" class="logo logo-scrolled" alt="<?php echo get_bloginfo( 'name' ); ?>">
                    	<?php endif;?>
                    </a>
                </div>
                <!-- End Header Navigation -->

                <!-- Collect the nav links, forms, and other content for toggling -->
                <div class="collapse navbar-collapse" id="navbar-menu">

                    <div class="collapse-header">
                       	<?php if(!empty($consua_header_output['header_logo_mobile']['url'])):?>
                        	<img src="<?php echo esc_url($consua_header_output['header_logo_mobile']['url']);?>" alt="?php echo get_bloginfo( 'name' ); ?>">
                        <?php endif;?>
                        <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#navbar-menu">
                            <i class="fa fa-times"></i>
                        </button>
                    </div>
                    
                    <?php
					wp_nav_menu(
						array(
							'menu' => $consua_header_output['nav_menu'],
							'menu_class'      => 'nav navbar-nav navbar-center',
                            'fallback_cb'     => 'Consua_Bootstrap_Navwalker::fallback',
                            'walker'          => new Consua_Bootstrap_Navwalker(),
                            'items_wrap'      => '<ul data-in="fadeInDown" data-out="fadeOutUp" class="%2$s" id="%1$s">%3$s</ul>'));
					?>

                </div><!-- /.navbar-collapse -->

                <?php if(!empty($consua_header_output['button_link']['url'])):?>
	                <div class="attr-right">
	                    <!-- Start Atribute Navigation -->
	                    <div class="attr-nav">
	                        <ul>
	                            <li class="button">
	                              <a href="<?php echo esc_url($consua_header_output['button_link']['url']);?>"><?php echo esc_html($consua_header_output['button_label']);?></a>
	                            </li>
	                        </ul>
	                    </div>
	                    <!-- End Atribute Navigation -->
	                </div>
            	<?php endif;?>

            </div>   
            <!-- Overlay screen for menu -->
            <div class="overlay-screen"></div>
            <!-- End Overlay screen for menu -->
        </nav>
        <!-- End Navigation -->
    </header>
    <!-- End Header Six -->

	<?php elseif($consua_header_output['style'] == '7'):?>

	<!-- Start Header Seven
    ============================================= -->
    <div class="top-bar-area top-bar-style-one bg-dark text-light">
        <div class="container">
            <div class="row align-center">
            	<?php if(!empty($consua_header_output['header_contact_info_list'])):?>
	                <div class="col-lg-7">
	                    <ul class="item-flex">
	                        <?php foreach($consua_header_output['header_contact_info_list'] as $single_header_con_info): ?>
		                        <li>
		                            <?php if(!empty($single_header_con_info['flat_icon'])):?>
				                        <i class="<?php echo esc_attr($single_header_con_info['flat_icon']); ?>"></i>
				                    <?php endif;?>
				                    <?php if(!empty($single_header_con_info['icon_image'])):?>
				                        <img src="<?php echo esc_url($single_header_con_info['icon_image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
				                    <?php endif;?>
				                    <?php 
				                    if(!empty($single_header_con_info['custom_icon'])):?>
				                        <i class="<?php echo esc_attr($single_header_con_info['custom_icon']); ?>"></i>
							        <?php endif; ?><?php echo wp_kses($single_header_con_info['info'], 'consua_allowed_tags'); ?>
		                        </li>
	                    	<?php endforeach;?>
	                    </ul>
	                </div>
	            <?php endif;?>
	            <?php if(!empty($consua_header_output['social_list'])):?>
	                <div class="col-lg-5 text-end">
	                    <div class="social">
	                        <ul>
	                           <?php 
						            foreach ($consua_header_output['social_list'] as $single_item):
						            ?>
		                            <li>
		                                <a href="<?php echo esc_url($single_item['url']['url']);?>">
		                                   <?php if(!empty($single_item['flat_icon'])):?>
						                    <i class="<?php echo esc_attr($single_item['flat_icon']); ?>"></i>
						                    <?php endif;?>
						                    <?php if(!empty($single_item['icon_image']['url'])):?>
						                        <img src="<?php echo esc_url($single_item['icon_image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
						                    <?php endif;?>
						                    <?php 
						                    	if(!empty($single_item['custom_icon'])):?>
						                        <i class="<?php echo esc_attr($single_item['custom_icon']); ?>"></i>
						                    <?php endif;?>
		                                </a>
		                            </li>
		                        <?php endforeach;?>
	                        </ul>
	                    </div>
	                </div>
                <?php endif;?>
            </div>
        </div>
    </div>
    <!-- End Header Top -->

    <!-- Header 
    ============================================= -->
    <header>
        <!-- Start Navigation -->
        <nav class="navbar mobile-sidenav navbar-common navbar-sticky navbar-default validnavs">


            <div class="container d-flex justify-content-between align-items-center">            

                <!-- Start Header Navigation -->
                <div class="navbar-header">
                    <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#navbar-menu">
                        <i class="fa fa-bars"></i>
                    </button>
                    <a class="navbar-brand" href="<?php echo esc_url(home_url());?>">
                        <?php if(!empty($consua_header_output['header_logo_desktop']['url'])):?>
                        	<img src="<?php echo esc_url($consua_header_output['header_logo_desktop']['url']);?>" class="logo" alt="<?php echo get_bloginfo( 'name' ); ?>">
                        <?php endif;?>
                    </a>
                </div>
                <!-- End Header Navigation -->

                <!-- Collect the nav links, forms, and other content for toggling -->
                <div class="collapse navbar-collapse" id="navbar-menu">

                    <?php if(!empty($consua_header_output['header_logo_mobile']['url'])):?>
                    	<img src="<?php echo esc_url($consua_header_output['header_logo_mobile']['url']);?>" alt="?php echo get_bloginfo( 'name' ); ?>">
                    <?php endif;?>
                    <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#navbar-menu">
                        <i class="fa fa-times"></i>
                    </button>
                    
                    <?php
					wp_nav_menu(
						array(
							'menu' => $consua_header_output['nav_menu'],
							'menu_class'      => 'nav navbar-nav navbar-right',
                            'fallback_cb'     => 'Consua_Bootstrap_Navwalker::fallback',
                            'walker'          => new Consua_Bootstrap_Navwalker(),
                            'items_wrap'      => '<ul data-in="fadeInDown" data-out="fadeOutUp" class="%2$s" id="%1$s">%3$s</ul>'));
					?>

                </div><!-- /.navbar-collapse -->

                <?php if(!empty($consua_header_output['button_link']['url'])):?>
	                <div class="attr-right">
	                    <!-- Start Atribute Navigation -->
	                    <div class="attr-nav">
	                        <ul>
	                        	<li class="button">
	                            	<a href="<?php echo esc_url($consua_header_output['button_link']['url']);?>"><?php echo esc_html($consua_header_output['button_label']);?></a>
	                        	</li>
	                        	<?php if ('yes' == $consua_header_output['wishlist_enable'] && class_exists('WooCommerce')) : ?>
    	                        	<li class="wishlist">
                                    	<?php
                                        	if( class_exists( 'TInvWL_Admin_TInvWL' ) ){
    		                                    echo do_shortcode( '[ti_wishlist_products_counter]' );
    		                                }
                                    	?>
    	                            </li>
	                            <?php endif; ?>
	                            <?php if ('yes' == $consua_header_output['cart_enable'] && class_exists('WooCommerce')) : ?>
                                	<li class="dropdown">
                                        <div class="basket-item-count">
    	                                    <span class="cart-items-count"> 
    	                                        <?php
    	                                        	if (is_admin()) return false;
    	                                         	WC()->cart->get_cart_contents_count(); 
    	                                        ?>
    	                                    </span>
                                        </div>
                                        <!-- End Atribute Navigation -->
                                        <div class="widget_shopping_cart_content">
                                           	<?php 
                                           		if (is_admin()) return false;
                                           		echo woocommerce_mini_cart();
                                           	?>
                                        </div>
                                    </li>
                                 <?php endif; ?>
	                        </ul>
	                    </div>
	                    <!-- End Atribute Navigation -->
	                </div>
                <?php endif;?> 
                <!-- Main Nav -->
            </div>   
            <!-- Overlay screen for menu -->
            <div class="overlay-screen"></div>
            <!-- End Overlay screen for menu -->
        </nav>
        <!-- End Navigation -->
    </header>
    <!-- End Header Seven -->

    <?php 	
	endif;
    }
}