<?php
	/**
	* Elementor Feature Widget.
	*
	* Elementor widget that inserts an embbedable content into the page, from any given URL.
	*
	* @since 1.0.0
	*/
class Elementor_Consua_Feature_Widget extends \Elementor\Widget_Base {

	/**
	* Get widget name.
	*
	* Retrieve Feature widget name.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget name.
	*/
	public function get_name() {
		return 'consua_feature';
	}

	/**
	* Get widget title.
	*
	* Retrieve Feature widget title.
	*
	* @since 1.0.0
	* @access public 
	*
	* @return string Widget title.
	*/
	public function get_title() {
		return esc_html__( 'Feature', 'consua-core' );
	}

	/**
	* Get widget icon.
	*
	* Retrieve Feature widget icon.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget icon.
	*/
	public function get_icon() {
		return 'eicon-code';
	}

	/**
	* Get widget categories.
	*
	* Retrieve the list of categories the Feature widget belongs to.
	*
	* @since 1.0.0
	* @access public
	*
	* @return array Widget categories.
	*/
	public function get_categories() {
		return [ 'consua_elements'];
	}

	public function get_script_depends() {
        return array('main');
    }

	// Add The Input For User
	protected function register_controls(){
		

		$this->start_controls_section(
			'feature_content',
			[
				'label'		=> esc_html__( 'Set Feature Content','consua-core' ),
				'tab'		=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'style',
			[
				'label' 	=> esc_html__( 'Style', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Style One', 'consua-core' ),
					'2'  	=> esc_html__( 'Style Two', 'consua-core' ),
					'3'  	=> esc_html__( 'Style Three', 'consua-core' ),
					'4'  	=> esc_html__( 'Style Four', 'consua-core' ),
					'5'  	=> esc_html__( 'Style Five', 'consua-core' ),
					'6'  	=> esc_html__( 'Style Six', 'consua-core' ),
				],
			]
		);


		$this->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'placeholder' 	=> esc_html__( 'Title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Title', 'consua-core' ),
				'condition' => [
                    'style' => ['1','5','6','2']
                ]
			]
		);

		$this->add_control(
			'subtitle', [
				'label' 		=> esc_html__( 'Sub-Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'placeholder' 	=> esc_html__( 'SubTitle', 'consua-core' ),
				'default' 		=> esc_html__( 'Default SubTitle', 'consua-core' ),
				'condition' => [
                   'style' => ['1','5','2']
                ]
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows' 			=> '1',
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'number', [
				'label' 		=> esc_html__( 'Number', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'label_block' 	=> true,
			]
		);

		$this->add_control(
			'funfact_list',
			[
				'label' 	=> esc_html__( 'Funfact List', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
				'default' 	=> [
					[
						'list_title' => esc_html__( 'Add Funfact', 'consua-core' ),
					],
				],
				'title_field' => '{{{ title }}}',
				'condition' => [
                    'style' => '1'
                ]
			]
		);

		$this->add_control(
			'feature_list_divider',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows' 			=> '2',
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'subtitle', [
				'label' 		=> esc_html__( 'Number', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
			]
		);

		$repeater->add_control(
			'icon_style',
			[
				'label' 	=> esc_html__( 'Icon Style', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Flaticon', 'consua-core' ),
					'3' 	=> esc_html__( 'Icon Image', 'consua-core' ),
					'2'  	=> esc_html__( 'Custom Icon', 'consua-core' ),
				],
			]
		);

		$repeater->add_control(
			'flat_icon',
			[
                'label'      => esc_html__('Icon One', 'consua-core'),
                'type'       => \Elementor\Controls_Manager::ICON,
                'options'    => consua_flaticons(),
                'include'    => consua_include_flaticons(),
                'default'    => 'flaticon-vegetables',
                'condition' => [
                    'icon_style' => '1'
                ]
            ]
		);

		$repeater->add_control(
			'custom_icon', [
				'label' 		=> esc_html__( 'Custom Icon', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'condition' => [
                    'icon_style' => '2'
                ]
			]
		);


		$repeater->add_control(
			'icon_image',
			[
				'label'			=> esc_html__( 'Add Image Icon','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'icon_style' => '3'
                ]
			]
		);
		
		$this->add_control(
			'feature_list',
			[
				'label' 	=> esc_html__( 'Feature List', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
				'default' 	=> [
					[
						'list_title' => esc_html__( 'Add Feature', 'consua-core' ),
					],
				],
				'title_field' => '{{{ title }}}',
				'condition' => [
                    'style' => '1'
                ]
			]
		);
		

		$style_two_feature_list = new \Elementor\Repeater();

		$style_two_feature_list->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows' 			=> '2',
				'placeholder' => __('Add title', 'ogency-addon'),
        		'default' => __('Default Title', 'ogency-addon'),
				'label_block' 	=> true,
			]
		);

		$style_two_feature_list->add_control(
			'summary', [
				'label' 		=> esc_html__( 'Summary', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add summary', 'ogency-addon'),
        		'default' => __('Default Summary', 'ogency-addon'),
				'label_block' 	=> true,
			]
		);

		$style_two_feature_list->add_control(
			'icon_image',
			[
				'label'			=> esc_html__( 'Add Image Icon','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);

		$style_two_feature_list->add_control(
			'url',
			[
				'label' 		=> esc_html__( 'URL', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'consua-core' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);
		
		$this->add_control(
			'style_two_feature_list',
			[
				'label' 	=> esc_html__( 'Feature List', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $style_two_feature_list->get_controls(),
				'default' 	=> [
					[
						'list_title' => esc_html__( 'Add Feature', 'consua-core' ),
					],
				],
				'title_field' => '{{{ title }}}',
				'prevent_empty' => false,
				'condition' => [
                    'style' => ['2','4']
                ]
			]
		);


		$style_three_feature_list = new \Elementor\Repeater();

		$style_three_feature_list->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows' 			=> '2',
				'placeholder' 	=> esc_html__( 'title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Title', 'consua-core' ),
				'label_block' 	=> true,
			]
		);
		$style_three_feature_list->add_control(
			'subtitle', [
				'label' 		=> esc_html__( 'Subtitle', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'subtitle', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Subtitle', 'consua-core' ),
				'label_block' 	=> true,
			]
		);

		$style_three_feature_list->add_control(
			'image',
			[
				'label'			=> esc_html__( 'Add Image','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' => [
		            'url' => \Elementor\Utils::get_placeholder_image_src(),
		        ],
			]
		);

		$style_three_feature_list->add_control(
			'icon_style',
			[
				'label' 	=> esc_html__( 'Icon Style', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Flaticon', 'consua-core' ),
					'3' 	=> esc_html__( 'Icon Image', 'consua-core' ),
					'2'  	=> esc_html__( 'Custom Icon', 'consua-core' ),
				],
			]
		);

		$style_three_feature_list->add_control(
			'flat_icon',
			[
                'label'      => esc_html__('Icon One', 'consua-core'),
                'type'       => \Elementor\Controls_Manager::ICON,
                'options'    => consua_flaticons(),
                'include'    => consua_include_flaticons(),
                'default'    => 'flaticon-vegetables',
                'condition' => [
                    'icon_style' => '1'
                ]
            ]
		);

		$style_three_feature_list->add_control(
			'custom_icon', [
				'label' 		=> esc_html__( 'Custom Icon', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'label_block' 	=> true,
				'condition' => [
                    'icon_style' => '2'
                ]
			]
		);


		$style_three_feature_list->add_control(
			'icon_image',
			[
				'label'			=> esc_html__( 'Add Image Icon','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'icon_style' => '3'
                ]
			]
		);
		
		$this->add_control(
			'style_three_feature_list',
			[
				'label' 	=> esc_html__( 'Feature List', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $style_three_feature_list->get_controls(),
				'prevent_empty' => false,
				'title_field' => '{{{ title }}}',
				'condition' => [
                    'style' => ['3']
                ]
			]
		);

		$style_five_feature_list = new \Elementor\Repeater();

		$style_five_feature_list->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows' 			=> '2',
				'placeholder' 	=> esc_html__( 'title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Title', 'consua-core' ),
				'label_block' 	=> true,
			]
		);
		$style_five_feature_list->add_control(
			'subtitle', [
				'label' 		=> esc_html__( 'Subtitle', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'subtitle', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Subtitle', 'consua-core' ),
				'label_block' 	=> true,
			]
		);

		$style_five_feature_list->add_control(
			'icon_image',
			[
				'label'			=> esc_html__( 'Add Image Icon','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' => [
		            'url' => \Elementor\Utils::get_placeholder_image_src(),
		        ],
			]
		);

	
		$this->add_control(
			'style_five_feature_list',
			[
				'label' 	=> esc_html__( 'Feature List', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $style_five_feature_list->get_controls(),
				'prevent_empty' => false,
				'title_field' => '{{{ title }}}',
				'condition' => [
                    'style' => '5'
                ]
			]
		);

		$style_six_feature_list = new \Elementor\Repeater();

		$style_six_feature_list->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows' 			=> '2',
				'placeholder' 	=> esc_html__( 'title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Title', 'consua-core' ),
				'label_block' 	=> true,
			]
		);
		$style_six_feature_list->add_control(
			'subtitle', [
				'label' 		=> esc_html__( 'Subtitle', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'subtitle', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Subtitle', 'consua-core' ),
				'label_block' 	=> true,
			]
		);

		$style_six_feature_list->add_control(
			'icon_style',
			[
				'label' 	=> esc_html__( 'Icon Style', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Flaticon', 'consua-core' ),
					'3' 	=> esc_html__( 'Icon Image', 'consua-core' ),
					'2'  	=> esc_html__( 'Custom Icon', 'consua-core' ),
				],
			]
		);

		$style_six_feature_list->add_control(
			'flat_icon',
			[
                'label'      => esc_html__('Icon One', 'consua-core'),
                'type'       => \Elementor\Controls_Manager::ICON,
                'options'    => consua_flaticons(),
                'include'    => consua_include_flaticons(),
                'default'    => 'flaticon-vegetables',
                'condition' => [
                    'icon_style' => '1'
                ]
            ]
		);

		$style_six_feature_list->add_control(
			'custom_icon', [
				'label' 		=> esc_html__( 'Custom Icon', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'label_block' 	=> true,
				'condition' => [
                    'icon_style' => '2'
                ]
			]
		);


		$style_six_feature_list->add_control(
			'icon_image',
			[
				'label'			=> esc_html__( 'Add Image Icon','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'icon_style' => '3'
                ]
			]
		);

		$style_six_feature_list->add_control(
			'url',
			[
				'label' 		=> esc_html__( 'URL', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'consua-core' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);
		
		$this->add_control(
			'style_six_feature_list',
			[
				'label' 	=> esc_html__( 'Feature List', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $style_six_feature_list->get_controls(),
				'prevent_empty' => false,
				'title_field' => '{{{ title }}}',
				'condition' => [
                    'style' => ['6']
                ]
			]
		);

		$this->add_control(
			'feature_shape_one',
			[
				'label' 	=> esc_html__( 'Background Shape One', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'style' => ['1','2']
                ]
			]
		);

		$this->add_control(
			'feature_shape_two',
			[
				'label' 	=> esc_html__( 'Background Shape Two', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'style' => '2'
                ]
			]
		);
		
		$this->end_controls_section();

		include CONSUA_PLUGIN_WIDGET_STYLE_PATH . 'feature-style.php';
	}

	// Output For User
	protected function render(){
	$consua_feature_output = $this->get_settings_for_display();
	$funfact_list = $consua_feature_output['funfact_list'];
	$feature_list = $consua_feature_output['feature_list'];
	$style_two_feature_list = $consua_feature_output['style_two_feature_list'];
	$style_three_feature_list = $consua_feature_output['style_three_feature_list'];
	$style_five_feature_list = $consua_feature_output['style_five_feature_list'];
	if($consua_feature_output['style'] == '1'):
	?>

    <!-- Start Our Features One
    ============================================= -->
    <div class="feature-style-one-area half-angle-shape overflow-hidden default-padding">
        <div class="container">
            <div class="row align-center">
                <!-- Single Itme -->
                <div class="col-lg-5">
                    <div class="feature-style-one-heading text-light">
                    	<?php if(!empty($consua_feature_output['feature_shape_one']['url'])):?>
	                        <div class="arrow-shape">
		                        <?php 
					            	echo consua_img_tag( array(
							            'url'   => esc_url( $consua_feature_output['feature_shape_one']['url'] )
							    	) );
					            ?>
	                        </div>
                    	<?php endif;?>
                        <h2 class="title mb-25"><?php echo esc_attr($consua_feature_output['title']);?></h2>
                        <p>
                           <?php echo esc_attr($consua_feature_output['subtitle']);?>
                        </p>

                        <div class="circle-progress">
							<?php 
		                    	foreach ($funfact_list as $single_funfact):
		                    ?>
	                            <div class="progressbar">
	                                <div class="circle" data-percent="<?php echo esc_html($single_funfact['number']);?>">
	                                    <strong></strong>
	                                </div>
	                                <h4><?php echo esc_attr($single_funfact['title']);?></h4>
	                            </div>
                            <?php
		                	    endforeach;
		                	?>
                        </div>

                    </div>
                </div>
                <!-- End Single Itme -->
                <div class="col-lg-6 offset-lg-1 pl-60 pl-md-15 pl-xs-10 mt-md-50 mt-xs-50">

					<?php 
                    	foreach ($feature_list as $single_feature):
                    ?>
	                <!-- Single Itme -->
                    <div class="feature-style-one wow fadeInUp">
                        <div class="icon">
                           <?php if(!empty($single_feature['flat_icon'])):?>
		                        <i class="<?php echo esc_attr($single_feature['flat_icon']); ?>"></i>
			                    <?php endif;?>
		                    <?php if(!empty($single_feature['icon_image']['url'])):?>
		                        <img src="<?php echo esc_url($single_feature['icon_image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
		                    <?php endif;?>
		                    <?php 
		                    	if(!empty($single_feature['custom_icon'])):?>
		                        <i class="<?php echo esc_attr($single_feature['custom_icon']); ?>"></i>
		                    <?php endif;?>
                        </div>
                        <div class="info">
                            <h4><?php echo esc_html($single_feature['title']);?></h4>
                            <p>
                              <?php echo esc_html($single_feature['subtitle']);?>
                            </p>
                        </div>
                    </div>
                    <!-- End Single Itme -->
                  	<?php
                	    endforeach;
                	?>

                </div>
            </div>
        </div>
    </div>
    <!-- End Our Features One -->

	<?php elseif($consua_feature_output['style'] == '2'): ?>

	<!-- Start Feature Style Two
    ============================================= -->
    <div class="feature-style-two-area default-padding bottom-less bg-gray" style="background-image: url(<?php echo esc_url($consua_feature_output['feature_shape_two']['url']);?>);">

    	<?php if(!empty($consua_feature_output['title'] || $consua_feature_output['subtitle'])):?>
	    	<div class="container">
	            <div class="row">
	                <div class="col-lg-8 offset-lg-2">
	                    <div class="site-heading secondary text-center">
	                        <h4 class="sub-heading"><?php echo wp_kses($consua_feature_output['title'], 'consua_allowed_tags'); ?></h4>
	                        <h2 class="title"><?php echo wp_kses($consua_feature_output['subtitle'], 'consua_allowed_tags'); ?></h2>
	                        <div class="devider"></div>
	                    </div>
	                </div>
	            </div>
	        </div>
    	<?php endif;?>
        <div class="container">
            <div class="row relative">

				<?php 
                	foreach ($style_two_feature_list as $single_feature):
                ?>
                <!-- Single item -->
                <div class="col-lg-4 col-md-6 mb-30">
                    <div class="feature-style-two">
                    	<?php if(!empty($single_feature['icon_image']['url'])):?>
                        	<img src="<?php echo esc_url($single_feature['icon_image']['url']);?>" alt="<?php echo esc_attr(get_bloginfo('name'));?>">
                    	<?php endif;?>
                        <h4>
                        	<a href="<?php echo esc_url($single_feature['url']['url']);?>"><?php echo wp_kses($single_feature['title'], 'consua_allowed_tags'); ?></a>
                        </h4>
                        <p>
                            <?php echo wp_kses($single_feature['summary'], 'consua_allowed_tags'); ?>
                        </p>
                    </div>
                </div>
                <!-- End Single item -->
               	<?php
            	    endforeach;
            	?>

            	<?php if(!empty($consua_feature_output['feature_shape_one']['url'])):?>
	                <div class="shape-right-bottom">
	                    <img src="<?php echo esc_url($consua_feature_output['feature_shape_one']['url']);?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>">
	                </div>
            	<?php endif;?>

            </div>
        </div>
    </div>
    <!-- End Feature Style Two -->

	<?php elseif($consua_feature_output['style'] == '3'): ?>

	<!-- Start Features Style Three
    ============================================= -->
    <div class="feature-style-three-area">
        <div class="container">
            <div class="row">

				<?php 
                	foreach ($style_three_feature_list as $single_feature):
                ?>
	                <!-- Single Item -->
	                <div class="col-lg-4 col-md-6 mb-30">
	                    <div class="feature-style-three">
	                        <div class="thumb">
	                            <img src="<?php echo esc_url($single_feature['image']['url']); ?>" alt="<?php echo esc_attr(get_bloginfo('name'));?>">
	                        </div>
	                        <div class="info">
	                            <?php if(!empty($single_feature['flat_icon'])):?>
		                        <i class="<?php echo esc_attr($single_feature['flat_icon']); ?>"></i>
				                    <?php endif;?>
			                    <?php if(!empty($single_feature['icon_image'])):?>
			                        <img src="<?php echo esc_url($single_feature['icon_image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
			                    <?php endif;?>
			                    <?php 
			                    	if(!empty($single_feature['custom_icon'])):?>
			                        <i class="<?php echo esc_attr($single_feature['custom_icon']); ?>"></i>
			                    <?php endif;?>
	                            <h4><?php echo wp_kses($single_feature['title'], 'consua_allowed_tags'); ?></h4>
	                            <p>
	                               <?php echo wp_kses($single_feature['subtitle'], 'consua_allowed_tags'); ?>
	                            </p>
	                        </div>
	                    </div>
	                </div>
	                <!-- End Single Item -->
                <?php
            	    endforeach;
            	?>

            </div>
        </div>
    </div>
    <!-- End Features Style Three -->

    <?php elseif($consua_feature_output['style'] == '4'): ?>

    <!-- Start Feature Style Four
    ============================================= -->
	    <div class="feature-style-four-area text-center default-padding bg-dark text-light">
	        <div class="container">
	            <div class="row">

	            <?php 
                	foreach ($style_two_feature_list as $single_feature):
                ?>	
	                <!-- Single Itme -->
	                <div class="col-lg-4 feature-style-four-single">
	                    <div class="feature-style-four">
	                       <?php if(!empty($single_feature['icon_image']['url'])):?>
	                        	<img src="<?php echo esc_url($single_feature['icon_image']['url']);?>" alt="<?php echo esc_attr(get_bloginfo('name'));?>">
	                    	<?php endif;?>
	                        <h4>
	                        	<a href="<?php echo esc_url($single_feature['url']['url']);?>"><?php echo wp_kses($single_feature['title'], 'consua_allowed_tags'); ?></a>
	                        </h4>
	                        <p>
	                            <?php echo wp_kses($single_feature['summary'], 'consua_allowed_tags'); ?>
	                        </p>
	                    </div>
	                </div>
	                <!-- End Single Itme -->
	            <?php
            	    endforeach;
            	?>   
	            </div>
	        </div>
	    </div>
    <!-- End Start Feature Style Four -->

	<?php elseif($consua_feature_output['style'] == '5'): ?>

	<!-- Start Feature Style Five -->
    <div class="feature-style-five-area">

    	<?php if(!empty($consua_feature_output['subtitle'] || $consua_feature_output['title'])):?>
	        <div class="container">
	            <div class="row">
	                <div class="col-lg-8 offset-lg-2">
	                    <div class="site-heading text-center secondary">
	                        <h4 class="sub-heading"> <?php echo wp_kses($consua_feature_output['subtitle'], 'consua_allowed_tags'); ?></h4>
	                        <h2 class="title"> <?php echo wp_kses($consua_feature_output['title'], 'consua_allowed_tags'); ?></h2>
	                    </div>
	                </div>
	            </div>
	        </div>
    	<?php endif;?>

        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="feature-style-five-grid">

                     	<?php 
		                	foreach ($style_five_feature_list as $single_feature):
		                ?>	
	                        <!-- Single Item -->
	                        <div class="feature-style-five">
	                            <div class="thumb">
	                               <img src="<?php echo esc_url($single_feature['icon_image']['url']);?>" alt="<?php echo esc_attr(get_bloginfo('name'));?>">
	                            </div>
	                            <h3><?php echo wp_kses($single_feature['title'], 'consua_allowed_tags'); ?></h3>
	                            <p>
	                              <?php echo wp_kses($single_feature['subtitle'], 'consua_allowed_tags'); ?>
	                            </p>
	                        </div>
	                        <!-- End Single Item -->
                       	<?php
		            	    endforeach;
		            	?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Start Feature Style Five -->

	<?php elseif($consua_feature_output['style'] == '6'): ?>

	<!-- Start Feature Style Six -->
	<div class="services-more mt-40">
        <h2> <?php echo wp_kses($consua_feature_output['title'], 'consua_allowed_tags'); ?></h2>
        <div class="row">
        <?php 
        	foreach ($consua_feature_output['style_six_feature_list'] as $single_feature):
        ?>
            <div class="col-md-6">
                <div class="item">
                    <?php if(!empty($single_feature['flat_icon'])):?>
                    	<i class="<?php echo esc_attr($single_feature['flat_icon']); ?>"></i>
	                <?php endif;?>
                    <?php if(!empty($single_feature['icon_image'])):?>
                        <img src="<?php echo esc_url($single_feature['icon_image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
                    <?php endif;?>
                    <?php 
                    	if(!empty($single_feature['custom_icon'])):?>
                        <i class="<?php echo esc_attr($single_feature['custom_icon']); ?>"></i>
                    <?php endif;?>
                    <h4>
                    	<a href="<?php echo esc_url($single_feature['url']['url']); ?>"><?php echo wp_kses($single_feature['title'], 'consua_allowed_tags'); ?></a>
                    </h4>
                    <p>
                        <?php echo wp_kses($single_feature['subtitle'], 'consua_allowed_tags'); ?>
                    </p>
                </div>
            </div>
        <?php
    	    endforeach;
    	?>    
        </div>
    </div>
    <!-- End Feature Style Six -->

	<?php 
	endif;
	}
}