<?php
	/**
	* Elementor Consua About Widget.
	*
	* Elementor widget that inserts an embbedable content into the page, from any given URL.
	*
	* @since 1.0.0
	*/
class Elementor_Consua_About_Widget extends \Elementor\Widget_Base {

	/**
	* Get widget name.
	*
	* Retrieve About widget name.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget name.
	*/
	public function get_name() {
		return 'consua_about_content';
	}

	/**
	* Get widget title.
	*
	* Retrieve About Nav Tab widget title.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget title.
	*/
	public function get_title() {
		return esc_html__( 'About', 'consua-core' );
	}

	/**
	* Get widget icon.
	*
	* Retrieve About Nav Tab widget icon.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget icon.
	*/
	public function get_icon() {
		return 'eicon-code';
	}

	/**
	* Get widget categories.
	*
	* Retrieve the list of categories the About Nav Tab widget belongs to.
	*
	* @since 1.0.0
	* @access public
	*
	* @return array Widget categories.
	*/
	public function get_categories() {
		return [ 'consua_elements' ];
	}
	
	// Add The Input For User
	protected function register_controls(){

		$this->start_controls_section(
			'about_content_style',
			[
				'label'		=> esc_html__( 'About Style','consua-core' ),
				'tab'		=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'style',
			[
				'label' 	=> esc_html__( 'Style', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Style One', 'consua-core' ),
					'2'  	=> esc_html__( 'Style Two', 'consua-core' ),
					'3'  	=> esc_html__( 'Style Three', 'consua-core' ),
					'4'  	=> esc_html__( 'Style Four', 'consua-core' ),
					'5'  	=> esc_html__( 'Style Five', 'consua-core' ),
					'6'  	=> esc_html__( 'Style Six', 'consua-core' )
				],
			]
		);

		$this->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'rows' 			=> '2',
				'placeholder' 	=> esc_html__( 'title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Title', 'consua-core' ),
				'condition' => [
                    'style' => ['1','3','4','5','6','2']
                ]
			]
		);

		$this->add_control(
			'subtitle', [
				'label' 		=> esc_html__( 'Sub-Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'rows' 			=> '2',
				'placeholder' 	=> esc_html__( 'subtitle', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Sub-Title', 'consua-core' ),
				'condition' => [
                     'style' => ['1','3','4','6']
                ]
			]
		);

		$this->add_control(
			'summary', [
				'label' 		=> esc_html__( 'Summary', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'rows' 			=> '4',
				'placeholder' 	=> esc_html__( 'summary', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Summary', 'consua-core' ),
				'condition' => [
                     'style' => ['1','4','5','6','2']
                ]
			]
		);

		$this->add_control(
			'highlighted_text', [
				'label' 		=> esc_html__( 'Highlighted Text', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'rows' 			=> '2',
				'placeholder' 	=> esc_html__( 'highlighted text', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Highlighted Text', 'consua-core' ),
				'condition' => [
                     'style' => ['5']
                ]
			]
		);

		$this->add_control(
			'experiance_title', [
				'label' 		=> esc_html__( 'Experiance Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'rows' 			=> '2',
				'placeholder' 	=> esc_html__( 'experiance title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Experiance Title', 'consua-core' ),
				'condition' => [
                     'style' => ['4','2']
                ]
			]
		);


		$counter = new \Elementor\Repeater();

		$counter->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'title', 'consua-core' ),
				'rows' 			=> '1',
				'default' 		=> esc_html__( 'Default Title', 'consua-core' ),
				'label_block' 	=> true,
			]
		);
		$counter->add_control(
			'number', [
				'label' 		=> esc_html__( 'Number', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'number', 'consua-core' ),
				'default' 		=> esc_html__( '80', 'consua-core' ),
				'label_block' 	=> true,
			]
		);

		$counter->add_control(
			'operator', [
				'label' 		=> esc_html__( 'Operator', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'operator', 'consua-core' ),
				'default' 		=> esc_html__( 'K', 'consua-core' ),
				'label_block' 	=> true,
			]
		);

		$this->add_control(
			'style_four_counter_list',
			[
				'label' 	=> esc_html__( 'Counter List', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $counter->get_controls(),
				'default' 	=> [
					[
						'list_title' => esc_html__( 'Add Counter', 'consua-core' ),
					],
				],
				'title_field' => '{{{ title }}}',
				'prevent_empty' => false,
				'condition' => [
                    'style' => ['3','4']
                ]
			]
		);


		$style_two_feature_list = new \Elementor\Repeater();

		$style_two_feature_list->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'title', 'consua-core' ),
				'rows' 			=> '1',
				'default' 		=> esc_html__( 'Default Title', 'consua-core' ),
				'label_block' 	=> true,
			]
		);

		$style_two_feature_list->add_control(
			'url',
			[
				'label' 		=> esc_html__( 'URL', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'consua-core' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);

		$style_two_feature_list->add_control(
			'icon_style',
			[
				'label' 	=> esc_html__( 'Icon Style', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Flaticon', 'consua-core' ),
					'3' 	=> esc_html__( 'Icon Image', 'consua-core' ),
					'2'  	=> esc_html__( 'Custom Icon', 'consua-core' ),
				],
			]
		);

		$style_two_feature_list->add_control(
			'flat_icon',
			[
                'label'      => esc_html__('Icon One', 'consua-core'),
                'type'       => \Elementor\Controls_Manager::ICON,
                'options'    => consua_flaticons(),
                'include'    => consua_include_flaticons(),
                'default'    => 'flaticon-license',
                'condition' => [
                    'icon_style' => '1'
                ]
            ]
		);

		$style_two_feature_list->add_control(
			'custom_icon', [
				'label' 		=> esc_html__( 'Custom Icon', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'condition' => [
                    'icon_style' => '2'
                ]
			]
		);


		$style_two_feature_list->add_control(
			'icon_image',
			[
				'label'			=> esc_html__( 'Add Image Icon','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'icon_style' => '3'
                ]
			]
		);

		$this->add_control(
			'style_two_feature_list',
			[
				'label' 	=> esc_html__( 'Feature List', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $style_two_feature_list->get_controls(),
				'default' 	=> [
					[
						'list_title' => esc_html__( 'Add Feature', 'consua-core' ),
					],
				],
				'title_field' => '{{{ title }}}',
				'prevent_empty' => false,
				'condition' => [
                    'style' => ['2']
                ]
			]
		);


		$style_five_counter = new \Elementor\Repeater();

		$style_five_counter->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'title', 'consua-core' ),
				'rows' 			=> '1',
				'default' 		=> esc_html__( 'Default Title', 'consua-core' ),
				'label_block' 	=> true,
			]
		);
		$style_five_counter->add_control(
			'number', [
				'label' 		=> esc_html__( 'Number', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'number', 'consua-core' ),
				'default' 		=> esc_html__( '80', 'consua-core' ),
				'label_block' 	=> true,
			]
		);

		$style_five_counter->add_control(
			'operator', [
				'label' 		=> esc_html__( 'Operator', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'operator', 'consua-core' ),
				'default' 		=> esc_html__( 'K', 'consua-core' ),
				'label_block' 	=> true,
			]
		);

		$style_five_counter->add_control(
			'icon_style',
			[
				'label' 	=> esc_html__( 'Icon Style', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Flaticon', 'consua-core' ),
					'3' 	=> esc_html__( 'Icon Image', 'consua-core' ),
					'2'  	=> esc_html__( 'Custom Icon', 'consua-core' ),
				],
			]
		);

		$style_five_counter->add_control(
			'flat_icon',
			[
                'label'      => esc_html__('Icon One', 'consua-core'),
                'type'       => \Elementor\Controls_Manager::ICON,
                'options'    => consua_flaticons(),
                'include'    => consua_include_flaticons(),
                'default'    => 'flaticon-license',
                'condition' => [
                    'icon_style' => '1'
                ]
            ]
		);

		$style_five_counter->add_control(
			'custom_icon', [
				'label' 		=> esc_html__( 'Custom Icon', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'condition' => [
                    'icon_style' => '2'
                ]
			]
		);


		$style_five_counter->add_control(
			'icon_image',
			[
				'label'			=> esc_html__( 'Add Image Icon','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'icon_style' => '3'
                ]
			]
		);

		$this->add_control(
			'style_five_counter_list',
			[
				'label' 	=> esc_html__( 'Counter List', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $style_five_counter->get_controls(),
				'default' 	=> [
					[
						'list_title' => esc_html__( 'Add Counter', 'consua-core' ),
					],
				],
				'title_field' => '{{{ title }}}',
				'prevent_empty' => false,
				'condition' => [
                    'style' => ['1','5']
                ]
			]
		);

		$this->add_control(
			'about_counter_divider',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Title', 'consua-core' ),
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'summary', [
				'label' 		=> esc_html__( 'Summary', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'summary', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Summary', 'consua-core' ),
				'label_block' 	=> true,
			]
		);

		$this->add_control(
			'style_three_choose_list',
			[
				'label' 	=> esc_html__( 'Choose List', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
				'default' 	=> [
					[
						'list_title' => esc_html__( 'Add Choose', 'consua-core' ),
					],
				],
				'title_field' => '{{{ title }}}',
				'condition' => [
                    'style' => ['3','4']
                ]
			]
		);

		$this->add_control(
			'style_four_author_content', [
				'label' 		=> esc_html__( 'Author Content', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::CODE,
				'label_block' 	=> true,
				'rows' 			=> '2',
				'placeholder' 	=> esc_html__( 'author content', 'consua-core' ),
				'default' 		=> esc_html__( 'Default author content', 'consua-core' ),
				'condition' => [
                     'style' => ['1','4']
                ]
			]
		);

		$style_six_point_list = new \Elementor\Repeater();

		$style_six_point_list->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'title', 'consua-core' ),
				'rows' 			=> '1',
				'default' 		=> esc_html__( 'Default Title', 'consua-core' ),
				'label_block' 	=> true,
			]
		);
		
		$this->add_control(
			'style_six_point_list',
			[
				'label' 	=> esc_html__( 'Point List', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $style_six_point_list->get_controls(),
				'default' 	=> [
					[
						'list_title' => esc_html__( 'Add Point List', 'consua-core' ),
					],
				],
				'title_field' => '{{{ title }}}',
				'prevent_empty' => false,
				'condition' => [
                    'style' => ['6']
                ]
			]
		);

		$this->add_control(
			'about_three_image_one',
			[
				'label'			=> esc_html__( 'Add Image One','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' => [
		            'url' => \Elementor\Utils::get_placeholder_image_src(),
		        ],
				'condition' => [
                    'style' => ['1','3','4','5','6','2']
                ]
			]
		);

		$this->add_control(
			'about_three_image_two',
			[
				'label'			=> esc_html__( 'Add Image Two','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'style' => ['3','5','6','2']
                ]
			]
		);

		$this->add_control(
			'about_three_image_three',
			[
				'label'			=> esc_html__( 'Add Image Three','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'style' => ['3']
                ]
			]
		);

		$this->add_control(
			'about_four_image_shape',
			[
				'label'			=> esc_html__( 'Add Shape Image','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'style' => ['1','4','5','6','2']
                ]
			]
		);

		$this->add_control(
			'about_shape_two',
			[
				'label'			=> esc_html__( 'Add Shape Image Two','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'style' => ['1','2']
                ]
			]
		);

		$this->add_control(
			'about_shape_three',
			[
				'label'			=> esc_html__( 'Add Shape Image Three','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'style' => ['1']
                ]
			]
		);

		$this->add_control(
			'about_shape_four',
			[
				'label'			=> esc_html__( 'Add Shape Image Four','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'style' => ['1']
                ]
			]
		);

		$this->add_control(
			'about_author_image',
			[
				'label'			=> esc_html__( 'Add Author Image','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' => [
		            'url' => \Elementor\Utils::get_placeholder_image_src(),
		        ],
				'condition' => [
                    'style' => '4'
                ]
			]
		);

		$this->add_control(
			'about_signature_image',
			[
				'label'			=> esc_html__( 'Add Signature Image','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' => [
		            'url' => \Elementor\Utils::get_placeholder_image_src(),
		        ],
				'condition' => [
                    'style' => ['4','1']
                ]
			]
		);



		$this->end_controls_section();

		INCLUDE CONSUA_PLUGIN_WIDGET_STYLE_PATH . 'about-style.php';
	}

	// Output For User
	protected function render(){	
	$consua_about_output = $this->get_settings_for_display();
	if($consua_about_output['style'] == '1'):
	?>

	<!-- Start About Style One
    ============================================= -->
    <div class="about-style-one-area default-padding">
        <div class="shape-animated-left">
        	<?php if(!empty($consua_about_output['about_four_image_shape']['url'])):?>
            	<img src="<?php echo esc_url($consua_about_output['about_four_image_shape']['url']);?>" alt="<?php echo esc_attr(get_bloginfo('name'));?>">
            <?php endif;?>
            <?php if(!empty($consua_about_output['about_shape_two']['url'])):?>
            	<img src="<?php echo esc_url($consua_about_output['about_shape_two']['url']);?>" alt="<?php echo esc_attr(get_bloginfo('name'));?>">
            <?php endif;?>
        </div>
        <div class="container">
            <div class="row align-center">
                <div class="about-style-one col-xl-6 col-lg-5">
                    <div class="h4 sub-heading"><?php echo wp_kses_post($consua_about_output['subtitle'],'consua_kses_allowed_html');?></div>
                    <h2 class="title mb-25"><?php echo wp_kses_post($consua_about_output['title'],'consua_kses_allowed_html');?></h2>
                    <p>
                       <?php echo wp_kses_post($consua_about_output['summary'],'consua_kses_allowed_html');?>
                    </p>
                    <div class="owner-info">
                    	<?php if(!empty($consua_about_output['style_four_author_content'])):?>
	                        <div class="left-info">
	                        	<?php echo wp_kses_post($consua_about_output['style_four_author_content'],'consua_kses_allowed_html');?>
	                        </div>
                    	<?php endif;?>
                        <?php if(!empty($consua_about_output['about_signature_image']['url'])):?>
	                        <div class="right-info">
	                            <img src="<?php echo esc_url($consua_about_output['about_signature_image']['url']);?>" alt="<?php echo esc_attr(get_bloginfo('name'));?>">
	                        </div>
                    	<?php endif;?>
                    </div>
                </div>
                <div class="about-style-one col-xl-5 offset-xl-1 col-lg-6 offset-lg-1">
                    <div class="about-thumb">
                        <img class="wow fadeInRight" src="<?php echo esc_url($consua_about_output['about_three_image_one']['url']);?>" alt="<?php echo esc_attr(get_bloginfo('name'));?>">
                        <div class="about-card wow fadeInUp" data-wow-delay="500ms">
                            <ul>
                            	<?php 
									foreach($consua_about_output['style_five_counter_list'] as $single_counter): ?>
	                                <li>
	                                    <div class="icon">
	                                        <?php if(!empty($single_counter['flat_icon'])):?>
						                        <i class="<?php echo esc_attr($single_counter['flat_icon']); ?>"></i>
							                    <?php endif;?>
						                    <?php if(!empty($single_counter['icon_image']['url'])):?>
						                        <img src="<?php echo esc_url($single_counter['icon_image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
						                    <?php endif;?>
						                    <?php 
						                    	if(!empty($single_counter['custom_icon'])):?>
						                        <i class="<?php echo esc_attr($single_counter['custom_icon']); ?>"></i>
						                    <?php endif;?>
	                                    </div>
	                                    <div class="fun-fact">
	                                        <div class="counter">
	                                            <div class="timer" data-to="<?php echo esc_attr($single_counter['number']);?>" data-speed="2000"><?php echo wp_kses_post($single_counter['number'],'consua_kses_allowed_html');?></div>
	                                            <div class="operator"><?php echo wp_kses_post($single_counter['operator'],'consua_kses_allowed_html');?></div>
	                                        </div>
	                                        <span class="medium"><?php echo wp_kses_post($single_counter['title'],'consua_kses_allowed_html');?></span>
	                                    </div>
	                                </li>
                                <?php 
								 endforeach;
								?>
                                
                            </ul>
                        </div>
                        <div class="thumb-shape-bottom wow fadeInDown" data-wow-delay="300ms">
                        	<?php if(!empty($consua_about_output['about_shape_three']['url'])):?>
                           		<img src="<?php echo esc_url($consua_about_output['about_shape_three']['url']);?>" alt="<?php echo esc_attr(get_bloginfo('name'));?>">
                       		<?php endif;?>
                       		<?php if(!empty($consua_about_output['about_shape_four']['url'])):?>
            					<img src="<?php echo esc_url($consua_about_output['about_shape_four']['url']);?>" alt="<?php echo esc_attr(get_bloginfo('name'));?>">
            				<?php endif;?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End  About Style One -->

	<?php elseif($consua_about_output['style'] == '2'): ?>

	<!-- Start About Style Two
    ============================================= -->
    <div class="about-style-two-area overflow-hidden bg-contain default-padding" style="background-image: url(<?php echo esc_url($consua_about_output['about_four_image_shape']['url']); ?>);">
        <div class="container">
            <div class="row align-center">

                <div class="col-lg-5 about-style-two">
                    <div class="thumb">
                    	<?php if(!empty($consua_about_output['about_three_image_one']['url'])):?>
                        	<img src="<?php echo esc_url($consua_about_output['about_three_image_one']['url']);?>" alt="<?php echo esc_attr(get_bloginfo('name'));?>">
                    	<?php endif;?>
                    	<?php if(!empty($consua_about_output['about_three_image_two']['url'])):?>
                        	<img src="<?php echo esc_url($consua_about_output['about_three_image_two']['url']);?>" alt="<?php echo esc_attr(get_bloginfo('name'));?>">
                        <?php endif;?>
                        <?php
                        	if(!empty($consua_about_output['experiance_title'])):
	                            ?>
	                        <div class="experience">
	                            <h2><?php echo wp_kses_post($consua_about_output['experiance_title'],'consua_kses_allowed_html');?></h2>
	                        </div>
                    	<?php endif;?>
                        <?php if(!empty($consua_about_output['about_shape_two']['url'])):?>
	                        <div class="shape">
	                            <img src="<?php echo esc_url($consua_about_output['about_shape_two']['url']);?>" alt="<?php echo esc_attr(get_bloginfo('name'));?>">
	                        </div>
                        <?php endif;?>
                    </div>
                </div>

                <div class="about-style-two col-lg-6 offset-lg-1">
                	<?php if(!empty($consua_about_output['title'])):?>
                    	<h2 class="title"><?php echo wp_kses_post($consua_about_output['title'],'consua_kses_allowed_html');?></h2>
                	<?php endif;?>
                	<?php if(!empty($consua_about_output['summary'])):?>
	                    <p>
	                       <?php echo wp_kses_post($consua_about_output['summary'],'consua_kses_allowed_html');?>
	                    </p>
                    <?php endif;?>
                    <?php if(!empty($consua_about_output['style_two_feature_list'])):?>
	                    <div class="default-features mt-30">

	                    	<?php 
							foreach($consua_about_output['style_two_feature_list'] as $single_feature): ?>
		                        <div class="default-feature-item">
		                            <a href="<?php echo esc_url($single_feature['url']['url']);?>">
	                                	<?php if(!empty($single_feature['flat_icon'])):?>
				                        	<i class="<?php echo esc_attr($single_feature['flat_icon']); ?>"></i>
					                    <?php endif;?>
					                    <?php if(!empty($single_featuresingle_feature['icon_image']['url'])):?>
					                        <img src="<?php echo esc_url($single_feature['icon_image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
					                    <?php endif;?>
					                    <?php 
					                    	if(!empty($single_feature['custom_icon'])):?>
					                        <i class="<?php echo esc_attr($single_feature['custom_icon']); ?>"></i>
					                    <?php endif;?>
		                                <h4><?php echo wp_kses_post($single_feature['title'],'consua_kses_allowed_html');?></h4>
		                            </a>
		                        </div>
	                    	<?php endforeach;?>
	                        
	                    </div>
                	<?php endif;?>
                </div>

            </div>
        </div>
    </div>
    <!-- End About Style Two -->

	<?php elseif($consua_about_output['style'] == '3'): ?>

    <!-- Start About Style Three
    ============================================= -->
    <div class="about-style-three-area">
        <div class="container">
            <div class="row align-center">

                <div class="col-lg-5">
                    <div class="about-style-three">
                        <div class="thumb">
                        	<?php if(!empty($consua_about_output['about_three_image_one']['url'])):?>
                            	<img class="wow fadeInLeft" src="<?php echo esc_url($consua_about_output['about_three_image_one']['url']);?>" alt="<?php echo esc_attr(get_bloginfo('name'));?>">
                        	<?php endif;?>
                            <div class="sub-item">
                            	<?php if(!empty($consua_about_output['about_three_image_two']['url'])):?>
                                	<img class="wow fadeInUp" data-wow-delay="500ms" src="<?php echo esc_url($consua_about_output['about_three_image_two']['url']);?>" alt="<?php echo esc_attr(get_bloginfo('name'));?>">
                                <?php endif;?>
                                <?php if(!empty($consua_about_output['about_three_image_three']['url'])):?>
                                	<img class="wow fadeInRight" data-wow-delay="1000ms" src="<?php echo esc_url($consua_about_output['about_three_image_three']['url']);?>" alt="<?php echo esc_attr(get_bloginfo('name'));?>">
                                 <?php endif;?>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-6 offset-lg-1">
                    <div class="about-style-three">
                    	<?php if(!empty($consua_about_output['title'] || $consua_about_output['subtitle'])):?>
	                        <h4 class="sub-heading secondary"><?php echo wp_kses_post($consua_about_output['subtitle'],'consua_kses_allowed_html');?></h4>
	                        <h2 class="heading"><?php echo wp_kses_post($consua_about_output['title'],'consua_kses_allowed_html');?></h2>
                    	<?php endif;?>
						<?php 
						$counter = 1;
						foreach($consua_about_output['style_three_choose_list'] as $single_choose): ?>
	                        <div class="list-item-style-two wow fadeInUp">
	                            <div class="number"><?php echo esc_attr("0"); ?><?php echo esc_html($counter);?></div>
	                            <div class="info">
	                                <h4><?php echo wp_kses_post($single_choose['title'],'consua_kses_allowed_html');?></h4>
	                                <p>
	                                   <?php echo wp_kses_post($single_choose['summary'],'consua_kses_allowed_html');?>
	                                </p>
	                            </div>
	                        </div>
						<?php 
						 $counter++;
						 endforeach;
						?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End About Style Three -->

	<?php elseif($consua_about_output['style'] == '4'):?>

	<!-- Start About Four
    ============================================= -->
    <div class="about-style-four-area overflow-hidden bg-gray default-padding-top shape-light-bottom">
        <?php if(!empty($consua_about_output['about_four_image_shape']['url'])):?>
	        <div class="shape-right-bottom-actual">
	            <img src="<?php echo esc_url($consua_about_output['about_four_image_shape']['url']);?>" alt="<?php echo esc_attr(get_bloginfo('name'));?>">
	        </div>
    	<?php endif;?>
        <div class="container">
            <div class="row">

                <div class="col-lg-6 about-style-four">
                    <h4 class="sub-heading secondary"> <?php echo wp_kses_post($consua_about_output['subtitle'],'consua_kses_allowed_html');?></h4>
                    <h2 class="title"> <?php echo wp_kses_post($consua_about_output['title'],'consua_kses_allowed_html');?></h2>
                    <div class="thumb mt-50 mt-xs-30">
                        <img src="<?php echo esc_url($consua_about_output['about_three_image_one']['url']);?>" alt="<?php echo esc_attr(get_bloginfo('name'));?>">
                        <?php if(!empty($consua_about_output['experiance_title'])):?>
	                        <div class="experience wow fadeInUp">
	                            <h2><?php echo wp_kses_post($consua_about_output['experiance_title'],'consua_kses_allowed_html');?></h2>
	                        </div>
                    	<?php endif;?>
                    </div>
                </div>

                <div class="col-lg-5 offset-lg-1 about-style-four">
                    <div class="fun-fact-box mb-30">
                        <?php 
						foreach($consua_about_output['style_four_counter_list'] as $single_counter): ?>
	                        <div class="fun-fact">
	                            <div class="counter">
	                                <div class="timer" data-to="<?php echo esc_attr($single_counter['number']);?>" data-speed="2000"><?php echo wp_kses_post($single_counter['number'],'consua_kses_allowed_html');?></div>
	                                <div class="operator"><?php echo wp_kses_post($single_counter['operator'],'consua_kses_allowed_html');?></div>
	                            </div>
	                            <span class="medium"><?php echo wp_kses_post($single_counter['title'],'consua_kses_allowed_html');?></span>
	                        </div>
                        <?php 
						 endforeach;
						?>
                    </div>
                    <?php if(!empty($consua_about_output['summary'])):?>
	                    <p>
	                       <?php echo wp_kses_post($consua_about_output['summary'],'consua_kses_allowed_html');?>
	                    </p>
                	<?php endif;?>
                    <div class="mt-50 mt-xs-30">
                    	<?php 
						foreach($consua_about_output['style_three_choose_list'] as $single_choose): ?>
	                        <div class="list-item-style-two wow fadeInUp">
	                            <div class="number"><i class="fas fa-check"></i></div>
	                            <div class="info">
	                                <h4><?php echo wp_kses_post($single_choose['title'],'consua_kses_allowed_html');?></h4>
	                                <p>
	                                   <?php echo wp_kses_post($single_choose['summary'],'consua_kses_allowed_html');?>
	                                </p>
	                            </div>
	                        </div>
                        <?php 
						endforeach;
						?>
                    </div>

                    <?php if(!empty($consua_about_output['style_four_author_content'] || $consua_about_output['about_author_image']['url'] || $consua_about_output['about_signature_image']['url'])):?>
	                    <div class="company-autor">
	                        <div class="left-info">
	                        	<?php if(!empty($consua_about_output['about_author_image']['url'])):?>
		                            <div class="author-thumb">
		                                <img src="<?php echo esc_url($consua_about_output['about_author_image']['url']);?>" alt="<?php echo esc_attr(get_bloginfo('name'));?>">
		                            </div>
	                            <?php endif;?>
	                            <?php if(!empty($consua_about_output['style_four_author_content'])):?>
		                            <div class="content">
		                               <?php echo wp_kses_post($consua_about_output['style_four_author_content'],'consua_kses_allowed_html');?>
		                            </div>
	                            <?php endif;?>
	                        </div>
	                        <?php if(!empty($consua_about_output['about_signature_image']['url'])):?>
		                        <div class="right-info">
		                            <img src="<?php echo esc_url($consua_about_output['about_signature_image']['url']);?>" alt="<?php echo esc_attr(get_bloginfo('name'));?>">
		                        </div>
	                    	<?php endif;?>
	                    </div>
                	<?php endif;?>

                </div>

            </div>
        </div>
    </div>
    <!-- End About Four -->

	<?php elseif($consua_about_output['style'] == '5'):?>

	<!-- Start About Style Five
    ============================================= -->
    <div class="about-style-five-area default-padding overflow-hidden bg-cover" style="background: url(<?php echo esc_url($consua_about_output['about_four_image_shape']['url']);?>);">
        <div class="container">
            <div class="row align-center">
                <div class="col-lg-6">
                    <div class="about-style-five-thumb">
                    	<?php if(!empty($consua_about_output['about_three_image_one']['url'])):?>
                        	<img src="<?php echo esc_url($consua_about_output['about_three_image_one']['url']);?>" alt="<?php echo esc_attr(get_bloginfo('name'));?>">
                    	<?php endif;?>

                    	<?php if(!empty($consua_about_output['about_three_image_two']['url'])):?>
                        	<img src="<?php echo esc_url($consua_about_output['about_three_image_two']['url']);?>" alt="<?php echo esc_attr(get_bloginfo('name'));?>">
                        <?php endif;?>

                        <?php if(!empty($consua_about_output['highlighted_text'])):?>
                        	<h2><?php echo wp_kses_post($consua_about_output['highlighted_text'],'consua_kses_allowed_html');?></h2>
                    	<?php endif;?>
                    </div>
                </div>
                <div class="col-lg-5 offset-lg-1">
                    <div class="about-style-five-info">
                        <h2><?php echo wp_kses_post($consua_about_output['title'],'consua_kses_allowed_html');?></h2>
                        <p>
                            <?php echo wp_kses_post($consua_about_output['summary'],'consua_kses_allowed_html');?>
                        </p>
                        <ul>
                        	<?php 
		                    	foreach ($consua_about_output['style_five_counter_list'] as $single_counter):
		                    ?>
	                            <li>
	                                <div class="icon">
	                                   	<?php if(!empty($single_counter['flat_icon'])):?>
				                        	<i class="<?php echo esc_attr($single_counter['flat_icon']); ?>"></i>
					                    <?php endif;?>
					                    <?php if(!empty($single_counter['icon_image']['url'])):?>
					                        <img src="<?php echo esc_url($single_counter['icon_image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
					                    <?php endif;?>
					                    <?php 
					                    	if(!empty($single_counter['custom_icon'])):?>
					                        <i class="<?php echo esc_attr($single_counter['custom_icon']); ?>"></i>
					                    <?php endif;?>
	                                </div>
	                                <div class="fun-fact">
	                                    <div class="counter">
	                                        <div class="timer" data-to="<?php echo esc_attr($single_counter['number']);?>" data-speed="2000"><?php echo wp_kses_post($single_counter['number'],'consua_kses_allowed_html');?></div>
	                                        <div class="operator"><?php echo wp_kses_post($single_counter['operator'],'consua_kses_allowed_html');?></div>
	                                    </div>
	                                    <span class="medium"><?php echo wp_kses_post($single_counter['title'],'consua_kses_allowed_html');?></span>
	                                </div>
	                            </li>
                            <?php 
								endforeach;
							?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End About Style Five -->

	<?php elseif($consua_about_output['style'] == '6'):?>

	<!-- Start About Style Six  
    ============================================= -->
    <div class="about-style-six-area">
        <div class="container">
            <div class="row align-center">
                <div class="col-lg-6">
                    <div class="about-style-six-thumb">
                    	<?php if(!empty($consua_about_output['about_three_image_one']['url'])):?>
                        	<img src="<?php echo esc_url($consua_about_output['about_three_image_one']['url']);?>" alt="<?php echo esc_attr(get_bloginfo('name'));?>">
                    	<?php endif;?>
                    	<?php if(!empty($consua_about_output['about_three_image_two']['url'])):?>
                        	<img src="<?php echo esc_url($consua_about_output['about_three_image_two']['url']);?>" alt="<?php echo esc_attr(get_bloginfo('name'));?>">
                        <?php endif;?>
                        <?php if(!empty($consua_about_output['about_four_image_shape']['url'])):?>
	                        <div class="shape">
	                            <img src="<?php echo esc_url($consua_about_output['about_four_image_shape']['url']);?>" alt="<?php echo esc_attr(get_bloginfo('name'));?>">
	                        </div>
                        <?php endif;?>
                    </div>
                </div>
                <div class="col-lg-5 offset-lg-1">
                    <div class="about-style-six-info">
                        <h4 class="sub-heading secondary"><?php echo wp_kses_post($consua_about_output['subtitle'],'consua_kses_allowed_html');?></h4>
                        <h2 class="title"><?php echo wp_kses_post($consua_about_output['title'],'consua_kses_allowed_html');?></h2>
                        <p>
                            <?php echo wp_kses_post($consua_about_output['summary'],'consua_kses_allowed_html');?>
                        </p>
                        <?php if (!empty($consua_about_output['style_six_point_list'])) : ?>
	                        <ul class="list-regular">
								<?php 
			                    	foreach ($consua_about_output['style_six_point_list'] as $single_item):
			                    ?>
	                            	<li><?php echo wp_kses_post($single_item['title'],'consua_kses_allowed_html');?></li>
	                        	<?php endforeach;?>
	                        </ul>
                    	<?php endif;?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End About Style Five  -->

    <?php
	endif;
    }
}