<?php
	/**
	* Elementor Consua Footer Newsletter Widget.
	*
	* Elementor widget that inserts an embbedable content into the page, from any given URL.
	*
	* @since 1.0.0
	*/
class Elementor_Consua_Footer_Newsletter_Widget extends \Elementor\Widget_Base {

	/**
	* Get widget name.
	*
	* Retrieve Footer Newsletter widget name.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget name.
	*/
	public function get_name() {
		return 'consua_footer_newsletter';
	}

	/**
	* Get widget title.
	*
	* Retrieve Footer_Newsletter Nav Tab widget title.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget title.
	*/
	public function get_title() {
		return esc_html__( 'Footer Newsletter', 'consua-core' );
	}

	/**
	* Get widget icon.
	*
	* Retrieve Footer_Newsletter Nav Tab widget icon.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget icon.
	*/
	public function get_icon() {
		return 'eicon-code';
	}

	/**
	* Get widget categories.
	*
	* Retrieve the list of categories the Footer_Newsletter Nav Tab widget belongs to.
	*
	* @since 1.0.0
	* @access public
	*
	* @return array Widget categories.
	*/
	public function get_categories() {
		return [ 'consua_footer_elements' ];
	}
	
	// Add The Input For User
	protected function register_controls(){

		$this->start_controls_section(
			'footer_newsletter_content_style',
			[
				'label'		=> esc_html__( 'Content Style','consua-core' ),
				'tab'		=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'style',
			[
				'label' 	=> esc_html__( 'Style', 'Consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Style One', 'Consua-core' ),
					'2' 	=> esc_html__( 'Style Two', 'Consua-core' ),
				],
			]
		);

		$this->add_control(
			'section_title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'title', 'consua-core' ),
				'default' 		=> esc_html__( 'Section Title', 'consua-core' ),
				'rows'   		=>'1',
				'label_block' 	=> true,
			]
		);

		$this->add_control(
			'section_subtitle', [
				'label' 		=> esc_html__( 'SubTitle', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'subtitle', 'consua-core' ),
				'default' 		=> esc_html__( 'Section SubTitle', 'consua-core' ),
				'rows'   		=>'2',
				'label_block' 	=> true,
			]
		);

		$this->add_control(
			'newsletter_placeholder',
			[
				'label'     => __( 'Newsletter Placeholder Text', 'consua-core' ),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'default'   => __( 'Newsletter Placeholder Text', 'consua-core' ),
			]
        );

        $this->add_control(
			'newsletter_submit',
			[
				'label'     => __( 'Newsletter Submit Button Text', 'consua-core' ),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'default'   => __( 'Subscribe', 'consua-core' )
			]
        );

        $social = new \Elementor\Repeater();

		$social->add_control(
			'icon_style',
			[
				'label' 	=> esc_html__( 'Icon Style', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Flaticon', 'consua-core' ),
					'3' 	=> esc_html__( 'Icon Image', 'consua-core' ),
					'2'  	=> esc_html__( 'Custom Icon', 'consua-core' ),
				],
			]
		);

		$social->add_control(
			'flat_icon',
			[
                'label'      => esc_html__('Icon One', 'cleanu-core'),
                'type'       => \Elementor\Controls_Manager::ICON,
                'options'    => consua_flaticons(),
                'include'    => consua_include_flaticons(),
                'default'    => 'flaticon-budget',
                'condition' => [
                    'icon_style' => '1'
                ]
            ]
		);

		$social->add_control(
			'custom_icon', [
				'label' 		=> esc_html__( 'Custom Icon', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'label_block' 	=> true,
				'condition' => [
                    'icon_style' => '2'
                ]
			]
		);


		$social->add_control(
			'icon_image',
			[
				'label'			=> esc_html__( 'Add Image Icon','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'icon_style' => '3'
                ]
			]
		);

		$social->add_control(
		    'url',
		    [
		        'label' => __('Add Url', 'apsro-addon'),
		        'type' => \Elementor\Controls_Manager::URL,
		        'placeholder' => __('#', 'apsro-addon'),
		        'show_external' => false,
		        'default' => [
		            'url' => '#',
		            'is_external' => false,
		            'nofollow' => false,
		        ],
		        'show_label' => false,
		    ]
		);

		$this->add_control(
		    'social_list',
		    [
		        'label' => __('Social List', 'apsro-addon'),
		        'type' => \Elementor\Controls_Manager::REPEATER,
		        'fields' => $social->get_controls(),
		        'prevent_empty' => false,
		        'default' => [
		            [
		                'social_url' => [
		                    'url' => '#',
		                    'is_external' => false,
		                    'nofollow' => false,
		                ],
		            ],
		        ],

		    ]
		);
		
		$this->end_controls_section();

		$this->start_controls_section(
			'footer_Newsletter_style_option',
			[
				'label'			=> esc_html__( 'Footer Newsletter Style','consua-core' ),
				'tab' 			=> \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'open_hours_title_option',
			[
				'label' 		=> esc_html__( 'Open Hours Options', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::HEADING,
				'separator' 	=> 'before',
			]
		);

		$this->add_control(
			'open_hours_title_color',
			[
				'label' 		=> esc_html__( 'Title Color', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .opening-hours h5' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' 			=> 'open_hours_title_typography',
				'label' 		=> esc_html__( 'Title Typography', 'consua-core' ),
				'selector' 		=> '{{WRAPPER}} .opening-hours h5',
			]
		);

		$this->add_control(
			'section_subtitle_option',
			[
				'label' 		=> esc_html__( 'Sub-Title Options', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::HEADING,
				'separator' 	=> 'before',
			]
		);

		$this->add_control(
			'section_sub_title_color',
			[
				'label' 		=> esc_html__( 'Sub Title Color', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .Newsletter p' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' 			=> 'section_subtitle_typography',
				'label' 		=> esc_html__( 'Subtitle Typography', 'consua-core' ),
				'selector' 		=> '{{WRAPPER}} .Newsletter p',
			]
		);

		$this->end_controls_section();
	}

	// Output For User
	protected function render(){	
	$consua_footer_newsletter_output = $this->get_settings_for_display();
	if($consua_footer_newsletter_output['style'] == '1'): 
	?>

    <!-- Start Footer_Newsletter 
    ============================================= -->
    <div class="footer-item-subscribe">
    	<?php if(!empty($consua_footer_newsletter_output['section_title'])):?>
        <h4 class="widget-title"><?php echo wp_kses($consua_footer_newsletter_output['section_title'], 'consua_allowed_tags'); ?></h4>
    	<?php endif;?>
    	<?php if(!empty($consua_footer_newsletter_output['section_subtitle'])):?>
	        <p>
	            <?php echo wp_kses($consua_footer_newsletter_output['section_subtitle'], 'consua_allowed_tags'); ?>
	        </p>
        <?php endif;?>
        <div class="f-item newsletter">
            <form class="newsletter-form">
                <input type="email" placeholder="<?php echo esc_attr($consua_footer_newsletter_output['newsletter_placeholder']);?>" class="form-control" name="email">
                <button type="submit"><?php echo esc_html($consua_footer_newsletter_output['newsletter_submit']);?></button>  
            </form>
        </div>
        <ul class="footer-social">
        	<?php 
            	foreach ($consua_footer_newsletter_output['social_list'] as $single_item):
            ?>
	            <li>
	                <a href="<?php echo esc_url($single_item['url']['url']);?>">
	                   <?php if(!empty($single_item['flat_icon'])):?>
	                    <i class="<?php echo esc_attr($single_item['flat_icon']); ?>"></i>
	                    <?php endif;?>
	                    <?php if(!empty($single_item['icon_image']['url'])):?>
	                        <img src="<?php echo esc_url($single_item['icon_image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
	                    <?php endif;?>
	                    <?php 
	                    	if(!empty($single_item['custom_icon'])):?>
	                        <i class="<?php echo esc_attr($single_item['custom_icon']); ?>"></i>
	                    <?php endif;?>
	                </a>
	            </li>
        	<?php endforeach;?>
        </ul>
    </div>
    <!-- End Footer_Newsletter 
    ============================================= -->

	<?php elseif($consua_footer_newsletter_output['style'] == '2'): ?>

	<!-- Start Footer_Newsletter Two
    ============================================= -->
    <div class="footer-item-subscribe">
    	<?php if(!empty($consua_footer_newsletter_output['section_title'])):?>
        <h4 class="widget-title"><?php echo wp_kses($consua_footer_newsletter_output['section_title'], 'consua_allowed_tags'); ?></h4>
    	<?php endif;?>
    	<?php if(!empty($consua_footer_newsletter_output['section_subtitle'])):?>
	        <p>
	            <?php echo wp_kses($consua_footer_newsletter_output['section_subtitle'], 'consua_allowed_tags'); ?>
	        </p>
        <?php endif;?>
        <div class="f-item newsletter secondary">
            <form class="newsletter-form">
                <input type="email" placeholder="<?php echo esc_attr($consua_footer_newsletter_output['newsletter_placeholder']);?>" class="form-control" name="email">
                <button type="submit"><?php echo esc_html($consua_footer_newsletter_output['newsletter_submit']);?></button>  
            </form>
        </div>
        <ul class="footer-social">
        	<?php 
            	foreach ($consua_footer_newsletter_output['social_list'] as $single_item):
            ?>
	            <li>
	                <a href="<?php echo esc_url($single_item['url']['url']);?>">
	                   <?php if(!empty($single_item['flat_icon'])):?>
	                    <i class="<?php echo esc_attr($single_item['flat_icon']); ?>"></i>
	                    <?php endif;?>
	                    <?php if(!empty($single_item['icon_image']['url'])):?>
	                        <img src="<?php echo esc_url($single_item['icon_image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
	                    <?php endif;?>
	                    <?php 
	                    	if(!empty($single_item['custom_icon'])):?>
	                        <i class="<?php echo esc_attr($single_item['custom_icon']); ?>"></i>
	                    <?php endif;?>
	                </a>
	            </li>
        	<?php endforeach;?>
        </ul>
    </div>
    <!-- End Footer_Newsletter Two
    ============================================= -->

    <?php
    endif;
    }
}