<?php
	/**
	* Elementor Consua Footer About Widget.
	*
	* Elementor widget that inserts an embbedable content into the page, from any given URL.
	*
	* @since 1.0.0
	*/
class Elementor_Consua_Footer_About_Widget extends \Elementor\Widget_Base {

	/**
	* Get widget name.
	*
	* Retrieve Footer About widget name.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget name.
	*/
	public function get_name() {
		return 'consua_footer_about';
	}

	/**
	* Get widget title.
	*
	* Retrieve Footer_About Nav Tab widget title.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget title.
	*/
	public function get_title() {
		return esc_html__( 'Footer About', 'Consua-core' );
	}

	/**
	* Get widget icon.
	*
	* Retrieve Footer_About Nav Tab widget icon.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget icon.
	*/
	public function get_icon() {
		return 'eicon-code';
	}

	/**
	* Get widget categories.
	*
	* Retrieve the list of categories the Footer_About Nav Tab widget belongs to.
	*
	* @since 1.0.0
	* @access public
	*
	* @return array Widget categories.
	*/
	public function get_categories() {
		return [ 'consua_footer_elements' ];
	}
	
	// Add The Input For User
	protected function register_controls(){
		$this->start_controls_section(
			'footer_about_content_style',
			[
				'label'		=> esc_html__( 'Content Style','Consua-core' ),
				'tab'		=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'section_subtitle', [
				'label' 		=> esc_html__( 'Section Sub-Title', 'Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'section sub title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Section Sub Title', 'consua-core' ),
				'rows'   		=>'4',
				'label_block' 	=> true,
			]
		);

		$this->add_control(
			'logo',
			[
				'label'			=> esc_html__( 'Logo','Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' 	=> [
					'url' 		=> \Elementor\Utils::get_placeholder_image_src(),
				]
			]
		);

		$this->add_control(
		    'logo_dimension',
		    [
		        'label' => __('Logo Dimension', 'apsro-addon'),
		        'type' => \Elementor\Controls_Manager::IMAGE_DIMENSIONS,
		        'description' => __('Set Custom Logo Size.', 'apsro-addon'),
		        'default' => [
		            'width' => '205',
		            'height' => '60',
		        ],
		    ]
		);

		$this->add_control(
			'open_hours_title', [
				'label' 		=> esc_html__( 'Open Hours Title', 'Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'open hours title', 'consua-core' ),
				'default' 		=> esc_html__( 'Open Hours', 'consua-core' ),
				'rows'   		=>'4',
				'label_block' 	=> true,
			]
		);


		$footer_about = new \Elementor\Repeater();

		$footer_about->add_control(
			'day', [
				'label' 		=> esc_html__( 'Day', 'Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'day', 'consua-core' ),
				'default' 		=> esc_html__( 'Monday – Sunday:', 'consua-core' ),
				'rows'   		=>'2',
				'label_block' 	=> true,
			]
		);

		$footer_about->add_control(
			'time', [
				'label' 		=> esc_html__( 'Time', 'Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'time', 'consua-core' ),
				'default' 		=> esc_html__( '2pm – 2pm', 'consua-core' ),
				'rows'   		=>'2',
				'label_block' 	=> true,
			]
		);

		
		$this->add_control(
			'footer_open_hours_list',
			[
				'label' 	=> esc_html__( 'Open Hours List', 'Consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $footer_about->get_controls(),
				'prevent_empty' => false,
				'title_field' => '{{{ day }}}',
			]
		);

		
		$this->end_controls_section();

		$this->start_controls_section(
			'footer_about_style_option',
			[
				'label'			=> esc_html__( 'Footer About Style','consua-core' ),
				'tab' 			=> \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'open_hours_title_option',
			[
				'label' 		=> esc_html__( 'Open Hours Options', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::HEADING,
				'separator' 	=> 'before',
			]
		);

		$this->add_control(
			'open_hours_title_color',
			[
				'label' 		=> esc_html__( 'Title Color', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .opening-hours h5' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' 			=> 'open_hours_title_typography',
				'label' 		=> esc_html__( 'Title Typography', 'consua-core' ),
				'selector' 		=> '{{WRAPPER}} .opening-hours h5',
			]
		);

		$this->add_control(
			'section_subtitle_option',
			[
				'label' 		=> esc_html__( 'Sub-Title Options', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::HEADING,
				'separator' 	=> 'before',
			]
		);

		$this->add_control(
			'section_sub_title_color',
			[
				'label' 		=> esc_html__( 'Sub Title Color', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .about p' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' 			=> 'section_subtitle_typography',
				'label' 		=> esc_html__( 'Subtitle Typography', 'consua-core' ),
				'selector' 		=> '{{WRAPPER}} .about p',
			]
		);

		$this->add_control(
			'day_option',
			[
				'label' 		=> esc_html__( 'Day Options', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::HEADING,
				'separator' 	=> 'before',
			]
		);

		$this->add_control(
			'day_color',
			[
				'label' 		=> esc_html__( 'Day Color', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .opening-hours .working-day' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' 			=> 'day_typography',
				'label' 		=> esc_html__( 'Day Typography', 'consua-core' ),
				'selector' 		=> '{{WRAPPER}} .opening-hours .working-day',
			]
		);

		$this->add_control(
			'time_option',
			[
				'label' 		=> esc_html__( 'Time Options', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::HEADING,
				'separator' 	=> 'before',
			]
		);

		$this->add_control(
			'time_color',
			[
				'label' 		=> esc_html__( 'Time Color', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .opening-hours .working-hour' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' 			=> 'time_typography',
				'label' 		=> esc_html__( 'Time Typography', 'consua-core' ),
				'selector' 		=> '{{WRAPPER}} .opening-hours .working-hour',
			]
		);




		$this->end_controls_section();
	}

	// Output For User
	protected function render(){	
	$consua_footer_about_output = $this->get_settings_for_display();
	?>

    <!-- Start Footer_About 
    ============================================= -->
    <div class="f-item about">
    	<?php if(!empty($consua_footer_about_output['logo']['url'])):?>
        	<img class="logo" src="<?php echo esc_url($consua_footer_about_output['logo']['url']);?>" width="<?php echo esc_attr($consua_footer_about_output['logo_dimension']['width']); ?>" height="<?php echo esc_attr($consua_footer_about_output['logo_dimension']['height']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
    	<?php endif;?>
        <?php if(!empty($consua_footer_about_output['section_subtitle'])):?>
	        <p>
	            <?php echo wp_kses($consua_footer_about_output['section_subtitle'], 'consua_allowed_tags'); ?>
	        </p>
    	<?php endif;?>
        <div class="opening-hours">
        	<?php if(!empty($consua_footer_about_output['open_hours_title'])):?>
	            <h5>  
	            	<?php echo wp_kses($consua_footer_about_output['open_hours_title'], 'consua_allowed_tags'); ?>
	            </h5>
            <?php endif;?>
            <ul>
            	<?php
                	if (!empty($consua_footer_about_output['footer_open_hours_list'])) : 
                	foreach($consua_footer_about_output['footer_open_hours_list'] as $single_item):
                ?>
	                <li> 
	                    <div class="working-day"><?php echo wp_kses($single_item['day'], 'consua_allowed_tags'); ?></div>
	                    <div class="marker"></div>
	                    <div class="working-hour"><?php echo wp_kses($single_item['time'], 'consua_allowed_tags'); ?></div>
	                </li>
	            <?php
	            	endforeach;
	            	endif;
	            ?>
                
            </ul>
        </div>
    </div>
    <!-- End Footer_About 
    ============================================= -->

    <?php
    }
}